// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOSINK_H
#define _GSTREAMERMM_AUDIOSINK_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/gstaudiosink.h>
#include <gstreamermm/baseaudiosink.h>
#include <gstreamermm/ringbuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstAudioSink GstAudioSink;
typedef struct _GstAudioSinkClass GstAudioSinkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class AudioSink_Class; } // namespace Gst
namespace Gst
{

/** A simple base class for audio sinks.
 * This is the most simple base class for audio sinks that only requires
 * subclasses to implement a set of simple virtual functions:
 *
 * - open_vfunc() - Open the device.
 * - prepare_vfunc()  - Configure the device with the specified format.
 * - write_vfunc() - Write samples to the device.
 * - reset_vfunc() - Unblock writes and flush the device.
 * - get_delay_vfunc() - Get the number of samples written but not yet played
 * by the device.
 * - unprepare_vfunc() - Undo operations done by prepare.
 * - close_vfunc() - Close the device.
 *
 * All scheduling of samples and timestamps is done in this base class together
 * with Gst::BaseAudioSink using a default implementation of a
 * Gst::RingBuffer that uses threads.
 *
 * Last reviewed on 2006-09-27 (0.10.12)
 *
 * @ingroup GstBaseClasses
 */

class AudioSink : public Gst::BaseAudioSink
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AudioSink CppObjectType;
  typedef AudioSink_Class CppClassType;
  typedef GstAudioSink BaseObjectType;
  typedef GstAudioSinkClass BaseClassType;

private:  friend class AudioSink_Class;
  static CppClassType audiosink_class_;

private:
  // noncopyable
  AudioSink(const AudioSink&);
  AudioSink& operator=(const AudioSink&);

protected:
  explicit AudioSink(const Glib::ConstructParams& construct_params);
  explicit AudioSink(GstAudioSink* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AudioSink();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioSink*       gobj()       { return reinterpret_cast<GstAudioSink*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioSink* gobj() const { return reinterpret_cast<GstAudioSink*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioSink* gobj_copy();

private:


public:
  //TODO: Some boolean vfuncs cause strange incorrect functionality when their
  //callbacks return false with the last "return RType()" line.  Make sure this
  //one doesn't cause problems and implement later.
  ///** vfunc to open the device. No configuration needs to be done at this
   //* point. This function is also used to check if the device is available.
   //*/
  //_WRAP_VFUNC(bool open(), "open")

#ifdef GLIBMM_VFUNCS_ENABLED
  /** vfunc to prepare the device to operate with the specified parameters.
   */
  virtual bool prepare_vfunc(Gst::RingBufferSpec& spec);
#endif //GLIBMM_VFUNCS_ENABLED

  //TODO: Some boolean vfuncs cause strange incorrect functionality when their
  //callbacks return false with the last "return RType()" line.  Make sure this
  //one doesn't cause problems and implement later.
  ///** vfunc to undo operations done in prepare.
   //*/
  //_WRAP_VFUNC(bool unprepare(), "unprepare")

  //TODO: Some boolean vfuncs cause strange incorrect functionality when their
  //callbacks return false with the last "return RType()" line.  Make sure this
  //one doesn't cause problems and implement later.
  ///** vfunc to close the device.
   //*/
  //_WRAP_VFUNC(bool close(), "close")

 #ifdef GLIBMM_VFUNCS_ENABLED
  /** vfunc to write data to the device.
   */
  virtual guint write_vfunc(const void* data, guint length);
#endif //GLIBMM_VFUNCS_ENABLED

  /** vfunc to return how many samples are still in the device. This is used to
   * drive the synchronisation.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual guint get_delay_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  /** vfunc to return as quickly as possible from a write and flush any pending
   * samples from the device.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void reset_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioSink
   */
  Glib::RefPtr<Gst::AudioSink> wrap(GstAudioSink* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOSINK_H */

