// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PRESET_H
#define _GSTREAMERMM_PRESET_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstpreset.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstPreset GstPreset;
typedef struct _GstPresetClass GstPresetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Preset_Class; } // namespace Gst
namespace Gst
{

/** Gst::Preset - helper interface for element presets.
 * This interface offers methods to query and manipulate parameter preset sets.
 * A preset is a bunch of property settings, together with meta data and a
 * name. The name of a preset serves as key for subsequent method calls to
 * manipulate single presets. All instances of one type will share the list of
 * presets. The list is created on demand, if presets are not used, the list is
 * not created.
 *
 * The interface comes with a default implementation that serves most plugins.
 * Wrapper plugins will override most methods to implement support for the
 * native preset format of those wrapped plugins. One method that is useful to
 * be overridden is property_names_vfunc(). With that, one can control which
 * properties are saved and in which order.
 * @ingroup GstInterfaces
 */

class Preset : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Preset CppObjectType;
  typedef Preset_Class CppClassType;
  typedef GstPreset BaseObjectType;
  typedef GstPresetInterface BaseClassType;

private:
  friend class Preset_Class;
  static CppClassType preset_class_;

  // noncopyable
  Preset(const Preset&);
  Preset& operator=(const Preset&);

protected:
  Preset(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Preset(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Preset(GstPreset* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Preset();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPreset*       gobj()       { return reinterpret_cast<GstPreset*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstPreset* gobj() const { return reinterpret_cast<GstPreset*>(gobject_); }

private:


public:
 

  /** Get a copy of preset names as a <tt>0</tt> terminated string array.
   * @return List with names, ue Glib::strfreev() after usage.
   * 
   * @newin{0,10}.20.
   */
  Glib::StringArrayHandle get_preset_names() const;
  
  /** Get a the names of the GObject properties that can be used for presets.
   * @return An array of property names which should be freed with Glib::strfreev() after use.
   * 
   * @newin{0,10}.20.
   */
  Glib::StringArrayHandle get_property_names() const;
  
  /** Load the given preset.
   * @param name Preset name to load.
   * @return <tt>true</tt> for success, <tt>false</tt> if e.g. there is no preset with that @a name
   * 
   * @newin{0,10}.20.
   */
  bool load_preset(const Glib::ustring& name);
  
  /** Save the current preset under the given name. If there is already a preset by
   * this @a name it will be overwritten.
   * @param name Preset name to save.
   * @return <tt>true</tt> for success, <tt>false</tt>
   * 
   * @newin{0,10}.20.
   */
  bool save_preset(const Glib::ustring& name);
  
  /** Renames a preset. If there is already a preset by the @a new_name it will be
   * overwritten.
   * @param old_name Current preset name.
   * @param new_name New preset name.
   * @return <tt>true</tt> for success, <tt>false</tt> if e.g. there is no preset with @a old_name
   * 
   * @newin{0,10}.20.
   */
  bool rename_preset(const Glib::ustring& old_name, const Glib::ustring& new_name);
  
  /** Delete the given preset.
   * @param name Preset name to remove.
   * @return <tt>true</tt> for success, <tt>false</tt> if e.g. there is no preset with that @a name
   * 
   * @newin{0,10}.20.
   */
  bool delete_preset(const Glib::ustring& name);
  
  /** Sets a new @a value for an existing meta data item or adds a new item. Meta
   * data @a tag names can be something like e.g. "comment". Supplying <tt>0</tt> for the
   *  @a value will unset an existing value.
   * @param name Preset name.
   * @param tag Meta data item name.
   * @param value New value.
   * @return <tt>true</tt> for success, <tt>false</tt> if e.g. there is no preset with that @a name
   * 
   * @newin{0,10}.20.
   */
  bool set_meta(const Glib::ustring& name, const Glib::ustring& tag, const Glib::ustring& value);

  
  /** Gets the @a value for an existing meta data @a tag. Meta data @a tag names can be
   * something like e.g. "comment". Returned values need to be released when done.
   * @param name Preset name.
   * @param tag Meta data item name.
   * @param value Value.
   * @return <tt>true</tt> for success, <tt>false</tt> if e.g. there is no preset with that @a name
   * or no value for the given @a tag
   * 
   * @newin{0,10}.20.
   */

  bool get_meta(const Glib::ustring& name, const Glib::ustring& tag, Glib::ustring& value) const;

 
#ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::StringArrayHandle get_preset_names_vfunc() const;
  virtual Glib::StringArrayHandle get_property_names_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool load_preset_vfunc(const Glib::ustring& name);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool save_preset_vfunc(const Glib::ustring& name) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool rename_preset_vfunc(const Glib::ustring& old_name, const Glib::ustring& new_name);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool delete_preset_vfunc(const Glib::ustring& name);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_meta_vfunc(const Glib::ustring& name, const Glib::ustring& tag, const Glib::ustring& value);
#endif //GLIBMM_VFUNCS_ENABLED


#ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_meta_vfunc(const Glib::ustring& name,
    const Glib::ustring& tag, Glib::ustring& value);
#endif //GLIBMM_VFUNCS_ENABLED

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Preset
   */
  Glib::RefPtr<Gst::Preset> wrap(GstPreset* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_PRESET_H */

