// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_INDEXFACTORY_H
#define _GSTREAMERMM_INDEXFACTORY_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstelement.h>
#include <gstreamermm/pluginfeature.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstIndexFactory GstIndexFactory;
typedef struct _GstIndexFactoryClass GstIndexFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class IndexFactory_Class; } // namespace Gst
namespace Gst
{

class Index;

/** Gst::IndexFactory - Create Indexes from a factory.
 * Gst::IndexFactory is used to dynamically create Gst::Index implementations.
 */

class IndexFactory : public PluginFeature
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef IndexFactory CppObjectType;
  typedef IndexFactory_Class CppClassType;
  typedef GstIndexFactory BaseObjectType;
  typedef GstIndexFactoryClass BaseClassType;

private:  friend class IndexFactory_Class;
  static CppClassType indexfactory_class_;

private:
  // noncopyable
  IndexFactory(const IndexFactory&);
  IndexFactory& operator=(const IndexFactory&);

protected:
  explicit IndexFactory(const Glib::ConstructParams& construct_params);
  explicit IndexFactory(GstIndexFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~IndexFactory();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstIndexFactory*       gobj()       { return reinterpret_cast<GstIndexFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstIndexFactory* gobj() const { return reinterpret_cast<GstIndexFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstIndexFactory* gobj_copy();

private:


protected:
  explicit IndexFactory(const Glib::ustring& name, const Glib::ustring& longdesc, GType type);

public:
  /** Create a new index factory with the given parameters
   *
   * @param name Name of the index factory to create.
   * @param longdesc Long description of the index factory to create.
   * @param type The GType of the Gst::Index element of this factory.
   * @return A new Gst::IndexFactory.
   */
  
  static Glib::RefPtr<IndexFactory> create(const Glib::ustring& name, const Glib::ustring& longdesc, GType type);


  /** Search for an indexfactory of the given name.
   * @param name Name of indexfactory to find.
   * @return Gst::IndexFactory if found, <tt>0</tt> otherwise.
   */
  static Glib::RefPtr<Gst::IndexFactory> find(const Glib::ustring& name);
  
  /** Create a new Gst::Index instance from the
   * given indexfactory.
   * @return A new Gst::Index instance.
   */
  Glib::RefPtr<Gst::Index> create_index();
  
  /** Create a new Gst::Index instance from the
   * indexfactory with the given name.
   * @param name The name of the factory used to create the instance.
   * @return A new Gst::Index instance.
   */
  static Glib::RefPtr<Gst::Index> create_index(const Glib::ustring& factory_name);

  //Destruction occurs when last reference is lost.
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::IndexFactory
   */
  Glib::RefPtr<Gst::IndexFactory> wrap(GstIndexFactory* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_INDEXFACTORY_H */

