// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/segment.h>
#include <gstreamermm/private/segment_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstsegment.h>

namespace Gst
{

void Segment::set_seek(double rate, Format format, SeekFlags flags,
  SeekType start_type, gint64 start, SeekType stop_type, gint64 stop,
  bool& update)
{
  gboolean gst_update = 0;

  gst_segment_set_seek(gobj(), rate, ((GstFormat)(format)),
    ((GstSeekFlags)(flags)), ((GstSeekType)(start_type)), start,
    ((GstSeekType)(stop_type)), stop, &gst_update); 

  update = gst_update;
}

} // namespace Gst

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::Segment wrap(GstSegment* object, bool take_copy)
{
  return Gst::Segment(object, take_copy);
}

} // namespace Glib


namespace Gst
{


// static
GType Segment::get_type()
{
  return gst_segment_get_type();
}

Segment::Segment()
:
  gobject_ (gst_segment_new())
{}

Segment::Segment(const Segment& other)
:
  gobject_ ((other.gobject_) ? gst_segment_copy(other.gobject_) : 0)
{}

Segment::Segment(GstSegment* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gst_segment_copy(gobject) : gobject)
{}

Segment& Segment::operator=(const Segment& other)
{
  Segment temp (other);
  swap(temp);
  return *this;
}

Segment::~Segment()
{
  if(gobject_)
    gst_segment_free(gobject_);
}

void Segment::swap(Segment& other)
{
  GstSegment *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GstSegment* Segment::gobj_copy() const
{
  return gst_segment_copy(gobject_);
}


bool Segment::clip(Format format, gint64 start, gint64 stop, gint64& clip_start, gint64& clip_stop) const
{
  return gst_segment_clip(const_cast<GstSegment*>(gobj()), ((GstFormat)(format)), start, stop, &clip_start, &clip_stop);
}

void Segment::init(Format format)
{
gst_segment_init(gobj(), ((GstFormat)(format))); 
}

void Segment::set_duration(Format format, gint64 duration)
{
gst_segment_set_duration(gobj(), ((GstFormat)(format)), duration); 
}

void Segment::set_last_stop(Format format, gint64 position)
{
gst_segment_set_last_stop(gobj(), ((GstFormat)(format)), position); 
}

void Segment::set_newsegment(bool update, double rate, Format format, gint64 start, gint64 stop, gint64 time)
{
gst_segment_set_newsegment(gobj(), static_cast<int>(update), rate, ((GstFormat)(format)), start, stop, time); 
}

void Segment::set_newsegment(bool update, double rate, double applied_rate, Format format, gint64 start, gint64 stop, gint64 time)
{
gst_segment_set_newsegment_full(gobj(), static_cast<int>(update), rate, applied_rate, ((GstFormat)(format)), start, stop, time); 
}

gint64 Segment::to_running_time(Format format, gint64 position) const
{
  return gst_segment_to_running_time(const_cast<GstSegment*>(gobj()), ((GstFormat)(format)), position);
}

gint64 Segment::to_stream_time(Format format, gint64 position) const
{
  return gst_segment_to_stream_time(const_cast<GstSegment*>(gobj()), ((GstFormat)(format)), position);
}

gint64 Segment::to_position(Format format, gint64 running_time) const
{
  return gst_segment_to_position(const_cast<GstSegment*>(gobj()), ((GstFormat)(format)), running_time);
}

bool Segment::set_running_time(Format format, gint64 running_time)
{
  return gst_segment_set_running_time(gobj(), ((GstFormat)(format)), running_time);
}


} // namespace Gst


