// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/message.h>
#include <gstreamermm/private/message_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gst/interfaces/mixer.h>
#include <gstreamermm/mixer.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/taglist.h>


namespace Gst
{

namespace Enums
{

Glib::ustring get_name(MessageType t)
{
  return gst_message_type_get_name(GstMessageType(t));
}

Glib::QueryQuark get_quark(MessageType t)
{
  return Glib::QueryQuark(gst_message_type_to_quark(GstMessageType(t)));
}

} //namespace Enums

Glib::RefPtr<Gst::Message> Message::copy() const
{
  return Gst::wrap(gst_message_copy(gobj()));
}

Glib::RefPtr<Gst::Message> Message::create_writable()
{
  return Gst::wrap(gst_message_make_writable(gobj()));
}

MessageEos::MessageEos(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageEos::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_eos(src->gobj());
  return Gst::Message::wrap(message, false);
}

MessageError::MessageError(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageError::create(const Glib::RefPtr<Gst::Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_error(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}

void MessageError::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_error(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageError::parse() const
{
  GError* c_error = 0;
  gst_message_parse_error(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageError::parse_debug() const
{
  gchar* c_debug = 0;
  gst_message_parse_error(const_cast<GstMessage*>(gobj()), 0, &c_debug);

  std::string result = c_debug;
  if(c_debug)
    g_free(c_debug);

  return result;
}

MessageWarning::MessageWarning(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageWarning::create(const Glib::RefPtr<Gst::Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_warning(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}

void MessageWarning::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageWarning::parse() const
{
  GError* c_error = 0;
  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageWarning::parse_debug() const
{
  gchar* c_debug = 0;
  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), 0, &c_debug);

  std::string result = c_debug;
  if(c_debug)
    g_free(c_debug);

  return result;
}

MessageInfo::MessageInfo(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageInfo::create(const Glib::RefPtr<Gst::Object>& src, Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_info(src->gobj(), error.gobj(),(gchar*)(debug.c_str()));
  return Gst::Message::wrap(message, false);
}


void MessageInfo::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_info(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageInfo::parse() const
{
  GError* c_error = 0;
  gst_message_parse_info(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageInfo::parse_debug() const
{
  gchar* c_debug = 0;
  gst_message_parse_info(const_cast<GstMessage*>(gobj()), 0, &c_debug);

  std::string result = c_debug;
  if(c_debug)
    g_free(c_debug);

  return result;
}

MessageTag::MessageTag(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageTag::create(const Glib::RefPtr<Gst::Object>& src, const Gst::TagList& taglist)
{
  //We create a copy because gst_message_new_tag() takes ownership:
  GstTagList* c_taglist = gst_tag_list_copy(taglist.gobj());
  GstMessage* message = gst_message_new_tag(src->gobj(), c_taglist);
  return Gst::Message::wrap(message, false);
}

Gst::TagList MessageTag::parse() const
{
  GstTagList* gst_tag_list = gst_tag_list_new();
  gst_message_parse_tag(const_cast<GstMessage*>(gobj()), &gst_tag_list);
  return Gst::TagList(gst_tag_list);
}

MessageBuffering::MessageBuffering(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageBuffering::create(const Glib::RefPtr<Gst::Object>& src, int percent)
{
  GstMessage* message = gst_message_new_buffering(src->gobj(), percent);
  return Gst::Message::wrap(message, false);
}

int MessageBuffering::parse() const
{
  int percent = 0;
  gst_message_parse_buffering(const_cast<GstMessage*>(gobj()), &percent);
  return percent;
}

void MessageBuffering::set_stats(BufferingMode mode, int avg_in, int avg_out,
gint64 buffering_left)
{
  gst_message_set_buffering_stats(gobj(), (GstBufferingMode) mode, avg_in,
    avg_out, buffering_left);
}

void MessageBuffering::parse_stats(BufferingMode& mode, int& avg_in,
int& avg_out, gint64& buffering_left) const
{
  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()),
    (GstBufferingMode*)(&mode), &avg_in, &avg_out, &buffering_left);
}

BufferingMode MessageBuffering::parse_stats_buffering_mode() const
{
  GstBufferingMode mode = GST_BUFFERING_STREAM;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), &mode,
    0, 0, 0);
  return (BufferingMode)(mode);
}

int MessageBuffering::parse_stats_avg_in() const
{
  int avg_in = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    &avg_in, 0, 0);
  return avg_in;
}

int MessageBuffering::parse_stats_avg_out() const
{
  int avg_out = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    0, &avg_out, 0);
  return avg_out;
}

gint64 MessageBuffering::parse_stats_buffering_left() const
{
  gint64 buffering_left = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    0, 0, &buffering_left);
  return buffering_left;
}

MessageStateChanged::MessageStateChanged(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageStateChanged::create(const Glib::RefPtr<Gst::Object>& src, State oldstate, State newstate, State pending)
{
  GstMessage* message = gst_message_new_state_changed(src->gobj(), GstState(oldstate), GstState(newstate), GstState(pending));
  return Gst::Message::wrap(message, false);
}

void MessageStateChanged::parse(State& oldstate, State& newstate,
State& pending) const
{
  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()),
    (GstState*)(&oldstate), (GstState*)(&newstate), (GstState*)(&pending));
}

State MessageStateChanged::parse() const
{
  GstState new_state = GST_STATE_NULL;

  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), 0,
    &new_state, 0);
  return State(new_state);
}

State MessageStateChanged::parse_old() const
{
  GstState old_state = GST_STATE_NULL;

  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), &old_state,
    0, 0);
  return State(old_state);
}

State MessageStateChanged::parse_pending() const
{
  GstState pending_state = GST_STATE_NULL;
  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), 0,
    0, &pending_state);
  return State(pending_state);
}

MessageStateDirty::MessageStateDirty(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageStateDirty::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_state_dirty(src->gobj());
  return Gst::Message::wrap(message, false);
}

MessageClockProvide::MessageClockProvide(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageClockProvide::create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock, bool ready)
{
  GstMessage* message = gst_message_new_clock_provide(src->gobj(), clock->gobj(), ready);
  return Gst::Message::wrap(message, false);
}

void MessageClockProvide::parse(Glib::RefPtr<Gst::Clock>& clock, bool& ready) const
{
  GstClock* cclock = 0;
  gboolean ready_ = false;
  gst_message_parse_clock_provide(const_cast<GstMessage*>(gobj()), &cclock,
    &ready_);
  clock = Glib::wrap(cclock);
  ready = ready_;
}

Glib::RefPtr<Gst::Clock> MessageClockProvide::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_clock_provide(gobj(), &cclock, 0);
  return Glib::wrap(cclock);
}

Glib::RefPtr<const Gst::Clock> MessageClockProvide::parse() const
{
  return parse();
}

bool MessageClockProvide::parse_ready() const
{
  gboolean ready = FALSE;
  gst_message_parse_clock_provide(const_cast<GstMessage*>(gobj()), 0,
    &ready);
  return ready;
}

MessageClockLost::MessageClockLost(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageClockLost::create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock)
{
  GstMessage* message = gst_message_new_clock_lost(src->gobj(), clock->gobj());
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Clock> MessageClockLost::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_clock_lost(gobj(), &cclock);
  return Glib::wrap(cclock, false);
}

Glib::RefPtr<const Gst::Clock> MessageClockLost::parse() const
{
  return parse();
}

MessageNewClock::MessageNewClock(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageNewClock::create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock)
{
  GstMessage* message = gst_message_new_new_clock(src->gobj(), clock->gobj());
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Clock> MessageNewClock::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_new_clock(gobj(), &cclock);
  return Glib::wrap(cclock, false);
}

Glib::RefPtr<const Gst::Clock> MessageNewClock::parse() const
{
  return parse();
}

MessageApplication::MessageApplication(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageApplication::create(const Glib::RefPtr<Gst::Object>& src, Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_application(src->gobj(), copy_struct);
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Message> MessageApplication::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_application(src->gobj(), 0);
  return Gst::Message::wrap(message, false);
}

MessageElement::MessageElement(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageElement::create(const Glib::RefPtr<Gst::Object>& src, Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_element(src->gobj(), copy_struct);
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Message> MessageElement::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_element(src->gobj(), 0);
  return Gst::Message::wrap(message, false);
}

MessageCustom::MessageCustom(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageCustom::create(MessageType type, const Glib::RefPtr<Gst::Object>& src, Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_custom(GstMessageType(type),
    src->gobj(), copy_struct);
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Message> MessageCustom::create(MessageType type, const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_custom(GstMessageType(type),
    src->gobj(), 0);
  return Gst::Message::wrap(message, false);
}

MessageSegmentStart::MessageSegmentStart(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageSegmentStart::create(const Glib::RefPtr<Gst::Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_start(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}

void MessageSegmentStart::parse(Format& format, gint64& position) const
{
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), &position);
}

gint64 MessageSegmentStart::parse() const
{
  gint64 position = 0;
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()), 0,
    &position);
  return position;
}

Format MessageSegmentStart::parse_format() const
{
  Format format = Gst::FORMAT_DEFAULT;
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), 0);
  return format;
}

MessageSegmentDone::MessageSegmentDone(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageSegmentDone::create(const Glib::RefPtr<Gst::Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_done(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}

void MessageSegmentDone::parse(Format& format, gint64& position) const
{
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), &position);
}

gint64 MessageSegmentDone::parse() const
{
  gint64 position = 0;
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()), 0,
    &position);
  return position;
}

Format MessageSegmentDone::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), 0);
  return format;
}

MessageDuration::MessageDuration(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageDuration::create(const Glib::RefPtr<Gst::Object>& src, Format format, gint64 position)
{
  GstMessage* message = gst_message_new_duration(src->gobj(), GstFormat(format), position);
  return Gst::Message::wrap(message, false);
}

void MessageDuration::parse(Format& format, gint64& position) const
{
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), &position);
}

gint64 MessageDuration::parse() const
{
  gint64 position = 0;
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()), 0, &position);
  return position;
}

Format MessageDuration::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()),
    (GstFormat*)(&format), 0);
  return format;
}

MessageLatency::MessageLatency(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageLatency::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_latency(src->gobj());
  return Gst::Message::wrap(message, false);
}

MessageAsyncStart::MessageAsyncStart(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageAsyncStart::create(const Glib::RefPtr<Gst::Object>& src, bool new_base_time)
{
  GstMessage* message = gst_message_new_async_start(src->gobj(), new_base_time);
  return Gst::Message::wrap(message, false);
}

bool MessageAsyncStart::parse() const
{
  gboolean new_base_time = FALSE;
  gst_message_parse_async_start(const_cast<GstMessage*>(gobj()),
    &new_base_time);
  return new_base_time;
}

MessageAsyncDone::MessageAsyncDone(GstMessage* castitem)
: Message(castitem)
{}

Glib::RefPtr<Gst::Message> MessageAsyncDone::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_async_done(src->gobj());
  return Gst::Message::wrap(message, false);
}

Glib::RefPtr<Gst::Message> Message::wrap(GstMessage* message, bool take_copy)
{
  Glib::RefPtr<Gst::Message> result;

  if(!message)
    return result;

  if(gst_mixer_message_get_type(message) == GST_MIXER_MESSAGE_INVALID)
  {
    switch(GST_MESSAGE_TYPE(message))
    {
      case GST_MESSAGE_EOS:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageEos(message) );
        break;
      case GST_MESSAGE_ERROR:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageError(message) );
        break;
      case GST_MESSAGE_WARNING:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageWarning(message) );
        break;
      case GST_MESSAGE_INFO:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageInfo(message) );
        break;
      case GST_MESSAGE_TAG:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageTag(message) );
        break;
      case GST_MESSAGE_BUFFERING:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageBuffering(message) );
        break;
      case GST_MESSAGE_STATE_CHANGED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageStateChanged(message) );
        break;
      case GST_MESSAGE_STATE_DIRTY:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageStateDirty(message) );
        break;
      case GST_MESSAGE_CLOCK_PROVIDE:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageClockProvide(message) );
        break;
      case GST_MESSAGE_CLOCK_LOST:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageClockLost(message) );
        break;
      case GST_MESSAGE_NEW_CLOCK:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageNewClock(message) );
        break;
      case GST_MESSAGE_APPLICATION:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageApplication(message) );
        break;
      case GST_MESSAGE_ELEMENT:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageElement(message) );
        break;
      case GST_MESSAGE_SEGMENT_START:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageSegmentStart(message) );
        break;
      case GST_MESSAGE_SEGMENT_DONE:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageSegmentDone(message) );
        break;
      case GST_MESSAGE_DURATION:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageDuration(message) );
        break;
      case GST_MESSAGE_LATENCY:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageLatency(message) );
        break;
      case GST_MESSAGE_ASYNC_START:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageAsyncStart(message) );
        break;
      case GST_MESSAGE_ASYNC_DONE:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageAsyncDone(message) );
        break;
      case GST_MESSAGE_UNKNOWN:
      case GST_MESSAGE_ANY:
        result = Gst::wrap(message, false);
        break;
        /* The rest of the message types are custom ones */
      default:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageCustom(message) );
    }
  }
  else
  {
    switch(GST_MESSAGE_TYPE(message))
    {
      case GST_MIXER_MESSAGE_MUTE_TOGGLED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerMuteToggled(message) );
        break;
      case GST_MIXER_MESSAGE_RECORD_TOGGLED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerRecordToggled(message) );
        break;
      case GST_MIXER_MESSAGE_VOLUME_CHANGED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerVolumeChanged(message) );
        break;
      case GST_MIXER_MESSAGE_OPTION_CHANGED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerOptionChanged(message) );
        break;
      case GST_MIXER_MESSAGE_OPTIONS_LIST_CHANGED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerOptionsListChanged(message) );
        break;
      case GST_MIXER_MESSAGE_MIXER_CHANGED:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageMixerChanged(message) );
        break;
      default:
        result = Glib::RefPtr<Gst::Message>( new Gst::MessageCustom(message) );
    }
  }

  if(result && take_copy)
    result->reference();

  return result;
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MessageType>::value_type()
{
  return gst_message_type_get_type();
}


namespace Gst
{

Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Message>( dynamic_cast<Gst::Message*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Message_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Message_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_message_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Message_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Message_Class::wrap_new(GstMiniObject* object)
{
  return new Message((GstMessage*)object);
}


/* The implementation: */

GstMessage* Message::gobj_copy()
{
  reference();
  return gobj();
}


Message::Message(GstMessage* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Message::~Message()
{}


Message::CppClassType Message::message_class_; // initialize static member

GType Message::get_type()
{
  return message_class_.init().get_type();
}

GType Message::get_base_type()
{
  return gst_message_get_type();
}


const Gst::Structure Message::get_structure() const
{
  return Glib::wrap(const_cast<GstStructure*>(gst_message_get_structure(const_cast<GstMessage*>(gobj()))), true);
}

guint32 Message::get_seqnum() const
{
  return gst_message_get_seqnum(const_cast<GstMessage*>(gobj()));
}

void Message::set_seqnum(guint32 seqnum)
{
gst_message_set_seqnum(gobj(), seqnum); 
}

 MessageType Message::get_message_type() const
{
  return ((MessageType)(gobj()->type));
}
 
 ClockTime Message::get_timestamp() const
{
  return (ClockTime)(gobj()->timestamp);
}
 
 Glib::RefPtr<Gst::Object> Message::get_source()
{
  Glib::RefPtr<Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Object> Message::get_source() const
{
  Glib::RefPtr<const Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


