// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/caps.h>
#include <gstreamermm/private/caps_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstcaps.h>
#include <gstreamermm/structure.h>

namespace Gst
{

GType Caps::get_type()
{
  return gst_caps_get_type();
}

Glib::RefPtr<Gst::Caps> Caps::create_any()
{
  return Glib::wrap(gst_caps_new_any());
}

/*
  This method is implemented because gst_caps_new_simple is a variable argument
  function and cannot be wrapped.  In addition, because gst_caps_new_simple
  creates a GstStructure for the GstCaps and will not be called, we must create
  our own GstStructure here and append it to the GstCaps.
*/
Glib::RefPtr<Gst::Caps> Caps::create_simple(const Glib::ustring& media_type)
{
  Glib::RefPtr<Gst::Caps> result = Glib::wrap(gst_caps_new_empty());
  GstStructure* gst_struct = gst_structure_empty_new(media_type.c_str());
  gst_caps_append_structure(Glib::unwrap(result), gst_struct);
  return result;
}

Glib::RefPtr<Gst::Caps> Caps::create(const Structure& structure)
{
  //We take a copy because gst_caps_append_structure() wants to take ownership:
  GstStructure* copy = gst_structure_copy(structure.gobj());
  return Glib::wrap(gst_caps_new_full(copy, 0));
}

void Caps::append_structure(const Structure& structure)
{
  //We take a copy because gst_caps_append_structure() wants to take ownership:
  GstStructure* copy = gst_structure_copy(structure.gobj());
  gst_caps_append_structure(gobj(), copy);
}

void Caps::merge_structure(Structure& structure)
{
  //We take a copy because gst_caps_append_structure() wants to take ownership:
  GstStructure* copy = gst_structure_copy(structure.gobj());
  gst_caps_merge_structure(gobj(), copy);
}

//TODO: Want to return RefPtr to Caps but using RefPtr in expressions such
// as 'caps->set_simple(name1, value1)->set_simple(name2, value2)' a
// causes gstreamer Structure immutability warnings because the Caps is
// referenced more than once in the expression (see bug #510301).
/*
  This method is implemented in place of gst_caps_set_simple which is a
  variable argument function and cannot be wrapped.  We don't call
  gst_caps_set_simple() directly because we are using a Glib::ValueBase as the
  value to be set instead of listing out each field in the value as would be
  done with gst_caps_set_simple()
*/
//Glib::RefPtr<Gst::Caps>
void
Caps::set_simple(const Glib::ustring& name, const Glib::ValueBase& value)
{
  g_return_if_fail((this->gobj()->structs->len == 1)); // Not simple
  g_return_if_fail (g_atomic_int_get(&(this->gobj())->refcount) == 1); // IS_WRITABLE(caps) fails

  //The result of gst_caps_get_structure() should not be modified, according to
  //its documentation, but we are reimplementing gst_caps_set_simple() which
  //does that:
  GstStructure* structure = gst_caps_get_structure(gobj(), 0);
  if(structure)
    gst_structure_set_value(structure, name.c_str(), value.gobj());

  //return Glib::wrap(gobj(), true);
}

void
Caps::set_simple(const Glib::ustring& name, const char* data)
{
  set_simple(name, std::string(data));
}

xmlpp::Node* Caps::save(xmlpp::Node* parent) const
{
  gst_caps_save_thyself(gobj(), parent->cobj());

  // gst_caps_save_thyself() returns the parent node so return parent here also:
  return parent;
}

} //namespace Gst

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<Caps*>(gobject) is needed:
 *
 * A Caps instance is in fact always a GstCaps instance.
 * Unfortunately, GstCaps cannot be a member of Caps,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Caps does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::Caps> wrap(GstCaps* object, bool take_copy)
{
  if(take_copy && object)
    gst_caps_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Caps>(reinterpret_cast<Gst::Caps*>(object));
}

} // namespace Glib


namespace Gst
{


// static
Glib::RefPtr<Caps> Caps::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Caps>(reinterpret_cast<Caps*>(gst_caps_new_empty()));
}

void Caps::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_caps_ref(reinterpret_cast<GstCaps*>(const_cast<Caps*>(this)));
}

void Caps::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_caps_unref(reinterpret_cast<GstCaps*>(const_cast<Caps*>(this)));
}

GstCaps* Caps::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstCaps*>(this);
}

const GstCaps* Caps::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstCaps*>(this);
}

GstCaps* Caps::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstCaps *const gobject = reinterpret_cast<GstCaps*>(const_cast<Caps*>(this));
  gst_caps_ref(gobject);
  return gobject;
}


Glib::RefPtr<Gst::Caps> Caps::create_from_string(const Glib::ustring& string)
{
  return Glib::wrap(gst_caps_from_string(string.c_str()));
}


Glib::RefPtr<Gst::Caps> Caps::copy() const
{
  return Glib::wrap(gst_caps_copy(const_cast<GstCaps*>(gobj())));
}

Glib::RefPtr<Gst::Caps> Caps::copy_nth(guint nth) const
{
  return Glib::wrap(gst_caps_copy_nth(const_cast<GstCaps*>(gobj()), nth));
}

void Caps::append(const Glib::RefPtr<Gst::Caps>& caps)
{
  gst_caps_append(gobj(), Glib::unwrap(caps)); 
}

void Caps::merge(const Glib::RefPtr<Gst::Caps>& caps)
{
  gst_caps_merge(gobj(), Glib::unwrap(caps)); 
}

const Structure Caps::get_structure(guint idx) const
{
  return Glib::wrap(gst_caps_get_structure(const_cast<GstCaps*>(gobj()), idx), true);
}

void Caps::remove_structure(guint idx)
{
  gst_caps_remove_structure(gobj(), idx); 
}

guint Caps::size() const
{
  return gst_caps_get_size(const_cast<GstCaps*>(gobj()));
}

Structure Caps::steal_structure(guint index)
{
  return Glib::wrap(gst_caps_steal_structure(gobj(), index));
}

void Caps::set_value(const Glib::ustring& field, const Glib::ValueBase& value)
{
  gst_caps_set_value(gobj(), field.c_str(), (value).gobj()); 
}

bool Caps::is_any() const
{
  return gst_caps_is_any(const_cast<GstCaps*>(gobj()));
}

bool Caps::empty() const
{
  return gst_caps_is_empty(const_cast<GstCaps*>(gobj()));
}

bool Caps::is_fixed() const
{
  return gst_caps_is_fixed(const_cast<GstCaps*>(gobj()));
}

bool Caps::equals(const Glib::RefPtr<const Gst::Caps>& other_caps) const
{
  return gst_caps_is_equal(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::equals_fixed(const Glib::RefPtr<const Gst::Caps>& other_caps) const
{
  return gst_caps_is_equal_fixed(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::is_always_compatible(const Glib::RefPtr<const Gst::Caps>& other_caps) const
{
  return gst_caps_is_always_compatible(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps));
}

bool Caps::is_subset(const Glib::RefPtr<const Gst::Caps>& superset_caps) const
{
  return gst_caps_is_subset(const_cast<GstCaps*>(gobj()), Glib::unwrap(superset_caps));
}

bool Caps::can_intersect(const Glib::RefPtr<const Gst::Caps>& caps2) const
{
  return gst_caps_can_intersect(const_cast<GstCaps*>(gobj()), Glib::unwrap(caps2));
}

Glib::RefPtr<Gst::Caps> Caps::get_intersect(const Glib::RefPtr<const Gst::Caps>& other_caps) const
{
  return Glib::wrap(gst_caps_intersect(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps)));
}

Glib::RefPtr<Gst::Caps> Caps::get_intersect(const Glib::RefPtr<const Gst::Caps>& other_caps, CapsIntersectMode p2) const
{
  return Glib::wrap(gst_caps_intersect_full(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps), ((GstCapsIntersectMode)(p2))));
}

Glib::RefPtr<Gst::Caps> Caps::get_union(const Glib::RefPtr<const Gst::Caps>& other_caps) const
{
  return Glib::wrap(gst_caps_union(const_cast<GstCaps*>(gobj()), Glib::unwrap(other_caps)));
}

Glib::RefPtr<Gst::Caps> Caps::get_normal() const
{
  return Glib::wrap(gst_caps_normalize(const_cast<GstCaps*>(gobj())));
}

bool Caps::simplify()
{
  return gst_caps_do_simplify(gobj());
}

Glib::RefPtr<Gst::Caps> Caps::load(xmlpp::Node* parent)
{
  return Glib::wrap(gst_caps_load_thyself(parent->cobj()));
}


Glib::ustring Caps::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_caps_to_string(const_cast<GstCaps*>(gobj())));
}

Glib::RefPtr<Gst::Caps> Caps::get_difference(const Glib::RefPtr<const Gst::Caps>& subtrahend_caps) const
{
  return Glib::wrap(gst_caps_subtract(const_cast<GstCaps*>(gobj()), Glib::unwrap(subtrahend_caps)));
}

Glib::RefPtr<Gst::Caps> Caps::create_writable()
{
  return Glib::wrap(gst_caps_make_writable(gobj()));
}

void Caps::truncate()
{
  gst_caps_truncate(gobj()); 
}


} // namespace Gst


