// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/element.h>
#include <gstreamermm/private/element_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdexcept>
#include <gst/gstenumtypes.h>
#include <gst/gstinterface.h>
#include <gst/gstutils.h>
#include <gstreamermm/bus.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/elementfactory.h>
#include <gstreamermm/event.h>
#include <gstreamermm/index.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/padtemplate.h>
#include <gstreamermm/query.h>
#include <gstreamermm/taglist.h>
#include <gstreamermm/iterator.h>


namespace Gst
{

void ElementInterfaced_WeakNotify_gstreamermm_callback(void* data, GObject* where_the_object_was)
{
  delete (Gst::Element*) data;
}

namespace Enums
{

Glib::ustring get_name(State s)
{
  return gst_element_state_get_name(GstState(s));
}

Glib::ustring get_name(StateChangeReturn s)
{
  return gst_element_state_change_return_get_name(GstStateChangeReturn(s));
}

} //namespace Enums

Glib::RefPtr<Gst::Element> Element::link(const Glib::RefPtr<Gst::Element>& dest)
{
  const bool result = gst_element_link(gobj(), dest->gobj());

  if(result)
    return dest;
  else
    throw std::runtime_error("failed to link: " + get_name() + "->" + dest->get_name());
}

bool Element::query_position(Format& format) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), reinterpret_cast<GstFormat*>(&format), NULL);
}

bool Element::query_duration(Format& format) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), reinterpret_cast<GstFormat*>(&format), NULL);
}

// This method is written manually because an extra ref is necessary. See
// gst_element_send_event() docs
bool Element::send_event(const Glib::RefPtr<Gst::Event>& event)
{
  event->reference();
  return gst_element_send_event(gobj(), event->gobj());
}

} //namespace Gst

namespace
{


static const Glib::SignalProxyInfo Element_signal_no_more_pads_info =
{
  "no-more-pads",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Element_signal_pad_added_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Gst::Pad>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_added_info =
{
  "pad-added",
  (GCallback) &Element_signal_pad_added_callback,
  (GCallback) &Element_signal_pad_added_callback
};


static void Element_signal_pad_removed_callback(GstElement* self, GstPad* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Gst::Pad>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Element_signal_pad_removed_info =
{
  "pad-removed",
  (GCallback) &Element_signal_pad_removed_callback,
  (GCallback) &Element_signal_pad_removed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gst::ElementFlags>::value_type()
{
  return gst_element_flags_get_type();
}

// static
GType Glib::Value<Gst::StateChangeReturn>::value_type()
{
  return gst_state_change_return_get_type();
}


namespace Glib
{

Glib::RefPtr<Gst::Element> wrap(GstElement* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Element>( dynamic_cast<Gst::Element*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Element_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Element_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_element_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Element_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->request_new_pad = &request_new_pad_vfunc_callback;
  klass->release_pad = &release_pad_vfunc_callback;
  klass->get_state = &get_state_vfunc_callback;
  klass->set_state = &set_state_vfunc_callback;
  klass->change_state = &change_state_vfunc_callback;
  klass->set_bus = &set_bus_vfunc_callback;
  klass->provide_clock = &provide_clock_vfunc_callback;
  klass->get_index = &get_index_vfunc_callback;
  klass->set_index = &set_index_vfunc_callback;
  klass->send_event = &send_event_vfunc_callback;
  klass->query = &query_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->no_more_pads = &no_more_pads_callback;
  klass->pad_added = &pad_added_callback;
  klass->pad_removed = &pad_removed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
GstPad* Element_Class::request_new_pad_vfunc_callback(GstElement* self, GstPadTemplate* templ, const gchar* name)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->request_new_pad_vfunc(Glib::wrap((templ), true)
, Glib::convert_const_gchar_ptr_to_ustring(name)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->request_new_pad)
    return (*base->request_new_pad)(self, templ, name);


  typedef GstPad* RType;
  return RType();
}
void Element_Class::release_pad_vfunc_callback(GstElement* self, GstPad* pad)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->release_pad_vfunc(Glib::wrap(pad, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->release_pad)
    (*base->release_pad)(self, pad);

}
GstStateChangeReturn Element_Class::get_state_vfunc_callback(GstElement* self, GstState* state, GstState* pending, GstClockTime timeout)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->get_state_vfunc((State&)(state)
, (State&)(pending)
, ((ClockTime)(timeout))
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_state)
    return (*base->get_state)(self, state, pending, timeout);


  typedef GstStateChangeReturn RType;
  return RType();
}
GstStateChangeReturn Element_Class::set_state_vfunc_callback(GstElement* self, GstState state)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->set_state_vfunc(((State)(state))
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_state)
    return (*base->set_state)(self, state);


  typedef GstStateChangeReturn RType;
  return RType();
}
GstStateChangeReturn Element_Class::change_state_vfunc_callback(GstElement* self, GstStateChange transition)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return ((GstStateChangeReturn)(obj->change_state_vfunc(((StateChange)(transition))
)));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->change_state)
    return (*base->change_state)(self, transition);


  typedef GstStateChangeReturn RType;
  return RType();
}
void Element_Class::set_bus_vfunc_callback(GstElement* self, GstBus* bus)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_bus_vfunc(Glib::wrap(bus, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_bus)
    (*base->set_bus)(self, bus);

}
GstClock* Element_Class::provide_clock_vfunc_callback(GstElement* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->provide_clock_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->provide_clock)
    return (*base->provide_clock)(self);


  typedef GstClock* RType;
  return RType();
}
GstIndex* Element_Class::get_index_vfunc_callback(GstElement* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_index_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_index)
    return (*base->get_index)(self);


  typedef GstIndex* RType;
  return RType();
}
void Element_Class::set_index_vfunc_callback(GstElement* self, GstIndex* index)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_index_vfunc(Glib::wrap(index, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_index)
    (*base->set_index)(self, index);

}
gboolean Element_Class::send_event_vfunc_callback(GstElement* self, GstEvent* event)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->send_event_vfunc(Gst::wrap(event, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->send_event)
    return (*base->send_event)(self, event);


  typedef gboolean RType;
  return RType();
}
gboolean Element_Class::query_vfunc_callback(GstElement* self, GstQuery* query)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->query_vfunc(Gst::wrap(query, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->query)
    return (*base->query)(self, query);


  typedef gboolean RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Element_Class::no_more_pads_callback(GstElement* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_no_more_pads();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->no_more_pads)
    (*base->no_more_pads)(self);
}
void Element_Class::pad_added_callback(GstElement* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_added(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_added)
    (*base->pad_added)(self, p0);
}
void Element_Class::pad_removed_callback(GstElement* self, GstPad* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_pad_removed(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->pad_removed)
    (*base->pad_removed)(self, p0);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Element_Class::wrap_new(GObject* object)
{
  return new Element((GstElement*)object);
}


/* The implementation: */

GstElement* Element::gobj_copy()
{
  reference();
  return gobj();
}

Element::Element(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

Element::Element(GstElement* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}

Element::~Element()
{}


Element::CppClassType Element::element_class_; // initialize static member

GType Element::get_type()
{
  return element_class_.init().get_type();
}

GType Element::get_base_type()
{
  return gst_element_get_type();
}


Element::Element()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gst::Object(Glib::ConstructParams(element_class_.init()))
{
  

}

bool Element::add_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
  return gst_element_add_pad(gobj(), Glib::unwrap(pad));
}

void Element::create_all_pads()
{
gst_element_create_all_pads(gobj()); 
}

Glib::RefPtr<Gst::Pad> Element::create_compatible_pad(const Glib::RefPtr<const Gst::Pad>& pad, const Glib::RefPtr<const Gst::Caps>& caps)
{
  return Glib::wrap(gst_element_get_compatible_pad(gobj(), const_cast<GstPad*>((pad)->gobj()), Glib::unwrap(caps)));
}

Glib::RefPtr<Gst::PadTemplate> Element::get_compatible_pad_template(const Glib::RefPtr<const Gst::PadTemplate>& padtemplate)
{

  Glib::RefPtr<Gst::PadTemplate> retvalue = Glib::wrap(gst_element_get_compatible_pad_template(gobj(), const_cast<GstPadTemplate*>((padtemplate)->gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gst::PadTemplate> Element::get_compatible_pad_template(const Glib::RefPtr<const Gst::PadTemplate>& padtemplate) const
{
  return const_cast<Element*>(this)->get_compatible_pad_template(padtemplate);
}

Glib::RefPtr<Gst::Pad> Element::get_request_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_request_pad(gobj(), name.c_str()));
}

Glib::RefPtr<Gst::Pad> Element::get_static_pad(const Glib::ustring& name)
{
  return Glib::wrap(gst_element_get_static_pad(gobj(), name.c_str()));
}

Glib::RefPtr<const Gst::Pad> Element::get_static_pad(const Glib::ustring& name) const
{
  return const_cast<Element*>(this)->get_static_pad(name);
}

void Element::no_more_pads()
{
gst_element_no_more_pads(gobj()); 
}

void Element::release_request_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
gst_element_release_request_pad(gobj(), Glib::unwrap(pad)); 
}

bool Element::remove_pad(const Glib::RefPtr<Gst::Pad>& pad)
{
  return gst_element_remove_pad(gobj(), Glib::unwrap(pad));
}

Gst::Iterator<Gst::Pad> Element::iterate_pads()
{
  return Gst::Iterator<Gst::Pad>::Iterator(gst_element_iterate_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_pads() const
{
  return Gst::Iterator<const Gst::Pad>::Iterator(gst_element_iterate_pads(const_cast<GstElement*>(gobj())));
}

Gst::Iterator<Gst::Pad> Element::iterate_sink_pads()
{
  return Gst::Iterator<Gst::Pad>::Iterator(gst_element_iterate_sink_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_sink_pads() const
{
  return Gst::Iterator<const Gst::Pad>::Iterator(gst_element_iterate_sink_pads(const_cast<GstElement*>(gobj())));
}

Gst::Iterator<Gst::Pad> Element::iterate_src_pads()
{
  return Gst::Iterator<Gst::Pad>::Iterator(gst_element_iterate_src_pads(gobj()));
}

Gst::Iterator<const Gst::Pad> Element::iterate_src_pads() const
{
  return Gst::Iterator<const Gst::Pad>::Iterator(gst_element_iterate_src_pads(const_cast<GstElement*>(gobj())));
}

void Element::unlink(const Glib::RefPtr<Gst::Element>& other_element)
{
gst_element_unlink(gobj(), Glib::unwrap(other_element)); 
}

bool Element::link_pads(const Glib::ustring& padname, const Glib::RefPtr<Gst::Element>& other_element, const Glib::ustring& others_padname)
{
  return gst_element_link_pads(gobj(), padname.c_str(), Glib::unwrap(other_element), others_padname.c_str());
}

void Element::unlink_pads(const Glib::ustring& padname, const Glib::RefPtr<Gst::Element>& other_element, const Glib::ustring& other_padname)
{
gst_element_unlink_pads(gobj(), padname.c_str(), Glib::unwrap(other_element), other_padname.c_str()); 
}

bool Element::link_pads_filtered(const Glib::ustring& padname, const Glib::RefPtr<Gst::Element>& other_element, const Glib::ustring& others_padname, const Glib::RefPtr<Gst::Caps>& filter)
{
  return gst_element_link_pads_filtered(gobj(), padname.c_str(), Glib::unwrap(other_element), others_padname.c_str(), Glib::unwrap(filter));
}

bool Element::link_filtered(const Glib::RefPtr<Gst::Element>& other_element, const Glib::RefPtr<Gst::Caps>& filter)
{
  return gst_element_link_filtered(gobj(), Glib::unwrap(other_element), Glib::unwrap(filter));
}

void Element::set_base_time(ClockTime time)
{
gst_element_set_base_time(gobj(), ((GstClockTime)(time))); 
}

ClockTime Element::get_base_time() const
{
  return ((ClockTime)(gst_element_get_base_time(const_cast<GstElement*>(gobj()))));
}

void Element::set_bus(const Glib::RefPtr<Gst::Bus>& bus)
{
gst_element_set_bus(gobj(), Glib::unwrap(bus)); 
}

Glib::RefPtr<Gst::Bus> Element::get_bus()
{
  return Glib::wrap(gst_element_get_bus(gobj()));
}

Glib::RefPtr<const Gst::Bus> Element::get_bus() const
{
  return const_cast<Element*>(this)->get_bus();
}

void Element::set_index(const Glib::RefPtr<Gst::Index>& index)
{
gst_element_set_index(gobj(), Glib::unwrap(index)); 
}

Glib::RefPtr<Gst::Index> Element::get_index()
{
  return Glib::wrap(gst_element_get_index(gobj()));
}

Glib::RefPtr<const Gst::Index > Element::get_index() const
{
  return const_cast<Element*>(this)->get_index();
}

Glib::RefPtr<Gst::ElementFactory> Element::get_factory()
{

  Glib::RefPtr<Gst::ElementFactory> retvalue = Glib::wrap(gst_element_get_factory(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gst::ElementFactory> Element::get_factory() const
{
  return const_cast<Element*>(this)->get_factory();
}

bool Element::is_indexable() const
{
  return gst_element_is_indexable(const_cast<GstElement*>(gobj()));
}

bool Element::requires_clock() const
{
  return gst_element_requires_clock(const_cast<GstElement*>(gobj()));
}

bool Element::set_clock(const Glib::RefPtr<Gst::Clock>& clock)
{
  return gst_element_set_clock(gobj(), Glib::unwrap(clock));
}

Glib::RefPtr<Gst::Clock> Element::get_clock()
{
  return Glib::wrap(gst_element_get_clock(gobj()));
}

Glib::RefPtr<const Gst::Clock> Element::get_clock() const
{
  return const_cast<Element*>(this)->get_clock();
}

bool Element::provides_clock() const
{
  return gst_element_provides_clock(const_cast<GstElement*>(gobj()));
}

Glib::RefPtr<Gst::Clock> Element::provide_clock()
{
  return Glib::wrap(gst_element_provide_clock(gobj()));
}

Glib::RefPtr<const Gst::Clock> Element::provide_clock() const
{
  return const_cast<Element*>(this)->provide_clock();
}

StateChangeReturn Element::set_state(State state)
{
  return ((StateChangeReturn)(gst_element_set_state(gobj(), ((GstState)(state)))));
}

StateChangeReturn Element::get_state(State& state, State& pending, ClockTime timeout) const
{
  return ((StateChangeReturn)(gst_element_get_state(const_cast<GstElement*>(gobj()), ((GstState*)(&(state))), ((GstState*)(&(pending))), ((GstClockTime)(timeout)))));
}

bool Element::set_locked_state(gboolean locked_state)
{
  return gst_element_set_locked_state(gobj(), locked_state);
}

bool Element::is_locked_state() const
{
  return gst_element_is_locked_state(const_cast<GstElement*>(gobj()));
}

void Element::abort_state()
{
gst_element_abort_state(gobj()); 
}

StateChangeReturn Element::continue_state(StateChangeReturn prestate_value)
{
  return ((StateChangeReturn)(gst_element_continue_state(gobj(), ((GstStateChangeReturn)(prestate_value)))));
}

void Element::lost_state()
{
gst_element_lost_state(gobj()); 
}

bool Element::sync_state_with_parent()
{
  return gst_element_sync_state_with_parent(gobj());
}

StateChangeReturn Element::change_state(StateChange transition)
{
  return ((StateChangeReturn)(gst_element_change_state(gobj(), ((GstStateChange)(transition)))));
}

void Element::found_tags(Gst::TagList& list)
{
gst_element_found_tags(gobj(), (list).gobj()); 
}

void Element::found_tags_for_pad(const Glib::RefPtr<Gst::Pad>& pad, Gst::TagList& list)
{
gst_element_found_tags_for_pad(gobj(), Glib::unwrap(pad), (list).gobj()); 
}

void Element::post_message(MessageType message_type, const Glib::QueryQuark& domain, int code, const Glib::ustring& message, const Glib::ustring& debug, const Glib::ustring& filename, const Glib::ustring& function_name, int line_number)
{
gst_element_message_full(gobj(), ((GstMessageType)(message_type)), domain, code, const_cast<gchar*>(message.c_str()), const_cast<gchar*>(debug.c_str()), filename.c_str(), function_name.c_str(), line_number); 
}

bool Element::post_message(const Glib::RefPtr<Gst::Message>& message)
{
  return gst_element_post_message(gobj(), Glib::unwrap(message));
}

Glib::ArrayHandle<QueryType> Element::get_query_types() const
{
  return Glib::ArrayHandle<QueryType>((QueryType*)(gst_element_get_query_types(const_cast<GstElement*>(gobj()))), Glib::OWNERSHIP_SHALLOW);
}

bool Element::query(const Glib::RefPtr<Gst::Query>& query) const
{
  return gst_element_query(const_cast<GstElement*>(gobj()), Gst::unwrap(query));
}

bool Element::query_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const
{
  return gst_element_query_convert(const_cast<GstElement*>(gobj()), ((GstFormat)(src_format)), src_value, ((GstFormat*)&(dst_format)), &(dst_value));
}

bool Element::query_position(Format& format, gint64& position) const
{
  return gst_element_query_position(const_cast<GstElement*>(gobj()), ((GstFormat*)&(format)), &(position));
}

bool Element::query_duration(Format& format, gint64& duration) const
{
  return gst_element_query_duration(const_cast<GstElement*>(gobj()), ((GstFormat*)&(format)), &(duration));
}

bool Element::seek(Format format, SeekFlags flags, gint64 position)
{
  return gst_element_seek_simple(gobj(), ((GstFormat)(format)), ((GstSeekFlags)(flags)), position);
}

bool Element::seek(double rate, Format format, SeekFlags flags, SeekType current_type, gint64 current_position, SeekType stop_type, gint64 stop_position)
{
  return gst_element_seek(gobj(), rate, ((GstFormat)(format)), ((GstSeekFlags)(flags)), ((GstSeekType)(current_type)), current_position, ((GstSeekType)(stop_type)), stop_position);
}

bool Element::implements_interface(GType iface_type) const
{
  return gst_element_implements_interface(const_cast<GstElement*>(gobj()), iface_type);
}


Glib::SignalProxy0< void > Element::signal_no_more_pads()
{
  return Glib::SignalProxy0< void >(this, &Element_signal_no_more_pads_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > Element::signal_pad_added()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& >(this, &Element_signal_pad_added_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > Element::signal_pad_removed()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& >(this, &Element_signal_pad_removed_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gst::Element::on_no_more_pads()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->no_more_pads)
    (*base->no_more_pads)(gobj());
}
void Gst::Element::on_pad_added(const Glib::RefPtr<Gst::Pad>& new_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_added)
    (*base->pad_added)(gobj(),Glib::unwrap(new_pad));
}
void Gst::Element::on_pad_removed(const Glib::RefPtr<Gst::Pad>& old_pad)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pad_removed)
    (*base->pad_removed)(gobj(),Glib::unwrap(old_pad));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
Glib::RefPtr<Gst::Pad> Gst::Element::request_new_pad_vfunc(const Glib::RefPtr<const Gst::PadTemplate>& templ, const Glib::ustring& name) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->request_new_pad)
    return Glib::wrap((*base->request_new_pad)(gobj(),const_cast<GstPadTemplate*>((templ)->gobj()),name.c_str()));

  typedef Glib::RefPtr<Gst::Pad> RType;
  return RType();
}
void Gst::Element::release_pad_vfunc(const Glib::RefPtr<Gst::Pad>& pad) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->release_pad)
    (*base->release_pad)(gobj(),Glib::unwrap(pad));
}
StateChangeReturn Gst::Element::get_state_vfunc(State& state, State& pending, ClockTime timeout) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_state)
    return ((StateChangeReturn)((*base->get_state)(const_cast<GstElement*>(gobj()),((GstState*)(&(state))),((GstState*)(&(pending))),((GstClockTime)(timeout)))));

  typedef StateChangeReturn RType;
  return RType();
}
StateChangeReturn Gst::Element::set_state_vfunc(State state) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_state)
    return ((StateChangeReturn)((*base->set_state)(gobj(),((GstState)(state)))));

  typedef StateChangeReturn RType;
  return RType();
}
StateChangeReturn Gst::Element::change_state_vfunc(StateChange transition) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_state)
    return ((StateChangeReturn)((*base->change_state)(gobj(),((GstStateChange)(transition)))));

  typedef StateChangeReturn RType;
  return RType();
}
void Gst::Element::set_bus_vfunc(const Glib::RefPtr<Gst::Bus>& bus) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_bus)
    (*base->set_bus)(gobj(),Glib::unwrap(bus));
}
Glib::RefPtr<Gst::Clock> Gst::Element::provide_clock_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->provide_clock)
    return Glib::wrap((*base->provide_clock)(gobj()));

  typedef Glib::RefPtr<Gst::Clock> RType;
  return RType();
}
Glib::RefPtr<Gst::Index> Gst::Element::get_index_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_index)
    return Glib::wrap((*base->get_index)(const_cast<GstElement*>(gobj())));

  typedef Glib::RefPtr<Gst::Index> RType;
  return RType();
}
void Gst::Element::set_index_vfunc(const Glib::RefPtr<Gst::Index>& index) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_index)
    (*base->set_index)(gobj(),Glib::unwrap(index));
}
bool Gst::Element::send_event_vfunc(const Glib::RefPtr<Gst::Event>& event) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->send_event)
    return (*base->send_event)(gobj(),Gst::unwrap(event));

  typedef bool RType;
  return RType();
}
bool Gst::Element::query_vfunc(const Glib::RefPtr<Gst::Query>& query) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->query)
    return (*base->query)(const_cast<GstElement*>(gobj()),Gst::unwrap(query));

  typedef bool RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


