/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*#define DEBUG_ENABLED*/
#include <gst/gst.h>

static GstCaps* mpegsystem_type_find (GstByteStream *bs, gpointer private);
#if 0
static GstCaps* mpegvideo_type_find (GstByteStream *bs, gpointer private);
#endif

static GstTypeDefinition mpegtype_definitions[] = {
  { "mpegtypes_video/mpeg;system", "video/mpeg",
    ".mpg .mpeg .mpe", mpegsystem_type_find },
#if 0
  { "mpegtypes_video/mpeg", "video/mpeg",
    ".mpg .mpeg .mpe", mpegvideo_type_find },
#endif
  { NULL, NULL, NULL, NULL },
};

static GstCaps *
mpegsystem_type_find (GstByteStream *bs, gpointer private) 
{
  GstBuffer *buf = NULL;
  GstCaps *new = NULL;

  if (gst_bytestream_peek (bs, &buf, 5) == 5) {
    guint32 head1 = GUINT32_FROM_BE (*((guint32 *) GST_BUFFER_DATA (buf)));

    if (head1 == 0x000001ba &&
	(GST_BUFFER_DATA (buf)[4] & 0xC0) == 0x40) {
      new = GST_CAPS_NEW ("mpegsystem_type_find",
			  "video/mpeg",
        	            "systemstream", GST_PROPS_BOOLEAN (TRUE));
    }
  }

  if (buf != NULL) {
    gst_buffer_unref (buf);
  }

  return new;
}

#if 0
static GstCaps *
mpegvideo_type_find (GstByteStream *bs, gpointer private) 
{
  GstBuffer *buf = NULL;
  GstCaps *new = NULL;

  if (gst_bytestream_peek (bs, &buf, 4) == 4) {
    guint32 head = GUINT32_FROM_BE (*((guint32 *) GST_BUFFER_DATA (buf)));

    if (head == 0x000001b3) {
      new = GST_CAPS_NEW ("mpegvideo_type_find",
			  "video/mpeg",
			    "mpegversion",  GST_PROPS_INT (2 | 1), /* FIXME */
			    "systemstream", GST_PROPS_BOOLEAN (FALSE));
    }
  }
  return new;
}
#endif

static gboolean
plugin_init (GModule *module, GstPlugin *plugin)
{
  gint i=0;

  while (mpegtype_definitions[i].name) {
    GstTypeFactory *type;

    type = gst_type_factory_new (&mpegtype_definitions[i]);
    gst_plugin_add_feature (plugin, GST_PLUGIN_FEATURE (type));
    i++;
  }

  return TRUE;
}

GstPluginDesc plugin_desc = {
  GST_VERSION_MAJOR,
  GST_VERSION_MINOR,
  "mpeg2types",
  plugin_init
};
