## Contributing to Graphene

If you found a bug (which I'm sure there will be plenty), or if you want
to add your own pet feature, then follow these steps:

 1. Fork the [ebassi/graphene](https://github.com/ebassi/graphene) repo
 2. Fix bugs or add new features and push them to your clone
 3. Open [a new issue](https://github.com/ebassi/graphene/issues/new)
 4. Open [a pull request](https://github.com/ebassi/graphene/pulls)
 5. Wait for me to give feedback on the pull request
 6. Celebrate when your code gets merged

That's pretty much it.

### Coding style

Please, respect the coding style when writing patches for Graphene. The
coding style can be immediately gleaned from the existing code, but here is
a short version:

 * Indentation is made of spaces, and only spaces — **no tabs**
 * Each indentation level is 2 spaces
 * Curly braces for blocks go on a separate indentation level
  * Except for functions
 * Do not use curly braces for single-statement blocks
 * When declaring or defining a function, arguments go on separate
   lines
 * When calling a function never break a line between the function
   name and the opening parenthesis, and between the opening parenthesis
   and the first argument
 * Leave a space between functions and parenthesis

A more comprehensive coding style document is available in the
`CODING_STYLE.md` document, under the `docs` directory.
