// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_ITEMMODEL_H
#define _GOOCANVASMM_ITEMMODEL_H


#include <glibmm.h>


/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cairomm/cairomm.h>
#include <goocanvasitemmodel.h>
#include <goocanvasmm/style.h>
#include <goocanvasmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GooCanvasPathCommand GooCanvasPathCommand; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GooCanvasItemModel GooCanvasItemModel;
typedef struct _GooCanvasItemModelClass GooCanvasItemModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{ class ItemModel_Class; } // namespace Goocanvas
namespace Goocanvas
{
  class Canvas ;
  class Item ;

/** @addtogroup goocanvasmmEnums Enums and Flags */

/**
 * @ingroup goocanvasmmEnums
 */
enum AnimateType
{
  CANVAS_ANIMATE_FREEZE,
  CANVAS_ANIMATE_RESET,
  CANVAS_ANIMATE_RESTART,
  CANVAS_ANIMATE_BOUNCE
};

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::AnimateType> : public Glib::Value_Enum<Goocanvas::AnimateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{


class ItemModel : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ItemModel CppObjectType;
  typedef ItemModel_Class CppClassType;
  typedef GooCanvasItemModel BaseObjectType;
  typedef GooCanvasItemModelIface BaseClassType;

private:
  friend class ItemModel_Class;
  static CppClassType itemmodel_class_;

  // noncopyable
  ItemModel(const ItemModel&);
  ItemModel& operator=(const ItemModel&);

protected:
  ItemModel(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit ItemModel(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ItemModel(GooCanvasItemModel* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ItemModel();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GooCanvasItemModel*       gobj()       { return reinterpret_cast<GooCanvasItemModel*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GooCanvasItemModel* gobj() const { return reinterpret_cast<GooCanvasItemModel*>(gobject_); }

private:


public:

  
  /** Gets the number of children of the container.
   * @return The number of children.
   */
  int get_n_children() const;
  
  /** Gets the child at the given stack position.
   * @param child_num The position of a child in the container's stack.
   * @return The child at the given stack position, or <tt>0</tt> if @a child_num
   * is out of range.
   */
  Glib::RefPtr<ItemModel> get_child(int child_num);
  
  /** Gets the child at the given stack position.
   * @param child_num The position of a child in the container's stack.
   * @return The child at the given stack position, or <tt>0</tt> if @a child_num
   * is out of range.
   */
  Glib::RefPtr<const ItemModel> get_child(int child_num) const;
  
  /** Gets a child property of @a child.
   * @param child A child Goo::CanvasItemModel.
   * @param property_name The name of the child property to get.
   * @param value A location to return the value.
   */
  void get_child_property(const Glib::RefPtr<ItemModel>& child, const Glib::ustring& property_name, Glib::ValueBase& value) const;
  
  /** Sets a child property of @a child.
   * @param child A child Goo::CanvasItemModel.
   * @param property_name The name of the child property to set.
   * @param value The value to set the property to.
   */
  void set_child_property(const Glib::RefPtr<ItemModel>& child, const Glib::ustring& property_name, const Glib::ValueBase& value);

  
  /** Adds a child at the given stack position.
   * @param child The child to add.
   * @param position The position of the child, or -1 to place it last (at the top of
   * the stacking order).
   */
  void add_child(const Glib::RefPtr<ItemModel>& child, int position);
   void add_child(const Glib::RefPtr<ItemModel>& child);

  
  /** Moves a child to a new stack position.
   * @param old_position The current position of the child.
   * @param new_position The new position of the child.
   */
  void move_child(int old_position, int new_position);
  
  /** Removes the child at the given position.
   * @param child_num The position of the child to remove.
   */
  void remove_child(int child_num);
  
  /** Attempts to find the given child with the container's stack.
   * @param child The child to find.
   * @return The position of the given @a child, or -1 if it isn't found.
   */
  int find_child(const Glib::RefPtr<ItemModel>& child);

  
  /** Gets the parent of the given model.
   * @return The parent model, or <tt>0</tt> if the model has no parent.
   */
  Glib::RefPtr<ItemModel> get_parent();
  
  /** Gets the parent of the given model.
   * @return The parent model, or <tt>0</tt> if the model has no parent.
   */
  Glib::RefPtr<const ItemModel> get_parent() const;
  
  /** This function is only intended to be used when implementing new canvas
   * item models (specifically container models such as Goo::CanvasGroupModel).
   * It sets the parent of the child model.
   * &lt;!--PARAMETERS--&gt;
   * &lt;note&gt;
   * This function cannot be used to add a model to a group
   * or to change the parent of a model.
   * To do that use the Goo::CanvasItemModel:parent property.
   * &lt;/note&gt;
   * @param parent The new parent item model.
   */
  void set_parent(const Glib::RefPtr<ItemModel>& parent);

  
  /** Removes a model from its parent. If the model is in a canvas it will be
   * removed.
   * 
   * This would normally also result in the model being freed.
   */
  void remove();
  
  /** Tests to see if the given item model is a container.
   * @return <tt>true</tt> if the item model is a container.
   */
  bool is_container() const;

  
  /** Raises a model in the stacking order.
   * @param above The item model to raise @a model above, or <tt>0</tt> to raise @a model to the top
   * of the stack.
   */
  void raise(const Glib::RefPtr<ItemModel>& above);

  /** Raise the item to the top of the stack.
   */
  void raise();

  
  /** Lowers a model in the stacking order.
   * @param below The item model to lower @a model below, or <tt>0</tt> to lower @a model to the
   * bottom of the stack.
   */
  void lower(const Glib::RefPtr<ItemModel>& below);

  /** Lower the item to the bottom of the stack.
   */
  void lower();

  //TODO: Use Cairo::RefPtr?
  
  /** Gets the transformation matrix of an item model.
   * @param transform The place to store the transform.
   * @return <tt>true</tt> if a transform is set.
   */
  bool get_transform(Cairo::Matrix* transform);
  
  /** Sets the transformation matrix of an item model.
   * @param transform The new transformation matrix, or <tt>0</tt> to reset the
   * transformation to the identity matrix.
   */
  void set_transform(const Cairo::Matrix* transform);
  
  /** A convenience function to set the item model's transformation matrix.
   * @param x The x coordinate of the origin of the model's coordinate space.
   * @param y The y coordinate of the origin of the model's coordinate space.
   * @param scale The scale of the model.
   * @param rotation The clockwise rotation of the model, in degrees.
   */
  void set_simple_transform(double x, double y, double scale, double rotation);
  
  /** This function can be used to get the position, scale and rotation of an
   * item model, providing that the model has a simple transformation matrix
   * (e.g.\ set with set_simple_transform(), or using a
   * combination of simple translate, scale and rotate operations). If the model
   * has a complex transformation matrix the results will be incorrect.
   * @param x Returns the x coordinate of the origin of the model's coordinate space.
   * @param y Returns the y coordinate of the origin of the model's coordinate space.
   * @param scale Returns the scale of the model.
   * @param rotation Returns the clockwise rotation of the model, in degrees (0-360).
   * @return <tt>true</tt> if a transform is set.
   */
  bool get_simple_transform(double& x, double& y, double& scale, double& rotation) const;
  
  /** Translates the origin of the model's coordinate system by the given amounts.
   * @param tx The amount to move the origin in the horizontal direction.
   * @param ty The amount to move the origin in the vertical direction.
   */
  void translate(double tx, double ty);
  
  /** Scales the model's coordinate system by the given amounts.
   * @param sx The amount to scale the horizontal axis.
   * @param sy The amount to scale the vertical axis.
   */
  void scale(double sx, double sy);
  
  /** Rotates the model's coordinate system by the given amount, about the given
   * origin.
   * @param degrees The clockwise angle of rotation.
   * @param cx The x coordinate of the origin of the rotation.
   * @param cy The y coordinate of the origin of the rotation.
   */
  void rotate(double degrees, double cx, double cy);
  
  /** Skews the model's coordinate system along the x axis by the given amount,
   * about the given origin.
   * @param degrees The skew angle.
   * @param cx The x coordinate of the origin of the skew transform.
   * @param cy The y coordinate of the origin of the skew transform.
   */
  void skew_x(double degrees, double cx, double cy);
  
  /** Skews the model's coordinate system along the y axis by the given amount,
   * about the given origin.
   * @param degrees The skew angle.
   * @param cx The x coordinate of the origin of the skew transform.
   * @param cy The y coordinate of the origin of the skew transform.
   */
  void skew_y(double degrees, double cx, double cy);

  
  /** Gets the model's style. If the model doesn't have its own style it will
   * return its parent's style.
   * @return The model's style.
   */
  Glib::RefPtr<Style> get_style();
  
  /** Gets the model's style. If the model doesn't have its own style it will
   * return its parent's style.
   * @return The model's style.
   */
  Glib::RefPtr<const Style> get_style() const;
  
  /** Sets the model's style, by copying the properties from the given style.
   * @param style A style.
   */
  void set_style(const Glib::RefPtr<Style>& style);

  
  /** Animates a model from its current position to the given offsets, scale
   * and rotation.
   * @param x The final x coordinate.
   * @param y The final y coordinate.
   * @param scale The final scale.
   * @param degrees The final rotation. This can be negative to rotate anticlockwise,
   * and can also be greater than 360 to rotate a number of times.
   * @param absolute If the @a x, @a y, @a scale and @a degrees values are absolute, or
   * relative to the current transform. Note that absolute animations only work
   * if the model currently has a simple transform. If the model has a shear or
   * some other complicated transform it may result in strange animations.
   * @param duration The duration of the animation, in milliseconds (1/1000ths of a
   * second).
   * @param step_time The time between each animation step, in milliseconds.
   * @param type Specifies what happens when the animation finishes.
   */
  void animate(double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, AnimateType animate_type);
  
  /** Stops any current animation for the given model, leaving it at its current
   * position.
   */
  void stop_animation();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_added(int child_num)</tt>
   */

  Glib::SignalProxy1< void,int > signal_child_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_removed(int child_num)</tt>
   */

  Glib::SignalProxy1< void,int > signal_child_removed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_moved(int old_child_num, int new_child_num)</tt>
   */

  Glib::SignalProxy2< void,int,int > signal_child_moved();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(bool recompute_bounds)</tt>
   */

  Glib::SignalProxy1< void,bool > signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_notify(GParamSpec* pspec)</tt>
   */

  Glib::SignalProxy1< void,GParamSpec* > signal_child_notify();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent item model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<ItemModel> > property_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent item model.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ItemModel> > property_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The transformation matrix of the item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Cairo::Matrix*> property_transform() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The transformation matrix of the item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Cairo::Matrix*> property_transform() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A short context-rich description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A short context-rich description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PointerEvents> property_pointer_events() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PointerEvents> property_pointer_events() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ItemVisibility> property_visibility() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ItemVisibility> property_visibility() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_visibility_threshold() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_visibility_threshold() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
 

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_n_children_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<ItemModel> get_child_vfunc(int child_num) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void add_child_vfunc(const Glib::RefPtr<ItemModel>& child, int position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void move_child_vfunc(int old_position, int ne_position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void remove_child_vfunc(int child_num);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_child_property_vfunc(const Glib::RefPtr<ItemModel>& child, guint property_id, Glib::ValueBase& value, GParamSpec* pspec) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_child_property_vfunc(const Glib::RefPtr<ItemModel>& child, guint property_id, const Glib::ValueBase& value, GParamSpec* pspec);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<ItemModel> get_parent_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_parent_vfunc(const Glib::RefPtr<ItemModel>& parent);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Item> create_item_vfunc(Canvas* canvas);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_transform_vfunc(Cairo::Matrix* transform) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_transform_vfunc(const Cairo::Matrix* transform);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Style> get_style_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_style_vfunc(const Glib::RefPtr<Style>& style);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_child_added(int child_num);
  virtual void on_child_removed(int child_num);
  virtual void on_child_moved(int old_child_num, int new_child_num);
  virtual void on_changed(bool recompute_bounds);
  virtual void on_child_notify(GParamSpec* pspec);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Goocanvas::ItemModel
   */
  Glib::RefPtr<Goocanvas::ItemModel> wrap(GooCanvasItemModel* object, bool take_copy = false);

} // namespace Glib


#endif /* _GOOCANVASMM_ITEMMODEL_H */

