;; A table of ISO currency codes and their long descriptions
;; of usage by country. Some currencies are used in more than
;; one country, hence some codes have multiple long descriptions.

(gnc:support "currencies.scm")

(if (not (defined? 'gnc:*currencies*))
    (define gnc:*currencies*
      (list
       '( "AFA" . "Afghanistan Afghani" )
       '( "ALL" . "Albanian Lek" )
       '( "DZD" . "Algerian Dinar" )
       '( "ADF" . "Andorran Franc" )
       '( "ADP" . "Andorran Peseta" )
       '( "AON" . "Angolan New Kwanza" )
       '( "ARA" . "Argentine Austral" )
       '( "ARS" . "Argentine Peso" )
       '( "AWG" . "Aruban Florin" )
       '( "AUD" . "Australian Dollar" )
       '( "ATS" . "Austrian Schilling" )
       '( "BSD" . "Bahamian Dollar" )
       '( "BHD" . "Bahraini Dinar" )
       '( "BDT" . "Bangladeshi Taka" )
       '( "BBD" . "Barbados Dollar" )
       '( "BEF" . "Belgian Franc" )
       '( "BZD" . "Belize Dollar" )
       '( "XOF" . "Benin Franc" )
       '( "BMD" . "Bermudian Dollar" )
       '( "BTN" . "Bhutan Ngultrum" )
       '( "BOB" . "Bolivian Boliviano" )
       '( "BWP" . "Botswana Pula" )
       '( "BRC" . "Brazilian Cruzeiro" )
       '( "BRL" . "Brazilian Real" )
       '( "GBP" . "British Pound" )
       '( "BND" . "Brunei Dollar" )
       '( "BGL" . "Bulgarian Lev" )
       '( "XOF" . "Burkino Faso Franc" )
       '( "BIF" . "Burundi Franc" )
       '( "XAF" . "Cameroon Franc" )
       '( "CAD" . "Canadian Dollar" )
       '( "CVE" . "Cape Verde Escudo" )
       '( "KYD" . "Cayman Islands Dollar" )
       '( "XAF" . "Central African Republic Franc" )
       '( "XAF" . "Chad Franc" )
       '( "CLP" . "Chilean Peso" )
       '( "CNY" . "Chinese Yuan Renminbi" )
       '( "COP" . "Colombian Peso" )
       '( "KMF" . "Comoros Franc" )
       '( "XAF" . "Congo Franc" )
       '( "CRC" . "Costa Rican Colon" )
       '( "HRK" . "Croatian Kuna" )
       '( "CUP" . "Cuban Peso" )
       '( "CYP" . "Cyprus Pound" )
       '( "CSK" . "Czech Koruna" )
       '( "DKK" . "Danish Krone" )
       '( "DJF" . "Djibouti Franc" )
       '( "DOP" . "Dominican Peso" )
       '( "NLG" . "Dutch Guilder" )
       '( "ECS" . "Ecuador Sucre" )
       '( "EGP" . "Egyptian Pound" )
       '( "SVC" . "El Salvador Colon" )
       '( "XAF" . "Equatorial Guinea Franc" )
       '( "EEK" . "Estonian Kroon" )
       '( "ETB" . "Ethiopian Birr" )
       '( "EUR" . "Euro" )
       '( "FKP" . "Falkland Islands Pound" )
       '( "FJD" . "Fiji Dollar" )
       '( "FIM" . "Finnish Markka" )
       '( "FRF" . "French Franc" )
       '( "XAF" . "Gabon Franc" )
       '( "GMD" . "Gambian Dalasi" )
       '( "DEM" . "German Mark" )
       '( "GHC" . "Ghanaian Cedi" )
       '( "GIP" . "Gibraltar Pound" )
       '( "GRD" . "Greek Drachma" )
       '( "GTQ" . "Guatemalan Quetzal" )
       '( "GNF" . "Guinea Franc" )
       '( "GWP" . "Guinea-Bissau Peso" )
       '( "GYD" . "Guyanan Dollar" )
       '( "HTG" . "Haitian Gourde" )
       '( "HNL" . "Honduran Lempira" )
       '( "HKD" . "Hong Kong Dollar" )
       '( "HUF" . "Hungarian Forint" )
       '( "ISK" . "Iceland Krona" )
       '( "INR" . "Indian Rupee" )
       '( "IDR" . "Indonesian Rupiah" )
       '( "IRR" . "Iranian Rial" )
       '( "IQD" . "Iraqi Dinar" )
       '( "IEP" . "Irish Punt" )
       '( "ILS" . "Israeli New Shekel" )
       '( "ITL" . "Italian Lira" )
       '( "XOF" . "Ivory Coast Franc" )
       '( "JMD" . "Jamaican Dollar" )
       '( "JPY" . "Japanese Yen" )
       '( "JOD" . "Jordanian Dinar" )
       '( "KHR" . "Kampuchean (Cambodian) Riel" )
       '( "KZT" . "Kazakhstan Tenge" )
       '( "KES" . "Kenyan Schilling" )
       '( "KRW" . "Korean Won" )
       '( "KWD" . "Kuwaiti Dinar" )
       '( "LAK" . "Lao Kip" )
       '( "LVL" . "Latvian Lats" )
       '( "LBP" . "Lebanese Pound" )
       '( "LSL" . "Lesotho Loti" )
       '( "LRD" . "Liberian Dollar" )
       '( "LYD" . "Libyan Dinar" )
       '( "LTL" . "Lithuanian Litas" )
       '( "LUF" . "Luxembourg Franc" )
       '( "MOP" . "Macau Pataca" )
       '( "MGF" . "Malagasy Franc" )
       '( "MWK" . "Malawi Kwacha" )
       '( "MYR" . "Malaysian Ringgit" )
       '( "MVR" . "Maldive Rufiyaa" )
       '( "XOF" . "Mali Republic Franc" )
       '( "MTL" . "Maltese Lira" )
       '( "MRO" . "Mauritanian Ouguiya" )
       '( "MUR" . "Mauritius Rupee" )
       '( "MXP" . "Mexican Peso" )
       '( "MNT" . "Mongolian Tugrik" )
       '( "MAD" . "Moroccan Dirham" )
       '( "MZM" . "Mozambique Metical" )
       '( "MMK" . "Myanmar Kyat" )
       '( "NAD" . "Namibian Dollar" )
       '( "NPR" . "Nepalese Rupee" )
       '( "ANG" . "Netherlands Antillian Guilder" )
       '( "NZD" . "New Zealand Dollar" )
       '( "NIO" . "Nicaraguan Cordoba Oro" )
       '( "XOF" . "Niger Republic Franc" )
       '( "NGN" . "Nigerian Naira" )
       '( "KPW" . "North Korean Won" )
       '( "NOK" . "Norwegian Kroner" )
       '( "OMR" . "Omani Rial" )
       '( "PKR" . "Pakistan Rupee" )
       '( "PAB" . "Panamanian Balboa" )
       '( "PGK" . "Papua New Guinea Kina" )
       '( "PYG" . "Paraguay Guarani" )
       '( "PEN" . "Peruvian Nuevo Sol" )
       '( "PHP" . "Philippine Peso" )
       '( "PLZ" . "Polish Zloty" )
       '( "PTE" . "Portuguese Escudo" )
       '( "QAR" . "Qatari Rial" )
       '( "ROL" . "Romanian Leu" )
       '( "RUB" . "Russian Rouble" )
       '( "WST" . "Samoan Tala" )
       '( "STD" . "Sao Tome and Principe Dobra" )
       '( "SAR" . "Saudi Riyal" )
       '( "XOF" . "Senegal Franc" )
       '( "SCR" . "Seychelles Rupee" )
       '( "SLL" . "Sierra Leone Leone" )
       '( "SGD" . "Singapore Dollar" )
       '( "SKK" . "Slovak Koruna" )
       '( "SIT" . "Slovenian Tolar" )
       '( "SBD" . "Solomon Islands Dollar" )
       '( "SOS" . "Somali Schilling" )
       '( "ZAR" . "South African Rand" )
       '( "ESP" . "Spanish Peseta" )
       '( "LKR" . "Sri Lanka Rupee" )
       '( "SHP" . "St. Helena Pound" )
       '( "SDD" . "Sudanese Dinar" )
       '( "SDP" . "Sudanese Pound" )
       '( "SRG" . "Suriname Guilder" )
       '( "SZL" . "Swaziland Lilangeni" )
       '( "SEK" . "Swedish Krona" )
       '( "CHF" . "Swiss Franc" )
       '( "SYP" . "Syrian Pound" )
       '( "TWD" . "Taiwan Dollar" )
       '( "TZS" . "Tanzanian Schilling" )
       '( "THB" . "Thai Baht" )
       '( "XOF" . "Togo Republic Franc" )
       '( "TOP" . "Tongan Pa'anga" )
       '( "TTD" . "Trinidad and Tobago Dollar" )
       '( "TND" . "Tunisian Dinar" )
       '( "TRL" . "Turkish Lira" )
       '( "USD" . "US Dollar" )
       '( "UGS" . "Uganda Shilling" )
       '( "UAG" . "Ukraine Hryvnia" )
       '( "UAK" . "Ukraine Karbovanets" )
       '( "AED" . "United Arab Emirates Dirham" )
       '( "UYP" . "Uruguayan Peso" )
       '( "VUV" . "Vanuatu Vatu" )
       '( "VEB" . "Venezuelan Bolivar" )
       '( "VND" . "Vietnamese Dong" )
       '( "YUN" . "Yugoslav Dinar" )
       '( "ZMK" . "Zambian Kwacha" )
       '( "ZWD" . "Zimbabwe Dollar" )
       )
      )
    )

(define (gnc:add-currency currency description)
  (set! gnc:*currencies*
        (cons (cons currency description)
              gnc:*currencies*)))
