/********************************************************************\
 * guile-util.h -- utility functions for using guile for GnuCash    *
 * Copyright (C) 1999 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

#ifndef __GUILE_UTIL_H__
#define __GUILE_UTIL_H__

#include <guile/gh.h>

#include "top-level.h"
#include "GNCId.h"

/* Helpers for various types */

SCM      gnc_timespec2timepair(Timespec t);
Timespec gnc_timepair2timespec(SCM x);
int      gnc_timepair_p(SCM x);

SCM  gnc_guid2scm(GUID guid);
GUID gnc_scm2guid(SCM guid_scm);
int  gnc_guid_p(SCM guid_scm);

/* Helpful functions for calling functions that return
 * specific kinds of values. These functions do error
 * checking to verify the result is of the correct type. */
char * gnc_guile_call1_to_string(SCM func, SCM arg);
char * gnc_guile_call1_symbol_to_string(SCM func, SCM arg);
SCM    gnc_guile_call1_to_procedure(SCM func, SCM arg);
SCM    gnc_guile_call1_to_list(SCM func, SCM arg);
SCM    gnc_guile_list_ref(SCM list, int index);
SCM    gnc_guile_call1_to_vector(SCM func, SCM arg);

/* Accessing the gnucash/guile dependency mechanism */
gncBoolean gnc_depend(const char *scm_file);

/* The next set of functions is for manipulating scheme
 * representations of splits and transactions. */
gncBoolean gnc_is_split_scm(SCM scm);
gncBoolean gnc_is_trans_scm(SCM scm);

SCM    gnc_copy_split(Split *split);
void   gnc_copy_split_scm_onto_split(SCM split_scm, Split *split);

void   gnc_split_scm_set_account(SCM split_scm, Account *account);
void   gnc_split_scm_set_memo(SCM split_scm, const char *memo);
void   gnc_split_scm_set_action(SCM split_scm, const char *action);
void   gnc_split_scm_set_reconcile_state(SCM split_scm, char reconcile_state);
void   gnc_split_scm_set_share_price_and_amount(SCM split_scm, double price,
                                                double amount);

char * gnc_split_scm_get_memo(SCM split_scm);
char * gnc_split_scm_get_action(SCM split_scm);
double gnc_split_scm_get_share_price(SCM split_scm);
double gnc_split_scm_get_share_amount(SCM split_scm);

SCM    gnc_copy_trans(Transaction *trans);
void   gnc_copy_trans_scm_onto_trans(SCM trans_scm, Transaction *trans,
                                     gncBoolean do_commit);
void   gnc_copy_trans_scm_onto_trans_swap_accounts(SCM trans_scm,
                                                   Transaction *trans,
                                                   const GUID *guid_1,
                                                   const GUID *guid_2,
                                                   gncBoolean do_commit);

void   gnc_trans_scm_set_date(SCM trans_scm, Timespec *ts);
void   gnc_trans_scm_set_num(SCM trans_scm, const char *num);
void   gnc_trans_scm_set_description(SCM trans_scm, const char *description);
void   gnc_trans_scm_append_split_scm(SCM trans_scm, SCM split_scm);

SCM    gnc_trans_scm_get_split_scm(SCM trans_scm, int index);
SCM    gnc_trans_scm_get_other_split_scm(SCM trans_scm, SCM split_scm);
int    gnc_trans_scm_get_num_splits(SCM trans_scm);

/* Two functions that return string synonyms for the terms 'debit' and
 * 'credit' as appropriate for the given account type and user preferences. */
char * gnc_get_debit_string(GNCAccountType account_type);
char * gnc_get_credit_string(GNCAccountType account_type);

/* Utilities for working with account lists and SCMs */
SCM     gnc_account_list_to_scm(GList *account_list);
GList * gnc_scm_to_account_list(SCM scm_list);

#endif
