/********************************************************************\
 * gnc-helpers.h -- gnucash g-wrap helper functions                 *
 * Copyright (C) 2000 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

#ifndef __GNC_HELPERS__
#define __GNC_HELPERS__

#include <guile/gh.h>
#include <glib.h>

#include "gnc-common.h"
#include "Transaction.h"
#include "GNCId.h"

int  gnc_guid_type(GUID guid);

GUID           gnc_group_get_guid(AccountGroup *group);
AccountGroup * gnc_group_lookup(GUID guid);

GUID      gnc_account_get_guid(Account *account);
Account * gnc_account_lookup(GUID guid);

GUID          gnc_trans_get_guid(Transaction *trans);
Transaction * gnc_trans_lookup(GUID guid);

GUID    gnc_split_get_guid(Split *split);
Split * gnc_split_lookup(GUID guid);

int gnc_trans_is_common_currency(Transaction *trans, const char *currency);

Timespec gnc_transaction_get_date_posted(Transaction *t);
Timespec gnc_transaction_get_date_entered(Transaction *t);

Timespec gnc_split_get_date_reconciled(Split *s);

void gnc_transaction_set_date_posted(Transaction *t, const Timespec d);
void gnc_transaction_set_date_entered(Transaction *t, const Timespec d);

void gnc_transaction_set_date(Transaction *t, Timespec ts);

char * gnc_gettext_helper(const char *string);

SCM    _gnc_get_current_accounts();

/* See Group.h for info about traversals. */

gncBoolean gnc_scmGroupStagedTransactionTraversal(AccountGroup *grp,
                                                  unsigned int stage,
                                                  SCM thunk);

gncBoolean gnc_scmAccountStagedTransactionTraversal(Account *a,
                                                    unsigned int stage,
                                                    SCM thunk);

#endif
