/********************************************************************\
 * gnc-helpers.c -- gnucash g-wrap helper functions                 *
 * Copyright (C) 2000 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

#include "config.h"
#include "gnc-helpers.h"

#include <g-wrap.h>

#include "top-level.h"
#include "guile-util.h"
#include "ui-callbacks.h"
#include "gnc.h"
#include "messages.h"

int
gnc_guid_type(GUID guid)
{
  return xaccGUIDType(&guid);
}

GUID
gnc_group_get_guid(AccountGroup *group) {
  return *xaccGroupGetGUID(group);
}

AccountGroup *
gnc_group_lookup(GUID guid) {
  return xaccGroupLookup(&guid);
}

GUID
gnc_account_get_guid(Account *account) {
  return *xaccAccountGetGUID(account);
}

Account *
gnc_account_lookup(GUID guid) {
  return xaccAccountLookup(&guid);
}

GUID
gnc_trans_get_guid(Transaction *trans) {
  return *xaccTransGetGUID(trans);
}

Transaction *
gnc_trans_lookup(GUID guid) {
  return xaccTransLookup(&guid);
}

GUID
gnc_split_get_guid(Split *split) {
  return *xaccSplitGetGUID(split);
}

Split *
gnc_split_lookup(GUID guid) {
  return xaccSplitLookup(&guid);
}

int
gnc_trans_is_common_currency(Transaction *trans, const char *currency)
{
  return xaccTransIsCommonCurrency(trans, currency) != NULL;
}

Timespec
gnc_transaction_get_date_posted(Transaction *t) {
  Timespec result;
  xaccTransGetDateTS(t, &result);
  return(result);
}

Timespec
gnc_transaction_get_date_entered(Transaction *t) {
  Timespec result;
  xaccTransGetDateEnteredTS(t, &result);
  return(result);
}

Timespec
gnc_split_get_date_reconciled(Split *s) {
  Timespec result;
  xaccSplitGetDateReconciledTS(s, &result);
  return(result);
}

void
gnc_transaction_set_date_posted(Transaction *t, const Timespec d) {
  xaccTransSetDateTS(t, &d);
}

void
gnc_transaction_set_date_entered(Transaction *t, const Timespec d) {
  xaccTransSetDateEnteredTS(t, &d);
}

void
gnc_transaction_set_date(Transaction *t, Timespec ts)
{
  xaccTransSetDateTS(t, &ts);
}

char *
gnc_gettext_helper(const char *string)
{
  return _(string);
}

/********************************************************************\
 * _gnc_get_current_accounts                                        *
 *   Return an SCMified list of the current accounts                *
 *                                                                  *
 * Args: none                                                       *
 * Return: SCM list of current accounts                             *
\********************************************************************/
SCM
_gnc_get_current_accounts()
{
  GList *list;
  SCM scm_list;

  list = gnc_get_current_accounts();

  scm_list = gnc_account_list_to_scm(list);

  g_list_free(list);

  return scm_list;
}

static int
gnc_scm_traversal_adapter(Transaction *t, void *data)
{
  POINTER_TOKEN pt;
  SCM scm_trans, result;
  SCM thunk = *((SCM *) data);

  pt = make_POINTER_TOKEN("Transaction*", t);
  scm_trans = POINTER_TOKEN_to_SCM(pt);

  result = gh_call1(thunk, scm_trans);

  if (result == SCM_BOOL_F)
    return(GNC_F);
  else
    return(GNC_T);
}

gncBoolean
gnc_scmGroupStagedTransactionTraversal(AccountGroup *grp,
                                       unsigned int new_marker,
                                       SCM thunk)
{
  return xaccGroupStagedTransactionTraversal(grp, new_marker,
                                             gnc_scm_traversal_adapter,
                                             &thunk);
}

gncBoolean
gnc_scmAccountStagedTransactionTraversal(Account *a,
                                         unsigned int new_marker,
                                         SCM thunk) 
{
  return xaccAccountStagedTransactionTraversal(a, new_marker,
					       gnc_scm_traversal_adapter,
                                               &thunk);
}
