/********************************************************************\
 * enriched-messages.c -- simple text formatting                    *
 * Copyright (C) 1999 Laurent Plecq                                *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
\********************************************************************/

#include <stdio.h>
#include <string.h>
#include <assert.h>

#define DISABLE_GETTEXT_UNDERSCORE
#include "enriched-messages.h"

#define ALL_MESSAGES_LENGTH		4095

char *enriched_message[NUMBER_OF_STRINGS_WITH_COLONS_OR_ELIPSES];

static char heap[ALL_MESSAGES_LENGTH+1];

static char *heap_cursor=heap;

struct _indexed_message_t
{
  int index;
  const char *str;
};
typedef struct _indexed_message_t indexed_message_t;

indexed_message_t messages_with_colons[]=
{
  { ACC_CODE_C_IDX,		ACC_CODE_STR },
  { ACC_NAME_C_IDX,		ACC_NAME_STR },
  { AMOUNT_C_IDX,               AMT_STR },
  { ASSETS_C_IDX,		ASSETS_STR },
  { BALN_C_IDX,			BALN_STR },
  { CLEARED_C_IDX,		CLEARED_STR },
  { CREDITS_C_IDX,		CREDITS_STR },
  { CURRENCY_C_IDX,		CURRENCY_STR },
  { DATE_C_IDX,                 DATE_STR },
  { DEBITS_C_IDX,		DEBITS_STR },
  { DESC_C_IDX,			DESC_STR },
  { DIFF_C_IDX,			DIFF_STR },
  { END_BALN_C_IDX,		END_BALN_STR },
  { END_DATE_C_IDX,             END_DATE_STR },
  { FROM_C_IDX,			FROM_STR },
  { MEMO_C_IDX,                 MEMO_STR },
  { PARENT_ACC_C_IDX,		PARENT_ACC_STR },
  { PREV_BALN_C_IDX,		PREV_BALN_STR },
  { PROFITS_C_IDX,		PROFITS_STR },
  { QUOTE_SRC_C_IDX,		QUOTE_SRC_STR },
  { RECONCILE_BALN_C_IDX,	RECONCILE_BALN_STR },
  { SECURITY_C_IDX,		SECURITY_STR },
  { START_BALN_C_IDX,		START_BALN_STR },
  { START_DATE_C_IDX,           START_DATE_STR },
  { TO_C_IDX,			TO_STR },
  { TOTAL_C_IDX,		TOTAL_STR },
  { NUMBER_OF_STRINGS_WITH_COLONS, NULL }
};

indexed_message_t messages_with_elipses[]=
{
  { ABOUT_E_IDX,		ABOUT_STR },
  { ACCOUNTS_E_IDX,		ACCOUNTS_STR },
  { ADJ_BALN_E_IDX,		ADJ_BALN_STR },
  { ADJ_BALN_MENU_E_IDX,	ADJ_BALN_MENU_STR },
  { DATE_RANGE_E_IDX,           DATE_RANGE_STR },
  { DEL_ACC_E_IDX,		DEL_ACC_STR },
  { EDIT_ACCT_E_IDX,		EDIT_ACCT_STR },
  { END_BALN_MENU_E_IDX,        END_BALN_MENU_STR },
  { HELP_E_IDX,			HELP_STR },
  { HIDE_INC_EXP_E_IDX,		HIDE_INC_EXP_STR },
  { IMPORT_QIF_E_IDX,		IMPORT_QIF_STR },
  { LICENSE_E_IDX,		LICENSE_STR },
  { NEW_ACC_E_IDX,		NEW_ACC_STR },
  { NEW_ACC_MENU_E_IDX,		NEW_ACC_MENU_STR },
  { NEW_FILE_E_IDX,		NEW_FILE_STR },
  { OPEN_ACC_E_IDX,		OPEN_ACC_STR },
  { OPEN_FILE_E_IDX,		OPEN_FILE_STR },
  { OPEN_SUB_E_IDX,		OPEN_SUB_STR },
  { PREFERENCES_MENU_E_IDX,     PREFERENCES_MENU_STR },
  { PRINT_E_IDX,		PRINT_STR },
  { RECONCILE_E_IDX,		RECONCILE_STR },
  { RECONCILE_MENU_E_IDX,	RECONCILE_MENU_STR },
  { REPORT_E_IDX,		REPORT_STR },
  { SAVE_E_IDX,			SAVE_STR },
  { SAVE_AS_E_IDX,		SAVE_AS_STR },
  { SET_RANGE_MENU_E_IDX,       SET_RANGE_MENU_STR },
  { SHOW_INC_EXP_E_IDX,		SHOW_INC_EXP_STR },
  { SIMPLE_E_IDX,		SIMPLE_STR },
  { TRANSFER_E_IDX,		TRANSFER_STR },
  { TRANSFER_MENU_E_IDX,	TRANSFER_MENU_STR },
  { NUMBER_OF_STRINGS_WITH_COLONS_OR_ELIPSES, NULL }
};

void
addEnrichedStrings (const char *simple_format,
		    indexed_message_t *indexes)
{
  indexed_message_t *p=NULL;
  for (p=indexes; p->str; p++)
    {
      sprintf (heap_cursor, simple_format, gettext (p->str));
      /* If the following assertion fail, increase the length of
	 heap. It would be better to dynamically allocate strings but
	 it seems difficult to free them since main function never
	 terminate. */
      assert (heap_cursor+strlen (simple_format)+strlen (p->str)<
	      heap+ALL_MESSAGES_LENGTH);
      enriched_message[p->index]=heap_cursor;
      while (*heap_cursor++)
	;
    }
}

void buildEnrichedMessages ()
{
  addEnrichedStrings ("%s:", messages_with_colons);
  addEnrichedStrings ("%s...", messages_with_elipses);
}



