/* vi:set ts=8 sts=0 sw=8:
 * $Id: doc.h,v 1.12 1999/01/18 19:45:26 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DOC_H__
#define __DOC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <sys/stat.h>
#include <gtk/gtk.h>
#include "main.h"
#include "win.h"

typedef struct {
	unsigned	docid;		/* document id */
	win_t *		w;		/* document's parent window (win_t *) */
	char *		fname;		/* document's filename */
	struct stat *	sb;		/* info from stat() */
	void *		docinfo;	/* top level docinfo */

#ifdef APP_GNP
	guint		changed_id;	/* id of doc changed */
	bool_t		changed;	/* whether or not doc has changed */
#endif
	GtkWidget *	data;		/* text or clist widget */
	GtkWidget *	tablabel;	/* tab label, containing filename */
	GtkWidget *	printwin;	/* top level print window */
	GtkWidget *	printentry;	/* widget containing print cmd */
} doc_t;

typedef struct {
	win_t *w;			/* pointer into entry in 'winlist' */
	char *fname;
} doc_new_name_t;


extern char *	doc_basefname(doc_t *d);
extern void	doc_by_name(GtkWidget *wgt, gpointer cbdata);
#ifdef APP_GNP
extern void	doc_changed_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_check_if_any_changed(win_t *w);
#endif
extern void	doc_close_all_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_close_all_common(win_t *w);
extern void	doc_close_cb(GtkWidget *wgt, gpointer cbdata);
extern doc_t *	doc_current(win_t *w);
extern void	doc_foreach(win_t *wp, void (*func)(void *));
extern void	doc_goto_by_name(GtkWidget *wgt, gpointer cbdata);
extern void	doc_info_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_info_init(win_t *w, GtkWidget *parent);
extern void	doc_info_label_update(win_t *w);
extern void	doc_list_add(win_t *w, doc_t *curdoc, int , char *, int);
extern void	doc_list_destroy(GtkWidget *wgt, gpointer cbdata);
extern void	doc_list_remove(win_t *w, int num);
extern void	doc_list_show(GtkWidget *wgt, gpointer cbdata);
extern void	doc_new(win_t *parent, char *fname, bool_t update_msgbar);
extern void	doc_new_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_open_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_open_in_new_win(GtkWidget *wgt, gpointer cbdata);
#ifdef APP_GNP
extern void	doc_redraw(void *data);
extern void	doc_saveas_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_saveas_common(win_t *w);
extern void	doc_save_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_save_common(win_t *w);
extern void	doc_toggle_wrap(GtkWidget *w, gpointer data);
#endif
#if defined(WANT_PROJECT) && defined(APP_GNP)
extern void	doc_open_prj(win_t *w);
#endif	/* WANT_PROJECT */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DOC_H__ */
