/* srsxml.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"	
#include <libxml/parser.h>
#include <string.h>
#include <stdlib.h>
	
#include "srsxml.h"
#include "srsxmlapi.h"

#include "srintl.h"

/*#define SRSXML_DEBUG*/

static xmlSAXHandler  *srs_ctx;
static gint srs_priority = 0;
static gboolean srs_preempt = TRUE;

SPSParserState curr_state = SPS_IDLE;
SPSParserState prev_state = SPS_IDLE;

int unknown_depth = 0;

SRSVoice *curr_srs_voice = NULL;
SRSText  *curr_srs_text  = NULL;

static gboolean srs_xml_initialized  = FALSE;
static gboolean found		     = FALSE;			

/* __ SAX CALLBACKS ___________________________________________________________ */

void 
srs_startDocument (void *ctx)
{
	found = FALSE;
#ifdef SRSXML_DEBUG
	fprintf (stderr, "SRS: startDocument\n"); 
#endif
}

void 
srs_endDocument (void *ctx)
{
#ifdef SRSXML_DEBUG
	fprintf (stderr, "SRS: endDocument\n"); 
#endif
}

void 
srs_startElement (void           *ctx, 
		  const xmlChar  *name,
		  const xmlChar **attrs)
{	
	gchar *attr_val;
	gchar *tattr_val;

	found = FALSE;
#ifdef SRSXML_DEBUG		
	fprintf (stderr, "SRS: startElement: %s\n", name); 
#endif

	switch (curr_state)
	{
		case SPS_IDLE:
			if (g_strcasecmp ((gchar*)name, "SRSOUT") == 0)
			{
				static gboolean last_preempt = TRUE;
				static gint last_priority = -1;
				/* srs_shut_up (); */
				curr_state = SPS_OUT;
				srs_priority = 0;
				srs_preempt = TRUE;
				if (attrs)
				{
				    while (*attrs)
				    {
					if (g_strcasecmp((gchar*)*attrs, "priority") == 0)
					{
					    ++attrs;				
					    srs_priority = atoi((gchar*)*attrs);
					}
					else if (g_strcasecmp((gchar*)*attrs, "preempt") == 0)
					{
					    ++attrs;
					    srs_preempt = strcmp ((gchar*)*attrs, "true") == 0;
					}						
					++attrs;																
				    }					
				}
				if ((last_priority < srs_priority) ||
				    ((last_priority == srs_priority) && last_preempt))
				    srs_call_shut_up (srs_priority, srs_preempt);
				last_priority = srs_priority;
				last_preempt = srs_preempt;
				srs_remove (srs_priority);						
			}
			break;
		
		case SPS_OUT:
			
      if (g_strcasecmp ((gchar*)name, "SHUTUP") == 0)
			{
				curr_state = SPS_SHUT_UP;
			}								
      else if (g_strcasecmp ((gchar*)name, "PAUSE") == 0)
      {
        curr_state = SPS_PAUSE;
      }
      else if (g_strcasecmp ((gchar*)name, "RESUME") == 0)
      {
        curr_state = SPS_RESUME;
      }
			
      else if (g_strcasecmp ((gchar*)name, "TEXT") == 0)
			{
			  /* create a new SRSText object */
				curr_srs_text = srs_text_new();				
				curr_srs_text->priority = srs_priority;
				curr_srs_text->preempt = srs_preempt;
				
				/*  SRSText ATTRIBUTES */
				if (attrs)
				{
				  while (*attrs)
					{
/* 					    		fprintf (stderr, "attr_val: %s\n", *attrs); */
					  if (g_strcasecmp((gchar*)*attrs, "voice") == 0)
						{
						  ++attrs;				
							
							attr_val  = g_strdup((gchar*)*attrs);
							/* trim the attr value */
							tattr_val = g_strstrip (attr_val);

							srs_text_set_voice (curr_srs_text, tattr_val);
							
							g_free (attr_val);
						}
						
						else if (g_strcasecmp((gchar*)*attrs, "marker") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_text_set_marker (curr_srs_text, tattr_val);
							
							g_free (attr_val);	/* !!! TBR !!! potential leak? attr_val before g_strstrip ?*/
						
						}						
						else if (g_strcasecmp((gchar*)*attrs, "language") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_text_set_language (curr_srs_text, tattr_val);
							
							g_free (attr_val);	/* !!! TBR !!! potential leak? attr_val before g_strstrip ?*/
							attr_val = NULL;
						
						}						

						else if (g_strcasecmp((gchar*)*attrs, "spelling") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_text_set_spelling (curr_srs_text, tattr_val);
							
							g_free (attr_val);	/* !!! TBR !!! potential leak? attr_val before g_strstrip ?*/
							attr_val = NULL;
						
						}						

						else
						{						
							/* unsupported attribute*/
							fprintf (stderr, "The TEXT attribute \"%s\" is not supported\n", *attrs);
							++attrs;						
						}						
						
						++attrs;																
						
					}					
				}								
				curr_state = SPS_TEXT;
			}
			
			else if (g_strcasecmp((gchar*)name, "VOICE") == 0)
			{				
				
				/* create a new SRSVoice object */
				curr_srs_voice = srs_voice_new();				
			
				/* SRSVoice ATTRIBUTES*/
				if (attrs)
				{	
					while (*attrs)
					{
						/* parse the srs voice attributes */
						
						/* 
						   ID="fcstrk" 
						   TTSengine="Festival" 
						   TTSVoice="kal_diphone" 
						   priority="0" 
						   preempt="yes" 
						   rate="80" 
						   pitch="100" 
						 */
						
						if (g_strcasecmp((gchar*)*attrs, "ID") == 0)
						{
							++attrs;				
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */						
							tattr_val = g_strstrip (attr_val); 

							srs_voice_set_id (curr_srs_voice, tattr_val);
							found = srs_voice_find (&curr_srs_voice);
							
							g_free (attr_val);
						}
						
						else if (g_strcasecmp((gchar*)*attrs, "TTSEngine") == 0)
						{
							++attrs;
							
							attr_val  = g_strdup((gchar*)*attrs);
							 /* trim the attr value */
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_tts_engine_name (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "TTSVoice") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_tts_voice_name (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "priority") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_priority (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "preempt") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_preempt (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "rate") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_rate (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "pitch") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_pitch (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						
						
						else if (g_strcasecmp((gchar*)*attrs, "volume") == 0)
						{
							++attrs;
							
							attr_val = g_strdup((gchar*)*attrs);
							 /* trim the attr value */							
							tattr_val = g_strstrip (attr_val);	

							srs_voice_set_volume (curr_srs_voice, tattr_val);
							
							g_free (attr_val);
						
						}						


						else
						{						
							/* unsupported attribute */
							fprintf (stderr, "The VOICE attribute \"%s\" is not supported\n", *attrs);
							++attrs;						
						}						
						
						++attrs;
						
					}					
				
        }

				curr_state = SPS_VOICE;
			}
      else
      {
        /* unsupported SRSML tag */
        fprintf (stderr, "Unsupported SRSML tag \"%s\"\n", (gchar*)name);
      }
			
		  break;
						
		case SPS_TEXT: break;
		
		case SPS_VOICE: break;

	  case SPS_SHUT_UP: break;				

    case SPS_PAUSE: break;

    case SPS_RESUME: break;		
		
    case SPS_UNKNOWN:
			prev_state = curr_state;
			++unknown_depth;
		    break;

		default:
		    break;
	}
		
}

void srs_endElement (void *ctx, const xmlChar* name)
{


/* 	fprintf (stderr, "SRS: endElement: %s\n", name); */

	switch (curr_state)
	{
		
		case SPS_IDLE: break;
		
		case SPS_OUT:
			if (g_strcasecmp((gchar*)name, "SRSOUT") == 0)
			{
				curr_state = SPS_IDLE;
			}
			
		break;
		
		case SPS_SHUT_UP:
			
			if (g_strcasecmp((gchar*)name, "SHUTUP") == 0)
			{				
				srs_shut_up ();				
				curr_state = SPS_OUT;
			}
		  break;

    case SPS_PAUSE:
      if (g_strcasecmp ((gchar*)name, "PAUSE") == 0)
      {
        srs_pause();
        curr_state = SPS_OUT;
      }
      break;

    case SPS_RESUME:
      if (g_strcasecmp ((gchar*)name, "RESUME") == 0)
      {
        srs_resume();
        curr_state = SPS_OUT;
      }
      break;		
		
		case SPS_TEXT:
		
			if (g_strcasecmp((gchar*)name, "TEXT") == 0)
			{				
				/* speak the SRSText */
				srs_speak (curr_srs_text);
				
				/* free the srs text */
        /* !!! CHANGE !!! */
				/* srs_text_free (curr_srs_text); */
				curr_srs_text = NULL;
				
				curr_state = SPS_OUT;
			}
						
		break;
		
		case SPS_VOICE:
			
			if (g_strcasecmp((gchar*)name, "VOICE") == 0)
			{	
				/* give the SRSVoice to srspeech */
				srs_add_voice (curr_srs_voice);
				
				/* free de srs voice */
				if (!found)				
				{
				    srs_voice_free (curr_srs_voice);
				    curr_srs_voice = NULL;
				}
				curr_state = SPS_OUT;
			}
		
		break;				
				
		case SPS_UNKNOWN:
			--unknown_depth;
			if (unknown_depth <= 0)
			{
				curr_state = prev_state;
			}
		break;
		
	}

}

/* !!! TBR !!! move this into gconf / po */

static struct
{
    gchar ch;
    gchar *char_by_char;
}char_by_char_translate[] = {
	{' ',	N_("space")	},
	{'\t',	N_("tab")	},
	{'\n',	N_("new line")	},
	{'-',	N_("dash")	},
    };

/* To translators: This is the military phonetic alphabet */
static struct
{
    gchar ch;
    gchar *military;
}military_translate[] = {
	{'a', 	N_("Alpha")	},
	{'A',	N_("Alpha")	},
	{'b',	N_("Bravo")	},
	{'B',	N_("Bravo")	},
	{'c',	N_("Charlie")	},
	{'C',	N_("Charlie")	},
	{'d',	N_("Delta")	},
	{'D',	N_("Delta")	},
	{'e',	N_("Echo")	},
	{'E',	N_("Echo")	},
	{'f',	N_("Foxtrot")	},
	{'F',	N_("Foxtrot")	},
	{'g',	N_("Golf")	},
	{'G',	N_("Golf")	},
	{'h',	N_("Hotel")	},
	{'H',	N_("Hotel")	},
	{'i',	N_("India")	},
	{'I',	N_("India")	},
	{'j',	N_("Juliet")	},
	{'J',	N_("Juliet")	},
	{'k',	N_("Kilo")	},
	{'K',	N_("Kilo")	},
	{'l',	N_("Lima")	},
	{'L',	N_("Lima")	},
	{'m',	N_("Mike")	},
	{'M',	N_("Mike")	},
	{'n',	N_("November")	},
	{'N',	N_("November")	},
	{'o',	N_("Oscar")	},
	{'O',	N_("Oscar")	},
	{'p',	N_("Papa")	},
	{'P',	N_("Papa")	},
	{'q',	N_("Quebec")	},
	{'Q',	N_("Quebec")	},
	{'r',	N_("Romeo")	},
	{'R',	N_("Romeo")	},
	{'s',	N_("Sierra")	},
	{'S',	N_("Sierra")	},
	{'t',	N_("Tango")	},
	{'T',	N_("Tango")	},
	{'u',	N_("Uniform")	},
	{'U',	N_("uniform")	},
	{'v',	N_("Victor")	},
	{'V',	N_("Victor")	},
	{'w',	N_("Whiskey")	},
	{'W',	N_("Whiskey")	},
	{'x',	N_("Xray")	},
	{'X',	N_("Xray")	},
	{'y',	N_("Yankee")	},
	{'Y',	N_("Yankee")	},
	{'z',	N_("Zulu")	},
	{'Z',	N_("Zulu")	},
	{' ',	N_("space")	},
	{'\t',	N_("tab")	},
	{'\n',	N_("new line")	},
	{'-',	N_("dash")	},
    };

static gchar*
sr_speech_char_by_char_string (gchar *str)
{
    gint i, len;
    gchar *rv, *crt;
    if (!str || !str[0])
	return NULL;
    len = strlen (str);
    crt = rv = (gchar*) g_malloc ((len * (8 + 1) + 1) * sizeof (gchar));
    if (!rv)
	return NULL;
    for (i = 0; i < len; i++)
    {
	gint j;
	gboolean special = FALSE;
	for (j = 0; j < G_N_ELEMENTS (char_by_char_translate); j++)
	{
	    if (str[i] == char_by_char_translate[j].ch)
	    {
		crt = g_stpcpy (crt, _(char_by_char_translate[j].char_by_char));
		special = TRUE;
	    }
	}
	if (!special)
	{
	    *crt = str[i];
	    crt++;
	}
	*crt = ' ';
	crt++; 
    }
    *crt = '\0';
    return rv;
}

static gchar*
sr_speech_military_string (gchar *str)
{
    gint i, len;
    gchar *rv, *crt;
    if (!str || !str[0])
	return NULL;
    len = strlen (str);
    crt = rv = (gchar*) g_malloc ((len * (8 + 1) + 1) * sizeof (gchar));
    if (!rv)
	return NULL;
    for (i = 0; i < len; i++)
    {
	gint j;
	gboolean special = FALSE;
	for (j = 0; j < G_N_ELEMENTS (military_translate); j++)
	{
	    if (str[i] == military_translate[j].ch)
	    {
		crt = g_stpcpy (crt, _(military_translate[j].military));
		special = TRUE;
	    }
	}
	if (!special)
	{
	    *crt = str[i];
	    crt++;
	}
	*crt = ' ';
	crt++; 
    }
    *crt = '\0';
    return rv;
}



void srs_characters (void *ctx, const xmlChar *ch, int len)
{
	
	/* char ts[128];
	
	 int 			i;
	*/
	gchar*		tch;
	/* gchar**	tokens; */
		
	tch = g_strndup((gchar*)ch, len);	/* make out own copy */
	/* tch = g_strstrip(tch);		strip it */
	
	/* !!! TBI: !!! check the < and > case !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
	
	switch (curr_state)
	{
		
		case SPS_IDLE: break;
		case SPS_OUT: break;				
		case SPS_SHUT_UP: break;
    case SPS_PAUSE: break;
    case SPS_RESUME: break;		
		
		case SPS_TEXT:
			
			if (curr_srs_text)
			{
				/* srs_text_set_text (curr_srs_text, tch); */
				gchar *tmp = NULL;
				if (curr_srs_text->spelling)
				{
				    if (strcmp (curr_srs_text->spelling, "char") == 0)
					tmp = sr_speech_char_by_char_string (tch);
				    else if (strcmp (curr_srs_text->spelling, "military") == 0)
					tmp = sr_speech_military_string (tch);
				}
				else
				    tmp = g_strdup (tch);
				
				if (tmp)
				    srs_text_add_text(curr_srs_text, tmp);
				g_free (tmp);
			}
			
		break;
			
		case SPS_VOICE: break;
		case SPS_UNKNOWN: break;
		
	}
	
	g_free (tch);
	
}

void srs_warning (void *ctx, const char *msg, ...)
{
	
	va_list args;

	va_start (args, msg);
	g_logv ("SRSXML", G_LOG_LEVEL_WARNING, msg, args);
	va_end (args);
	/* !!! TBI !!! curr_state = SPS_IDLE*/
	
}

void srs_error (void *ctx, const char *msg, ...)
{
	
	va_list args;

	va_start (args, msg);
	g_logv ("SRSXML", G_LOG_LEVEL_CRITICAL, msg, args);
	va_end (args);
	/* !!! TBI !!! curr_state = SPS_IDLE */
	
}

void srs_fatalError (void *ctx, const char *msg, ...)
{
	
	va_list args;

	va_start (args, msg);
	g_logv ("SRSXML", G_LOG_LEVEL_ERROR, msg, args);
	va_end (args);
	/* !!! TBI !!! curr_state = SPS_IDLE */
	
}


/* __ SRSXML API ______________________________________________________________*/

int srs_xml_init (SRS_XML_INPUT_PROC InputCallbackProc)
{
/*dr s */
    gint rv = 0;
/*dr e */
	if (!srs_xml_initialized)
	{
	    xmlInitParser();
	/* initialize SAX */
/*
	ctx.startDocument = startDocument;
	ctx.endDocument = endDocument;
	ctx.startElement = startElement;
	ctx.endElement = endElement;
	ctx.characters = characters;

	ctx.warning =   my_warning;
	ctx.error = my_error;
	ctx.fatalError = my_fatalError;
*/
	    srs_ctx = g_malloc0(sizeof(xmlSAXHandler));
		
	    srs_ctx->startDocument = srs_startDocument;
	    srs_ctx->endDocument = srs_endDocument;
	    srs_ctx->startElement = srs_startElement;
	    srs_ctx->endElement = srs_endElement;
	    srs_ctx->characters = srs_characters;

	    srs_ctx->warning =   srs_warning;
	    srs_ctx->error = srs_error;
	    srs_ctx->fatalError = srs_fatalError;
/*dr s	 */
/*	    srs_initialize(); */
	    rv = srs_initialize();
/*dr e	     */
	    srs_xml_initialized = TRUE;
	}
	else
	{
            fprintf (stderr, "WARNING: srs_xml_init called more than once.\n");
	}
/*dr s	 */
/*	return 1; */
    return rv;
/*dr e */
}

void srs_xml_terminate ()
{

	if (srs_xml_initialized)
	{
	    if (srs_ctx) 
	    {
    		g_free(srs_ctx);
		srs_ctx = NULL;
	    }
	    srs_terminate();
	    srs_xml_initialized = FALSE;
	}
	else
	{
	    fprintf (stderr, "WARNING: srs_xml_terminate called more than once.\n");
	}
}

void srs_xml_output (char* buffer, int len)
{
/*	printf("\nSRS: srs_xml_output: chem xmlSAXParseMemory cu ctx: %lx, %lx\n", srs_ctx, srs_ctx->startElement);*/
/*	xmlSAXParseMemory (&ctx, buffer, len, 0);  recovery == 0???*/
	xmlSAXParseMemory (srs_ctx, buffer, len, 0); /* recovery == 0??? */
}

