#include "common.h"
#include "gnomeicu.h"
#include "listwindow.h"
#include "v7send.h"
#include "v7snac13.h"
#include "visible.h"
#include "groups.h"

static void modify_visible_list( GtkWidget *widget, gpointer data );

static gboolean is_visible (CONTACT_PTR contact);
static void remove_func (CONTACT_PTR contact);

gboolean is_visible (CONTACT_PTR contact)
{
	return contact->vis_list == TRUE;
}

void remove_func (CONTACT_PTR contact)
{
  if (contact->vis_list)
    v7_visible (contact->uin, contact->vislist_uid, FALSE);
  contact->vis_list = FALSE;
  contact->vislist_uid = 0;
}

void visible_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("GnomeICU: Visible List"), "Visible_List",
                        /*
			_("Drag the users you wish to add to your\n"
			  "visible list into this window, and then click\n"
			  "the \"Apply\" button below.")*/ NULL,
			GNOME_STOCK_BUTTON_OK, NULL,
			GTK_SIGNAL_FUNC (modify_visible_list),
			is_visible,
                        remove_func
		);
		gtk_widget_show_all( dlg );
		gtk_signal_connect( GTK_OBJECT(dlg), "destroy",
				    GTK_SIGNAL_FUNC(gtk_widget_destroyed),
				    &dlg );
	} else {
		gdk_window_show(dlg->window);
		gdk_window_raise(dlg->window);
	}
}

void modify_visible_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_visible_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		kontakt->vis_list = FALSE;
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
                  {
                    if( atoi( uin ) == kontakt->uin )
                      {
                        if (kontakt->vis_list == FALSE) {
                          v7_visible (kontakt->uin,
                                      kontakt->vislist_uid=contact_gen_uid (),
                                      TRUE); /* add */ 
                          kontakt->vis_list = TRUE;
                          
                          if (kontakt->invis_list == TRUE) {
                            v7_invisible (kontakt->uin, kontakt->invlist_uid,
                                          FALSE); /* remove */
                            kontakt->invlist_uid = 0;
                            kontakt->invis_list = FALSE;
                            
                          }                                
                        } 
                      }
                    
                    contact = contact->next;
                  }
	}
        
        
	gtk_widget_set_sensitive( widget, FALSE );
}
