/* GnomeICU
 * Copyright (C) 1998-2002 Jeremy Wise
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Functions for SNAC family 0x13, server side contacts list management
 * first created by Patrick Sung (2002)
 */

#ifndef __V7SNAC13_H__
#define __V7SNAC13_H__

#include "datatype.h"
#include "v7base.h"

extern gboolean contacts_resync;

void v7_read_contacts_list (Snac *snac, V7Connection *conn);

void v7_request_contacts_list (void);
void v7_begin_CL_edit (gboolean migrate);
void v7_end_CL_edit (void);
gboolean v7_send_contacts_list (TLVstack *t, gboolean force);
void v7_migrate_contacts_list (void);
void v7_addto_contacts_list (UIN_T uin, const gchar *nick,
			     guint group, gboolean authtlv);
void v7_send_grant_auth (UIN_T uin);
void v7_send_auth_message (UIN_T uin, const gchar *authmsg);
void v7_snac13_check_srv_ack (Snac *snac);
void v7_send_status_server (gboolean visible);
void v7_update_nickname (guint gid, guint uid, UIN_T uin,
                         const gchar *nick, gint nick_len, gboolean wait_auth);
void v7_update_group_info (guint gid);
void v7_try_add_uin (UIN_T uin, const gchar *nick, guint gid, gboolean grant);
void v7_ask_uin_for_auth (gchar *authmsg);
void v7_remove_contact (const UIN_T uin);
void v7_recv_auth_request (Snac *snac);
void v7_grant_auth_request (UIN_T uin);
void v7_user_grant_auth (Snac *snac);
void v7_visible (UIN_T uin, WORD luid, gboolean add);
void v7_invisible (UIN_T uin, WORD luid, gboolean add);
void v7_ignore (UIN_T uin, WORD luid, gboolean add);

#endif /* __V7SNAC13_H__ */
