/****************************
  New user for ICQ v6-7 protocol (Oscar)
  Olivier Crete (c) 2001
  GnomeICU
*****************************/

#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "util.h"
#include "v7newuser.h"
#include "gnomecfg.h"
#include "v7login.h"

void v7_newuser_connected (GTcpSocket *socket, GInetAddr *ia,
                   GTcpSocketConnectAsyncStatus status, V7Connection *conn);

gboolean v7_newuser_handler (GIOChannel *source, GIOCondition condition,
                           V7Connection *conn);
gboolean v7_newuser_error_handler (GIOChannel *iochannel,
                                   GIOCondition condition, V7Connection *conn);



void v7_new_user(gchar *passwd)
{

  V7Connection *conn;

#ifdef TRACE_FUNCTION
  g_print( "v7_new_user\n" );
#endif

  animate_on();

  conn = g_malloc0(sizeof(V7Connection));

  conn->gsocketasyncid = gnet_tcp_socket_connect_async( server, remote_port,
                        (GTcpSocketConnectAsyncFunc) v7_newuser_connected, conn);
  conn->status = NOT_CONNECTED;
  conn->last_reqid = 1;
  conn->cookie = g_strdup(passwd);
  otherconnections = g_slist_append(otherconnections, conn);
}
void v7_newuser_connected (GTcpSocket *socket, GInetAddr *ia,
              GTcpSocketConnectAsyncStatus status, V7Connection *conn)
{

#ifdef TRACE_FUNCTION
  g_print( "v7_newuser_connected\n" );
#endif


  if (status != GTCP_SOCKET_CONNECT_ASYNC_STATUS_OK) {

    g_free(conn);

    Current_Status = STATUS_OFFLINE;
    ready_set();
    animate_off();
    gnome_warning_dialog(_("Can't connect to server\n Adding new user failed"));
    return;
  }

  conn->gsocket = socket;
  
  conn->status = CONNECTING;

  conn->iochannel = gnet_tcp_socket_get_iochannel (socket);
  
  conn->in_watch = g_io_add_watch ( conn->iochannel, G_IO_IN|G_IO_PRI,
                   (GIOFunc) v7_newuser_handler, conn);
  conn->err_watch = g_io_add_watch ( conn->iochannel,
                                     G_IO_ERR|G_IO_HUP|G_IO_NVAL,
                                     (GIOFunc) v7_newuser_error_handler, conn);
}
  
gboolean v7_newuser_error_handler (GIOChannel *iochannel,
                                   GIOCondition condition, V7Connection *conn)
{
#ifdef TRACE_FUNCTION
  g_print( "v7_newuser_error_handler\n" );
#endif

  return FALSE; /* not sure what to return -- menesis */
}

gboolean v7_newuser_handler (GIOChannel *iochannel, GIOCondition condition,
                     V7Connection *conn)
{
  V7Packet *packet;
  Snac *snac;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_newuser_handler\n" );
#endif


  /* If we dont have the whole packet stop here */
  if ((packet = read_flap(conn)) == NULL)
    return TRUE;

  
  if (packet->channel == 1 &&
      packet->len == 4  &&
      packet->data[0] == packet->data[1] == packet->data[2] == 0 &&
      packet->data[3] == 1) {
    
    gchar buffer[4] = "\0\0\0\01";
    gchar buffer2[44] = "\0\x01\0\0" "\0\0\0\0" "\x28\0\x03\0" "\0\0\0\0"
      "\0\0\0\0" "\x03\x46\0\0" "\x03\x46\0\0" "\0\0\0\0" "\0\0\0\0"
      "\0\0\0\0" "\0\0\0\0" ;
    gchar buffer3[8] = "\x03\x46\0\0" "\0\0\xCF\x01";
    gchar *finalbuffer;
      
    if (! flap_send(conn, CHANNEL_NEWCONN, buffer, 4))
      conn->status = BROKEN;
    
    /* The desired password is stored in conn->cookie */
    
    buffer2[3] = 0x33+strlen(conn->cookie);

    finalbuffer = g_malloc0(44+2+strlen(conn->cookie)+1+8);
    
    g_memmove(finalbuffer, buffer2, 44);
    
    Word_2_Chars(finalbuffer+44, strlen(conn->cookie)+1);
    
    g_memmove(finalbuffer+46, conn->cookie, strlen(conn->cookie)+1);
    g_memmove(finalbuffer+46+strlen(conn->cookie)+1, buffer3, 8);

    snac_send(conn, finalbuffer, 46+strlen(conn->cookie)+1+8,
              FAMILY_17_NEW_USER, F17_CLIENT_REG_USER, NULL, ANY_ID);
    
  } else if (packet->channel == 2) {
    snac = read_snac(packet);
    
    if (snac->family == FAMILY_17_NEW_USER &&
        snac->type == F17_SERVER_ACK_NEW_USER ) {

      our_info->uin = Chars_2_DW(snac->data+46);
      passwd = conn->cookie;

      save_preferences();

      g_source_remove(conn->in_watch);
      gnet_tcp_socket_delete(conn->gsocket);
      otherconnections = g_slist_remove(otherconnections, conn);
      g_free(conn);

      animate_off();

      v7_new_login_session();

    } else {
          g_warning("Bizzare things happened, we dont have the right snac!\n");
          return TRUE;
    }  
  } else {
        g_warning("Something very abnormal hapenned\n");
  }  
  
  return TRUE;
}

