#include "common.h"
#include "changenick.h"
#include "detach.h"
#include "dirbrowser.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "history.h"
#include "icons.h"
#include "personal_info.h"
#include "response.h"
#include "sendcontact.h"
#include "showlist.h"
#include "tcp.h"
#include "user_popup.h"
#include "v7send.h"
#include "v7snac13.h"
#include "groups.h"

static void icq_sendmessage_window_from_menu( GtkWidget *widget, gpointer data );
static void send_url_window_default( GtkWidget *widget, gpointer data );
static void get_contact_list (GtkWidget *widget, gpointer data);
static void request_chat( GtkWidget *widget, gpointer data);
static void request_file_from_menu (GtkWidget *widget, gpointer data);
static void retrieve_away_message( GtkWidget *widget, gpointer data );
static void add_user_to_list( GtkWidget *widget, gpointer data );
static void authorize_uin( GtkWidget *widget, gpointer data );
static void remove_user_question( GtkWidget *widget, gpointer data );
static void lists_change_list_ignore (GtkWidget *widget, gpointer data);
static void lists_change_list_visible (GtkWidget *widget, gpointer data);
static void lists_change_list_invisible (GtkWidget *widget, gpointer data);
static void lists_change_list_notify (GtkWidget *widget, gpointer data);
static void lists_change_list( GtkWidget *widget, gpointer data, gint type );
static void add_files( GtkWidget *widget, gpointer data);
static void remove_files( GtkWidget *widget, gpointer data);
static void add_files_final( gchar *text, gpointer user_data );
static void remove_user (GtkWidget *widget, gpointer data);

GtkWidget *user_popup (CONTACT_PTR contact)
{
	GtkWidget *personal_menu, *lists_menu;

	GtkWidget *pm, *item_box, *item_label;
	GtkWidget *item;
	gchar *uinstr;

#ifdef TRACE_FUNCTION
	g_print( "user_popup\n" );
#endif

	personal_menu = gtk_menu_new ();

	uinstr = g_strdup_printf ("%u", contact->uin);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (uinstr);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_label);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_widget_show (item);
	g_free (uinstr);

	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_widget_show (item);

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_message_pixmap, icon_message_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  Message..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (icq_sendmessage_window_from_menu),
			    contact);
	gtk_widget_show (item);

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_url_pixmap, icon_url_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  URL..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (send_url_window_default), contact);
	gtk_widget_show (item);

        item_box = gtk_hbox_new (FALSE, 0);
        pm = gtk_pixmap_new (icon_contact_pixmap, icon_contact_bitmap);
        gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
        gtk_widget_show (pm);
        item = gtk_menu_item_new ();
        item_label = gtk_label_new (_("  Contact List..."));
        gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE,
                            FALSE, 0);
        gtk_widget_show (item_label);
        gtk_container_add (GTK_CONTAINER (item), item_box);
        gtk_widget_show (item_box);
        gtk_menu_append (GTK_MENU (personal_menu), item);
        gtk_signal_connect (GTK_OBJECT (item), "activate",
                            GTK_SIGNAL_FUNC (get_contact_list), contact);
        gtk_widget_show (item);

	/*

	if (contact->status != STATUS_OFFLINE) {
		item_box = gtk_hbox_new (FALSE, 0);
		pm = gtk_pixmap_new (icon_chat_pixmap, icon_chat_bitmap);
		gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
		gtk_widget_show (pm);
		item = gtk_menu_item_new ();
		item_label = gtk_label_new (_("  Chat Request..."));
		gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE,
				    FALSE, 0);
		gtk_widget_show (item_label);
		gtk_container_add (GTK_CONTAINER (item), item_box);
		gtk_widget_show (item_box);
		gtk_menu_append (GTK_MENU (personal_menu), item);
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (request_chat), contact);
		gtk_widget_show (item);

		item_box = gtk_hbox_new (FALSE, 0);
		pm = gtk_pixmap_new (icon_file_pixmap, icon_file_bitmap);
		gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
		gtk_widget_show (pm);
		item = gtk_menu_item_new ();
		item_label = gtk_label_new (_("  File Request..."));
		gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE,
				    FALSE, 0);
		gtk_widget_show (item_label);
		gtk_container_add (GTK_CONTAINER (item), item_box);
		gtk_widget_show (item_box);
		gtk_menu_append (GTK_MENU (personal_menu), item);
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (request_file_from_menu), contact);
		gtk_widget_show (item);
	}

	*/

	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_widget_show (item);

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_info_pixmap, icon_info_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  User Info..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (show_personal_info), contact);
	gtk_widget_show (item);

	if ((contact->status & 0xffff) != STATUS_ONLINE &&
	    contact->status != STATUS_OFFLINE &&
	    (contact->status & 0xffff) != STATUS_INVISIBLE &&
	    (contact->status & 0xffff) != STATUS_FREE_CHAT) {
		item_box = gtk_hbox_new (FALSE, 0);
		pm = gtk_pixmap_new (get_pixmap_for_status (contact->status),
				     get_bitmap_for_status (contact->status));
		gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
		gtk_widget_show (pm);
		item = gtk_menu_item_new ();
		switch (contact->status & 0xffff) {
		case STATUS_AWAY:
			item_label = gtk_label_new (_("  Read Away Message"));
			break;
		case STATUS_NA:
			item_label = gtk_label_new (_("  Read N/A Message"));
			break;
		case STATUS_OCCUPIED:
			item_label =
			    gtk_label_new (_("  Read Occupied Message"));
			break;
		case STATUS_DND:
			item_label =
			    gtk_label_new (_("  Read Do not Disturb Message"));
			break;
		default:
			item_label = gtk_label_new (_("  Read Away Message"));
			break;
		}

		gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE,
				    FALSE, 0);
		gtk_widget_show (item_label);
		gtk_container_add (GTK_CONTAINER (item), item_box);
		gtk_widget_show (item_box);
		gtk_menu_append (GTK_MENU (personal_menu), item);
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (retrieve_away_message),
				    contact);
		gtk_widget_show (item);
	}

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_hist_pixmap, icon_hist_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  History..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (history_display), contact);
	gtk_widget_show (item);

	/* Lists menu */
	lists_menu = gtk_menu_new ();

	/* On ignore list... */
	item = gtk_check_menu_item_new_with_label (_("On Ignore List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->ignore_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_menu_append (GTK_MENU (lists_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "toggled",
			    GTK_SIGNAL_FUNC (lists_change_list_ignore),
			    contact);
	gtk_widget_show (item);

	/* On visible list... */
	item = gtk_check_menu_item_new_with_label (_("On Visible List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->vis_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_menu_append (GTK_MENU (lists_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "toggled",
			    GTK_SIGNAL_FUNC (lists_change_list_visible),
			    contact);
	gtk_widget_show (item);

	/* On invisible list... */
	item = gtk_check_menu_item_new_with_label (_("On Invisible List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->invis_list);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_menu_append (GTK_MENU (lists_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "toggled",
			    GTK_SIGNAL_FUNC (lists_change_list_invisible),
			    contact);
	gtk_widget_show (item);

	/* On online notify list... */
	item = gtk_check_menu_item_new_with_label (_("On Notify List"));
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item),
					contact->online_notify);
	gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (item), TRUE);
	gtk_menu_append (GTK_MENU (lists_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "toggled",
			    GTK_SIGNAL_FUNC (lists_change_list_notify),
			    contact);
	gtk_widget_show (item);

	/* End Lists Menu */

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_info_pixmap, icon_info_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  Lists"));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), lists_menu);
	gtk_widget_show (item);

	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_widget_show (item);

	/* Detach/Attach user */
        
	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_auth_pixmap, icon_auth_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	if (GTK_IS_WIDGET (contact->detached_window)
	    && GTK_WIDGET_VISIBLE (contact->detached_window))
		item_label = gtk_label_new (_("  Hide shortcut"));
	else
		item_label = gtk_label_new (_("  Show shortcut"));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	if (GTK_IS_WIDGET (contact->detached_window))
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (detach_contact_hide),
				    contact);
	else
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (detach_contact), contact);

	gtk_widget_show (item);

	/* Separator */
	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_widget_show (item);

	if (contact->inlist == FALSE) {
		item_box = gtk_hbox_new (FALSE, 0);
		pm = gtk_pixmap_new (icon_auth_pixmap, icon_auth_bitmap);
		gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
		gtk_widget_show (pm);
		item = gtk_menu_item_new ();
		item_label = gtk_label_new (_("  Add To List"));
		gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE,
				    FALSE, 0);
		gtk_widget_show (item_label);
		gtk_container_add (GTK_CONTAINER (item), item_box);
		gtk_widget_show (item_box);
		gtk_menu_append (GTK_MENU (personal_menu), item);
		gtk_signal_connect (GTK_OBJECT (item), "activate",
				    GTK_SIGNAL_FUNC (add_user_to_list), contact);
		gtk_widget_show (item);

		item = gtk_menu_item_new ();
		gtk_widget_set_sensitive (item, FALSE);
		gtk_menu_append (GTK_MENU (personal_menu), item);
		gtk_widget_show (item);
	}

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_auth_pixmap, icon_auth_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  Authorize User"));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (authorize_uin), contact);
	gtk_widget_show (item);

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_rename_pixmap, icon_rename_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  Rename User..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (change_nick_window), contact);
	gtk_widget_show (item);

	item_box = gtk_hbox_new (FALSE, 0);
	pm = gtk_pixmap_new (icon_cancel_pixmap, icon_cancel_bitmap);
	gtk_box_pack_start (GTK_BOX (item_box), pm, FALSE, FALSE, 0);
	gtk_widget_show (pm);
	item = gtk_menu_item_new ();
	item_label = gtk_label_new (_("  Remove User..."));
	gtk_box_pack_start (GTK_BOX (item_box), item_label, FALSE, FALSE, 0);
	gtk_widget_show (item_label);
	gtk_container_add (GTK_CONTAINER (item), item_box);
	gtk_widget_show (item_box);
	gtk_menu_append (GTK_MENU (personal_menu), item);
	gtk_signal_connect (GTK_OBJECT (item), "activate",
			    GTK_SIGNAL_FUNC (remove_user_question), contact);
	gtk_widget_show (item);

	return personal_menu;
}

static void icq_sendmessage_window_from_menu( GtkWidget *widget, gpointer data )
{
	GdkEventButton *event;
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window_from_menu\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	event = g_new0( GdkEventButton, 1 );
	event->type = GDK_KEY_PRESS;
	((GdkEventKey*)event)->keyval = GDK_Return;

	icq_sendmessage_window( MainData->lb_userwin, event, contact );

	g_free( event );
}

static void send_url_window_default( GtkWidget *widget, gpointer data )
{
	gtk_object_set_data (GTK_OBJECT (widget), "contact", data);
	send_url_window( widget, "" );
}

static void get_contact_list( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "get_contact_list\n" );
#endif

	if( data == NULL )
		return;

	contact_list_window( data );
}

static void request_chat( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox1;
	GtkWidget *label9;
	GtkWidget *scrolledwindow2;
	GtkWidget *text2;
	GtkWidget *button6;
	GtkWidget *hbox6 = NULL;
	GtkWidget *label7;
	GtkWidget *menuitem;
	GtkWidget *optionmenu;
	GtkWidget *optionmenu_menu = NULL;

	GSList *contact;

	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "request_chat\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	window = gnome_dialog_new (_("GnomeICU: Chat Request"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Chat_Request", "GnomeICU");
	gtk_window_set_default_size (GTK_WINDOW (window), 250, 210);
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

        set_window_icon( window, "gnomeicu-chat.png" );

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Send Chat Request to %s:\n\nReason:"),
	                       kontakt->nick );

	label9 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (vbox1), label9, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text2 = gtk_text_new (NULL, NULL);
	gtk_widget_show (text2);
	GTK_WIDGET_SET_FLAGS (text2, GTK_CAN_FOCUS);
	gtk_text_set_word_wrap( GTK_TEXT( text2 ), TRUE );
	gtk_text_set_editable( GTK_TEXT( text2 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);

	if (Sessions != NULL)
	{
	     GSList *gslcsession;
	     GSList *member_cc;

	     hbox6 = gtk_hbox_new(FALSE, 0);
	     gtk_box_pack_start (GTK_BOX (vbox1), hbox6,  TRUE, TRUE, 0);
	     label7 = gtk_label_new(_("Invite to session: "));
	     gtk_box_pack_start (GTK_BOX (hbox6), label7,  TRUE, TRUE, 0);
	     optionmenu = gtk_option_menu_new();
	     gtk_box_pack_start (GTK_BOX (hbox6), optionmenu,  TRUE, TRUE, 0);
	     optionmenu_menu = gtk_menu_new();
	     gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), optionmenu_menu);

	     for (gslcsession = Sessions;
		  gslcsession != NULL;
		  gslcsession = gslcsession->next)
	     {
		  GString *sessionname;
		  sessionname = g_string_new(our_info->nick);
		  for (member_cc = ((ChatSession *)gslcsession->data)->members;
		       member_cc != NULL;
		       member_cc = member_cc->next)
		  {
		       g_string_sprintfa(sessionname, ", %s", ((ChatContact *)member_cc->data)->contact->nick);

		  }
		  menuitem = gtk_menu_item_new_with_label(sessionname->str);
		  g_string_free (sessionname, TRUE);
		  gtk_menu_append(GTK_MENU (optionmenu_menu), menuitem);
		  gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", gslcsession->data);
	     }

	     menuitem = gtk_menu_item_new_with_label("None");
	     gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", NULL);
	     gtk_menu_prepend(GTK_MENU(optionmenu_menu), menuitem);
	     gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),0);
	     gtk_widget_show_all (hbox6);

	}

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
	                                        _("Send"),
						GNOME_STOCK_PIXMAP_JUMP_TO);
	button6 = g_list_last (GNOME_DIALOG (window)->buttons)->data;

	gtk_object_set_data (GTK_OBJECT (button6), "OptionMenu",
			     GTK_IS_HBOX (hbox6) ? optionmenu_menu : NULL);
	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
	                    GTK_SIGNAL_FUNC (send_chat_request),
	                    text2);

	gnome_dialog_append_button (GNOME_DIALOG (window),
				    GNOME_STOCK_BUTTON_CLOSE);

	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);
	gnome_dialog_set_default (GNOME_DIALOG (window), 0);

	gtk_window_set_focus (GTK_WINDOW (window), text2);
	gnome_dialog_editable_enters (GNOME_DIALOG (window),
				      GTK_EDITABLE (text2));

	gtk_widget_show (window);
}

static void request_file_from_menu (GtkWidget *widget, gpointer data)
{
	request_file (widget, NULL, data);
}

void request_file( GtkWidget *widget, GList *files, gpointer data )
{
	GSList *contact;

        GList *file;

	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label3;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *filelist;
	GtkWidget *label2;
	GtkWidget *scrolledwindow2;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *button1;
	GtkWidget *addbutton;
	GtkWidget *removebutton;

	gchar *str, *filenames[1];

#ifdef TRACE_FUNCTION
	g_print( "request_file\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;


	window = gnome_dialog_new (_("GnomeICU: Send File"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Send_File", "GnomeICU");
	gtk_window_set_default_size( GTK_WINDOW( window ), 350, 250 );
	gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

        set_window_icon( window, "gnomeicu-file.png" );

	dialog_vbox1 = GNOME_DIALOG (window)->vbox;

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Send File to %s:"), kontakt->nick );

	label3 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox1);

	label1 = gtk_label_new (_("Files:"));
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	filelist = gtk_clist_new(1);

	gtk_clist_set_selection_mode(GTK_CLIST(filelist), GTK_SELECTION_EXTENDED);
        for ( file = files; file; file = file->next )
        {
            char *data = file->data;

            /* Since its a file, we can strip the protocol type */
            if (strncmp (data, "file:", 5) == 0)
                data += 5;

            filenames[0] = data;
            gtk_clist_append(GTK_CLIST(filelist), filenames);
        }
	gtk_widget_show (filelist);

	gtk_container_add (GTK_CONTAINER (scrolledwindow2), filelist);

	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

	addbutton = gtk_button_new_with_label(_("Add files..."));
	gtk_widget_show (addbutton);
	gtk_box_pack_end (GTK_BOX (hbox1), addbutton, FALSE, FALSE, 3);

	removebutton = gtk_button_new_with_label(_("Remove files"));
	gtk_widget_show (removebutton);
	gtk_box_pack_end (GTK_BOX (hbox1), removebutton, FALSE, FALSE, 3);

	label2 = gtk_label_new (_("Reason:"));
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text1 = gtk_text_new (NULL, NULL);
	gtk_widget_show (text1);
	gtk_text_set_word_wrap( GTK_TEXT( text1 ), TRUE );
	gtk_text_set_editable( GTK_TEXT( text1 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
						_("Send"),
						GNOME_STOCK_PIXMAP_JUMP_TO);
	button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;

	gtk_object_set_data (GTK_OBJECT (button1), "reason", text1);
	gtk_object_set_data (GTK_OBJECT (button1), "uin",
			     GINT_TO_POINTER (kontakt->uin));
	gtk_object_set_data (GTK_OBJECT (button1), "filelist", filelist);

	gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		GTK_SIGNAL_FUNC (send_file_request), NULL); 

	gtk_signal_connect (GTK_OBJECT (addbutton), "clicked",
			    GTK_SIGNAL_FUNC (add_files), filelist);
	gtk_signal_connect (GTK_OBJECT (removebutton), "clicked",
			    GTK_SIGNAL_FUNC (remove_files), filelist);

	gnome_dialog_append_button (GNOME_DIALOG (window),
				    GNOME_STOCK_BUTTON_CLOSE);

	gnome_dialog_editable_enters (GNOME_DIALOG (window),
				      GTK_EDITABLE (text1));

	gnome_dialog_set_default (GNOME_DIALOG (window), 0);
	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

	gtk_widget_show (window);
}

static void retrieve_away_message( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "retrieve_away_message\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	kontakt->show_again = TRUE;

        /* trillian reports version 0, does it do away messages?*/
        if (kontakt->version >= 8 || kontakt->version == 0)
          v7_request_away_msg(kontakt->uin, kontakt->status);
        else
          TCPRetrieveAwayMessage( contact, NULL );
}

static void add_user_to_list( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "add_user_to_list\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	kontakt->inlist = TRUE;
	Show_Quick_Status_lower( UPDATE_NOTLIST |
	                         ( kontakt->status == STATUS_OFFLINE ? UPDATE_OFFLINE : UPDATE_ONLINE ),
	                         NULL );
	v7_try_add_uin (kontakt->uin, kontakt->nick, groups_find_gid_by_name ("General"), FALSE);

	Save_RC();
}

static void authorize_uin( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "authorize_uin\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

        v7_grant_auth( kontakt->uin ); 
}

static void remove_user_question( GtkWidget *widget, gpointer data )
{
	GtkWidget *rmcontact_dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *label;
	GtkWidget *remhist_button;
	GtkWidget *yes_button;

	GSList *contact;
	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "remove_user_question\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

	rmcontact_dialog = gnome_dialog_new (_("GnomeICU: Remove Contact"),
					     GNOME_STOCK_BUTTON_YES,
					     GNOME_STOCK_BUTTON_NO,
					     NULL);
	gtk_window_set_wmclass (GTK_WINDOW (rmcontact_dialog), "Remove_Contact", "GnomeICU");
	gtk_window_set_policy (GTK_WINDOW (rmcontact_dialog), FALSE, FALSE, TRUE);

	dialog_vbox1 = GNOME_DIALOG (rmcontact_dialog)->vbox;

	str = g_strdup_printf( _("Are you sure you wish to remove\n%s from your contact list?\n"),
	                       kontakt->nick );
	label = gtk_label_new ( str );
	g_free( str );
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), label, FALSE, FALSE, 0);

	remhist_button = gtk_check_button_new_with_label (_("Remove User's History file"));
	gtk_widget_show (remhist_button);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), remhist_button, FALSE, FALSE, 0);

	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( remhist_button ), TRUE );

	yes_button = GNOME_DIALOG (rmcontact_dialog)->buttons->data;

	gtk_object_set_data (GTK_OBJECT (yes_button), "contact", contact);

	gtk_signal_connect (GTK_OBJECT (yes_button), "clicked",
	                    GTK_SIGNAL_FUNC (remove_user),
	                    remhist_button);
	gnome_dialog_set_close (GNOME_DIALOG (rmcontact_dialog), TRUE);

	gtk_widget_show (rmcontact_dialog);
}

static void lists_change_list_ignore (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 0);
}

static void lists_change_list_visible (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 1);
}

static void lists_change_list_invisible (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 2);
}

static void lists_change_list_notify (GtkWidget *widget, gpointer data)
{
	lists_change_list (widget, data, 3);
}

static void lists_change_list( GtkWidget *widget, gpointer data, gint type )
{
    CONTACT_PTR contact;
    /*gint method = 0;
    GtkWidget *dialog;
    gchar *msg;*/

#ifdef TRACE_FUNCTION
    g_print( "lists_change_lists" );
#endif

    contact = data;

    switch(type)
    {
    case 0: /* ignore list */
      if ( contact->ignore_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->ignore_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->ignore_list) {
          v7_ignore (contact->uin, contact->ignorelist_uid = contact_gen_uid (),
                      TRUE); /* add */
        } else {
          v7_ignore (contact->uin, contact->ignorelist_uid, FALSE); /* remove */
        }
      }
      break;
    case 1: /* visible list */
      if ( contact->vis_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->vis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->vis_list) {
          v7_visible (contact->uin, contact->vislist_uid = contact_gen_uid (),
                      TRUE); /* add */
        } else {
          v7_visible (contact->uin, contact->vislist_uid, FALSE); /* remove */
        }
      }
      break;
    case 2: /* invisible list */
      if ( contact->invis_list != GTK_CHECK_MENU_ITEM( widget )->active) {
        contact->invis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        if (contact->invis_list) {
          v7_invisible (contact->uin, contact->invlist_uid = contact_gen_uid (),
                        TRUE); /* add */
        } else {
          v7_invisible (contact->uin, contact->invlist_uid, FALSE); /* remove */
        }
      }
      break;
    case 3:
        contact->online_notify = GTK_CHECK_MENU_ITEM( widget )->active;
        break;
    }
}

static void add_files( GtkWidget *widget, gpointer data)
{
	create_filebrowser(add_files_final, data);
}

static void remove_files( GtkWidget *widget, gpointer data)
{
	GList *selected;

	while ((selected = GTK_CLIST(data)->selection))
		gtk_clist_remove(GTK_CLIST(data), GPOINTER_TO_INT(selected->data) );
}

static void add_files_final( gchar *add_text, gpointer user_data )
{
	gchar *text[1];

	text[0] = add_text;

	gtk_clist_append(GTK_CLIST(user_data), text);
}

void remove_user( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "remove_user\n" );
#endif

	contact = gtk_object_get_data (GTK_OBJECT (widget), "contact");
	if( contact == NULL )
		return;

        /* remove the user from status lists, if she is on any of them */
        if (kontakt->vis_list)
          v7_visible (kontakt->uin, kontakt->vislist_uid, FALSE);
        if (kontakt->invis_list)
          v7_invisible (kontakt->uin, kontakt->invlist_uid, FALSE);
        if (kontakt->ignore_list)
          v7_ignore (kontakt->uin, kontakt->ignorelist_uid, FALSE);

        /* remove user */
	if (kontakt->inlist == TRUE)
		v7_remove_contact (kontakt->uin);
	remove_contact (kontakt->uin, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data)));
}
