#include "common.h"
#include "gtkfunc.h"
#include "groups.h"
#include "search.h"
#include "showlist.h"
#include "util.h"
#include "v7send.h"
#include "v7snac13.h"

void clear_search (GtkButton *button, gpointer user_data);
void execute_search (GtkButton *button, gpointer user_data);
void add_from_search (GtkButton *button, gpointer user_data);

typedef struct {
	GtkWidget *search_dlg;
	GtkWidget *search_uin;
	GtkWidget *search_nick;
	GtkWidget *search_first;
	GtkWidget *search_last;
	GtkWidget *search_email;
} SearchWidgets;

SearchWidgets search_widgets;

void search_window( GtkWidget *widget, gpointer data )
{
	GladeXML *xml;

	xml = glade_xml_new (GNOMEICU_GLADEDIR "addcontact.glade", "dlg_add_contact");
	if (!xml) {
		gnome_dialog_run (GNOME_DIALOG (gnome_message_box_new (
		                  _("Unable to load Add Contact interface!"),
	                          GNOME_MESSAGE_BOX_ERROR,
		                  GNOME_STOCK_BUTTON_OK,
	                          NULL)));
		return;
	}

	search_widgets.search_dlg = glade_xml_get_widget (xml, "dlg_add_contact");
	search_widgets.search_uin = glade_xml_get_widget (xml, "search_uin");
	search_widgets.search_nick = glade_xml_get_widget (xml, "search_nick");
	search_widgets.search_first = glade_xml_get_widget (xml, "search_first");
	search_widgets.search_last = glade_xml_get_widget (xml, "search_last");
	search_widgets.search_email = glade_xml_get_widget (xml, "search_email");
	found_list = glade_xml_get_widget (xml, "found_list");

	glade_xml_signal_autoconnect (xml);
	gtk_widget_show_all (search_widgets.search_dlg);
}

void clear_search (GtkButton *button, gpointer user_data)
{
	SearchWidgets *sw;

	sw = &search_widgets;
	gtk_entry_set_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_uin))), "");
	gtk_entry_set_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_nick))), "");
	gtk_entry_set_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_first))), "");
	gtk_entry_set_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_last))), "");
	gtk_entry_set_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_email))), "");
}

void execute_search (GtkButton *button, gpointer user_data)
{
	SearchWidgets *sw = &search_widgets;
	UIN_T uin;
	gchar *nick, *first, *last, *email;

	uin = atoi (gtk_entry_get_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_uin)))));
	nick = g_strdup (gtk_entry_get_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_nick)))));
	first = g_strdup (gtk_entry_get_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_first)))));
	last = g_strdup (gtk_entry_get_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_last)))));
	email = g_strdup (gtk_entry_get_text (GTK_ENTRY (gnome_entry_gtk_entry (GNOME_ENTRY (sw->search_email)))));

	gtk_clist_clear (GTK_CLIST (found_list));

	if (uin)
		v7_findbyuin (uin);

	if (nick && first && last &&
	    (strlen (nick) || strlen (first) || strlen (last)))
		v7_findbyname (nick, first, last);

	if (email && strlen (email))
		v7_findbyemail (email);
}

void add_from_search (GtkButton *button, gpointer user_data)
{
  GtkCList *clist = NULL;
  gint row;
  gchar *str;
  UIN_T uin;
  gchar *nick;

  if (found_list)
    clist = GTK_CLIST (found_list);

  if (!clist || !clist->selection)
    return;

  row = GPOINTER_TO_INT (clist->selection->data);
  gtk_clist_get_text (clist, row, 1, &str);
  uin = atoi (str);

  if (Find_User(uin) != NULL)
	  return;

  gtk_clist_get_text (clist, row, 2, &nick);

  v7_try_add_uin (uin, nick, groups_find_gid_by_name ("General"), FALSE);
}
