/************************************
 Personal contact information
 (c) 1999 Jeremy Wise
 GnomeICU
*************************************/

#include "common.h"
#include "changenick.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "personal_info.h"
#include "showlist.h"
#include "util.h"
#include "v7send.h"

void show_personal_info (GtkWidget *widget, gpointer data)
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "show_personal_info\n" );
#endif

	contact = Contacts;
	while (contact != NULL && contact->data != data)
		contact = contact->next;

	if( contact == NULL )
		return;

        v7_request_info(kontakt->uin);

	dump_personal_info( kontakt->uin );
}

void dump_personal_info( UIN_T uin )
{
	GladeXML *xml;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "dump_personal_info\n" );
#endif

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	if (kontakt->info_dlg_xml)
		xml = kontakt->info_dlg_xml;
	else {
		xml = kontakt->info_dlg_xml = glade_xml_new (GNOMEICU_GLADEDIR "user_info.glade", "userinfo_dialog");
		gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (xml, "refresh_button")), "uin", GINT_TO_POINTER(uin));
		gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (xml, "close_button")), "dlg",
		                                 glade_xml_get_widget (xml, "userinfo_dialog"));
		glade_xml_signal_autoconnect (xml);
	}

	gtk_widget_show_all (glade_xml_get_widget (xml, "userinfo_dialog"));

	update_personal_info(uin);
}

void update_personal_info ( UIN_T uin )
{

  GSList *contact;
  gchar *string = NULL;
  gchar datebuf[30];
  GDate *date;

#ifdef TRACE_FUNCTION
	g_print( "update_personal_info\n" );
#endif

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	if (atoi (kontakt->nick) == kontakt->uin &&
	    kontakt->info->nick && kontakt->info->nick[0] != '\0') {
		strncpy (kontakt->nick, kontakt->info->nick, sizeof (kontakt->nick));
		Show_Quick_Status_lower (UPDATE_ONLINE | UPDATE_OFFLINE | UPDATE_NOTLIST, NULL);
	}

	if (kontakt->info_dlg_xml == NULL)
		return;

        if (kontakt->info->ip)
          g_free(kontakt->info->ip);
        if (kontakt->info->port)
          g_free(kontakt->info->port);

	if( kontakt->has_direct_connect)
	{
		kontakt->info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (kontakt->current_ip >> 24),
		         (BYTE) (kontakt->current_ip >> 16),
		         (BYTE) (kontakt->current_ip >> 8),
		         (BYTE) (kontakt->current_ip) );
		kontakt->info->port = g_strdup_printf( "%u", kontakt->port );
	}
	else
	{
		kontakt->info->ip = g_strdup( _("N/A") );
		kontakt->info->port = g_strdup( _("N/A") );
	}

        if (kontakt->info->version == NULL)
          kontakt->info->version = g_strdup_printf("%d", kontakt->version);

	g_free( kontakt->info->status );
	kontakt->info->status = g_strdup_printf( "%08X (%s)",
	                                         kontakt->status,
	                                         get_status_str( kontakt->status ) );

	if( kontakt->info->nick != NULL ) {
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "nick_entry")), kontakt->info->nick);
	}

	if( kontakt->info->first != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "fname_entry")), kontakt->info->first);

	if( kontakt->info->last != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "lname_entry")), kontakt->info->last);

	if( kontakt->info->sex == MALE )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "sex_entry")), _("Male"));
	else if( kontakt->info->sex == FEMALE )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "sex_entry")), _("Female"));
	else
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "sex_entry")), _("Unknown"));

	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "age_entry")),
	             (string = kontakt->info->age
			     ? g_strdup_printf( "%d", kontakt->info->age % 1000 )
			     : g_strdup( _("Unknown") )));
	g_free( string );

	string = g_strdup_printf ("%d", kontakt->uin);
	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "uin_entry")), string);
	g_free (string);

	if( kontakt->info->auth )
          gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "auth_entry")), _("Required"));
        else
          gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "auth_entry")), _("Not required"));

	if( kontakt->info->ip != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "ip_entry")), kontakt->info->ip);

	if( kontakt->info->port != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "port_entry")), kontakt->info->port);

	if (kontakt->version) {
		string = g_strdup_printf ("%d", kontakt->version);
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "protocol_entry")), string);
		g_free (string);
	}

	if( kontakt->info->status != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "status_entry")), kontakt->info->status);

	if( kontakt->info->email != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "email_entry")), kontakt->info->email);

	if( kontakt->info->phone != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "phone_entry")), kontakt->info->phone);

	if( kontakt->info->fax != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "fax_entry")), kontakt->info->fax);

	if( kontakt->info->homepage != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "homepage_entry")), kontakt->info->homepage);

	if( kontakt->info->about != NULL )
	{
		gtk_text_freeze( GTK_TEXT( glade_xml_get_widget (kontakt->info_dlg_xml, "about_text") ) );
		gtk_editable_delete_text (GTK_EDITABLE (glade_xml_get_widget (kontakt->info_dlg_xml, "about_text")), 0, -1);
		gtk_text_insert( GTK_TEXT( glade_xml_get_widget (kontakt->info_dlg_xml, "about_text") ), NULL, NULL, NULL,
		                 kontakt->info->about, -1 );
		gtk_text_thaw( GTK_TEXT( glade_xml_get_widget (kontakt->info_dlg_xml, "about_text") ) );
	}

	if( kontakt->info->job_pos != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_position_entry")), kontakt->info->job_pos);

	if( kontakt->info->department != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_department_entry")), kontakt->info->department);

	if( kontakt->info->company_name != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_company_entry")), kontakt->info->company_name);

	if( kontakt->info->work_address != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_street_entry")), kontakt->info->work_address);

	if( kontakt->info->work_city != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_city_entry")), kontakt->info->work_city);

	if( kontakt->info->work_state != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_state_entry")), kontakt->info->work_state);

	if( kontakt->info->work_homepage != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_homepage_entry")), kontakt->info->work_homepage);

	if( kontakt->info->work_zip != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_zip_entry")), kontakt->info->work_zip);
	
	if( kontakt->info->work_country != 0 )
                gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "work_country_entry")), Get_Country_Name (kontakt->info->work_country));
	
	if( kontakt->info->street != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "street_entry")), kontakt->info->street);

	if( kontakt->info->city != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "city_entry")), kontakt->info->city);

	if( kontakt->info->state != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "state_entry")), kontakt->info->state);

	if( kontakt->info->zip != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "zip_entry")), kontakt->info->zip);

	if( kontakt->info->country != 0 )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "country_entry")), Get_Country_Name (kontakt->info->country));

        if( kontakt->info->country != 0 )
                gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "timezone_entry")), Get_Time_Zone_String (kontakt->info->timezone));

	if( kontakt->info->cellular != NULL )
		gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "cellular_entry")), kontakt->info->cellular);

	if (kontakt->info->birth_year != 0 && 
	    kontakt->info->birth_month != 0 && 
	    kontakt->info->birth_day != 0)
	{
	    date = g_date_new_dmy(kontakt->info->birth_day, 
				  kontakt->info->birth_month,
				  kontakt->info->birth_year);
	    g_date_strftime(datebuf, 30, "%x", date);
	    g_date_free(date);
	    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (kontakt->info_dlg_xml, "birthday_entry")), datebuf);
	}
}

gboolean userinfo_close_clicked_callback (GtkWidget *widget, gpointer data)
{
	GtkWidget *window;

	window = gtk_object_get_data (GTK_OBJECT (widget), "dlg");
	gtk_widget_hide_all (window);

	return TRUE;
}

gboolean userinfo_refresh_clicked_callback (GtkWidget *widget, gpointer data)
{
       UIN_T uin;

       uin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (widget), "uin"));
        
       v7_request_info(uin);
                
       return TRUE;
}
