/*****************************
 Icon handling
 Author: Gediminas Paulauskas
 (c) 1999 Jeremy Wise
 GnomeICU
******************************/

#ifndef __ICONS_H__
#define __ICONS_H__

#include "datatype.h"
#include <gtk/gtkwidget.h>

/*** Pixmaps ***/
extern GdkPixmap *still_eyes_pixmap;
extern GdkPixmap *icon_blank_pixmap;
extern GdkPixmap *icon_message_pixmap;
extern GdkPixmap *icon_url_pixmap;
extern GdkPixmap *icon_auth_pixmap;
extern GdkPixmap *icon_away_pixmap;
extern GdkPixmap *icon_na_pixmap;
extern GdkPixmap *icon_occ_pixmap;
extern GdkPixmap *icon_dnd_pixmap;
extern GdkPixmap *icon_ffc_pixmap;
extern GdkPixmap *icon_inv_pixmap;
extern GdkPixmap *icon_online_pixmap;
extern GdkPixmap *icon_offline_pixmap;
extern GdkPixmap *icon_chat_pixmap;
extern GdkPixmap *icon_file_pixmap;
extern GdkPixmap *icon_info_pixmap;
extern GdkPixmap *icon_contact_pixmap;
extern GdkPixmap *icon_hist_pixmap;
extern GdkPixmap *icon_ok_pixmap;
extern GdkPixmap *icon_cancel_pixmap;
extern GdkPixmap *icon_rename_pixmap;

/*** Bitmaps ***/
extern GdkBitmap *still_eyes_bitmap;
extern GdkBitmap *icon_blank_bitmap;
extern GdkBitmap *icon_message_bitmap;
extern GdkBitmap *icon_url_bitmap;
extern GdkBitmap *icon_auth_bitmap;
extern GdkBitmap *icon_away_bitmap;
extern GdkBitmap *icon_na_bitmap;
extern GdkBitmap *icon_occ_bitmap;
extern GdkBitmap *icon_dnd_bitmap;
extern GdkBitmap *icon_ffc_bitmap;
extern GdkBitmap *icon_inv_bitmap;
extern GdkBitmap *icon_online_bitmap;
extern GdkBitmap *icon_offline_bitmap;
extern GdkBitmap *icon_chat_bitmap;
extern GdkBitmap *icon_file_bitmap;
extern GdkBitmap *icon_info_bitmap;
extern GdkBitmap *icon_contact_bitmap;
extern GdkBitmap *icon_hist_bitmap;
extern GdkBitmap *icon_ok_bitmap;
extern GdkBitmap *icon_cancel_bitmap;
extern GdkBitmap *icon_rename_bitmap;

void icons_init (void);
gchar *make_icon_path_theme (gchar *file_name, gchar *theme_name);
gchar *make_icon_path (gchar *file_name);

GdkPixmap *get_pixmap_for_status (DWORD status);
GdkBitmap *get_bitmap_for_status (DWORD status);

GdkPixmap *get_pixmap_for_message (gint type);
GdkBitmap *get_bitmap_for_message (gint type);

void set_window_icon (GtkWidget *window, gchar *icon_name);

#endif /* __ICONS_H__ */
