/*****************************
 Icon handling
 Author: Gediminas Paulauskas
 (c) 1999 Jeremy Wise
 GnomeICU
 *****************************/

#include "common.h"
#include "gnomeicu.h"
#include "icons.h"

/*** Global pixmaps ***/
GdkPixmap *still_eyes_pixmap;
GdkPixmap *icon_blank_pixmap;
GdkPixmap *icon_message_pixmap;
GdkPixmap *icon_url_pixmap;
GdkPixmap *icon_auth_pixmap;
GdkPixmap *icon_away_pixmap;
GdkPixmap *icon_na_pixmap;
GdkPixmap *icon_occ_pixmap;
GdkPixmap *icon_dnd_pixmap;
GdkPixmap *icon_ffc_pixmap;
GdkPixmap *icon_inv_pixmap;
GdkPixmap *icon_online_pixmap;
GdkPixmap *icon_offline_pixmap;
GdkPixmap *icon_chat_pixmap;
GdkPixmap *icon_file_pixmap;
GdkPixmap *icon_info_pixmap;
GdkPixmap *icon_contact_pixmap;
GdkPixmap *icon_hist_pixmap;
GdkPixmap *icon_ok_pixmap;
GdkPixmap *icon_cancel_pixmap;
GdkPixmap *icon_rename_pixmap;

GdkBitmap *still_eyes_bitmap;
GdkBitmap *icon_blank_bitmap;
GdkBitmap *icon_message_bitmap;
GdkBitmap *icon_url_bitmap;
GdkBitmap *icon_auth_bitmap;
GdkBitmap *icon_away_bitmap;
GdkBitmap *icon_na_bitmap;
GdkBitmap *icon_occ_bitmap;
GdkBitmap *icon_dnd_bitmap;
GdkBitmap *icon_ffc_bitmap;
GdkBitmap *icon_inv_bitmap;
GdkBitmap *icon_online_bitmap;
GdkBitmap *icon_offline_bitmap;
GdkBitmap *icon_chat_bitmap;
GdkBitmap *icon_file_bitmap;
GdkBitmap *icon_info_bitmap;
GdkBitmap *icon_contact_bitmap;
GdkBitmap *icon_hist_bitmap;
GdkBitmap *icon_ok_bitmap;
GdkBitmap *icon_cancel_bitmap;
GdkBitmap *icon_rename_bitmap;

/*** Local functions ***/
static void init_one_pixmap (gchar * icon_name, GdkPixmap ** icon_pixmap,
			     GdkBitmap ** icon_bitmap, int alpha_threshold);

/*** Global functions ***/
gchar *make_icon_path_theme (gchar * file_name, gchar * theme_name)
{
	gchar *file;

	if (theme_name == NULL)
		theme_name = toggles->theme_name;

	/* Local themes */
	file =
	    g_strconcat (g_get_home_dir (), "/.icq/icons/", theme_name, "/",
			 file_name, NULL);

	if (!g_file_exists (file)) {   /* Local theme does not exist */
		/* Global themes */
		gchar *theme_path = GNOMEICU_DATADIR "/gnomeicu/icons/";

		g_free (file);
		file =
		    g_strconcat (theme_path, theme_name, "/", file_name, NULL);

		if (!g_file_exists (file)) {	/* Theme does not exist, use Default */
			g_free (file);
			file =
			    g_strconcat (theme_path, "Default/", file_name,
					 NULL);

			if (!g_file_exists (file)) {	/* Nothing exists */
				g_free (file);
				file = NULL;
			}
		}
	}

	return file;
}

gchar *make_icon_path (gchar * file_name)
{
	return make_icon_path_theme (file_name, NULL);
}

void init_one_pixmap (gchar * icon_name, GdkPixmap ** icon_pixmap,
		      GdkBitmap ** icon_bitmap, int alpha_threshold)
{
	GdkPixbuf *im;
	gchar *icon_filename;

	icon_filename = make_icon_path (icon_name);

	im = gdk_pixbuf_new_from_file (icon_filename);
	gdk_pixbuf_render_pixmap_and_mask (im, icon_pixmap,
					   icon_bitmap, alpha_threshold);
	gdk_pixbuf_finalize (im);

	g_free (icon_filename);
}

void icons_init (void)
{
#ifdef TRACE_FUNCTION
	g_print ("icons_init\n");
#endif

	init_one_pixmap ("gnomeicu-blank.png",
			 &icon_blank_pixmap, &icon_blank_bitmap, 1);
	init_one_pixmap ("gnomeicu-still.png",
			 &still_eyes_pixmap, &still_eyes_bitmap, 1);
	init_one_pixmap ("gnomeicu-message.png",
			 &icon_message_pixmap, &icon_message_bitmap, 1);
	init_one_pixmap ("gnomeicu-url.png",
			 &icon_url_pixmap, &icon_url_bitmap, 1);
	init_one_pixmap ("gnomeicu-auth.png",
			 &icon_auth_pixmap, &icon_auth_bitmap, 1);
	init_one_pixmap ("gnomeicu-away.png",
			 &icon_away_pixmap, &icon_away_bitmap, 50);
	init_one_pixmap ("gnomeicu-occ.png",
			 &icon_occ_pixmap, &icon_occ_bitmap, 50);
	init_one_pixmap ("gnomeicu-na.png",
			 &icon_na_pixmap, &icon_na_bitmap, 50);
	init_one_pixmap ("gnomeicu-dnd.png",
			 &icon_dnd_pixmap, &icon_dnd_bitmap, 50);
	init_one_pixmap ("gnomeicu-ffc.png",
			 &icon_ffc_pixmap, &icon_ffc_bitmap, 50);
	init_one_pixmap ("gnomeicu-inv.png",
			 &icon_inv_pixmap, &icon_inv_bitmap, 50);
	init_one_pixmap ("gnomeicu-online.png",
			 &icon_online_pixmap, &icon_online_bitmap, 50);
	init_one_pixmap ("gnomeicu-offline.png",
			 &icon_offline_pixmap, &icon_offline_bitmap, 50);
	init_one_pixmap ("gnomeicu-chat.png",
			 &icon_chat_pixmap, &icon_chat_bitmap, 1);
	init_one_pixmap ("gnomeicu-file.png",
			 &icon_file_pixmap, &icon_file_bitmap, 1);
	init_one_pixmap ("gnomeicu-info.png",
			 &icon_info_pixmap, &icon_info_bitmap, 1);
	init_one_pixmap ("gnomeicu-contact.png",
			 &icon_contact_pixmap, &icon_contact_bitmap, 1);
	init_one_pixmap ("gnomeicu-hist.png",
			 &icon_hist_pixmap, &icon_hist_bitmap, 1);
	init_one_pixmap ("gnomeicu-rename.png",
			 &icon_rename_pixmap, &icon_rename_bitmap, 1);
	init_one_pixmap ("gnomeicu-cancel.png",
			 &icon_cancel_pixmap, &icon_cancel_bitmap, 1);
	init_one_pixmap ("gnomeicu-ok.png",
			 &icon_ok_pixmap, &icon_ok_bitmap, 1);
}

GdkPixmap *get_pixmap_for_status (DWORD status)
{
	/* test offline separately, because -1 & 0xFFFF is not -1 */
	if (STATUS_OFFLINE == status)
		return icon_offline_pixmap;

	switch (status & 0xffff) {
	case STATUS_ONLINE:
		return icon_online_pixmap;
	case STATUS_DND:
		return icon_dnd_pixmap;
	case STATUS_AWAY:
		return icon_away_pixmap;
	case STATUS_OCCUPIED:
		return icon_occ_pixmap;
	case STATUS_NA:
		return icon_na_pixmap;
	case STATUS_INVISIBLE:
		return icon_inv_pixmap;
	case STATUS_FREE_CHAT:
		return icon_ffc_pixmap;
	default:
		return icon_offline_pixmap;
	}
}

GdkBitmap *get_bitmap_for_status (DWORD status)
{
	/* test offline separately, because -1 & 0xFFFF is not -1 */
	if (STATUS_OFFLINE == status)
		return icon_offline_bitmap;

	switch (status & 0xffff) {
	case STATUS_ONLINE:
		return icon_online_bitmap;
	case STATUS_DND:
		return icon_dnd_bitmap;
	case STATUS_AWAY:
		return icon_away_bitmap;
	case STATUS_OCCUPIED:
		return icon_occ_bitmap;
	case STATUS_NA:
		return icon_na_bitmap;
	case STATUS_INVISIBLE:
		return icon_inv_bitmap;
	case STATUS_FREE_CHAT:
		return icon_ffc_bitmap;
	default:
		return icon_offline_bitmap;
	}
}

GdkPixmap *get_pixmap_for_message (gint type)
{
	switch (type)
	{
	case MESSAGE_CONT_LIST:
		return icon_contact_pixmap;
	case MESSAGE_CHAT_REQ:
		return icon_chat_pixmap;
	case MESSAGE_FILE_REQ:
		return icon_file_pixmap;
	case MESSAGE_URL:
		return icon_url_pixmap;
	case MESSAGE_AUTH_REQ:
	case MESSAGE_USER_ADD:
	case MESSAGE_USER_AUTHD:
		return icon_auth_pixmap;
	default:
		return icon_message_pixmap;
	}
}

GdkBitmap *get_bitmap_for_message (gint type)
{
	switch (type)
	{
	case MESSAGE_CONT_LIST:
		return icon_contact_bitmap;
	case MESSAGE_CHAT_REQ:
		return icon_chat_bitmap;
	case MESSAGE_FILE_REQ:
		return icon_file_bitmap;
	case MESSAGE_URL:
		return icon_url_bitmap;
	case MESSAGE_AUTH_REQ:
	case MESSAGE_USER_ADD:
	case MESSAGE_USER_AUTHD:
		return icon_auth_bitmap;
	default:
		return icon_message_bitmap;
	}
}

#ifdef GNOME_ICON
#include <libgnomeui/gnome-window-icon.h>

void set_window_icon (GtkWidget * window, gchar * name)
{
	gchar *path = make_icon_path (name);
	gnome_window_icon_set_from_file (GTK_WINDOW (window), path);
	g_free (path);
}

#else

void set_window_icon (GtkWidget * window, gchar * name)
{
}
#endif /* GNOME_ICON */
