/*****************************************************
 Header file for ICQ protocol structres and constants
 (c) 1999 Jeremy Wise
 GnomeICU
******************************************************/

#ifndef __GNOMEICU_H__
#define __GNOMEICU_H__

#include "common.h"

typedef struct
{
	GladeXML *xml;
	GtkWidget *notebook;
	GtkWidget *lb_userwin;
	GtkWidget *lb_userwin_online;
	GtkWidget *lb_userwin_offline;
	GtkWidget *lb_userwin_notinlist;
	GtkWidget *head_online;
	GtkWidget *head_offline;
	GtkWidget *head_notinlist;
	GtkWidget *not_contents;
	GtkWidget *window;
} _MainData;

extern _MainData *MainData;

extern GSList *Contacts;

extern DWORD our_ip;
extern DWORD our_port;
extern DWORD Current_Status;
extern gchar *passwd;
extern gchar *server;
extern DWORD remote_port;
extern gchar *Away_Message;
extern gboolean Done_Login;

extern _programs *programs;

extern gboolean search_in_progress;

extern BYTE chat_fg_red, chat_fg_green, chat_fg_blue;
extern BYTE chat_bg_red, chat_bg_green, chat_bg_blue;

extern gboolean is_new_user;

extern gint WindowWidth, WindowHeight;
extern gint WindowX, WindowY;

extern gchar *configfilename;

extern gint tcp_gdk_input;

extern GdkFont *ChatFont;
extern gchar *ChatFontString;

extern DWORD our_session;

extern USER_INFO_PTR our_info;

extern GtkWidget *app;

extern gboolean enable_online_events;

extern gboolean webpresence;

extern _toggles *toggles;

extern GtkWidget *eyes_animated;
extern GtkWidget *eyes_still;

/* for server side contacts list */
extern gboolean srvlist_exist;   /* server side list exist for this user? */
extern guint32 list_time_stamp;  /* time stamp of the list */
extern guint16 record_cnt;       /* record count */
extern guint16 status_uid;       /* for change status on server list */
extern gboolean sane_cl;         /* is the contact list sane? or checked? */

extern GSList *Groups;

void create_tcp_line( void );
void ready_set( void );
void create_animator (void);
void init( void );
void about( GtkWidget *widget, gpointer data );
void go_url_home (void);
void go_url_updates (void);
void icq_quit( GtkWidget *widget, gpointer data );

#endif /* __GNOMEICU_H__ */
