/*****************************
 Handle file transfer
 (c) 1999 Jeremy Wise
 GnomeICU
******************************/

#ifndef __FILEXFER_H__
#define __FILEXFER_H__

#include "common.h"

#define XFER_DIRECTION_SENDING		0
#define XFER_DIRECTION_RECEIVING	1

#define XFER_STATUS_PENDING		0
#define XFER_STATUS_CONNECTING		1
#define XFER_STATUS_TRANSFERING		2

extern GSList *pending_xfers;
extern gint max_tcp_port;
extern gint min_tcp_port;

struct file_struct {
	char *short_filename;
	char *full_filename;

	guint total_bytes;
	guint completed_bytes;

	time_t start_time;
};

typedef struct {
	GSList *file_queue;
	GSList *completed_files;

	int sock_fd;
	int file_fd;
	GIOChannel *gioc;

	int direction;
	CONTACT_PTR remote_contact;
	WORD seq;
	int status;
	WORD port;

        void *dialog; /* Xfer dialog struct not yet defined */
	gchar *filename;

	int auto_transfer;
	gchar *auto_save_path;

	guint total_bytes;
	guint completed_bytes;
	time_t start_time;

	char *packet;
	unsigned short packet_offset;
	unsigned short packet_size;
} XferInfo;

void ft_skip_file( GtkWidget *, XferInfo *xfer);
void ft_cancel_transfer( GtkWidget *, XferInfo *xfer);

int ft_connectfile( XferInfo *xfer );
int ft_filereadserver( GIOChannel *source, GIOCondition condition,
                       XferInfo *xfer );
int ft_filereadclient( GIOChannel *source, GIOCondition condition,
                       XferInfo *xfer );
void ft_sendfileinfo( XferInfo *xfer );
int ft_sendpartfile( GIOChannel *source, GIOCondition condition,
                     XferInfo *xfer );
void ft_readytoreceive (XferInfo *xfer);
gboolean ft_listen( XferInfo *xfer);




#endif /* __FILEXFERDLG_H__ */

