Summary:        GnomeICU is a clone of Mirabilis' popular ICQ written with GTK.
Name:           gnomeicu
Version:        0.98.3
Release:        1
Epoch:          1
License:        GPL
Group:          Applications/Communications
URL:            http://gnomeicu.sourceforge.net/
Source:         http://download.sourceforge.net/gnomeicu/%{name}-%{version}.tar.gz
Requires:       gnome-libs >= 1.2.0
Requires:       libglade >= 0.16
BuildRequires:  gnome-libs >= 1.2.0
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%description
GnomeICU is a clone of Mirabilis' popular ICQ written with GTK.
The original source was taken from Matt Smith's mICQ.  This is ment as
a replacement for the JavaICQ, which is slow and buggy.  If you would
like to contribute, please contact Jeremy Wise <jwise@pathwaynet.com>.


%prep
%setup -q

# seems as if xss support is broken on alpha :-(
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux --without-xss"
%endif

if [ ! -f configure ]; then
    CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS \
	--prefix=%{_prefix} --sysconfdir=%{_sysconfdir} \
	--bindir=%{_bindir} --datadir=%{_datadir}
else
    CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS \
	--prefix=%{_prefix} --sysconfdir=%{_sysconfdir} \
	--bindir=%{_bindir} --datadir=%{_datadir}
fi

%build

if [ "$SMP" != "" ]; then
  make -j$SMP "MAKE=make -j$SMP"
else
  make
fi

%install
make prefix=$RPM_BUILD_ROOT/%{_prefix} \
    sysconfdir=$RPM_BUILD_ROOT/%{_sysconfdir} \
    bindir=$RPM_BUILD_ROOT/%{_bindir} \
    datadir=$RPM_BUILD_ROOT/%{_datadir} install

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%{_sysconfdir}/CORBA/servers/GnomeICU.gnorba
%config %{_sysconfdir}/sound/events/GnomeICU.soundlist
%{_bindir}/*
%{_datadir}/applets/Network/GnomeICU.desktop
%{_datadir}/gnome/apps/Internet/GnomeICU.desktop
%{_datadir}/pixmaps/*
%{_datadir}/sounds/gnomeicu/*
%{_datadir}/gnome/help/gnomeicu/*
%{_datadir}/gnomeicu/icons/*
%{_datadir}/gnomeicu/glade/*

###################################################################
%changelog
* Tue Dec 04 2001 Gediminas Paulauskas <menesis@delfi.lt>
- libglade now required

* Thu Nov 29 2001 Gregory Leblanc <gleblanc@linuxweasel.com>
- removed packager line, this should get handled by ~/.rpmmacros on
  the machine actually building the RPMs 
- added flags to make it more relocatable
- used the %find_lang macro for languages
- removed install-strip, rpm strips binaries as part of the packaging process.
- removed hard-coded paths
- reformatted header
- s/Copyright/License/
- changed buildroot to use %{_tmppath}
- added BuildRequires on gnome-libs
- removed requires ORBit and gtk+, since both of those are required by
  gnome-libs 
- remove unnecessary %defines of release and rel

* Fri Sep 10 1999 Herbert Valerio Riedel <hvr@gnu.org>
- added support for SMP builds

* Sun Jul 25 1999 Herbert Valerio Riedel <hvr@gnu.org>
- added online documentation
- added locale files

* Sat Jul 10 1999 Herbert Valerio Riedel <hvr@gnu.org>
- no need to define %{name} and %{version} explicitly (thanks to 
  Graham Cole <dybbuk@earthlink.net> for this hint)

* Tue Jun 29 1999 Herbert Valerio Riedel <hvr@gnu.org>
- first try at an official RPM
