#include "common.h"

GdkImlibImage *create_image( const gchar *filename);
void can_continue( GnomeDruidPage *page, GnomeDruid *druid );
gint cant_continue( GnomeDruidPage *page, GnomeDruid *druid );
gint cant_continue_back( GnomeDruidPage *page, GnomeDruid *druid );
void can_finish( GtkWidget *widget, gint row, gint col, GdkEventButton *event,
                 gpointer *data );
gint prepare_finish_page( GnomeDruidPage *page, GnomeDruid *druid, GtkWidget *window );
/*void finish_adding_user( GnomeDruidPage *page, GnomeDruid *druid );*/
void sort_found_list( GtkCList *clist, gint column, gpointer data );
gint found_list_compare_func( GtkCList *clist, gconstpointer ptrt,
                              gconstpointer ptr2 );
void search_changed( GtkWidget *widget, gpointer data );
void clear_i_window2( GtkWidget *widget, gpointer data );

GtkWidget*
create_AddContact (void)
{
	GtkWidget *AddContact;
	GtkWidget *viewport1;
	GtkWidget *druid1;
	GtkWidget *druidpagestandard1;
	GdkColor druidpagestandard1_bg_color = { 0, 257, 257, 257 };
	GdkColor druidpagestandard1_logo_bg_color = { 0, 257, 257, 257 };
	GdkColor druidpagestandard1_title_color = { 0, 65535, 65535, 65535 };
	GtkWidget *druid_vbox1;
	GtkWidget *label123;
	GtkWidget *notebook4;
	GtkWidget *table26;
	GtkWidget *entry81;
	GtkWidget *search_uin;
	GtkWidget *label121;
	GtkWidget *label114;
	GtkWidget *table25;
	GtkWidget *label118;
	GtkWidget *label119;
	GtkWidget *label120;
	GtkWidget *entry78;
	GtkWidget *search_nick;
	GtkWidget *entry79;
	GtkWidget *search_first;
	GtkWidget *entry80;
	GtkWidget *search_last;
	GtkWidget *label115;
	GtkWidget *table27;
	GtkWidget *label122;
	GtkWidget *entry82;
	GtkWidget *search_email;
	GtkWidget *label116;
	GtkWidget *druidpagestandard2;
	GdkColor druidpagestandard2_bg_color = { 0, 0, 0, 0 };
	GdkColor druidpagestandard2_logo_bg_color = { 0, 0, 0, 0 };
	GdkColor druidpagestandard2_title_color = { 0, 65535, 65535, 65535 };
	GtkWidget *druid_vbox2;
	GtkWidget *label74;
	GtkWidget *scrolledwindow9;
	GtkWidget *found_list;
	GtkWidget *label75;
	GtkWidget *label76;
	GtkWidget *label77;
	GtkWidget *label78;
	GtkWidget *label79;                

	AddContact = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_widget_set_name (AddContact, "AddContact");
	gtk_object_set_data (GTK_OBJECT (AddContact), "AddContact", AddContact);
	gtk_window_set_title (GTK_WINDOW (AddContact), _("GnomeICU - Add A Contact"));
	gtk_window_set_position (GTK_WINDOW (AddContact), GTK_WIN_POS_CENTER);
	gtk_window_set_policy (GTK_WINDOW (AddContact), TRUE, TRUE, FALSE);
	gtk_window_set_wmclass (GTK_WINDOW (AddContact), "AddContact", "GnomeICU");

	viewport1 = gtk_viewport_new (NULL, NULL);
	gtk_widget_set_name (viewport1, "viewport1");
	gtk_widget_ref (viewport1);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "viewport1", viewport1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (viewport1);
	gtk_container_add (GTK_CONTAINER (AddContact), viewport1);
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_OUT);

	druid1 = gnome_druid_new ();
	gtk_widget_set_name (druid1, "druid1");
	gtk_widget_ref (druid1);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "druid1", druid1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (druid1);
	gtk_container_add (GTK_CONTAINER (viewport1), druid1);

	druidpagestandard1 = gnome_druid_page_standard_new_with_vals ("", NULL);
	gtk_widget_set_name (druidpagestandard1, "druidpagestandard1");
	gtk_widget_ref (druidpagestandard1);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "druidpagestandard1", druidpagestandard1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show_all (druidpagestandard1);
	gnome_druid_append_page (GNOME_DRUID (druid1), GNOME_DRUID_PAGE (druidpagestandard1));
	gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), &druidpagestandard1_bg_color);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), &druidpagestandard1_logo_bg_color);
	gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), &druidpagestandard1_title_color);
	gnome_druid_page_standard_set_title (GNOME_DRUID_PAGE_STANDARD (druidpagestandard1), _("Contact Information"));

	druid_vbox1 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard1)->vbox;
	gtk_widget_set_name (druid_vbox1, "druid_vbox1");
	gtk_widget_ref (druid_vbox1);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "druid_vbox1", druid_vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (druid_vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (druid_vbox1), 20);

	label123 = gtk_label_new (_("Please enter the known information\nin one of the following three pages,\nand press the \"Next\" button below."));
	gtk_widget_set_name (label123, "label123");
	gtk_widget_ref (label123);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label123", label123,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label123);
	gtk_box_pack_start (GTK_BOX (druid_vbox1), label123, FALSE, FALSE, 0);

	notebook4 = gtk_notebook_new ();
	gtk_widget_set_name (notebook4, "notebook4");
	gtk_widget_ref (notebook4);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "notebook4", notebook4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notebook4);
	gtk_box_pack_start (GTK_BOX (druid_vbox1), notebook4, TRUE, TRUE, 0);

	table26 = gtk_table_new (1, 2, FALSE);
	gtk_widget_set_name (table26, "table26");
	gtk_widget_ref (table26);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "table26", table26,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table26);
	gtk_container_add (GTK_CONTAINER (notebook4), table26);
	gtk_container_set_border_width (GTK_CONTAINER (table26), 6);

	entry81 = gnome_entry_new ("gnomeicu_search_uin");
	gtk_widget_set_name (entry81, "entry81");
	gtk_widget_ref (entry81);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "entry81", entry81,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry81);
	gtk_table_attach (GTK_TABLE (table26), entry81, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	search_uin = gnome_entry_gtk_entry (GNOME_ENTRY (entry81));
	gtk_widget_set_name (search_uin, "search_uin");
	gtk_widget_ref (search_uin);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "search_uin", search_uin,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (search_uin);
    gtk_widget_grab_focus( search_uin );

	gtk_signal_connect( GTK_OBJECT( search_uin ), "changed",
	                    GTK_SIGNAL_FUNC( can_continue ),
	                    druid1 );

	label121 = gtk_label_new (_("Contact's UIN:"));
	gtk_widget_set_name (label121, "label121");
	gtk_widget_ref (label121);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label121", label121,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label121);
	gtk_table_attach (GTK_TABLE (table26), label121, 0, 1, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	label114 = gtk_label_new (_("UIN"));
	gtk_widget_set_name (label114, "label114");
	gtk_widget_ref (label114);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label114", label114,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label114);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 0), label114);

	table25 = gtk_table_new (3, 2, FALSE);
	gtk_widget_set_name (table25, "table25");
	gtk_widget_ref (table25);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "table25", table25,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table25);
	gtk_container_add (GTK_CONTAINER (notebook4), table25);
	gtk_container_set_border_width (GTK_CONTAINER (table25), 6);
	gtk_table_set_row_spacings (GTK_TABLE (table25), 4);

	label118 = gtk_label_new (_("Nick Name:"));
	gtk_widget_set_name (label118, "label118");
	gtk_widget_ref (label118);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label118", label118,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label118);
	gtk_table_attach (GTK_TABLE (table25), label118, 0, 1, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label118), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label118), 1, 0.5);

	label119 = gtk_label_new (_("First Name:"));
	gtk_widget_set_name (label119, "label119");
	gtk_widget_ref (label119);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label119", label119,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label119);
	gtk_table_attach (GTK_TABLE (table25), label119, 0, 1, 1, 2,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label119), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label119), 1, 0.5);

	label120 = gtk_label_new (_("Last Name:"));
	gtk_widget_set_name (label120, "label120");
	gtk_widget_ref (label120);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label120", label120,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label120);
	gtk_table_attach (GTK_TABLE (table25), label120, 0, 1, 2, 3,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label120), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label120), 1, 0.5);

	entry78 = gnome_entry_new ("gnomeicu_search_nick");
	gtk_widget_set_name (entry78, "entry78");
	gtk_widget_ref (entry78);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "entry78", entry78,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry78);
	gtk_table_attach (GTK_TABLE (table25), entry78, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	search_nick = gnome_entry_gtk_entry (GNOME_ENTRY (entry78));
	gtk_widget_set_name (search_nick, "search_nick");
	gtk_widget_ref (search_nick);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "search_nick", search_nick,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (search_nick);

	gtk_signal_connect( GTK_OBJECT( search_nick ), "changed",
	                    GTK_SIGNAL_FUNC( can_continue ),
	                    druid1 );


	entry79 = gnome_entry_new ("gnomeicu_search_first");
	gtk_widget_set_name (entry79, "entry79");
	gtk_widget_ref (entry79);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "entry79", entry79,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry79);
	gtk_table_attach (GTK_TABLE (table25), entry79, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	search_first = gnome_entry_gtk_entry (GNOME_ENTRY (entry79));
	gtk_widget_set_name (search_first, "search_first");
	gtk_widget_ref (search_first);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "search_first", search_first,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (search_first);

	gtk_signal_connect( GTK_OBJECT( search_first ), "changed",
	                    GTK_SIGNAL_FUNC( can_continue ),
	                    druid1 );

	entry80 = gnome_entry_new ("gnomeicu_search_last");
	gtk_widget_set_name (entry80, "entry80");
	gtk_widget_ref (entry80);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "entry80", entry80,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry80);
	gtk_table_attach (GTK_TABLE (table25), entry80, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	search_last = gnome_entry_gtk_entry (GNOME_ENTRY (entry80));
	gtk_widget_set_name (search_last, "search_last");
	gtk_widget_ref (search_last);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "search_last", search_last,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (search_last);

	gtk_signal_connect( GTK_OBJECT( search_last ), "changed",
	                    GTK_SIGNAL_FUNC( can_continue ),
	                    druid1 );

	label115 = gtk_label_new (_("Contact Info"));
	gtk_widget_set_name (label115, "label115");
	gtk_widget_ref (label115);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label115", label115,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label115);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 1), label115);

	table27 = gtk_table_new (1, 2, FALSE);
	gtk_widget_set_name (table27, "table27");
	gtk_widget_ref (table27);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "table27", table27,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table27);
	gtk_container_add (GTK_CONTAINER (notebook4), table27);
	gtk_container_set_border_width (GTK_CONTAINER (table27), 6);

	label122 = gtk_label_new (_("Contact's E-Mail Address:"));
	gtk_widget_set_name (label122, "label122");
	gtk_widget_ref (label122);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label122", label122,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label122);
	gtk_table_attach (GTK_TABLE (table27), label122, 0, 1, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	entry82 = gnome_entry_new ("gnomeicu_search_email");
	gtk_widget_set_name (entry82, "entry82");
	gtk_widget_ref (entry82);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "entry82", entry82,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry82);
	gtk_table_attach (GTK_TABLE (table27), entry82, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	search_email = gnome_entry_gtk_entry (GNOME_ENTRY (entry82));
	gtk_widget_set_name (search_email, "search_email");
	gtk_widget_ref (search_email);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "search_email", search_email,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (search_email);

	gtk_signal_connect( GTK_OBJECT( search_email ), "changed",
	                    GTK_SIGNAL_FUNC( can_continue ),
	                    druid1 );

	label116 = gtk_label_new (_("E-Mail Address"));
	gtk_widget_set_name (label116, "label116");
	gtk_widget_ref (label116);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label116", label116,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label116);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook4), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook4), 2), label116);

	druidpagestandard2 = gnome_druid_page_standard_new_with_vals ("", NULL);
	gtk_widget_set_name (druidpagestandard2, "druidpagestandard2");
	gtk_widget_ref (druidpagestandard2);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "druidpagestandard2", druidpagestandard2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show_all (druidpagestandard2);
	gnome_druid_append_page (GNOME_DRUID (druid1), GNOME_DRUID_PAGE (druidpagestandard2));
	gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), &druidpagestandard2_bg_color);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), &druidpagestandard2_logo_bg_color);
	gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), &druidpagestandard2_title_color);
	gnome_druid_page_standard_set_title (GNOME_DRUID_PAGE_STANDARD (druidpagestandard2), _("Search Results"));

	druid_vbox2 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard2)->vbox;
	gtk_widget_set_name (druid_vbox2, "druid_vbox2");
	gtk_widget_ref (druid_vbox2);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "druid_vbox2", druid_vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (druid_vbox2);
	gtk_container_set_border_width (GTK_CONTAINER (druid_vbox2), 20);

	label74 = gtk_label_new (_("Please choose one contact to add and click \"Next\". If the person you were\nlooking for is not listed, go back and try again with different information."));
	gtk_widget_set_name (label74, "label74");
	gtk_widget_ref (label74);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label74", label74,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label74);
	gtk_box_pack_start (GTK_BOX (druid_vbox2), label74, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label74), GTK_JUSTIFY_LEFT);

	scrolledwindow9 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_name (scrolledwindow9, "scrolledwindow9");
	gtk_widget_ref (scrolledwindow9);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "scrolledwindow9", scrolledwindow9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow9);
	gtk_box_pack_start (GTK_BOX (druid_vbox2), scrolledwindow9, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow9), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	found_list = gtk_clist_new (5);
	gtk_widget_set_name (found_list, "found_list");
	gtk_widget_ref (found_list);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "found_list", found_list,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_clist_set_selection_mode( GTK_CLIST( found_list ), GTK_SELECTION_BROWSE );
	gtk_clist_set_compare_func( GTK_CLIST( found_list ), found_list_compare_func );
	gtk_widget_show (found_list);
	gtk_container_add (GTK_CONTAINER (scrolledwindow9), found_list);
	gtk_clist_set_row_height( GTK_CLIST( found_list ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (found_list), 0, 75);
	gtk_clist_set_column_width (GTK_CLIST (found_list), 1, 75);
	gtk_clist_set_column_width (GTK_CLIST (found_list), 2, 75);
	gtk_clist_set_column_width (GTK_CLIST (found_list), 3, 75);
	gtk_clist_set_column_width (GTK_CLIST (found_list), 4, 110);
	gtk_clist_column_titles_show (GTK_CLIST (found_list));

	gtk_signal_connect (GTK_OBJECT (found_list), "destroy",
	                    GTK_SIGNAL_FUNC (clear_i_window2), NULL);

	gtk_object_set_data( GTK_OBJECT( found_list ), "druid", druid1 );

	label75 = gtk_label_new (_("UIN"));
	gtk_widget_set_name (label75, "label75");
	gtk_widget_ref (label75);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label75", label75,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label75);
	gtk_clist_set_column_widget (GTK_CLIST (found_list), 0, label75);
	gtk_label_set_justify (GTK_LABEL (label75), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label75), 0, 0.5);

	label76 = gtk_label_new (_("Nick Name"));
	gtk_widget_set_name (label76, "label76");
	gtk_widget_ref (label76);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label76", label76,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label76);
	gtk_clist_set_column_widget (GTK_CLIST (found_list), 1, label76);
	gtk_misc_set_alignment (GTK_MISC (label76), 0, 0.5);

	label77 = gtk_label_new (_("First Name"));
	gtk_widget_set_name (label77, "label77");
	gtk_widget_ref (label77);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label77", label77,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label77);
	gtk_clist_set_column_widget (GTK_CLIST (found_list), 2, label77);
	gtk_label_set_justify (GTK_LABEL (label77), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label77), 0, 0.5);

	label78 = gtk_label_new (_("Last Name"));
	gtk_widget_set_name (label78, "label78");
	gtk_widget_ref (label78);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label78", label78,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label78);
	gtk_clist_set_column_widget (GTK_CLIST (found_list), 3, label78);
	gtk_label_set_justify (GTK_LABEL (label78), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label78), 0, 0.5);

	label79 = gtk_label_new (_("E-Mail"));
	gtk_widget_set_name (label79, "label79");
	gtk_widget_ref (label79);
	gtk_object_set_data_full (GTK_OBJECT (AddContact), "label79", label79,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label79);
	gtk_clist_set_column_widget (GTK_CLIST (found_list), 4, label79);
	gtk_label_set_justify (GTK_LABEL (label79), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label79), 0, 0.5);
        
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "next_page", druidpagestandard2 );

	gtk_object_set_data( GTK_OBJECT( druidpagestandard2 ), "clist", found_list );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard2 ), "w", AddContact );

	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "search_uin", search_uin );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "search_nick", search_nick );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "search_first", search_first );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "search_last", search_last );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "search_email", search_email );
	gtk_object_set_data( GTK_OBJECT( druidpagestandard1 ), "found_list", found_list );

	gtk_object_set_data( GTK_OBJECT( druid1 ), "search_uin", search_uin );
	gtk_object_set_data( GTK_OBJECT( druid1 ), "search_nick", search_nick );
	gtk_object_set_data( GTK_OBJECT( druid1 ), "search_first", search_first );
	gtk_object_set_data( GTK_OBJECT( druid1 ), "search_last", search_last );
	gtk_object_set_data( GTK_OBJECT( druid1 ), "search_email", search_email );

	gtk_signal_connect( GTK_OBJECT( search_uin ), "changed",
	                    GTK_SIGNAL_FUNC( search_changed ),
	                    druid1 );

	gtk_signal_connect( GTK_OBJECT( search_nick ), "changed",
	                    GTK_SIGNAL_FUNC( search_changed ),
	                    druid1 );

	gtk_signal_connect( GTK_OBJECT( search_first ), "changed",
	                    GTK_SIGNAL_FUNC( search_changed ),
	                    druid1 );

	gtk_signal_connect( GTK_OBJECT( search_last ), "changed",
	                    GTK_SIGNAL_FUNC( search_changed ),
	                    druid1 );

	gtk_signal_connect( GTK_OBJECT( search_email ), "changed",
	                    GTK_SIGNAL_FUNC( search_changed ),
	                    druid1 );

	gtk_signal_connect_after( GTK_OBJECT( druidpagestandard1 ), "next",
	                                      GTK_SIGNAL_FUNC( begin_search ),
	                                      NULL );

	gtk_signal_connect_object( GTK_OBJECT( druidpagestandard1 ), "cancel",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( AddContact ) );
	gtk_signal_connect_object( GTK_OBJECT( druidpagestandard2 ), "cancel",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( AddContact ) );

	gtk_signal_connect( GTK_OBJECT( druidpagestandard1 ), "next",
	                    GTK_SIGNAL_FUNC( cant_continue ),
	                    NULL );

	gtk_signal_connect( GTK_OBJECT( druidpagestandard2 ), "next",
	                    GTK_SIGNAL_FUNC( prepare_finish_page ),
	                    AddContact );

	gtk_signal_connect( GTK_OBJECT( druidpagestandard2 ), "back",
	                    GTK_SIGNAL_FUNC( cant_continue_back ),
	                    NULL );

	gtk_signal_connect( GTK_OBJECT( found_list ), "select_row",
	                    GTK_SIGNAL_FUNC( can_finish ),
	                    druid1 );

	gtk_signal_connect( GTK_OBJECT( found_list ), "click_column",
	                    GTK_SIGNAL_FUNC( sort_found_list ),
	                    NULL );

	gtk_object_set_data( GTK_OBJECT( druidpagestandard2 ), "prev_page", druidpagestandard1 );

	gnome_druid_set_buttons_sensitive( GNOME_DRUID( druid1 ), FALSE, FALSE, TRUE );

	return AddContact;
}

GdkImlibImage *create_image( const gchar *filename)
{
	GdkImlibImage *image;
	gchar *pathname;

	pathname = gnome_pixmap_file (filename);
	if (!pathname)
	  {
	    g_warning (_("Couldn't find pixmap file: %s"), filename);
	    return NULL;
	  }

	image = gdk_imlib_load_image (pathname);
	g_free (pathname);
	return image;
}

void can_continue( GnomeDruidPage *page, GnomeDruid *druid )
{
	gpointer prev_page = NULL;

	prev_page = gtk_object_get_data( GTK_OBJECT( page ), "prev_page" );

	if( prev_page == NULL )
            gnome_druid_set_buttons_sensitive( druid, FALSE, TRUE, TRUE );
	else
            gnome_druid_set_buttons_sensitive( druid, TRUE, TRUE, TRUE );

}

gint cant_continue( GnomeDruidPage *page, GnomeDruid *druid )
{
	GnomeDruidPage *next_page;
	gpointer prev_page;

	next_page = GNOME_DRUID_PAGE( gtk_object_get_data( GTK_OBJECT( page ), "next_page" ) );
	prev_page = gtk_object_get_data( GTK_OBJECT( page ), "prev_page" );
	gnome_druid_set_page( druid, next_page );

	gnome_druid_set_buttons_sensitive( druid, TRUE, FALSE, TRUE );

	return TRUE;
}

gint cant_continue_back( GnomeDruidPage *page, GnomeDruid *druid )
{
	gpointer prev_page;
	GtkEntry *e_uin;
	GtkEntry *e_nick;
	GtkEntry *e_first;
	GtkEntry *e_last;
	GtkEntry *e_email;


	prev_page = gtk_object_get_data( GTK_OBJECT( page ), "prev_page" );
	gnome_druid_set_page( druid, prev_page );

	e_uin = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_uin" ) );
	e_nick = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_nick" ) );
	e_first = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_first" ) );
	e_last = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_last" ) );
	e_email = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_email" ) );

	if( !strcmp( gtk_entry_get_text( e_uin ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_nick ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_first ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_last ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_email ), "" ) )
		gnome_druid_set_buttons_sensitive( druid, FALSE, FALSE, TRUE );
	else
		gnome_druid_set_buttons_sensitive( druid, FALSE, TRUE, TRUE );

	return TRUE;
}

void can_finish( GtkWidget *widget, gint row, gint col, GdkEventButton *event,
                 gpointer *data )
{
	GnomeDruid *druid = GNOME_DRUID( data );

	gnome_druid_set_buttons_sensitive( druid, TRUE, TRUE, TRUE );
}

/* TODO: use GnomeDruidPageFinish instead of another dialog */
gint prepare_finish_page( GnomeDruidPage *page, GnomeDruid *druid, GtkWidget *window )
{
	GtkCList *clist = GTK_CLIST( gtk_object_get_data( GTK_OBJECT( page ), "clist" ) );
        GtkWidget *finish_message;
	gint row = GPOINTER_TO_INT( clist->selection->data );
	gchar *str;
	UIN_T uin;
	gchar *nick = NULL, *fname, *lname, *msg = NULL;

	gtk_clist_get_text( clist, row, 0, &str );
	uin = atoi( str );

	gtk_clist_get_text( clist, row, 1, &nick );
	gtk_clist_get_text( clist, row, 2, &fname );
	gtk_clist_get_text( clist, row, 3, &lname );

        Add_User( uin, nick, TRUE );

        msg = g_strdup_printf(_("The UIN %d has been added.\nDo you want to add another one?"), uin);
        finish_message = gnome_message_box_new (
            msg,
            GNOME_MESSAGE_BOX_QUESTION,
            GNOME_STOCK_BUTTON_YES,
            GNOME_STOCK_BUTTON_NO,
            NULL);
        switch(gnome_dialog_run(GNOME_DIALOG(finish_message))) 
        {
        case 0:
            break;
        case 1:
            gtk_widget_destroy( GTK_WIDGET( window ) );
            break;
        }

	return TRUE;
}

void sort_found_list( GtkCList *clist, gint column, gpointer data )
{
	gtk_clist_set_sort_column( clist, column );

	/* Toggle the type of sort being performed. */
	gtk_clist_set_sort_type( clist,
	  ( clist->sort_type == GTK_SORT_ASCENDING ? GTK_SORT_DESCENDING :
	    GTK_SORT_ASCENDING ) );

	gtk_clist_freeze( clist );
	gtk_clist_sort( clist );
	gtk_clist_thaw( clist );
}

gint found_list_compare_func( GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2 )
{
	GtkCListRow *row1, *row2; /* Rows to compare. */
	gint column; /* Column being sorted on */

	g_return_val_if_fail( clist != NULL, 0 );
	g_return_val_if_fail( GTK_IS_CLIST( clist ), 0 );

	row1 = (GtkCListRow*)ptr1;
	row2 = (GtkCListRow*)ptr2;
	column = clist->sort_column;

	g_return_val_if_fail( row1 != NULL && row2 != NULL, 0 );

	if( row1->cell[column].type != GTK_CELL_TEXT ||
	    row2->cell[column].type != GTK_CELL_TEXT )
	{
		int val1 = atoi( GTK_CELL_TEXT( row1->cell[column] )->text );
		int val2 = atoi( GTK_CELL_TEXT( row2->cell[column] )->text );

		return (val1 > val2 ? 1 : (val1 == val2 ? 0 : -1 ) );
	}

	return 0;
}

void search_changed( GtkWidget *widget, gpointer data )
{
	GnomeDruid *druid;
	GtkEntry *e_uin;
	GtkEntry *e_nick;
	GtkEntry *e_first;
	GtkEntry *e_last;
	GtkEntry *e_email;

	druid = GNOME_DRUID( data );
	e_uin = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_uin" ) );
	e_nick = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_nick" ) );
	e_first = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_first" ) );
	e_last = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_last" ) );
	e_email = GTK_ENTRY( gtk_object_get_data( GTK_OBJECT( druid ), "search_email" ) );

	if( !strcmp( gtk_entry_get_text( e_uin ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_nick ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_first ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_last ), "" ) &&
	    !strcmp( gtk_entry_get_text( e_email ), "" ) )
		gnome_druid_set_buttons_sensitive( druid, FALSE, FALSE, TRUE );
	else
		gnome_druid_set_buttons_sensitive( druid, FALSE, TRUE, TRUE );
}

void clear_i_window2( GtkWidget *widget, gpointer data )
{
/*	UIN_T uin;

	GSList *contact;

	uin = GPOINTER_TO_INT( data );

	contact = Find_User( uin );

	if( contact != NULL )
		kontakt->info->window = NULL;

	if( New_Contact.uin == uin )*/
		widget = NULL;
		New_Contact.info->window = NULL;
}
