/******************************
 Configuration parser
 (c) 1999 Jeremy Wise
 GnomeICU
*******************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

/*** Local function declarations ***/
static void str2col( GdkColor *color, const gchar *str );
int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 );

/*** Global functions ***/
void Read_RC_File( void )
{
	char *value, *true_value;
	char *temp_uin;
	char *temp_nick;
	int first = TRUE;

	/* To be used in the new config section */
	void *iter;
	gchar *iterKey = NULL;
	gchar *iterData = NULL;
	gchar *tmp;

	CONTACT_PTR contactdata;

	gchar *version;

#ifdef TRACE_FUNCTION
	g_print( "Read_RC_File\n" );
#endif

	gnome_config_push_prefix( configfilename );

	/* User info */
	if( our_info->uin == 0 ) /* in case it was set in newsignup.c */
	  our_info->uin = gnome_config_get_int( "User/UIN=0" );

	/* Version */
	version = gnome_config_get_string( "User/Version=" );
	if( strcmp( version, VERSION ) )
	{
		/* Do this if they've upgraded */
	}

	g_free( version );

	if( !passwd ) /* ... */
		passwd = gnome_config_private_get_string( "User/Password=" );

	if( !strcmp( passwd, "" ) )
	{
		passwd = gnome_config_get_string( "User/Password=" );
		if( strcmp( passwd, "" ) )
			gnome_config_clean_key( "User/Password" );
	}

	our_info->nick = gnome_config_get_string( "User/Nickname=User" );

	preset_status = gnome_config_get_int( "User/Status=0" );

	g_free( Away_Message );
	Away_Message = gnome_config_get_string( "User/AwayMessage=User is currently away.  Please leave a message and have a great day!" );

	g_free( our_info->first );
	our_info->first = gnome_config_get_string( "User/First" );

	g_free( our_info->last );
	our_info->last = gnome_config_get_string( "User/Last" );

	our_info->sex = gnome_config_get_int( "User/Sex=0" );

	our_info->age = gnome_config_get_int( "User/Age=0" );

	our_info->auth = gnome_config_get_int( "User/Auth=1" );

	our_info->birth_year = gnome_config_get_int( "User/Birth_Year=0" );

	our_info->birth_month = gnome_config_get_int( "User/Birth_Month=1" );

	our_info->birth_day = gnome_config_get_int( "User/Birth_Day=1" );

	g_free( our_info->email );
	our_info->email = gnome_config_get_string( "User/Email" );

	g_free( our_info->email2 );
	our_info->email2 = gnome_config_get_string( "User/Email2" );

	g_free( our_info->email3 );
	our_info->email3 = gnome_config_get_string( "User/Email3" );

	g_free( our_info->phone );
	our_info->phone = gnome_config_get_string( "User/Phone" );

	g_free( our_info->fax );
	our_info->fax = gnome_config_get_string( "User/Fax" );

	g_free( our_info->cellular );
	our_info->cellular = gnome_config_get_string( "User/Cellular" );

	g_free( our_info->street );
	our_info->street = gnome_config_get_string( "User/Street" );

	g_free( our_info->city );
	our_info->city = gnome_config_get_string( "User/City" );

	g_free( our_info->state );
	our_info->state = gnome_config_get_string( "User/State" );

	our_info->zip = gnome_config_get_int( "User/Zip=0" );

	our_info->country = gnome_config_get_int( "User/Country=1" );

	our_info->zip = gnome_config_get_int( "User/Zip=0" );

	our_info->c_status = gnome_config_get_int( "User/C_Status=-500" );

	our_info->hide_email = gnome_config_get_int( "User/Hide_Email=0 " );

	g_free(our_info->homepage);
	our_info->homepage = gnome_config_get_string( "User/Homepage" );

	g_free(our_info->about);
	our_info->about = gnome_config_get_string( "User/About" );

	/* Server info */
	g_free( server );
	server = gnome_config_get_string( "Server/Server=icq.mirabilis.com" );

	remote_port = gnome_config_get_int( "Server/Port=4000" );

	min_tcp_port = gnome_config_get_int( "Server/MinTCPPort=4000" );
	max_tcp_port = gnome_config_get_int( "Server/MaxTCPPort=4100" );

	/* Window info */
	sscanf( (tmp=gnome_config_get_string( "Window/Size=160x330" )), "%dx%d", &WindowWidth, &WindowHeight);
	g_free(tmp);

	WindowWidth = (WindowWidth > 500) ? 500 : WindowWidth;
	WindowHeight = (WindowHeight > 1200) ? 1200 : WindowHeight;

	/* Auto Hide */
	autohide_time = gnome_config_get_int( "AutoHide/AutoHideTime=30" );

	g_free(WindowTitle);

	WindowTitle = gnome_config_get_string( "Window/Title=GnomeICU" );

	/* Toggles */
	toggles->sound = gnome_config_get_bool( "Toggles/Sound=true" );
	toggles->sound_onlyonline = gnome_config_get_bool( "Toggles/Sound_OnlyOnline=false" );
	toggles->beep = gnome_config_get_bool( "Toggles/Beep=false" );
	toggles->packet_udp = gnome_config_get_bool( "Toggles/PacketDumpUDP=false" );
	toggles->packet_tcp = gnome_config_get_bool( "Toggles/PacketDumpTCP=false" );
	toggles->force = gnome_config_get_bool( "Toggles/Force=false" );
	toggles->autohide = gnome_config_get_bool( "Toggles/AutoHide=false" );
	toggles->connect_startup = gnome_config_get_bool( "Toggles/ConnectStartup=true" );
	toggles->webpresence = gnome_config_get_bool( "Toggles/WebPresence=false" );
	toggles->show_window = gnome_config_get_bool( "Toggles/ShowWindow=false" );
	toggles->russian = gnome_config_get_bool( "Toggles/Russian=false" );
	toggles->check_spell = gnome_config_get_bool( "Toggles/Spelling=false" );
	toggles->kanji = gnome_config_get_bool( "Toggles/Kanji=false" );
	toggles->full_reply = gnome_config_get_bool( "Toggles/FullReply=true" );
	toggles->auto_popup = gnome_config_get_bool( "Toggles/AutoPopup=false" );
	toggles->no_new_users = gnome_config_get_bool( "Toggles/NoNewUsers=false" );
	toggles->hidetooltip = gnome_config_get_bool( "Toggles/HideToolTip=false" );
	toggles->status_notify = gnome_config_get_bool ("Toggles/StatusNotify=false" );
	toggles->sort_contacts = gnome_config_get_bool( "Toggles/Sort_Contacts=true" );
	toggles->program_on_receive_message =
		gnome_config_get_bool("Toggles/ProgramOnReceiveMessage=false");
	toggles->program_on_chat_request =
		gnome_config_get_bool( "Toggles/ProgramOnChatRequest=false" );
	toggles->program_on_receive_url =
		gnome_config_get_bool( "Toggles/ProgramOnReceiveURL=false" );
	toggles->program_on_file_request =
		gnome_config_get_bool( "Toggles/ProgramOnFileRequest=false" );
	toggles->program_on_user_online =
		gnome_config_get_bool( "Toggles/ProgramOnUserOnline=false" );
	toggles->program_on_user_offline =
		gnome_config_get_bool( "Toggles/ProgramOnUserOffline=false" );
	toggles->program_on_auth =
		gnome_config_get_bool( "Toggles/ProgramOnAuth=false" );
	toggles->program_on_auth_request =
		gnome_config_get_bool( "Toggles/ProgramOnAuthReq=false" );
	toggles->program_on_list_add =
		gnome_config_get_bool( "Toggles/ProgramOnListAdd=false" );
	toggles->program_on_contact_list =
		gnome_config_get_bool( "Toggles/ProgramOnContactList=false" );
	toggles->auto_away = gnome_config_get_int( "Toggles/AutoAway=10" );
	toggles->auto_na = gnome_config_get_int( "Toggles/AutoNA=20" );
	toggles->use_autoaway = gnome_config_get_bool("Toggles/UseAutoAway=true");
	toggles->auto_accept_xfers = gnome_config_get_bool("Toggles/AutoAcceptXfers=false");
	toggles->auto_accept_path = gnome_config_get_string("Toggles/AutoAcceptPath=~/.icq/Received");

        toggles->theme_name = gnome_config_get_string( "Toggles/ThemeName=Default" );

	/* Auto Hide */
	autohide_time = gnome_config_get_int( "AutoHide/AutoHideTime=60" );

	/* Chat font */
	g_free(ChatFontString);
	ChatFontString = gnome_config_get_string( "Color/ChatFont=-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	if( ChatFontString == NULL || !strcmp( ChatFontString, "" ) )
		ChatFontString = g_strdup( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );

	/* External Programs */
	programs->receive_message =
		gnome_config_get_string( "Programs/OnRecieveMessage" );
	programs->chat_request =
		gnome_config_get_string( "Programs/OnChatRequest" );
	programs->receive_url =
		gnome_config_get_string( "Programs/OnReceiveURL" );
	programs->file_request =
		gnome_config_get_string( "Programs/OnFileRequest" );
	programs->user_online =
		gnome_config_get_string( "Programs/OnUserOnline" );
	programs->user_offline =
		gnome_config_get_string( "Programs/OnUserOffline" );
	programs->auth =
		gnome_config_get_string( "Programs/OnAuth" );
	programs->auth_request =
		gnome_config_get_string( "Programs/OnAuthRequest" );
	programs->list_add =
		gnome_config_get_string( "Programs/OnListAdd" );
	programs->contact_list =
		gnome_config_get_string( "Programs/OnContactList" );

	/* Color section */
	str2col(&color_online, (tmp=gnome_config_get_string( "Color/Online=#000000009a69009a" )) );
	g_free(tmp);
	color_online_set = TRUE;
	str2col(&color_offline, (tmp=gnome_config_get_string( "Color/Offline=#75d675d675d67575" )) );
	g_free(tmp);
	color_offline_set = TRUE;
	str2col(&color_away, (tmp=gnome_config_get_string( "Color/Away=#0000820700008200" )) );
	g_free(tmp);
	color_away_set = TRUE;
	str2col(&color_na, (tmp=gnome_config_get_string( "Color/NotAvailable=#0000820700008200" )) );
	g_free(tmp);
	color_na_set = TRUE;
	str2col(&color_ffc, (tmp=gnome_config_get_string( "Color/FreeForChat=#0000000075300075" )) );
	g_free(tmp);
	color_ffc_set = TRUE;
	str2col(&color_occ, (tmp=gnome_config_get_string( "Color/Occupied=#0000000075300075" )) );
	g_free(tmp);
	color_occ_set = TRUE;
	str2col(&color_dnd, (tmp=gnome_config_get_string( "Color/DoNotDisturb=#0000000075300075" )) );
	g_free(tmp);
	color_dnd_set = TRUE;
	str2col(&color_inv, (tmp=gnome_config_get_string( "Color/Invisible=#9a692ed2810c2e81" )) );
	g_free(tmp);
	color_inv_set = TRUE;

	/* New Contacts section */
	if( gnome_config_has_section( "NewContacts" ) )
	{
		iter = gnome_config_init_iterator( "NewContacts" );
		while( 1 )
		{
			g_free( iterKey );
			g_free( iterData );

			iter = gnome_config_iterator_next( iter, &iterKey, &iterData );

			if( iter == NULL )
				break;
			if( atoi( iterKey ) == 0 )
				continue;
			contactdata = g_new0( Contact_Member, 1 );
			if( strstr( iterData, "Snot" ) ) /* Online Notification */
				contactdata->online_notify = TRUE;
			else
				contactdata->online_notify = FALSE;

			if( strstr( iterData, "Ssrv" ) ) /* Force through server */
				contactdata->force_override = TRUE;
			else
				contactdata->force_override = FALSE;

			if( strstr( iterData, "Sign" ) ) /* Ignore List */
				contactdata->ignore_list = TRUE;
			else
				contactdata->ignore_list = FALSE;

			if( strstr( iterData, "Sinv" ) ) /* Invisible List */
				contactdata->invis_list = TRUE;
			else if( strstr( iterData, "Svis" ) ) /* Visible List */
				contactdata->vis_list = TRUE;
			else
			{
				contactdata->invis_list = FALSE;
				contactdata->vis_list = FALSE;
			}

			contactdata->uin = atoi( iterKey );

			if( iterData[ 0 ] == ',' )
				sprintf( contactdata->nick, "%s", iterKey );
			else
			{
				if( strchr( iterData, ',' ) != NULL )
					strncpy( contactdata->nick, iterData,
					         ( strchr( iterData, ',' ) - iterData ) );
				else
					strncpy( contactdata->nick, iterData,
					         sizeof( contactdata->nick ) );
			}

			contactdata->sok = 0;
			contactdata->chat_requests = NULL;
			contactdata->stored_messages = NULL;
			contactdata->status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->show_again = TRUE;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
			contactdata->inlist = TRUE;
			contactdata->tcp_seq = -1;

			Contacts = g_slist_insert_sorted( Contacts, contactdata, (GCompareFunc)sort_compare );
		}
	}

	/* Contacts section */
	else
	{
		value = gnome_config_get_string( "Contacts/Contacts=4664755,GnomeICU Author" );

		true_value = value;

		while( ( temp_uin = strtok( ( first ? value : NULL ), "," ) ) != NULL )
		{
			first = FALSE;
			temp_nick = strtok( NULL, "," );

			contactdata = g_new0( Contact_Member, 1 );

			if( temp_uin[ 0 ] == '*' )
			{
				contactdata->invis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else if( temp_uin[ 0 ] == '~' )
			{
				contactdata->vis_list = TRUE;
				contactdata->uin = atoi( &temp_uin[ 1 ] );
			}
			else
			{
				contactdata->invis_list = FALSE;
				contactdata->vis_list = FALSE;
				contactdata->uin = atoi( temp_uin );
			}
			contactdata->sok = 0;
			contactdata->chat_requests = NULL;
			contactdata->messages = 0;
			contactdata->status = STATUS_OFFLINE;
			contactdata->last_time = -1L;
			contactdata->current_ip = -1L;
			contactdata->show_again = TRUE;
			contactdata->info = g_new0( USER_INFO_STRUCT, 1 );

			contactdata->tcp_seq = -1;

			if( temp_nick )
			{
				strncpy( contactdata->nick, temp_nick, sizeof(contactdata->nick)-1);
				contactdata->nick[ sizeof( contactdata->nick ) - 1 ] = 0;
			}
			else
				contactdata->nick[ 0 ] = 0;

			Contacts = g_slist_prepend( Contacts, contactdata );
		}

		Contacts = g_slist_reverse( Contacts );

		g_free( true_value );
	}
	/* Here we get all of the away messages */
	get_config_file_away_msgs();
	/* End get all of the away messages */


	gnome_config_pop_prefix();

	have_read_config = TRUE;


	return;
}

void Initialize_RC_File( void )
{
	gchar *path = NULL;
#ifdef TRACE_FUNCTION
	g_print( "Initialize_RC_File\n" );
#endif

	path = g_strdup_printf("%s/.icq", getenv( "HOME" ) );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	path = g_strdup_printf("%s/.icq/history", getenv( "HOME" ) );
	if(mkdir(path, 0700))
	    switch(errno)
	      {
	      case EEXIST: break;
	      default: g_warning(PACKAGE "mkdir:%s:%s", path, g_strerror(errno) );
	      }
	g_free(path);

	NewUserSignup();

	return;
}

/*
 *	Config File Save
 *
 * Jeremy Wise (jwise@pathwaynet.com) 02/27/1999
 *
 */

void Save_RC( void )
{
	char uin_str[64];
	char *contactKey, *contactStr;

	GSList *contact;

	gnome_config_push_prefix( configfilename );

#ifdef TRACE_FUNCTION
	g_print( "Save_RC\n" );
#endif

	/* User info */
	gnome_config_set_string( "User/Version", VERSION );
	gnome_config_set_int( "User/UIN", our_info->uin );
	gnome_config_private_set_string( "User/Password", passwd );
	gnome_config_set_int( "User/Status", ( Current_Status != STATUS_OFFLINE ? Current_Status : STATUS_ONLINE ) );
	gnome_config_set_string( "User/Nickname", our_info->nick );
	gnome_config_set_string( "User/First", our_info->first );
	gnome_config_set_string( "User/Last", our_info->last );
	gnome_config_set_int( "User/Sex", our_info->sex );
	gnome_config_set_int( "User/Age", our_info->age );
	gnome_config_set_int( "User/Auth", our_info->auth );
	gnome_config_set_int( "User/Birth_Year", our_info->birth_year );
	gnome_config_set_int( "User/Birth_Month", our_info->birth_month );
	gnome_config_set_int( "User/Birth_Day", our_info->birth_day );
	gnome_config_set_string( "User/Email", our_info->email );
	gnome_config_set_string( "User/Email2", our_info->email2 );
	gnome_config_set_string( "User/Email3", our_info->email3 );
	gnome_config_set_string( "User/Phone", our_info->phone );
	gnome_config_set_string( "User/Fax", our_info->fax );
	gnome_config_set_string( "User/Cellular", our_info->cellular );
	gnome_config_set_string( "User/Street", our_info->street );
	gnome_config_set_string( "User/City", our_info->city );
	gnome_config_set_string( "User/State", our_info->state );
	gnome_config_set_int( "User/Zip", our_info->zip );
	gnome_config_set_int( "User/Country", our_info->country );
	gnome_config_set_int( "User/C_Status", our_info->c_status );
	gnome_config_set_string( "User/Homepage", our_info->homepage );
	gnome_config_set_string( "User/About", our_info->about );
	gnome_config_set_int( "User/Hide_Email", our_info->hide_email );
	gnome_config_set_string( "User/AwayMessage", Away_Message );

	/* Server info */
	gnome_config_set_string( "Server/Server", server );
	gnome_config_set_int( "Server/Port", remote_port );
	gnome_config_set_int( "Server/MinTCPPort", min_tcp_port );
	gnome_config_set_int( "Server/MaxTCPPort", max_tcp_port );

	/* Window info */
	sprintf( uin_str, "%dx%d", WindowWidth, WindowHeight );
	gnome_config_set_string( "Window/Size", uin_str );
	gnome_config_set_string( "Window/Title", WindowTitle );

	/* Toggles */
	gnome_config_set_bool( "Toggles/Sound", toggles->sound );
	gnome_config_set_bool( "Toggles/Sound_OnlyOnline", toggles->sound_onlyonline );
	gnome_config_set_bool( "Toggles/Beep", toggles->beep );
	gnome_config_set_bool( "Toggles/PacketDumpUDP", toggles->packet_udp );
	gnome_config_set_bool( "Toggles/PacketDumpTCP", toggles->packet_tcp );
	gnome_config_set_bool( "Toggles/Force", toggles->force );
	gnome_config_set_bool( "Toggles/AutoHide", toggles->autohide );
	gnome_config_set_bool( "Toggles/ConnectStartup", toggles->connect_startup );
	gnome_config_set_bool( "Toggles/HideToolTip", toggles->hidetooltip );
	gnome_config_set_bool( "Toggles/Sort_Contacts", toggles->sort_contacts );
	gnome_config_set_bool( "Toggles/WebPresence", toggles->webpresence );
	gnome_config_clean_key( "Toggles/Headers" );
	gnome_config_set_bool( "Toggles/ShowWindow", toggles->show_window );
	gnome_config_set_bool( "Toggles/Spelling", toggles->check_spell );
	gnome_config_set_bool( "Toggles/Russian", toggles->russian );
	gnome_config_set_bool( "Toggles/Kanji", toggles->kanji );
	gnome_config_set_bool( "Toggles/FullReply", toggles->full_reply );
	gnome_config_set_bool( "Toggles/AutoPopup", toggles->auto_popup );
	gnome_config_set_bool( "Toggles/StatusNotify", toggles->status_notify );
	gnome_config_set_bool( "Toggles/NoNewUsers", toggles->no_new_users );
	gnome_config_set_bool( "Toggles/ProgramOnReceiveMessage",
			       toggles->program_on_receive_message );
	gnome_config_set_bool( "Toggles/ProgramOnChatRequest",
			       toggles->program_on_chat_request );
	gnome_config_set_bool( "Toggles/ProgramOnReceiveURL",
			       toggles->program_on_receive_url );
	gnome_config_set_bool( "Toggles/ProgramOnFileRequest",
			       toggles->program_on_file_request );
	gnome_config_set_bool( "Toggles/ProgramOnUserOnline",
			       toggles->program_on_user_online );
	gnome_config_set_bool( "Toggles/ProgramOnUserOffline",
			       toggles->program_on_user_offline );
	gnome_config_set_bool( "Toggles/ProgramOnAuth",
			       toggles->program_on_auth );
	gnome_config_set_bool( "Toggles/ProgramOnAuthReq",
			       toggles->program_on_auth_request );
	gnome_config_set_bool( "Toggles/ProgramOnListAdd",
			       toggles->program_on_list_add );
	gnome_config_set_bool( "Toggles/ProgramOnContactList",
			       toggles->program_on_contact_list );
	gnome_config_set_int( "Toggles/AutoAway", toggles->auto_away);
	gnome_config_set_int( "Toggles/AutoNA", toggles->auto_na);
	gnome_config_set_bool( "Toggles/UseAutoAway", toggles->use_autoaway);
	gnome_config_set_bool( "Toggles/AutoAcceptXfers", toggles->auto_accept_xfers);
	gnome_config_set_string( "Toggles/AutoAcceptPath", toggles->auto_accept_path);
        gnome_config_set_string( "Toggles/ThemeName", toggles->theme_name );

	/* AutoHide */
	gnome_config_set_int( "AutoHide/AutoHideTime", autohide_time );

	/* Color Section */
	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_online.red & 0xffff,
	         color_online.green & 0xffff,
	         color_online.blue & 0xffff,
	         (unsigned int)color_online.pixel & 0xffff );
	gnome_config_set_string( "Color/Online", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_offline.red & 0xffff,
	         color_offline.green & 0xffff,
	         color_offline.blue & 0xffff,
	         (unsigned int)color_offline.pixel & 0xffff );
	gnome_config_set_string( "Color/Offline", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_away.red & 0xffff,
	         color_away.green & 0xffff,
	         color_away.blue & 0xffff,
	         (unsigned int)color_away.pixel & 0xffff );
	gnome_config_set_string( "Color/Away", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_na.red & 0xffff,
	         color_na.green & 0xffff,
	         color_na.blue & 0xffff,
	         (unsigned int)color_na.pixel & 0xffff );
	gnome_config_set_string( "Color/NotAvailable", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_ffc.red & 0xffff,
	         color_ffc.green & 0xffff,
	         color_ffc.blue & 0xffff,
	         (unsigned int)color_ffc.pixel & 0xffff);
	gnome_config_set_string( "Color/FreeForChat", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_occ.red & 0xffff,
	         color_occ.green & 0xffff,
	         color_occ.blue & 0xffff,
	         (unsigned int)color_occ.pixel & 0xffff );
	gnome_config_set_string( "Color/Occupied", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_dnd.red & 0xffff,
	         color_dnd.green & 0xffff,
	         color_dnd.blue & 0xffff,
	         (unsigned int)color_dnd.pixel & 0xffff );
	gnome_config_set_string( "Color/DoNotDisturb", uin_str );

	sprintf( uin_str, "#%04hx%04hx%04hx%04hx",
	         color_inv.red & 0xffff,
	         color_inv.green & 0xffff,
	         color_inv.blue & 0xffff,
	         (unsigned int)color_inv.pixel & 0xffff );
	gnome_config_set_string( "Color/Invisible", uin_str );

	/* Chat font */
	gnome_config_set_string( "Color/ChatFont", ChatFontString );

	/* External Programs */
	gnome_config_set_string( "Programs/OnRecieveMessage",
				 programs->receive_message );
	gnome_config_set_string( "Programs/OnChatRequest",
				 programs->chat_request );
	gnome_config_set_string( "Programs/OnReceiveURL",
				 programs->receive_url );
	gnome_config_set_string( "Programs/OnFileRequest",
				 programs->file_request );
	gnome_config_set_string( "Programs/OnUserOnline",
				 programs->user_online );
	gnome_config_set_string( "Programs/OnUserOffline",
				 programs->user_offline );
	gnome_config_set_string( "Programs/OnAuth",
				 programs->auth );
	gnome_config_set_string( "Programs/OnAuthRequest",
				 programs->auth_request );
	gnome_config_set_string( "Programs/OnListAdd",
				 programs->list_add );
	gnome_config_set_string( "Programs/OnContactList",
				 programs->contact_list );

	/* New Contact Section */
	gnome_config_clean_section( "NewContacts" );

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->inlist == FALSE )
		{
			contact = contact->next;
			continue;
		}
		contactKey = g_strdup_printf( "NewContacts/%u",
					      kontakt->uin );

		contactStr = g_strdup_printf( "%s%s%s%s%s%s%s",

	/* Start with the nickname */
					      (kontakt)->nick,

	/* If we append ANYTHING, we need a comma here */
					      ( kontakt->invis_list ||
		                 kontakt->vis_list ||
		                 kontakt->ignore_list ||
		                 kontakt->force_override ||
		                 kontakt->online_notify ? "," : "" ),

	/* If we're forcing their messages thru server, we append Ssrv */
	                  ( kontakt->force_override ? "Ssrv" : "" ),

	/* If they're on the invisible list, we append an Sinv */
		               ( kontakt->invis_list ? "Sinv" : "" ),

	/* If they're on the visible list, we append Svis here */
		               ( kontakt->vis_list ? "Svis" : "" ),

	/* If they're on the notify list, we append Snot here */
		               ( kontakt->online_notify ? "Snot" : "" ),

	/* If they're on the ignore list, we append Sign here */
		               ( kontakt->ignore_list ? "Sign" : "" ) );

		gnome_config_set_string( contactKey, contactStr );
		g_free( contactKey );
		g_free( contactStr );
		contact = contact->next;
	}

	/* Write the away messages to the config file */
	set_config_file_away_msgs();
	/* End of writing the away messages to the config file */

	gnome_config_set_int( "Existence/exists", 1 );

	gnome_config_sync();

	gnome_config_pop_prefix();

	return;
}

/*** Local functions ***/
void str2col(GdkColor *color, const gchar *str) {
    guint r, g, b;
    guint pix;

    sscanf(str, "#%04x%04x%04x%04x", &r, &g, &b, &pix);
    color->red = r;
    color->green = g;
    color->blue = b;
    color->pixel = pix;
}

int sort_compare( CONTACT_PTR c1, CONTACT_PTR c2 )
{

	return strcoll( c1->nick, c2->nick );
}
