/************************************
 Miscellaneous functions
 (c) 1999 Jeremy Wise
 GnomeICU
*************************************/

/*** GnomeICU header files ***/
#include "common.h"
#include "gtkspell.h"
#include "dirbrowser.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#ifdef GNOME_ICON
#include <libgnomeui/gnome-window-icon.h>
#endif
#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

/* In this file sometimes both contact and contact2 are used */
#define kontakt2 ((CONTACT_PTR)contact2->data)

typedef struct
{
	gpointer data;
	int i;
} dataandint;

GtkWidget *found_list;
GtkWidget *file_selector;

int start_new_info = TRUE;

/*** Local function declarations ***/
static void icq_allow_auth( GtkWidget *widget, gpointer data );
static void icq_accept_chat( GtkWidget *widget, GSList *contact );
static void icq_refuse_chat( GtkWidget *widget, GSList *contact );
static void icq_accept_file( GtkWidget *widget, struct xfer_struct *xfer );
static void icq_refuse_file( GtkWidget *widget, struct xfer_struct *xfer );
static void icq_refresh_list( GtkWidget *widget, gpointer data );
static void set_window_icon ( GtkWidget *window, gchar *name );
static void clear_i_window( GtkWidget *wigdet, gpointer data );
static void clear_pointer( GtkWidget *widget, gpointer *data );
static void toggle_force( GtkWidget *widget, CONTACT_PTR co );
static void grab_history( GtkWidget *widget, gpointer data );
static void get_contact_list( GtkWidget *widget, gpointer data );
static void build_mass_list(GSList *contact, GtkCList *uins_clist);
static void remove_user_question( GtkWidget *widget, gpointer data );
static void cb_menu_position (GtkMenu *menu, gint *x, gint *y, gpointer user_data);
static void reply_button_cb( GtkWidget *widget, gpointer data );
static void search_show_cb(GtkWidget *widget, gpointer data);
static void searchentry_changed(GtkEditable *widget, gpointer data);
static void search_cb(GtkWidget *widget, gpointer data);
static gchar *stripr( gchar *str );
static void add_user_to_list( GtkWidget *widget, gpointer data );
static gint compare_dates(const gint *a, const gint *b);
static void quote_click ( GtkWidget *widget);
static void more_clicked (GtkWidget *widget, gpointer userdata);
static void clist_op_clicked (GtkWidget *widget, gpointer userdata);
static void lists_change_list( GtkWidget *widget, gpointer data );
static void send_message_from_message_chat( GtkWidget *entry, GtkWidget *window );
static void show_clear_dialog(GtkWidget *widget, gpointer data);
static void clear_hist_cb(gint reply, gpointer data);
static void save_hist_cb(GtkWidget *widget, gpointer data);
static void file_ok_cb(GtkWidget *widget, gpointer data);

static void open_file( GtkWidget *widget, gpointer data );
static void del_file( GtkWidget *widget, gpointer data );
/* static void open_dir( GtkWidget *widget, gpointer data ); */

static void add_files( GtkWidget *widget, gpointer data);
static void remove_files( GtkWidget *widget, gpointer data);
static void add_files_final( gchar *text, gpointer user_data );

/* detaching stuff... */
static void detach_contact( GtkWidget *widget, gpointer data );
static void detach_contact_hide( GtkWidget *widget, gpointer data );
static void detach_window_click( GtkWidget *widget, GdkEventButton *event, gpointer data );
static gint detach_window_delete( GtkWidget *widget, GdkEvent *event, gpointer data );

gint animate_ref = 0;

/*** Global functions ***/
void animate_on( void )
{
	++animate_ref;

#ifndef NO_SCARY_EYBALLS

	/* If the eyes are already spinning, no need to start them again */
	if( animate_ref != 1 )
		return;

	gtk_widget_hide( eyes_still );
	gtk_widget_show( eyes_animated );
	gnome_animator_set_loop_type( GNOME_ANIMATOR( eyes_animated ),
	                              GNOME_ANIMATOR_LOOP_RESTART );
	gnome_animator_start( GNOME_ANIMATOR( eyes_animated ) );
#endif
}

void animate_off( void )
{
	--animate_ref;

	if( animate_ref < 0 )
		animate_ref = 0;

#ifndef NO_SCARY_EYEBALLS

	/* If we're not back down to zero yet, don't stop the eyes */
	if( animate_ref )
		return;

	gnome_animator_stop( GNOME_ANIMATOR( eyes_animated ) );
	gtk_widget_hide( eyes_animated );
	gtk_widget_show( eyes_still );
#endif
}

void icq_quit( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_quit\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->sok > 0 )
			close( kontakt->sok );
/*		if( kontakt->chat_sok > 0 )
			close( kontakt->chat_sok );
   HERE.. QUIT CLOSE	        */
		contact = contact->next;
	}

	if( MainData->window != NULL && GTK_WIDGET_VISIBLE( MainData->window ) )
		gdk_window_get_size( GTK_WIDGET( MainData->window )->window,
		                     &WindowWidth,
		                     &WindowHeight );
        gtkspell_stop();

	Save_RC();
#ifdef HAVE_ICUDB
	icudb_close_all();
#endif
	if( toggles->applet ) {
		applet_remove();
		applet_widget_gtk_main_quit();
	}
	else
		gtk_main_quit();
}

void icq_refresh( gpointer data, int sok, GdkInputCondition cond )
{
	static struct timeval tv;
	static fd_set readfds;

	tv.tv_sec = 2;
	tv.tv_usec = 500000;

#ifdef TRACE_FUNCTION
	g_print( "icq_refresh\n" );
#endif

	FD_ZERO(&readfds);
	FD_SET( MainData->sok, &readfds);

	/* Don't care about writefds and exceptfds: */
	select( MainData->sok+1, &readfds, NULL, NULL, &tv);

	if (FD_ISSET( MainData->sok, &readfds))
	{
		Handle_Server_Response();
	}

	Show_Quick_Status();
}

void icq_msgbox( STORED_MESSAGE_PTR message_text, UIN_T uin )
{
	GtkWidget *window = NULL;
	GtkWidget *table;
	GtkWidget *menuitem;
	GtkWidget *entry1;
	GtkWidget *entry2;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *fromfield;
	GtkWidget *emailfield = NULL;
	GtkWidget *ipfield = NULL;
	GtkWidget *timefield;
	GtkWidget *subjectfield = NULL;
	GtkWidget *scrolledwindow1;
	GtkWidget *text;
	GtkWidget *optionmenu;
	GtkWidget *optionmenu_menu;
	GtkWidget *scrolledwindow2;
	GtkWidget *respond_text;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *button3;
	GtkWidget *button4;
	GtkWidget *button5;
        GtkWidget *button6;
	GtkWidget *force_question;
   	/* Mass-send - NH */
	GtkWidget *more_hbox;
   	GtkWidget *hbox4;
   	GtkWidget *more_button;
   	GtkWidget *uins_clist;
   	GtkWidget *all_button;
   	GtkWidget *none_button;
   	GtkWidget *more_sep;
   	GtkWidget *somelabel;
   	GtkWidget *moreuinscroll;
   	GtkWidget *more_vbox;
   	GtkWidget *hbox5;
	GtkWidget *hbox6 = NULL;
	GtkWidget *label7;
	GtkWidget *optionmenu2;
	GtkWidget *optionmenu2_menu = NULL;

   	/* End mass-send */
	GtkAccelGroup *accel_group;
   	guint accel_widget;
	guchar *tmp, *tmp2 = NULL;

	gchar *new_str;

	char *msgtime = NULL, *msgtemp2 = NULL;

	int cx;
	char *nick;
	char *ptr, *ptr2, *ptr3, *buf[2];

	gchar *sender = NULL;

	GSList *contact, *contact2;

	int picked_user;

	GtkWidget *contact_list_clist;

	gchar *curl, *cdesc;
	GtkWidget *url, *desc;

	GString *sessionname;

#ifdef TRACE_FUNCTION
	g_print( "icq_msgbox\n" );
#endif

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	nick = kontakt->nick;

	if( g_slist_length( kontakt->stored_messages ) == 1 )
	{
		kontakt->icon_p = GetIcon_p( kontakt->status );
		kontakt->icon_b = GetIcon_b( kontakt->status );
		kontakt->need_update = 1;
	}

   	accel_group = gtk_accel_group_new();

/* Strip \r's out of text - \r's are for Windows people */
	new_str = stripr( message_text->message );
	g_free( message_text->message );
	message_text->message = new_str;

/*** User has received a TEXT message ***/
	if( message_text->type == MESSAGE_TEXT )
	{
		window = gnome_dialog_new (_("GnomeICU: Message Received"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "Message_Received", "GnomeICU");
		gtk_object_set_data (GTK_OBJECT (window), "window", window);
		gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, TRUE);
#ifdef GNOME_ICON
                set_window_icon( window, "gnomeicu-message.png" );
#endif

		gtk_widget_set_usize( window, -1, 375 );

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
		gtk_widget_show (dialog_vbox1);

	   	/* A hbox for the mass-send user list - NH */
	   	hbox4 = gtk_hbox_new (FALSE, 4);
	   	gtk_widget_ref (hbox4);
	   	gtk_object_set_data_full (GTK_OBJECT (window), "hbox4", hbox4,
					  (GtkDestroyNotify) gtk_widget_unref);
	   	gtk_widget_show (hbox4);
	   	gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox4, TRUE, TRUE, 0);
	   	/* End hbox */

		vbox1 = gtk_vbox_new (FALSE, 0);
		gtk_widget_ref (vbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (hbox4), vbox1, TRUE, TRUE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (vbox1), 6);

		hbox1 = gtk_hbox_new (FALSE, 0);
		gtk_widget_ref (hbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "hbox1", hbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (hbox1);
		gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 4);

		label1 = gtk_label_new (_("Sender:"));
		gtk_widget_ref (label1);
		gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 4);

		fromfield = gtk_entry_new ();
		gtk_widget_ref (fromfield);
		gtk_object_set_data_full (GTK_OBJECT (window), "fromfield", fromfield,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (fromfield);
		gtk_box_pack_start (GTK_BOX (hbox1), fromfield, FALSE, TRUE, 0);
		gtk_entry_set_editable (GTK_ENTRY (fromfield), FALSE);
		gtk_entry_set_text( GTK_ENTRY( fromfield ), nick );

		label2 = gtk_label_new (_("Time/Date:"));
		gtk_widget_ref (label2);
		gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label2);
		gtk_box_pack_start (GTK_BOX (hbox1), label2, TRUE, TRUE, 4);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);

		timefield = gtk_entry_new ();
		gtk_widget_ref (timefield);
		gtk_object_set_data_full (GTK_OBJECT (window), "timefield", timefield,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (timefield);
		gtk_entry_set_editable( GTK_ENTRY( timefield ), FALSE );
		gtk_box_pack_start (GTK_BOX (hbox1), timefield, FALSE, TRUE, 0);

		msgtime = g_strdup( message_text->message );
		cx = 0;
		while(msgtime[cx++] != '\n' );
		msgtime[cx-1] = 0;
		gtk_entry_set_text( GTK_ENTRY( timefield ), msgtime );
		g_free( msgtime );

		if ( uin == 10 )
		{
		     msgtemp2 = msgtime = g_strndup( message_text->message, 1024);
		     /* I know this is ugly, fix your translation  --Tester */
		     if (toggles->russian)
			  tmp = g_strdup_printf("%c", 192);
		     else
			  tmp = g_strdup_printf("%c", 0xFE);

//		     tmp2 = strsep( &msgtime, "\n");
		     tmp2 = strtok(msgtime, "\n");
		     g_assert(tmp2 != NULL);
//		     tmp2 = strsep( &msgtime, tmp);
		     tmp2 = strtok(NULL, tmp);
		     g_assert(tmp2 != NULL);

		     gtk_entry_set_text( GTK_ENTRY( fromfield ), tmp2 );

		     hbox1 = gtk_hbox_new (FALSE, 0);
		     gtk_widget_ref (hbox1);
		     gtk_object_set_data_full (GTK_OBJECT (window), "hbox1",
					       hbox1, (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (hbox1);
		     gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE,
					 FALSE, 4);

		     label1 = gtk_label_new (_("Email:"));
		     gtk_widget_ref (label1);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "label1", label1,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (label1);
		     gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE,
					 FALSE, 4);

		     emailfield = gtk_entry_new ();
		     gtk_widget_ref (emailfield);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "emailfield", emailfield,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (emailfield);
		     gtk_box_pack_start (GTK_BOX (hbox1), emailfield, FALSE,
					 TRUE, 0);
		     gtk_entry_set_editable (GTK_ENTRY (emailfield), FALSE);

		     msgtime +=  2;
//		     tmp2 = strsep( &msgtime, tmp);
		     tmp2 = strtok(NULL, tmp);
		     g_assert(tmp2 != NULL);

		     gtk_entry_set_text( GTK_ENTRY( emailfield ), tmp2 );
//		     msgtime += 2;
//		     tmp2 = strsep( &msgtime, "\n");
		     tmp2 = strtok(NULL, tmp);
		     tmp2 = strtok(NULL, "\n");
		     g_assert(tmp2 != NULL);


		     label1 = gtk_label_new (_("Sender IP:"));
		     gtk_widget_ref (label1);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "label1", label1,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_box_pack_start (GTK_BOX (hbox1), label1,
					 FALSE,FALSE, 4);

		     ipfield = gtk_entry_new ();
		     gtk_widget_ref (ipfield);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "ipfield", ipfield,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_box_pack_start (GTK_BOX (hbox1), ipfield,
					 FALSE, TRUE, 0);
		     gtk_entry_set_editable (GTK_ENTRY (ipfield),
					     FALSE);
		     gtk_object_set_data ( GTK_OBJECT( ipfield ), "label", label1 );

		     if (!strncmp(tmp2,"Sender IP:", 10))
		     {
			  gtk_widget_show (label1);
			  gtk_widget_show (ipfield);
			  tmp2 = strchr(tmp2, ':') + 2;
			  g_assert(tmp2 != (guchar *)2);
			  gtk_entry_set_text( GTK_ENTRY( ipfield ),
					      tmp2 );
//			  tmp2 = strsep( &msgtime, "\n");
			  tmp2 = strtok( NULL, "\n");
			  g_assert(tmp2 != NULL);

		     }

		     hbox1 = gtk_hbox_new (FALSE, 0);
		     gtk_widget_ref (hbox1);
		     gtk_object_set_data_full (GTK_OBJECT (window), "hbox1",
					       hbox1, (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (hbox1);
		     gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE,
					 FALSE, 4);

		     label1 = gtk_label_new (_("Subject:"));
		     gtk_widget_ref (label1);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "label1", label1,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (label1);
		     gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE,
					 FALSE, 4);

		     subjectfield = gtk_entry_new ();
		     gtk_widget_ref (subjectfield);
		     gtk_object_set_data_full (GTK_OBJECT (window),
					       "subjectfield", subjectfield,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (subjectfield);
		     gtk_box_pack_start (GTK_BOX (hbox1), subjectfield, FALSE,
					 TRUE, 0);

		     tmp2 = strchr(tmp2, ':' ) + 2;
		     g_assert(tmp2 != (guchar *)2);
		     gtk_entry_set_editable (GTK_ENTRY (subjectfield), FALSE);
		     gtk_entry_set_text( GTK_ENTRY( subjectfield ), tmp2 );

//		     tmp2 = strsep( &msgtime, tmp);
		     tmp2 = strtok( NULL, tmp);
		     g_assert(tmp2 != NULL);
		     g_free(tmp);
		}

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_ref (scrolledwindow1);
		gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (scrolledwindow1);
		gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_ref (text);
		gtk_object_set_data_full (GTK_OBJECT (window), "text", text,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		kanji_conv_to_locale_s( &message_text->message );

		if ( uin == 10 )
		{
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      tmp2, -1);
		     g_free( msgtemp2 );
		}
		else
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      ( strchr( message_text->message, '\n' ) + 1 ), -1 );

		hbox3 = gtk_hbox_new (FALSE, 0);
		gtk_widget_ref (hbox3);
		gtk_object_set_data_full (GTK_OBJECT (window), "hbox3", hbox3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		if (uin != 10)
		     gtk_widget_show (hbox3);
		gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 6);

		button5 = gtk_button_new_with_label( ""  );
	   	accel_widget = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button5)->child),_("_Reply >>"));
	   	gtk_widget_add_accelerator(button5, "clicked", accel_group,
					   accel_widget, GDK_MOD1_MASK, 0);
		gtk_widget_ref( button5 );
		gtk_object_set_data_full( GTK_OBJECT( window ), "button5", button5,
		                          (GtkDestroyNotify) gtk_widget_unref );
		gtk_widget_show( button5 );
		gtk_box_pack_end( GTK_BOX( hbox3 ), button5, FALSE, FALSE, 0 );

		gtk_signal_connect( GTK_OBJECT( button5 ), "clicked",
		                    GTK_SIGNAL_FUNC( reply_button_cb ),
		                    NULL );

		vbox2 = gtk_vbox_new( FALSE, 0 );
		gtk_widget_ref( vbox2 );
		gtk_object_set_data_full( GTK_OBJECT( window ), "vbox2", vbox2,
		                          (GtkDestroyNotify) gtk_widget_unref );
		gtk_box_pack_start( GTK_BOX( vbox1 ), vbox2, TRUE, TRUE, 0 );

		gtk_object_set_data( GTK_OBJECT( button5 ), "box", vbox2 );
		gtk_object_set_data( GTK_OBJECT( button5 ), "hbox", hbox3 );

		hbox2 = gtk_hbox_new (FALSE, 0);
		gtk_widget_ref (hbox2);
		gtk_object_set_data_full (GTK_OBJECT (window), "hbox2", hbox2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (hbox2);
		gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, FALSE, 6);

		label3 = gtk_label_new (_("Reply to:"));
		gtk_widget_ref (label3);
		gtk_object_set_data_full (GTK_OBJECT (window), "label3", label3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label3);
		gtk_box_pack_start (GTK_BOX (hbox2), label3, FALSE, FALSE, 0);
		gtk_misc_set_padding (GTK_MISC (label3), 4, 0);

		optionmenu = gtk_option_menu_new ();
		gtk_widget_ref (optionmenu);
		gtk_object_set_data_full (GTK_OBJECT (window), "optionmenu", optionmenu,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (optionmenu);
		gtk_box_pack_start (GTK_BOX (hbox2), optionmenu, FALSE, TRUE, 0);
		optionmenu_menu = gtk_menu_new ();

		contact2 = Contacts;
		cx = 0;
		picked_user = 0;
		while( contact2 != NULL )
		{
			menuitem = gtk_menu_item_new_with_label( kontakt2->nick );
			gtk_widget_show (menuitem);
			gtk_object_set_data( GTK_OBJECT( menuitem ), "contact", contact2 );
			gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
			if( contact == contact2 )
				picked_user = cx;
			contact2 = contact2->next;
			cx++;
		}

		gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
		gtk_option_menu_set_history( GTK_OPTION_MENU( optionmenu ), picked_user );

                somelabel = gtk_label_new("");
                more_button = gtk_toggle_button_new();
                accel_widget = gtk_label_parse_uline(GTK_LABEL(somelabel),_("_Multiple"));
                gtk_widget_add_accelerator(more_button, "clicked", accel_group,
                                           accel_widget, GDK_MOD1_MASK, 0);
                gtk_box_pack_end( GTK_BOX( hbox2 ), more_button, FALSE, FALSE, 0 );
                gtk_object_set_data( GTK_OBJECT( more_button ), "menu", optionmenu_menu );
                gtk_signal_connect( GTK_OBJECT( more_button ), "toggled",
                                    GTK_SIGNAL_FUNC( more_clicked ), NULL );

                gtk_container_add(GTK_CONTAINER(more_button), GTK_WIDGET(somelabel));
                gtk_widget_show(somelabel);
                gtk_widget_show( more_button );

                gtk_object_set_data(GTK_OBJECT(more_button), "optionmenu", optionmenu);
                gtk_object_set_data(GTK_OBJECT(more_button), "label", label3);

	        button6 = gtk_button_new_with_label ("");
	   	accel_widget = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button6)->child),_("_Quote >>"));
	   	gtk_widget_add_accelerator(button6, "clicked", accel_group,
					   accel_widget, GDK_MOD1_MASK, 0);
	        gtk_widget_ref(button6);
		gtk_object_set_data_full (GTK_OBJECT (window), "button6", button6,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button6);
		gtk_box_pack_end (GTK_BOX (hbox2), button6, FALSE, FALSE, 0);
		gtk_object_set_data( GTK_OBJECT( button6 ), "menu", optionmenu_menu );

		scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_ref (scrolledwindow2);
		gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow2", scrolledwindow2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (scrolledwindow2);
		gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow2, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		respond_text = gtk_text_new (NULL, NULL);
		GTK_WIDGET_SET_FLAGS (respond_text, GTK_CAN_DEFAULT);

		gtk_widget_ref (respond_text);
		gtk_object_set_data_full (GTK_OBJECT (window), "respond_text", respond_text,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (respond_text);
                if (toggles->check_spell)
                {
                    if (!gtkspell_running())
                        gtkspell_start(NULL, ispell_cmd);
                    gtkspell_attach(GTK_TEXT(respond_text));
                }
		gtk_text_set_word_wrap( GTK_TEXT( respond_text ), TRUE );
		gtk_container_add (GTK_CONTAINER (scrolledwindow2), respond_text);
		gtk_text_set_editable( GTK_TEXT( respond_text ), TRUE );

	        gtk_object_set_data( GTK_OBJECT( button6 ), "text",  text);
	        gtk_object_set_data( GTK_OBJECT( button6 ), "respond_text", respond_text);

	      	/* A hbox for the more button */
      		more_hbox = gtk_hbox_new (FALSE, 4);
		gtk_widget_ref (more_hbox);
		gtk_object_set_data_full (GTK_OBJECT (window), "more_hbox", more_hbox,
	        	                  (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (more_hbox);
		gtk_box_pack_start (GTK_BOX (vbox2), more_hbox, FALSE, FALSE, 0);
   		/* End hbox */

		force_question = gtk_check_button_new_with_label( _("Force message through server") );
		gtk_box_pack_start( GTK_BOX( more_hbox ), force_question, FALSE, FALSE, 0 );
		gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( force_question ),
		                             kontakt->force_override );
		if( toggles->force )
			gtk_widget_set_sensitive( force_question, FALSE );
		if( kontakt->force_override )
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( force_question ), TRUE );

		gtk_widget_show( force_question );

		gtk_signal_connect( GTK_OBJECT( force_question ), "toggled",
		                    GTK_SIGNAL_FUNC( toggle_force ),
		                    kontakt );
	/* Mass send code - NH */
	/*
	 * I know this code is not TAB-ed correctly,
	 * but going thru each line and pressing -Tab?
	 * If this code was in a function, called from
	 * both icq_msgbox and icq_showmessage that wouldn't
	 * be a problem now, would it?
	 * No thanks!
	 */

        button4 = gtk_button_new_with_label ("");
        accel_widget = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button4)->child),_("_History"));
        gtk_widget_add_accelerator(button4, "clicked", accel_group,
                                   accel_widget, GDK_MOD1_MASK, 0);
        gtk_widget_ref (button4);
        gtk_object_set_data_full (GTK_OBJECT (window), "button4", button4,
                                  (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (button4);
        gtk_box_pack_end (GTK_BOX (more_hbox), button4, FALSE, FALSE, 0);
        gtk_object_set_data( GTK_OBJECT( button4 ), "menu", optionmenu_menu );

   	more_vbox = gtk_vbox_new(FALSE, 4);
	gtk_widget_ref (more_vbox);
	gtk_object_set_data_full (GTK_OBJECT (window), "more_vbox", more_vbox,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (more_vbox);
	gtk_box_pack_end (GTK_BOX (hbox4), more_vbox, FALSE, FALSE, 0);

	moreuinscroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (moreuinscroll);
	gtk_object_set_data_full (GTK_OBJECT (window), "moreuinscroll", moreuinscroll,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (moreuinscroll), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
   	gtk_box_pack_start(GTK_BOX(more_vbox), moreuinscroll, TRUE, TRUE, 0);

   	uins_clist = gtk_clist_new(2);
   	gtk_widget_ref(uins_clist);
   	gtk_object_set_data_full(GTK_OBJECT(window), "uins_clist", uins_clist,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_widget_set_name(uins_clist, "uins_clist");
	gtk_object_set_data(GTK_OBJECT(more_button), "uins_clist", uins_clist);
   	gtk_clist_set_selection_mode(GTK_CLIST(uins_clist), GTK_SELECTION_MULTIPLE);
   	gtk_container_add(GTK_CONTAINER(moreuinscroll), uins_clist);
   	gtk_widget_show(uins_clist);

      	gtk_clist_set_column_auto_resize(GTK_CLIST(uins_clist), 0, TRUE);
   	gtk_clist_set_column_visibility(GTK_CLIST(uins_clist), 1, FALSE);

	build_mass_list(contact, GTK_CLIST(uins_clist));
	
      	hbox5 = gtk_hbox_new(FALSE, 2);
	gtk_widget_ref (hbox5);
	gtk_object_set_data_full (GTK_OBJECT (window), "hbox5", hbox5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_end (GTK_BOX (more_vbox), hbox5, FALSE, FALSE, 0);

   	none_button = gtk_button_new_with_label(_("None"));
	gtk_box_pack_end (GTK_BOX(hbox5), none_button, TRUE, TRUE, 0);
   	gtk_widget_show(none_button);

      	all_button = gtk_button_new_with_label(_("All"));
	gtk_box_pack_end (GTK_BOX(hbox5), all_button, TRUE, TRUE, 0);
   	gtk_widget_show(all_button);

   	gtk_object_set_data(GTK_OBJECT(all_button), "uins_clist", uins_clist);
   	gtk_object_set_data(GTK_OBJECT(none_button), "uins_clist", uins_clist);

   	gtk_signal_connect(GTK_OBJECT(all_button), "clicked", GTK_SIGNAL_FUNC(clist_op_clicked), GINT_TO_POINTER(1));
   	gtk_signal_connect(GTK_OBJECT(none_button), "clicked", GTK_SIGNAL_FUNC(clist_op_clicked), NULL);

      	gtk_object_set_data(GTK_OBJECT(more_button), "more_vbox", more_vbox);

      	more_sep = gtk_vseparator_new();
   	gtk_box_pack_end( GTK_BOX( hbox4 ), more_sep, FALSE, FALSE, 0);
   	gtk_object_set_data(GTK_OBJECT(more_button), "more_sep", more_sep);
	/* End mass send code - NH */

		dialog_action_area1 = GNOME_DIALOG (window)->action_area;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
		gtk_widget_show (dialog_action_area1);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

		gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
		                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button1);
		gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
		gtk_widget_hide( button1 );

		gtk_object_set_data( GTK_OBJECT( button5 ), "reply", button1 );

		gtk_object_set_data( GTK_OBJECT( respond_text ), "button", button1 );
		gtk_object_set_data( GTK_OBJECT( button1 ), "menu", optionmenu_menu );
		gtk_object_set_data( GTK_OBJECT( button1 ), "contact", contact );
		gtk_object_set_data( GTK_OBJECT( button1 ), "text", respond_text );
		gtk_object_set_data( GTK_OBJECT( button1 ), "force", NULL );
		gtk_object_set_data( GTK_OBJECT( button1 ), "more_button", more_button );

		gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
		                                        _("Read Next"), GNOME_STOCK_PIXMAP_FORWARD);
		button2 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button2);
		gtk_object_set_data_full (GTK_OBJECT (window), "button2", button2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button2);
		GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

		kontakt->read_next = button2;

		gtk_object_set_data( GTK_OBJECT( respond_text ), "readnext", button2 );
		gtk_object_set_data( GTK_OBJECT( button2 ), "contact", contact );
		gtk_object_set_data( GTK_OBJECT( button2 ), "text", text );
		gtk_object_set_data( GTK_OBJECT( button2 ), "time", timefield );
		if ( uin == 10 )
		{
		     gtk_object_set_data( GTK_OBJECT( button2 ),
					  "fromfield", fromfield );
		     gtk_object_set_data( GTK_OBJECT( button2 ),
					  "emailfield", emailfield );
		     gtk_object_set_data( GTK_OBJECT( button2 ),
					  "subjectfield", subjectfield );
		     gtk_object_set_data( GTK_OBJECT( button2 ),
					  "ipfield", ipfield );
		}

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button3);
		gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button3);
		GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

		gtk_object_set_data( GTK_OBJECT( respond_text ), "cancel", button3 );

		gtk_object_set_data( GTK_OBJECT( button5 ), "readnext", button2 );
		gtk_object_set_data( GTK_OBJECT( button5 ), "cancel", button3 );

		gtk_signal_connect_after( GTK_OBJECT( respond_text ), "key_press_event",
		                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

		gtk_signal_connect( GTK_OBJECT( button5 ), "key_press_event",
		                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

		gtk_signal_connect (GTK_OBJECT (button4), "clicked",
		                    GTK_SIGNAL_FUNC (grab_history),
		                    NULL);


		gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		                    GTK_SIGNAL_FUNC (icq_sendmessage),
		                    NULL);

		gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		                    GTK_SIGNAL_FUNC (icq_refresh_list),
		                    NULL);

		gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
		                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
		                           GTK_OBJECT( window ));


		gtk_signal_connect (GTK_OBJECT (button2), "destroy",
		                    GTK_SIGNAL_FUNC (gtk_widget_destroyed),
		                    &kontakt->read_next);

		gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		                    GTK_SIGNAL_FUNC (read_next),
		                    NULL);

         	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
				    GTK_SIGNAL_FUNC (quote_click),
		                    NULL);

		gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		                    GTK_SIGNAL_FUNC (icq_refresh_list),
		                    NULL);
		gtk_signal_connect_object (GTK_OBJECT (button3), "clicked",
		                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
		                           GTK_OBJECT( window ));

		gtk_object_set_data( GTK_OBJECT( button5 ), "text", respond_text );

		if( toggles->full_reply && uin != 10)
		{
			gtk_widget_hide_all( hbox3 );
			gtk_widget_show( vbox2 );
			gtk_widget_show( button1 );
			gtk_widget_grab_focus( respond_text );
			gtk_widget_grab_default( respond_text );
		}
		else
			gtk_widget_grab_focus (button5);

	   	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
		gtk_widget_show( window );
	}

/*** User has received a CONTACT LIST ***/
	if( message_text->type == MESSAGE_CONT_LIST )
	{
		ptr = (char*)create_recd_contact_list_window( kontakt );
		gtk_widget_show( GTK_WIDGET( ptr ) );

		contact_list_clist = gtk_object_get_data( GTK_OBJECT( ptr ), "clist" );

		ptr = message_text->message;
		ptr2 = ptr;

		ptr = strchr( ptr, '\xFE' );
		ptr[0] = 0;
		ptr2 = (ptr + 1);
		ptr = strchr( ptr2, '\xFE' );
		if( ptr == NULL )
			return;
		ptr[0] = 0;

		while( 1 )
		{
			ptr3 = (ptr + 1);
			ptr = strchr( ptr3, '\xFE' );
			if( ptr == NULL )
				break;
			ptr[0] = 0;

			buf[0] = ptr2;
			buf[1] = ptr3;
			gtk_clist_append( GTK_CLIST( contact_list_clist ), buf );

			ptr2 = (ptr + 1);
			ptr = strchr( ptr2, '\xFE' );
			if( ptr == NULL )
				break;
			ptr[0] = 0;
		}

		return;
	}

/*** User has added you to his/her list ***/
	if( message_text->type == MESSAGE_USER_ADD )
	{
		if (kontakt->info->sex == FEMALE)
		  sender = g_strdup_printf( _("%s has added you to her list"), nick );
		else if (kontakt->info->sex == MALE)
		  sender = g_strdup_printf( _("%s has added you to his list"), nick );
		else /* No sex specified */
		  sender = g_strdup_printf( _("%s has added you to his/her list"), nick );


		gtk_widget_show( gnome_message_box_new( _( sender ),
		                                        GNOME_MESSAGE_BOX_INFO,
		                                        GNOME_STOCK_BUTTON_OK, NULL ) );
		g_free( sender );
		return;
	}

/*** Sender has authorized you to add him to your list ***/
	if( message_text->type == MESSAGE_USER_AUTHD )
	{
		sender = g_strdup_printf( _("You are authorized to add %s to your list"), nick );

		gtk_widget_show( gnome_message_box_new( _( sender ),
		                                        GNOME_MESSAGE_BOX_INFO,
		                                        GNOME_STOCK_BUTTON_OK, NULL ) );
		g_free( sender );
		return;
	}

/*** Sender has sent you a chat request ***/
	if( message_text->type == MESSAGE_CHAT_REQ )
	{
		window = gnome_dialog_new (_("GnomeICU: Chat Request"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "Chat_Request", "GnomeICU");
		gtk_object_set_data (GTK_OBJECT (window), "window", window);
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);

#ifdef GNOME_ICON
                set_window_icon( window, "gnomeicu-chat.png" );
#endif

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
		gtk_widget_show (dialog_vbox1);

		vbox1 = gtk_vbox_new (FALSE, 0);
		gtk_widget_ref (vbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		sender = g_strdup_printf( _("Accept Chat Request from %s?\n"), nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_ref (label1);
		gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

		if (message_text->chatsessionname != NULL)
		{

		     sender = g_strdup_printf( _("Multi-party session:  %s?\n"),  message_text->chatsessionname);
		     label1 = gtk_label_new ( sender );
		     g_free( sender );
		     gtk_widget_ref (label1);
		     gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
					       (GtkDestroyNotify) gtk_widget_unref);
		     gtk_widget_show (label1);
		     gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
		}

		label2 = gtk_label_new (_("Reason:"));
		gtk_widget_ref (label2);
		gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label2);
		gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_ref (scrolledwindow1);
		gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (scrolledwindow1);
		gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_ref (text);
		gtk_object_set_data_full (GTK_OBJECT (window), "text", text,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );
/*		if( kontakt->chat_reason != NULL )
		{
				kanji_conv_to_locale_s( &kontakt->chat_reason );
				gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				                 kontakt->chat_reason, -1 );
				g_free( kontakt->chat_reason );
				kontakt->chat_reason = NULL;
		}
*/
		if (message_text->message)
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      message_text->message, -1 );
		else
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				                 _("No reason given"), -1 );

		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		if (Sessions != NULL && message_text->chatsessionname == NULL)
		{
		     GSList *gslcsession;
		     GSList *member_cc;

		     hbox6 = gtk_hbox_new(FALSE, 0);
		     gtk_box_pack_start (GTK_BOX (vbox1), hbox6,  TRUE, TRUE, 0);
		     label7 = gtk_label_new(_("Invite to session: "));
		     gtk_box_pack_start (GTK_BOX (hbox6), label7,  TRUE, TRUE, 0);
		     optionmenu2 = gtk_option_menu_new();
		     gtk_box_pack_start (GTK_BOX (hbox6), optionmenu2,  TRUE, TRUE, 0);
		     optionmenu2_menu = gtk_menu_new();
		     gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu2), optionmenu2_menu);

		     for (gslcsession = Sessions;
			  gslcsession != NULL;
			  gslcsession = gslcsession->next)
		     {
			  sessionname = g_string_new(our_info->nick);
			  for (member_cc = ((ChatSession *)gslcsession->data)->members;
			       member_cc != NULL;
			       member_cc = member_cc->next)
			  {
			       g_string_sprintfa(sessionname, ", %s", ((ChatContact *)member_cc->data)->contact->nick);
			  }
			  menuitem = gtk_menu_item_new_with_label(sessionname->str);
			  g_string_free (sessionname, TRUE);
			  gtk_menu_append(GTK_MENU (optionmenu2_menu), menuitem);
			  gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", gslcsession->data);
		     }

		     menuitem = gtk_menu_item_new_with_label("None");
		     gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", NULL);
		     gtk_menu_prepend(GTK_MENU(optionmenu2_menu), menuitem);
		     gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu2),0);
		     gtk_widget_show_all (hbox6);

		}


		dialog_action_area1 = GNOME_DIALOG (window)->action_area;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
		gtk_widget_show (dialog_action_area1);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_YES );
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button1);
		gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button1);
		if (GTK_IS_HBOX(hbox6))
		     gtk_object_set_data (GTK_OBJECT (button1), "OptionMenu", optionmenu2_menu);
		else {
		     gtk_object_set_data (GTK_OBJECT (button1), "OptionMenu", NULL);
		}
		gtk_object_set_data (GTK_OBJECT (button1), "ChatContact",message_text->chatcontact);

		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

		gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_accept_chat ),
		                    contact );

		gtk_signal_connect_object( GTK_OBJECT( button1 ), "clicked",
		                           (GtkSignalFunc) gtk_widget_destroy,
		                           GTK_OBJECT( window ) );

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_NO);
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button3);
		gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_object_set_data (GTK_OBJECT (button3), "ChatContact",message_text->chatcontact);
		gtk_widget_show (button3);
		GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

		gtk_signal_connect( GTK_OBJECT( button3 ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_refuse_chat ),
		                    contact );

		gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
		                           (GtkSignalFunc) gtk_widget_destroy,
		                           GTK_OBJECT( window ) );

		gtk_widget_show_all( window );
	}

/*** Sender has offered you a file ***/
	if( message_text->type == MESSAGE_FILE_REQ )
	{
		window = gnome_dialog_new (_("GnomeICU: File Offer"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "File_Offer", "GnomeICU");
		gtk_object_set_data (GTK_OBJECT (window), "window", window);
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);

#ifdef GNOME_ICON
                set_window_icon( window, "gnomeicu-file.png" );
#endif

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
		gtk_widget_show (dialog_vbox1);

		vbox1 = gtk_vbox_new (FALSE, 4);
		gtk_widget_ref (vbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		sender = g_strdup_printf( _("Accept file from %s?\n"), nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_ref (label1);
		gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

		table = gtk_table_new (4, 3, FALSE);
		gtk_widget_ref (table);
		gtk_object_set_data_full (GTK_OBJECT (window), "table", table,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (table);
		gtk_box_pack_start (GTK_BOX (vbox1), table, TRUE, TRUE, 0);

		label3 = gtk_label_new (_("Size:"));
		gtk_widget_ref (label3);
		gtk_object_set_data_full (GTK_OBJECT (window), "label3", label3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label3);
		gtk_table_attach (GTK_TABLE (table), label3, 0, 1, 1, 2,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		label2 = gtk_label_new (_("Name:"));
		gtk_widget_ref (label2);
		gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label2);
		gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 0, 1,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);

		label5 = gtk_label_new ("");
		gtk_widget_ref (label5);
		gtk_object_set_data_full (GTK_OBJECT (window), "label5", label5,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label5);
		gtk_table_attach (GTK_TABLE (table), label5, 1, 2, 2, 3,
		                  (GtkAttachOptions) (0),
		                  (GtkAttachOptions) (0), 0, 0);

		label4 = gtk_label_new (_("\nReason:"));
		gtk_widget_ref (label4);
		gtk_object_set_data_full (GTK_OBJECT (window), "label4", label4,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label4);
		gtk_table_attach (GTK_TABLE (table), label4, 0, 2, 2, 3,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label4), 7.45058e-09, 0.5);

		label6 = gtk_label_new ("");
		gtk_widget_ref (label6);
		gtk_object_set_data_full (GTK_OBJECT (window), "label6", label6,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label6);
		gtk_table_attach (GTK_TABLE (table), label6, 2, 3, 2, 3,
		                  (GtkAttachOptions) (0),
		                  (GtkAttachOptions) (0), 0, 0);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_ref (scrolledwindow1);
		gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (scrolledwindow1);
		gtk_table_attach (GTK_TABLE (table), scrolledwindow1, 0, 3, 3, 4,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_ref (text);
		gtk_object_set_data_full (GTK_OBJECT (window), "text", text,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );
		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		kanji_conv_to_locale_s( &message_text->message );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 message_text->message, -1 );

		entry1 = gtk_entry_new ();
		gtk_widget_ref (entry1);
		gtk_object_set_data_full (GTK_OBJECT (window), "entry1", entry1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (entry1);
		gtk_entry_set_editable( GTK_ENTRY( entry1 ), FALSE );
		sender = g_strdup_printf( "%d", message_text->xfer->total_bytes );
		gtk_entry_set_text( GTK_ENTRY( entry1 ), sender );

		g_free( sender );
		gtk_table_attach (GTK_TABLE (table), entry1, 1, 3, 1, 2,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		entry2 = gtk_entry_new ();
		gtk_widget_ref (entry2);
		gtk_object_set_data_full (GTK_OBJECT (window), "entry2", entry2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (entry2);
		gtk_entry_set_editable( GTK_ENTRY( entry2 ), FALSE );
		gtk_entry_set_text( GTK_ENTRY( entry2 ), message_text->xfer->filename );

		gtk_table_attach (GTK_TABLE (table), entry2, 1, 3, 0, 1,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		dialog_action_area1 = GNOME_DIALOG (window)->action_area;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
		gtk_widget_show (dialog_action_area1);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_YES);
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button1);
		gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button1);
		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_NO);
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button3);
		gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button3);
		GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

		gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		                    GTK_SIGNAL_FUNC (icq_accept_file),
		                    message_text->xfer);
		gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
		                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
		                           GTK_OBJECT( window ));
		gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		                    GTK_SIGNAL_FUNC (icq_refuse_file),
		                    message_text->xfer);
		gtk_signal_connect_object (GTK_OBJECT (button3), "clicked",
		                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
		                           GTK_OBJECT( window ));

		gtk_widget_show_all( window );
	}


/* Sender wishes to add you to his/her list */
	if( message_text->type == MESSAGE_AUTH_REQ )
	{
		window = gnome_dialog_new (_("GnomeICU: Authorization Request"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "Auth_Request", "GnomeICU");
		gtk_object_set_data (GTK_OBJECT (window), "window", window);
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
		gtk_widget_show (dialog_vbox1);

		vbox1 = gtk_vbox_new (FALSE, 0);
		gtk_widget_ref (vbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		sender = g_strdup_printf( _("Auth Request from %s:\n"), nick );

		label1 = gtk_label_new ( sender );
		g_free( sender );
		gtk_widget_ref (label1);
		gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

		hbox1 = gtk_hbox_new (FALSE, 0);
		gtk_widget_ref (hbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "hbox1", hbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (hbox1);
		gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

		label3 = gtk_label_new (_("Time/Date:"));
		gtk_widget_ref (label3);
		gtk_object_set_data_full (GTK_OBJECT (window), "label3", label3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label3);
		gtk_box_pack_start (GTK_BOX (hbox1), label3, TRUE, TRUE, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		timefield = gtk_entry_new ();
		gtk_widget_ref (timefield);
		gtk_object_set_data_full (GTK_OBJECT (window), "timefield", timefield,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (timefield);
		gtk_entry_set_editable( GTK_ENTRY( timefield ), FALSE );
		gtk_box_pack_start (GTK_BOX (hbox1), timefield, FALSE, TRUE, 0);

		msgtime = g_strdup( message_text->message );
		cx = 0;
		while(msgtime[cx++] != '\n' );
		msgtime[cx-1] = 0;
		gtk_entry_set_text( GTK_ENTRY( timefield ), msgtime );
		g_free( msgtime );

		label2 = gtk_label_new (_("Reason:"));
		gtk_widget_ref (label2);
		gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label2);
		gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

		scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_ref (scrolledwindow1);
		gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (scrolledwindow1);
		gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		text = gtk_text_new (NULL, NULL);
		gtk_widget_ref (text);
		gtk_object_set_data_full (GTK_OBJECT (window), "text", text,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (text);
		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
		gtk_text_set_editable( GTK_TEXT( text ), FALSE );

		kanji_conv_to_locale_s( &message_text->message );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 ( strchr( message_text->message, '\n' ) + 1 ), -1 );

		gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);

		dialog_action_area1 = GNOME_DIALOG (window)->action_area;
		gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
		gtk_widget_show (dialog_action_area1);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

		gnome_dialog_append_button (GNOME_DIALOG (window), _("Allow") );
		button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button1);
		gtk_object_set_data( GTK_OBJECT( button1 ), "uin", GUINT_TO_POINTER(kontakt->uin) );
		gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button1);
		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

		gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
		                    GTK_SIGNAL_FUNC( icq_allow_auth ), NULL );

		gtk_signal_connect_object(GTK_OBJECT( button1 ), "clicked",
		                          (GtkSignalFunc) gtk_widget_destroy,
	                             GTK_OBJECT( window ) );

		gnome_dialog_append_button (GNOME_DIALOG (window), _("Refuse") );
		button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_ref (button3);
		gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button3);
		GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

		gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
		                           (GtkSignalFunc) gtk_widget_destroy,
		                           GTK_OBJECT( window ) );

		gtk_widget_show_all( window );
	}

/* Sender has sent you a URL */
	if( message_text->type == MESSAGE_URL )
	{
		int url_len = 0, desc_len = 0;

		curl = g_strdup( message_text->message );
		cdesc = g_strdup( message_text->message );

		sender = g_strdup_printf( _("Received URL from %s:"), nick );

		for( cx = ( strchr( message_text->message, '\n' ) - message_text->message ); ; cx ++ )
		{
			if( message_text->message[ cx ] == '\xFE' ||
			    message_text->message[ cx ] == 0x00 )
			{
				if( message_text->message[ cx ] == 0x00 )
				{
					url_len = cx - 1 - desc_len - ( strchr( message_text->message, '\n' ) - message_text->message );
					break;
				}
				else
					desc_len = cx - 1 - ( strchr( message_text->message, '\n' ) - message_text->message );
			}
		}

		memcpy( cdesc, strchr( message_text->message, '\n' ) + 1, desc_len );
		cdesc[ desc_len ] = 0x00;
		memcpy( curl, strchr( message_text->message, '\n' ) + 2 + desc_len, url_len );
		curl[ url_len ]  = 0x00;

		window = gnome_dialog_new (_("GnomeICU: URL"), NULL);
		gtk_window_set_wmclass (GTK_WINDOW (window), "URL", "GnomeICU");
		gtk_widget_set_name (window, "window");
		gtk_object_set_data (GTK_OBJECT (window), "window", window);
		gtk_widget_set_usize (window, 400, -2);
		GTK_WINDOW (window)->type = GTK_WINDOW_DIALOG;
		gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
		gtk_window_set_default_size( GTK_WINDOW( window ), 500, 150 );
		gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
		gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

#ifdef GNOME_ICON
                set_window_icon( window, "gnomeicu-url.png" );
#endif

		dialog_vbox1 = GNOME_DIALOG (window)->vbox;
		gtk_widget_set_name (dialog_vbox1, "dialog_vbox1");
		gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
		gtk_widget_show (dialog_vbox1);

		vbox1 = gtk_vbox_new (FALSE, 4);
		gtk_widget_set_name (vbox1, "vbox1");
		gtk_widget_ref (vbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (vbox1);
		gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

		label1 = gtk_label_new ( sender );
		gtk_widget_set_name (label1, "label1");
		gtk_widget_ref (label1);
		gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label1);
		gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
		gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

		table = gtk_table_new (2, 2, FALSE);
		gtk_widget_set_name (table, "table");
		gtk_widget_ref (table);
		gtk_object_set_data_full (GTK_OBJECT (window), "table", table,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (table);
		gtk_box_pack_start (GTK_BOX (vbox1), table, TRUE, TRUE, 0);
		gtk_table_set_row_spacings (GTK_TABLE (table), 4);
		gtk_table_set_col_spacings (GTK_TABLE (table), 4);

		hbox1 = gtk_hbox_new (FALSE, 4);
		gtk_widget_set_name (hbox1, "hbox1");
		gtk_widget_ref (hbox1);
		gtk_object_set_data_full (GTK_OBJECT (window), "hbox1", hbox1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (hbox1);
		gtk_table_attach (GTK_TABLE (table), hbox1, 1, 2, 0, 1,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

		url = gtk_entry_new ();
		gtk_widget_set_name (url, "url");
		gtk_widget_ref (url);
		gtk_object_set_data_full (GTK_OBJECT (window), "url", url,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (url);
		gtk_box_pack_start (GTK_BOX (hbox1), url, TRUE, TRUE, 0);

		gtk_entry_set_text( GTK_ENTRY( url ), curl );

		button1 = gtk_button_new_with_label (_("Go To"));
		gtk_widget_set_name (button1, "button1");
		gtk_widget_ref (button1);
		gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button1);
		gtk_box_pack_start (GTK_BOX (hbox1), button1, FALSE, FALSE, 0);

		gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url ),
		                    g_strdup( curl ) );

		desc = gtk_entry_new ();
		gtk_widget_set_name (desc, "desc");
		gtk_widget_ref (desc);
		gtk_object_set_data_full (GTK_OBJECT (window), "desc", desc,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (desc);
		gtk_table_attach (GTK_TABLE (table), desc, 1, 2, 1, 2,
		                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		                  (GtkAttachOptions) (0), 0, 0);

		kanji_conv_to_locale_s( &cdesc );

		gtk_entry_set_text( GTK_ENTRY( desc ), cdesc );

		label2 = gtk_label_new (_("URL:"));
		gtk_widget_set_name (label2, "label2");
		gtk_widget_ref (label2);
		gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
		                         (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label2);
		gtk_table_attach (GTK_TABLE (table), label2, 0, 1, 0, 1,
		                 (GtkAttachOptions) (GTK_FILL),
		                 (GtkAttachOptions) (GTK_FILL), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label2), 1, 0.5);

		label3 = gtk_label_new (_("Description:"));
		gtk_widget_set_name (label3, "label3");
		gtk_widget_ref (label3);
		gtk_object_set_data_full (GTK_OBJECT (window), "label3", label3,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (label3);
		gtk_table_attach (GTK_TABLE (table), label3, 0, 1, 1, 2,
		                  (GtkAttachOptions) (GTK_FILL),
		                  (GtkAttachOptions) (GTK_FILL), 0, 0);
		gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_RIGHT);
		gtk_misc_set_alignment (GTK_MISC (label3), 1, 0.5);

		dialog_action_area1 = GNOME_DIALOG (window)->action_area;
		gtk_widget_set_name (dialog_action_area1, "dialog_action_area1");
		gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
		gtk_widget_show (dialog_action_area1);
		gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

		gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
		button2 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
		gtk_widget_set_name (button2, "button2");
		gtk_widget_ref (button2);
		gtk_object_set_data_full (GTK_OBJECT (window), "button2", button2,
		                          (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (button2);
		GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

		gtk_signal_connect_object( GTK_OBJECT( button2 ), "clicked",
		                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
		                           GTK_OBJECT( window ) );

		gtk_widget_show_all( window );

		g_free( curl );
		g_free( cdesc );
		g_free( sender );
	}
}

void quote_click ( GtkWidget *widget )
{
   GtkWidget *text;
   GtkWidget *respond_text;
   gchar *origText = "";
   GString *textTo;
   GString *temp;
   int i,starttext,endtext;

   text = gtk_object_get_data( GTK_OBJECT( widget ), "text" );
   respond_text = gtk_object_get_data( GTK_OBJECT( widget ), "respond_text" );

   textTo = g_string_new(">");
   temp = g_string_new(NULL);

   if (GTK_EDITABLE(text)->selection_start_pos == GTK_EDITABLE(text)->selection_end_pos) {
   origText = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
   } else {
      if (GTK_EDITABLE(text)->selection_start_pos < GTK_EDITABLE(text)->selection_end_pos) {
	 starttext = GTK_EDITABLE(text)->selection_start_pos;
	 endtext = GTK_EDITABLE(text)->selection_end_pos;
      } else {
	 starttext = GTK_EDITABLE(text)->selection_end_pos;
	 endtext = GTK_EDITABLE(text)->selection_start_pos;
      }

      origText = gtk_editable_get_chars(GTK_EDITABLE(text), starttext, endtext);
   }

   for (i=0;i<strlen(origText); i++) {
      temp = g_string_assign(temp, textTo->str);
      if (origText[i-1] == '\n') {
         g_string_sprintf(textTo, "%s>%c", temp->str, origText[i]);
      } else {
         g_string_sprintf(textTo, "%s%c", temp->str, origText[i]);
      }
   }
   temp = g_string_assign(temp, textTo->str);
   g_string_sprintf(textTo, "%s\n", temp->str);

   gtk_text_set_point(GTK_TEXT(respond_text), 0);
   gtk_text_insert(GTK_TEXT(respond_text), NULL, NULL, NULL, textTo->str, -1);
   gtk_text_set_point(GTK_TEXT(respond_text), strlen(textTo->str));

   g_free(origText);
   g_string_free(textTo, FALSE);
   g_string_free(temp, TRUE);
}

GtkWidget *create_menu ( void )
{
	GtkWidget *item;
	GtkWidget *menu;

#ifdef TRACE_FUNCTION
	g_print( "create_menu\n" );
#endif

	menu = gtk_menu_new();

	item = gtk_menu_item_new_with_label ( _("Online") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_online), NULL );

	item = gtk_menu_item_new_with_label ( _("Offline") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_offline), NULL );

	item = gtk_menu_item_new_with_label ( _("Away") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_away), NULL );

	item = gtk_menu_item_new_with_label ( _("Not Available") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_na), NULL );

	item = gtk_menu_item_new_with_label ( _("Free for Chat") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_ffc), NULL );

	item = gtk_menu_item_new_with_label ( _("Occupied") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_occ), NULL );

	item = gtk_menu_item_new_with_label ( _("Do Not Disturb") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_dnd), NULL );

	item = gtk_menu_item_new_with_label ( _("Invisible") );

	gtk_menu_append( GTK_MENU ( menu ), item );
	gtk_widget_show( item );

	gtk_signal_connect(GTK_OBJECT( item ), "activate",
	                   GTK_SIGNAL_FUNC(icq_set_status_invisible), NULL );

	return menu;
}

void show_contact_message( GSList *contact )
{
	STORED_MESSAGE_PTR msg = (STORED_MESSAGE_PTR)kontakt->stored_messages->data;

	if( kontakt->read_next &&
	    GTK_IS_WIDGET( kontakt->read_next ) &&
	    GTK_WIDGET_VISIBLE( kontakt->read_next ) &&
	    msg->type == MESSAGE_TEXT )
		gtk_signal_emit_by_name( GTK_OBJECT( kontakt->read_next ), "clicked", MainData );
	else
	if( g_slist_length( kontakt->stored_messages ) )
	{
		icq_msgbox( msg, kontakt->uin );
		g_free(msg->chatsessionname);
		if (msg->chatcontact && ((ChatContact *)msg->chatcontact)->contact == NULL)
		     g_free(msg->chatcontact);
		g_free( msg->message );
		g_free( msg );
		kontakt->stored_messages = g_slist_remove( kontakt->stored_messages, msg );

		if( g_slist_length( kontakt->stored_messages ) == 0 )
		{
			kontakt->icon_p = GetIcon_p( kontakt->status );
			kontakt->icon_b = GetIcon_b( kontakt->status );
			kontakt->need_update = 1;
			gtk_widget_set_sensitive( kontakt->read_next, FALSE );
		}
		else
		{
			if( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type != MESSAGE_TEXT )
				gtk_widget_set_sensitive( kontakt->read_next, FALSE );
			else
				gtk_widget_set_sensitive( kontakt->read_next, TRUE );
		}

	  	Update_Contact_Style( Which_List( kontakt ), kontakt );
		applet_update( Current_Status, NULL );
		Shortcut_Update( kontakt );
	}
}

void clist_op_clicked (GtkWidget *widget, gpointer userdata)
{
   GtkWidget *clist;

   clist = gtk_object_get_data(GTK_OBJECT(widget), "uins_clist");

   if (userdata == NULL) {
      gtk_clist_unselect_all(GTK_CLIST(clist));
   } else {
      gtk_clist_select_all(GTK_CLIST(clist));
   }
}


void detach_window_click( GtkWidget *widget, GdkEventButton *event, gpointer data )
{
    CONTACT_PTR contact = gtk_object_get_data( GTK_OBJECT( widget ), "contact" );
    GdkEventButton *new_event = g_new0( GdkEventButton, 1 );
    GSList *contact_list = NULL;

    /* Exit if not the left or right mouse buttons */
    if( event->button != 3 && event->button != 1 ) return;

    /* Forge the current listbox according to user status */
    select_clist_row_from_contact( contact );

    contact_list = g_slist_append( contact_list, contact );
    if( (event->button == 3) && (event->type == GDK_BUTTON_PRESS) )
    {
        new_event->type = GDK_KEY_PRESS;
        ((GdkEventKey*)new_event)->keyval = ' ';
        icq_sendmessage_window( MainData->lb_userwin, new_event, contact_list );
    }
    else if( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
    {
        icq_sendmessage_window_from_menu( NULL, NULL );
    }

    /* Return the list box, and free the stuff */
    g_free( new_event );
}

gint detach_window_delete( GtkWidget *widget, GdkEvent *event, gpointer data )
{
    gtk_widget_hide( widget );
    return( TRUE );
}

void detach_contact_hide( GtkWidget *widget, gpointer data )
{
    CONTACT_PTR contact = (CONTACT_PTR)data;

    if( !GTK_WIDGET_VISIBLE( contact->detached_window ) )
    {
        gtk_widget_show( GTK_WIDGET( contact->detached_window ) );
    }
    else
    {
        gtk_widget_hide( GTK_WIDGET( contact->detached_window ) );
    }
}

void detach_contact( GtkWidget *widget, gpointer data )
{
    // GSList *contact_list = get_contact_from_clist();
    CONTACT_PTR contact = (CONTACT_PTR)data;
    GnomeWinState state;
    GnomeWinHints hints;
    GtkWidget *window, *label, *hbox, *gtk_pixmap, *eventbox;
    gchar *title;

    if( GTK_IS_WIDGET( contact->detached_window ) ) return;

    window = gtk_window_new( GTK_WINDOW_DIALOG );
    gtk_window_set_wmclass( GTK_WINDOW( window ),
                            "Contact_Shortcut", "GnomeICU" );
    title = g_strdup_printf( _("%s status"), contact->nick );
    gtk_window_set_title( GTK_WINDOW( window ), title );
    g_free( title );
    contact->detached_window = window;

    eventbox = gtk_event_box_new();

    gtk_signal_connect( GTK_OBJECT( window ), "delete-event",
                        GTK_SIGNAL_FUNC( detach_window_delete ), NULL );
    gtk_signal_connect( GTK_OBJECT( eventbox ), "button-press-event",
                        GTK_SIGNAL_FUNC( detach_window_click ), NULL );
    gtk_container_add( GTK_CONTAINER( window ), eventbox );
    init_contact_list_drag_drop( eventbox );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_pixmap = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );
    gtk_box_pack_start( GTK_BOX( hbox ), gtk_pixmap, FALSE, FALSE, 0 );
    gtk_widget_show( gtk_pixmap );
    label = gtk_label_new( contact->nick );
    gtk_box_pack_end( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
    gtk_misc_set_padding( GTK_MISC( label ), 3, 0 );
    gtk_container_add( GTK_CONTAINER( eventbox ), hbox );

    gtk_object_set_data( GTK_OBJECT( window ), "pixmap", gtk_pixmap );
    gtk_object_set_data( GTK_OBJECT( window ), "label", label );
    gtk_object_set_data( GTK_OBJECT( window ), "event_box", eventbox );
    gtk_object_set_data( GTK_OBJECT( eventbox ), "contact", contact );

    gtk_widget_show_all( GTK_WIDGET( window ) );

    gnome_win_hints_set_layer( GTK_WIDGET( window ),
                               WIN_LAYER_ABOVE_DOCK );

    state = gnome_win_hints_get_state( GTK_WIDGET( window ) );
    state = state | WIN_STATE_STICKY;
    gnome_win_hints_set_state( GTK_WIDGET( window ), state );

    hints = gnome_win_hints_get_hints( GTK_WIDGET( window ) );
    hints = hints | WIN_HINTS_SKIP_TASKBAR | WIN_HINTS_SKIP_WINLIST;
    gnome_win_hints_set_hints( GTK_WIDGET( window ), hints );

    Shortcut_Update( contact );
}

void lists_change_list( GtkWidget *widget, gpointer data )
{
    CONTACT_PTR contact;
    gint method = 0;
    GtkWidget *dialog;
    gchar *msg;

#ifdef TRACE_FUNCTION
    g_print( "lists_change_lists" );
#endif
    contact = get_contact_from_clist()->data;

    switch(GPOINTER_TO_INT(data))
    {
    case 0:
        msg = g_strdup_printf("Are you sure you want to move %s to your ignore list?", contact->nick);
        dialog = gnome_message_box_new(msg,
                                       GNOME_MESSAGE_BOX_WARNING,
                                       GNOME_STOCK_BUTTON_YES,
                                       GNOME_STOCK_BUTTON_NO,
                                       NULL);
        g_free(msg);

        if (gnome_dialog_run(GNOME_DIALOG(dialog)) != 0) break;

        contact->ignore_list = TRUE;
        contact->invis_list = TRUE;
        contact->vis_list = FALSE;
        if( contact->inlist == FALSE )
            method |= UPDATE_NOTLIST;
        else if( contact->status == STATUS_OFFLINE )
            method |= UPDATE_OFFLINE;
        else
            method |= UPDATE_ONLINE;
        Show_Quick_Status_lower( method, NULL );
        break;
    case 1:
        contact->vis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        break;
    case 2:
        contact->invis_list = GTK_CHECK_MENU_ITEM( widget )->active;
        break;
    case 3:
        contact->online_notify = GTK_CHECK_MENU_ITEM( widget )->active;
        break;
    }

    snd_vis_list();
    snd_invis_list();
}

void icq_sendmessage( GtkWidget *button, gpointer dialog )
{
	gchar *buf, *tmp;
	GtkWidget *entry;
   	GtkWidget *uinclist = NULL;
   	GtkWidget *more_button;
        gboolean bol_forced;
	gpointer forced;
   	gint wid;
	UIN_T uin;
   	GList *select;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage\n" );
#endif

	if( gtk_object_get_data( GTK_OBJECT( button ), "menu" ) != NULL )
		contact = gtk_object_get_data( GTK_OBJECT( gtk_menu_get_active( gtk_object_get_data( GTK_OBJECT( button ), "menu" ) ) ), "contact" );
	else
		contact = gtk_object_get_data( GTK_OBJECT( button ), "contact" );
	entry = gtk_object_get_data( GTK_OBJECT( button ), "text" );
	forced = gtk_object_get_data( GTK_OBJECT( button ), "force" );
   	more_button = gtk_object_get_data(GTK_OBJECT(button), "more_button");
   	if GTK_IS_WIDGET(more_button) uinclist = gtk_object_get_data(GTK_OBJECT(more_button), "uins_clist");

	buf = gtk_editable_get_chars( GTK_EDITABLE( entry ), 0, -1 );

        bol_forced = kontakt->force_override;
        if ((bol_forced == TRUE) && (strlen(buf) > 450))
        {
            gnome_ok_dialog(_("When sending trough server, you can't exceed the 450 characters limit."));
	    if (dialog)
		 gtk_widget_destroy( GTK_WIDGET( dialog ) );
            g_free(buf);
            return;
        }

   	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(more_button))) {
            select = g_list_first(GTK_CLIST(uinclist)->selection);
            while (select != NULL) {
                wid = (gint)(GTK_CLIST_ROW(select));
                gtk_clist_get_text(GTK_CLIST(uinclist), wid, 1, &tmp);
                uin = atol(tmp);
                icq_sendmsg( uin, buf, ( forced == NULL ? 0 : 1 ) );
                select = g_list_next(select);
            }
        }
        else
            icq_sendmsg( kontakt->uin, buf, ( forced == NULL ? 0 : 1 ) );

	if (dialog)
            gtk_widget_destroy( GTK_WIDGET( dialog ) );
        g_free( buf );
}

gint icq_sendmessage_window( GtkWidget *clist, GdkEventButton *event, gpointer data )
{
	int row, column;

	GtkWidget *dialog1;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *send_message_optionmenu;
	GtkWidget *send_message_optionmenu_menu;
	GtkWidget *menuitem;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;
	GtkWidget *button3;
	GtkWidget *force_question;
   	/* Mass-send - NH */
	GtkWidget *more_hbox;
   	GtkWidget *hbox2;
   	GtkWidget *more_button;
   	GtkWidget *uins_clist;
   	GtkWidget *all_button;
   	GtkWidget *none_button;
   	GtkWidget *more_sep;
   	GtkWidget *somelabel;
   	GtkWidget *moreuinscroll;
   	GtkWidget *more_vbox;
   	GtkWidget *hbox3;
   	/* End mass-send */
	GtkAccelGroup *accel_group;
   	guint accel_widget;

	int cx, picked_user;
	gchar *nick = NULL;
	UIN_T uin;

	int key_select = FALSE;

	GSList *contact, *contact2;

      	accel_group = gtk_accel_group_new();

	if( event == NULL )
		return FALSE;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window\n" );
#endif

	if( event->type == GDK_KEY_PRESS )
	{
 		if( ((GdkEventKey*)event)->keyval != GDK_Return && ((GdkEventKey*)event)->keyval != ' ' )
			return FALSE;
		key_select = TRUE;
	}
	else if( event->button > 3 )
		return FALSE;

        MainData->lb_userwin = clist;
	gtk_clist_get_selection_info( GTK_CLIST( clist ), event->x, event->y,
	                              &row, &column );

	if( event->type == GDK_KEY_PRESS )
		row = GTK_CLIST(clist)->focus_row;

	if( !GTK_IS_SCROLLBAR( clist ) && key_select == FALSE &&
	    event->button == 3 )
		 gtk_clist_select_row( GTK_CLIST( clist ), row, column );

	if( key_select == FALSE )
	{
		if(  event->type != GDK_2BUTTON_PRESS && event->button == 1 )
			return FALSE;

		if( event->type != GDK_BUTTON_PRESS && event->button == 3 )
			return FALSE;

		if( event->button == 2 )
			return FALSE;
	}

	if( data != NULL )
		contact = (GSList*)data;
	else 
	{
		uin = GPOINTER_TO_INT( gtk_clist_get_row_data( GTK_CLIST( clist ), row ) );

		if( uin == 0 )
			return FALSE;

		contact = Find_User( uin );
		if( contact == NULL )
			return FALSE;
	}

	nick = kontakt->nick;

	if( event->button == 3 ||
	    ( event->type == GDK_KEY_PRESS && ((GdkEventKey*)event)->keyval == ' ' ) )
	{
		GtkWidget *personal_menu, *lists_menu;
		GdkEventButton *bevent = (GdkEventButton *) event;

		GtkWidget *pm, *item_box, *item_label;
		GtkWidget *item;
		personal_menu = gtk_menu_new();

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_message_pixmap, icon_message_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Message...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( icq_sendmessage_window_from_menu ),
		                    NULL );
		gtk_widget_show( item );

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_url_pixmap, icon_url_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  URL...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( send_url_window_default ),
		                    NULL );
		gtk_widget_show( item );

		if( kontakt->status != STATUS_OFFLINE )
		{
			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_chat_pixmap, icon_chat_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( _("  Chat Request...") );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( request_chat ),
			                    NULL );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_file_pixmap, icon_file_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( _("  File Request...") );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( request_file_default ),
			                    NULL );
			gtk_widget_show( item );

			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_contact_pixmap, icon_contact_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( _("  Contact List...") );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( get_contact_list ),
			                    NULL );
			gtk_widget_show( item );
		}

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_chat_pixmap, icon_chat_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Message Chat...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( open_message_chat ), NULL );
		gtk_widget_show( item );

		item = gtk_menu_item_new();
		gtk_widget_set_sensitive( item, FALSE );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_widget_show( item );

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_info_pixmap, icon_info_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  User Info...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( show_personal_info ), NULL );
		gtk_widget_show( item );

		if( (kontakt->status & 0xffff) != STATUS_ONLINE &&
		    kontakt->status != STATUS_OFFLINE &&
		    (kontakt->status & 0xffff) !=  STATUS_INVISIBLE &&
		    (kontakt->status & 0xffff) != STATUS_FREE_CHAT )
		{
			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( GetIcon_p( kontakt->status ),
			                     GetIcon_b( kontakt->status ) );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			switch( kontakt->status & 0xffff )
			{
				case STATUS_AWAY:
					item_label = gtk_label_new( _("  Read Away Message") );
					break;
				case STATUS_NA:
					item_label = gtk_label_new( _("  Read N/A Message") );
					break;
				case STATUS_OCCUPIED:
					item_label = gtk_label_new( _("  Read Occupied Message") );
					break;
				case STATUS_DND:
					item_label = gtk_label_new( _("  Read Do not Disturb Message") );
					break;
				default:
					item_label = gtk_label_new( _("  Read Away Message") );
					break;
			}

			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( retrieve_away_message ), NULL );
			gtk_widget_show( item );
		}

		if( kontakt->status != STATUS_OFFLINE )
		{
			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_info_pixmap, icon_info_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( _("  Version...") );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( retrieve_version ), NULL );
			gtk_widget_show( item );
		}

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_hist_pixmap, icon_hist_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  History...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( display_mess_history ), NULL );
		gtk_widget_show( item );

                /* Lists menu */
                lists_menu = gtk_menu_new();

                /* On ignore list... */
                item = gtk_menu_item_new_with_label(_("Move to ignore list"));
		gtk_menu_append( GTK_MENU( lists_menu ), item );
                gtk_signal_connect( GTK_OBJECT( item ), "activate",
                                    GTK_SIGNAL_FUNC( lists_change_list ), GINT_TO_POINTER(0) );
		gtk_widget_show( item );

                /* On visible list... */
                item = gtk_check_menu_item_new_with_label(_("On Visible List"));
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item),
                                               kontakt->vis_list);
                gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(item), TRUE);
		gtk_menu_append( GTK_MENU( lists_menu ), item );
                gtk_signal_connect( GTK_OBJECT( item ), "toggled",
                                    GTK_SIGNAL_FUNC( lists_change_list ), GINT_TO_POINTER(1) );
		gtk_widget_show( item );

                /* On invisible list... */
                item = gtk_check_menu_item_new_with_label(_("On Invisible List"));
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item),
                                               kontakt->invis_list);
                gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(item), TRUE);
		gtk_menu_append( GTK_MENU( lists_menu ), item );
                gtk_signal_connect( GTK_OBJECT( item ), "toggled",
                                    GTK_SIGNAL_FUNC( lists_change_list ), GINT_TO_POINTER(2) );
		gtk_widget_show( item );

                /* On online notify list... */
                item = gtk_check_menu_item_new_with_label(_("On Notify List"));
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item),
                                               kontakt->online_notify);
                gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(item), TRUE);
		gtk_menu_append( GTK_MENU( lists_menu ), item );
                gtk_signal_connect( GTK_OBJECT( item ), "toggled",
                                    GTK_SIGNAL_FUNC( lists_change_list ), GINT_TO_POINTER(3) );
		gtk_widget_show( item );

                /* End Lists Menu */

                item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_info_pixmap, icon_info_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Lists") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
                gtk_menu_item_set_submenu( GTK_MENU_ITEM( item ), lists_menu );
		/* gtk_signal_connect( GTK_OBJECT( item ), "activate",
                  GTK_SIGNAL_FUNC( display_mess_history ), NULL ); */
		gtk_widget_show( item );

		item = gtk_menu_item_new();
		gtk_widget_set_sensitive( item, FALSE );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_widget_show( item );

                /* Detach/Attach user */
		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_auth_pixmap, icon_auth_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
                if( GTK_IS_WIDGET(kontakt->detached_window) && GTK_WIDGET_VISIBLE( kontakt->detached_window) )
                    item_label = gtk_label_new( _("  Hide shortcut") );
                else
                    item_label = gtk_label_new( _("  Show shortcut") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
                if( GTK_IS_WIDGET( kontakt->detached_window) )
                    gtk_signal_connect( GTK_OBJECT( item ), "activate",
                                        GTK_SIGNAL_FUNC( detach_contact_hide ),
                                        kontakt );
                else
                    gtk_signal_connect( GTK_OBJECT( item ), "activate",
                                        GTK_SIGNAL_FUNC( detach_contact ),
                                        kontakt );

		gtk_widget_show( item );

                /* Separator */
                item = gtk_menu_item_new();
		gtk_widget_set_sensitive( item, FALSE );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_widget_show( item );

		if( kontakt->inlist == FALSE )
		{
			item_box = gtk_hbox_new( FALSE, 0 );
			pm = gtk_pixmap_new( icon_auth_pixmap, icon_auth_bitmap );
			gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
			gtk_widget_show( pm );
			item = gtk_menu_item_new();
			item_label = gtk_label_new( _("  Add To List") );
			gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
			gtk_widget_show( item_label );
			gtk_container_add( GTK_CONTAINER( item ), item_box );
			gtk_widget_show( item_box );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_signal_connect( GTK_OBJECT( item ), "activate",
			                    GTK_SIGNAL_FUNC( add_user_to_list ), NULL );
			gtk_widget_show( item );

			item = gtk_menu_item_new();
			gtk_widget_set_sensitive( item, FALSE );
			gtk_menu_append( GTK_MENU( personal_menu ), item );
			gtk_widget_show( item );
		}

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_auth_pixmap, icon_auth_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Authorize User") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( authorize_uin ), NULL );
		gtk_widget_show( item );

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_rename_pixmap, icon_rename_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Rename User...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( change_nick_window ), NULL );
		gtk_widget_show( item );

		item_box = gtk_hbox_new( FALSE, 0 );
		pm = gtk_pixmap_new( icon_cancel_pixmap, icon_cancel_bitmap );
		gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
		gtk_widget_show( pm );
		item = gtk_menu_item_new();
		item_label = gtk_label_new( _("  Remove User...") );
		gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
		gtk_widget_show( item_label );
		gtk_container_add( GTK_CONTAINER( item ), item_box );
		gtk_widget_show( item_box );
		gtk_menu_append( GTK_MENU( personal_menu ), item );
		gtk_signal_connect( GTK_OBJECT( item ), "activate",
		                    GTK_SIGNAL_FUNC( remove_user_question ), NULL );
		gtk_widget_show( item );

		gtk_menu_popup( GTK_MENU( personal_menu ), NULL, NULL, NULL, NULL,
		                bevent->button, bevent->time );
		return FALSE;
	}

	if( g_slist_length( kontakt->stored_messages ) )
	{
		show_contact_message( contact );
		return FALSE;
	}

	dialog1 = gnome_dialog_new (_("GnomeICU: Send Message"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (dialog1), "Send_Message", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
	gtk_window_set_policy (GTK_WINDOW (dialog1), FALSE, FALSE, FALSE);

#ifdef GNOME_ICON
        set_window_icon( dialog1, "gnomeicu-message.png" );
#endif

	dialog_vbox1 = GNOME_DIALOG (dialog1)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

   	/* A hbox for the mass-send user list - NH */
   	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbox2", hbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox2, TRUE, TRUE, 0);
	/* End hbox */

	vbox1 = gtk_vbox_new (FALSE, 4);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (hbox2), vbox1, TRUE, TRUE, 0);

	hbox1 = gtk_hbox_new (FALSE, 4);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbox1", hbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

	label1 = gtk_label_new (_("Send message to:"));
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "label1", label1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label1), 1, 0.5);

	send_message_optionmenu = gtk_option_menu_new ();
	gtk_widget_ref (send_message_optionmenu);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "send_message_optionmenu", send_message_optionmenu,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (send_message_optionmenu);
	gtk_box_pack_start (GTK_BOX (hbox1), send_message_optionmenu, FALSE, FALSE, 0);
	send_message_optionmenu_menu = gtk_menu_new ();

	contact2 = Contacts;
	cx = 0;
	picked_user = 0;
	while( contact2 != NULL )
	{
		menuitem = gtk_menu_item_new_with_label( kontakt2->nick );
		gtk_widget_show (menuitem);
		gtk_object_set_data( GTK_OBJECT( menuitem ), "contact", contact2 );
		gtk_menu_append (GTK_MENU (send_message_optionmenu_menu), menuitem);
		if( contact == contact2 )
			picked_user = cx;
		contact2 = contact2->next;
		cx++;
	}

	gtk_option_menu_set_menu( GTK_OPTION_MENU( send_message_optionmenu ), send_message_optionmenu_menu );
	gtk_option_menu_set_history( GTK_OPTION_MENU( send_message_optionmenu ), picked_user );

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text1 = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "text1", text1,
	                          (GtkDestroyNotify) gtk_widget_unref);

        if (toggles->check_spell)
        {
            if (!gtkspell_running())
                gtkspell_start(NULL, ispell_cmd);
            gtkspell_attach(GTK_TEXT(text1));
        }
	gtk_text_set_editable( GTK_TEXT( text1 ), TRUE );
	gtk_text_set_word_wrap( GTK_TEXT( text1 ), TRUE );

	gtk_object_set_data( GTK_OBJECT( text1 ), "nick", kontakt->nick );
	gtk_object_set_data( GTK_OBJECT( text1 ), "force", NULL );

	gtk_signal_connect_after( GTK_OBJECT( text1 ), "key_press_event",
	                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

	gtk_widget_show (text1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
	gtk_widget_set_usize (text1, 375, 146);
	GTK_WIDGET_SET_FLAGS (text1, GTK_CAN_DEFAULT);

   	/* A hbox for the more button */
      	more_hbox = gtk_hbox_new (FALSE, 4);
	gtk_widget_ref (more_hbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "more_hbox", more_hbox,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (more_hbox);
	gtk_box_pack_start (GTK_BOX (vbox1), more_hbox, TRUE, TRUE, 0);
   	/* End hbox */

	force_question = gtk_check_button_new_with_label( _("Force message through server") );
	gtk_box_pack_start( GTK_BOX( more_hbox ), force_question, FALSE, FALSE, 0 );
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( force_question ),
	                             kontakt->force_override );
	if( toggles->force )
		gtk_widget_set_sensitive( force_question, FALSE );
	if( kontakt->force_override )
		gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( force_question ), TRUE );

	gtk_widget_show( force_question );

	gtk_signal_connect( GTK_OBJECT( force_question ), "toggled",
	                    GTK_SIGNAL_FUNC( toggle_force ),
	                    kontakt );

        button1 = gtk_button_new_with_label( "" );
	accel_widget = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button1)->child),_("_History"));
	gtk_widget_add_accelerator(button1, "clicked", accel_group,
				   accel_widget, GDK_MOD1_MASK, 0);
	gtk_box_pack_end( GTK_BOX( more_hbox ), button1, FALSE, FALSE, 0 );
	gtk_object_set_data( GTK_OBJECT( button1 ), "menu", send_message_optionmenu_menu );
	gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
	                    GTK_SIGNAL_FUNC( grab_history ), NULL );
	gtk_widget_show( button1 );

        /* Mass send code - NH */
   	somelabel = gtk_label_new(_(""));
	more_button = gtk_toggle_button_new();
	accel_widget = gtk_label_parse_uline(GTK_LABEL(somelabel),_("_Multiple"));
	gtk_widget_add_accelerator(more_button, "clicked", accel_group,
				   accel_widget, GDK_MOD1_MASK, 0);
	gtk_box_pack_end( GTK_BOX( hbox1 ), more_button, FALSE, FALSE, 0 );
	gtk_object_set_data( GTK_OBJECT( more_button ), "menu", send_message_optionmenu_menu );
	gtk_signal_connect( GTK_OBJECT( more_button ), "toggled",
	                    GTK_SIGNAL_FUNC( more_clicked ), NULL );
   	gtk_container_add(GTK_CONTAINER(more_button), GTK_WIDGET(somelabel));
      	gtk_widget_show(somelabel);
	gtk_widget_show( more_button );

   	gtk_object_set_data(GTK_OBJECT(more_button), "optionmenu", send_message_optionmenu);
   	gtk_object_set_data(GTK_OBJECT(more_button), "label", label1);

   	more_vbox = gtk_vbox_new(FALSE, 4);
	gtk_widget_ref (more_vbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "more_vbox", more_vbox,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (more_vbox);
	gtk_box_pack_end (GTK_BOX (hbox2), more_vbox, TRUE, TRUE, 0);

	moreuinscroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (moreuinscroll);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "moreuinscroll", moreuinscroll,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (moreuinscroll), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
   	gtk_box_pack_start(GTK_BOX(more_vbox), moreuinscroll, TRUE, TRUE, 0);

   	uins_clist = gtk_clist_new(2);
   	gtk_widget_ref(uins_clist);
   	gtk_object_set_data_full(GTK_OBJECT(dialog1), "uins_clist", uins_clist,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_widget_set_name(uins_clist, "uins_clist");
   	gtk_clist_set_selection_mode(GTK_CLIST(uins_clist), GTK_SELECTION_MULTIPLE);
   	gtk_object_set_data(GTK_OBJECT(more_button), "uins_clist", uins_clist);
   	gtk_container_add(GTK_CONTAINER(moreuinscroll), uins_clist);
   	gtk_widget_show(uins_clist);

      	gtk_clist_set_column_auto_resize(GTK_CLIST(uins_clist), 0, TRUE);
   	gtk_clist_set_column_visibility(GTK_CLIST(uins_clist), 1, FALSE);

	build_mass_list(contact, GTK_CLIST(uins_clist));

      	hbox3 = gtk_hbox_new(FALSE, 2);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbox3", hbox3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_end (GTK_BOX (more_vbox), hbox3, FALSE, FALSE, 0);

   	none_button = gtk_button_new_with_label(_("None"));
	gtk_box_pack_end (GTK_BOX(hbox3), none_button, TRUE, TRUE, 0);
   	gtk_widget_show(none_button);

      	all_button = gtk_button_new_with_label(_("All"));
	gtk_box_pack_end (GTK_BOX(hbox3), all_button, TRUE, TRUE, 0);
   	gtk_widget_show(all_button);

   	gtk_object_set_data(GTK_OBJECT(all_button), "uins_clist", uins_clist);
   	gtk_object_set_data(GTK_OBJECT(none_button), "uins_clist", uins_clist);

   	gtk_signal_connect(GTK_OBJECT(all_button), "clicked", GTK_SIGNAL_FUNC(clist_op_clicked), GINT_TO_POINTER(1));
   	gtk_signal_connect(GTK_OBJECT(none_button), "clicked", GTK_SIGNAL_FUNC(clist_op_clicked), NULL);

      	gtk_object_set_data(GTK_OBJECT(more_button), "more_vbox", more_vbox);

      	more_sep = gtk_vseparator_new();
   	gtk_box_pack_end( GTK_BOX( hbox2 ), more_sep, FALSE, FALSE, 0);
   	gtk_object_set_data(GTK_OBJECT(more_button), "more_sep", more_sep);
	/* End mass send code - NH */

	dialog_action_area1 = GNOME_DIALOG (dialog1)->action_area;
	gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog1),
	                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
	button1 = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "button1", button1,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( text1 ), "button", button1 );
	gtk_object_set_data( GTK_OBJECT( button1 ), "text", text1 );
	gtk_object_set_data( GTK_OBJECT( button1 ), "force", NULL );
	gtk_object_set_data( GTK_OBJECT( button1 ), "contact", contact );
	gtk_object_set_data( GTK_OBJECT( button1 ), "menu", send_message_optionmenu_menu );
   	gtk_object_set_data( GTK_OBJECT( button1 ), "more_button", more_button );

	gtk_signal_connect( GTK_OBJECT( button1 ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendmessage ), dialog1 );

	gtk_widget_show (button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_CLOSE);
	button3 = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (dialog1), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( text1 ), "cancel", button3 );

	gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( dialog1 ) );

	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

   	gtk_window_add_accel_group(GTK_WINDOW(dialog1), accel_group);
	gtk_widget_show( dialog1 );

	gtk_widget_grab_focus( text1 );
	gtk_widget_grab_default (text1);

	return FALSE;
}

void more_clicked (GtkWidget *widget,
		   gpointer userdata)
{

   GtkWidget *moresep;
   GtkWidget *optionmenu;
   GtkWidget *nicklabel;
   GtkWidget *more_vbox;
   gboolean more;

   more = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

   nicklabel = gtk_object_get_data(GTK_OBJECT(widget), "label");
   optionmenu = gtk_object_get_data(GTK_OBJECT(widget), "optionmenu");
   moresep = gtk_object_get_data(GTK_OBJECT(widget), "more_sep");
   more_vbox = gtk_object_get_data(GTK_OBJECT(widget), "more_vbox");

   if (more) {
      gtk_widget_hide(nicklabel);
      gtk_widget_hide(optionmenu);
      gtk_widget_show(moresep);
      gtk_widget_show_all(more_vbox);
   } else {
      gtk_widget_show(nicklabel);
      gtk_widget_show(optionmenu);
      gtk_widget_hide(moresep);
      gtk_widget_hide_all(more_vbox);
   }
}

void icq_sendmessage_window_from_menu( GtkWidget *widget, gpointer data )
{
	GdkEventButton *event;
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_sendmessage_window_from_menu\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	event = g_new0( GdkEventButton, 1 );
	event->type = GDK_KEY_PRESS;
	((GdkEventKey*)event)->keyval = GDK_Return;

	icq_sendmessage_window( MainData->lb_userwin, event, contact );

	g_free( event );
}

int stay_connected( void )
{
#ifdef TRACE_FUNCTION
	g_print( "stay_connected\n" );
#endif

	Keep_Alive();
	return TRUE;
}

void show_personal_info( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "show_personal_info\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	kontakt->info_was_requested = TRUE;

	info_req_99( kontakt->uin );

	dump_personal_info( kontakt->uin );
}

void dump_personal_info( UIN_T uin )
{
	gchar *sts, *string = NULL;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *vbutton;
	GtkWidget *notebook;
	GtkWidget *mainbox;
	GtkWidget *hbox;
	GtkWidget *scrollbar;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "dump_personal_info\n" );
#endif

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	/* hvrfixme: where is ip and port freed up again?? */
	if( kontakt->current_ip != -1 )
	{
		kontakt->info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (kontakt->current_ip >> 24),
		         (BYTE) (kontakt->current_ip >> 16),
		         (BYTE) (kontakt->current_ip >> 8),
		         (BYTE) (kontakt->current_ip) );
		kontakt->info->port = g_strdup_printf( "%u", kontakt->port );
	}
	else
	{
		kontakt->info->ip = g_strdup( _("N/A") );
		kontakt->info->port = g_strdup( _("N/A") );
	}

	g_free( kontakt->info->status );

	if( kontakt->status == STATUS_OFFLINE )
		sts = _("Offline");
	else
		switch( kontakt->status & 0xffff )
		{
			case STATUS_ONLINE:
				sts = _("Online"); break;
			case STATUS_AWAY:
				sts = _("Away"); break;
			case STATUS_NA:
				sts = _("N/A"); break;
			case STATUS_FREE_CHAT:
				sts = _("Free for Chat"); break;
			case STATUS_OCCUPIED:
				sts = _("Occupied"); break;
			case STATUS_DND:
				sts = _("Do not Disturb"); break;
			case STATUS_INVISIBLE:
				sts = _("Invisible"); break;
			default:
				sts = _("Unknown"); break;
		}

	kontakt->info->status = g_strdup_printf( "%08X (%s)",
	                                             kontakt->status,
	                                             sts );

	if( kontakt->info->window == NULL )
	{
		if( kontakt->info_was_requested == FALSE )
			return;
		kontakt->info_was_requested = FALSE;
		kontakt->info->window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
		gtk_container_border_width( GTK_CONTAINER( kontakt->info->window ), 10 );
		gtk_window_set_title( GTK_WINDOW( kontakt->info->window ), _("GnomeICU: User Information") );

		gtk_signal_connect( GTK_OBJECT( kontakt->info->window ), "destroy",
		                    (GtkSignalFunc)clear_i_window,
		                    GINT_TO_POINTER( kontakt->uin ) );

		mainbox = gtk_vbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( kontakt->info->window ), mainbox );

		notebook = gtk_notebook_new();
		gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
		gtk_box_pack_start( GTK_BOX( mainbox ), notebook, FALSE, FALSE, 10 );

/** General Tab **/
		table = gtk_table_new( 4, 7, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( _("General") ) );

		label = gtk_label_new( _("UIN:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Nick:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("F. Name:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("L. Name:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Sex:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Age:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Alias:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 3, 4, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Auth:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		kontakt->info->w_uin = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_uin,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_uin ), FALSE );
		gtk_widget_show( kontakt->info->w_uin );

		kontakt->info->w_nick = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_nick,
		                  4, 7, 0, 1, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_nick ), FALSE );
		gtk_widget_show( kontakt->info->w_nick );

		kontakt->info->w_first = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_first,
		                  1, 3, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_first ), FALSE );
		gtk_widget_show( kontakt->info->w_first );

		kontakt->info->w_last = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_last,
		                  4, 7, 2, 3, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_last ), FALSE );
		gtk_widget_show( kontakt->info->w_last );

		kontakt->info->w_sex = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_sex,
		                  1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_sex ), FALSE );
		gtk_widget_show( kontakt->info->w_sex );

		kontakt->info->w_age = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_age,
		                  4, 7, 3, 4, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_age ), FALSE );
		gtk_widget_show( kontakt->info->w_age );

		kontakt->info->w_alias = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_alias,
		                  4, 6, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_alias ), FALSE );
		gtk_widget_show( kontakt->info->w_alias );

		button = gtk_button_new_with_label( _("Set") );
		gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc)change_nick_window,
		                    GINT_TO_POINTER( kontakt->uin ) );
		gtk_table_attach( GTK_TABLE( table ), button,
		                  6, 7, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 5 );
		gtk_widget_show( button );

		kontakt->info->w_auth = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_auth,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_auth ), FALSE );
		gtk_widget_show( kontakt->info->w_auth );

		gtk_widget_show( table );

/** Internet Tab **/
		table = gtk_table_new( 7, 2, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( _("Internet") ) );

		label = gtk_label_new( _("IP:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Port:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Status:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_hseparator_new();
		gtk_table_attach( GTK_TABLE( table ), label, 0, 2, 3, 4, GTK_FILL, 0, 0, 7 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Email:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Other Email:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 5, 6, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Old Email:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 6, 7, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		kontakt->info->w_ip = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_ip,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_ip ), FALSE );
		gtk_widget_show( kontakt->info->w_ip );

		kontakt->info->w_port = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_port,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_port ), FALSE );
		gtk_widget_show( kontakt->info->w_port );

		kontakt->info->w_status = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_status,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_status ), FALSE );
		gtk_widget_show( kontakt->info->w_status );

		kontakt->info->w_email = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_email,
		                  1, 2, 4, 5, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_widget_set_usize( kontakt->info->w_email, 200, 0 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_email ), FALSE );
		gtk_widget_show( kontakt->info->w_email );

		kontakt->info->w_email2 = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_email2,
		                  1, 2, 5, 6, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_widget_set_usize( kontakt->info->w_email2, 200, 0 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_email2 ), FALSE );
		gtk_widget_show( kontakt->info->w_email2 );

		kontakt->info->w_email3 = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_email3,
		                  1, 2, 6, 7, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_widget_set_usize( kontakt->info->w_email3, 200, 0 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_email3 ), FALSE );
		gtk_widget_show( kontakt->info->w_email3 );

		gtk_widget_show( table );

/** Work Tab **/
		table = gtk_table_new( 8, 4, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( _("Work") ) );

		label = gtk_label_new( _("Job Position:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Department:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_hseparator_new();
		gtk_table_attach( GTK_TABLE( table ), label, 0, 4, 1, 2, GTK_FILL, 0, 0, 7 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Company:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Address:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("City:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("State:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 4, 5, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_hseparator_new();
		gtk_table_attach( GTK_TABLE( table ), label, 0, 4, 5, 6, GTK_FILL, 0, 0, 7 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Phone:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 6, 7, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Fax:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 6, 7, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Homepage:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 7, 8, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		kontakt->info->w_job_pos = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_job_pos,
		                  1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 7 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_job_pos ), FALSE );
		gtk_widget_show( kontakt->info->w_job_pos );

		kontakt->info->w_department = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_department,
		                  3, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 7 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_department ), FALSE );
		gtk_widget_show( kontakt->info->w_department );

		kontakt->info->w_company_name = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_company_name,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 3 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_company_name ), FALSE );
		gtk_widget_show( kontakt->info->w_company_name );

		kontakt->info->w_work_address = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_address,
		                  1, 4, 3, 4, GTK_FILL, GTK_FILL, 5, 0 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_address ), FALSE );
		gtk_widget_show( kontakt->info->w_work_address );

		kontakt->info->w_work_city = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_city,
		                  1, 2, 4, 5, GTK_FILL, GTK_FILL, 5, 3 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_city ), FALSE );
		gtk_widget_show( kontakt->info->w_work_city );

		kontakt->info->w_work_state = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_state,
		                  3, 4, 4, 5, GTK_FILL, GTK_FILL, 5, 3 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_state ), FALSE );
		gtk_widget_show( kontakt->info->w_work_state );

		kontakt->info->w_work_phone = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_phone,
		                  1, 2, 6, 7, GTK_FILL, GTK_FILL, 5, 7 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_phone ), FALSE );
		gtk_widget_show( kontakt->info->w_work_phone );

		kontakt->info->w_work_fax = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_fax,
		                  3, 4, 6, 7, GTK_FILL, GTK_FILL, 5, 7 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_fax ), FALSE );
		gtk_widget_show( kontakt->info->w_work_fax );

		kontakt->info->w_work_homepage = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_work_homepage,
		                  1, 4, 7, 8, GTK_FILL, GTK_FILL, 5, 3 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_work_homepage ), FALSE );
		gtk_widget_show( kontakt->info->w_work_homepage );

		gtk_widget_show( table );

/** Location Tab **/
		table = gtk_table_new( 6, 4, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( _("Location") ) );

		label = gtk_label_new( _("Address:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("City:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("State:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Zip:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Country:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 2, 3, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_hseparator_new();
		gtk_table_attach( GTK_TABLE( table ), label, 0, 4, 3, 4, GTK_FILL, 0, 0, 7 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Phone:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 4, 5, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Fax:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 4, 5, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("Cellular:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 5, 6, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		kontakt->info->w_street = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_street,
		                  1, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_street ), FALSE );
		gtk_widget_show( kontakt->info->w_street );

		kontakt->info->w_city = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_city,
		                  1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_city ), FALSE );
		gtk_widget_show( kontakt->info->w_city );

		kontakt->info->w_state = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_state,
		                  3, 4, 1, 2, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_state ), FALSE );
		gtk_widget_show( kontakt->info->w_state );

		kontakt->info->w_zip = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_zip,
		                  1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_zip ), FALSE );
		gtk_widget_show( kontakt->info->w_zip );

		kontakt->info->w_country = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_country,
		                  3, 4, 2, 3, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_country ), FALSE );
		gtk_widget_show( kontakt->info->w_country );

		kontakt->info->w_phone = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_phone,
		                  1, 2, 4, 5, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_phone ), FALSE );
		gtk_widget_show( kontakt->info->w_phone );

		kontakt->info->w_fax = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_fax,
		                  3, 4, 4, 5, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_fax ), FALSE );
		gtk_widget_show( kontakt->info->w_fax );

		kontakt->info->w_cellular = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_cellular,
		                  1, 2, 5, 6, GTK_FILL, GTK_FILL, 5, 2 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_cellular ), FALSE );
		gtk_widget_show( kontakt->info->w_cellular );

		gtk_widget_show( table );

/** About Tab **/
		table = gtk_table_new( 3, 3, FALSE );
		gtk_container_set_border_width( GTK_CONTAINER( table ), 7 );
		gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), table,
		                          gtk_label_new( _("About") ) );

		label = gtk_label_new( _("Home Page:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 1, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		label = gtk_label_new( _("About:") );
		gtk_misc_set_alignment( GTK_MISC( label ), 0, 1 );
		gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0 );
		gtk_widget_show( label );

		kontakt->info->w_homepage = gtk_entry_new();

		gtk_table_attach( GTK_TABLE( table ), kontakt->info->w_homepage,
		                  1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 5 );
		gtk_entry_set_editable( GTK_ENTRY( kontakt->info->w_homepage ), FALSE );
		gtk_widget_show( kontakt->info->w_homepage );

		vbutton = gtk_button_new_with_label( _("View") );
		gtk_table_attach( GTK_TABLE( table ), vbutton,
		                  2, 3, 0, 1, GTK_FILL, 0, 0, 0 );

		gtk_signal_connect( GTK_OBJECT( vbutton ), "clicked",
		                    GTK_SIGNAL_FUNC( display_url_from_entry ),
		                    kontakt->info->w_homepage );

		gtk_widget_show( vbutton );

		hbox = gtk_hbox_new( FALSE, 0 );
		kontakt->info->w_about = gtk_text_new( NULL, NULL );
		gtk_text_set_word_wrap( GTK_TEXT( kontakt->info->w_about ), TRUE );

		gtk_box_pack_start( GTK_BOX( hbox ), kontakt->info->w_about, TRUE, TRUE, 0 );
		gtk_widget_show( kontakt->info->w_about );

		scrollbar = gtk_vscrollbar_new( GTK_TEXT( kontakt->info->w_about )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
		gtk_widget_show( scrollbar );


		gtk_table_attach( GTK_TABLE( table ), hbox,
		                  0, 3, 2, 3, GTK_FILL | GTK_EXPAND,
		                  GTK_FILL | GTK_EXPAND, 5, 5 );

		gtk_widget_show( hbox );
		gtk_widget_show( table );

		hbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout( GTK_BUTTON_BOX( hbox ),
		                           GTK_BUTTONBOX_END );

		button = gtk_button_new_with_label( _("Close") );
		gtk_box_pack_end( GTK_BOX( mainbox ), hbox, FALSE, FALSE, 0 );
		gtk_box_pack_end( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
		gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		                    (GtkSignalFunc) gtk_widget_destroy,
		                    GTK_OBJECT( kontakt->info->window ) );
		gtk_widget_show( hbox );
		gtk_widget_show( button );

		gtk_widget_show( notebook );
		gtk_widget_show( mainbox );
		gtk_widget_show( kontakt->info->window );

		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_uin ),
		                    g_strdup_printf( "%u", kontakt->uin ) );
	}

	if( kontakt->info->nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_nick ), kontakt->info->nick );

	if( kontakt->info->first != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_first ), kontakt->info->first );

	if( kontakt->info->last != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_last ), kontakt->info->last );

	if( kontakt->info->sex == MALE )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_sex ), _("Male") );
	else if( kontakt->info->sex == FEMALE )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_sex ), _("Female") );
	else
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_sex ), _("Unknown") );

	gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_age ),
			    (string = kontakt->info->age
			     ? g_strdup_printf( "%d", kontakt->info->age % 1000 )
			     : g_strdup( _("Unknown") )));
	g_free( string );

	if( kontakt->nick != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_alias ), kontakt->nick );

	if( kontakt->info->auth )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_auth ), _("Required") );
	else
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_auth ), _("Not Required") );

	if( kontakt->info->ip != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_ip ), kontakt->info->ip );

	if( kontakt->info->port != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_port ), kontakt->info->port );

	if( kontakt->info->status != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_status ), kontakt->info->status );

	if( kontakt->info->email != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_email ), kontakt->info->email );

	if( kontakt->info->email2 != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_email2 ), kontakt->info->email2 );

	if( kontakt->info->email3 != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_email3 ), kontakt->info->email3 );

	if( kontakt->info->phone != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_phone ), kontakt->info->phone );

	if( kontakt->info->city != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_city ), kontakt->info->city );

	if( kontakt->info->state != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_state ), kontakt->info->state );

	if( kontakt->info->homepage != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_homepage ), kontakt->info->homepage );

	if( kontakt->info->about != NULL )
	{
		gtk_text_freeze( GTK_TEXT( kontakt->info->w_about ) );
		gtk_text_insert( GTK_TEXT( kontakt->info->w_about ), NULL, NULL, NULL,
		                 kontakt->info->about, -1 );
		gtk_text_thaw( GTK_TEXT( kontakt->info->w_about ) );
	}

	if( kontakt->info->job_pos != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_job_pos ), kontakt->info->job_pos );

	if( kontakt->info->department != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_department ), kontakt->info->department );

	if( kontakt->info->company_name != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_company_name ), kontakt->info->company_name );

	if( kontakt->info->work_address != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_address ), kontakt->info->work_address );

	if( kontakt->info->work_city != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_city ), kontakt->info->work_city );

	if( kontakt->info->work_state != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_state ), kontakt->info->work_state );

	if( kontakt->info->work_phone != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_phone ), kontakt->info->work_phone );

	if( kontakt->info->work_fax != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_fax ), kontakt->info->work_fax );

	if( kontakt->info->work_homepage != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_work_homepage ), kontakt->info->work_homepage );

	if( kontakt->info->street != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_street ), kontakt->info->street );

	if( kontakt->info->city != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_city ), kontakt->info->city );

	if( kontakt->info->state != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_state ), kontakt->info->state );

	if( kontakt->info->zip != 0 )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_zip ),
		                    g_strdup_printf( "%d", kontakt->info->zip ) );

	if( kontakt->info->country != 0 )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_country ),
		                    Get_Country_Name( kontakt->info->country ) );

	if( kontakt->info->phone != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_phone ), kontakt->info->phone );

	if( kontakt->info->fax != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_fax ), kontakt->info->fax );

	if( kontakt->info->cellular != NULL )
		gtk_entry_set_text( GTK_ENTRY( kontakt->info->w_cellular ), kontakt->info->cellular );
}

void authorize_uin( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "authorize_uin\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	icq_sendauthmsg( kontakt->uin );
}

void add_user_to_list( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "authorize_uin\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	kontakt->inlist = TRUE;
	Show_Quick_Status_lower( UPDATE_NOTLIST |
	                         ( kontakt->status == STATUS_OFFLINE ? UPDATE_OFFLINE : UPDATE_ONLINE ),
	                         NULL );

	Save_RC();
}

void search_window( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "search_window\n" );
#endif

	gtk_widget_show( create_AddContact() );
}

void display_mess_history( GtkWidget *widget, gpointer data )
{
	GtkWidget *MessageHistory;
	GtkWidget *dialog_vbox7;
	GtkWidget *scrolledwindow8;
	GtkWidget *scrolledwindow9;
	GtkWidget *scrolledwindow10;
	GtkWidget *text;
	GtkWidget *incoming_text;
	GtkWidget *outgoing_text;
	GtkWidget *dialog_action_area7;
	GtkWidget *button23;
   	/* Function widgets */
	GtkWidget *searchbutton1;
	GtkWidget *searchbutton2;
	GtkWidget *searchbutton3;
	GtkWidget *searchbutton_label;
	GtkWidget *searchbutton_label2;
	GtkWidget *searchbutton_label3;
	GtkWidget *searchhbox;
	GtkWidget *searchhbox2;
	GtkWidget *searchhbox3;
	GtkWidget *searchentry;
	GtkWidget *searchentry2;
	GtkWidget *searchentry3;
	GtkWidget *savebutton1;
	GtkWidget *savebutton2;
	GtkWidget *savebutton3;
	GtkWidget *clearbutton1;
	GtkWidget *clearbutton2;
	GtkWidget *clearbutton3;
	GtkWidget *clearbutton_label;
	GtkWidget *clearbutton_label2;
	GtkWidget *clearbutton_label3;
	GtkWidget *savebutton_label;
	GtkWidget *savebutton_label2;
	GtkWidget *savebutton_label3;

   	/* End Function */
	GtkWidget *notebook;
	GtkWidget *dialog_vbox;
	GtkWidget *incoming_vbox;
	GtkWidget *outgoing_vbox;
	GtkWidget *functionbutton;

	gchar *filename;
	gchar *dialog_name;

	GSList *contact;
	GList *listed_history = NULL, *rev_list;

#ifdef HAVE_ICUDB
        GdkColor mesg_color;

	DB_FILE db_file;
	datum firstkey, nextkey, key_data;
	struct tm *my_tm;
	gchar *pdate = NULL;
	char *halves[] = { _("AM"), _("PM") };
	int half = 0;
#else
	char *buffer;
	char *ptr;
	struct stat fs;
	int nchars;
	int cy = 0;
	FILE *file;
#endif


#ifdef TRACE_FUNCTION
	g_print( "display_mess_history\n" );
#endif

	if( data != NULL )
		contact = data;
	else
	{
		contact = get_contact_from_clist();
		if( contact == NULL )
			return;
	}

	if( kontakt->message_history != NULL )
		return;

#ifdef HAVE_ICUDB

	filename = g_strdup_printf( "/%s/.icq/history/%u.db", getenv( "HOME" ),
				    kontakt->uin );

	db_file = icudb_open( filename, DB_READ );

	if( db_file == NULL )
	{
		gnome_error_dialog( _("No message history available.") );
		g_free( filename );
		return;
	}

#else
	filename = g_strdup_printf( "/%s/.icq/history/%u", getenv( "HOME" ),
				    kontakt->uin );

	file = fopen( filename, "r" );

	if( file == NULL )
	{
		gnome_error_dialog( _("No message history available.") );
		g_free( filename );
		return;
	}
#endif

	dialog_name = g_strdup_printf( _("GnomeICU: Message History: %s"), kontakt->nick );
	MessageHistory = gnome_dialog_new ( dialog_name , NULL);
	g_free( dialog_name );

	gtk_widget_set_name (MessageHistory, "MessageHistory");
	gtk_object_set_data (GTK_OBJECT (MessageHistory), "MessageHistory", MessageHistory);
	gtk_object_set_data( GTK_OBJECT( MessageHistory ), "contact", contact );
	gtk_window_set_default_size ( GTK_WINDOW( MessageHistory ), 400, 300);
	GTK_WINDOW (MessageHistory)->type = GTK_WINDOW_DIALOG;
	gtk_window_set_position (GTK_WINDOW (MessageHistory), GTK_WIN_POS_CENTER);
	gtk_window_set_policy (GTK_WINDOW (MessageHistory), TRUE, TRUE, FALSE);
	gtk_window_set_wmclass (GTK_WINDOW (MessageHistory), "MessageHistory", "GnomeICU");

#ifdef GNOME_ICON
        set_window_icon( MessageHistory, "gnomeicu-hist.png" );
#endif

	dialog_vbox7 = GNOME_DIALOG (MessageHistory)->vbox;
	gtk_widget_set_name (dialog_vbox7, "dialog_vbox7");
	gtk_object_set_data (GTK_OBJECT (MessageHistory), "dialog_vbox7", dialog_vbox7);
	gtk_widget_show (dialog_vbox7);

    /* Notebook */

    notebook = gtk_notebook_new();
    gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
    gtk_object_set_data (GTK_OBJECT (MessageHistory), "notebook", notebook);
    gtk_box_pack_start(GTK_BOX (dialog_vbox7), notebook, TRUE, TRUE, 0);
    gtk_widget_show (notebook);

    dialog_vbox = gtk_vbox_new( 0, 5 );
    gtk_container_set_border_width(GTK_CONTAINER (dialog_vbox), 5 );
    gtk_widget_set_name (dialog_vbox, "dialog_vbox");
    gtk_widget_show(dialog_vbox);

    incoming_vbox = gtk_vbox_new( 0, 5 );
    gtk_container_set_border_width(GTK_CONTAINER (incoming_vbox), 5);
    gtk_widget_set_name (incoming_vbox, "incoming_vbox");
    gtk_widget_show(incoming_vbox);

    outgoing_vbox = gtk_vbox_new( 0, 5 );
    gtk_container_set_border_width(GTK_CONTAINER (outgoing_vbox) ,5);
    gtk_widget_set_name (outgoing_vbox, "outgoing_vbox");
    gtk_widget_show(outgoing_vbox);

    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), dialog_vbox,
                              gtk_label_new( _("Dialog") ) );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), incoming_vbox,
                              gtk_label_new( _("Incoming") ) );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), outgoing_vbox,
                              gtk_label_new( _("Outgoing") ) );

    /* Dialog Notebook Page */

	scrolledwindow8 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_name (scrolledwindow8, "scrolledwindow8");
	gtk_widget_ref (scrolledwindow8);
	gtk_object_set_data_full (GTK_OBJECT (MessageHistory), "scrolledwindow8", scrolledwindow8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow8);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolledwindow8, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow8), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text = gtk_text_new (NULL, NULL);
	kontakt->message_history = text;
	gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );
	gtk_widget_set_name (text, "text");
	gtk_widget_ref (text);
	gtk_object_set_data_full (GTK_OBJECT (MessageHistory), "text", text,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_usize( text, 225, 200 );
	gtk_widget_show (text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow8), text);

    /* Incoming Notebook Page */

    scrolledwindow9 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_set_name( scrolledwindow9, "scrolledwindow9");
    gtk_widget_ref (scrolledwindow9);
    gtk_object_set_data_full (GTK_OBJECT( MessageHistory), "scrolledwindow9", scrolledwindow9, (GtkDestroyNotify) gtk_widget_unref);

    gtk_widget_show (scrolledwindow9);
    gtk_box_pack_start (GTK_BOX (incoming_vbox), scrolledwindow9, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow9), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

    incoming_text = gtk_text_new (NULL, NULL);
    gtk_text_set_word_wrap( GTK_TEXT(incoming_text), TRUE );
    gtk_widget_set_name(incoming_text, "incoming_text" );
    gtk_widget_ref( incoming_text );
    gtk_object_set_data_full( GTK_OBJECT (MessageHistory), "incoming_text", incoming_text, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(incoming_text);
    gtk_container_add (GTK_CONTAINER (scrolledwindow9), incoming_text);

    /* Outgoing Notebook Page */

    scrolledwindow10 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_set_name( scrolledwindow10, "scrolledwindow10");
    gtk_widget_ref (scrolledwindow10);
    gtk_object_set_data_full (GTK_OBJECT( MessageHistory), "scrolledwindow10", scrolledwindow10, (GtkDestroyNotify) gtk_widget_unref);

    gtk_widget_show (scrolledwindow10);
    gtk_box_pack_start (GTK_BOX (outgoing_vbox), scrolledwindow10, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow10), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

    outgoing_text = gtk_text_new (NULL, NULL);
    gtk_text_set_word_wrap( GTK_TEXT(outgoing_text), TRUE );
    gtk_widget_set_name(outgoing_text, "outgoing_text" );
    gtk_widget_ref( outgoing_text );
    gtk_object_set_data_full( GTK_OBJECT (MessageHistory), "outgoing_text", outgoing_text, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(outgoing_text);
    gtk_container_add (GTK_CONTAINER (scrolledwindow10), outgoing_text);

	gtk_signal_connect( GTK_OBJECT( MessageHistory ), "destroy",
	                    GTK_SIGNAL_FUNC( clear_pointer ),
	                    &kontakt->message_history );

   	/* Dialog Search */
   	searchhbox = gtk_hbox_new(FALSE, 8);
   	gtk_widget_set_name(searchhbox, "searchhbox");
   	gtk_widget_ref(searchhbox);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchhbox", searchhbox,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(dialog_vbox), searchhbox, FALSE, TRUE, 0);

   	searchentry = gtk_entry_new();
   	gtk_widget_set_name(searchentry, "searchentry");
   	gtk_widget_ref (searchentry);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchentry", searchentry,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_signal_connect(GTK_OBJECT(searchentry), "changed",
			   GTK_SIGNAL_FUNC(searchentry_changed),
			   NULL);

       	gtk_box_pack_start(GTK_BOX(searchhbox), searchentry, TRUE, TRUE, 0);

   	clearbutton1 = gtk_button_new();
   	gtk_widget_set_name(clearbutton1, "clearbutton1");
   	gtk_widget_ref (clearbutton1);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "clearbutton1", clearbutton1,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox), clearbutton1, FALSE, TRUE, 0);

	   savebutton1 = gtk_button_new();
	   gtk_widget_set_name(savebutton1, "savebutton1");
	   gtk_widget_ref (savebutton1);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "savebutton1", savebutton1,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox), savebutton1, FALSE, TRUE, 0);

   	searchbutton1 = gtk_button_new();
   	gtk_widget_set_name(searchbutton1, "searchbutton1");
   	gtk_widget_ref (searchbutton1);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchbutton1", searchbutton1,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(searchhbox), searchbutton1, FALSE, TRUE, 0);

       gtk_object_set_data(GTK_OBJECT(clearbutton1), "text", text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton1), "incoming_text", incoming_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton1), "outgoing_text", outgoing_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton1), "filename", filename);

   	gtk_object_set_data(GTK_OBJECT(searchbutton1), "searchentry", searchentry);
   	gtk_object_set_data(GTK_OBJECT(searchbutton1), "history", text);
   	gtk_object_set_data(GTK_OBJECT(searchbutton1), "searched", GINT_TO_POINTER((gboolean)FALSE));
	   gtk_object_set_data(GTK_OBJECT(searchbutton1), "searchbutton2", searchbutton1 );

   	gtk_object_set_data(GTK_OBJECT(searchentry), "searchentry", searchentry);
   	gtk_object_set_data(GTK_OBJECT(searchentry), "history", text);
   	gtk_object_set_data(GTK_OBJECT(searchentry), "searched", GINT_TO_POINTER((gboolean)FALSE));
   	gtk_object_set_data(GTK_OBJECT(searchentry), "searchbutton2", searchbutton1 );

	   gtk_object_set_data(GTK_OBJECT(savebutton1), "text", text);
	   gtk_object_set_data(GTK_OBJECT(savebutton1), "contact", contact);


      	gtk_signal_connect(GTK_OBJECT(searchbutton1), "clicked",
				  GTK_SIGNAL_FUNC( search_cb ),
				  NULL);

	gtk_signal_connect( GTK_OBJECT( searchentry ), "activate",
	                    GTK_SIGNAL_FUNC( search_cb ),
	                    NULL );

	   gtk_signal_connect(GTK_OBJECT(clearbutton1), "clicked",
	           GTK_SIGNAL_FUNC( show_clear_dialog ), NULL);

	   gtk_signal_connect(GTK_OBJECT(savebutton1), "clicked",
	           GTK_SIGNAL_FUNC( save_hist_cb ), NULL);

   	clearbutton_label = gtk_label_new( _("Clear") );
   	gtk_container_add(GTK_CONTAINER(clearbutton1), clearbutton_label);

   	savebutton_label = gtk_label_new( _("Save As") );
   	gtk_container_add(GTK_CONTAINER(savebutton1), savebutton_label);

   	searchbutton_label = gtk_label_new( _("Search") );
   	gtk_container_add(GTK_CONTAINER(searchbutton1), searchbutton_label);

   	gtk_object_set_data(GTK_OBJECT(searchbutton1), "label", searchbutton_label);
	gtk_object_set_data(GTK_OBJECT(searchentry), "label", searchbutton_label );
   	gtk_object_set_data(GTK_OBJECT(searchentry), "button", searchbutton1);
   	gtk_object_set_data(GTK_OBJECT(searchhbox), "searchentry", searchentry);

   	/* Incoming Search */
   	searchhbox2 = gtk_hbox_new(FALSE, 8);
   	gtk_widget_set_name(searchhbox2, "searchhbox2");
   	gtk_widget_ref(searchhbox2);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchhbox2", searchhbox2,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(incoming_vbox), searchhbox2, FALSE, TRUE, 0);

   	searchentry2 = gtk_entry_new();
   	gtk_widget_set_name(searchentry2, "searchentry2");
   	gtk_widget_ref (searchentry2);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchentry2", searchentry2,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_signal_connect(GTK_OBJECT(searchentry2), "changed",
			   GTK_SIGNAL_FUNC(searchentry_changed),
			   NULL);

       	gtk_box_pack_start(GTK_BOX(searchhbox2), searchentry2, TRUE, TRUE, 0);

   	clearbutton2 = gtk_button_new();
   	gtk_widget_set_name(clearbutton2, "clearbutton2");
   	gtk_widget_ref (clearbutton2);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "clearbutton2", clearbutton2,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox2), clearbutton2, FALSE, TRUE, 0);

	   savebutton2 = gtk_button_new();
	   gtk_widget_set_name(savebutton2, "savebutton2");
	   gtk_widget_ref (savebutton2);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "savebutton2", savebutton2,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox2), savebutton2, FALSE, TRUE, 0);

   	searchbutton2 = gtk_button_new();
   	gtk_widget_set_name(searchbutton2, "searchbutton2");
   	gtk_widget_ref (searchbutton2);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchbutton2", searchbutton2,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(searchhbox2), searchbutton2, FALSE, TRUE, 0);

       gtk_object_set_data(GTK_OBJECT(clearbutton2), "text", text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton2), "incoming_text", incoming_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton2), "outgoing_text", outgoing_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton2), "filename", filename);   

   	gtk_object_set_data(GTK_OBJECT(searchbutton2), "searchentry", searchentry2);
   	gtk_object_set_data(GTK_OBJECT(searchbutton2), "history", incoming_text);
   	gtk_object_set_data(GTK_OBJECT(searchbutton2), "searched", GINT_TO_POINTER((gboolean)FALSE));
	   gtk_object_set_data(GTK_OBJECT(searchbutton2), "searchbutton2", searchbutton2 );

   	gtk_object_set_data(GTK_OBJECT(searchentry2), "searchentry", searchentry2);
   	gtk_object_set_data(GTK_OBJECT(searchentry2), "history", incoming_text);
   	gtk_object_set_data(GTK_OBJECT(searchentry2), "searched", GINT_TO_POINTER((gboolean)FALSE));
	   gtk_object_set_data(GTK_OBJECT(searchentry2), "searchbutton2", searchbutton2);

	   gtk_object_set_data(GTK_OBJECT(savebutton2), "text", text);
	   gtk_object_set_data(GTK_OBJECT(savebutton2), "contact", contact);

      	gtk_signal_connect(GTK_OBJECT(searchbutton2), "clicked",
				  GTK_SIGNAL_FUNC( search_cb ),
				  NULL);

	gtk_signal_connect( GTK_OBJECT( searchentry2 ), "activate",
	                    GTK_SIGNAL_FUNC( search_cb ),
	                    NULL );

	   gtk_signal_connect(GTK_OBJECT(clearbutton2), "clicked",
	           GTK_SIGNAL_FUNC( show_clear_dialog ), NULL);

	   gtk_signal_connect(GTK_OBJECT(savebutton2), "clicked",
	           GTK_SIGNAL_FUNC( save_hist_cb ), NULL);

   	clearbutton_label2 = gtk_label_new( _("Clear") );
   	gtk_container_add(GTK_CONTAINER(clearbutton2), clearbutton_label2);

   	savebutton_label2 = gtk_label_new( _("Save As") );
   	gtk_container_add(GTK_CONTAINER(savebutton2), savebutton_label2);

   	searchbutton_label2 = gtk_label_new( _("Search") );
   	gtk_container_add(GTK_CONTAINER(searchbutton2), searchbutton_label2);
   
   	gtk_object_set_data(GTK_OBJECT(searchbutton2), "label", searchbutton_label2);
	gtk_object_set_data(GTK_OBJECT(searchentry2), "label", searchbutton_label2 );
   	gtk_object_set_data(GTK_OBJECT(searchentry2), "button", searchbutton2);
   	gtk_object_set_data(GTK_OBJECT(searchhbox2), "searchentry", searchentry2);

   	/* Outgoing Search */
   	searchhbox3 = gtk_hbox_new(FALSE, 8);
   	gtk_widget_set_name(searchhbox3, "searchhbox3");
   	gtk_widget_ref(searchhbox3);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchhbox3", searchhbox3,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(outgoing_vbox), searchhbox3, FALSE, TRUE, 0);

   	searchentry3 = gtk_entry_new();
   	gtk_widget_set_name(searchentry3, "searchentry3");
   	gtk_widget_ref (searchentry3);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchentry3", searchentry3,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_signal_connect(GTK_OBJECT(searchentry3), "changed",
			   GTK_SIGNAL_FUNC(searchentry_changed),
			   NULL);

       	gtk_box_pack_start(GTK_BOX(searchhbox3), searchentry3, TRUE, TRUE, 0);

   	clearbutton3 = gtk_button_new();
   	gtk_widget_set_name(clearbutton3, "clearbutton3");
   	gtk_widget_ref (clearbutton3);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "clearbutton3", clearbutton3,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox3), clearbutton3, FALSE, TRUE, 0);

	   savebutton3 = gtk_button_new();
	   gtk_widget_set_name(savebutton3, "savebutton3");
	   gtk_widget_ref (savebutton3);
	   gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "savebutton3", savebutton3,
	             (GtkDestroyNotify)gtk_widget_unref);
	   gtk_box_pack_end(GTK_BOX(searchhbox3), savebutton3, FALSE, TRUE, 0);

   	searchbutton3 = gtk_button_new();
   	gtk_widget_set_name(searchbutton3, "searchbutton3");
   	gtk_widget_ref (searchbutton3);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "searchbutton3", searchbutton3,
				 (GtkDestroyNotify) gtk_widget_unref);
   	gtk_box_pack_end(GTK_BOX(searchhbox3), searchbutton3, FALSE, TRUE, 0);

       gtk_object_set_data(GTK_OBJECT(clearbutton3), "text", text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton3), "incoming_text", incoming_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton3), "outgoing_text", outgoing_text);
	   gtk_object_set_data(GTK_OBJECT(clearbutton3), "filename", filename);

   	gtk_object_set_data(GTK_OBJECT(searchbutton3), "searchentry", searchentry3);
   	gtk_object_set_data(GTK_OBJECT(searchbutton3), "history", outgoing_text);
   	gtk_object_set_data(GTK_OBJECT(searchbutton3), "searched", GINT_TO_POINTER((gboolean)FALSE));
	   gtk_object_set_data(GTK_OBJECT(searchbutton3), "searchbutton2", searchbutton3 );

   	gtk_object_set_data(GTK_OBJECT(searchentry3), "searchentry", searchentry3);
   	gtk_object_set_data(GTK_OBJECT(searchentry3), "history", outgoing_text);
   	gtk_object_set_data(GTK_OBJECT(searchentry3), "searched", GINT_TO_POINTER((gboolean)FALSE));
	   gtk_object_set_data(GTK_OBJECT(searchentry3), "searchbutton2", searchbutton3);

	   gtk_object_set_data(GTK_OBJECT(savebutton3), "text", text);
	   gtk_object_set_data(GTK_OBJECT(savebutton3), "contact", contact);

      	gtk_signal_connect(GTK_OBJECT(searchbutton3), "clicked",
				  GTK_SIGNAL_FUNC( search_cb ),
				  NULL);

	gtk_signal_connect( GTK_OBJECT( searchentry3 ), "activate",
	                    GTK_SIGNAL_FUNC( search_cb ),
	                    NULL );

	   gtk_signal_connect(GTK_OBJECT(clearbutton3), "clicked",
	           GTK_SIGNAL_FUNC( show_clear_dialog ), NULL);

	   gtk_signal_connect(GTK_OBJECT(savebutton3), "clicked",
	           GTK_SIGNAL_FUNC( save_hist_cb ), NULL);

   	clearbutton_label3 = gtk_label_new( _("Clear") );
   	gtk_container_add(GTK_CONTAINER(clearbutton3), clearbutton_label3);

   	savebutton_label3 = gtk_label_new( _("Save As") );
   	gtk_container_add(GTK_CONTAINER(savebutton3), savebutton_label3);

   	searchbutton_label3 = gtk_label_new( _("Search") );
   	gtk_container_add(GTK_CONTAINER(searchbutton3), searchbutton_label3);
   
   	gtk_object_set_data(GTK_OBJECT(searchbutton3), "label", searchbutton_label3);
	   gtk_object_set_data(GTK_OBJECT(searchentry3), "label", searchbutton_label3 );
   	gtk_object_set_data(GTK_OBJECT(searchentry3), "button", searchbutton3);
   	gtk_object_set_data(GTK_OBJECT(searchhbox3), "searchentry", searchentry3);

   	/* End Search */

	dialog_action_area7 = GNOME_DIALOG (MessageHistory)->action_area;
	gtk_widget_set_name (dialog_action_area7, "dialog_action_area7");
	gtk_object_set_data (GTK_OBJECT (MessageHistory), "dialog_action_area7", dialog_action_area7);
	gtk_widget_show (dialog_action_area7);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area7), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area7), 8);

   	/* Search button */
   	gnome_dialog_append_button_with_pixmap(GNOME_DIALOG(MessageHistory), _("Functions >>"), GNOME_STOCK_PIXMAP_EXEC);
       functionbutton = g_list_last (GNOME_DIALOG(MessageHistory)->buttons)->data;
   	gtk_widget_set_name(functionbutton, "functionbutton");
   	gtk_widget_ref(functionbutton);
   	gtk_object_set_data_full(GTK_OBJECT(MessageHistory), "functionbutton", functionbutton,
				 (GtkDestroyNotify)gtk_widget_unref);

	gtk_signal_connect(GTK_OBJECT(functionbutton), "clicked",
			   GTK_SIGNAL_FUNC( search_show_cb ),
			   NULL);

	gtk_object_set_data(GTK_OBJECT(functionbutton), "searchhbox", searchhbox);
	gtk_object_set_data(GTK_OBJECT(functionbutton), "searchhbox2", searchhbox2);
	gtk_object_set_data(GTK_OBJECT(functionbutton), "searchhbox3", searchhbox3);
	gtk_object_set_data(GTK_OBJECT(functionbutton), "notebook", notebook );

	gtk_widget_show(functionbutton);
   	/* End Search */

	gnome_dialog_append_button (GNOME_DIALOG (MessageHistory), GNOME_STOCK_BUTTON_CLOSE);
	button23 = g_list_last (GNOME_DIALOG (MessageHistory)->buttons)->data;
	gtk_widget_set_name (button23, "button23");
	gtk_widget_ref (button23);
	gtk_object_set_data_full (GTK_OBJECT (MessageHistory), "button23", button23,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_signal_connect( GTK_OBJECT( button23 ), "clicked",
	                    GTK_SIGNAL_FUNC( clear_pointer ),
	                    &kontakt->message_history );

	gtk_signal_connect_object( GTK_OBJECT( button23 ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( MessageHistory ) );
	gtk_widget_show (button23);
	GTK_WIDGET_SET_FLAGS (button23, GTK_CAN_DEFAULT);

	gtk_widget_grab_default (button23);

#ifdef HAVE_ICUDB

	firstkey = icudb_firstkey ( db_file );

	/* First, create a list of keys from the history file */
	while ( firstkey.dptr ) {

		listed_history = g_list_prepend( listed_history, GINT_TO_POINTER(firstkey.dptr) );

		nextkey = icudb_nextkey ( db_file, firstkey );
		firstkey = nextkey;

		while( gtk_events_pending() )
			gtk_main_iteration();

	}

	/* Then sort the keys */
	listed_history = g_list_sort (listed_history, (GCompareFunc)compare_dates);

	/* Then print the data associated with the keys */
	rev_list = g_list_last( listed_history );

	while( rev_list != NULL ) {

		firstkey.dptr = rev_list->data;
		firstkey.dsize = sizeof(time_t);

		key_data = icudb_fetch( db_file, firstkey );

		if(key_data.dptr != NULL) {
			my_tm = localtime( rev_list->data );

			half = 0;
			if( my_tm->tm_hour > 12 ) {
				my_tm->tm_hour -= 12 ;
				half ++;
			}

			pdate = g_strdup_printf( "\n*** %02d/%02d/%d %02d:%02d:%02d %s [ %s ] ***\n",
						 my_tm->tm_mon + 1,
						 my_tm->tm_mday,
						 my_tm->tm_year + 1900,
						 my_tm->tm_hour,
						 my_tm->tm_min,
						 my_tm->tm_sec,
						 halves[ half ],
						 ( (MESG_ISRECV(key_data.dptr)) ? "Received" : "Sent" ) );

			/* It's possible to display unread messages in a different
			 * color than read messages.  Something like:
			 *
			 * if ( MESG_ISREAD(key_data.dptr) )
			 *  GdkColor mesg_color = NULL;
			 * else
			 *  GdkColor mesg_color = ???;
			 */

		   if (MESG_ISRECV(key_data.dptr)) {
		      mesg_color.pixel = 0;
		      mesg_color.red = 65535;
		      mesg_color.green = 0;
		      mesg_color.blue = 0;
		   } else {
		      mesg_color.pixel = 0;
		      mesg_color.red = 0;
		      mesg_color.green = 0;
		      mesg_color.blue = 65535;
		   }

			gtk_text_insert( GTK_TEXT( text ), NULL, &mesg_color, NULL,
					 pdate, -1 );

			/* This gets a +2 offset for the two bytes we use for flags */
			gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
					 (key_data.dptr + 2), (key_data.dsize - 2) );
			gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
					 "\n\n", -1 );

            if (MESG_ISRECV(key_data.dptr)) {
                gtk_text_insert( GTK_TEXT( incoming_text ), NULL, &mesg_color, NULL, pdate, -1 );
                gtk_text_insert( GTK_TEXT( incoming_text ), NULL, NULL,
                       NULL, (key_data.dptr + 2), (key_data.dsize - 2) );
                gtk_text_insert( GTK_TEXT( incoming_text ), NULL, NULL,
                       NULL, "\n\n", -1 );
            } else {
                gtk_text_insert( GTK_TEXT( outgoing_text ), NULL, &mesg_color, NULL, pdate, -1 );
                gtk_text_insert( GTK_TEXT( outgoing_text ), NULL, NULL,
                       NULL, (key_data.dptr + 2), (key_data.dsize - 2) );
                gtk_text_insert( GTK_TEXT( outgoing_text ), NULL, NULL,
                       NULL, "\n\n", -1 );
            }

			g_free(pdate);

			icudb_free (key_data.dptr);
		}


		while( gtk_events_pending() )
			gtk_main_iteration();

		icudb_free (rev_list->data);
		rev_list = rev_list->prev;
	}

	/* Finally, close the db file */
	icudb_close ( db_file );

#else

	stat( filename, &fs );

	buffer = (char*)g_malloc( fs.st_size + 16 );

	nchars = fread( buffer, 1, fs.st_size, file );
	fclose( file );

	ptr = buffer;

	while( cy < nchars )
	{
		if( buffer[ cy ] == '*' )
		{
			if( buffer[ cy + 1 ] == '*' && buffer[ cy + 2 ] == '*' &&
			    buffer[ cy + 3 ] == ' ' )
			{
				buffer[ cy ] = 0x00;
				listed_history = g_list_prepend( listed_history, g_strdup( ptr ) );

				ptr = &buffer[ cy ];
				buffer[ cy ] = '*';

				while( gtk_events_pending() )
					gtk_main_iteration();
			}
		}

		cy ++;
	}

	if( strlen( ptr ) )
	{
		buffer[ cy++ ] = '\n';
		buffer[ cy ] = 0x00;
		listed_history = g_list_prepend( listed_history, g_strdup( ptr ) );
	}

	rev_list = listed_history;

	/* Doesn't this leave off the first entry? */
	while( rev_list != NULL )
	{
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 rev_list->data, -1 );
		/* Insert text also in one of other boxes */
		if( strncmp( rev_list->data + 27, "[ Sent ]", 8 ) )
			gtk_text_insert( GTK_TEXT( incoming_text ),
					 NULL, NULL, NULL,
					 rev_list->data, -1 );
		else
			gtk_text_insert( GTK_TEXT( outgoing_text ),
					 NULL, NULL, NULL,
					 rev_list->data, -1 );
		g_free( rev_list->data );
		rev_list = rev_list->next;
	}

	g_free( buffer );
#endif

	g_free(filename);

	gtk_widget_show_all( MessageHistory );
	gtk_widget_hide_all( searchhbox );
	gtk_widget_hide_all( searchhbox2 );
	gtk_widget_hide_all( searchhbox3 );

	g_list_free( listed_history );
}

void save_hist_cb(GtkWidget *widget, gpointer data)
{
    GSList *contact;
    GtkWidget *filew;
    GtkWidget *text;
    gchar *savename;
    gint length;

    text = gtk_object_get_data(GTK_OBJECT(widget), "text");
    length = gtk_text_get_length(GTK_TEXT(text));
    if(length == 0){
        gnome_error_dialog(_("No history to save."));
    } else {
        contact = gtk_object_get_data(GTK_OBJECT(widget), "contact");
        savename = g_strconcat(kontakt->nick, ".hist", NULL);

        filew = gtk_file_selection_new("Save History");
    	gtk_window_set_wmclass (GTK_WINDOW (filew), "Save History", "GnomeICU");

    	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                               "clicked", (GtkSignalFunc) gtk_widget_destroy,
                               GTK_OBJECT (filew));

        gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                               "clicked", (GtkSignalFunc) file_ok_cb, filew );

        gtk_object_set_data(GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "filew", filew );
        gtk_object_set_data(GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "text", text );

    	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew), savename );
        gtk_widget_show(filew);
    }
}

void file_ok_cb(GtkWidget *widget, gpointer data)
{
    GtkWidget *filew;
    GtkWidget *text;
    gchar *writename;
    gchar *history_text;
    /*, *new_history_text; */
    FILE *writefile;

#ifdef TRACE_FUNCTION
    g_print( "file_ok_cb" );
#endif

    filew = gtk_object_get_data(GTK_OBJECT(widget), "filew");
    text = gtk_object_get_data(GTK_OBJECT(widget), "text");
    writename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(filew));

    history_text = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

	/* new_history_text = g_strdup_printf("%s", history_text);*/

    writefile = fopen( writename, "w" );
    if (writefile){
        fprintf(writefile, "%s", history_text);
        fclose(writefile);
    } else {
        gnome_error_dialog(_("File save error."));
    }

	gtk_widget_destroy(filew);

}

void show_clear_dialog(GtkWidget *widget, gpointer data)
{
    gnome_question_dialog(_("Clear all stored history?"), clear_hist_cb, widget);
}

void clear_hist_cb(gint reply, gpointer data)
{
    GtkWidget *text;
    GtkWidget *incoming_text;
    GtkWidget *outgoing_text;
    guint length;
    gchar *filename;

    if( reply == GNOME_YES ){
        text = gtk_object_get_data(GTK_OBJECT(data), "text");
        incoming_text = gtk_object_get_data(GTK_OBJECT(data), "incoming_text");
        outgoing_text = gtk_object_get_data(GTK_OBJECT(data), "outgoing_text");
        filename = gtk_object_get_data(GTK_OBJECT(data), "filename");

        /* clear the text widgets */
        length = gtk_text_get_length(GTK_TEXT(text));
        gtk_text_set_point(GTK_TEXT(text), 0);
        gtk_text_forward_delete(GTK_TEXT(text), length);
        length = gtk_text_get_length(GTK_TEXT(incoming_text));
        gtk_text_set_point(GTK_TEXT(incoming_text), 0);
        gtk_text_forward_delete(GTK_TEXT(incoming_text), length);
        length = gtk_text_get_length(GTK_TEXT(outgoing_text));
        gtk_text_set_point(GTK_TEXT(outgoing_text), 0);
        gtk_text_forward_delete(GTK_TEXT(outgoing_text), length);
#ifdef HAVE_ICUDB
        icudb_close_dbpath( filename );
#endif
        remove( filename );
    }
}

void search_show_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *searchhbox;
	GtkWidget *searchhbox2;
	GtkWidget *searchhbox3;
	GtkWidget *searchentry;
	GtkWidget *notebook;
	gint currenttab;

	searchhbox = gtk_object_get_data(GTK_OBJECT(widget), "searchhbox");
	searchhbox2 = gtk_object_get_data(GTK_OBJECT(widget), "searchhbox2");
	searchhbox3 = gtk_object_get_data(GTK_OBJECT(widget), "searchhbox3");
	notebook = gtk_object_get_data(GTK_OBJECT(widget), "notebook");

    currenttab = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));

	if( currenttab == 0){
	    searchentry = gtk_object_get_data(GTK_OBJECT(searchhbox), "searchentry" );
	} else if( currenttab == 1){
	    searchentry = gtk_object_get_data(GTK_OBJECT(searchhbox2), "searchentry" );
	} else {
	    searchentry = gtk_object_get_data(GTK_OBJECT(searchhbox3), "searchentry" );
	}

	gtk_widget_show_all(searchhbox);
	gtk_widget_show_all(searchhbox2);
	gtk_widget_show_all(searchhbox3);
	gtk_widget_grab_focus( searchentry );
	gtk_widget_hide(widget);
}

void searchentry_changed(GtkEditable *widget, gpointer data)
{
   GtkWidget *button;
   GtkWidget *label;
   gboolean searched;

   button = gtk_object_get_data(GTK_OBJECT(widget), "button");
   label = gtk_object_get_data(GTK_OBJECT(button), "label");

   searched = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(button), "searched"));
   searched = FALSE;
   gtk_object_set_data(GTK_OBJECT(button), "searched", GINT_TO_POINTER(searched));

   gtk_label_set_text(GTK_LABEL(label), _("Search") );
}

void search_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *searchentry;
	GtkWidget *label;
	GtkWidget *history;
	GtkWidget *searchbutton2;
	gboolean searched;
	gchar *historytext;
	gchar *searchstring;
	gint searchfrom,foundat = 0;

	/* Get the widgets */
	searchbutton2 = gtk_object_get_data(GTK_OBJECT(widget), "searchbutton2" );
	searchentry = gtk_object_get_data(GTK_OBJECT(widget), "searchentry");
	label = gtk_object_get_data(GTK_OBJECT(widget), "label");
	history = gtk_object_get_data(GTK_OBJECT(widget), "history");
	searched = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "searched"));

	if(searched)
		foundat = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "foundat"));

	/* OK, lets search now! */

	searchstring = gtk_editable_get_chars(GTK_EDITABLE(searchentry), 0, -1);
	if (!searched) {
		searchfrom = 0;
		foundat = 0;
	} else {
		searchfrom = foundat;
	}
	if (!searched) searched = TRUE;
	historytext = gtk_editable_get_chars(GTK_EDITABLE(history), searchfrom, -1);
	foundat = (gint)(strstr(historytext, searchstring));
	gtk_text_freeze( GTK_TEXT( history ) );
	if (foundat != 0)
	 {
		 foundat -= (gint)historytext;
		 gtk_editable_set_position(GTK_EDITABLE(history), foundat + searchfrom);
		 gtk_editable_select_region(GTK_EDITABLE(history), foundat + searchfrom, foundat + strlen(searchstring) + searchfrom);
		 foundat += searchfrom + strlen(searchstring) + 1;
	 }
	else
	 {
		 gnome_ok_dialog(_("No more occurrences found."));
		 searched = FALSE;
	 }


	gtk_text_thaw( GTK_TEXT( history ) );

	gtk_object_set_data(GTK_OBJECT(searchbutton2), "searched", GINT_TO_POINTER(searched));
	gtk_object_set_data(GTK_OBJECT(searchbutton2), "foundat", GINT_TO_POINTER(foundat));
	gtk_object_set_data(GTK_OBJECT(searchentry), "searched", GINT_TO_POINTER(searched));
	gtk_object_set_data(GTK_OBJECT(searchentry), "foundat", GINT_TO_POINTER(foundat));

	g_free(historytext);
	g_free(searchstring);

	if (searched) {
		gtk_label_set_text(GTK_LABEL(label), _("Search Again"));
	} else {
		gtk_label_set_text(GTK_LABEL(label), _("Search"));
	}
}

void read_next( GtkWidget *widget, gpointer data )
{
     GtkWidget *text;
     GtkWidget *timefield;
     GtkWidget *fromfield = NULL;
     GtkWidget *subjectfield = NULL;
     GtkWidget *emailfield = NULL;
     GtkWidget *ipfield = NULL;
     GtkWidget *iplabel = NULL;

     gchar *msgtime;
     gchar *new_str;
     guchar *tmp, *tmp2 = NULL;
     gchar *msgtemp, *msgtemp2 = NULL;

     int cx;

     GSList *contact;

     STORED_MESSAGE_PTR msg;

#ifdef TRACE_FUNCTION
     g_print( "read_next\n" );
#endif

     if (!GTK_WIDGET_SENSITIVE (widget))
     	return;

     contact = gtk_object_get_data( GTK_OBJECT( widget ), "contact" );
     if( contact == NULL )
	  return;
     msg = (STORED_MESSAGE_PTR)kontakt->stored_messages->data;
     text = gtk_object_get_data( GTK_OBJECT( widget ), "text" );
     timefield = gtk_object_get_data( GTK_OBJECT( widget ), "time" );

     if ( kontakt->uin == 10 )
     {
	  fromfield = gtk_object_get_data( GTK_OBJECT( widget ), "fromfield" );
	  subjectfield = gtk_object_get_data( GTK_OBJECT( widget ), "subjectfield" );
	  emailfield = gtk_object_get_data( GTK_OBJECT( widget ), "emailfield" );
	  ipfield = gtk_object_get_data( GTK_OBJECT( widget ), "ipfield" );
	  iplabel = gtk_object_get_data( GTK_OBJECT( ipfield ), "label" );
     }

     if( g_slist_length( kontakt->stored_messages ) )
     {
/*	  snprintf( buf, 100, _("Message from %s:"), kontakt->nick );  What is this line for?? */
	  gtk_editable_delete_text(GTK_EDITABLE(text), 0, -1);

/* Strip \r's out of text - \r's are for Windows people */
	  new_str = stripr( msg->message );
	  g_free( msg->message );
	  msg->message = new_str;

	  msgtime = g_strdup( msg->message );
	  cx = 0;
	  while(msgtime[cx++] != '\n' );
	  msgtime[cx] = 0;
	  gtk_entry_set_text( GTK_ENTRY( timefield ), _(msgtime) );
	  g_free( msgtime );

	  kanji_conv_to_locale_s( &msg->message );

	  if ( kontakt->uin == 10 )
	  {
		     msgtemp2 = msgtemp = g_strndup( cx + msg->message , 1024);

		     /* I know this is ugly, fix your translation --Tester */
		     if (toggles->russian)
			  tmp = g_strdup_printf("%c", 192);
		     else
			  tmp = g_strdup_printf("%c", 0xFE);

//		     tmp2 = strsep( &msgtemp, tmp);
		     tmp2 = strtok( msgtemp, tmp);
		     g_assert(tmp2 != NULL);
		     gtk_entry_set_text( GTK_ENTRY( fromfield ), tmp2 );

		     msgtemp +=  2;
//		     tmp2 = strsep( &msgtemp, tmp);
		     tmp2 = strtok( NULL, tmp);
		     g_assert(tmp2 != NULL);
		     gtk_entry_set_text( GTK_ENTRY( emailfield ), tmp2 );

		     msgtemp += 2;
//		     tmp2 = strsep( &msgtemp, "\n");
		     tmp2 = strtok( msgtemp, "\n");
		     g_assert(tmp2 != NULL);

		     if (!strncmp(tmp2,"Sender IP:", 10))
		     {
			  gtk_widget_show (iplabel);
			  gtk_widget_show (ipfield);

			  tmp2 = strchr(tmp2, ':') + 2;
			  g_assert(tmp2 != (guchar *)2);

			  gtk_entry_set_text( GTK_ENTRY( ipfield ), tmp2 );

			//  tmp2 = strsep( &msgtemp, "\n");
			  tmp2 = strtok( msgtemp, "\n");
			  g_assert(tmp2 != NULL);
		     }
		     else
		     {
			  gtk_widget_hide(ipfield);
			  gtk_widget_hide(iplabel);
		     }

		     tmp2 = strchr(tmp2, ':' ) + 2;
		     gtk_entry_set_text( GTK_ENTRY( subjectfield ), (gchar *)tmp2 );

//		     tmp2 = strsep( &msgtemp, tmp);
		     tmp2 = strtok( NULL, tmp);
		     g_free(tmp);

		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
				      tmp2, -1);
		     g_free( msgtemp2 );

		}
		else
		     gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL,
		                 ( cx + msg->message ), -1 );

          g_free( msg->chatsessionname );
	  /* Is this needed? it is only in show_contact_message() 
	  if (msg->chatcontact && ((ChatContact *)msg->chatcontact)->contact == NULL)
	  */
	  g_free( msg->chatcontact );
	  g_free( msg->message );
	  g_free( msg );
	  kontakt->stored_messages = g_slist_remove( kontakt->stored_messages, msg );

	  if( g_slist_length( kontakt->stored_messages ) == 0 )
	  {
	       kontakt->icon_p = GetIcon_p( kontakt->status );
	       kontakt->icon_b = GetIcon_b( kontakt->status );
	       kontakt->need_update = 1;
	       gtk_widget_set_sensitive( kontakt->read_next, FALSE );
	  }
	  else
	  {
	       /* msg points to some strange location already */
	       if( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type != MESSAGE_TEXT )
		    gtk_widget_set_sensitive( kontakt->read_next, FALSE );
	       else
		    gtk_widget_set_sensitive( kontakt->read_next, TRUE );
	  }

	  Update_Contact_Style( Which_List( kontakt ), kontakt );
	  applet_update( Current_Status, NULL );
	  Shortcut_Update( kontakt );
     }
}

void send_chat_request( GtkWidget *widget, GtkWidget *text )
{
     GSList *contact;
     ChatSession *csession = NULL;
     GtkWidget *menu;

#ifdef TRACE_FUNCTION
     g_print( "send_chat_request\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
	     return;

	menu = gtk_object_get_data( GTK_OBJECT(widget), "OptionMenu");
	if (GTK_IS_MENU (menu))
	     csession = gtk_object_get_data( GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu))), "ChatSession");


	TCPSendChatRequest( kontakt->uin,
	                    gtk_editable_get_chars( GTK_EDITABLE( text ), 0, -1 ), csession);
}

void send_file_request( GtkWidget *widget, gpointer data )
{
	GSList *filenames = 0;
	gchar *filename = 0;
	gchar *msg;
	GtkText *text;
	GtkWidget *entry;
	UIN_T uin;
	gint currow;

	uin = GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "uin" ) );
	text = gtk_object_get_data( GTK_OBJECT( widget ), "reason" );
	entry = gtk_object_get_data( GTK_OBJECT( widget ), "filelist" );

	for (currow = 0;gtk_clist_get_text( GTK_CLIST(entry), currow, 0, &filename);currow++)
		filenames = g_slist_append(filenames, filename);

	msg = g_strdup( gtk_editable_get_chars( GTK_EDITABLE( text ), 0, -1 ) );

	TCPSendFileRequest( uin, msg, filenames );

	g_slist_free(filenames);

	g_free( msg );
}

void request_chat( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox1;
	GtkWidget *label9;
	GtkWidget *scrolledwindow2;
	GtkWidget *text2;
	GtkWidget *dialog_action_area2;
	GtkWidget *button6;
	GtkWidget *button7;
	GtkWidget *hbox6 = NULL;
	GtkWidget *label7;
	GtkWidget *menuitem;
	GtkWidget *optionmenu;
	GtkWidget *optionmenu_menu = NULL;

	GSList *contact;

	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "request_chat\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	window = gnome_dialog_new ( _("GnomeICU: Chat Request"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Chat_Request", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_default_size (GTK_WINDOW (window), 250, 210);
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

#ifdef GNOME_ICON
        set_window_icon( window, "gnomeicu-chat.png" );
#endif

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox2", dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Send Chat Request to %s:\n\nReason:"),
	                       kontakt->nick );

	label9 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (window), "label9", label9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (vbox1), label9, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label9), 7.45058e-09, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow2", scrolledwindow2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text2 = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text2);
	gtk_object_set_data_full (GTK_OBJECT (window), "text2", text2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text2);
	GTK_WIDGET_SET_FLAGS (text2, GTK_CAN_FOCUS);
	gtk_text_set_word_wrap( GTK_TEXT( text2 ), TRUE );
	gtk_text_set_editable( GTK_TEXT( text2 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), text2);

	if (Sessions != NULL)
	{
	     GSList *gslcsession;
	     GSList *member_cc;

	     hbox6 = gtk_hbox_new(FALSE, 0);
	     gtk_box_pack_start (GTK_BOX (vbox1), hbox6,  TRUE, TRUE, 0);
	     label7 = gtk_label_new(_("Invite to session: "));
	     gtk_box_pack_start (GTK_BOX (hbox6), label7,  TRUE, TRUE, 0);
	     optionmenu = gtk_option_menu_new();
	     gtk_box_pack_start (GTK_BOX (hbox6), optionmenu,  TRUE, TRUE, 0);
	     optionmenu_menu = gtk_menu_new();
	     gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), optionmenu_menu);

	     for (gslcsession = Sessions;
		  gslcsession != NULL;
		  gslcsession = gslcsession->next)
	     {
		  GString *sessionname;
		  sessionname = g_string_new(our_info->nick);
		  for (member_cc = ((ChatSession *)gslcsession->data)->members;
		       member_cc != NULL;
		       member_cc = member_cc->next)
		  {
		       g_string_sprintfa(sessionname, ", %s", ((ChatContact *)member_cc->data)->contact->nick);

		  }
		  menuitem = gtk_menu_item_new_with_label(sessionname->str);
		  g_string_free (sessionname, TRUE);
		  gtk_menu_append(GTK_MENU (optionmenu_menu), menuitem);
		  gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", gslcsession->data);
	     }

	     menuitem = gtk_menu_item_new_with_label("None");
	     gtk_object_set_data (GTK_OBJECT (menuitem), "ChatSession", NULL);
	     gtk_menu_prepend(GTK_MENU(optionmenu_menu), menuitem);
	     gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),0);
	     gtk_widget_show_all (hbox6);

	}


	dialog_action_area2 = GNOME_DIALOG (window)->action_area;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area2", dialog_action_area2);
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
	                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
	button6 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button6);
	gtk_object_set_data_full (GTK_OBJECT (window), "button6", button6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if (GTK_IS_HBOX(hbox6))
	     gtk_object_set_data (GTK_OBJECT (button6), "OptionMenu", optionmenu_menu);
	else
	     gtk_object_set_data (GTK_OBJECT (button6), "OptionMenu", NULL);

	gtk_widget_show (button6);

	GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
	button7 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (window), "button7", button7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button7);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( text2 ), "button", button6 );
	gtk_object_set_data( GTK_OBJECT( text2 ), "cancel", button7 );

	gtk_signal_connect_after (GTK_OBJECT (text2), "key_press_event",
	                    GTK_SIGNAL_FUNC (ctrl_enter_cb),
	                    NULL);

	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
	                    GTK_SIGNAL_FUNC (send_chat_request),
	                    text2);

	gtk_signal_connect_object (GTK_OBJECT (button6), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_signal_connect_object (GTK_OBJECT (button7), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_widget_grab_focus( text2 );
	gtk_widget_show_all( window );
}

void open_message_chat( GtkWidget *widget, gpointer data )
{
	GSList *contact;
	gchar *str;

	GtkWidget *window1;
	GtkWidget *vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *hbox1;
	GtkWidget *entry1;
	GtkWidget *combo_entry1;
	GtkWidget *hbox2;
	GtkWidget *button3;

#ifdef TRACE_FUNCTION
	g_print( "open_message_chat\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	str = g_strdup_printf( _("GnomeICU: %s"), kontakt->nick );

	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
	gtk_container_set_border_width (GTK_CONTAINER (window1), 5);
	gtk_window_set_title (GTK_WINDOW (window1), str );
	gtk_window_set_default_size (GTK_WINDOW (window1), 300, 225);

	g_free( str );

#ifdef GNOME_ICON
        set_window_icon( window1, "gnomeicu-chat.png" );
#endif

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (window1), vbox1);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text1 = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "text1", text1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text1);
	gtk_text_set_word_wrap( GTK_TEXT( text1 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

	str = g_strdup_printf( _("Message Chat with %s\n"), kontakt->nick );
	gtk_text_insert (GTK_TEXT (text1), NULL, NULL, NULL,
	                 str, -1);

	g_free( str );

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox1", hbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

	entry1 = gnome_entry_new (NULL);
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "entry1", entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry1);
	gtk_box_pack_start (GTK_BOX (hbox1), entry1, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS (entry1, GTK_CAN_FOCUS);
	GTK_WIDGET_SET_FLAGS (entry1, GTK_CAN_DEFAULT);

	combo_entry1 = gnome_entry_gtk_entry (GNOME_ENTRY (entry1));
	gtk_widget_ref (combo_entry1);
	gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry1", combo_entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (window1), "hbox2", hbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);

	button3 = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (window1), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button3);
	gtk_box_pack_end (GTK_BOX (hbox2), button3, FALSE, FALSE, 0);

	gtk_widget_grab_focus (combo_entry1);

	gtk_widget_show_all( window1 );

	kontakt->message_chat = window1;

	gtk_object_set_data( GTK_OBJECT( window1 ), "entry", combo_entry1 );
	gtk_object_set_data( GTK_OBJECT( window1 ), "contact", contact );
	gtk_object_set_data( GTK_OBJECT( window1 ), "text", text1 );

	gtk_signal_connect( GTK_OBJECT( combo_entry1 ), "activate",
	                    GTK_SIGNAL_FUNC( send_message_from_message_chat ),
	                    window1 );

	gtk_signal_connect( GTK_OBJECT( window1 ), "destroy",
	                    GTK_SIGNAL_FUNC( clear_pointer ),
	                    &kontakt->message_chat );

	gtk_signal_connect_object( GTK_OBJECT( button3 ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( window1 ) );
}

void request_file( GtkWidget *widget, GList *files )
{
	GSList *contact;

        GList *file;

	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label3;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *filelist;
	GtkWidget *label2;
	GtkWidget *scrolledwindow2;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *addbutton;
	GtkWidget *removebutton;

	gchar *str, *filenames[1];

#ifdef TRACE_FUNCTION
	g_print( "request_file\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	window = gnome_dialog_new (_("GnomeICU: Send File"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Send_File", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_default_size( GTK_WINDOW( window ), 350, 250 );
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

#ifdef GNOME_ICON
        set_window_icon( window, "gnomeicu-file.png" );
#endif

	dialog_vbox1 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Send File to %s:"), kontakt->nick );

	label3 = gtk_label_new ( str );
	g_free( str );
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (window), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (window), "hbox1", hbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);

	label1 = gtk_label_new (_("Files:"));
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (window), "label1", label1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label1), 7.45058e-09, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow2", scrolledwindow2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	filelist = gtk_clist_new(1);
	gtk_widget_ref (filelist);
	gtk_object_set_data_full (GTK_OBJECT (window), "filelist", filelist,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_clist_set_selection_mode(GTK_CLIST(filelist), GTK_SELECTION_EXTENDED);
        for ( file = files; file; file = file->next )
        {
            char *data = file->data;

            /* Since its a file, we can strip the protocol type */
            if (strncmp (data, "file:", 5) == 0)
                data += 5;

            filenames[0] = data;
            gtk_clist_append(GTK_CLIST(filelist), filenames);
        }
	gtk_widget_show (filelist);

	gtk_container_add (GTK_CONTAINER (scrolledwindow2), filelist);

	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

	addbutton = gtk_button_new_with_label("Add files...");
	gtk_widget_ref (addbutton);
	gtk_object_set_data_full (GTK_OBJECT (window), "addbutton", addbutton,
                                  (GtkDestroyNotify) gtk_widget_unref);

	gtk_widget_show (addbutton);
	gtk_box_pack_end (GTK_BOX (hbox1), addbutton, FALSE, FALSE, 3);

	removebutton = gtk_button_new_with_label("Remove files");
	gtk_widget_ref (removebutton);
	gtk_object_set_data_full (GTK_OBJECT (window), "remove", removebutton,
                                  (GtkDestroyNotify) gtk_widget_unref);

	gtk_widget_show (removebutton);
	gtk_box_pack_end (GTK_BOX (hbox1), removebutton, FALSE, FALSE, 3);

	label2 = gtk_label_new (_("Reason:"));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (window), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label2), 7.45058e-09, 0.5);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text1 = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text1);
	gtk_object_set_data_full (GTK_OBJECT (window), "text1", text1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text1);
	gtk_text_set_word_wrap( GTK_TEXT( text1 ), TRUE );
	gtk_text_set_editable( GTK_TEXT( text1 ), TRUE );
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

	dialog_action_area1 = GNOME_DIALOG (window)->action_area;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
	                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
	button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( button1 ), "reason", text1 );
	gtk_object_set_data( GTK_OBJECT( button1 ), "uin",
	                     GINT_TO_POINTER( kontakt->uin ) );
	gtk_object_set_data( GTK_OBJECT( button1 ), "filelist", filelist );

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
	button2 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button2);
	gtk_object_set_data_full (GTK_OBJECT (window), "button2", button2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( text1 ), "button", button1 );
	gtk_object_set_data( GTK_OBJECT( text1 ), "cancel", button2 );

	gtk_signal_connect_after( GTK_OBJECT( text1 ), "key_press_event",
	                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

        gtk_signal_connect (GTK_OBJECT (addbutton), "clicked",
                            GTK_SIGNAL_FUNC (add_files),
                            filelist );

        gtk_signal_connect (GTK_OBJECT (removebutton), "clicked",
                            GTK_SIGNAL_FUNC (remove_files),
                            filelist);

	gtk_signal_connect (GTK_OBJECT (button1), "clicked",
	                    GTK_SIGNAL_FUNC (send_file_request),
	                    NULL);

	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));
	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_widget_show_all( window );
}

void request_file_default( GtkWidget *widget, gpointer data )
{
	request_file( widget, NULL );
}

void send_url_window( GtkWidget *widget, char *defaulturl )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox2;
	GtkWidget *vbox12;
	GtkWidget *label20;
	GtkWidget *table4;
	GtkWidget *label21;
	GtkWidget *label22;
	GtkWidget *entry2;
	GtkWidget *combo_entry2;
	GtkWidget *entry3;
	GtkWidget *combo_entry3;
	GtkWidget *dialog_action_area2;
	GtkWidget *button4;
	GtkWidget *button6;

	gchar *wtitle;

	struct URLInfo *urlinfo;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "send_url_window\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	urlinfo = g_new0( struct URLInfo, 1 );
	urlinfo->contact = contact;

	wtitle = g_strdup_printf( _("Send URL to: %s"), kontakt->nick );

	window = gnome_dialog_new (_("GnomeICU: Send URL"), NULL);
	gtk_widget_set_name (window, "window");
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_default_size ( GTK_WINDOW( window ), 400, -2);
	GTK_WINDOW (window)->type = GTK_WINDOW_DIALOG;
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_window_set_default_size( GTK_WINDOW( window ), 500, 150 );
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
	gtk_window_set_wmclass (GTK_WINDOW (window), "SendURL", "GnomeICU");

#ifdef GNOME_ICON
	set_window_icon( window, "gnomeicu-url.png" );
#endif

	dialog_vbox2 = GNOME_DIALOG (window)->vbox;
	gtk_widget_set_name (dialog_vbox2, "dialog_vbox2");
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox2", dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	vbox12 = gtk_vbox_new (FALSE, 4);
	gtk_widget_set_name (vbox12, "vbox12");
	gtk_widget_ref (vbox12);
	gtk_object_set_data_full (GTK_OBJECT (window), "vbox12", vbox12,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox12);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox12, TRUE, TRUE, 0);

	label20 = gtk_label_new ( wtitle );
	g_free( wtitle );
	gtk_widget_set_name (label20, "label20");
	gtk_widget_ref (label20);
	gtk_object_set_data_full (GTK_OBJECT (window), "label20", label20,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label20);
	gtk_box_pack_start (GTK_BOX (vbox12), label20, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label20), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label20), 0, 0.5);

	table4 = gtk_table_new (2, 2, FALSE);
	gtk_widget_set_name (table4, "table4");
	gtk_widget_ref (table4);
	gtk_object_set_data_full (GTK_OBJECT (window), "table4", table4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table4);
	gtk_box_pack_start (GTK_BOX (vbox12), table4, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table4), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table4), 4);

	label21 = gtk_label_new (_("URL:"));
	gtk_widget_set_name (label21, "label21");
	gtk_widget_ref (label21);
	gtk_object_set_data_full (GTK_OBJECT (window), "label21", label21,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label21);
	gtk_table_attach (GTK_TABLE (table4), label21, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label21), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label21), 1, 0.5);

	label22 = gtk_label_new (_("Description:"));
	gtk_widget_set_name (label22, "label22");
	gtk_widget_ref (label22);
	gtk_object_set_data_full (GTK_OBJECT (window), "label22", label22,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label22);
	gtk_table_attach (GTK_TABLE (table4), label22, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label22), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label22), 1, 0.5);

	entry2 = gnome_entry_new ("gnomeicu_url");
	gtk_widget_set_name (entry2, "entry2");
	gtk_widget_ref (entry2);
	gtk_object_set_data_full (GTK_OBJECT (window), "entry2", entry2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry2);
	gtk_table_attach (GTK_TABLE (table4), entry2, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry2 = gnome_entry_gtk_entry (GNOME_ENTRY (entry2));
	gtk_widget_set_name (combo_entry2, "combo_entry2");
	gtk_widget_ref (combo_entry2);
	gtk_entry_set_text(GTK_ENTRY(combo_entry2), defaulturl);
	gtk_object_set_data_full (GTK_OBJECT (window), "combo_entry2", combo_entry2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry2);

	urlinfo->url = combo_entry2;

	entry3 = gnome_entry_new ("gnomeicu_history_desc");
	gtk_widget_set_name (entry3, "entry3");
	gtk_widget_ref (entry3);
	gtk_object_set_data_full (GTK_OBJECT (window), "entry3", entry3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (entry3);
	gtk_table_attach (GTK_TABLE (table4), entry3, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	combo_entry3 = gnome_entry_gtk_entry (GNOME_ENTRY (entry3));
	gtk_widget_set_name (combo_entry3, "combo_entry3");
	gtk_widget_ref (combo_entry3);
	gtk_object_set_data_full (GTK_OBJECT (window), "combo_entry3", combo_entry3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo_entry3);

	urlinfo->desc = combo_entry3;

	dialog_action_area2 = GNOME_DIALOG (window)->action_area;
	gtk_widget_set_name (dialog_action_area2, "dialog_action_area2");
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area2", dialog_action_area2);
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

	gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (window),
	                                        _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO);
	button4 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_set_name (button4, "button4");
	gtk_widget_ref (button4);
	gtk_object_set_data_full (GTK_OBJECT (window), "button4", button4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button4);
	GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

	gtk_signal_connect( GTK_OBJECT( button4 ), "clicked",
	                    GTK_SIGNAL_FUNC( icq_sendurl ), urlinfo );

	gtk_signal_connect_object( GTK_OBJECT( button4 ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( window ) );

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
	button6 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_set_name (button6, "button6");
	gtk_widget_ref (button6);
	gtk_object_set_data_full (GTK_OBJECT (window), "button6", button6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button6);
	GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

	gtk_signal_connect_object( GTK_OBJECT( button6 ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( window ) );

	gtk_object_set_data( GTK_OBJECT( combo_entry2 ), "button", button4 );
	gtk_object_set_data( GTK_OBJECT( combo_entry2 ), "cancel", button6 );

	gtk_object_set_data( GTK_OBJECT( combo_entry3 ), "button", button4 );
	gtk_object_set_data( GTK_OBJECT( combo_entry3 ), "cancel", button6 );

	gtk_signal_connect( GTK_OBJECT( combo_entry2 ), "key_press_event",
	                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

	gtk_signal_connect( GTK_OBJECT( combo_entry3 ), "key_press_event",
	                    GTK_SIGNAL_FUNC( ctrl_enter_cb ), NULL );

	/* This hopefully destroys urlinfo on window close */
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
	                           GTK_SIGNAL_FUNC( g_free ),
				   (gpointer) urlinfo );

	GTK_WIDGET_SET_FLAGS (combo_entry2, GTK_CAN_FOCUS);
	gtk_widget_grab_focus( combo_entry2 );

	gtk_widget_show_all( window );
}

void send_url_window_default( GtkWidget *widget, gpointer data )
{
	send_url_window( widget, "" );
}

void remove_user( GtkWidget *widget, gpointer data )
{
	GtkWidget *check = gtk_object_get_data( GTK_OBJECT( widget ), "delhist" );
	gchar *path;

	GSList *contact;

	gint method;

#ifdef TRACE_FUNCTION
	g_print( "remove_user\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	if( kontakt->inlist == FALSE )
		method = UPDATE_NOTLIST;
	else if( kontakt->status == STATUS_OFFLINE )
		method = UPDATE_OFFLINE;
	else
		method = UPDATE_ONLINE;

	if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( check ) ) )
	{
#ifdef HAVE_ICUDB
		path = g_strdup_printf( "rm -f /%s/.icq/history/%d.db", getenv( "HOME" ),
		                        kontakt->uin );
#else
		path = g_strdup_printf( "rm -f /%s/.icq/history/%d", getenv( "HOME" ),
		                        kontakt->uin );
#endif
		system( path );
		g_free( path );
	}

	if( kontakt->sok )
	{
		close( kontakt->sok );
		g_io_channel_close( kontakt->gioc );
		g_source_remove( kontakt->giocw );
	}

	if( kontakt->detached_window )
		gtk_widget_destroy( kontakt->detached_window );
	
/*	Contacts = g_slist_remove( Contacts, kontakt );*/

/*	Save_RC();*/

	applet_update( Current_Status, NULL );
	Show_Quick_Status_lower( method, contact );
}

void show_info_new( UIN_T uin )
{
	static int first = TRUE;

#ifdef TRACE_FUNCTION
	g_print( "show_info_new\n" );
#endif

	if( first )
	{
		memset( &New_Contact, 0x00, sizeof( New_Contact ) );
		New_Contact.info = g_new0( USER_INFO_STRUCT, 1 );
		first = FALSE;
	}

	New_Contact.info->window = found_list;
	if( found_list )
	{
		gchar *str[5];

		str[0] = g_strdup_printf( "%d\n", uin );
		str[1] = str[2] = str[3] = str[4] = "";

		gtk_clist_append( GTK_CLIST( New_Contact.info->window ), str );

		g_free (str[0]);
	}

	if( start_new_info )
	{
		info_req_99( uin );
/*		FIXME: this was duplicated
 *		info_req_99( uin ); */
/*		FIXME: why this is commented?
 *		dump_personal_info( uin );*/
		start_new_info = FALSE;
	}
}

void retrieve_away_message( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "retrieve_away_message\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	kontakt->show_again = TRUE;

	TCPRetrieveAwayMessage( contact, NULL );
}

void retrieve_version( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "retrieve_away_message\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	kontakt->show_again = TRUE;

	TCPRetrieveVersion( contact, NULL );
}

void icq_set_status_online( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_online\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_ONLINE;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Current_Status = STATUS_ONLINE | (toggles->webpresence*0x10000);
			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_ONLINE );
	}
	place_widgets ();
}

void icq_set_status_offline( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_offline\n" );
#endif

	contact = Contacts;

	if( Current_Status == STATUS_OFFLINE )
		return;

	Current_Status = STATUS_OFFLINE;
	Quit_ICQ();
	if( udp_gdk_input )
	{
		gdk_input_remove( udp_gdk_input );
		udp_gdk_input = 0;
	}

	while( contact != NULL )
	{
		kontakt->last_status = kontakt->status;
		kontakt->status = STATUS_OFFLINE;
		kontakt->have_tcp_connection = FALSE;
		if( kontakt->sok )
		{
			g_io_channel_close( kontakt->gioc );
			close( kontakt->sok );
			g_source_remove( kontakt->giocw );
			kontakt->gioc = 0;
			kontakt->sok = 0;
		}
		contact = contact->next;
	}

	Show_Quick_Status_lower( UPDATE_ONLINE | UPDATE_OFFLINE | UPDATE_NOTLIST, NULL );
	seq_num = 1;

	if( MainData->sok )
		close( MainData->sok );

	Connected = FALSE;
	enable_online_events = FALSE;

	ready_set();

	if( toggles->applet )
		applet_update( Current_Status, NULL );

	msg_queue_clear();
	place_widgets();
}

int icq_set_status_away( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_away\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_AWAY;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_AWAY | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_AWAY );
		change_away_window( NULL, NULL );
	}
	place_widgets();

	return FALSE;
}

void icq_set_status_na( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_na\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_NA;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_NA | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_NA );
		change_away_window( NULL, NULL );
	}
	place_widgets();
}

void icq_set_status_invisible( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_invisible\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_INVISIBLE;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_INVISIBLE | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_INVISIBLE );
	}
	place_widgets();
}

void icq_set_status_ffc( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_ffc\n" );
#endif

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_FREE_CHAT;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_FREE_CHAT | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_FREE_CHAT );
	}
	place_widgets();
}

void icq_set_status_occ( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_occ\n" );
#endif

	if( Current_Status == STATUS_OCCUPIED )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_OCCUPIED;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_OCCUPIED | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_OCCUPIED );
		change_away_window( NULL, NULL );
	}
	place_widgets();
}

void icq_set_status_dnd( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_set_status_dnd\n" );
#endif

	if( Current_Status == STATUS_DND )
		return;

	if( Current_Status == STATUS_OFFLINE )
	{
		create_tcp_line();
		preset_status = STATUS_DND;
		Done_Login = FALSE;
		MainData->sok = Connect_Remote( server, remote_port, STDERR );
		if( MainData->sok > 0 )
		{
			Current_Status = STATUS_DND | (toggles->webpresence*0x10000);
			udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );
			Connected = TRUE;

			Login( passwd, our_ip, our_port );
		}
	}
	else
	{
		icq_change_status( STATUS_DND );
		change_away_window( NULL, NULL );
	}
	place_widgets();
}

void display_url( GtkWidget *widget, char *url )
{
#ifdef TRACE_FUNCTION
	g_print( "display_url\n" );
#endif

	gnome_url_show( url );
}

void display_url_from_entry( GtkWidget *widget, GtkEntry *entry )
{
#ifdef TRACE_FUNCTION
	g_print( "display_url_from_entry\n" );
#endif
	display_url( NULL, gtk_entry_get_text( entry ) );
}

/* FIXME: this is never used. Please remove */
void add_from_search( GtkWidget *widget, gpointer data )
{
	UIN_T new_uin;
	int row;

#ifdef TRACE_FUNCTION
	g_print( "add_from_search\n" );
#endif

	row = GPOINTER_TO_INT( GTK_CLIST( found_list )->selection->data );
	new_uin = GPOINTER_TO_INT(
		gtk_clist_get_row_data( GTK_CLIST( found_list ), row ) );
	Add_User( new_uin, NULL, TRUE );
}

gint app_save_state_cb( GnomeClient *client, gint phase, GnomeRestartStyle save_style, gint shutdown, GnomeInteractStyle interact_style, gint fast, gpointer client_data )
{
	gchar *prefix= gnome_client_get_config_prefix (client);
	gchar *argv[]= { "rm", "-r", NULL, NULL };
	gchar *config_param = NULL;
	int i = 1;

#ifdef TRACE_FUNCTION
	g_print ("app_save_state_cb\n");
#endif

	/* Here is the real SM code. We set the argv to the parameters needed
	   to restart/discard the session that we've just saved and call
	   the gnome_session_set_*_command to tell the session manager it. */

	argv[2] = gnome_config_get_real_path (prefix);
	gnome_client_set_discard_command (client, 3, argv);

	/* Set commands to clone and restart this application.  Note that we
	   use the same values for both -- the session management code will
	   automatically add whatever magic option is required to set the
	   session id on startup.  */

	argv[0]= (gchar*) client_data;
	if ( toggles->applet == FALSE )
		argv[i++] = "-a";
	if ( strlen( configfilename ) )
	{
		config_param = g_strdup_printf ("--config=%s", configfilename);
		argv[i++] = config_param;
	}

	gnome_client_set_restart_command (client, i, argv);
	gnome_client_set_clone_command (client, 0, NULL);

	g_free(config_param);

	return TRUE;
}

int hide_ch_window( GtkWidget *widget, GdkEvent *event, GtkWidget *window )
{
#ifdef TRACE_FUNCTION
	g_print( "hide_ch_window\n" );
#endif
	gtk_widget_hide( window );
	return TRUE;
}

/* Callback for status menu positioning */
static void cb_menu_position (GtkMenu *menu, gint *x, gint *y, gpointer user_data)
{
	GtkWidget *widget, *button;
	gint screen_width, screen_height;

	GtkRequisition requisition;

	widget = GTK_WIDGET (menu);
	button = GTK_WIDGET (user_data);

	gtk_widget_size_request (widget, &requisition);

	gdk_window_get_origin (button->window, x, y);
	*y -= requisition.height;

	screen_width = gdk_screen_width ();
	screen_height = gdk_screen_height ();

	if (*x + requisition.width > screen_width) {
	  *x -= *x + requisition.width - screen_width;
	}
}

int popup_status_menu( GtkWidget *widget, gpointer data )
{
	GtkWidget *status_menu;
	GtkWidget *pm, *item_box, *item_label;
	GtkWidget *item;

#ifdef TRACE_FUNCTION
	g_print( "popup_status_menu\n" );
#endif

	status_menu = gtk_menu_new();

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_online_pixmap, icon_online_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Online") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_online ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_away_pixmap, icon_away_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Away") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_away ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_na_pixmap, icon_na_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Not Available") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_na ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_ffc_pixmap, icon_ffc_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Free for Chat") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_ffc ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_occ_pixmap, icon_occ_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Occupied") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_occ ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_dnd_pixmap, icon_dnd_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Do not Disturb") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_dnd ),
	                    NULL );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_inv_pixmap, icon_inv_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Invisible") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_invisible ),
	                    NULL );
	gtk_widget_show( item );

	item = gtk_menu_item_new();
	gtk_widget_set_sensitive( item, FALSE );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_widget_show( item );

	item_box = gtk_hbox_new( FALSE, 0 );
	pm = gtk_pixmap_new( icon_offline_pixmap, icon_offline_bitmap );
	gtk_box_pack_start( GTK_BOX( item_box ), pm, FALSE, FALSE, 0 );
	gtk_widget_show( pm );
	item = gtk_menu_item_new();
	item_label = gtk_label_new( _("  Offline") );
	gtk_box_pack_start( GTK_BOX( item_box ), item_label, FALSE, FALSE, 0 );
	gtk_widget_show( item_label );
	gtk_container_add( GTK_CONTAINER( item ), item_box );
	gtk_widget_show( item_box );
	gtk_menu_append( GTK_MENU( status_menu ), item );
	gtk_signal_connect( GTK_OBJECT( item ), "activate",
	                    GTK_SIGNAL_FUNC( icq_set_status_offline ),
	                    NULL );
	gtk_widget_show( item );

	gtk_widget_show( status_menu );

	gtk_menu_popup( GTK_MENU( status_menu ), NULL, NULL,
	                cb_menu_position, widget,
	                0, 0 );

	return TRUE;
}

gint ctrl_enter_cb( GtkWidget *widget, GdkEventKey *ev, int sock )
{
	switch( ev->keyval )
	{
		case GDK_Return:
			if( ev->state & GDK_CONTROL_MASK &&
			    gtk_object_get_data( GTK_OBJECT( widget ), "button" ) != NULL )
				gtk_signal_emit_by_name( GTK_OBJECT( gtk_object_get_data( GTK_OBJECT( widget ), "button" ) ), "clicked", MainData );
			break;
/* Commented out by jwise 10/17/2000 */
/*		case 'c':
			if( ev->state & GDK_CONTROL_MASK &&
			    gtk_object_get_data( GTK_OBJECT( widget ), "cancel" ) != NULL )
				gtk_signal_emit_by_name( GTK_OBJECT( gtk_object_get_data( GTK_OBJECT( widget ), "cancel" ) ), "clicked", MainData );
			break;*/
		case 'n':
			if( ev->state & GDK_CONTROL_MASK &&
			    gtk_object_get_data( GTK_OBJECT( widget ), "readnext" ) != NULL )
				gtk_signal_emit_by_name( GTK_OBJECT( gtk_object_get_data( GTK_OBJECT( widget ), "readnext" ) ), "clicked", MainData );
			break;

		/* All the text operations */
		case GDK_Left:
		case GDK_Right:
		case GDK_Up:
		case GDK_Down:
		case ' ':
			break;
		case GDK_Tab:
			if ( !(ev->state & GDK_SHIFT_MASK) )
				break;
		default:
			return FALSE;
	}

	return TRUE;
}


/*** Local functions ***/
void icq_allow_auth( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_allow_auth\n" );
#endif

	icq_sendauthmsg( GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "uin" ) ) );
}

void icq_accept_chat( GtkWidget *widget, GSList *contact )
{
     int sock = kontakt->sok;
     GtkWidget *menu;
     ChatSession *csession = NULL;
     ChatContact *ccontact;

#ifdef TRACE_FUNCTION
     g_print( "icq_accept_chat\n" );
#endif

     menu = gtk_object_get_data( GTK_OBJECT(widget), "OptionMenu");
     ccontact = gtk_object_get_data( GTK_OBJECT(widget), "ChatContact");
     if (GTK_IS_MENU (menu))
	  csession = gtk_object_get_data( GTK_OBJECT(gtk_menu_get_active(GTK_MENU(menu))), "ChatSession");


     if (csession)
	  ccontact->chatsession = csession;

     TCPAcceptChat( sock, ccontact);
}

void icq_refuse_chat( GtkWidget *widget, GSList *contact )
{

     ChatContact *ccontact = gtk_object_get_data( GTK_OBJECT(widget), "ChatContact");
     int sock = kontakt->sok;

#ifdef TRACE_FUNCTION
     g_print( "icq_refuse_chat\n" );
#endif

     TCPRefuseChat( sock, ccontact);
}

void icq_accept_file( GtkWidget *widget, struct xfer_struct *xfer )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_accept_file\n" );
#endif

	TCPAcceptFile( xfer );
}

void icq_refuse_file( GtkWidget *widget, struct xfer_struct *xfer )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_refuse_file\n" );
#endif

	TCPRefuseFile( xfer );
}

void icq_refresh_list( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "icq_refresh_list\n" );
#endif

	Show_Quick_Status();
}

void set_window_icon ( GtkWidget *window, gchar *name )
{
	gchar *path = make_file_path( name );
	gnome_window_icon_set_from_file( GTK_WINDOW(window), path );
	g_free( path );
}

void clear_i_window( GtkWidget *wigdet, gpointer data )
{
	UIN_T uin;

	GSList *contact;

	uin = GPOINTER_TO_INT( data );

	contact = Find_User( uin );

	if( contact != NULL )
		kontakt->info->window = NULL;

	if( New_Contact.uin == uin )
		New_Contact.info->window = NULL;

g_print ("Destroying window for %u: %d\n", kontakt->uin, kontakt->info->window);
}

void clear_pointer( GtkWidget *widget, gpointer *data )
{
	*data = NULL;
}

void toggle_force( GtkWidget *widget, CONTACT_PTR co )
{
	co->force_override = !co->force_override;
}

void grab_history( GtkWidget *widget, gpointer data )
{
	GSList *contact = gtk_object_get_data( GTK_OBJECT( gtk_menu_get_active( gtk_object_get_data( GTK_OBJECT( widget ), "menu" ) ) ), "contact" );
	display_mess_history( NULL, contact );
}

void get_contact_list( GtkWidget *widget, gpointer data )
{
	GtkWidget *dialog;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "request_chat\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	dialog = create_contact_list_window( kontakt );
	gtk_window_set_title(GTK_WINDOW( dialog ), _("GnomeICU: Send Contact List"));
	gtk_widget_show( dialog );
}

void build_mass_list(GSList *contact, GtkCList *uins_clist)
{
   	GSList *contact2 = Contacts;
	gint cx = 0;
   	gchar *titles[2];

#ifdef TRACE_FUNCTION
	g_print( "build_mass_list\n" );
#endif

   	gtk_clist_freeze(uins_clist);

	while( contact2 != NULL )
	{
		/*titles[0] = kontakt2->nick;
		 * This is set below */
		titles[0] = "";
		titles[1] = g_strdup_printf("%d", kontakt2->uin);

		/* FIXME: why separate from common list again, when we already
		 * have showlist.c::OfflineList and OnlineList? */
		if ( kontakt2->status == STATUS_OFFLINE )
		{
			gtk_clist_append( uins_clist, titles );
			if (contact == contact2) gtk_clist_select_row(uins_clist, cx, 1);
			gtk_clist_set_pixtext( uins_clist, cx, 0, kontakt2->nick, 3,
					       icon_offline_pixmap,
					       icon_offline_bitmap );
			gtk_clist_set_foreground( uins_clist, cx,
						  &color_offline );
		}
		else
		{
			gtk_clist_prepend( uins_clist, titles );
			if (contact == contact2) gtk_clist_select_row(uins_clist, 0, 1);

#define set_icon_and_color(pix,bit,color) \
	gtk_clist_set_pixtext( uins_clist, 0, 0, kontakt2->nick, 3, pix, bit );\
	gtk_clist_set_foreground(uins_clist, 0, color); 

			switch (kontakt2->status & 0xffff)
			{
			case STATUS_ONLINE:
				set_icon_and_color( icon_online_pixmap,
						    icon_online_bitmap,
						    &color_online );
				break;
			case STATUS_AWAY:
				set_icon_and_color( icon_away_pixmap,
						    icon_away_bitmap,
						    &color_away );
				break;
			case STATUS_NA:
				set_icon_and_color( icon_na_pixmap,
						    icon_na_bitmap,
						    &color_na );
				break;
			case STATUS_OCCUPIED:
				set_icon_and_color( icon_occ_pixmap,
						    icon_occ_bitmap,
						    &color_occ );
				break;
			case STATUS_DND:
				set_icon_and_color( icon_dnd_pixmap,
						    icon_dnd_bitmap,
						    &color_dnd );
				break;
			case STATUS_INVISIBLE:
				set_icon_and_color( icon_inv_pixmap,
						    icon_inv_bitmap,
						    &color_inv );
				break;
			case STATUS_FREE_CHAT:
				set_icon_and_color( icon_ffc_pixmap,
						    icon_ffc_bitmap,
						    &color_ffc );
				break;
			default:
				g_warning( "No such status: %d", kontakt2->status & 0xffff );
			}
		}

		g_free( titles[1] );

		contact2 = contact2->next;
		cx++;
	}
   	gtk_clist_thaw(uins_clist);
}

void remove_user_question( GtkWidget *widget, gpointer data )
{
	GtkWidget *rmcontact_dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label;
	GtkWidget *remhist_button;
	GtkWidget *dialog_action_area1;
	GtkWidget *yes_button;
	GtkWidget *no_button;

	GSList *contact;
	gchar *str;

#ifdef TRACE_FUNCTION
	g_print( "remove_user\n" );
#endif

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	rmcontact_dialog = gnome_dialog_new (_("GnomeICU: Remove Contact"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (rmcontact_dialog), "Remove_Contact", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (rmcontact_dialog), "rmcontact_dialog", rmcontact_dialog);
	gtk_window_set_modal (GTK_WINDOW (rmcontact_dialog), TRUE);
	gtk_window_set_policy (GTK_WINDOW (rmcontact_dialog), FALSE, FALSE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (rmcontact_dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (rmcontact_dialog), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (rmcontact_dialog), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	str = g_strdup_printf( _("Are you sure you wish to remove\n%s from your contact list?\n"),
	                       kontakt->nick );
	label = gtk_label_new ( str );
	g_free( str );
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (rmcontact_dialog), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (vbox1), label, FALSE, FALSE, 0);

	remhist_button = gtk_check_button_new_with_label (_("Remove User's History file"));
	gtk_widget_ref (remhist_button);
	gtk_object_set_data_full (GTK_OBJECT (rmcontact_dialog), "remhist_button", remhist_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (remhist_button);
	gtk_box_pack_start (GTK_BOX (vbox1), remhist_button, FALSE, FALSE, 0);

	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( remhist_button ), TRUE );

	dialog_action_area1 = GNOME_DIALOG (rmcontact_dialog)->action_area;
	gtk_object_set_data (GTK_OBJECT (rmcontact_dialog), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button (GNOME_DIALOG (rmcontact_dialog), GNOME_STOCK_BUTTON_YES);
	yes_button = g_list_last (GNOME_DIALOG (rmcontact_dialog)->buttons)->data;
	gtk_widget_ref (yes_button);
	gtk_object_set_data_full (GTK_OBJECT (rmcontact_dialog), "yes_button", yes_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yes_button);
	GTK_WIDGET_SET_FLAGS (yes_button, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (rmcontact_dialog), GNOME_STOCK_BUTTON_NO);
	no_button = g_list_last (GNOME_DIALOG (rmcontact_dialog)->buttons)->data;
	gtk_widget_ref (no_button);
	gtk_object_set_data_full (GTK_OBJECT (rmcontact_dialog), "no_button", no_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (no_button);
	GTK_WIDGET_SET_FLAGS (no_button, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( yes_button ), "delhist", remhist_button );

	gtk_signal_connect (GTK_OBJECT (yes_button), "clicked",
	                    GTK_SIGNAL_FUNC (remove_user),
	                    NULL);
	gtk_signal_connect_object( GTK_OBJECT (yes_button), "clicked",
	                    GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                    GTK_OBJECT( rmcontact_dialog ));
	gtk_signal_connect_object( GTK_OBJECT (no_button), "clicked",
	                    GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                    GTK_OBJECT( rmcontact_dialog ));

	gtk_widget_show_all( rmcontact_dialog );
}

void begin_search( GnomeDruidPage *page, GnomeDruid *druid )
{
	UIN_T uin;
	gchar *nick, *first, *last, *email;
	GtkEntry *entry;

#ifdef TRACE_FUNCTION
	g_print( "begin_search\n" );
#endif

	entry = gtk_object_get_data( GTK_OBJECT( page ), "search_uin" );
	uin = atoi( gtk_entry_get_text( entry ) );
	entry = gtk_object_get_data( GTK_OBJECT( page ), "search_nick" );
	nick = gtk_entry_get_text( entry );
	entry = gtk_object_get_data( GTK_OBJECT( page ), "search_first" );
	first = gtk_entry_get_text( entry );
	entry = gtk_object_get_data( GTK_OBJECT( page ), "search_last" );
	last = gtk_entry_get_text( entry );
	entry = gtk_object_get_data( GTK_OBJECT( page ), "search_email" );
	email = gtk_entry_get_text( entry );

	if( uin > 0 )
		gnome_druid_set_buttons_sensitive( druid, TRUE, TRUE, TRUE );

	found_list = GTK_WIDGET( gtk_object_get_data( GTK_OBJECT( page ), "found_list" ) );
	gtk_clist_clear( GTK_CLIST( found_list ) );

	start_search( email, nick, first, last, uin );
}

void reply_button_cb( GtkWidget *widget, gpointer data )
{
	GtkWidget *box = GTK_WIDGET( gtk_object_get_data( GTK_OBJECT( widget ), "box" ) );
	GtkWidget *hbox = GTK_WIDGET( gtk_object_get_data( GTK_OBJECT( widget ), "hbox" ) );
	GtkWidget *text = GTK_WIDGET( gtk_object_get_data( GTK_OBJECT( widget ), "text" ) );
	GtkWidget *reply = GTK_WIDGET( gtk_object_get_data( GTK_OBJECT( widget ), "reply" ) );

	gtk_widget_show( reply );
	gtk_widget_hide_all( hbox );
	gtk_widget_show( box );
	gtk_widget_grab_focus( text );
}

gchar *stripr( gchar *str )
{
	gchar *new;
	gint cx = 0, cy = 0;

	new = (gchar*)g_malloc0( strlen( str ) + 1 );

	while( str[cx] )
	{
		if( str[cx] != '\r' )
			new[cy++] = str[cx];
		cx++;
	}

	return new;
}

gint compare_dates(const gint *a,
		   const gint *b)
{
	return( *a - *b );
}

void send_message_from_message_chat( GtkWidget *entry, GtkWidget *window )
{
	GtkWidget *text;
	GSList *contact;
	gchar *str;
	GdkColor head_color;
	gchar *header;

	text = gtk_object_get_data( GTK_OBJECT( window ), "text" );
	contact = gtk_object_get_data( GTK_OBJECT( window ), "contact" );

	str = gtk_entry_get_text( GTK_ENTRY( entry ) );
	if( strlen( str ) )
	{
		header = g_strdup_printf( "%s:  ", our_info->nick );
		icq_sendmsg( kontakt->uin, str, FALSE );
		head_color.pixel = 0;
		head_color.red = 0;
		head_color.green = 0;
		head_color.blue = 65535;
		gtk_text_insert( GTK_TEXT( text ), NULL, &head_color, NULL,
		                 header, -1 );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, str, -1 );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, "\n", 1 );
		g_free( header );
	}

	gtk_entry_set_text( GTK_ENTRY( entry ), "" );
}

void request_file_action ( GSList *completed_files )
{
    GtkWidget *dialog, *dialog_vbox, *main_vbox, *label;
    GtkWidget *label_name, *hseparator, *button_file, *button_del; /* , *button_dir; */
    GtkWidget *hbox, *dialog_action_area;
    gchar *full_filename = NULL;

    GSList *file;

    dialog = gnome_dialog_new( _("Files recieved successfully"), NULL );
    gtk_window_set_policy( GTK_WINDOW( dialog ), FALSE, FALSE, TRUE );
    gnome_dialog_set_close( GNOME_DIALOG( dialog), TRUE );

    dialog_vbox = GNOME_DIALOG( dialog )->vbox;

    main_vbox = gtk_vbox_new( FALSE, 0 );
    gtk_box_pack_start ( GTK_BOX( dialog_vbox ), main_vbox, TRUE, TRUE, 0 );

    label = gtk_label_new( _("The following files have been successfully retrieved.") );
    gtk_box_pack_start( GTK_BOX( main_vbox ), label, FALSE, TRUE, 0 );
    gtk_label_set_line_wrap( GTK_LABEL( label ), TRUE );

    hseparator = gtk_hseparator_new();
    gtk_box_pack_start( GTK_BOX( main_vbox ), hseparator, FALSE, TRUE, 0 );

    for ( file = completed_files; file; file = file->next )
    {
        hbox = gtk_hbox_new( FALSE, 3 );
        gtk_box_pack_start( GTK_BOX( main_vbox ), hbox, TRUE, TRUE, 0 );
        gtk_container_set_border_width( GTK_CONTAINER( hbox ), 3 );

        label_name = gtk_label_new( ((struct file_struct*)file->data)->short_filename );

        gtk_box_pack_start( GTK_BOX( hbox ), label_name, TRUE, TRUE, 0 );
        gtk_misc_set_alignment( GTK_MISC( label_name ), 0, 0.5 );

        full_filename = g_strdup( ((struct file_struct*)file->data)->full_filename );
        button_file = gtk_button_new_with_label( _("Open File") );
        gtk_box_pack_start( GTK_BOX( hbox ), button_file, FALSE, FALSE, 0 );
        gtk_object_set_data( GTK_OBJECT( button_file ), "filename", full_filename );

	button_del = gtk_button_new_with_label( _("Delete") );
	gtk_box_pack_start( GTK_BOX( hbox ), button_del, FALSE, FALSE, 0 );
	gtk_object_set_data( GTK_OBJECT( button_del ), "filename", full_filename );
	gtk_object_set_data( GTK_OBJECT( button_del ), "hbox", hbox );
	gtk_object_set_data( GTK_OBJECT( button_del ), "button_file", button_file );



        /*        button_dir = gtk_button_new_with_label( _("Open Dir") );
        gtk_box_pack_start( GTK_BOX( hbox ), button_dir, FALSE, FALSE, 0 );
        gtk_object_set_data( GTK_OBJECT( button_file ), "filename", full_filename ); */

        gtk_signal_connect( GTK_OBJECT( button_file ), "clicked",
                            GTK_SIGNAL_FUNC( open_file ),
                            NULL );

        gtk_signal_connect( GTK_OBJECT( button_del ), "clicked",
                            GTK_SIGNAL_FUNC( del_file ),
                            NULL );

        /*        gtk_signal_connect( GTK_OBJECT( button_dir ), "clicked",
                            GTK_SIGNAL_FUNC( open_dir ),
                            NULL ); */

    }

    dialog_action_area = GNOME_DIALOG( dialog )->action_area;
    gtk_button_box_set_layout( GTK_BUTTON_BOX( dialog_action_area ), GTK_BUTTONBOX_END );
    gtk_button_box_set_spacing( GTK_BUTTON_BOX( dialog_action_area ), 8 );

    gnome_dialog_append_button( GNOME_DIALOG( dialog ), GNOME_STOCK_BUTTON_CLOSE );

    gtk_widget_show_all( dialog );
}

static void open_file( GtkWidget *widget, gpointer data )
{
    const gchar *filename = NULL, *mime_tpe = NULL;
    gchar *prgm, *prgm_orig, *cmd = NULL, *argv[4];
    int loc;

    filename = gtk_object_get_data( GTK_OBJECT( widget ), "filename" );
    mime_tpe = gnome_mime_type_of_file( filename );
    prgm = g_strdup( gnome_mime_program( mime_tpe ) );
    prgm_orig = prgm;

    if (prgm)
    {
        loc = (int)strstr(prgm, "%f") - (int)prgm;
        cmd = g_strdup_printf("%s\"%s\"", g_strndup(prgm, loc), filename);
        prgm += loc + 2;
        cmd = g_strdup_printf("%s%s", cmd, prgm);

        argv[0] = "/bin/sh";
        argv[1] = "-c";
        argv[2] = cmd;
        argv[3] = NULL;

        gnome_execute_async( NULL, 4, argv );
        g_free( prgm_orig );
        g_free( cmd );
    }
}

static void del_file( GtkWidget *widget, gpointer data )
{
     const gchar *filename = NULL;
     GtkWidget *hbox, *button_file, *label;

     filename = gtk_object_get_data( GTK_OBJECT( widget ), "filename" );
     hbox = gtk_object_get_data( GTK_OBJECT( widget ), "hbox" );
     button_file = gtk_object_get_data( GTK_OBJECT( widget ), "button_file" );

     if (unlink(filename) == 0) {

	  gtk_widget_hide(hbox);

	  gtk_widget_destroy(widget);
	  gtk_widget_destroy(button_file);

	  label = gtk_label_new(_("DELETED"));

	  gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );

	  gtk_widget_show_all(hbox);

     }

}

/* static void open_dir( GtkWidget *widget, gpointer data )
{
    g_print("Should open the dir...\n");
} */

static void add_files( GtkWidget *widget, gpointer data)
{
   /* Create the selector */
	file_selector = create_filebrowser(add_files_final, data);

	/* Display that dialog */
	gtk_widget_show (file_selector);
}

static void remove_files( GtkWidget *widget, gpointer data)
{
	GList *selected;

	while ((selected = GTK_CLIST(data)->selection))
		gtk_clist_remove(GTK_CLIST(data), GPOINTER_TO_INT(selected->data) );
}

static void add_files_final( gchar *add_text, gpointer user_data )
{
	gchar *text[1];

	text[0] = add_text;

	gtk_clist_append(GTK_CLIST(user_data), text);
}
