/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Copyright (C) 2004 Vincent Noel <vnoel@cox.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GDICT_WEB_SEARCH_H
#define GDICT_WEB_SEARCH_H

#include <glib.h>
#include <gdict-app.h>

typedef struct {
	gchar *name;
	gchar *url;
	gboolean enabled;
} GDictWebSearchSite;

GDictWebSearchSite *gdict_web_search_new (gchar *name, gchar *url, gboolean enabled);
void gdict_web_search_remove (GDictWindow *gdict, GDictWebSearchSite *site);
void gdict_web_search_remove_all (GDictWindow *gdict);
GSList *gdict_web_search_default_sites (void);

#endif /* GDICT_WEB_SEARCH_H */
