/* $Id: gdict-about.c,v 1.9 2002/04/29 01:06:10 gman Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict About box
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>

#include "gdict-about.h"


static GtkWidget *gdict_about_new (void)
{
    GdkPixbuf   *pixbuf;
    GError  	*error = NULL;
    gchar 	*file;
    
    const gchar *authors[] = {
        "Mike Hughes <mfh@psilord.com>",
        "Spiros Papadimitriou <spapadim+@cs.cmu.edu>",
        "Bradford Hovinen <hovinen@udel.edu>",
        NULL
    };
    gchar *documenters[] = {
	    NULL
    };
    /* Translator credits */
    gchar *translator_credits = _("translator_credits");
    GtkWidget *about;
    
    file = gnome_program_locate_file (NULL, GNOME_FILE_DOMAIN_PIXMAP, "gdict.png", FALSE, NULL);
    pixbuf = gdk_pixbuf_new_from_file (file, &error);
    
    if (error) {
    	   g_warning (G_STRLOC ": cannot open %s: %s", file, error->message);
	   g_error_free (error);	
    }
    
    g_free (file);    
    
    about = gnome_about_new ("GNOME Dictionary", VERSION,
                             "Copyright 1999 by Mike Hughes",
                             _("Client for MIT dictionary server.\n"
			    "Web: http://gdict.dhs.org/, "
			    "http://www.psilord.com/code/"),
			     (const char **)authors,
			     (const char **)documenters,
			     strcmp (translator_credits, "translator_credits") != 0 ? translator_credits : NULL,
                             pixbuf);
    if (pixbuf) {
    	   gdk_pixbuf_unref (pixbuf);
    }

    gtk_window_set_wmclass (GTK_WINDOW (about), "gdict", "GNOME Dictionary");
    gnome_window_icon_set_from_file (GTK_WINDOW (about), GNOME_ICONDIR"/gdict.png");				     
			     
    return about;
}

void gdict_about (void)
{
    GtkWidget *about = gdict_about_new();

    gtk_widget_show(about);
}

