// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Align;
use crate::Buildable;
use crate::ConstraintTarget;
use crate::Editable;
use crate::EntryBuffer;
use crate::InputHints;
use crate::InputPurpose;
use crate::LayoutManager;
use crate::Overflow;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkText")]
    pub struct Text(Object<ffi::GtkText>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, Editable;

    match fn {
        type_ => || ffi::gtk_text_get_type(),
    }
}

impl Text {
    #[doc(alias = "gtk_text_new")]
    pub fn new() -> Text {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_text_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_text_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<EntryBuffer>) -> Text {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_text_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Text`] objects.
    ///
    /// This method returns an instance of [`TextBuilder`](crate::builders::TextBuilder) which can be used to create [`Text`] objects.
    pub fn builder() -> TextBuilder {
        TextBuilder::default()
    }

    #[cfg(any(feature = "v4_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
    #[doc(alias = "gtk_text_compute_cursor_extents")]
    pub fn compute_cursor_extents(&self, position: usize) -> (graphene::Rect, graphene::Rect) {
        unsafe {
            let mut strong = graphene::Rect::uninitialized();
            let mut weak = graphene::Rect::uninitialized();
            ffi::gtk_text_compute_cursor_extents(
                self.to_glib_none().0,
                position,
                strong.to_glib_none_mut().0,
                weak.to_glib_none_mut().0,
            );
            (strong, weak)
        }
    }

    #[doc(alias = "gtk_text_get_activates_default")]
    #[doc(alias = "get_activates_default")]
    pub fn activates_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_activates_default(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_attributes")]
    #[doc(alias = "get_attributes")]
    pub fn attributes(&self) -> Option<pango::AttrList> {
        unsafe { from_glib_none(ffi::gtk_text_get_attributes(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> EntryBuffer {
        unsafe { from_glib_none(ffi::gtk_text_get_buffer(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_enable_emoji_completion")]
    #[doc(alias = "get_enable_emoji_completion")]
    pub fn enables_emoji_completion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_get_enable_emoji_completion(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_get_extra_menu")]
    #[doc(alias = "get_extra_menu")]
    pub fn extra_menu(&self) -> Option<gio::MenuModel> {
        unsafe { from_glib_none(ffi::gtk_text_get_extra_menu(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    pub fn input_hints(&self) -> InputHints {
        unsafe { from_glib(ffi::gtk_text_get_input_hints(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    pub fn input_purpose(&self) -> InputPurpose {
        unsafe { from_glib(ffi::gtk_text_get_input_purpose(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_invisible_char")]
    #[doc(alias = "get_invisible_char")]
    pub fn invisible_char(&self) -> char {
        unsafe {
            std::convert::TryFrom::try_from(ffi::gtk_text_get_invisible_char(self.to_glib_none().0))
                .expect("conversion from an invalid Unicode value attempted")
        }
    }

    #[doc(alias = "gtk_text_get_max_length")]
    #[doc(alias = "get_max_length")]
    pub fn max_length(&self) -> i32 {
        unsafe { ffi::gtk_text_get_max_length(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_get_overwrite_mode")]
    #[doc(alias = "get_overwrite_mode")]
    pub fn is_overwrite_mode(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_overwrite_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_placeholder_text")]
    #[doc(alias = "get_placeholder_text")]
    pub fn placeholder_text(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_text_get_placeholder_text(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_propagate_text_width")]
    #[doc(alias = "get_propagate_text_width")]
    pub fn propagates_text_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_get_propagate_text_width(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_get_tabs")]
    #[doc(alias = "get_tabs")]
    pub fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(ffi::gtk_text_get_tabs(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_text_length")]
    #[doc(alias = "get_text_length")]
    pub fn text_length(&self) -> u16 {
        unsafe { ffi::gtk_text_get_text_length(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_text_get_truncate_multiline")]
    #[doc(alias = "get_truncate_multiline")]
    pub fn must_truncate_multiline(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_truncate_multiline(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_get_visibility")]
    #[doc(alias = "get_visibility")]
    pub fn is_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_text_get_visibility(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_text_grab_focus_without_selecting")]
    pub fn grab_focus_without_selecting(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_grab_focus_without_selecting(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_text_set_activates_default")]
    pub fn set_activates_default(&self, activates: bool) {
        unsafe {
            ffi::gtk_text_set_activates_default(self.to_glib_none().0, activates.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_attributes")]
    pub fn set_attributes(&self, attrs: Option<&pango::AttrList>) {
        unsafe {
            ffi::gtk_text_set_attributes(self.to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_buffer")]
    pub fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>) {
        unsafe {
            ffi::gtk_text_set_buffer(self.to_glib_none().0, buffer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_enable_emoji_completion")]
    pub fn set_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        unsafe {
            ffi::gtk_text_set_enable_emoji_completion(
                self.to_glib_none().0,
                enable_emoji_completion.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_extra_menu")]
    pub fn set_extra_menu(&self, model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::gtk_text_set_extra_menu(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_text_set_input_hints")]
    pub fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_text_set_input_hints(self.to_glib_none().0, hints.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_input_purpose")]
    pub fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_text_set_input_purpose(self.to_glib_none().0, purpose.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_invisible_char")]
    pub fn set_invisible_char(&self, ch: char) {
        unsafe {
            ffi::gtk_text_set_invisible_char(self.to_glib_none().0, ch.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_max_length")]
    pub fn set_max_length(&self, length: i32) {
        unsafe {
            ffi::gtk_text_set_max_length(self.to_glib_none().0, length);
        }
    }

    #[doc(alias = "gtk_text_set_overwrite_mode")]
    pub fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_text_set_overwrite_mode(self.to_glib_none().0, overwrite.into_glib());
        }
    }

    #[doc(alias = "gtk_text_set_placeholder_text")]
    pub fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_text_set_placeholder_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_text_set_propagate_text_width")]
    pub fn set_propagate_text_width(&self, propagate_text_width: bool) {
        unsafe {
            ffi::gtk_text_set_propagate_text_width(
                self.to_glib_none().0,
                propagate_text_width.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_tabs")]
    pub fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            ffi::gtk_text_set_tabs(self.to_glib_none().0, mut_override(tabs.to_glib_none().0));
        }
    }

    #[doc(alias = "gtk_text_set_truncate_multiline")]
    pub fn set_truncate_multiline(&self, truncate_multiline: bool) {
        unsafe {
            ffi::gtk_text_set_truncate_multiline(
                self.to_glib_none().0,
                truncate_multiline.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_text_set_visibility")]
    pub fn set_visibility(&self, visible: bool) {
        unsafe {
            ffi::gtk_text_set_visibility(self.to_glib_none().0, visible.into_glib());
        }
    }

    #[doc(alias = "gtk_text_unset_invisible_char")]
    pub fn unset_invisible_char(&self) {
        unsafe {
            ffi::gtk_text_unset_invisible_char(self.to_glib_none().0);
        }
    }

    #[doc(alias = "im-module")]
    pub fn im_module(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "im-module")
    }

    #[doc(alias = "im-module")]
    pub fn set_im_module(&self, im_module: Option<&str>) {
        glib::ObjectExt::set_property(self, "im-module", &im_module)
    }

    #[doc(alias = "invisible-char-set")]
    pub fn is_invisible_char_set(&self) -> bool {
        glib::ObjectExt::property(self, "invisible-char-set")
    }

    #[doc(alias = "scroll-offset")]
    pub fn scroll_offset(&self) -> i32 {
        glib::ObjectExt::property(self, "scroll-offset")
    }

    #[doc(alias = "activates-default")]
    pub fn connect_activates_default_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activates-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activates_default_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attributes")]
    pub fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer")]
    pub fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-emoji-completion")]
    pub fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-emoji-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_emoji_completion_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "extra-menu")]
    pub fn connect_extra_menu_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_menu_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_extra_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "im-module")]
    pub fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-hints")]
    pub fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-purpose")]
    pub fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char")]
    pub fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char-set")]
    pub fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_set_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-length")]
    pub fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_length_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overwrite-mode")]
    pub fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overwrite_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "placeholder-text")]
    pub fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "propagate-text-width")]
    pub fn connect_propagate_text_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_text_width_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-text-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_text_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scroll-offset")]
    pub fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_offset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs")]
    pub fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "truncate-multiline")]
    pub fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::truncate-multiline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_truncate_multiline_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visibility")]
    pub fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<F: Fn(&Text) + 'static>(
            this: *mut ffi::GtkText,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visibility\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visibility_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Text {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Text`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextBuilder {
    activates_default: Option<bool>,
    attributes: Option<pango::AttrList>,
    buffer: Option<EntryBuffer>,
    enable_emoji_completion: Option<bool>,
    extra_menu: Option<gio::MenuModel>,
    im_module: Option<String>,
    input_hints: Option<InputHints>,
    input_purpose: Option<InputPurpose>,
    invisible_char: Option<u32>,
    invisible_char_set: Option<bool>,
    max_length: Option<i32>,
    overwrite_mode: Option<bool>,
    placeholder_text: Option<String>,
    propagate_text_width: Option<bool>,
    tabs: Option<pango::TabArray>,
    truncate_multiline: Option<bool>,
    visibility: Option<bool>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
    editable: Option<bool>,
    enable_undo: Option<bool>,
    max_width_chars: Option<i32>,
    text: Option<String>,
    width_chars: Option<i32>,
    xalign: Option<f32>,
}

impl TextBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TextBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Text`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Text {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activates_default) = self.activates_default {
            properties.push(("activates-default", activates_default));
        }
        if let Some(ref attributes) = self.attributes {
            properties.push(("attributes", attributes));
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref enable_emoji_completion) = self.enable_emoji_completion {
            properties.push(("enable-emoji-completion", enable_emoji_completion));
        }
        if let Some(ref extra_menu) = self.extra_menu {
            properties.push(("extra-menu", extra_menu));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref invisible_char) = self.invisible_char {
            properties.push(("invisible-char", invisible_char));
        }
        if let Some(ref invisible_char_set) = self.invisible_char_set {
            properties.push(("invisible-char-set", invisible_char_set));
        }
        if let Some(ref max_length) = self.max_length {
            properties.push(("max-length", max_length));
        }
        if let Some(ref overwrite_mode) = self.overwrite_mode {
            properties.push(("overwrite-mode", overwrite_mode));
        }
        if let Some(ref placeholder_text) = self.placeholder_text {
            properties.push(("placeholder-text", placeholder_text));
        }
        if let Some(ref propagate_text_width) = self.propagate_text_width {
            properties.push(("propagate-text-width", propagate_text_width));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref truncate_multiline) = self.truncate_multiline {
            properties.push(("truncate-multiline", truncate_multiline));
        }
        if let Some(ref visibility) = self.visibility {
            properties.push(("visibility", visibility));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref enable_undo) = self.enable_undo {
            properties.push(("enable-undo", enable_undo));
        }
        if let Some(ref max_width_chars) = self.max_width_chars {
            properties.push(("max-width-chars", max_width_chars));
        }
        if let Some(ref text) = self.text {
            properties.push(("text", text));
        }
        if let Some(ref width_chars) = self.width_chars {
            properties.push(("width-chars", width_chars));
        }
        if let Some(ref xalign) = self.xalign {
            properties.push(("xalign", xalign));
        }
        glib::Object::new::<Text>(&properties).expect("Failed to create an instance of Text")
    }

    pub fn activates_default(mut self, activates_default: bool) -> Self {
        self.activates_default = Some(activates_default);
        self
    }

    pub fn attributes(mut self, attributes: &pango::AttrList) -> Self {
        self.attributes = Some(attributes.clone());
        self
    }

    pub fn buffer(mut self, buffer: &impl IsA<EntryBuffer>) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }

    pub fn enable_emoji_completion(mut self, enable_emoji_completion: bool) -> Self {
        self.enable_emoji_completion = Some(enable_emoji_completion);
        self
    }

    pub fn extra_menu(mut self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        self.extra_menu = Some(extra_menu.clone().upcast());
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn input_hints(mut self, input_hints: InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn invisible_char(mut self, invisible_char: u32) -> Self {
        self.invisible_char = Some(invisible_char);
        self
    }

    pub fn invisible_char_set(mut self, invisible_char_set: bool) -> Self {
        self.invisible_char_set = Some(invisible_char_set);
        self
    }

    pub fn max_length(mut self, max_length: i32) -> Self {
        self.max_length = Some(max_length);
        self
    }

    pub fn overwrite_mode(mut self, overwrite_mode: bool) -> Self {
        self.overwrite_mode = Some(overwrite_mode);
        self
    }

    pub fn placeholder_text(mut self, placeholder_text: &str) -> Self {
        self.placeholder_text = Some(placeholder_text.to_string());
        self
    }

    pub fn propagate_text_width(mut self, propagate_text_width: bool) -> Self {
        self.propagate_text_width = Some(propagate_text_width);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn truncate_multiline(mut self, truncate_multiline: bool) -> Self {
        self.truncate_multiline = Some(truncate_multiline);
        self
    }

    pub fn visibility(mut self, visibility: bool) -> Self {
        self.visibility = Some(visibility);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn enable_undo(mut self, enable_undo: bool) -> Self {
        self.enable_undo = Some(enable_undo);
        self
    }

    pub fn max_width_chars(mut self, max_width_chars: i32) -> Self {
        self.max_width_chars = Some(max_width_chars);
        self
    }

    pub fn text(mut self, text: &str) -> Self {
        self.text = Some(text.to_string());
        self
    }

    pub fn width_chars(mut self, width_chars: i32) -> Self {
        self.width_chars = Some(width_chars);
        self
    }

    pub fn xalign(mut self, xalign: f32) -> Self {
        self.xalign = Some(xalign);
        self
    }
}

impl fmt::Display for Text {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Text")
    }
}
