// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::NavigationDirection;
use crate::Swipeable;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdySwipeTracker")]
    pub struct SwipeTracker(Object<ffi::HdySwipeTracker, ffi::HdySwipeTrackerClass>) @implements gtk::Orientable;

    match fn {
        type_ => || ffi::hdy_swipe_tracker_get_type(),
    }
}

impl SwipeTracker {
    #[doc(alias = "hdy_swipe_tracker_new")]
    pub fn new(swipeable: &impl IsA<Swipeable>) -> SwipeTracker {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::hdy_swipe_tracker_new(
                swipeable.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SwipeTracker`] objects.
    ///
    /// This method returns an instance of [`SwipeTrackerBuilder`](crate::builders::SwipeTrackerBuilder) which can be used to create [`SwipeTracker`] objects.
    pub fn builder() -> SwipeTrackerBuilder {
        SwipeTrackerBuilder::default()
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_swipe_tracker_get_allow_long_swipes")]
    #[doc(alias = "get_allow_long_swipes")]
    pub fn allows_long_swipes(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_swipe_tracker_get_allow_long_swipes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_swipe_tracker_get_allow_mouse_drag")]
    #[doc(alias = "get_allow_mouse_drag")]
    pub fn allows_mouse_drag(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_swipe_tracker_get_allow_mouse_drag(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_swipe_tracker_get_enabled")]
    #[doc(alias = "get_enabled")]
    pub fn is_enabled(&self) -> bool {
        unsafe { from_glib(ffi::hdy_swipe_tracker_get_enabled(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_swipe_tracker_get_reversed")]
    #[doc(alias = "get_reversed")]
    pub fn is_reversed(&self) -> bool {
        unsafe { from_glib(ffi::hdy_swipe_tracker_get_reversed(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_swipe_tracker_get_swipeable")]
    #[doc(alias = "get_swipeable")]
    pub fn swipeable(&self) -> Option<Swipeable> {
        unsafe { from_glib_none(ffi::hdy_swipe_tracker_get_swipeable(self.to_glib_none().0)) }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_swipe_tracker_set_allow_long_swipes")]
    pub fn set_allow_long_swipes(&self, allow_long_swipes: bool) {
        unsafe {
            ffi::hdy_swipe_tracker_set_allow_long_swipes(
                self.to_glib_none().0,
                allow_long_swipes.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_swipe_tracker_set_allow_mouse_drag")]
    pub fn set_allow_mouse_drag(&self, allow_mouse_drag: bool) {
        unsafe {
            ffi::hdy_swipe_tracker_set_allow_mouse_drag(
                self.to_glib_none().0,
                allow_mouse_drag.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_swipe_tracker_set_enabled")]
    pub fn set_enabled(&self, enabled: bool) {
        unsafe {
            ffi::hdy_swipe_tracker_set_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "hdy_swipe_tracker_set_reversed")]
    pub fn set_reversed(&self, reversed: bool) {
        unsafe {
            ffi::hdy_swipe_tracker_set_reversed(self.to_glib_none().0, reversed.into_glib());
        }
    }

    #[doc(alias = "hdy_swipe_tracker_shift_position")]
    pub fn shift_position(&self, delta: f64) {
        unsafe {
            ffi::hdy_swipe_tracker_shift_position(self.to_glib_none().0, delta);
        }
    }

    #[doc(alias = "begin-swipe")]
    pub fn connect_begin_swipe<F: Fn(&Self, NavigationDirection, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn begin_swipe_trampoline<
            F: Fn(&SwipeTracker, NavigationDirection, bool) + 'static,
        >(
            this: *mut ffi::HdySwipeTracker,
            direction: ffi::HdyNavigationDirection,
            direct: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(direction),
                from_glib(direct),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"begin-swipe\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    begin_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-swipe")]
    pub fn connect_end_swipe<F: Fn(&Self, i64, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_swipe_trampoline<F: Fn(&SwipeTracker, i64, f64) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            duration: i64,
            to: libc::c_double,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), duration, to)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"end-swipe\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    end_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "update-swipe")]
    pub fn connect_update_swipe<F: Fn(&Self, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn update_swipe_trampoline<F: Fn(&SwipeTracker, f64) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            progress: libc::c_double,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), progress)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"update-swipe\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    update_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "allow-long-swipes")]
    pub fn connect_allow_long_swipes_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_long_swipes_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-long-swipes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_long_swipes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-mouse-drag")]
    pub fn connect_allow_mouse_drag_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_mouse_drag_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-mouse-drag\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_mouse_drag_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enabled")]
    pub fn connect_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enabled_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enabled\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enabled_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reversed")]
    pub fn connect_reversed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reversed_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::HdySwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reversed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reversed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SwipeTracker {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct SwipeTracker object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SwipeTracker`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SwipeTrackerBuilder {
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    allow_long_swipes: Option<bool>,
    allow_mouse_drag: Option<bool>,
    enabled: Option<bool>,
    reversed: Option<bool>,
    swipeable: Option<Swipeable>,
    orientation: Option<gtk::Orientation>,
}

impl SwipeTrackerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SwipeTrackerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SwipeTracker`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SwipeTracker {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref allow_long_swipes) = self.allow_long_swipes {
            properties.push(("allow-long-swipes", allow_long_swipes));
        }
        if let Some(ref allow_mouse_drag) = self.allow_mouse_drag {
            properties.push(("allow-mouse-drag", allow_mouse_drag));
        }
        if let Some(ref enabled) = self.enabled {
            properties.push(("enabled", enabled));
        }
        if let Some(ref reversed) = self.reversed {
            properties.push(("reversed", reversed));
        }
        if let Some(ref swipeable) = self.swipeable {
            properties.push(("swipeable", swipeable));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<SwipeTracker>(&properties)
            .expect("Failed to create an instance of SwipeTracker")
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn allow_long_swipes(mut self, allow_long_swipes: bool) -> Self {
        self.allow_long_swipes = Some(allow_long_swipes);
        self
    }

    pub fn allow_mouse_drag(mut self, allow_mouse_drag: bool) -> Self {
        self.allow_mouse_drag = Some(allow_mouse_drag);
        self
    }

    pub fn enabled(mut self, enabled: bool) -> Self {
        self.enabled = Some(enabled);
        self
    }

    pub fn reversed(mut self, reversed: bool) -> Self {
        self.reversed = Some(reversed);
        self
    }

    pub fn swipeable(mut self, swipeable: &impl IsA<Swipeable>) -> Self {
        self.swipeable = Some(swipeable.clone().upcast());
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

impl fmt::Display for SwipeTracker {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SwipeTracker")
    }
}
