// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::EventTypeFlags;
use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::ffi::CStr;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstBufferingMode")]
pub enum BufferingMode {
    #[doc(alias = "GST_BUFFERING_STREAM")]
    Stream,
    #[doc(alias = "GST_BUFFERING_DOWNLOAD")]
    Download,
    #[doc(alias = "GST_BUFFERING_TIMESHIFT")]
    Timeshift,
    #[doc(alias = "GST_BUFFERING_LIVE")]
    Live,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for BufferingMode {
    type GlibType = ffi::GstBufferingMode;

    fn into_glib(self) -> ffi::GstBufferingMode {
        match self {
            Self::Stream => ffi::GST_BUFFERING_STREAM,
            Self::Download => ffi::GST_BUFFERING_DOWNLOAD,
            Self::Timeshift => ffi::GST_BUFFERING_TIMESHIFT,
            Self::Live => ffi::GST_BUFFERING_LIVE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstBufferingMode> for BufferingMode {
    unsafe fn from_glib(value: ffi::GstBufferingMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_BUFFERING_STREAM => Self::Stream,
            ffi::GST_BUFFERING_DOWNLOAD => Self::Download,
            ffi::GST_BUFFERING_TIMESHIFT => Self::Timeshift,
            ffi::GST_BUFFERING_LIVE => Self::Live,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BufferingMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_buffering_mode_get_type()) }
    }
}

impl glib::value::ValueType for BufferingMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BufferingMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BufferingMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstBusSyncReply")]
pub enum BusSyncReply {
    #[doc(alias = "GST_BUS_DROP")]
    Drop,
    #[doc(alias = "GST_BUS_PASS")]
    Pass,
    #[doc(alias = "GST_BUS_ASYNC")]
    Async,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for BusSyncReply {
    type GlibType = ffi::GstBusSyncReply;

    fn into_glib(self) -> ffi::GstBusSyncReply {
        match self {
            Self::Drop => ffi::GST_BUS_DROP,
            Self::Pass => ffi::GST_BUS_PASS,
            Self::Async => ffi::GST_BUS_ASYNC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstBusSyncReply> for BusSyncReply {
    unsafe fn from_glib(value: ffi::GstBusSyncReply) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_BUS_DROP => Self::Drop,
            ffi::GST_BUS_PASS => Self::Pass,
            ffi::GST_BUS_ASYNC => Self::Async,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BusSyncReply {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_bus_sync_reply_get_type()) }
    }
}

impl glib::value::ValueType for BusSyncReply {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BusSyncReply {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BusSyncReply {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstCapsIntersectMode")]
pub enum CapsIntersectMode {
    #[doc(alias = "GST_CAPS_INTERSECT_ZIG_ZAG")]
    ZigZag,
    #[doc(alias = "GST_CAPS_INTERSECT_FIRST")]
    First,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CapsIntersectMode {
    type GlibType = ffi::GstCapsIntersectMode;

    fn into_glib(self) -> ffi::GstCapsIntersectMode {
        match self {
            Self::ZigZag => ffi::GST_CAPS_INTERSECT_ZIG_ZAG,
            Self::First => ffi::GST_CAPS_INTERSECT_FIRST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstCapsIntersectMode> for CapsIntersectMode {
    unsafe fn from_glib(value: ffi::GstCapsIntersectMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_CAPS_INTERSECT_ZIG_ZAG => Self::ZigZag,
            ffi::GST_CAPS_INTERSECT_FIRST => Self::First,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CapsIntersectMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_caps_intersect_mode_get_type()) }
    }
}

impl glib::value::ValueType for CapsIntersectMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CapsIntersectMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CapsIntersectMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstClockEntryType")]
pub enum ClockEntryType {
    #[doc(alias = "GST_CLOCK_ENTRY_SINGLE")]
    Single,
    #[doc(alias = "GST_CLOCK_ENTRY_PERIODIC")]
    Periodic,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ClockEntryType {
    type GlibType = ffi::GstClockEntryType;

    fn into_glib(self) -> ffi::GstClockEntryType {
        match self {
            Self::Single => ffi::GST_CLOCK_ENTRY_SINGLE,
            Self::Periodic => ffi::GST_CLOCK_ENTRY_PERIODIC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstClockEntryType> for ClockEntryType {
    unsafe fn from_glib(value: ffi::GstClockEntryType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_CLOCK_ENTRY_SINGLE => Self::Single,
            ffi::GST_CLOCK_ENTRY_PERIODIC => Self::Periodic,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ClockEntryType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_clock_entry_type_get_type()) }
    }
}

impl glib::value::ValueType for ClockEntryType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ClockEntryType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ClockEntryType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstClockReturn")]
pub enum ClockReturn {
    #[doc(alias = "GST_CLOCK_OK")]
    Ok,
    #[doc(alias = "GST_CLOCK_EARLY")]
    Early,
    #[doc(alias = "GST_CLOCK_UNSCHEDULED")]
    Unscheduled,
    #[doc(alias = "GST_CLOCK_BUSY")]
    Busy,
    #[doc(alias = "GST_CLOCK_BADTIME")]
    Badtime,
    #[doc(alias = "GST_CLOCK_ERROR")]
    Error,
    #[doc(alias = "GST_CLOCK_UNSUPPORTED")]
    Unsupported,
    #[doc(alias = "GST_CLOCK_DONE")]
    Done,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ClockReturn {
    type GlibType = ffi::GstClockReturn;

    fn into_glib(self) -> ffi::GstClockReturn {
        match self {
            Self::Ok => ffi::GST_CLOCK_OK,
            Self::Early => ffi::GST_CLOCK_EARLY,
            Self::Unscheduled => ffi::GST_CLOCK_UNSCHEDULED,
            Self::Busy => ffi::GST_CLOCK_BUSY,
            Self::Badtime => ffi::GST_CLOCK_BADTIME,
            Self::Error => ffi::GST_CLOCK_ERROR,
            Self::Unsupported => ffi::GST_CLOCK_UNSUPPORTED,
            Self::Done => ffi::GST_CLOCK_DONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstClockReturn> for ClockReturn {
    unsafe fn from_glib(value: ffi::GstClockReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_CLOCK_OK => Self::Ok,
            ffi::GST_CLOCK_EARLY => Self::Early,
            ffi::GST_CLOCK_UNSCHEDULED => Self::Unscheduled,
            ffi::GST_CLOCK_BUSY => Self::Busy,
            ffi::GST_CLOCK_BADTIME => Self::Badtime,
            ffi::GST_CLOCK_ERROR => Self::Error,
            ffi::GST_CLOCK_UNSUPPORTED => Self::Unsupported,
            ffi::GST_CLOCK_DONE => Self::Done,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ClockReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_clock_return_get_type()) }
    }
}

impl glib::value::ValueType for ClockReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ClockReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ClockReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstClockType")]
pub enum ClockType {
    #[doc(alias = "GST_CLOCK_TYPE_REALTIME")]
    Realtime,
    #[doc(alias = "GST_CLOCK_TYPE_MONOTONIC")]
    Monotonic,
    #[doc(alias = "GST_CLOCK_TYPE_OTHER")]
    Other,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_CLOCK_TYPE_TAI")]
    Tai,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ClockType {
    type GlibType = ffi::GstClockType;

    fn into_glib(self) -> ffi::GstClockType {
        match self {
            Self::Realtime => ffi::GST_CLOCK_TYPE_REALTIME,
            Self::Monotonic => ffi::GST_CLOCK_TYPE_MONOTONIC,
            Self::Other => ffi::GST_CLOCK_TYPE_OTHER,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::Tai => ffi::GST_CLOCK_TYPE_TAI,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstClockType> for ClockType {
    unsafe fn from_glib(value: ffi::GstClockType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_CLOCK_TYPE_REALTIME => Self::Realtime,
            ffi::GST_CLOCK_TYPE_MONOTONIC => Self::Monotonic,
            ffi::GST_CLOCK_TYPE_OTHER => Self::Other,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_CLOCK_TYPE_TAI => Self::Tai,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ClockType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_clock_type_get_type()) }
    }
}

impl glib::value::ValueType for ClockType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ClockType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ClockType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstCoreError")]
pub enum CoreError {
    #[doc(alias = "GST_CORE_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_CORE_ERROR_TOO_LAZY")]
    TooLazy,
    #[doc(alias = "GST_CORE_ERROR_NOT_IMPLEMENTED")]
    NotImplemented,
    #[doc(alias = "GST_CORE_ERROR_STATE_CHANGE")]
    StateChange,
    #[doc(alias = "GST_CORE_ERROR_PAD")]
    Pad,
    #[doc(alias = "GST_CORE_ERROR_THREAD")]
    Thread,
    #[doc(alias = "GST_CORE_ERROR_NEGOTIATION")]
    Negotiation,
    #[doc(alias = "GST_CORE_ERROR_EVENT")]
    Event,
    #[doc(alias = "GST_CORE_ERROR_SEEK")]
    Seek,
    #[doc(alias = "GST_CORE_ERROR_CAPS")]
    Caps,
    #[doc(alias = "GST_CORE_ERROR_TAG")]
    Tag,
    #[doc(alias = "GST_CORE_ERROR_MISSING_PLUGIN")]
    MissingPlugin,
    #[doc(alias = "GST_CORE_ERROR_CLOCK")]
    Clock,
    #[doc(alias = "GST_CORE_ERROR_DISABLED")]
    Disabled,
    #[doc(alias = "GST_CORE_ERROR_NUM_ERRORS")]
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CoreError {
    type GlibType = ffi::GstCoreError;

    fn into_glib(self) -> ffi::GstCoreError {
        match self {
            Self::Failed => ffi::GST_CORE_ERROR_FAILED,
            Self::TooLazy => ffi::GST_CORE_ERROR_TOO_LAZY,
            Self::NotImplemented => ffi::GST_CORE_ERROR_NOT_IMPLEMENTED,
            Self::StateChange => ffi::GST_CORE_ERROR_STATE_CHANGE,
            Self::Pad => ffi::GST_CORE_ERROR_PAD,
            Self::Thread => ffi::GST_CORE_ERROR_THREAD,
            Self::Negotiation => ffi::GST_CORE_ERROR_NEGOTIATION,
            Self::Event => ffi::GST_CORE_ERROR_EVENT,
            Self::Seek => ffi::GST_CORE_ERROR_SEEK,
            Self::Caps => ffi::GST_CORE_ERROR_CAPS,
            Self::Tag => ffi::GST_CORE_ERROR_TAG,
            Self::MissingPlugin => ffi::GST_CORE_ERROR_MISSING_PLUGIN,
            Self::Clock => ffi::GST_CORE_ERROR_CLOCK,
            Self::Disabled => ffi::GST_CORE_ERROR_DISABLED,
            Self::NumErrors => ffi::GST_CORE_ERROR_NUM_ERRORS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstCoreError> for CoreError {
    unsafe fn from_glib(value: ffi::GstCoreError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_CORE_ERROR_FAILED => Self::Failed,
            ffi::GST_CORE_ERROR_TOO_LAZY => Self::TooLazy,
            ffi::GST_CORE_ERROR_NOT_IMPLEMENTED => Self::NotImplemented,
            ffi::GST_CORE_ERROR_STATE_CHANGE => Self::StateChange,
            ffi::GST_CORE_ERROR_PAD => Self::Pad,
            ffi::GST_CORE_ERROR_THREAD => Self::Thread,
            ffi::GST_CORE_ERROR_NEGOTIATION => Self::Negotiation,
            ffi::GST_CORE_ERROR_EVENT => Self::Event,
            ffi::GST_CORE_ERROR_SEEK => Self::Seek,
            ffi::GST_CORE_ERROR_CAPS => Self::Caps,
            ffi::GST_CORE_ERROR_TAG => Self::Tag,
            ffi::GST_CORE_ERROR_MISSING_PLUGIN => Self::MissingPlugin,
            ffi::GST_CORE_ERROR_CLOCK => Self::Clock,
            ffi::GST_CORE_ERROR_DISABLED => Self::Disabled,
            ffi::GST_CORE_ERROR_NUM_ERRORS => Self::NumErrors,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for CoreError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_core_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_CORE_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_CORE_ERROR_TOO_LAZY => Some(Self::TooLazy),
            ffi::GST_CORE_ERROR_NOT_IMPLEMENTED => Some(Self::NotImplemented),
            ffi::GST_CORE_ERROR_STATE_CHANGE => Some(Self::StateChange),
            ffi::GST_CORE_ERROR_PAD => Some(Self::Pad),
            ffi::GST_CORE_ERROR_THREAD => Some(Self::Thread),
            ffi::GST_CORE_ERROR_NEGOTIATION => Some(Self::Negotiation),
            ffi::GST_CORE_ERROR_EVENT => Some(Self::Event),
            ffi::GST_CORE_ERROR_SEEK => Some(Self::Seek),
            ffi::GST_CORE_ERROR_CAPS => Some(Self::Caps),
            ffi::GST_CORE_ERROR_TAG => Some(Self::Tag),
            ffi::GST_CORE_ERROR_MISSING_PLUGIN => Some(Self::MissingPlugin),
            ffi::GST_CORE_ERROR_CLOCK => Some(Self::Clock),
            ffi::GST_CORE_ERROR_DISABLED => Some(Self::Disabled),
            ffi::GST_CORE_ERROR_NUM_ERRORS => Some(Self::NumErrors),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for CoreError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_core_error_get_type()) }
    }
}

impl glib::value::ValueType for CoreError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CoreError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CoreError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstDebugLevel")]
pub enum DebugLevel {
    #[doc(alias = "GST_LEVEL_NONE")]
    None,
    #[doc(alias = "GST_LEVEL_ERROR")]
    Error,
    #[doc(alias = "GST_LEVEL_WARNING")]
    Warning,
    #[doc(alias = "GST_LEVEL_FIXME")]
    Fixme,
    #[doc(alias = "GST_LEVEL_INFO")]
    Info,
    #[doc(alias = "GST_LEVEL_DEBUG")]
    Debug,
    #[doc(alias = "GST_LEVEL_LOG")]
    Log,
    #[doc(alias = "GST_LEVEL_TRACE")]
    Trace,
    #[doc(alias = "GST_LEVEL_MEMDUMP")]
    Memdump,
    #[doc(alias = "GST_LEVEL_COUNT")]
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

impl DebugLevel {
    pub fn name<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::gst_debug_level_get_name(self.into_glib())
                    .as_ref()
                    .expect("gst_debug_level_get_name returned NULL"),
            )
            .to_str()
            .expect("gst_debug_level_get_name returned an invalid string")
        }
    }
}

impl fmt::Display for DebugLevel {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for DebugLevel {
    type GlibType = ffi::GstDebugLevel;

    fn into_glib(self) -> ffi::GstDebugLevel {
        match self {
            Self::None => ffi::GST_LEVEL_NONE,
            Self::Error => ffi::GST_LEVEL_ERROR,
            Self::Warning => ffi::GST_LEVEL_WARNING,
            Self::Fixme => ffi::GST_LEVEL_FIXME,
            Self::Info => ffi::GST_LEVEL_INFO,
            Self::Debug => ffi::GST_LEVEL_DEBUG,
            Self::Log => ffi::GST_LEVEL_LOG,
            Self::Trace => ffi::GST_LEVEL_TRACE,
            Self::Memdump => ffi::GST_LEVEL_MEMDUMP,
            Self::Count => ffi::GST_LEVEL_COUNT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstDebugLevel> for DebugLevel {
    unsafe fn from_glib(value: ffi::GstDebugLevel) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_LEVEL_NONE => Self::None,
            ffi::GST_LEVEL_ERROR => Self::Error,
            ffi::GST_LEVEL_WARNING => Self::Warning,
            ffi::GST_LEVEL_FIXME => Self::Fixme,
            ffi::GST_LEVEL_INFO => Self::Info,
            ffi::GST_LEVEL_DEBUG => Self::Debug,
            ffi::GST_LEVEL_LOG => Self::Log,
            ffi::GST_LEVEL_TRACE => Self::Trace,
            ffi::GST_LEVEL_MEMDUMP => Self::Memdump,
            ffi::GST_LEVEL_COUNT => Self::Count,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DebugLevel {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_debug_level_get_type()) }
    }
}

impl glib::value::ValueType for DebugLevel {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DebugLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DebugLevel {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, PartialEq, Eq, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstEventType")]
pub enum EventType {
    #[doc(alias = "GST_EVENT_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_EVENT_FLUSH_START")]
    FlushStart,
    #[doc(alias = "GST_EVENT_FLUSH_STOP")]
    FlushStop,
    #[doc(alias = "GST_EVENT_STREAM_START")]
    StreamStart,
    #[doc(alias = "GST_EVENT_CAPS")]
    Caps,
    #[doc(alias = "GST_EVENT_SEGMENT")]
    Segment,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_EVENT_STREAM_COLLECTION")]
    StreamCollection,
    #[doc(alias = "GST_EVENT_TAG")]
    Tag,
    #[doc(alias = "GST_EVENT_BUFFERSIZE")]
    Buffersize,
    #[doc(alias = "GST_EVENT_SINK_MESSAGE")]
    SinkMessage,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_EVENT_STREAM_GROUP_DONE")]
    StreamGroupDone,
    #[doc(alias = "GST_EVENT_EOS")]
    Eos,
    #[doc(alias = "GST_EVENT_TOC")]
    Toc,
    #[doc(alias = "GST_EVENT_PROTECTION")]
    Protection,
    #[doc(alias = "GST_EVENT_SEGMENT_DONE")]
    SegmentDone,
    #[doc(alias = "GST_EVENT_GAP")]
    Gap,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_EVENT_INSTANT_RATE_CHANGE")]
    InstantRateChange,
    #[doc(alias = "GST_EVENT_QOS")]
    Qos,
    #[doc(alias = "GST_EVENT_SEEK")]
    Seek,
    #[doc(alias = "GST_EVENT_NAVIGATION")]
    Navigation,
    #[doc(alias = "GST_EVENT_LATENCY")]
    Latency,
    #[doc(alias = "GST_EVENT_STEP")]
    Step,
    #[doc(alias = "GST_EVENT_RECONFIGURE")]
    Reconfigure,
    #[doc(alias = "GST_EVENT_TOC_SELECT")]
    TocSelect,
    #[cfg(any(feature = "v1_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_10")))]
    #[doc(alias = "GST_EVENT_SELECT_STREAMS")]
    SelectStreams,
    #[cfg(any(feature = "v1_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_18")))]
    #[doc(alias = "GST_EVENT_INSTANT_RATE_SYNC_TIME")]
    InstantRateSyncTime,
    #[doc(alias = "GST_EVENT_CUSTOM_UPSTREAM")]
    CustomUpstream,
    #[doc(alias = "GST_EVENT_CUSTOM_DOWNSTREAM")]
    CustomDownstream,
    #[doc(alias = "GST_EVENT_CUSTOM_DOWNSTREAM_OOB")]
    CustomDownstreamOob,
    #[doc(alias = "GST_EVENT_CUSTOM_DOWNSTREAM_STICKY")]
    CustomDownstreamSticky,
    #[doc(alias = "GST_EVENT_CUSTOM_BOTH")]
    CustomBoth,
    #[doc(alias = "GST_EVENT_CUSTOM_BOTH_OOB")]
    CustomBothOob,
    #[doc(hidden)]
    __Unknown(i32),
}

impl EventType {
    #[doc(alias = "gst_event_type_get_flags")]
    #[doc(alias = "get_flags")]
    pub fn flags(self) -> EventTypeFlags {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_event_type_get_flags(self.into_glib())) }
    }

    pub fn name<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::gst_event_type_get_name(self.into_glib())
                    .as_ref()
                    .expect("gst_event_type_get_name returned NULL"),
            )
            .to_str()
            .expect("gst_event_type_get_name returned an invalid string")
        }
    }

    #[doc(alias = "gst_event_type_to_quark")]
    pub fn to_quark(self) -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_event_type_to_quark(self.into_glib())) }
    }
}

impl fmt::Display for EventType {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for EventType {
    type GlibType = ffi::GstEventType;

    fn into_glib(self) -> ffi::GstEventType {
        match self {
            Self::Unknown => ffi::GST_EVENT_UNKNOWN,
            Self::FlushStart => ffi::GST_EVENT_FLUSH_START,
            Self::FlushStop => ffi::GST_EVENT_FLUSH_STOP,
            Self::StreamStart => ffi::GST_EVENT_STREAM_START,
            Self::Caps => ffi::GST_EVENT_CAPS,
            Self::Segment => ffi::GST_EVENT_SEGMENT,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::StreamCollection => ffi::GST_EVENT_STREAM_COLLECTION,
            Self::Tag => ffi::GST_EVENT_TAG,
            Self::Buffersize => ffi::GST_EVENT_BUFFERSIZE,
            Self::SinkMessage => ffi::GST_EVENT_SINK_MESSAGE,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::StreamGroupDone => ffi::GST_EVENT_STREAM_GROUP_DONE,
            Self::Eos => ffi::GST_EVENT_EOS,
            Self::Toc => ffi::GST_EVENT_TOC,
            Self::Protection => ffi::GST_EVENT_PROTECTION,
            Self::SegmentDone => ffi::GST_EVENT_SEGMENT_DONE,
            Self::Gap => ffi::GST_EVENT_GAP,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::InstantRateChange => ffi::GST_EVENT_INSTANT_RATE_CHANGE,
            Self::Qos => ffi::GST_EVENT_QOS,
            Self::Seek => ffi::GST_EVENT_SEEK,
            Self::Navigation => ffi::GST_EVENT_NAVIGATION,
            Self::Latency => ffi::GST_EVENT_LATENCY,
            Self::Step => ffi::GST_EVENT_STEP,
            Self::Reconfigure => ffi::GST_EVENT_RECONFIGURE,
            Self::TocSelect => ffi::GST_EVENT_TOC_SELECT,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            Self::SelectStreams => ffi::GST_EVENT_SELECT_STREAMS,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            Self::InstantRateSyncTime => ffi::GST_EVENT_INSTANT_RATE_SYNC_TIME,
            Self::CustomUpstream => ffi::GST_EVENT_CUSTOM_UPSTREAM,
            Self::CustomDownstream => ffi::GST_EVENT_CUSTOM_DOWNSTREAM,
            Self::CustomDownstreamOob => ffi::GST_EVENT_CUSTOM_DOWNSTREAM_OOB,
            Self::CustomDownstreamSticky => ffi::GST_EVENT_CUSTOM_DOWNSTREAM_STICKY,
            Self::CustomBoth => ffi::GST_EVENT_CUSTOM_BOTH,
            Self::CustomBothOob => ffi::GST_EVENT_CUSTOM_BOTH_OOB,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstEventType> for EventType {
    unsafe fn from_glib(value: ffi::GstEventType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_EVENT_UNKNOWN => Self::Unknown,
            ffi::GST_EVENT_FLUSH_START => Self::FlushStart,
            ffi::GST_EVENT_FLUSH_STOP => Self::FlushStop,
            ffi::GST_EVENT_STREAM_START => Self::StreamStart,
            ffi::GST_EVENT_CAPS => Self::Caps,
            ffi::GST_EVENT_SEGMENT => Self::Segment,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_EVENT_STREAM_COLLECTION => Self::StreamCollection,
            ffi::GST_EVENT_TAG => Self::Tag,
            ffi::GST_EVENT_BUFFERSIZE => Self::Buffersize,
            ffi::GST_EVENT_SINK_MESSAGE => Self::SinkMessage,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_EVENT_STREAM_GROUP_DONE => Self::StreamGroupDone,
            ffi::GST_EVENT_EOS => Self::Eos,
            ffi::GST_EVENT_TOC => Self::Toc,
            ffi::GST_EVENT_PROTECTION => Self::Protection,
            ffi::GST_EVENT_SEGMENT_DONE => Self::SegmentDone,
            ffi::GST_EVENT_GAP => Self::Gap,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_EVENT_INSTANT_RATE_CHANGE => Self::InstantRateChange,
            ffi::GST_EVENT_QOS => Self::Qos,
            ffi::GST_EVENT_SEEK => Self::Seek,
            ffi::GST_EVENT_NAVIGATION => Self::Navigation,
            ffi::GST_EVENT_LATENCY => Self::Latency,
            ffi::GST_EVENT_STEP => Self::Step,
            ffi::GST_EVENT_RECONFIGURE => Self::Reconfigure,
            ffi::GST_EVENT_TOC_SELECT => Self::TocSelect,
            #[cfg(any(feature = "v1_10", feature = "dox"))]
            ffi::GST_EVENT_SELECT_STREAMS => Self::SelectStreams,
            #[cfg(any(feature = "v1_18", feature = "dox"))]
            ffi::GST_EVENT_INSTANT_RATE_SYNC_TIME => Self::InstantRateSyncTime,
            ffi::GST_EVENT_CUSTOM_UPSTREAM => Self::CustomUpstream,
            ffi::GST_EVENT_CUSTOM_DOWNSTREAM => Self::CustomDownstream,
            ffi::GST_EVENT_CUSTOM_DOWNSTREAM_OOB => Self::CustomDownstreamOob,
            ffi::GST_EVENT_CUSTOM_DOWNSTREAM_STICKY => Self::CustomDownstreamSticky,
            ffi::GST_EVENT_CUSTOM_BOTH => Self::CustomBoth,
            ffi::GST_EVENT_CUSTOM_BOTH_OOB => Self::CustomBothOob,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EventType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_event_type_get_type()) }
    }
}

impl glib::value::ValueType for EventType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EventType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EventType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstFlowReturn")]
pub enum FlowReturn {
    #[doc(alias = "GST_FLOW_CUSTOM_SUCCESS_2")]
    CustomSuccess2,
    #[doc(alias = "GST_FLOW_CUSTOM_SUCCESS_1")]
    CustomSuccess1,
    #[doc(alias = "GST_FLOW_CUSTOM_SUCCESS")]
    CustomSuccess,
    #[doc(alias = "GST_FLOW_OK")]
    Ok,
    #[doc(alias = "GST_FLOW_NOT_LINKED")]
    NotLinked,
    #[doc(alias = "GST_FLOW_FLUSHING")]
    Flushing,
    #[doc(alias = "GST_FLOW_EOS")]
    Eos,
    #[doc(alias = "GST_FLOW_NOT_NEGOTIATED")]
    NotNegotiated,
    #[doc(alias = "GST_FLOW_ERROR")]
    Error,
    #[doc(alias = "GST_FLOW_NOT_SUPPORTED")]
    NotSupported,
    #[doc(alias = "GST_FLOW_CUSTOM_ERROR")]
    CustomError,
    #[doc(alias = "GST_FLOW_CUSTOM_ERROR_1")]
    CustomError1,
    #[doc(alias = "GST_FLOW_CUSTOM_ERROR_2")]
    CustomError2,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FlowReturn {
    type GlibType = ffi::GstFlowReturn;

    fn into_glib(self) -> ffi::GstFlowReturn {
        match self {
            Self::CustomSuccess2 => ffi::GST_FLOW_CUSTOM_SUCCESS_2,
            Self::CustomSuccess1 => ffi::GST_FLOW_CUSTOM_SUCCESS_1,
            Self::CustomSuccess => ffi::GST_FLOW_CUSTOM_SUCCESS,
            Self::Ok => ffi::GST_FLOW_OK,
            Self::NotLinked => ffi::GST_FLOW_NOT_LINKED,
            Self::Flushing => ffi::GST_FLOW_FLUSHING,
            Self::Eos => ffi::GST_FLOW_EOS,
            Self::NotNegotiated => ffi::GST_FLOW_NOT_NEGOTIATED,
            Self::Error => ffi::GST_FLOW_ERROR,
            Self::NotSupported => ffi::GST_FLOW_NOT_SUPPORTED,
            Self::CustomError => ffi::GST_FLOW_CUSTOM_ERROR,
            Self::CustomError1 => ffi::GST_FLOW_CUSTOM_ERROR_1,
            Self::CustomError2 => ffi::GST_FLOW_CUSTOM_ERROR_2,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstFlowReturn> for FlowReturn {
    unsafe fn from_glib(value: ffi::GstFlowReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_FLOW_CUSTOM_SUCCESS_2 => Self::CustomSuccess2,
            ffi::GST_FLOW_CUSTOM_SUCCESS_1 => Self::CustomSuccess1,
            ffi::GST_FLOW_CUSTOM_SUCCESS => Self::CustomSuccess,
            ffi::GST_FLOW_OK => Self::Ok,
            ffi::GST_FLOW_NOT_LINKED => Self::NotLinked,
            ffi::GST_FLOW_FLUSHING => Self::Flushing,
            ffi::GST_FLOW_EOS => Self::Eos,
            ffi::GST_FLOW_NOT_NEGOTIATED => Self::NotNegotiated,
            ffi::GST_FLOW_ERROR => Self::Error,
            ffi::GST_FLOW_NOT_SUPPORTED => Self::NotSupported,
            ffi::GST_FLOW_CUSTOM_ERROR => Self::CustomError,
            ffi::GST_FLOW_CUSTOM_ERROR_1 => Self::CustomError1,
            ffi::GST_FLOW_CUSTOM_ERROR_2 => Self::CustomError2,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FlowReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_flow_return_get_type()) }
    }
}

impl glib::value::ValueType for FlowReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FlowReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FlowReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstFormat")]
pub enum Format {
    #[doc(alias = "GST_FORMAT_UNDEFINED")]
    Undefined,
    #[doc(alias = "GST_FORMAT_DEFAULT")]
    Default,
    #[doc(alias = "GST_FORMAT_BYTES")]
    Bytes,
    #[doc(alias = "GST_FORMAT_TIME")]
    Time,
    #[doc(alias = "GST_FORMAT_BUFFERS")]
    Buffers,
    #[doc(alias = "GST_FORMAT_PERCENT")]
    Percent,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Format {
    #[doc(alias = "gst_format_get_by_nick")]
    #[doc(alias = "get_by_nick")]
    pub fn by_nick(nick: &str) -> Format {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_format_get_by_nick(nick.to_glib_none().0)) }
    }

    //#[doc(alias = "gst_format_get_details")]
    //#[doc(alias = "get_details")]
    //pub fn details(self) -> /*Ignored*/Option<FormatDefinition> {
    //    unsafe { TODO: call ffi:gst_format_get_details() }
    //}

    #[doc(alias = "gst_format_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gst_format_get_name(self.into_glib())) }
    }

    //#[doc(alias = "gst_format_iterate_definitions")]
    //pub fn iterate_definitions() -> /*Ignored*/Iterator {
    //    unsafe { TODO: call ffi:gst_format_iterate_definitions() }
    //}

    #[doc(alias = "gst_format_to_quark")]
    pub fn to_quark(self) -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gst_format_to_quark(self.into_glib())) }
    }
}

#[doc(hidden)]
impl IntoGlib for Format {
    type GlibType = ffi::GstFormat;

    fn into_glib(self) -> ffi::GstFormat {
        match self {
            Self::Undefined => ffi::GST_FORMAT_UNDEFINED,
            Self::Default => ffi::GST_FORMAT_DEFAULT,
            Self::Bytes => ffi::GST_FORMAT_BYTES,
            Self::Time => ffi::GST_FORMAT_TIME,
            Self::Buffers => ffi::GST_FORMAT_BUFFERS,
            Self::Percent => ffi::GST_FORMAT_PERCENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstFormat> for Format {
    unsafe fn from_glib(value: ffi::GstFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_FORMAT_UNDEFINED => Self::Undefined,
            ffi::GST_FORMAT_DEFAULT => Self::Default,
            ffi::GST_FORMAT_BYTES => Self::Bytes,
            ffi::GST_FORMAT_TIME => Self::Time,
            ffi::GST_FORMAT_BUFFERS => Self::Buffers,
            ffi::GST_FORMAT_PERCENT => Self::Percent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Format {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_format_get_type()) }
    }
}

impl glib::value::ValueType for Format {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Format {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Format {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstLibraryError")]
pub enum LibraryError {
    #[doc(alias = "GST_LIBRARY_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_LIBRARY_ERROR_TOO_LAZY")]
    TooLazy,
    #[doc(alias = "GST_LIBRARY_ERROR_INIT")]
    Init,
    #[doc(alias = "GST_LIBRARY_ERROR_SHUTDOWN")]
    Shutdown,
    #[doc(alias = "GST_LIBRARY_ERROR_SETTINGS")]
    Settings,
    #[doc(alias = "GST_LIBRARY_ERROR_ENCODE")]
    Encode,
    #[doc(alias = "GST_LIBRARY_ERROR_NUM_ERRORS")]
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for LibraryError {
    type GlibType = ffi::GstLibraryError;

    fn into_glib(self) -> ffi::GstLibraryError {
        match self {
            Self::Failed => ffi::GST_LIBRARY_ERROR_FAILED,
            Self::TooLazy => ffi::GST_LIBRARY_ERROR_TOO_LAZY,
            Self::Init => ffi::GST_LIBRARY_ERROR_INIT,
            Self::Shutdown => ffi::GST_LIBRARY_ERROR_SHUTDOWN,
            Self::Settings => ffi::GST_LIBRARY_ERROR_SETTINGS,
            Self::Encode => ffi::GST_LIBRARY_ERROR_ENCODE,
            Self::NumErrors => ffi::GST_LIBRARY_ERROR_NUM_ERRORS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstLibraryError> for LibraryError {
    unsafe fn from_glib(value: ffi::GstLibraryError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_LIBRARY_ERROR_FAILED => Self::Failed,
            ffi::GST_LIBRARY_ERROR_TOO_LAZY => Self::TooLazy,
            ffi::GST_LIBRARY_ERROR_INIT => Self::Init,
            ffi::GST_LIBRARY_ERROR_SHUTDOWN => Self::Shutdown,
            ffi::GST_LIBRARY_ERROR_SETTINGS => Self::Settings,
            ffi::GST_LIBRARY_ERROR_ENCODE => Self::Encode,
            ffi::GST_LIBRARY_ERROR_NUM_ERRORS => Self::NumErrors,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for LibraryError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_library_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_LIBRARY_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_LIBRARY_ERROR_TOO_LAZY => Some(Self::TooLazy),
            ffi::GST_LIBRARY_ERROR_INIT => Some(Self::Init),
            ffi::GST_LIBRARY_ERROR_SHUTDOWN => Some(Self::Shutdown),
            ffi::GST_LIBRARY_ERROR_SETTINGS => Some(Self::Settings),
            ffi::GST_LIBRARY_ERROR_ENCODE => Some(Self::Encode),
            ffi::GST_LIBRARY_ERROR_NUM_ERRORS => Some(Self::NumErrors),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for LibraryError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_library_error_get_type()) }
    }
}

impl glib::value::ValueType for LibraryError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for LibraryError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LibraryError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPadDirection")]
pub enum PadDirection {
    #[doc(alias = "GST_PAD_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_PAD_SRC")]
    Src,
    #[doc(alias = "GST_PAD_SINK")]
    Sink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PadDirection {
    type GlibType = ffi::GstPadDirection;

    fn into_glib(self) -> ffi::GstPadDirection {
        match self {
            Self::Unknown => ffi::GST_PAD_UNKNOWN,
            Self::Src => ffi::GST_PAD_SRC,
            Self::Sink => ffi::GST_PAD_SINK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPadDirection> for PadDirection {
    unsafe fn from_glib(value: ffi::GstPadDirection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PAD_UNKNOWN => Self::Unknown,
            ffi::GST_PAD_SRC => Self::Src,
            ffi::GST_PAD_SINK => Self::Sink,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PadDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_pad_direction_get_type()) }
    }
}

impl glib::value::ValueType for PadDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PadDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PadDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPadLinkReturn")]
pub enum PadLinkReturn {
    #[doc(alias = "GST_PAD_LINK_OK")]
    Ok,
    #[doc(alias = "GST_PAD_LINK_WRONG_HIERARCHY")]
    WrongHierarchy,
    #[doc(alias = "GST_PAD_LINK_WAS_LINKED")]
    WasLinked,
    #[doc(alias = "GST_PAD_LINK_WRONG_DIRECTION")]
    WrongDirection,
    #[doc(alias = "GST_PAD_LINK_NOFORMAT")]
    Noformat,
    #[doc(alias = "GST_PAD_LINK_NOSCHED")]
    Nosched,
    #[doc(alias = "GST_PAD_LINK_REFUSED")]
    Refused,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PadLinkReturn {
    type GlibType = ffi::GstPadLinkReturn;

    fn into_glib(self) -> ffi::GstPadLinkReturn {
        match self {
            Self::Ok => ffi::GST_PAD_LINK_OK,
            Self::WrongHierarchy => ffi::GST_PAD_LINK_WRONG_HIERARCHY,
            Self::WasLinked => ffi::GST_PAD_LINK_WAS_LINKED,
            Self::WrongDirection => ffi::GST_PAD_LINK_WRONG_DIRECTION,
            Self::Noformat => ffi::GST_PAD_LINK_NOFORMAT,
            Self::Nosched => ffi::GST_PAD_LINK_NOSCHED,
            Self::Refused => ffi::GST_PAD_LINK_REFUSED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPadLinkReturn> for PadLinkReturn {
    unsafe fn from_glib(value: ffi::GstPadLinkReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PAD_LINK_OK => Self::Ok,
            ffi::GST_PAD_LINK_WRONG_HIERARCHY => Self::WrongHierarchy,
            ffi::GST_PAD_LINK_WAS_LINKED => Self::WasLinked,
            ffi::GST_PAD_LINK_WRONG_DIRECTION => Self::WrongDirection,
            ffi::GST_PAD_LINK_NOFORMAT => Self::Noformat,
            ffi::GST_PAD_LINK_NOSCHED => Self::Nosched,
            ffi::GST_PAD_LINK_REFUSED => Self::Refused,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PadLinkReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_pad_link_return_get_type()) }
    }
}

impl glib::value::ValueType for PadLinkReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PadLinkReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PadLinkReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPadMode")]
pub enum PadMode {
    #[doc(alias = "GST_PAD_MODE_NONE")]
    None,
    #[doc(alias = "GST_PAD_MODE_PUSH")]
    Push,
    #[doc(alias = "GST_PAD_MODE_PULL")]
    Pull,
    #[doc(hidden)]
    __Unknown(i32),
}

impl PadMode {
    pub fn name<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::gst_pad_mode_get_name(self.into_glib())
                    .as_ref()
                    .expect("gst_pad_mode_get_name returned NULL"),
            )
            .to_str()
            .expect("gst_pad_mode_get_name returned an invalid string")
        }
    }
}

impl fmt::Display for PadMode {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for PadMode {
    type GlibType = ffi::GstPadMode;

    fn into_glib(self) -> ffi::GstPadMode {
        match self {
            Self::None => ffi::GST_PAD_MODE_NONE,
            Self::Push => ffi::GST_PAD_MODE_PUSH,
            Self::Pull => ffi::GST_PAD_MODE_PULL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPadMode> for PadMode {
    unsafe fn from_glib(value: ffi::GstPadMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PAD_MODE_NONE => Self::None,
            ffi::GST_PAD_MODE_PUSH => Self::Push,
            ffi::GST_PAD_MODE_PULL => Self::Pull,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PadMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_pad_mode_get_type()) }
    }
}

impl glib::value::ValueType for PadMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PadMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PadMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPadPresence")]
pub enum PadPresence {
    #[doc(alias = "GST_PAD_ALWAYS")]
    Always,
    #[doc(alias = "GST_PAD_SOMETIMES")]
    Sometimes,
    #[doc(alias = "GST_PAD_REQUEST")]
    Request,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PadPresence {
    type GlibType = ffi::GstPadPresence;

    fn into_glib(self) -> ffi::GstPadPresence {
        match self {
            Self::Always => ffi::GST_PAD_ALWAYS,
            Self::Sometimes => ffi::GST_PAD_SOMETIMES,
            Self::Request => ffi::GST_PAD_REQUEST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPadPresence> for PadPresence {
    unsafe fn from_glib(value: ffi::GstPadPresence) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PAD_ALWAYS => Self::Always,
            ffi::GST_PAD_SOMETIMES => Self::Sometimes,
            ffi::GST_PAD_REQUEST => Self::Request,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PadPresence {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_pad_presence_get_type()) }
    }
}

impl glib::value::ValueType for PadPresence {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PadPresence {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PadPresence {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPadProbeReturn")]
pub enum PadProbeReturn {
    #[doc(alias = "GST_PAD_PROBE_DROP")]
    Drop,
    #[doc(alias = "GST_PAD_PROBE_OK")]
    Ok,
    #[doc(alias = "GST_PAD_PROBE_REMOVE")]
    Remove,
    #[doc(alias = "GST_PAD_PROBE_PASS")]
    Pass,
    #[doc(alias = "GST_PAD_PROBE_HANDLED")]
    Handled,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PadProbeReturn {
    type GlibType = ffi::GstPadProbeReturn;

    fn into_glib(self) -> ffi::GstPadProbeReturn {
        match self {
            Self::Drop => ffi::GST_PAD_PROBE_DROP,
            Self::Ok => ffi::GST_PAD_PROBE_OK,
            Self::Remove => ffi::GST_PAD_PROBE_REMOVE,
            Self::Pass => ffi::GST_PAD_PROBE_PASS,
            Self::Handled => ffi::GST_PAD_PROBE_HANDLED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPadProbeReturn> for PadProbeReturn {
    unsafe fn from_glib(value: ffi::GstPadProbeReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PAD_PROBE_DROP => Self::Drop,
            ffi::GST_PAD_PROBE_OK => Self::Ok,
            ffi::GST_PAD_PROBE_REMOVE => Self::Remove,
            ffi::GST_PAD_PROBE_PASS => Self::Pass,
            ffi::GST_PAD_PROBE_HANDLED => Self::Handled,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PadProbeReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_pad_probe_return_get_type()) }
    }
}

impl glib::value::ValueType for PadProbeReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PadProbeReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PadProbeReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstParseError")]
pub enum ParseError {
    #[doc(alias = "GST_PARSE_ERROR_SYNTAX")]
    Syntax,
    #[doc(alias = "GST_PARSE_ERROR_NO_SUCH_ELEMENT")]
    NoSuchElement,
    #[doc(alias = "GST_PARSE_ERROR_NO_SUCH_PROPERTY")]
    NoSuchProperty,
    #[doc(alias = "GST_PARSE_ERROR_LINK")]
    Link,
    #[doc(alias = "GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY")]
    CouldNotSetProperty,
    #[doc(alias = "GST_PARSE_ERROR_EMPTY_BIN")]
    EmptyBin,
    #[doc(alias = "GST_PARSE_ERROR_EMPTY")]
    Empty,
    #[doc(alias = "GST_PARSE_ERROR_DELAYED_LINK")]
    DelayedLink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ParseError {
    type GlibType = ffi::GstParseError;

    fn into_glib(self) -> ffi::GstParseError {
        match self {
            Self::Syntax => ffi::GST_PARSE_ERROR_SYNTAX,
            Self::NoSuchElement => ffi::GST_PARSE_ERROR_NO_SUCH_ELEMENT,
            Self::NoSuchProperty => ffi::GST_PARSE_ERROR_NO_SUCH_PROPERTY,
            Self::Link => ffi::GST_PARSE_ERROR_LINK,
            Self::CouldNotSetProperty => ffi::GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY,
            Self::EmptyBin => ffi::GST_PARSE_ERROR_EMPTY_BIN,
            Self::Empty => ffi::GST_PARSE_ERROR_EMPTY,
            Self::DelayedLink => ffi::GST_PARSE_ERROR_DELAYED_LINK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstParseError> for ParseError {
    unsafe fn from_glib(value: ffi::GstParseError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PARSE_ERROR_SYNTAX => Self::Syntax,
            ffi::GST_PARSE_ERROR_NO_SUCH_ELEMENT => Self::NoSuchElement,
            ffi::GST_PARSE_ERROR_NO_SUCH_PROPERTY => Self::NoSuchProperty,
            ffi::GST_PARSE_ERROR_LINK => Self::Link,
            ffi::GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY => Self::CouldNotSetProperty,
            ffi::GST_PARSE_ERROR_EMPTY_BIN => Self::EmptyBin,
            ffi::GST_PARSE_ERROR_EMPTY => Self::Empty,
            ffi::GST_PARSE_ERROR_DELAYED_LINK => Self::DelayedLink,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for ParseError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_parse_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_PARSE_ERROR_SYNTAX => Some(Self::Syntax),
            ffi::GST_PARSE_ERROR_NO_SUCH_ELEMENT => Some(Self::NoSuchElement),
            ffi::GST_PARSE_ERROR_NO_SUCH_PROPERTY => Some(Self::NoSuchProperty),
            ffi::GST_PARSE_ERROR_LINK => Some(Self::Link),
            ffi::GST_PARSE_ERROR_COULD_NOT_SET_PROPERTY => Some(Self::CouldNotSetProperty),
            ffi::GST_PARSE_ERROR_EMPTY_BIN => Some(Self::EmptyBin),
            ffi::GST_PARSE_ERROR_EMPTY => Some(Self::Empty),
            ffi::GST_PARSE_ERROR_DELAYED_LINK => Some(Self::DelayedLink),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for ParseError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_parse_error_get_type()) }
    }
}

impl glib::value::ValueType for ParseError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ParseError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ParseError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPluginError")]
pub enum PluginError {
    #[doc(alias = "GST_PLUGIN_ERROR_MODULE")]
    Module,
    #[doc(alias = "GST_PLUGIN_ERROR_DEPENDENCIES")]
    Dependencies,
    #[doc(alias = "GST_PLUGIN_ERROR_NAME_MISMATCH")]
    NameMismatch,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PluginError {
    type GlibType = ffi::GstPluginError;

    fn into_glib(self) -> ffi::GstPluginError {
        match self {
            Self::Module => ffi::GST_PLUGIN_ERROR_MODULE,
            Self::Dependencies => ffi::GST_PLUGIN_ERROR_DEPENDENCIES,
            Self::NameMismatch => ffi::GST_PLUGIN_ERROR_NAME_MISMATCH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstPluginError> for PluginError {
    unsafe fn from_glib(value: ffi::GstPluginError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PLUGIN_ERROR_MODULE => Self::Module,
            ffi::GST_PLUGIN_ERROR_DEPENDENCIES => Self::Dependencies,
            ffi::GST_PLUGIN_ERROR_NAME_MISMATCH => Self::NameMismatch,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for PluginError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_plugin_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_PLUGIN_ERROR_MODULE => Some(Self::Module),
            ffi::GST_PLUGIN_ERROR_DEPENDENCIES => Some(Self::Dependencies),
            ffi::GST_PLUGIN_ERROR_NAME_MISMATCH => Some(Self::NameMismatch),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for PluginError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_plugin_error_get_type()) }
    }
}

impl glib::value::ValueType for PluginError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PluginError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PluginError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstProgressType")]
pub enum ProgressType {
    #[doc(alias = "GST_PROGRESS_TYPE_START")]
    Start,
    #[doc(alias = "GST_PROGRESS_TYPE_CONTINUE")]
    Continue,
    #[doc(alias = "GST_PROGRESS_TYPE_COMPLETE")]
    Complete,
    #[doc(alias = "GST_PROGRESS_TYPE_CANCELED")]
    Canceled,
    #[doc(alias = "GST_PROGRESS_TYPE_ERROR")]
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ProgressType {
    type GlibType = ffi::GstProgressType;

    fn into_glib(self) -> ffi::GstProgressType {
        match self {
            Self::Start => ffi::GST_PROGRESS_TYPE_START,
            Self::Continue => ffi::GST_PROGRESS_TYPE_CONTINUE,
            Self::Complete => ffi::GST_PROGRESS_TYPE_COMPLETE,
            Self::Canceled => ffi::GST_PROGRESS_TYPE_CANCELED,
            Self::Error => ffi::GST_PROGRESS_TYPE_ERROR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstProgressType> for ProgressType {
    unsafe fn from_glib(value: ffi::GstProgressType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PROGRESS_TYPE_START => Self::Start,
            ffi::GST_PROGRESS_TYPE_CONTINUE => Self::Continue,
            ffi::GST_PROGRESS_TYPE_COMPLETE => Self::Complete,
            ffi::GST_PROGRESS_TYPE_CANCELED => Self::Canceled,
            ffi::GST_PROGRESS_TYPE_ERROR => Self::Error,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ProgressType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_progress_type_get_type()) }
    }
}

impl glib::value::ValueType for ProgressType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ProgressType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ProgressType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstPromiseResult")]
pub enum PromiseResult {
    #[doc(alias = "GST_PROMISE_RESULT_PENDING")]
    Pending,
    #[doc(alias = "GST_PROMISE_RESULT_INTERRUPTED")]
    Interrupted,
    #[doc(alias = "GST_PROMISE_RESULT_REPLIED")]
    Replied,
    #[doc(alias = "GST_PROMISE_RESULT_EXPIRED")]
    Expired,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
#[doc(hidden)]
impl IntoGlib for PromiseResult {
    type GlibType = ffi::GstPromiseResult;

    fn into_glib(self) -> ffi::GstPromiseResult {
        match self {
            Self::Pending => ffi::GST_PROMISE_RESULT_PENDING,
            Self::Interrupted => ffi::GST_PROMISE_RESULT_INTERRUPTED,
            Self::Replied => ffi::GST_PROMISE_RESULT_REPLIED,
            Self::Expired => ffi::GST_PROMISE_RESULT_EXPIRED,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
#[doc(hidden)]
impl FromGlib<ffi::GstPromiseResult> for PromiseResult {
    unsafe fn from_glib(value: ffi::GstPromiseResult) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_PROMISE_RESULT_PENDING => Self::Pending,
            ffi::GST_PROMISE_RESULT_INTERRUPTED => Self::Interrupted,
            ffi::GST_PROMISE_RESULT_REPLIED => Self::Replied,
            ffi::GST_PROMISE_RESULT_EXPIRED => Self::Expired,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
impl StaticType for PromiseResult {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_promise_result_get_type()) }
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
impl glib::value::ValueType for PromiseResult {
    type Type = Self;
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
unsafe impl<'a> FromValue<'a> for PromiseResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v1_14", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
impl ToValue for PromiseResult {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstQOSType")]
pub enum QOSType {
    #[doc(alias = "GST_QOS_TYPE_OVERFLOW")]
    Overflow,
    #[doc(alias = "GST_QOS_TYPE_UNDERFLOW")]
    Underflow,
    #[doc(alias = "GST_QOS_TYPE_THROTTLE")]
    Throttle,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for QOSType {
    type GlibType = ffi::GstQOSType;

    fn into_glib(self) -> ffi::GstQOSType {
        match self {
            Self::Overflow => ffi::GST_QOS_TYPE_OVERFLOW,
            Self::Underflow => ffi::GST_QOS_TYPE_UNDERFLOW,
            Self::Throttle => ffi::GST_QOS_TYPE_THROTTLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstQOSType> for QOSType {
    unsafe fn from_glib(value: ffi::GstQOSType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_QOS_TYPE_OVERFLOW => Self::Overflow,
            ffi::GST_QOS_TYPE_UNDERFLOW => Self::Underflow,
            ffi::GST_QOS_TYPE_THROTTLE => Self::Throttle,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for QOSType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_qos_type_get_type()) }
    }
}

impl glib::value::ValueType for QOSType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for QOSType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for QOSType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstRank")]
pub enum Rank {
    #[doc(alias = "GST_RANK_NONE")]
    None,
    #[doc(alias = "GST_RANK_MARGINAL")]
    Marginal,
    #[doc(alias = "GST_RANK_SECONDARY")]
    Secondary,
    #[doc(alias = "GST_RANK_PRIMARY")]
    Primary,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for Rank {
    type GlibType = ffi::GstRank;

    fn into_glib(self) -> ffi::GstRank {
        match self {
            Self::None => ffi::GST_RANK_NONE,
            Self::Marginal => ffi::GST_RANK_MARGINAL,
            Self::Secondary => ffi::GST_RANK_SECONDARY,
            Self::Primary => ffi::GST_RANK_PRIMARY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstRank> for Rank {
    unsafe fn from_glib(value: ffi::GstRank) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_RANK_NONE => Self::None,
            ffi::GST_RANK_MARGINAL => Self::Marginal,
            ffi::GST_RANK_SECONDARY => Self::Secondary,
            ffi::GST_RANK_PRIMARY => Self::Primary,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Rank {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_rank_get_type()) }
    }
}

impl glib::value::ValueType for Rank {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Rank {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Rank {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstResourceError")]
pub enum ResourceError {
    #[doc(alias = "GST_RESOURCE_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_RESOURCE_ERROR_TOO_LAZY")]
    TooLazy,
    #[doc(alias = "GST_RESOURCE_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "GST_RESOURCE_ERROR_BUSY")]
    Busy,
    #[doc(alias = "GST_RESOURCE_ERROR_OPEN_READ")]
    OpenRead,
    #[doc(alias = "GST_RESOURCE_ERROR_OPEN_WRITE")]
    OpenWrite,
    #[doc(alias = "GST_RESOURCE_ERROR_OPEN_READ_WRITE")]
    OpenReadWrite,
    #[doc(alias = "GST_RESOURCE_ERROR_CLOSE")]
    Close,
    #[doc(alias = "GST_RESOURCE_ERROR_READ")]
    Read,
    #[doc(alias = "GST_RESOURCE_ERROR_WRITE")]
    Write,
    #[doc(alias = "GST_RESOURCE_ERROR_SEEK")]
    Seek,
    #[doc(alias = "GST_RESOURCE_ERROR_SYNC")]
    Sync,
    #[doc(alias = "GST_RESOURCE_ERROR_SETTINGS")]
    Settings,
    #[doc(alias = "GST_RESOURCE_ERROR_NO_SPACE_LEFT")]
    NoSpaceLeft,
    #[doc(alias = "GST_RESOURCE_ERROR_NOT_AUTHORIZED")]
    NotAuthorized,
    #[doc(alias = "GST_RESOURCE_ERROR_NUM_ERRORS")]
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ResourceError {
    type GlibType = ffi::GstResourceError;

    fn into_glib(self) -> ffi::GstResourceError {
        match self {
            Self::Failed => ffi::GST_RESOURCE_ERROR_FAILED,
            Self::TooLazy => ffi::GST_RESOURCE_ERROR_TOO_LAZY,
            Self::NotFound => ffi::GST_RESOURCE_ERROR_NOT_FOUND,
            Self::Busy => ffi::GST_RESOURCE_ERROR_BUSY,
            Self::OpenRead => ffi::GST_RESOURCE_ERROR_OPEN_READ,
            Self::OpenWrite => ffi::GST_RESOURCE_ERROR_OPEN_WRITE,
            Self::OpenReadWrite => ffi::GST_RESOURCE_ERROR_OPEN_READ_WRITE,
            Self::Close => ffi::GST_RESOURCE_ERROR_CLOSE,
            Self::Read => ffi::GST_RESOURCE_ERROR_READ,
            Self::Write => ffi::GST_RESOURCE_ERROR_WRITE,
            Self::Seek => ffi::GST_RESOURCE_ERROR_SEEK,
            Self::Sync => ffi::GST_RESOURCE_ERROR_SYNC,
            Self::Settings => ffi::GST_RESOURCE_ERROR_SETTINGS,
            Self::NoSpaceLeft => ffi::GST_RESOURCE_ERROR_NO_SPACE_LEFT,
            Self::NotAuthorized => ffi::GST_RESOURCE_ERROR_NOT_AUTHORIZED,
            Self::NumErrors => ffi::GST_RESOURCE_ERROR_NUM_ERRORS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstResourceError> for ResourceError {
    unsafe fn from_glib(value: ffi::GstResourceError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_RESOURCE_ERROR_FAILED => Self::Failed,
            ffi::GST_RESOURCE_ERROR_TOO_LAZY => Self::TooLazy,
            ffi::GST_RESOURCE_ERROR_NOT_FOUND => Self::NotFound,
            ffi::GST_RESOURCE_ERROR_BUSY => Self::Busy,
            ffi::GST_RESOURCE_ERROR_OPEN_READ => Self::OpenRead,
            ffi::GST_RESOURCE_ERROR_OPEN_WRITE => Self::OpenWrite,
            ffi::GST_RESOURCE_ERROR_OPEN_READ_WRITE => Self::OpenReadWrite,
            ffi::GST_RESOURCE_ERROR_CLOSE => Self::Close,
            ffi::GST_RESOURCE_ERROR_READ => Self::Read,
            ffi::GST_RESOURCE_ERROR_WRITE => Self::Write,
            ffi::GST_RESOURCE_ERROR_SEEK => Self::Seek,
            ffi::GST_RESOURCE_ERROR_SYNC => Self::Sync,
            ffi::GST_RESOURCE_ERROR_SETTINGS => Self::Settings,
            ffi::GST_RESOURCE_ERROR_NO_SPACE_LEFT => Self::NoSpaceLeft,
            ffi::GST_RESOURCE_ERROR_NOT_AUTHORIZED => Self::NotAuthorized,
            ffi::GST_RESOURCE_ERROR_NUM_ERRORS => Self::NumErrors,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for ResourceError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_resource_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_RESOURCE_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_RESOURCE_ERROR_TOO_LAZY => Some(Self::TooLazy),
            ffi::GST_RESOURCE_ERROR_NOT_FOUND => Some(Self::NotFound),
            ffi::GST_RESOURCE_ERROR_BUSY => Some(Self::Busy),
            ffi::GST_RESOURCE_ERROR_OPEN_READ => Some(Self::OpenRead),
            ffi::GST_RESOURCE_ERROR_OPEN_WRITE => Some(Self::OpenWrite),
            ffi::GST_RESOURCE_ERROR_OPEN_READ_WRITE => Some(Self::OpenReadWrite),
            ffi::GST_RESOURCE_ERROR_CLOSE => Some(Self::Close),
            ffi::GST_RESOURCE_ERROR_READ => Some(Self::Read),
            ffi::GST_RESOURCE_ERROR_WRITE => Some(Self::Write),
            ffi::GST_RESOURCE_ERROR_SEEK => Some(Self::Seek),
            ffi::GST_RESOURCE_ERROR_SYNC => Some(Self::Sync),
            ffi::GST_RESOURCE_ERROR_SETTINGS => Some(Self::Settings),
            ffi::GST_RESOURCE_ERROR_NO_SPACE_LEFT => Some(Self::NoSpaceLeft),
            ffi::GST_RESOURCE_ERROR_NOT_AUTHORIZED => Some(Self::NotAuthorized),
            ffi::GST_RESOURCE_ERROR_NUM_ERRORS => Some(Self::NumErrors),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for ResourceError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_resource_error_get_type()) }
    }
}

impl glib::value::ValueType for ResourceError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ResourceError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ResourceError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstSeekType")]
pub enum SeekType {
    #[doc(alias = "GST_SEEK_TYPE_NONE")]
    None,
    #[doc(alias = "GST_SEEK_TYPE_SET")]
    Set,
    #[doc(alias = "GST_SEEK_TYPE_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SeekType {
    type GlibType = ffi::GstSeekType;

    fn into_glib(self) -> ffi::GstSeekType {
        match self {
            Self::None => ffi::GST_SEEK_TYPE_NONE,
            Self::Set => ffi::GST_SEEK_TYPE_SET,
            Self::End => ffi::GST_SEEK_TYPE_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstSeekType> for SeekType {
    unsafe fn from_glib(value: ffi::GstSeekType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_SEEK_TYPE_NONE => Self::None,
            ffi::GST_SEEK_TYPE_SET => Self::Set,
            ffi::GST_SEEK_TYPE_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SeekType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_seek_type_get_type()) }
    }
}

impl glib::value::ValueType for SeekType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SeekType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SeekType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstState")]
pub enum State {
    #[doc(alias = "GST_STATE_VOID_PENDING")]
    VoidPending,
    #[doc(alias = "GST_STATE_NULL")]
    Null,
    #[doc(alias = "GST_STATE_READY")]
    Ready,
    #[doc(alias = "GST_STATE_PAUSED")]
    Paused,
    #[doc(alias = "GST_STATE_PLAYING")]
    Playing,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for State {
    type GlibType = ffi::GstState;

    fn into_glib(self) -> ffi::GstState {
        match self {
            Self::VoidPending => ffi::GST_STATE_VOID_PENDING,
            Self::Null => ffi::GST_STATE_NULL,
            Self::Ready => ffi::GST_STATE_READY,
            Self::Paused => ffi::GST_STATE_PAUSED,
            Self::Playing => ffi::GST_STATE_PLAYING,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstState> for State {
    unsafe fn from_glib(value: ffi::GstState) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STATE_VOID_PENDING => Self::VoidPending,
            ffi::GST_STATE_NULL => Self::Null,
            ffi::GST_STATE_READY => Self::Ready,
            ffi::GST_STATE_PAUSED => Self::Paused,
            ffi::GST_STATE_PLAYING => Self::Playing,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for State {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_state_get_type()) }
    }
}

impl glib::value::ValueType for State {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for State {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for State {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstStateChange")]
pub enum StateChange {
    #[doc(alias = "GST_STATE_CHANGE_NULL_TO_READY")]
    NullToReady,
    #[doc(alias = "GST_STATE_CHANGE_READY_TO_PAUSED")]
    ReadyToPaused,
    #[doc(alias = "GST_STATE_CHANGE_PAUSED_TO_PLAYING")]
    PausedToPlaying,
    #[doc(alias = "GST_STATE_CHANGE_PLAYING_TO_PAUSED")]
    PlayingToPaused,
    #[doc(alias = "GST_STATE_CHANGE_PAUSED_TO_READY")]
    PausedToReady,
    #[doc(alias = "GST_STATE_CHANGE_READY_TO_NULL")]
    ReadyToNull,
    #[doc(alias = "GST_STATE_CHANGE_NULL_TO_NULL")]
    NullToNull,
    #[doc(alias = "GST_STATE_CHANGE_READY_TO_READY")]
    ReadyToReady,
    #[doc(alias = "GST_STATE_CHANGE_PAUSED_TO_PAUSED")]
    PausedToPaused,
    #[doc(alias = "GST_STATE_CHANGE_PLAYING_TO_PLAYING")]
    PlayingToPlaying,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StateChange {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.name())
    }
}

#[doc(hidden)]
impl IntoGlib for StateChange {
    type GlibType = ffi::GstStateChange;

    fn into_glib(self) -> ffi::GstStateChange {
        match self {
            Self::NullToReady => ffi::GST_STATE_CHANGE_NULL_TO_READY,
            Self::ReadyToPaused => ffi::GST_STATE_CHANGE_READY_TO_PAUSED,
            Self::PausedToPlaying => ffi::GST_STATE_CHANGE_PAUSED_TO_PLAYING,
            Self::PlayingToPaused => ffi::GST_STATE_CHANGE_PLAYING_TO_PAUSED,
            Self::PausedToReady => ffi::GST_STATE_CHANGE_PAUSED_TO_READY,
            Self::ReadyToNull => ffi::GST_STATE_CHANGE_READY_TO_NULL,
            Self::NullToNull => ffi::GST_STATE_CHANGE_NULL_TO_NULL,
            Self::ReadyToReady => ffi::GST_STATE_CHANGE_READY_TO_READY,
            Self::PausedToPaused => ffi::GST_STATE_CHANGE_PAUSED_TO_PAUSED,
            Self::PlayingToPlaying => ffi::GST_STATE_CHANGE_PLAYING_TO_PLAYING,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstStateChange> for StateChange {
    unsafe fn from_glib(value: ffi::GstStateChange) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STATE_CHANGE_NULL_TO_READY => Self::NullToReady,
            ffi::GST_STATE_CHANGE_READY_TO_PAUSED => Self::ReadyToPaused,
            ffi::GST_STATE_CHANGE_PAUSED_TO_PLAYING => Self::PausedToPlaying,
            ffi::GST_STATE_CHANGE_PLAYING_TO_PAUSED => Self::PlayingToPaused,
            ffi::GST_STATE_CHANGE_PAUSED_TO_READY => Self::PausedToReady,
            ffi::GST_STATE_CHANGE_READY_TO_NULL => Self::ReadyToNull,
            ffi::GST_STATE_CHANGE_NULL_TO_NULL => Self::NullToNull,
            ffi::GST_STATE_CHANGE_READY_TO_READY => Self::ReadyToReady,
            ffi::GST_STATE_CHANGE_PAUSED_TO_PAUSED => Self::PausedToPaused,
            ffi::GST_STATE_CHANGE_PLAYING_TO_PLAYING => Self::PlayingToPlaying,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StateChange {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_state_change_get_type()) }
    }
}

impl glib::value::ValueType for StateChange {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StateChange {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StateChange {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[must_use]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstStateChangeReturn")]
pub enum StateChangeReturn {
    #[doc(alias = "GST_STATE_CHANGE_FAILURE")]
    Failure,
    #[doc(alias = "GST_STATE_CHANGE_SUCCESS")]
    Success,
    #[doc(alias = "GST_STATE_CHANGE_ASYNC")]
    Async,
    #[doc(alias = "GST_STATE_CHANGE_NO_PREROLL")]
    NoPreroll,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for StateChangeReturn {
    type GlibType = ffi::GstStateChangeReturn;

    fn into_glib(self) -> ffi::GstStateChangeReturn {
        match self {
            Self::Failure => ffi::GST_STATE_CHANGE_FAILURE,
            Self::Success => ffi::GST_STATE_CHANGE_SUCCESS,
            Self::Async => ffi::GST_STATE_CHANGE_ASYNC,
            Self::NoPreroll => ffi::GST_STATE_CHANGE_NO_PREROLL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstStateChangeReturn> for StateChangeReturn {
    unsafe fn from_glib(value: ffi::GstStateChangeReturn) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STATE_CHANGE_FAILURE => Self::Failure,
            ffi::GST_STATE_CHANGE_SUCCESS => Self::Success,
            ffi::GST_STATE_CHANGE_ASYNC => Self::Async,
            ffi::GST_STATE_CHANGE_NO_PREROLL => Self::NoPreroll,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StateChangeReturn {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_state_change_return_get_type()) }
    }
}

impl glib::value::ValueType for StateChangeReturn {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StateChangeReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StateChangeReturn {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstStreamError")]
pub enum StreamError {
    #[doc(alias = "GST_STREAM_ERROR_FAILED")]
    Failed,
    #[doc(alias = "GST_STREAM_ERROR_TOO_LAZY")]
    TooLazy,
    #[doc(alias = "GST_STREAM_ERROR_NOT_IMPLEMENTED")]
    NotImplemented,
    #[doc(alias = "GST_STREAM_ERROR_TYPE_NOT_FOUND")]
    TypeNotFound,
    #[doc(alias = "GST_STREAM_ERROR_WRONG_TYPE")]
    WrongType,
    #[doc(alias = "GST_STREAM_ERROR_CODEC_NOT_FOUND")]
    CodecNotFound,
    #[doc(alias = "GST_STREAM_ERROR_DECODE")]
    Decode,
    #[doc(alias = "GST_STREAM_ERROR_ENCODE")]
    Encode,
    #[doc(alias = "GST_STREAM_ERROR_DEMUX")]
    Demux,
    #[doc(alias = "GST_STREAM_ERROR_MUX")]
    Mux,
    #[doc(alias = "GST_STREAM_ERROR_FORMAT")]
    Format,
    #[doc(alias = "GST_STREAM_ERROR_DECRYPT")]
    Decrypt,
    #[doc(alias = "GST_STREAM_ERROR_DECRYPT_NOKEY")]
    DecryptNokey,
    #[doc(alias = "GST_STREAM_ERROR_NUM_ERRORS")]
    NumErrors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for StreamError {
    type GlibType = ffi::GstStreamError;

    fn into_glib(self) -> ffi::GstStreamError {
        match self {
            Self::Failed => ffi::GST_STREAM_ERROR_FAILED,
            Self::TooLazy => ffi::GST_STREAM_ERROR_TOO_LAZY,
            Self::NotImplemented => ffi::GST_STREAM_ERROR_NOT_IMPLEMENTED,
            Self::TypeNotFound => ffi::GST_STREAM_ERROR_TYPE_NOT_FOUND,
            Self::WrongType => ffi::GST_STREAM_ERROR_WRONG_TYPE,
            Self::CodecNotFound => ffi::GST_STREAM_ERROR_CODEC_NOT_FOUND,
            Self::Decode => ffi::GST_STREAM_ERROR_DECODE,
            Self::Encode => ffi::GST_STREAM_ERROR_ENCODE,
            Self::Demux => ffi::GST_STREAM_ERROR_DEMUX,
            Self::Mux => ffi::GST_STREAM_ERROR_MUX,
            Self::Format => ffi::GST_STREAM_ERROR_FORMAT,
            Self::Decrypt => ffi::GST_STREAM_ERROR_DECRYPT,
            Self::DecryptNokey => ffi::GST_STREAM_ERROR_DECRYPT_NOKEY,
            Self::NumErrors => ffi::GST_STREAM_ERROR_NUM_ERRORS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstStreamError> for StreamError {
    unsafe fn from_glib(value: ffi::GstStreamError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STREAM_ERROR_FAILED => Self::Failed,
            ffi::GST_STREAM_ERROR_TOO_LAZY => Self::TooLazy,
            ffi::GST_STREAM_ERROR_NOT_IMPLEMENTED => Self::NotImplemented,
            ffi::GST_STREAM_ERROR_TYPE_NOT_FOUND => Self::TypeNotFound,
            ffi::GST_STREAM_ERROR_WRONG_TYPE => Self::WrongType,
            ffi::GST_STREAM_ERROR_CODEC_NOT_FOUND => Self::CodecNotFound,
            ffi::GST_STREAM_ERROR_DECODE => Self::Decode,
            ffi::GST_STREAM_ERROR_ENCODE => Self::Encode,
            ffi::GST_STREAM_ERROR_DEMUX => Self::Demux,
            ffi::GST_STREAM_ERROR_MUX => Self::Mux,
            ffi::GST_STREAM_ERROR_FORMAT => Self::Format,
            ffi::GST_STREAM_ERROR_DECRYPT => Self::Decrypt,
            ffi::GST_STREAM_ERROR_DECRYPT_NOKEY => Self::DecryptNokey,
            ffi::GST_STREAM_ERROR_NUM_ERRORS => Self::NumErrors,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for StreamError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_stream_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_STREAM_ERROR_FAILED => Some(Self::Failed),
            ffi::GST_STREAM_ERROR_TOO_LAZY => Some(Self::TooLazy),
            ffi::GST_STREAM_ERROR_NOT_IMPLEMENTED => Some(Self::NotImplemented),
            ffi::GST_STREAM_ERROR_TYPE_NOT_FOUND => Some(Self::TypeNotFound),
            ffi::GST_STREAM_ERROR_WRONG_TYPE => Some(Self::WrongType),
            ffi::GST_STREAM_ERROR_CODEC_NOT_FOUND => Some(Self::CodecNotFound),
            ffi::GST_STREAM_ERROR_DECODE => Some(Self::Decode),
            ffi::GST_STREAM_ERROR_ENCODE => Some(Self::Encode),
            ffi::GST_STREAM_ERROR_DEMUX => Some(Self::Demux),
            ffi::GST_STREAM_ERROR_MUX => Some(Self::Mux),
            ffi::GST_STREAM_ERROR_FORMAT => Some(Self::Format),
            ffi::GST_STREAM_ERROR_DECRYPT => Some(Self::Decrypt),
            ffi::GST_STREAM_ERROR_DECRYPT_NOKEY => Some(Self::DecryptNokey),
            ffi::GST_STREAM_ERROR_NUM_ERRORS => Some(Self::NumErrors),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for StreamError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_stream_error_get_type()) }
    }
}

impl glib::value::ValueType for StreamError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StreamError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StreamError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstStreamStatusType")]
pub enum StreamStatusType {
    #[doc(alias = "GST_STREAM_STATUS_TYPE_CREATE")]
    Create,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_ENTER")]
    Enter,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_LEAVE")]
    Leave,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_DESTROY")]
    Destroy,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_START")]
    Start,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_PAUSE")]
    Pause,
    #[doc(alias = "GST_STREAM_STATUS_TYPE_STOP")]
    Stop,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for StreamStatusType {
    type GlibType = ffi::GstStreamStatusType;

    fn into_glib(self) -> ffi::GstStreamStatusType {
        match self {
            Self::Create => ffi::GST_STREAM_STATUS_TYPE_CREATE,
            Self::Enter => ffi::GST_STREAM_STATUS_TYPE_ENTER,
            Self::Leave => ffi::GST_STREAM_STATUS_TYPE_LEAVE,
            Self::Destroy => ffi::GST_STREAM_STATUS_TYPE_DESTROY,
            Self::Start => ffi::GST_STREAM_STATUS_TYPE_START,
            Self::Pause => ffi::GST_STREAM_STATUS_TYPE_PAUSE,
            Self::Stop => ffi::GST_STREAM_STATUS_TYPE_STOP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstStreamStatusType> for StreamStatusType {
    unsafe fn from_glib(value: ffi::GstStreamStatusType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STREAM_STATUS_TYPE_CREATE => Self::Create,
            ffi::GST_STREAM_STATUS_TYPE_ENTER => Self::Enter,
            ffi::GST_STREAM_STATUS_TYPE_LEAVE => Self::Leave,
            ffi::GST_STREAM_STATUS_TYPE_DESTROY => Self::Destroy,
            ffi::GST_STREAM_STATUS_TYPE_START => Self::Start,
            ffi::GST_STREAM_STATUS_TYPE_PAUSE => Self::Pause,
            ffi::GST_STREAM_STATUS_TYPE_STOP => Self::Stop,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StreamStatusType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_stream_status_type_get_type()) }
    }
}

impl glib::value::ValueType for StreamStatusType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StreamStatusType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StreamStatusType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstStructureChangeType")]
pub enum StructureChangeType {
    #[doc(alias = "GST_STRUCTURE_CHANGE_TYPE_PAD_LINK")]
    Link,
    #[doc(alias = "GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK")]
    Unlink,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for StructureChangeType {
    type GlibType = ffi::GstStructureChangeType;

    fn into_glib(self) -> ffi::GstStructureChangeType {
        match self {
            Self::Link => ffi::GST_STRUCTURE_CHANGE_TYPE_PAD_LINK,
            Self::Unlink => ffi::GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstStructureChangeType> for StructureChangeType {
    unsafe fn from_glib(value: ffi::GstStructureChangeType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_STRUCTURE_CHANGE_TYPE_PAD_LINK => Self::Link,
            ffi::GST_STRUCTURE_CHANGE_TYPE_PAD_UNLINK => Self::Unlink,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureChangeType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_structure_change_type_get_type()) }
    }
}

impl glib::value::ValueType for StructureChangeType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureChangeType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureChangeType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTagFlag")]
pub enum TagFlag {
    #[doc(alias = "GST_TAG_FLAG_UNDEFINED")]
    Undefined,
    #[doc(alias = "GST_TAG_FLAG_META")]
    Meta,
    #[doc(alias = "GST_TAG_FLAG_ENCODED")]
    Encoded,
    #[doc(alias = "GST_TAG_FLAG_DECODED")]
    Decoded,
    #[doc(alias = "GST_TAG_FLAG_COUNT")]
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TagFlag {
    type GlibType = ffi::GstTagFlag;

    fn into_glib(self) -> ffi::GstTagFlag {
        match self {
            Self::Undefined => ffi::GST_TAG_FLAG_UNDEFINED,
            Self::Meta => ffi::GST_TAG_FLAG_META,
            Self::Encoded => ffi::GST_TAG_FLAG_ENCODED,
            Self::Decoded => ffi::GST_TAG_FLAG_DECODED,
            Self::Count => ffi::GST_TAG_FLAG_COUNT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTagFlag> for TagFlag {
    unsafe fn from_glib(value: ffi::GstTagFlag) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TAG_FLAG_UNDEFINED => Self::Undefined,
            ffi::GST_TAG_FLAG_META => Self::Meta,
            ffi::GST_TAG_FLAG_ENCODED => Self::Encoded,
            ffi::GST_TAG_FLAG_DECODED => Self::Decoded,
            ffi::GST_TAG_FLAG_COUNT => Self::Count,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TagFlag {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_tag_flag_get_type()) }
    }
}

impl glib::value::ValueType for TagFlag {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TagFlag {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TagFlag {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTagMergeMode")]
pub enum TagMergeMode {
    #[doc(alias = "GST_TAG_MERGE_UNDEFINED")]
    Undefined,
    #[doc(alias = "GST_TAG_MERGE_REPLACE_ALL")]
    ReplaceAll,
    #[doc(alias = "GST_TAG_MERGE_REPLACE")]
    Replace,
    #[doc(alias = "GST_TAG_MERGE_APPEND")]
    Append,
    #[doc(alias = "GST_TAG_MERGE_PREPEND")]
    Prepend,
    #[doc(alias = "GST_TAG_MERGE_KEEP")]
    Keep,
    #[doc(alias = "GST_TAG_MERGE_KEEP_ALL")]
    KeepAll,
    #[doc(alias = "GST_TAG_MERGE_COUNT")]
    Count,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TagMergeMode {
    type GlibType = ffi::GstTagMergeMode;

    fn into_glib(self) -> ffi::GstTagMergeMode {
        match self {
            Self::Undefined => ffi::GST_TAG_MERGE_UNDEFINED,
            Self::ReplaceAll => ffi::GST_TAG_MERGE_REPLACE_ALL,
            Self::Replace => ffi::GST_TAG_MERGE_REPLACE,
            Self::Append => ffi::GST_TAG_MERGE_APPEND,
            Self::Prepend => ffi::GST_TAG_MERGE_PREPEND,
            Self::Keep => ffi::GST_TAG_MERGE_KEEP,
            Self::KeepAll => ffi::GST_TAG_MERGE_KEEP_ALL,
            Self::Count => ffi::GST_TAG_MERGE_COUNT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTagMergeMode> for TagMergeMode {
    unsafe fn from_glib(value: ffi::GstTagMergeMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TAG_MERGE_UNDEFINED => Self::Undefined,
            ffi::GST_TAG_MERGE_REPLACE_ALL => Self::ReplaceAll,
            ffi::GST_TAG_MERGE_REPLACE => Self::Replace,
            ffi::GST_TAG_MERGE_APPEND => Self::Append,
            ffi::GST_TAG_MERGE_PREPEND => Self::Prepend,
            ffi::GST_TAG_MERGE_KEEP => Self::Keep,
            ffi::GST_TAG_MERGE_KEEP_ALL => Self::KeepAll,
            ffi::GST_TAG_MERGE_COUNT => Self::Count,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TagMergeMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_tag_merge_mode_get_type()) }
    }
}

impl glib::value::ValueType for TagMergeMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TagMergeMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TagMergeMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTagScope")]
pub enum TagScope {
    #[doc(alias = "GST_TAG_SCOPE_STREAM")]
    Stream,
    #[doc(alias = "GST_TAG_SCOPE_GLOBAL")]
    Global,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TagScope {
    type GlibType = ffi::GstTagScope;

    fn into_glib(self) -> ffi::GstTagScope {
        match self {
            Self::Stream => ffi::GST_TAG_SCOPE_STREAM,
            Self::Global => ffi::GST_TAG_SCOPE_GLOBAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTagScope> for TagScope {
    unsafe fn from_glib(value: ffi::GstTagScope) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TAG_SCOPE_STREAM => Self::Stream,
            ffi::GST_TAG_SCOPE_GLOBAL => Self::Global,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TagScope {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_tag_scope_get_type()) }
    }
}

impl glib::value::ValueType for TagScope {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TagScope {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TagScope {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTaskState")]
pub enum TaskState {
    #[doc(alias = "GST_TASK_STARTED")]
    Started,
    #[doc(alias = "GST_TASK_STOPPED")]
    Stopped,
    #[doc(alias = "GST_TASK_PAUSED")]
    Paused,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TaskState {
    type GlibType = ffi::GstTaskState;

    fn into_glib(self) -> ffi::GstTaskState {
        match self {
            Self::Started => ffi::GST_TASK_STARTED,
            Self::Stopped => ffi::GST_TASK_STOPPED,
            Self::Paused => ffi::GST_TASK_PAUSED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTaskState> for TaskState {
    unsafe fn from_glib(value: ffi::GstTaskState) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TASK_STARTED => Self::Started,
            ffi::GST_TASK_STOPPED => Self::Stopped,
            ffi::GST_TASK_PAUSED => Self::Paused,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TaskState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_task_state_get_type()) }
    }
}

impl glib::value::ValueType for TaskState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TaskState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TaskState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTocEntryType")]
pub enum TocEntryType {
    #[doc(alias = "GST_TOC_ENTRY_TYPE_ANGLE")]
    Angle,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_VERSION")]
    Version,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_EDITION")]
    Edition,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_INVALID")]
    Invalid,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_TITLE")]
    Title,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_TRACK")]
    Track,
    #[doc(alias = "GST_TOC_ENTRY_TYPE_CHAPTER")]
    Chapter,
    #[doc(hidden)]
    __Unknown(i32),
}

impl TocEntryType {
    pub fn nick<'a>(self) -> &'a str {
        unsafe {
            CStr::from_ptr(
                ffi::gst_toc_entry_type_get_nick(self.into_glib())
                    .as_ref()
                    .expect("gst_toc_entry_type_get_nick returned NULL"),
            )
            .to_str()
            .expect("gst_toc_entry_type_get_nick returned an invalid string")
        }
    }
}

#[doc(hidden)]
impl IntoGlib for TocEntryType {
    type GlibType = ffi::GstTocEntryType;

    fn into_glib(self) -> ffi::GstTocEntryType {
        match self {
            Self::Angle => ffi::GST_TOC_ENTRY_TYPE_ANGLE,
            Self::Version => ffi::GST_TOC_ENTRY_TYPE_VERSION,
            Self::Edition => ffi::GST_TOC_ENTRY_TYPE_EDITION,
            Self::Invalid => ffi::GST_TOC_ENTRY_TYPE_INVALID,
            Self::Title => ffi::GST_TOC_ENTRY_TYPE_TITLE,
            Self::Track => ffi::GST_TOC_ENTRY_TYPE_TRACK,
            Self::Chapter => ffi::GST_TOC_ENTRY_TYPE_CHAPTER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTocEntryType> for TocEntryType {
    unsafe fn from_glib(value: ffi::GstTocEntryType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TOC_ENTRY_TYPE_ANGLE => Self::Angle,
            ffi::GST_TOC_ENTRY_TYPE_VERSION => Self::Version,
            ffi::GST_TOC_ENTRY_TYPE_EDITION => Self::Edition,
            ffi::GST_TOC_ENTRY_TYPE_INVALID => Self::Invalid,
            ffi::GST_TOC_ENTRY_TYPE_TITLE => Self::Title,
            ffi::GST_TOC_ENTRY_TYPE_TRACK => Self::Track,
            ffi::GST_TOC_ENTRY_TYPE_CHAPTER => Self::Chapter,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TocEntryType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_toc_entry_type_get_type()) }
    }
}

impl glib::value::ValueType for TocEntryType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TocEntryType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TocEntryType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTocLoopType")]
pub enum TocLoopType {
    #[doc(alias = "GST_TOC_LOOP_NONE")]
    None,
    #[doc(alias = "GST_TOC_LOOP_FORWARD")]
    Forward,
    #[doc(alias = "GST_TOC_LOOP_REVERSE")]
    Reverse,
    #[doc(alias = "GST_TOC_LOOP_PING_PONG")]
    PingPong,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TocLoopType {
    type GlibType = ffi::GstTocLoopType;

    fn into_glib(self) -> ffi::GstTocLoopType {
        match self {
            Self::None => ffi::GST_TOC_LOOP_NONE,
            Self::Forward => ffi::GST_TOC_LOOP_FORWARD,
            Self::Reverse => ffi::GST_TOC_LOOP_REVERSE,
            Self::PingPong => ffi::GST_TOC_LOOP_PING_PONG,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTocLoopType> for TocLoopType {
    unsafe fn from_glib(value: ffi::GstTocLoopType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TOC_LOOP_NONE => Self::None,
            ffi::GST_TOC_LOOP_FORWARD => Self::Forward,
            ffi::GST_TOC_LOOP_REVERSE => Self::Reverse,
            ffi::GST_TOC_LOOP_PING_PONG => Self::PingPong,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TocLoopType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_toc_loop_type_get_type()) }
    }
}

impl glib::value::ValueType for TocLoopType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TocLoopType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TocLoopType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTocScope")]
pub enum TocScope {
    #[doc(alias = "GST_TOC_SCOPE_GLOBAL")]
    Global,
    #[doc(alias = "GST_TOC_SCOPE_CURRENT")]
    Current,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TocScope {
    type GlibType = ffi::GstTocScope;

    fn into_glib(self) -> ffi::GstTocScope {
        match self {
            Self::Global => ffi::GST_TOC_SCOPE_GLOBAL,
            Self::Current => ffi::GST_TOC_SCOPE_CURRENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTocScope> for TocScope {
    unsafe fn from_glib(value: ffi::GstTocScope) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TOC_SCOPE_GLOBAL => Self::Global,
            ffi::GST_TOC_SCOPE_CURRENT => Self::Current,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TocScope {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_toc_scope_get_type()) }
    }
}

impl glib::value::ValueType for TocScope {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TocScope {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TocScope {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstTypeFindProbability")]
pub enum TypeFindProbability {
    #[doc(alias = "GST_TYPE_FIND_NONE")]
    None,
    #[doc(alias = "GST_TYPE_FIND_MINIMUM")]
    Minimum,
    #[doc(alias = "GST_TYPE_FIND_POSSIBLE")]
    Possible,
    #[doc(alias = "GST_TYPE_FIND_LIKELY")]
    Likely,
    #[doc(alias = "GST_TYPE_FIND_NEARLY_CERTAIN")]
    NearlyCertain,
    #[doc(alias = "GST_TYPE_FIND_MAXIMUM")]
    Maximum,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TypeFindProbability {
    type GlibType = ffi::GstTypeFindProbability;

    fn into_glib(self) -> ffi::GstTypeFindProbability {
        match self {
            Self::None => ffi::GST_TYPE_FIND_NONE,
            Self::Minimum => ffi::GST_TYPE_FIND_MINIMUM,
            Self::Possible => ffi::GST_TYPE_FIND_POSSIBLE,
            Self::Likely => ffi::GST_TYPE_FIND_LIKELY,
            Self::NearlyCertain => ffi::GST_TYPE_FIND_NEARLY_CERTAIN,
            Self::Maximum => ffi::GST_TYPE_FIND_MAXIMUM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstTypeFindProbability> for TypeFindProbability {
    unsafe fn from_glib(value: ffi::GstTypeFindProbability) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_TYPE_FIND_NONE => Self::None,
            ffi::GST_TYPE_FIND_MINIMUM => Self::Minimum,
            ffi::GST_TYPE_FIND_POSSIBLE => Self::Possible,
            ffi::GST_TYPE_FIND_LIKELY => Self::Likely,
            ffi::GST_TYPE_FIND_NEARLY_CERTAIN => Self::NearlyCertain,
            ffi::GST_TYPE_FIND_MAXIMUM => Self::Maximum,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TypeFindProbability {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_type_find_probability_get_type()) }
    }
}

impl glib::value::ValueType for TypeFindProbability {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TypeFindProbability {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TypeFindProbability {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstURIError")]
pub enum URIError {
    #[doc(alias = "GST_URI_ERROR_UNSUPPORTED_PROTOCOL")]
    UnsupportedProtocol,
    #[doc(alias = "GST_URI_ERROR_BAD_URI")]
    BadUri,
    #[doc(alias = "GST_URI_ERROR_BAD_STATE")]
    BadState,
    #[doc(alias = "GST_URI_ERROR_BAD_REFERENCE")]
    BadReference,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for URIError {
    type GlibType = ffi::GstURIError;

    fn into_glib(self) -> ffi::GstURIError {
        match self {
            Self::UnsupportedProtocol => ffi::GST_URI_ERROR_UNSUPPORTED_PROTOCOL,
            Self::BadUri => ffi::GST_URI_ERROR_BAD_URI,
            Self::BadState => ffi::GST_URI_ERROR_BAD_STATE,
            Self::BadReference => ffi::GST_URI_ERROR_BAD_REFERENCE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstURIError> for URIError {
    unsafe fn from_glib(value: ffi::GstURIError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_URI_ERROR_UNSUPPORTED_PROTOCOL => Self::UnsupportedProtocol,
            ffi::GST_URI_ERROR_BAD_URI => Self::BadUri,
            ffi::GST_URI_ERROR_BAD_STATE => Self::BadState,
            ffi::GST_URI_ERROR_BAD_REFERENCE => Self::BadReference,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for URIError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gst_uri_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GST_URI_ERROR_UNSUPPORTED_PROTOCOL => Some(Self::UnsupportedProtocol),
            ffi::GST_URI_ERROR_BAD_URI => Some(Self::BadUri),
            ffi::GST_URI_ERROR_BAD_STATE => Some(Self::BadState),
            ffi::GST_URI_ERROR_BAD_REFERENCE => Some(Self::BadReference),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for URIError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_uri_error_get_type()) }
    }
}

impl glib::value::ValueType for URIError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for URIError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for URIError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg_attr(feature = "ser_de", derive(serde::Serialize, serde::Deserialize))]
#[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GstURIType")]
pub enum URIType {
    #[doc(alias = "GST_URI_UNKNOWN")]
    Unknown,
    #[doc(alias = "GST_URI_SINK")]
    Sink,
    #[doc(alias = "GST_URI_SRC")]
    Src,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for URIType {
    type GlibType = ffi::GstURIType;

    fn into_glib(self) -> ffi::GstURIType {
        match self {
            Self::Unknown => ffi::GST_URI_UNKNOWN,
            Self::Sink => ffi::GST_URI_SINK,
            Self::Src => ffi::GST_URI_SRC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GstURIType> for URIType {
    unsafe fn from_glib(value: ffi::GstURIType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GST_URI_UNKNOWN => Self::Unknown,
            ffi::GST_URI_SINK => Self::Sink,
            ffi::GST_URI_SRC => Self::Src,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for URIType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gst_uri_type_get_type()) }
    }
}

impl glib::value::ValueType for URIType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for URIType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for URIType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
