// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Range;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "AtkValue")]
    pub struct Value(Interface<ffi::AtkValue, ffi::AtkValueIface>);

    match fn {
        type_ => || ffi::atk_value_get_type(),
    }
}

impl Value {
    pub const NONE: Option<&'static Value> = None;
}

pub trait ValueExt: 'static {
    #[doc(alias = "atk_value_get_current_value")]
    #[doc(alias = "get_current_value")]
    fn current_value(&self) -> glib::Value;

    #[doc(alias = "atk_value_get_increment")]
    #[doc(alias = "get_increment")]
    fn increment(&self) -> f64;

    #[doc(alias = "atk_value_get_maximum_value")]
    #[doc(alias = "get_maximum_value")]
    fn maximum_value(&self) -> glib::Value;

    #[doc(alias = "atk_value_get_minimum_increment")]
    #[doc(alias = "get_minimum_increment")]
    fn minimum_increment(&self) -> glib::Value;

    #[doc(alias = "atk_value_get_minimum_value")]
    #[doc(alias = "get_minimum_value")]
    fn minimum_value(&self) -> glib::Value;

    #[doc(alias = "atk_value_get_range")]
    #[doc(alias = "get_range")]
    fn range(&self) -> Option<Range>;

    #[doc(alias = "atk_value_get_sub_ranges")]
    #[doc(alias = "get_sub_ranges")]
    fn sub_ranges(&self) -> Vec<Range>;

    #[doc(alias = "atk_value_get_value_and_text")]
    #[doc(alias = "get_value_and_text")]
    fn value_and_text(&self) -> (f64, glib::GString);

    #[doc(alias = "atk_value_set_current_value")]
    fn set_current_value(&self, value: &glib::Value) -> bool;

    #[doc(alias = "atk_value_set_value")]
    fn set_value(&self, new_value: f64);

    #[doc(alias = "value-changed")]
    fn connect_value_changed<F: Fn(&Self, f64, &str) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Value>> ValueExt for O {
    fn current_value(&self) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            ffi::atk_value_get_current_value(
                self.as_ref().to_glib_none().0,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    fn increment(&self) -> f64 {
        unsafe { ffi::atk_value_get_increment(self.as_ref().to_glib_none().0) }
    }

    fn maximum_value(&self) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            ffi::atk_value_get_maximum_value(
                self.as_ref().to_glib_none().0,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    fn minimum_increment(&self) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            ffi::atk_value_get_minimum_increment(
                self.as_ref().to_glib_none().0,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    fn minimum_value(&self) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            ffi::atk_value_get_minimum_value(
                self.as_ref().to_glib_none().0,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    fn range(&self) -> Option<Range> {
        unsafe { from_glib_full(ffi::atk_value_get_range(self.as_ref().to_glib_none().0)) }
    }

    fn sub_ranges(&self) -> Vec<Range> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::atk_value_get_sub_ranges(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn value_and_text(&self) -> (f64, glib::GString) {
        unsafe {
            let mut value = mem::MaybeUninit::uninit();
            let mut text = ptr::null_mut();
            ffi::atk_value_get_value_and_text(
                self.as_ref().to_glib_none().0,
                value.as_mut_ptr(),
                &mut text,
            );
            let value = value.assume_init();
            (value, from_glib_full(text))
        }
    }

    fn set_current_value(&self, value: &glib::Value) -> bool {
        unsafe {
            from_glib(ffi::atk_value_set_current_value(
                self.as_ref().to_glib_none().0,
                value.to_glib_none().0,
            ))
        }
    }

    fn set_value(&self, new_value: f64) {
        unsafe {
            ffi::atk_value_set_value(self.as_ref().to_glib_none().0, new_value);
        }
    }

    fn connect_value_changed<F: Fn(&Self, f64, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn value_changed_trampoline<
            P: IsA<Value>,
            F: Fn(&P, f64, &str) + 'static,
        >(
            this: *mut ffi::AtkValue,
            value: libc::c_double,
            text: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Value::from_glib_borrow(this).unsafe_cast_ref(),
                value,
                &glib::GString::from_glib_borrow(text),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"value-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    value_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Value {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Value")
    }
}
