// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use gdk_pixbuf;
use gdk_sys;
use gio;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::value::SetValueOptional;
use glib::GString;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use libc;
use pango;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use Adjustment;
use Align;
use Buildable;
use CellEditable;
use Container;
use DeleteType;
use Editable;
use EntryBuffer;
use EntryCompletion;
use EntryIconPosition;
use ImageType;
use InputHints;
use InputPurpose;
use MovementStep;
use ShadowType;
use TargetList;
use Widget;

glib_wrapper! {
    pub struct Entry(Object<gtk_sys::GtkEntry, gtk_sys::GtkEntryClass, EntryClass>) @extends Widget, @implements Buildable, CellEditable, Editable;

    match fn {
        get_type => || gtk_sys::gtk_entry_get_type(),
    }
}

impl Entry {
    pub fn new() -> Entry {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(gtk_sys::gtk_entry_new()).unsafe_cast() }
    }

    pub fn new_with_buffer<P: IsA<EntryBuffer>>(buffer: &P) -> Entry {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(gtk_sys::gtk_entry_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

impl Default for Entry {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
pub struct EntryBuilder {
    activates_default: Option<bool>,
    attributes: Option<pango::AttrList>,
    buffer: Option<EntryBuffer>,
    caps_lock_warning: Option<bool>,
    completion: Option<EntryCompletion>,
    editable: Option<bool>,
    enable_emoji_completion: Option<bool>,
    has_frame: Option<bool>,
    im_module: Option<String>,
    input_hints: Option<InputHints>,
    input_purpose: Option<InputPurpose>,
    invisible_char: Option<u32>,
    invisible_char_set: Option<bool>,
    max_length: Option<i32>,
    max_width_chars: Option<i32>,
    overwrite_mode: Option<bool>,
    placeholder_text: Option<String>,
    populate_all: Option<bool>,
    primary_icon_activatable: Option<bool>,
    primary_icon_gicon: Option<gio::Icon>,
    primary_icon_name: Option<String>,
    primary_icon_pixbuf: Option<gdk_pixbuf::Pixbuf>,
    primary_icon_sensitive: Option<bool>,
    primary_icon_tooltip_markup: Option<String>,
    primary_icon_tooltip_text: Option<String>,
    progress_fraction: Option<f64>,
    progress_pulse_step: Option<f64>,
    secondary_icon_activatable: Option<bool>,
    secondary_icon_gicon: Option<gio::Icon>,
    secondary_icon_name: Option<String>,
    secondary_icon_pixbuf: Option<gdk_pixbuf::Pixbuf>,
    secondary_icon_sensitive: Option<bool>,
    secondary_icon_tooltip_markup: Option<String>,
    secondary_icon_tooltip_text: Option<String>,
    shadow_type: Option<ShadowType>,
    show_emoji_icon: Option<bool>,
    tabs: Option<pango::TabArray>,
    text: Option<String>,
    truncate_multiline: Option<bool>,
    visibility: Option<bool>,
    width_chars: Option<i32>,
    xalign: Option<f32>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    editing_canceled: Option<bool>,
}

impl EntryBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> Entry {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref activates_default) = self.activates_default {
            properties.push(("activates-default", activates_default));
        }
        if let Some(ref attributes) = self.attributes {
            properties.push(("attributes", attributes));
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref caps_lock_warning) = self.caps_lock_warning {
            properties.push(("caps-lock-warning", caps_lock_warning));
        }
        if let Some(ref completion) = self.completion {
            properties.push(("completion", completion));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref enable_emoji_completion) = self.enable_emoji_completion {
            properties.push(("enable-emoji-completion", enable_emoji_completion));
        }
        if let Some(ref has_frame) = self.has_frame {
            properties.push(("has-frame", has_frame));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref invisible_char) = self.invisible_char {
            properties.push(("invisible-char", invisible_char));
        }
        if let Some(ref invisible_char_set) = self.invisible_char_set {
            properties.push(("invisible-char-set", invisible_char_set));
        }
        if let Some(ref max_length) = self.max_length {
            properties.push(("max-length", max_length));
        }
        if let Some(ref max_width_chars) = self.max_width_chars {
            properties.push(("max-width-chars", max_width_chars));
        }
        if let Some(ref overwrite_mode) = self.overwrite_mode {
            properties.push(("overwrite-mode", overwrite_mode));
        }
        if let Some(ref placeholder_text) = self.placeholder_text {
            properties.push(("placeholder-text", placeholder_text));
        }
        if let Some(ref populate_all) = self.populate_all {
            properties.push(("populate-all", populate_all));
        }
        if let Some(ref primary_icon_activatable) = self.primary_icon_activatable {
            properties.push(("primary-icon-activatable", primary_icon_activatable));
        }
        if let Some(ref primary_icon_gicon) = self.primary_icon_gicon {
            properties.push(("primary-icon-gicon", primary_icon_gicon));
        }
        if let Some(ref primary_icon_name) = self.primary_icon_name {
            properties.push(("primary-icon-name", primary_icon_name));
        }
        if let Some(ref primary_icon_pixbuf) = self.primary_icon_pixbuf {
            properties.push(("primary-icon-pixbuf", primary_icon_pixbuf));
        }
        if let Some(ref primary_icon_sensitive) = self.primary_icon_sensitive {
            properties.push(("primary-icon-sensitive", primary_icon_sensitive));
        }
        if let Some(ref primary_icon_tooltip_markup) = self.primary_icon_tooltip_markup {
            properties.push(("primary-icon-tooltip-markup", primary_icon_tooltip_markup));
        }
        if let Some(ref primary_icon_tooltip_text) = self.primary_icon_tooltip_text {
            properties.push(("primary-icon-tooltip-text", primary_icon_tooltip_text));
        }
        if let Some(ref progress_fraction) = self.progress_fraction {
            properties.push(("progress-fraction", progress_fraction));
        }
        if let Some(ref progress_pulse_step) = self.progress_pulse_step {
            properties.push(("progress-pulse-step", progress_pulse_step));
        }
        if let Some(ref secondary_icon_activatable) = self.secondary_icon_activatable {
            properties.push(("secondary-icon-activatable", secondary_icon_activatable));
        }
        if let Some(ref secondary_icon_gicon) = self.secondary_icon_gicon {
            properties.push(("secondary-icon-gicon", secondary_icon_gicon));
        }
        if let Some(ref secondary_icon_name) = self.secondary_icon_name {
            properties.push(("secondary-icon-name", secondary_icon_name));
        }
        if let Some(ref secondary_icon_pixbuf) = self.secondary_icon_pixbuf {
            properties.push(("secondary-icon-pixbuf", secondary_icon_pixbuf));
        }
        if let Some(ref secondary_icon_sensitive) = self.secondary_icon_sensitive {
            properties.push(("secondary-icon-sensitive", secondary_icon_sensitive));
        }
        if let Some(ref secondary_icon_tooltip_markup) = self.secondary_icon_tooltip_markup {
            properties.push((
                "secondary-icon-tooltip-markup",
                secondary_icon_tooltip_markup,
            ));
        }
        if let Some(ref secondary_icon_tooltip_text) = self.secondary_icon_tooltip_text {
            properties.push(("secondary-icon-tooltip-text", secondary_icon_tooltip_text));
        }
        if let Some(ref shadow_type) = self.shadow_type {
            properties.push(("shadow-type", shadow_type));
        }
        if let Some(ref show_emoji_icon) = self.show_emoji_icon {
            properties.push(("show-emoji-icon", show_emoji_icon));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref text) = self.text {
            properties.push(("text", text));
        }
        if let Some(ref truncate_multiline) = self.truncate_multiline {
            properties.push(("truncate-multiline", truncate_multiline));
        }
        if let Some(ref visibility) = self.visibility {
            properties.push(("visibility", visibility));
        }
        if let Some(ref width_chars) = self.width_chars {
            properties.push(("width-chars", width_chars));
        }
        if let Some(ref xalign) = self.xalign {
            properties.push(("xalign", xalign));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        {
            if let Some(ref focus_on_click) = self.focus_on_click {
                properties.push(("focus-on-click", focus_on_click));
            }
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref editing_canceled) = self.editing_canceled {
            properties.push(("editing-canceled", editing_canceled));
        }
        glib::Object::new(Entry::static_type(), &properties)
            .expect("object new")
            .downcast()
            .expect("downcast")
    }

    pub fn activates_default(mut self, activates_default: bool) -> Self {
        self.activates_default = Some(activates_default);
        self
    }

    pub fn attributes(mut self, attributes: &pango::AttrList) -> Self {
        self.attributes = Some(attributes.clone());
        self
    }

    pub fn buffer<P: IsA<EntryBuffer>>(mut self, buffer: &P) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }

    pub fn caps_lock_warning(mut self, caps_lock_warning: bool) -> Self {
        self.caps_lock_warning = Some(caps_lock_warning);
        self
    }

    pub fn completion<P: IsA<EntryCompletion>>(mut self, completion: &P) -> Self {
        self.completion = Some(completion.clone().upcast());
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn enable_emoji_completion(mut self, enable_emoji_completion: bool) -> Self {
        self.enable_emoji_completion = Some(enable_emoji_completion);
        self
    }

    pub fn has_frame(mut self, has_frame: bool) -> Self {
        self.has_frame = Some(has_frame);
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn input_hints(mut self, input_hints: InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn invisible_char(mut self, invisible_char: u32) -> Self {
        self.invisible_char = Some(invisible_char);
        self
    }

    pub fn invisible_char_set(mut self, invisible_char_set: bool) -> Self {
        self.invisible_char_set = Some(invisible_char_set);
        self
    }

    pub fn max_length(mut self, max_length: i32) -> Self {
        self.max_length = Some(max_length);
        self
    }

    pub fn max_width_chars(mut self, max_width_chars: i32) -> Self {
        self.max_width_chars = Some(max_width_chars);
        self
    }

    pub fn overwrite_mode(mut self, overwrite_mode: bool) -> Self {
        self.overwrite_mode = Some(overwrite_mode);
        self
    }

    pub fn placeholder_text(mut self, placeholder_text: &str) -> Self {
        self.placeholder_text = Some(placeholder_text.to_string());
        self
    }

    pub fn populate_all(mut self, populate_all: bool) -> Self {
        self.populate_all = Some(populate_all);
        self
    }

    pub fn primary_icon_activatable(mut self, primary_icon_activatable: bool) -> Self {
        self.primary_icon_activatable = Some(primary_icon_activatable);
        self
    }

    pub fn primary_icon_gicon<P: IsA<gio::Icon>>(mut self, primary_icon_gicon: &P) -> Self {
        self.primary_icon_gicon = Some(primary_icon_gicon.clone().upcast());
        self
    }

    pub fn primary_icon_name(mut self, primary_icon_name: &str) -> Self {
        self.primary_icon_name = Some(primary_icon_name.to_string());
        self
    }

    pub fn primary_icon_pixbuf(mut self, primary_icon_pixbuf: &gdk_pixbuf::Pixbuf) -> Self {
        self.primary_icon_pixbuf = Some(primary_icon_pixbuf.clone());
        self
    }

    pub fn primary_icon_sensitive(mut self, primary_icon_sensitive: bool) -> Self {
        self.primary_icon_sensitive = Some(primary_icon_sensitive);
        self
    }

    pub fn primary_icon_tooltip_markup(mut self, primary_icon_tooltip_markup: &str) -> Self {
        self.primary_icon_tooltip_markup = Some(primary_icon_tooltip_markup.to_string());
        self
    }

    pub fn primary_icon_tooltip_text(mut self, primary_icon_tooltip_text: &str) -> Self {
        self.primary_icon_tooltip_text = Some(primary_icon_tooltip_text.to_string());
        self
    }

    pub fn progress_fraction(mut self, progress_fraction: f64) -> Self {
        self.progress_fraction = Some(progress_fraction);
        self
    }

    pub fn progress_pulse_step(mut self, progress_pulse_step: f64) -> Self {
        self.progress_pulse_step = Some(progress_pulse_step);
        self
    }

    pub fn secondary_icon_activatable(mut self, secondary_icon_activatable: bool) -> Self {
        self.secondary_icon_activatable = Some(secondary_icon_activatable);
        self
    }

    pub fn secondary_icon_gicon<P: IsA<gio::Icon>>(mut self, secondary_icon_gicon: &P) -> Self {
        self.secondary_icon_gicon = Some(secondary_icon_gicon.clone().upcast());
        self
    }

    pub fn secondary_icon_name(mut self, secondary_icon_name: &str) -> Self {
        self.secondary_icon_name = Some(secondary_icon_name.to_string());
        self
    }

    pub fn secondary_icon_pixbuf(mut self, secondary_icon_pixbuf: &gdk_pixbuf::Pixbuf) -> Self {
        self.secondary_icon_pixbuf = Some(secondary_icon_pixbuf.clone());
        self
    }

    pub fn secondary_icon_sensitive(mut self, secondary_icon_sensitive: bool) -> Self {
        self.secondary_icon_sensitive = Some(secondary_icon_sensitive);
        self
    }

    pub fn secondary_icon_tooltip_markup(mut self, secondary_icon_tooltip_markup: &str) -> Self {
        self.secondary_icon_tooltip_markup = Some(secondary_icon_tooltip_markup.to_string());
        self
    }

    pub fn secondary_icon_tooltip_text(mut self, secondary_icon_tooltip_text: &str) -> Self {
        self.secondary_icon_tooltip_text = Some(secondary_icon_tooltip_text.to_string());
        self
    }

    pub fn shadow_type(mut self, shadow_type: ShadowType) -> Self {
        self.shadow_type = Some(shadow_type);
        self
    }

    pub fn show_emoji_icon(mut self, show_emoji_icon: bool) -> Self {
        self.show_emoji_icon = Some(show_emoji_icon);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn text(mut self, text: &str) -> Self {
        self.text = Some(text.to_string());
        self
    }

    pub fn truncate_multiline(mut self, truncate_multiline: bool) -> Self {
        self.truncate_multiline = Some(truncate_multiline);
        self
    }

    pub fn visibility(mut self, visibility: bool) -> Self {
        self.visibility = Some(visibility);
        self
    }

    pub fn width_chars(mut self, width_chars: i32) -> Self {
        self.width_chars = Some(width_chars);
        self
    }

    pub fn xalign(mut self, xalign: f32) -> Self {
        self.xalign = Some(xalign);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn editing_canceled(mut self, editing_canceled: bool) -> Self {
        self.editing_canceled = Some(editing_canceled);
        self
    }
}

pub const NONE_ENTRY: Option<&Entry> = None;

pub trait EntryExt: 'static {
    fn get_activates_default(&self) -> bool;

    fn get_alignment(&self) -> f32;

    fn get_attributes(&self) -> Option<pango::AttrList>;

    fn get_buffer(&self) -> EntryBuffer;

    fn get_completion(&self) -> Option<EntryCompletion>;

    fn get_current_icon_drag_source(&self) -> i32;

    fn get_cursor_hadjustment(&self) -> Option<Adjustment>;

    fn get_has_frame(&self) -> bool;

    fn get_icon_activatable(&self, icon_pos: EntryIconPosition) -> bool;

    fn get_icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle;

    fn get_icon_at_pos(&self, x: i32, y: i32) -> i32;

    fn get_icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon>;

    fn get_icon_name(&self, icon_pos: EntryIconPosition) -> Option<GString>;

    fn get_icon_pixbuf(&self, icon_pos: EntryIconPosition) -> Option<gdk_pixbuf::Pixbuf>;

    fn get_icon_sensitive(&self, icon_pos: EntryIconPosition) -> bool;

    fn get_icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType;

    fn get_icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<GString>;

    fn get_icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<GString>;

    fn get_input_hints(&self) -> InputHints;

    fn get_input_purpose(&self) -> InputPurpose;

    fn get_invisible_char(&self) -> Option<char>;

    fn get_layout(&self) -> Option<pango::Layout>;

    fn get_layout_offsets(&self) -> (i32, i32);

    fn get_max_length(&self) -> i32;

    fn get_max_width_chars(&self) -> i32;

    fn get_overwrite_mode(&self) -> bool;

    fn get_placeholder_text(&self) -> Option<GString>;

    fn get_progress_fraction(&self) -> f64;

    fn get_progress_pulse_step(&self) -> f64;

    fn get_tabs(&self) -> Option<pango::TabArray>;

    fn get_text(&self) -> Option<GString>;

    fn get_text_area(&self) -> gdk::Rectangle;

    fn get_text_length(&self) -> u16;

    fn get_visibility(&self) -> bool;

    fn get_width_chars(&self) -> i32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn grab_focus_without_selecting(&self);

    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool;

    fn layout_index_to_text_index(&self, layout_index: i32) -> i32;

    fn progress_pulse(&self);

    fn reset_im_context(&self);

    fn set_activates_default(&self, setting: bool);

    fn set_alignment(&self, xalign: f32);

    fn set_attributes(&self, attrs: &pango::AttrList);

    fn set_buffer<P: IsA<EntryBuffer>>(&self, buffer: &P);

    fn set_completion<P: IsA<EntryCompletion>>(&self, completion: Option<&P>);

    fn set_cursor_hadjustment<P: IsA<Adjustment>>(&self, adjustment: Option<&P>);

    fn set_has_frame(&self, setting: bool);

    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool);

    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        target_list: &TargetList,
        actions: gdk::DragAction,
    );

    fn set_icon_from_gicon<P: IsA<gio::Icon>>(&self, icon_pos: EntryIconPosition, icon: Option<&P>);

    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>);

    fn set_icon_from_pixbuf(
        &self,
        icon_pos: EntryIconPosition,
        pixbuf: Option<&gdk_pixbuf::Pixbuf>,
    );

    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool);

    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>);

    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>);

    fn set_input_hints(&self, hints: InputHints);

    fn set_input_purpose(&self, purpose: InputPurpose);

    fn set_invisible_char(&self, ch: Option<char>);

    fn set_max_length(&self, max: i32);

    fn set_max_width_chars(&self, n_chars: i32);

    fn set_overwrite_mode(&self, overwrite: bool);

    fn set_placeholder_text(&self, text: Option<&str>);

    fn set_progress_fraction(&self, fraction: f64);

    fn set_progress_pulse_step(&self, fraction: f64);

    fn set_tabs(&self, tabs: &pango::TabArray);

    fn set_text(&self, text: &str);

    fn set_visibility(&self, visible: bool);

    fn set_width_chars(&self, n_chars: i32);

    fn text_index_to_layout_index(&self, text_index: i32) -> i32;

    fn unset_invisible_char(&self);

    fn get_property_caps_lock_warning(&self) -> bool;

    fn set_property_caps_lock_warning(&self, caps_lock_warning: bool);

    fn get_property_cursor_position(&self) -> i32;

    fn get_property_enable_emoji_completion(&self) -> bool;

    fn set_property_enable_emoji_completion(&self, enable_emoji_completion: bool);

    fn get_property_im_module(&self) -> Option<GString>;

    fn set_property_im_module(&self, im_module: Option<&str>);

    fn get_property_invisible_char_set(&self) -> bool;

    fn set_property_invisible_char_set(&self, invisible_char_set: bool);

    fn get_property_populate_all(&self) -> bool;

    fn set_property_populate_all(&self, populate_all: bool);

    fn get_property_primary_icon_activatable(&self) -> bool;

    fn set_property_primary_icon_activatable(&self, primary_icon_activatable: bool);

    fn get_property_primary_icon_gicon(&self) -> Option<gio::Icon>;

    fn set_property_primary_icon_gicon<P: IsA<gio::Icon> + SetValueOptional>(
        &self,
        primary_icon_gicon: Option<&P>,
    );

    fn get_property_primary_icon_name(&self) -> Option<GString>;

    fn set_property_primary_icon_name(&self, primary_icon_name: Option<&str>);

    fn get_property_primary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf>;

    fn set_property_primary_icon_pixbuf(&self, primary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>);

    fn get_property_primary_icon_sensitive(&self) -> bool;

    fn set_property_primary_icon_sensitive(&self, primary_icon_sensitive: bool);

    fn get_property_primary_icon_storage_type(&self) -> ImageType;

    fn get_property_primary_icon_tooltip_markup(&self) -> Option<GString>;

    fn set_property_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>);

    fn get_property_primary_icon_tooltip_text(&self) -> Option<GString>;

    fn set_property_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>);

    fn get_property_scroll_offset(&self) -> i32;

    fn get_property_secondary_icon_activatable(&self) -> bool;

    fn set_property_secondary_icon_activatable(&self, secondary_icon_activatable: bool);

    fn get_property_secondary_icon_gicon(&self) -> Option<gio::Icon>;

    fn set_property_secondary_icon_gicon<P: IsA<gio::Icon> + SetValueOptional>(
        &self,
        secondary_icon_gicon: Option<&P>,
    );

    fn get_property_secondary_icon_name(&self) -> Option<GString>;

    fn set_property_secondary_icon_name(&self, secondary_icon_name: Option<&str>);

    fn get_property_secondary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf>;

    fn set_property_secondary_icon_pixbuf(
        &self,
        secondary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>,
    );

    fn get_property_secondary_icon_sensitive(&self) -> bool;

    fn set_property_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool);

    fn get_property_secondary_icon_storage_type(&self) -> ImageType;

    fn get_property_secondary_icon_tooltip_markup(&self) -> Option<GString>;

    fn set_property_secondary_icon_tooltip_markup(
        &self,
        secondary_icon_tooltip_markup: Option<&str>,
    );

    fn get_property_secondary_icon_tooltip_text(&self) -> Option<GString>;

    fn set_property_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>);

    fn get_property_selection_bound(&self) -> i32;

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn get_property_shadow_type(&self) -> ShadowType;

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn set_property_shadow_type(&self, shadow_type: ShadowType);

    fn get_property_show_emoji_icon(&self) -> bool;

    fn set_property_show_emoji_icon(&self, show_emoji_icon: bool);

    fn get_property_truncate_multiline(&self) -> bool;

    fn set_property_truncate_multiline(&self, truncate_multiline: bool);

    fn get_property_xalign(&self) -> f32;

    fn set_property_xalign(&self, xalign: f32);

    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate(&self);

    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_backspace(&self);

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_cut_clipboard(&self);

    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32);

    fn connect_icon_press<F: Fn(&Self, EntryIconPosition, &gdk::EventButton) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_icon_release<F: Fn(&Self, EntryIconPosition, &gdk::EventButton) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_insert_at_cursor(&self, string: &str);

    #[cfg(any(feature = "v3_22_27", feature = "dox"))]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22_27", feature = "dox"))]
    fn emit_insert_emoji(&self);

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool);

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_paste_clipboard(&self);

    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_preedit_changed(&self, preedit: &str);

    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_overwrite(&self);

    fn connect_property_activates_default_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_caps_lock_warning_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_cursor_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_input_purpose_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_invisible_char_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_invisible_char_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_max_width_chars_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_overwrite_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_placeholder_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_populate_all_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_progress_fraction_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_progress_pulse_step_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_scroll_offset_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_selection_bound_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_show_emoji_icon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_truncate_multiline_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Entry>> EntryExt for O {
    fn get_activates_default(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_activates_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_alignment(&self) -> f32 {
        unsafe { gtk_sys::gtk_entry_get_alignment(self.as_ref().to_glib_none().0) }
    }

    fn get_attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_buffer(&self) -> EntryBuffer {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_completion(&self) -> Option<EntryCompletion> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_current_icon_drag_source(&self) -> i32 {
        unsafe { gtk_sys::gtk_entry_get_current_icon_drag_source(self.as_ref().to_glib_none().0) }
    }

    fn get_cursor_hadjustment(&self) -> Option<Adjustment> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_cursor_hadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_has_frame(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_has_frame(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_icon_activatable(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle {
        unsafe {
            let mut icon_area = gdk::Rectangle::uninitialized();
            gtk_sys::gtk_entry_get_icon_area(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                icon_area.to_glib_none_mut().0,
            );
            icon_area
        }
    }

    fn get_icon_at_pos(&self, x: i32, y: i32) -> i32 {
        unsafe { gtk_sys::gtk_entry_get_icon_at_pos(self.as_ref().to_glib_none().0, x, y) }
    }

    fn get_icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_icon_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_name(&self, icon_pos: EntryIconPosition) -> Option<GString> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_pixbuf(&self, icon_pos: EntryIconPosition) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_icon_pixbuf(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_sensitive(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_icon_storage_type(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<GString> {
        unsafe {
            from_glib_full(gtk_sys::gtk_entry_get_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<GString> {
        unsafe {
            from_glib_full(gtk_sys::gtk_entry_get_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
            ))
        }
    }

    fn get_input_hints(&self) -> InputHints {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_invisible_char(&self) -> Option<char> {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_invisible_char(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_layout(&self) -> Option<pango::Layout> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_layout_offsets(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            gtk_sys::gtk_entry_get_layout_offsets(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (x, y)
        }
    }

    fn get_max_length(&self) -> i32 {
        unsafe { gtk_sys::gtk_entry_get_max_length(self.as_ref().to_glib_none().0) }
    }

    fn get_max_width_chars(&self) -> i32 {
        unsafe { gtk_sys::gtk_entry_get_max_width_chars(self.as_ref().to_glib_none().0) }
    }

    fn get_overwrite_mode(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_overwrite_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_placeholder_text(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gtk_sys::gtk_entry_get_placeholder_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_progress_fraction(&self) -> f64 {
        unsafe { gtk_sys::gtk_entry_get_progress_fraction(self.as_ref().to_glib_none().0) }
    }

    fn get_progress_pulse_step(&self) -> f64 {
        unsafe { gtk_sys::gtk_entry_get_progress_pulse_step(self.as_ref().to_glib_none().0) }
    }

    fn get_tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(gtk_sys::gtk_entry_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    fn get_text(&self) -> Option<GString> {
        unsafe { from_glib_none(gtk_sys::gtk_entry_get_text(self.as_ref().to_glib_none().0)) }
    }

    fn get_text_area(&self) -> gdk::Rectangle {
        unsafe {
            let mut text_area = gdk::Rectangle::uninitialized();
            gtk_sys::gtk_entry_get_text_area(
                self.as_ref().to_glib_none().0,
                text_area.to_glib_none_mut().0,
            );
            text_area
        }
    }

    fn get_text_length(&self) -> u16 {
        unsafe { gtk_sys::gtk_entry_get_text_length(self.as_ref().to_glib_none().0) }
    }

    fn get_visibility(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_get_visibility(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_width_chars(&self) -> i32 {
        unsafe { gtk_sys::gtk_entry_get_width_chars(self.as_ref().to_glib_none().0) }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn grab_focus_without_selecting(&self) {
        unsafe {
            gtk_sys::gtk_entry_grab_focus_without_selecting(self.as_ref().to_glib_none().0);
        }
    }

    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_entry_im_context_filter_keypress(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn layout_index_to_text_index(&self, layout_index: i32) -> i32 {
        unsafe {
            gtk_sys::gtk_entry_layout_index_to_text_index(
                self.as_ref().to_glib_none().0,
                layout_index,
            )
        }
    }

    fn progress_pulse(&self) {
        unsafe {
            gtk_sys::gtk_entry_progress_pulse(self.as_ref().to_glib_none().0);
        }
    }

    fn reset_im_context(&self) {
        unsafe {
            gtk_sys::gtk_entry_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    fn set_activates_default(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_activates_default(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_alignment(&self, xalign: f32) {
        unsafe {
            gtk_sys::gtk_entry_set_alignment(self.as_ref().to_glib_none().0, xalign);
        }
    }

    fn set_attributes(&self, attrs: &pango::AttrList) {
        unsafe {
            gtk_sys::gtk_entry_set_attributes(
                self.as_ref().to_glib_none().0,
                attrs.to_glib_none().0,
            );
        }
    }

    fn set_buffer<P: IsA<EntryBuffer>>(&self, buffer: &P) {
        unsafe {
            gtk_sys::gtk_entry_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_completion<P: IsA<EntryCompletion>>(&self, completion: Option<&P>) {
        unsafe {
            gtk_sys::gtk_entry_set_completion(
                self.as_ref().to_glib_none().0,
                completion.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_cursor_hadjustment<P: IsA<Adjustment>>(&self, adjustment: Option<&P>) {
        unsafe {
            gtk_sys::gtk_entry_set_cursor_hadjustment(
                self.as_ref().to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_has_frame(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_has_frame(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                activatable.to_glib(),
            );
        }
    }

    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        target_list: &TargetList,
        actions: gdk::DragAction,
    ) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_drag_source(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                target_list.to_glib_none().0,
                actions.to_glib(),
            );
        }
    }

    fn set_icon_from_gicon<P: IsA<gio::Icon>>(
        &self,
        icon_pos: EntryIconPosition,
        icon: Option<&P>,
    ) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_from_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                icon.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_from_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                icon_name.to_glib_none().0,
            );
        }
    }

    fn set_icon_from_pixbuf(
        &self,
        icon_pos: EntryIconPosition,
        pixbuf: Option<&gdk_pixbuf::Pixbuf>,
    ) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_from_pixbuf(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                pixbuf.to_glib_none().0,
            );
        }
    }

    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                sensitive.to_glib(),
            );
        }
    }

    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            gtk_sys::gtk_entry_set_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.to_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            gtk_sys::gtk_entry_set_input_hints(self.as_ref().to_glib_none().0, hints.to_glib());
        }
    }

    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            gtk_sys::gtk_entry_set_input_purpose(self.as_ref().to_glib_none().0, purpose.to_glib());
        }
    }

    fn set_invisible_char(&self, ch: Option<char>) {
        unsafe {
            gtk_sys::gtk_entry_set_invisible_char(self.as_ref().to_glib_none().0, ch.to_glib());
        }
    }

    fn set_max_length(&self, max: i32) {
        unsafe {
            gtk_sys::gtk_entry_set_max_length(self.as_ref().to_glib_none().0, max);
        }
    }

    fn set_max_width_chars(&self, n_chars: i32) {
        unsafe {
            gtk_sys::gtk_entry_set_max_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_overwrite_mode(
                self.as_ref().to_glib_none().0,
                overwrite.to_glib(),
            );
        }
    }

    fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            gtk_sys::gtk_entry_set_placeholder_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            );
        }
    }

    fn set_progress_fraction(&self, fraction: f64) {
        unsafe {
            gtk_sys::gtk_entry_set_progress_fraction(self.as_ref().to_glib_none().0, fraction);
        }
    }

    fn set_progress_pulse_step(&self, fraction: f64) {
        unsafe {
            gtk_sys::gtk_entry_set_progress_pulse_step(self.as_ref().to_glib_none().0, fraction);
        }
    }

    fn set_tabs(&self, tabs: &pango::TabArray) {
        unsafe {
            gtk_sys::gtk_entry_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    fn set_text(&self, text: &str) {
        unsafe {
            gtk_sys::gtk_entry_set_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    fn set_visibility(&self, visible: bool) {
        unsafe {
            gtk_sys::gtk_entry_set_visibility(self.as_ref().to_glib_none().0, visible.to_glib());
        }
    }

    fn set_width_chars(&self, n_chars: i32) {
        unsafe {
            gtk_sys::gtk_entry_set_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    fn text_index_to_layout_index(&self, text_index: i32) -> i32 {
        unsafe {
            gtk_sys::gtk_entry_text_index_to_layout_index(
                self.as_ref().to_glib_none().0,
                text_index,
            )
        }
    }

    fn unset_invisible_char(&self) {
        unsafe {
            gtk_sys::gtk_entry_unset_invisible_char(self.as_ref().to_glib_none().0);
        }
    }

    fn get_property_caps_lock_warning(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"caps-lock-warning\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `caps-lock-warning` getter")
                .unwrap()
        }
    }

    fn set_property_caps_lock_warning(&self, caps_lock_warning: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"caps-lock-warning\0".as_ptr() as *const _,
                Value::from(&caps_lock_warning).to_glib_none().0,
            );
        }
    }

    fn get_property_cursor_position(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"cursor-position\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `cursor-position` getter")
                .unwrap()
        }
    }

    fn get_property_enable_emoji_completion(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"enable-emoji-completion\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `enable-emoji-completion` getter")
                .unwrap()
        }
    }

    fn set_property_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"enable-emoji-completion\0".as_ptr() as *const _,
                Value::from(&enable_emoji_completion).to_glib_none().0,
            );
        }
    }

    fn get_property_im_module(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"im-module\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `im-module` getter")
        }
    }

    fn set_property_im_module(&self, im_module: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"im-module\0".as_ptr() as *const _,
                Value::from(im_module).to_glib_none().0,
            );
        }
    }

    fn get_property_invisible_char_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible-char-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible-char-set` getter")
                .unwrap()
        }
    }

    fn set_property_invisible_char_set(&self, invisible_char_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible-char-set\0".as_ptr() as *const _,
                Value::from(&invisible_char_set).to_glib_none().0,
            );
        }
    }

    fn get_property_populate_all(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"populate-all\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `populate-all` getter")
                .unwrap()
        }
    }

    fn set_property_populate_all(&self, populate_all: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"populate-all\0".as_ptr() as *const _,
                Value::from(&populate_all).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_activatable(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-activatable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-activatable` getter")
                .unwrap()
        }
    }

    fn set_property_primary_icon_activatable(&self, primary_icon_activatable: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-activatable\0".as_ptr() as *const _,
                Value::from(&primary_icon_activatable).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_gicon(&self) -> Option<gio::Icon> {
        unsafe {
            let mut value = Value::from_type(<gio::Icon as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-gicon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-gicon` getter")
        }
    }

    fn set_property_primary_icon_gicon<P: IsA<gio::Icon> + SetValueOptional>(
        &self,
        primary_icon_gicon: Option<&P>,
    ) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-gicon\0".as_ptr() as *const _,
                Value::from(primary_icon_gicon).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_name(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-name` getter")
        }
    }

    fn set_property_primary_icon_name(&self, primary_icon_name: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-name\0".as_ptr() as *const _,
                Value::from(primary_icon_name).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            let mut value = Value::from_type(<gdk_pixbuf::Pixbuf as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-pixbuf\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-pixbuf` getter")
        }
    }

    fn set_property_primary_icon_pixbuf(&self, primary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-pixbuf\0".as_ptr() as *const _,
                Value::from(primary_icon_pixbuf).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_sensitive(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-sensitive\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-sensitive` getter")
                .unwrap()
        }
    }

    fn set_property_primary_icon_sensitive(&self, primary_icon_sensitive: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-sensitive\0".as_ptr() as *const _,
                Value::from(&primary_icon_sensitive).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_storage_type(&self) -> ImageType {
        unsafe {
            let mut value = Value::from_type(<ImageType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-storage-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-storage-type` getter")
                .unwrap()
        }
    }

    fn get_property_primary_icon_tooltip_markup(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-tooltip-markup\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-tooltip-markup` getter")
        }
    }

    fn set_property_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-tooltip-markup\0".as_ptr() as *const _,
                Value::from(primary_icon_tooltip_markup).to_glib_none().0,
            );
        }
    }

    fn get_property_primary_icon_tooltip_text(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-tooltip-text\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `primary-icon-tooltip-text` getter")
        }
    }

    fn set_property_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"primary-icon-tooltip-text\0".as_ptr() as *const _,
                Value::from(primary_icon_tooltip_text).to_glib_none().0,
            );
        }
    }

    fn get_property_scroll_offset(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"scroll-offset\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scroll-offset` getter")
                .unwrap()
        }
    }

    fn get_property_secondary_icon_activatable(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-activatable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-activatable` getter")
                .unwrap()
        }
    }

    fn set_property_secondary_icon_activatable(&self, secondary_icon_activatable: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-activatable\0".as_ptr() as *const _,
                Value::from(&secondary_icon_activatable).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_gicon(&self) -> Option<gio::Icon> {
        unsafe {
            let mut value = Value::from_type(<gio::Icon as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-gicon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-gicon` getter")
        }
    }

    fn set_property_secondary_icon_gicon<P: IsA<gio::Icon> + SetValueOptional>(
        &self,
        secondary_icon_gicon: Option<&P>,
    ) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-gicon\0".as_ptr() as *const _,
                Value::from(secondary_icon_gicon).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_name(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-name` getter")
        }
    }

    fn set_property_secondary_icon_name(&self, secondary_icon_name: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-name\0".as_ptr() as *const _,
                Value::from(secondary_icon_name).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            let mut value = Value::from_type(<gdk_pixbuf::Pixbuf as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-pixbuf\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-pixbuf` getter")
        }
    }

    fn set_property_secondary_icon_pixbuf(
        &self,
        secondary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>,
    ) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-pixbuf\0".as_ptr() as *const _,
                Value::from(secondary_icon_pixbuf).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_sensitive(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-sensitive\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-sensitive` getter")
                .unwrap()
        }
    }

    fn set_property_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-sensitive\0".as_ptr() as *const _,
                Value::from(&secondary_icon_sensitive).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_storage_type(&self) -> ImageType {
        unsafe {
            let mut value = Value::from_type(<ImageType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-storage-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-storage-type` getter")
                .unwrap()
        }
    }

    fn get_property_secondary_icon_tooltip_markup(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-tooltip-markup` getter")
        }
    }

    fn set_property_secondary_icon_tooltip_markup(
        &self,
        secondary_icon_tooltip_markup: Option<&str>,
    ) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                Value::from(secondary_icon_tooltip_markup).to_glib_none().0,
            );
        }
    }

    fn get_property_secondary_icon_tooltip_text(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-tooltip-text\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `secondary-icon-tooltip-text` getter")
        }
    }

    fn set_property_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"secondary-icon-tooltip-text\0".as_ptr() as *const _,
                Value::from(secondary_icon_tooltip_text).to_glib_none().0,
            );
        }
    }

    fn get_property_selection_bound(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"selection-bound\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `selection-bound` getter")
                .unwrap()
        }
    }

    fn get_property_shadow_type(&self) -> ShadowType {
        unsafe {
            let mut value = Value::from_type(<ShadowType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"shadow-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `shadow-type` getter")
                .unwrap()
        }
    }

    fn set_property_shadow_type(&self, shadow_type: ShadowType) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"shadow-type\0".as_ptr() as *const _,
                Value::from(&shadow_type).to_glib_none().0,
            );
        }
    }

    fn get_property_show_emoji_icon(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"show-emoji-icon\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `show-emoji-icon` getter")
                .unwrap()
        }
    }

    fn set_property_show_emoji_icon(&self, show_emoji_icon: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"show-emoji-icon\0".as_ptr() as *const _,
                Value::from(&show_emoji_icon).to_glib_none().0,
            );
        }
    }

    fn get_property_truncate_multiline(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"truncate-multiline\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `truncate-multiline` getter")
                .unwrap()
        }
    }

    fn set_property_truncate_multiline(&self, truncate_multiline: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"truncate-multiline\0".as_ptr() as *const _,
                Value::from(&truncate_multiline).to_glib_none().0,
            );
        }
    }

    fn get_property_xalign(&self) -> f32 {
        unsafe {
            let mut value = Value::from_type(<f32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"xalign\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `xalign` getter")
                .unwrap()
        }
    }

    fn set_property_xalign(&self, xalign: f32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"xalign\0".as_ptr() as *const _,
                Value::from(&xalign).to_glib_none().0,
            );
        }
    }

    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate\0".as_ptr() as *const _,
                Some(transmute(activate_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("activate", &[])
                .unwrap()
        };
    }

    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn backspace_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"backspace\0".as_ptr() as *const _,
                Some(transmute(backspace_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_backspace(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("backspace", &[])
                .unwrap()
        };
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute(copy_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("copy-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cut_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cut-clipboard\0".as_ptr() as *const _,
                Some(transmute(cut_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_cut_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("cut-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_from_cursor_trampoline<
            P,
            F: Fn(&P, DeleteType, i32) + 'static,
        >(
            this: *mut gtk_sys::GtkEntry,
            type_: gtk_sys::GtkDeleteType,
            count: libc::c_int,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                from_glib(type_),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-from-cursor\0".as_ptr() as *const _,
                Some(transmute(delete_from_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("delete-from-cursor", &[&type_, &count])
                .unwrap()
        };
    }

    fn connect_icon_press<F: Fn(&Self, EntryIconPosition, &gdk::EventButton) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_press_trampoline<
            P,
            F: Fn(&P, EntryIconPosition, &gdk::EventButton) + 'static,
        >(
            this: *mut gtk_sys::GtkEntry,
            icon_pos: gtk_sys::GtkEntryIconPosition,
            event: *mut gdk_sys::GdkEventButton,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                from_glib(icon_pos),
                &from_glib_borrow(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-press\0".as_ptr() as *const _,
                Some(transmute(icon_press_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_release<F: Fn(&Self, EntryIconPosition, &gdk::EventButton) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_release_trampoline<
            P,
            F: Fn(&P, EntryIconPosition, &gdk::EventButton) + 'static,
        >(
            this: *mut gtk_sys::GtkEntry,
            icon_pos: gtk_sys::GtkEntryIconPosition,
            event: *mut gdk_sys::GdkEventButton,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                from_glib(icon_pos),
                &from_glib_borrow(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-release\0".as_ptr() as *const _,
                Some(transmute(icon_release_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_at_cursor_trampoline<P, F: Fn(&P, &str) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            string: *mut libc::c_char,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                &GString::from_glib_borrow(string),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-at-cursor\0".as_ptr() as *const _,
                Some(transmute(insert_at_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_at_cursor(&self, string: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("insert-at-cursor", &[&string])
                .unwrap()
        };
    }

    #[cfg(any(feature = "v3_22_27", feature = "dox"))]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_emoji_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-emoji\0".as_ptr() as *const _,
                Some(transmute(insert_emoji_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22_27", feature = "dox"))]
    fn emit_insert_emoji(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("insert-emoji", &[])
                .unwrap()
        };
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut gtk_sys::GtkEntry,
            step: gtk_sys::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib_sys::gboolean,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute(move_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("move-cursor", &[&step, &count, &extend_selection])
                .unwrap()
        };
    }

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute(paste_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("paste-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn populate_popup_trampoline<P, F: Fn(&P, &Widget) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            widget: *mut gtk_sys::GtkWidget,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(widget),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"populate-popup\0".as_ptr() as *const _,
                Some(transmute(populate_popup_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn preedit_changed_trampoline<P, F: Fn(&P, &str) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            preedit: *mut libc::c_char,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Entry::from_glib_borrow(this).unsafe_cast(),
                &GString::from_glib_borrow(preedit),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preedit-changed\0".as_ptr() as *const _,
                Some(transmute(preedit_changed_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_preedit_changed(&self, preedit: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("preedit-changed", &[&preedit])
                .unwrap()
        };
    }

    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_overwrite_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-overwrite\0".as_ptr() as *const _,
                Some(transmute(toggle_overwrite_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_overwrite(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("toggle-overwrite", &[])
                .unwrap()
        };
    }

    fn connect_property_activates_default_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activates-default\0".as_ptr() as *const _,
                Some(transmute(
                    notify_activates_default_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute(notify_attributes_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute(notify_buffer_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_caps_lock_warning_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_caps_lock_warning_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::caps-lock-warning\0".as_ptr() as *const _,
                Some(transmute(
                    notify_caps_lock_warning_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::completion\0".as_ptr() as *const _,
                Some(transmute(notify_completion_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_cursor_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_position_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-position\0".as_ptr() as *const _,
                Some(transmute(
                    notify_cursor_position_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute(notify_editable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-emoji-completion\0".as_ptr() as *const _,
                Some(transmute(
                    notify_enable_emoji_completion_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-frame\0".as_ptr() as *const _,
                Some(transmute(notify_has_frame_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute(notify_im_module_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute(notify_input_hints_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_input_purpose_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute(
                    notify_input_purpose_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_invisible_char_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char\0".as_ptr() as *const _,
                Some(transmute(
                    notify_invisible_char_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_invisible_char_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char-set\0".as_ptr() as *const _,
                Some(transmute(
                    notify_invisible_char_set_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-length\0".as_ptr() as *const _,
                Some(transmute(notify_max_length_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_max_width_chars_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(transmute(
                    notify_max_width_chars_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_overwrite_mode_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite-mode\0".as_ptr() as *const _,
                Some(transmute(
                    notify_overwrite_mode_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_placeholder_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(transmute(
                    notify_placeholder_text_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_populate_all_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_populate_all_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::populate-all\0".as_ptr() as *const _,
                Some(transmute(
                    notify_populate_all_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_activatable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_activatable_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_gicon_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_gicon_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_name_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-name\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_name_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_pixbuf_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-pixbuf\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_pixbuf_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_sensitive_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_sensitive_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_storage_type_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_storage_type_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_markup_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_tooltip_markup_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_text_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute(
                    notify_primary_icon_tooltip_text_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_progress_fraction_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_fraction_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-fraction\0".as_ptr() as *const _,
                Some(transmute(
                    notify_progress_fraction_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_progress_pulse_step_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_pulse_step_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-pulse-step\0".as_ptr() as *const _,
                Some(transmute(
                    notify_progress_pulse_step_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_scroll_offset_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-offset\0".as_ptr() as *const _,
                Some(transmute(
                    notify_scroll_offset_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_activatable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_activatable_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_gicon_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_gicon_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_name_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-name\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_name_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_pixbuf_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-pixbuf\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_pixbuf_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_sensitive_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_sensitive_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_storage_type_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_storage_type_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_markup_trampoline<
            P,
            F: Fn(&P) + 'static,
        >(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_tooltip_markup_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_text_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute(
                    notify_secondary_icon_tooltip_text_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_selection_bound_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_bound_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-bound\0".as_ptr() as *const _,
                Some(transmute(
                    notify_selection_bound_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_shadow_type_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::shadow-type\0".as_ptr() as *const _,
                Some(transmute(notify_shadow_type_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_show_emoji_icon_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_emoji_icon_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-emoji-icon\0".as_ptr() as *const _,
                Some(transmute(
                    notify_show_emoji_icon_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute(notify_tabs_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute(notify_text_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_length_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-length\0".as_ptr() as *const _,
                Some(transmute(notify_text_length_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_truncate_multiline_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::truncate-multiline\0".as_ptr() as *const _,
                Some(transmute(
                    notify_truncate_multiline_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visibility\0".as_ptr() as *const _,
                Some(transmute(notify_visibility_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(transmute(notify_width_chars_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xalign_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkEntry,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Entry>,
        {
            let f: &F = &*(f as *const F);
            f(&Entry::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::xalign\0".as_ptr() as *const _,
                Some(transmute(notify_xalign_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Entry {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Entry")
    }
}
