/* gtd-sidebar.h
 *
 * Copyright 2018 Georges Basile Stavracas Neto <georges.stavracas@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTD_TYPE_SIDEBAR (gtd_sidebar_get_type())

G_DECLARE_FINAL_TYPE (GtdSidebar, gtd_sidebar, GTD, SIDEBAR, GtkBox)

void                 gtd_sidebar_set_panel_stack                 (GtdSidebar         *self,
                                                                  GtkStack           *stack);

void                 gtd_sidebar_set_task_list_panel             (GtdSidebar         *self,
                                                                  GtdPanel           *task_list_panel);

void                 gtd_sidebar_activate                        (GtdSidebar         *self);

G_END_DECLS
