# Contributing

We welcome contributions of all types!

## Code of Conduct

The Text Editor project is governed by the
[https://wiki.gnome.org/Foundation/CodeOfConduct](GNOME Code of Conduct)
and contributors are expected to adhere to that.

## Design First

The Text Editor project focuses on design before code. If you'd like to add new
features to Text Editor, coordinate with the GNOME Design Team to work on
mockups and think through how the feature will affect other features. Often
times, adding a new feature can alter how we present other features.

You can find mockups for Text Editor on the GNOME Design Team's
[https://gitlab.gnome.org/Teams/Design/app-mockups/-/tree/master/text-editor](text editor mockups)
repository.

File an issue at [Teams/Design/Whiteboards](https://gitlab.gnome.org/Teams/Design/whiteboards/) to start that process.
Out of the design process, we expect the following:

 * A mockup if changing UI components.
 * A specification of the implementation, and what should be implemented and what should not be implemented.
 * A breakdown of what existing code will be affected.
 * If there are any side-effects to the change that will affect other modules in the code-base.

## Coding Style

Text Editor follows the GTK coding style which is similar to the GNU style.

