/* puzzle.c generated by valac 0.24.0.146-7a48b, the Vala compiler
 * generated from puzzle.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>


#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint north;
	gint west;
	gint east;
	gint south;
	guint x;
	guint y;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};

struct _PuzzlePrivate {
	guint _size;
	Tile** board;
	gint board_length1;
	gint board_length2;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	gboolean _paused;
};


static gpointer tile_parent_class = NULL;
static gpointer puzzle_parent_class = NULL;

GType tile_get_type (void) G_GNUC_CONST;
enum  {
	TILE_DUMMY_PROPERTY
};
Tile* tile_new (guint x, guint y);
Tile* tile_construct (GType object_type, guint x, guint y);
static void tile_finalize (GObject* obj);
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE, PuzzlePrivate))
enum  {
	PUZZLE_DUMMY_PROPERTY,
	PUZZLE_SIZE,
	PUZZLE_ELAPSED,
	PUZZLE_PAUSED,
	PUZZLE_IS_SOLVED,
	PUZZLE_CAN_MOVE_UP,
	PUZZLE_CAN_MOVE_DOWN,
	PUZZLE_CAN_MOVE_LEFT,
	PUZZLE_CAN_MOVE_RIGHT
};
Puzzle* puzzle_new (guint size);
Puzzle* puzzle_construct (GType object_type, guint size);
static void puzzle_start_clock (Puzzle* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Tile* puzzle_get_tile (Puzzle* self, guint x, guint y);
void puzzle_get_tile_location (Puzzle* self, Tile* tile, guint* x, guint* y);
guint puzzle_get_size (Puzzle* self);
gboolean puzzle_tile_fits (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
gboolean puzzle_can_switch (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
void puzzle_switch_tiles (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
gboolean puzzle_get_is_solved (Puzzle* self);
static void puzzle_stop_clock (Puzzle* self);
void puzzle_move_up (Puzzle* self);
gboolean puzzle_get_can_move_up (Puzzle* self);
void puzzle_move_down (Puzzle* self);
gboolean puzzle_get_can_move_down (Puzzle* self);
void puzzle_move_left (Puzzle* self);
gboolean puzzle_get_can_move_left (Puzzle* self);
void puzzle_move_right (Puzzle* self);
gboolean puzzle_get_can_move_right (Puzzle* self);
void puzzle_solve (Puzzle* self);
static gboolean puzzle_timeout_cb (Puzzle* self);
static void puzzle_continue_clock (Puzzle* self);
static gboolean _puzzle_timeout_cb_gsource_func (gpointer self);
gdouble puzzle_get_elapsed (Puzzle* self);
gboolean puzzle_get_paused (Puzzle* self);
void puzzle_set_paused (Puzzle* self, gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void puzzle_finalize (GObject* obj);
static void _vala_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Tile* tile_construct (GType object_type, guint x, guint y) {
	Tile * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (Tile*) g_object_new (object_type, NULL);
	_tmp0_ = x;
	self->x = _tmp0_;
	_tmp1_ = y;
	self->y = _tmp1_;
	return self;
}


Tile* tile_new (guint x, guint y) {
	return tile_construct (TYPE_TILE, x, y);
}


static void tile_class_init (TileClass * klass) {
	tile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tile_finalize;
}


static void tile_instance_init (Tile * self) {
}


static void tile_finalize (GObject* obj) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
	G_OBJECT_CLASS (tile_parent_class)->finalize (obj);
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, NULL };
		GType tile_type_id;
		tile_type_id = g_type_register_static (G_TYPE_OBJECT, "Tile", &g_define_type_info, 0);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


Puzzle* puzzle_construct (GType object_type, guint size) {
	Puzzle * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Tile** _tmp3_ = NULL;
	GList* tiles = NULL;
	self = (Puzzle*) g_object_new (object_type, NULL);
	_tmp0_ = size;
	self->priv->_size = _tmp0_;
	_tmp1_ = size;
	_tmp2_ = size;
	_tmp3_ = g_new0 (Tile*, ((_tmp1_ * 2) * _tmp2_) + 1);
	self->priv->board = (_vala_array_free (self->priv->board, self->priv->board_length1 * self->priv->board_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->board = _tmp3_;
	self->priv->board_length1 = _tmp1_ * 2;
	self->priv->board_length2 = _tmp2_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				guint _tmp7_ = 0U;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = size;
				if (!(((guint) _tmp6_) < _tmp7_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							guint _tmp11_ = 0U;
							Tile** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp12__length2 = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Tile* _tmp17_ = NULL;
							Tile* _tmp18_ = NULL;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = y;
								y = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = y;
							_tmp11_ = size;
							if (!(((guint) _tmp10_) < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->board;
							_tmp12__length1 = self->priv->board_length1;
							_tmp12__length2 = self->priv->board_length2;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = tile_new ((guint) _tmp15_, (guint) _tmp16_);
							_g_object_unref0 (_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_]);
							_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = _tmp17_;
							_tmp18_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint _tmp21_ = 0;
				guint _tmp22_ = 0U;
				if (!_tmp19_) {
					gint _tmp20_ = 0;
					_tmp20_ = x;
					x = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = x;
				_tmp22_ = size;
				if (!(((guint) _tmp21_) < _tmp22_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint _tmp25_ = 0;
							guint _tmp26_ = 0U;
							gint32 n = 0;
							gint32 _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp34_ = 0;
							guint _tmp35_ = 0U;
							if (!_tmp23_) {
								gint _tmp24_ = 0;
								_tmp24_ = y;
								y = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = y;
							_tmp26_ = size;
							if (!(((guint) _tmp25_) <= _tmp26_)) {
								break;
							}
							_tmp27_ = g_random_int_range ((gint32) 0, (gint32) 10);
							n = _tmp27_;
							_tmp28_ = y;
							if ((_tmp28_ - 1) >= 0) {
								Tile** _tmp29_ = NULL;
								gint _tmp29__length1 = 0;
								gint _tmp29__length2 = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Tile* _tmp32_ = NULL;
								gint32 _tmp33_ = 0;
								_tmp29_ = self->priv->board;
								_tmp29__length1 = self->priv->board_length1;
								_tmp29__length2 = self->priv->board_length2;
								_tmp30_ = x;
								_tmp31_ = y;
								_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + (_tmp31_ - 1)];
								_tmp33_ = n;
								_tmp32_->south = (gint) _tmp33_;
							}
							_tmp34_ = y;
							_tmp35_ = size;
							if (((guint) _tmp34_) < _tmp35_) {
								Tile** _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
								gint _tmp36__length2 = 0;
								gint _tmp37_ = 0;
								gint _tmp38_ = 0;
								Tile* _tmp39_ = NULL;
								gint32 _tmp40_ = 0;
								_tmp36_ = self->priv->board;
								_tmp36__length1 = self->priv->board_length1;
								_tmp36__length2 = self->priv->board_length2;
								_tmp37_ = x;
								_tmp38_ = y;
								_tmp39_ = _tmp36_[(_tmp37_ * _tmp36__length2) + _tmp38_];
								_tmp40_ = n;
								_tmp39_->north = (gint) _tmp40_;
							}
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_ = 0;
				guint _tmp44_ = 0U;
				if (!_tmp41_) {
					gint _tmp42_ = 0;
					_tmp42_ = x;
					x = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = x;
				_tmp44_ = size;
				if (!(((guint) _tmp43_) <= _tmp44_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gint _tmp47_ = 0;
							guint _tmp48_ = 0U;
							gint32 n = 0;
							gint32 _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp56_ = 0;
							guint _tmp57_ = 0U;
							if (!_tmp45_) {
								gint _tmp46_ = 0;
								_tmp46_ = y;
								y = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = y;
							_tmp48_ = size;
							if (!(((guint) _tmp47_) < _tmp48_)) {
								break;
							}
							_tmp49_ = g_random_int_range ((gint32) 0, (gint32) 10);
							n = _tmp49_;
							_tmp50_ = x;
							if ((_tmp50_ - 1) >= 0) {
								Tile** _tmp51_ = NULL;
								gint _tmp51__length1 = 0;
								gint _tmp51__length2 = 0;
								gint _tmp52_ = 0;
								gint _tmp53_ = 0;
								Tile* _tmp54_ = NULL;
								gint32 _tmp55_ = 0;
								_tmp51_ = self->priv->board;
								_tmp51__length1 = self->priv->board_length1;
								_tmp51__length2 = self->priv->board_length2;
								_tmp52_ = x;
								_tmp53_ = y;
								_tmp54_ = _tmp51_[((_tmp52_ - 1) * _tmp51__length2) + _tmp53_];
								_tmp55_ = n;
								_tmp54_->east = (gint) _tmp55_;
							}
							_tmp56_ = x;
							_tmp57_ = size;
							if (((guint) _tmp56_) < _tmp57_) {
								Tile** _tmp58_ = NULL;
								gint _tmp58__length1 = 0;
								gint _tmp58__length2 = 0;
								gint _tmp59_ = 0;
								gint _tmp60_ = 0;
								Tile* _tmp61_ = NULL;
								gint32 _tmp62_ = 0;
								_tmp58_ = self->priv->board;
								_tmp58__length1 = self->priv->board_length1;
								_tmp58__length2 = self->priv->board_length2;
								_tmp59_ = x;
								_tmp60_ = y;
								_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
								_tmp62_ = n;
								_tmp61_->west = (gint) _tmp62_;
							}
						}
					}
				}
			}
		}
	}
	tiles = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gint _tmp65_ = 0;
				guint _tmp66_ = 0U;
				if (!_tmp63_) {
					gint _tmp64_ = 0;
					_tmp64_ = x;
					x = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp65_ = x;
				_tmp66_ = size;
				if (!(((guint) _tmp65_) < _tmp66_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp67_ = FALSE;
						_tmp67_ = TRUE;
						while (TRUE) {
							gint _tmp69_ = 0;
							guint _tmp70_ = 0U;
							Tile** _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							Tile* _tmp74_ = NULL;
							Tile* _tmp75_ = NULL;
							Tile** _tmp76_ = NULL;
							gint _tmp76__length1 = 0;
							gint _tmp76__length2 = 0;
							gint _tmp77_ = 0;
							gint _tmp78_ = 0;
							Tile* _tmp79_ = NULL;
							if (!_tmp67_) {
								gint _tmp68_ = 0;
								_tmp68_ = y;
								y = _tmp68_ + 1;
							}
							_tmp67_ = FALSE;
							_tmp69_ = y;
							_tmp70_ = size;
							if (!(((guint) _tmp69_) < _tmp70_)) {
								break;
							}
							_tmp71_ = self->priv->board;
							_tmp71__length1 = self->priv->board_length1;
							_tmp71__length2 = self->priv->board_length2;
							_tmp72_ = x;
							_tmp73_ = y;
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
							_tmp75_ = _g_object_ref0 (_tmp74_);
							tiles = g_list_append (tiles, _tmp75_);
							_tmp76_ = self->priv->board;
							_tmp76__length1 = self->priv->board_length1;
							_tmp76__length2 = self->priv->board_length2;
							_tmp77_ = x;
							_tmp78_ = y;
							_g_object_unref0 (_tmp76_[(_tmp77_ * _tmp76__length2) + _tmp78_]);
							_tmp76_[(_tmp77_ * _tmp76__length2) + _tmp78_] = NULL;
							_tmp79_ = _tmp76_[(_tmp77_ * _tmp76__length2) + _tmp78_];
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gint _tmp82_ = 0;
				guint _tmp83_ = 0U;
				if (!_tmp80_) {
					gint _tmp81_ = 0;
					_tmp81_ = x;
					x = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				_tmp82_ = x;
				_tmp83_ = size;
				if (!(((guint) _tmp82_) < _tmp83_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp84_ = FALSE;
						_tmp84_ = TRUE;
						while (TRUE) {
							gint _tmp86_ = 0;
							guint _tmp87_ = 0U;
							gint32 n = 0;
							GList* _tmp88_ = NULL;
							guint _tmp89_ = 0U;
							gint32 _tmp90_ = 0;
							Tile* tile = NULL;
							GList* _tmp91_ = NULL;
							gint32 _tmp92_ = 0;
							gconstpointer _tmp93_ = NULL;
							Tile* _tmp94_ = NULL;
							Tile** _tmp95_ = NULL;
							gint _tmp95__length1 = 0;
							gint _tmp95__length2 = 0;
							gint _tmp96_ = 0;
							guint _tmp97_ = 0U;
							gint _tmp98_ = 0;
							Tile* _tmp99_ = NULL;
							Tile* _tmp100_ = NULL;
							Tile* _tmp101_ = NULL;
							Tile* _tmp102_ = NULL;
							if (!_tmp84_) {
								gint _tmp85_ = 0;
								_tmp85_ = y;
								y = _tmp85_ + 1;
							}
							_tmp84_ = FALSE;
							_tmp86_ = y;
							_tmp87_ = size;
							if (!(((guint) _tmp86_) < _tmp87_)) {
								break;
							}
							_tmp88_ = tiles;
							_tmp89_ = g_list_length (_tmp88_);
							_tmp90_ = g_random_int_range ((gint32) 0, (gint32) _tmp89_);
							n = _tmp90_;
							_tmp91_ = tiles;
							_tmp92_ = n;
							_tmp93_ = g_list_nth_data (_tmp91_, (guint) _tmp92_);
							_tmp94_ = _g_object_ref0 ((Tile*) _tmp93_);
							tile = _tmp94_;
							_tmp95_ = self->priv->board;
							_tmp95__length1 = self->priv->board_length1;
							_tmp95__length2 = self->priv->board_length2;
							_tmp96_ = x;
							_tmp97_ = size;
							_tmp98_ = y;
							_tmp99_ = tile;
							_tmp100_ = _g_object_ref0 (_tmp99_);
							_g_object_unref0 (_tmp95_[((_tmp96_ + _tmp97_) * _tmp95__length2) + _tmp98_]);
							_tmp95_[((_tmp96_ + _tmp97_) * _tmp95__length2) + _tmp98_] = _tmp100_;
							_tmp101_ = _tmp95_[((_tmp96_ + _tmp97_) * _tmp95__length2) + _tmp98_];
							_tmp102_ = tile;
							tiles = g_list_remove (tiles, _tmp102_);
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	puzzle_start_clock (self);
	__g_list_free__g_object_unref0_0 (tiles);
	return self;
}


Puzzle* puzzle_new (guint size) {
	return puzzle_construct (TYPE_PUZZLE, size);
}


Tile* puzzle_get_tile (Puzzle* self, guint x, guint y) {
	Tile* result = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Tile* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->board;
	_tmp0__length1 = self->priv->board_length1;
	_tmp0__length2 = self->priv->board_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


void puzzle_get_tile_location (Puzzle* self, Tile* tile, guint* x, guint* y) {
	guint _vala_x = 0U;
	guint _vala_y = 0U;
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_vala_y = (guint) 0;
	_tmp0_ = _vala_y;
	_vala_x = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_vala_x = (guint) 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			guint _tmp3_ = 0U;
			guint _tmp4_ = 0U;
			guint _tmp5_ = 0U;
			if (!_tmp1_) {
				guint _tmp2_ = 0U;
				_tmp2_ = _vala_x;
				_vala_x = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp3_ = _vala_x;
			_tmp4_ = puzzle_get_size (self);
			_tmp5_ = _tmp4_;
			if (!(_tmp3_ < (_tmp5_ * 2))) {
				break;
			}
			{
				gboolean _tmp6_ = FALSE;
				_vala_y = (guint) 0;
				_tmp6_ = TRUE;
				while (TRUE) {
					guint _tmp8_ = 0U;
					guint _tmp9_ = 0U;
					guint _tmp10_ = 0U;
					Tile** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp11__length2 = 0;
					guint _tmp12_ = 0U;
					guint _tmp13_ = 0U;
					Tile* _tmp14_ = NULL;
					Tile* _tmp15_ = NULL;
					if (!_tmp6_) {
						guint _tmp7_ = 0U;
						_tmp7_ = _vala_y;
						_vala_y = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = _vala_y;
					_tmp9_ = puzzle_get_size (self);
					_tmp10_ = _tmp9_;
					if (!(_tmp8_ < _tmp10_)) {
						break;
					}
					_tmp11_ = self->priv->board;
					_tmp11__length1 = self->priv->board_length1;
					_tmp11__length2 = self->priv->board_length2;
					_tmp12_ = _vala_x;
					_tmp13_ = _vala_y;
					_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
					_tmp15_ = tile;
					if (_tmp14_ == _tmp15_) {
						if (x) {
							*x = _vala_x;
						}
						if (y) {
							*y = _vala_y;
						}
						return;
					}
				}
			}
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


gboolean puzzle_tile_fits (Puzzle* self, guint x0, guint y0, guint x1, guint y1) {
	gboolean result = FALSE;
	Tile* tile = NULL;
	Tile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Tile* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	Tile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	guint _tmp9_ = 0U;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	guint _tmp51_ = 0U;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	guint _tmp71_ = 0U;
	guint _tmp72_ = 0U;
	guint _tmp73_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->board;
	_tmp0__length1 = self->priv->board_length1;
	_tmp0__length2 = self->priv->board_length2;
	_tmp1_ = x0;
	_tmp2_ = y0;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tile = _tmp4_;
	_tmp5_ = tile;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (tile);
		return result;
	}
	_tmp9_ = x1;
	if (_tmp9_ > ((guint) 0)) {
		gboolean _tmp10_ = FALSE;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp11_ = x1;
		_tmp12_ = x0;
		if ((_tmp11_ - 1) == _tmp12_) {
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			_tmp13_ = y1;
			_tmp14_ = y0;
			_tmp10_ = _tmp13_ == _tmp14_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp8_ = !_tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Tile** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp15__length2 = 0;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		Tile* _tmp18_ = NULL;
		_tmp15_ = self->priv->board;
		_tmp15__length1 = self->priv->board_length1;
		_tmp15__length2 = self->priv->board_length2;
		_tmp16_ = x1;
		_tmp17_ = y1;
		_tmp18_ = _tmp15_[((_tmp16_ - 1) * _tmp15__length2) + _tmp17_];
		_tmp7_ = _tmp18_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		Tile** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp19__length2 = 0;
		guint _tmp20_ = 0U;
		guint _tmp21_ = 0U;
		Tile* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		Tile* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		_tmp19_ = self->priv->board;
		_tmp19__length1 = self->priv->board_length1;
		_tmp19__length2 = self->priv->board_length2;
		_tmp20_ = x1;
		_tmp21_ = y1;
		_tmp22_ = _tmp19_[((_tmp20_ - 1) * _tmp19__length2) + _tmp21_];
		_tmp23_ = _tmp22_->east;
		_tmp24_ = tile;
		_tmp25_ = _tmp24_->west;
		_tmp6_ = _tmp23_ != _tmp25_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (tile);
		return result;
	}
	_tmp29_ = x1;
	_tmp30_ = puzzle_get_size (self);
	_tmp31_ = _tmp30_;
	if (_tmp29_ < (_tmp31_ - 1)) {
		gboolean _tmp32_ = FALSE;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		_tmp33_ = x1;
		_tmp34_ = x0;
		if ((_tmp33_ + 1) == _tmp34_) {
			guint _tmp35_ = 0U;
			guint _tmp36_ = 0U;
			_tmp35_ = y1;
			_tmp36_ = y0;
			_tmp32_ = _tmp35_ == _tmp36_;
		} else {
			_tmp32_ = FALSE;
		}
		_tmp28_ = !_tmp32_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		Tile** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gint _tmp37__length2 = 0;
		guint _tmp38_ = 0U;
		guint _tmp39_ = 0U;
		Tile* _tmp40_ = NULL;
		_tmp37_ = self->priv->board;
		_tmp37__length1 = self->priv->board_length1;
		_tmp37__length2 = self->priv->board_length2;
		_tmp38_ = x1;
		_tmp39_ = y1;
		_tmp40_ = _tmp37_[((_tmp38_ + 1) * _tmp37__length2) + _tmp39_];
		_tmp27_ = _tmp40_ != NULL;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		Tile** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gint _tmp41__length2 = 0;
		guint _tmp42_ = 0U;
		guint _tmp43_ = 0U;
		Tile* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		Tile* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		_tmp41_ = self->priv->board;
		_tmp41__length1 = self->priv->board_length1;
		_tmp41__length2 = self->priv->board_length2;
		_tmp42_ = x1;
		_tmp43_ = y1;
		_tmp44_ = _tmp41_[((_tmp42_ + 1) * _tmp41__length2) + _tmp43_];
		_tmp45_ = _tmp44_->west;
		_tmp46_ = tile;
		_tmp47_ = _tmp46_->east;
		_tmp26_ = _tmp45_ != _tmp47_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = FALSE;
		_g_object_unref0 (tile);
		return result;
	}
	_tmp51_ = y1;
	if (_tmp51_ > ((guint) 0)) {
		gboolean _tmp52_ = FALSE;
		guint _tmp53_ = 0U;
		guint _tmp54_ = 0U;
		_tmp53_ = x1;
		_tmp54_ = x0;
		if (_tmp53_ == _tmp54_) {
			guint _tmp55_ = 0U;
			guint _tmp56_ = 0U;
			_tmp55_ = y1;
			_tmp56_ = y0;
			_tmp52_ = (_tmp55_ - 1) == _tmp56_;
		} else {
			_tmp52_ = FALSE;
		}
		_tmp50_ = !_tmp52_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		Tile** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gint _tmp57__length2 = 0;
		guint _tmp58_ = 0U;
		guint _tmp59_ = 0U;
		Tile* _tmp60_ = NULL;
		_tmp57_ = self->priv->board;
		_tmp57__length1 = self->priv->board_length1;
		_tmp57__length2 = self->priv->board_length2;
		_tmp58_ = x1;
		_tmp59_ = y1;
		_tmp60_ = _tmp57_[(_tmp58_ * _tmp57__length2) + (_tmp59_ - 1)];
		_tmp49_ = _tmp60_ != NULL;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		Tile** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp61__length2 = 0;
		guint _tmp62_ = 0U;
		guint _tmp63_ = 0U;
		Tile* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		Tile* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		_tmp61_ = self->priv->board;
		_tmp61__length1 = self->priv->board_length1;
		_tmp61__length2 = self->priv->board_length2;
		_tmp62_ = x1;
		_tmp63_ = y1;
		_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + (_tmp63_ - 1)];
		_tmp65_ = _tmp64_->south;
		_tmp66_ = tile;
		_tmp67_ = _tmp66_->north;
		_tmp48_ = _tmp65_ != _tmp67_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		result = FALSE;
		_g_object_unref0 (tile);
		return result;
	}
	_tmp71_ = y1;
	_tmp72_ = puzzle_get_size (self);
	_tmp73_ = _tmp72_;
	if (_tmp71_ < (_tmp73_ - 1)) {
		gboolean _tmp74_ = FALSE;
		guint _tmp75_ = 0U;
		guint _tmp76_ = 0U;
		_tmp75_ = x1;
		_tmp76_ = x0;
		if (_tmp75_ == _tmp76_) {
			guint _tmp77_ = 0U;
			guint _tmp78_ = 0U;
			_tmp77_ = y1;
			_tmp78_ = y0;
			_tmp74_ = (_tmp77_ + 1) == _tmp78_;
		} else {
			_tmp74_ = FALSE;
		}
		_tmp70_ = !_tmp74_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		Tile** _tmp79_ = NULL;
		gint _tmp79__length1 = 0;
		gint _tmp79__length2 = 0;
		guint _tmp80_ = 0U;
		guint _tmp81_ = 0U;
		Tile* _tmp82_ = NULL;
		_tmp79_ = self->priv->board;
		_tmp79__length1 = self->priv->board_length1;
		_tmp79__length2 = self->priv->board_length2;
		_tmp80_ = x1;
		_tmp81_ = y1;
		_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + (_tmp81_ + 1)];
		_tmp69_ = _tmp82_ != NULL;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		Tile** _tmp83_ = NULL;
		gint _tmp83__length1 = 0;
		gint _tmp83__length2 = 0;
		guint _tmp84_ = 0U;
		guint _tmp85_ = 0U;
		Tile* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		Tile* _tmp88_ = NULL;
		gint _tmp89_ = 0;
		_tmp83_ = self->priv->board;
		_tmp83__length1 = self->priv->board_length1;
		_tmp83__length2 = self->priv->board_length2;
		_tmp84_ = x1;
		_tmp85_ = y1;
		_tmp86_ = _tmp83_[(_tmp84_ * _tmp83__length2) + (_tmp85_ + 1)];
		_tmp87_ = _tmp86_->north;
		_tmp88_ = tile;
		_tmp89_ = _tmp88_->south;
		_tmp68_ = _tmp87_ != _tmp89_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		result = FALSE;
		_g_object_unref0 (tile);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (tile);
	return result;
}


gboolean puzzle_can_switch (Puzzle* self, guint x0, guint y0, guint x1, guint y1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Tile* t0 = NULL;
	Tile** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Tile* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	Tile* t1 = NULL;
	Tile** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	Tile* _tmp13_ = NULL;
	Tile* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	Tile* _tmp16_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	Tile* _tmp20_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	Tile* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = x0;
	_tmp2_ = x1;
	if (_tmp1_ == _tmp2_) {
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp3_ = y0;
		_tmp4_ = y1;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->board;
	_tmp5__length1 = self->priv->board_length1;
	_tmp5__length2 = self->priv->board_length2;
	_tmp6_ = x0;
	_tmp7_ = y0;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	t0 = _tmp9_;
	_tmp10_ = self->priv->board;
	_tmp10__length1 = self->priv->board_length1;
	_tmp10__length2 = self->priv->board_length2;
	_tmp11_ = x1;
	_tmp12_ = y1;
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
	_tmp14_ = _g_object_ref0 (_tmp13_);
	t1 = _tmp14_;
	_tmp16_ = t0;
	if (_tmp16_ == NULL) {
		Tile* _tmp17_ = NULL;
		_tmp17_ = t1;
		_tmp15_ = _tmp17_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		result = FALSE;
		_g_object_unref0 (t1);
		_g_object_unref0 (t0);
		return result;
	}
	_tmp20_ = t0;
	if (_tmp20_ != NULL) {
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		guint _tmp23_ = 0U;
		_tmp21_ = x1;
		_tmp22_ = puzzle_get_size (self);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp21_ < _tmp23_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		guint _tmp24_ = 0U;
		guint _tmp25_ = 0U;
		guint _tmp26_ = 0U;
		guint _tmp27_ = 0U;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = x0;
		_tmp25_ = y0;
		_tmp26_ = x1;
		_tmp27_ = y1;
		_tmp28_ = puzzle_tile_fits (self, _tmp24_, _tmp25_, _tmp26_, _tmp27_);
		_tmp18_ = !_tmp28_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		result = FALSE;
		_g_object_unref0 (t1);
		_g_object_unref0 (t0);
		return result;
	}
	_tmp31_ = t1;
	if (_tmp31_ != NULL) {
		guint _tmp32_ = 0U;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		_tmp32_ = x0;
		_tmp33_ = puzzle_get_size (self);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp32_ < _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		guint _tmp35_ = 0U;
		guint _tmp36_ = 0U;
		guint _tmp37_ = 0U;
		guint _tmp38_ = 0U;
		gboolean _tmp39_ = FALSE;
		_tmp35_ = x1;
		_tmp36_ = y1;
		_tmp37_ = x0;
		_tmp38_ = y0;
		_tmp39_ = puzzle_tile_fits (self, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
		_tmp29_ = !_tmp39_;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		result = FALSE;
		_g_object_unref0 (t1);
		_g_object_unref0 (t0);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (t1);
	_g_object_unref0 (t0);
	return result;
}


void puzzle_switch_tiles (Puzzle* self, guint x0, guint y0, guint x1, guint y1) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Tile* t0 = NULL;
	Tile** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Tile* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	Tile* t1 = NULL;
	Tile** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	Tile* _tmp13_ = NULL;
	Tile* _tmp14_ = NULL;
	Tile** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp15__length2 = 0;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	Tile* _tmp18_ = NULL;
	Tile* _tmp19_ = NULL;
	Tile* _tmp20_ = NULL;
	Tile** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	Tile* _tmp24_ = NULL;
	Tile* _tmp25_ = NULL;
	Tile* _tmp26_ = NULL;
	Tile* _tmp27_ = NULL;
	Tile* _tmp31_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = x0;
	_tmp2_ = x1;
	if (_tmp1_ == _tmp2_) {
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp3_ = y0;
		_tmp4_ = y1;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->priv->board;
	_tmp5__length1 = self->priv->board_length1;
	_tmp5__length2 = self->priv->board_length2;
	_tmp6_ = x0;
	_tmp7_ = y0;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	t0 = _tmp9_;
	_tmp10_ = self->priv->board;
	_tmp10__length1 = self->priv->board_length1;
	_tmp10__length2 = self->priv->board_length2;
	_tmp11_ = x1;
	_tmp12_ = y1;
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
	_tmp14_ = _g_object_ref0 (_tmp13_);
	t1 = _tmp14_;
	_tmp15_ = self->priv->board;
	_tmp15__length1 = self->priv->board_length1;
	_tmp15__length2 = self->priv->board_length2;
	_tmp16_ = x0;
	_tmp17_ = y0;
	_tmp18_ = t1;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_]);
	_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp19_;
	_tmp20_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
	_tmp21_ = self->priv->board;
	_tmp21__length1 = self->priv->board_length1;
	_tmp21__length2 = self->priv->board_length2;
	_tmp22_ = x1;
	_tmp23_ = y1;
	_tmp24_ = t0;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_]);
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp25_;
	_tmp26_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
	_tmp27_ = t0;
	if (_tmp27_ != NULL) {
		Tile* _tmp28_ = NULL;
		guint _tmp29_ = 0U;
		guint _tmp30_ = 0U;
		_tmp28_ = t0;
		_tmp29_ = x1;
		_tmp30_ = y1;
		g_signal_emit_by_name (self, "tile-moved", _tmp28_, _tmp29_, _tmp30_);
	}
	_tmp31_ = t1;
	if (_tmp31_ != NULL) {
		Tile* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		_tmp32_ = t1;
		_tmp33_ = x0;
		_tmp34_ = y0;
		g_signal_emit_by_name (self, "tile-moved", _tmp32_, _tmp33_, _tmp34_);
	}
	_tmp35_ = puzzle_get_is_solved (self);
	_tmp36_ = _tmp35_;
	if (_tmp36_) {
		puzzle_stop_clock (self);
		g_signal_emit_by_name (self, "solved");
	}
	_g_object_unref0 (t1);
	_g_object_unref0 (t0);
}


void puzzle_move_up (Puzzle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_get_can_move_up (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint y = 0;
		y = 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				guint _tmp5_ = 0U;
				guint _tmp6_ = 0U;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = y;
					y = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = y;
				_tmp5_ = puzzle_get_size (self);
				_tmp6_ = _tmp5_;
				if (!(((guint) _tmp4_) < _tmp6_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = x;
								x = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = x;
							_tmp10_ = puzzle_get_size (self);
							_tmp11_ = _tmp10_;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = x;
							_tmp15_ = y;
							puzzle_switch_tiles (self, (guint) _tmp12_, (guint) _tmp13_, (guint) _tmp14_, (guint) (_tmp15_ - 1));
						}
					}
				}
			}
		}
	}
}


void puzzle_move_down (Puzzle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_get_can_move_down (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint y = 0;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		_tmp2_ = puzzle_get_size (self);
		_tmp3_ = _tmp2_;
		y = ((gint) _tmp3_) - 2;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = y;
					y = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = y;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = x;
								x = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = x;
							_tmp10_ = puzzle_get_size (self);
							_tmp11_ = _tmp10_;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = x;
							_tmp15_ = y;
							puzzle_switch_tiles (self, (guint) _tmp12_, (guint) _tmp13_, (guint) _tmp14_, (guint) (_tmp15_ + 1));
						}
					}
				}
			}
		}
	}
}


void puzzle_move_left (Puzzle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_get_can_move_left (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint x = 0;
		x = 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				guint _tmp5_ = 0U;
				guint _tmp6_ = 0U;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = x;
				_tmp5_ = puzzle_get_size (self);
				_tmp6_ = _tmp5_;
				if (!(((guint) _tmp4_) < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = puzzle_get_size (self);
							_tmp11_ = _tmp10_;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = x;
							_tmp15_ = y;
							puzzle_switch_tiles (self, (guint) _tmp12_, (guint) _tmp13_, (guint) (_tmp14_ - 1), (guint) _tmp15_);
						}
					}
				}
			}
		}
	}
}


void puzzle_move_right (Puzzle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_get_can_move_right (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint x = 0;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		_tmp2_ = puzzle_get_size (self);
		_tmp3_ = _tmp2_;
		x = ((gint) _tmp3_) - 2;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = x;
					x = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = x;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = puzzle_get_size (self);
							_tmp11_ = _tmp10_;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = x;
							_tmp15_ = y;
							puzzle_switch_tiles (self, (guint) _tmp12_, (guint) _tmp13_, (guint) (_tmp14_ + 1), (guint) _tmp15_);
						}
					}
				}
			}
		}
	}
}


void puzzle_solve (Puzzle* self) {
	GList* wrong_tiles = NULL;
	GList* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	wrong_tiles = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < (_tmp4_ * 2))) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							guint _tmp8_ = 0U;
							guint _tmp9_ = 0U;
							Tile* tile = NULL;
							Tile** _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							Tile* _tmp13_ = NULL;
							Tile* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							Tile* _tmp16_ = NULL;
							Tile** _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							gint _tmp26__length2 = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							Tile* _tmp29_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = y;
							_tmp8_ = puzzle_get_size (self);
							_tmp9_ = _tmp8_;
							if (!(((guint) _tmp7_) < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->board;
							_tmp10__length1 = self->priv->board_length1;
							_tmp10__length2 = self->priv->board_length2;
							_tmp11_ = x;
							_tmp12_ = y;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							_tmp14_ = _g_object_ref0 (_tmp13_);
							tile = _tmp14_;
							_tmp16_ = tile;
							if (_tmp16_ != NULL) {
								gboolean _tmp17_ = FALSE;
								Tile* _tmp18_ = NULL;
								guint _tmp19_ = 0U;
								gint _tmp20_ = 0;
								_tmp18_ = tile;
								_tmp19_ = _tmp18_->x;
								_tmp20_ = x;
								if (_tmp19_ != ((guint) _tmp20_)) {
									_tmp17_ = TRUE;
								} else {
									Tile* _tmp21_ = NULL;
									guint _tmp22_ = 0U;
									gint _tmp23_ = 0;
									_tmp21_ = tile;
									_tmp22_ = _tmp21_->y;
									_tmp23_ = y;
									_tmp17_ = _tmp22_ != ((guint) _tmp23_);
								}
								_tmp15_ = _tmp17_;
							} else {
								_tmp15_ = FALSE;
							}
							if (_tmp15_) {
								Tile* _tmp24_ = NULL;
								Tile* _tmp25_ = NULL;
								_tmp24_ = tile;
								_tmp25_ = _g_object_ref0 (_tmp24_);
								wrong_tiles = g_list_append (wrong_tiles, _tmp25_);
							}
							_tmp26_ = self->priv->board;
							_tmp26__length1 = self->priv->board_length1;
							_tmp26__length2 = self->priv->board_length2;
							_tmp27_ = x;
							_tmp28_ = y;
							_g_object_unref0 (_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_]);
							_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = NULL;
							_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp30_ = wrong_tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp30_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp31_ = NULL;
			Tile* tile = NULL;
			_tmp31_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp31_;
			{
				Tile** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp32__length2 = 0;
				Tile* _tmp33_ = NULL;
				guint _tmp34_ = 0U;
				Tile* _tmp35_ = NULL;
				guint _tmp36_ = 0U;
				Tile* _tmp37_ = NULL;
				Tile* _tmp38_ = NULL;
				Tile* _tmp39_ = NULL;
				Tile* _tmp40_ = NULL;
				Tile* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				Tile* _tmp43_ = NULL;
				guint _tmp44_ = 0U;
				_tmp32_ = self->priv->board;
				_tmp32__length1 = self->priv->board_length1;
				_tmp32__length2 = self->priv->board_length2;
				_tmp33_ = tile;
				_tmp34_ = _tmp33_->x;
				_tmp35_ = tile;
				_tmp36_ = _tmp35_->y;
				_tmp37_ = tile;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_g_object_unref0 (_tmp32_[(_tmp34_ * _tmp32__length2) + _tmp36_]);
				_tmp32_[(_tmp34_ * _tmp32__length2) + _tmp36_] = _tmp38_;
				_tmp39_ = _tmp32_[(_tmp34_ * _tmp32__length2) + _tmp36_];
				_tmp40_ = tile;
				_tmp41_ = tile;
				_tmp42_ = _tmp41_->x;
				_tmp43_ = tile;
				_tmp44_ = _tmp43_->y;
				g_signal_emit_by_name (self, "tile-moved", _tmp40_, _tmp42_, _tmp44_);
				_g_object_unref0 (tile);
			}
		}
	}
	puzzle_stop_clock (self);
	__g_list_free__g_object_unref0_0 (wrong_tiles);
}


static void puzzle_start_clock (Puzzle* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	}
	puzzle_timeout_cb (self);
}


static void puzzle_stop_clock (Puzzle* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->clock_timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->clock_timeout;
		g_source_remove (_tmp2_);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp3_ = self->priv->clock;
	g_timer_stop (_tmp3_);
	g_signal_emit_by_name (self, "tick");
}


static void puzzle_continue_clock (Puzzle* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	} else {
		GTimer* _tmp2_ = NULL;
		_tmp2_ = self->priv->clock;
		g_timer_continue (_tmp2_);
	}
	puzzle_timeout_cb (self);
}


static gboolean _puzzle_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_timeout_cb ((Puzzle*) self);
	return result;
}


static gboolean puzzle_timeout_cb (Puzzle* self) {
	gboolean result = FALSE;
	gdouble elapsed = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gint next = 0;
	gdouble wait = 0.0;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->clock;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	elapsed = _tmp1_;
	next = (gint) (elapsed + 1.0);
	wait = next - elapsed;
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (wait * 1000)), _puzzle_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->clock_timeout = _tmp2_;
	g_signal_emit_by_name (self, "tick");
	result = FALSE;
	return result;
}


guint puzzle_get_size (Puzzle* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


gdouble puzzle_get_elapsed (Puzzle* self) {
	gdouble result;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		result = 0.0;
		return result;
	}
	_tmp1_ = self->priv->clock_elapsed;
	_tmp2_ = self->priv->clock;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	result = _tmp1_ + _tmp3_;
	return result;
}


gboolean puzzle_get_paused (Puzzle* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void puzzle_set_paused (Puzzle* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	_tmp1_ = self->priv->clock;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = value;
		if (_tmp2_) {
			puzzle_stop_clock (self);
		} else {
			puzzle_continue_clock (self);
		}
	}
	g_signal_emit_by_name (self, "paused-changed");
	g_object_notify ((GObject *) self, "paused");
}


gboolean puzzle_get_is_solved (Puzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							guint _tmp8_ = 0U;
							guint _tmp9_ = 0U;
							Tile* tile = NULL;
							Tile** _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							Tile* _tmp13_ = NULL;
							Tile* _tmp14_ = NULL;
							Tile* _tmp15_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = y;
							_tmp8_ = puzzle_get_size (self);
							_tmp9_ = _tmp8_;
							if (!(((guint) _tmp7_) < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->board;
							_tmp10__length1 = self->priv->board_length1;
							_tmp10__length2 = self->priv->board_length2;
							_tmp11_ = x;
							_tmp12_ = y;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							_tmp14_ = _g_object_ref0 (_tmp13_);
							tile = _tmp14_;
							_tmp15_ = tile;
							if (_tmp15_ == NULL) {
								result = FALSE;
								_g_object_unref0 (tile);
								return result;
							}
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean puzzle_get_can_move_up (Puzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Tile** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp6_ = 0;
				Tile* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->board;
				_tmp5__length1 = self->priv->board_length1;
				_tmp5__length2 = self->priv->board_length2;
				_tmp6_ = x;
				_tmp7_ = _tmp5_[(_tmp6_ * _tmp5__length2) + 0];
				if (_tmp7_ != NULL) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean puzzle_get_can_move_down (Puzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Tile** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp6_ = 0;
				guint _tmp7_ = 0U;
				guint _tmp8_ = 0U;
				Tile* _tmp9_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->board;
				_tmp5__length1 = self->priv->board_length1;
				_tmp5__length2 = self->priv->board_length2;
				_tmp6_ = x;
				_tmp7_ = puzzle_get_size (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp5_[(_tmp6_ * _tmp5__length2) + (_tmp8_ - 1)];
				if (_tmp9_ != NULL) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean puzzle_get_can_move_left (Puzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Tile** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp6_ = 0;
				Tile* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->board;
				_tmp5__length1 = self->priv->board_length1;
				_tmp5__length2 = self->priv->board_length2;
				_tmp6_ = y;
				_tmp7_ = _tmp5_[(0 * _tmp5__length2) + _tmp6_];
				if (_tmp7_ != NULL) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean puzzle_get_can_move_right (Puzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Tile** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				gint _tmp8_ = 0;
				Tile* _tmp9_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = puzzle_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->board;
				_tmp5__length1 = self->priv->board_length1;
				_tmp5__length2 = self->priv->board_length2;
				_tmp6_ = puzzle_get_size (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = y;
				_tmp9_ = _tmp5_[((_tmp7_ - 1) * _tmp5__length2) + _tmp8_];
				if (_tmp9_ != NULL) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void puzzle_class_init (PuzzleClass * klass) {
	puzzle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzlePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_SIZE, g_param_spec_uint ("size", "size", "size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_ELAPSED, g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_IS_SOLVED, g_param_spec_boolean ("is-solved", "is-solved", "is-solved", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_CAN_MOVE_UP, g_param_spec_boolean ("can-move-up", "can-move-up", "can-move-up", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_CAN_MOVE_DOWN, g_param_spec_boolean ("can-move-down", "can-move-down", "can-move-down", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_CAN_MOVE_LEFT, g_param_spec_boolean ("can-move-left", "can-move-left", "can-move-left", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_CAN_MOVE_RIGHT, g_param_spec_boolean ("can-move-right", "can-move-right", "can-move-right", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("tile_moved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT_UINT, G_TYPE_NONE, 3, TYPE_TILE, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("solved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("paused_changed", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("tick", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void puzzle_instance_init (Puzzle * self) {
	self->priv = PUZZLE_GET_PRIVATE (self);
	self->priv->_paused = FALSE;
}


static void puzzle_finalize (GObject* obj) {
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
	self->priv->board = (_vala_array_free (self->priv->board, self->priv->board_length1 * self->priv->board_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_timer_destroy0 (self->priv->clock);
	G_OBJECT_CLASS (puzzle_parent_class)->finalize (obj);
}


GType puzzle_get_type (void) {
	static volatile gsize puzzle_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Puzzle), 0, (GInstanceInitFunc) puzzle_instance_init, NULL };
		GType puzzle_type_id;
		puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "Puzzle", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_type_id__volatile, puzzle_type_id);
	}
	return puzzle_type_id__volatile;
}


static void _vala_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE, Puzzle);
	switch (property_id) {
		case PUZZLE_SIZE:
		g_value_set_uint (value, puzzle_get_size (self));
		break;
		case PUZZLE_ELAPSED:
		g_value_set_double (value, puzzle_get_elapsed (self));
		break;
		case PUZZLE_PAUSED:
		g_value_set_boolean (value, puzzle_get_paused (self));
		break;
		case PUZZLE_IS_SOLVED:
		g_value_set_boolean (value, puzzle_get_is_solved (self));
		break;
		case PUZZLE_CAN_MOVE_UP:
		g_value_set_boolean (value, puzzle_get_can_move_up (self));
		break;
		case PUZZLE_CAN_MOVE_DOWN:
		g_value_set_boolean (value, puzzle_get_can_move_down (self));
		break;
		case PUZZLE_CAN_MOVE_LEFT:
		g_value_set_boolean (value, puzzle_get_can_move_left (self));
		break;
		case PUZZLE_CAN_MOVE_RIGHT:
		g_value_set_boolean (value, puzzle_get_can_move_right (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE, Puzzle);
	switch (property_id) {
		case PUZZLE_PAUSED:
		puzzle_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



