/* puzzle-view.c generated by valac 0.24.0, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TILE_IMAGE (tile_image_get_type ())
#define TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_IMAGE, TileImage))
#define TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_IMAGE, TileImageClass))
#define IS_TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_IMAGE))
#define IS_TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_IMAGE))
#define TILE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_IMAGE, TileImageClass))

typedef struct _TileImage TileImage;
typedef struct _TileImageClass TileImageClass;
typedef struct _TileImagePrivate TileImagePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
typedef struct _ParamSpecTileImage ParamSpecTileImage;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _theme_unref0(var) ((var == NULL) ? NULL : (var = (theme_unref (var), NULL)))
#define _tile_image_unref0(var) ((var == NULL) ? NULL : (var = (tile_image_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TileImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TileImagePrivate * priv;
	Tile* tile;
	gdouble x;
	gdouble y;
	gdouble source_x;
	gdouble source_y;
	gdouble source_time;
	gdouble target_x;
	gdouble target_y;
	gdouble duration;
};

struct _TileImageClass {
	GTypeClass parent_class;
	void (*finalize) (TileImage *self);
};

struct _ParamSpecTileImage {
	GParamSpec parent_instance;
};

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	Puzzle* _puzzle;
	Theme* theme;
	TileImage* selected_tile;
	guint selection_timeout;
	gdouble selected_x_offset;
	gdouble selected_y_offset;
	GHashTable* tiles;
	GTimer* animation_timer;
	guint animation_timeout;
};


static gpointer tile_image_parent_class = NULL;
static gpointer puzzle_view_parent_class = NULL;

gpointer tile_image_ref (gpointer instance);
void tile_image_unref (gpointer instance);
GParamSpec* param_spec_tile_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile_image (GValue* value, gpointer v_object);
void value_take_tile_image (GValue* value, gpointer v_object);
gpointer value_get_tile_image (const GValue* value);
GType tile_image_get_type (void) G_GNUC_CONST;
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
enum  {
	TILE_IMAGE_DUMMY_PROPERTY
};
TileImage* tile_image_new (Tile* tile);
TileImage* tile_image_construct (GType object_type, Tile* tile);
static void tile_image_finalize (TileImage* obj);
GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer theme_ref (gpointer instance);
void theme_unref (gpointer instance);
GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_theme (GValue* value, gpointer v_object);
void value_take_theme (GValue* value, gpointer v_object);
gpointer value_get_theme (const GValue* value);
GType theme_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_minimum_size 40
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void _tile_unref0_ (gpointer var);
static void _tile_image_unref0_ (gpointer var);
Theme* theme_new (void);
Theme* theme_construct (GType object_type);
static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image);
static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap);
static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
guint puzzle_get_size (Puzzle* self);
static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration);
static gboolean puzzle_view_animate_cb (PuzzleView* self);
static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self);
static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y);
static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
void puzzle_get_tile_location (Puzzle* self, Tile* tile, guint* x, guint* y);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context);
void theme_draw_arrow (Theme* self, cairo_t* context, guint size, guint gap);
void theme_draw_socket (Theme* self, cairo_t* context, guint size);
gboolean puzzle_get_paused (Puzzle* self);
void theme_draw_paused_tile (Theme* self, cairo_t* context, guint size);
void theme_draw_tile (Theme* self, cairo_t* context, guint size, Tile* tile);
static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_get_is_solved (Puzzle* self);
static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self);
static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self);
static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y);
gboolean puzzle_can_switch (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
void puzzle_switch_tiles (Puzzle* self, guint x0, guint y0, guint x1, guint y1);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
Tile* puzzle_get_tile (Puzzle* self, guint x, guint y);
static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self);
static void _puzzle_view_puzzle___lambda3_ (PuzzleView* self);
static void __puzzle_view_puzzle___lambda3__puzzle_paused_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


TileImage* tile_image_construct (GType object_type, Tile* tile) {
	TileImage* self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	g_return_val_if_fail (tile != NULL, NULL);
	self = (TileImage*) g_type_create_instance (object_type);
	_tmp0_ = tile;
	_tmp1_ = _tile_ref0 (_tmp0_);
	_tile_unref0 (self->tile);
	self->tile = _tmp1_;
	return self;
}


TileImage* tile_image_new (Tile* tile) {
	return tile_image_construct (TYPE_TILE_IMAGE, tile);
}


static void value_tile_image_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tile_image_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tile_image_unref (value->data[0].v_pointer);
	}
}


static void value_tile_image_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tile_image_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tile_image_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tile_image_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TileImage* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tile_image_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tile_image_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TileImage** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tile_image_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tile_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTileImage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TILE_IMAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tile_image (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE), NULL);
	return value->data[0].v_pointer;
}


void value_set_tile_image (GValue* value, gpointer v_object) {
	TileImage* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tile_image_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_image_unref (old);
	}
}


void value_take_tile_image (GValue* value, gpointer v_object) {
	TileImage* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TILE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TILE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tile_image_unref (old);
	}
}


static void tile_image_class_init (TileImageClass * klass) {
	tile_image_parent_class = g_type_class_peek_parent (klass);
	TILE_IMAGE_CLASS (klass)->finalize = tile_image_finalize;
}


static void tile_image_instance_init (TileImage * self) {
	self->ref_count = 1;
}


static void tile_image_finalize (TileImage* obj) {
	TileImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_IMAGE, TileImage);
	_tile_unref0 (self->tile);
}


GType tile_image_get_type (void) {
	static volatile gsize tile_image_type_id__volatile = 0;
	if (g_once_init_enter (&tile_image_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tile_image_init, value_tile_image_free_value, value_tile_image_copy_value, value_tile_image_peek_pointer, "p", value_tile_image_collect_value, "p", value_tile_image_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TileImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileImage), 0, (GInstanceInitFunc) tile_image_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tile_image_type_id;
		tile_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TileImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tile_image_type_id__volatile, tile_image_type_id);
	}
	return tile_image_type_id__volatile;
}


gpointer tile_image_ref (gpointer instance) {
	TileImage* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tile_image_unref (gpointer instance) {
	TileImage* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TILE_IMAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _tile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_unref (var), NULL));
}


static void _tile_image_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_image_unref (var), NULL));
}


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Theme* _tmp3_ = NULL;
	GTimer* _tmp4_ = NULL;
	GTimer* _tmp5_ = NULL;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _tile_unref0_, _tile_image_unref0_);
	_g_hash_table_unref0 (self->priv->tiles);
	self->priv->tiles = _tmp2_;
	_tmp3_ = theme_new ();
	_theme_unref0 (self->priv->theme);
	self->priv->theme = _tmp3_;
	_tmp4_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->animation_timer = _tmp4_;
	_tmp5_ = self->priv->animation_timer;
	g_timer_start (_tmp5_);
	return self;
}


PuzzleView* puzzle_view_new (void) {
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}


static void puzzle_view_redraw_tile (PuzzleView* self, TileImage* image) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	TileImage* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	TileImage* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	size = _tmp2_;
	gap = _tmp3_;
	_tmp4_ = image;
	_tmp5_ = _tmp4_->x;
	_tmp6_ = image;
	_tmp7_ = _tmp6_->y;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp5_ + 0.5), (gint) (_tmp7_ + 0.5), (gint) size, (gint) size);
}


static void puzzle_view_move_tile_to_location (PuzzleView* self, TileImage* image, guint x, guint y, gdouble duration) {
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint target_x = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Puzzle* _tmp8_ = NULL;
	Puzzle* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint target_y = 0U;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	TileImage* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	gdouble _tmp19_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	puzzle_view_get_dimensions (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	size = _tmp2_;
	gap = _tmp3_;
	_tmp4_ = x_offset;
	_tmp5_ = x;
	_tmp6_ = size;
	target_x = _tmp4_ + (_tmp5_ * _tmp6_);
	_tmp7_ = x;
	_tmp8_ = puzzle_view_get_puzzle (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = puzzle_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp7_ >= _tmp11_) {
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		_tmp12_ = target_x;
		_tmp13_ = gap;
		target_x = _tmp12_ + _tmp13_;
	}
	_tmp14_ = y_offset;
	_tmp15_ = y;
	_tmp16_ = size;
	target_y = _tmp14_ + (_tmp15_ * _tmp16_);
	_tmp17_ = image;
	_tmp18_ = target_x;
	_tmp19_ = duration;
	puzzle_view_move_tile (self, _tmp17_, (gdouble) _tmp18_, (gdouble) target_y, _tmp19_);
}


static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_animate_cb ((PuzzleView*) self);
	return result;
}


static void puzzle_view_move_tile (PuzzleView* self, TileImage* image, gdouble x, gdouble y, gdouble duration) {
	gboolean _tmp0_ = FALSE;
	TileImage* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	TileImage* _tmp7_ = NULL;
	TileImage* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	TileImage* _tmp10_ = NULL;
	TileImage* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	TileImage* _tmp13_ = NULL;
	GTimer* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	TileImage* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	TileImage* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	TileImage* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	guint _tmp31_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	_tmp1_ = image;
	_tmp2_ = _tmp1_->x;
	_tmp3_ = x;
	if (_tmp2_ == _tmp3_) {
		TileImage* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp4_ = image;
		_tmp5_ = _tmp4_->y;
		_tmp6_ = y;
		_tmp0_ = _tmp5_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = image;
	_tmp8_ = image;
	_tmp9_ = _tmp8_->x;
	_tmp7_->source_x = _tmp9_;
	_tmp10_ = image;
	_tmp11_ = image;
	_tmp12_ = _tmp11_->y;
	_tmp10_->source_y = _tmp12_;
	_tmp13_ = image;
	_tmp14_ = self->priv->animation_timer;
	_tmp15_ = g_timer_elapsed (_tmp14_, NULL);
	_tmp13_->source_time = _tmp15_;
	_tmp16_ = image;
	_tmp17_ = x;
	_tmp16_->target_x = _tmp17_;
	_tmp18_ = image;
	_tmp19_ = y;
	_tmp18_->target_y = _tmp19_;
	_tmp20_ = image;
	_tmp21_ = duration;
	_tmp20_->duration = _tmp21_;
	_tmp22_ = duration;
	if (_tmp22_ == ((gdouble) 0)) {
		TileImage* _tmp23_ = NULL;
		TileImage* _tmp24_ = NULL;
		TileImage* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		TileImage* _tmp27_ = NULL;
		TileImage* _tmp28_ = NULL;
		gdouble _tmp29_ = 0.0;
		TileImage* _tmp30_ = NULL;
		_tmp23_ = image;
		puzzle_view_redraw_tile (self, _tmp23_);
		_tmp24_ = image;
		_tmp25_ = image;
		_tmp26_ = _tmp25_->target_x;
		_tmp24_->x = _tmp26_;
		_tmp27_ = image;
		_tmp28_ = image;
		_tmp29_ = _tmp28_->target_y;
		_tmp27_->y = _tmp29_;
		_tmp30_ = image;
		puzzle_view_redraw_tile (self, _tmp30_);
		return;
	}
	_tmp31_ = self->priv->animation_timeout;
	if (_tmp31_ == ((guint) 0)) {
		guint _tmp32_ = 0U;
		_tmp32_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _puzzle_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->animation_timeout = _tmp32_;
	}
}


static gpointer _tile_image_ref0 (gpointer self) {
	return self ? tile_image_ref (self) : NULL;
}


static gboolean puzzle_view_animate_cb (PuzzleView* self) {
	gboolean result = FALSE;
	gdouble t = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gboolean animating = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp6_ = NULL;
	gboolean _tmp55_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animation_timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	t = _tmp1_;
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x_offset = _tmp2_;
	y_offset = _tmp3_;
	size = _tmp4_;
	gap = _tmp5_;
	animating = FALSE;
	_tmp6_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp6_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		Tile* _tmp10_ = NULL;
		TileImage* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		TileImage* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		TileImage* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		TileImage* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		TileImage* _tmp23_ = NULL;
		gdouble _tmp24_ = 0.0;
		TileImage* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		TileImage* _tmp54_ = NULL;
		_tmp9_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
		_tile_unref0 (tile);
		_tmp10_ = _tile_ref0 (_tmp7_);
		tile = _tmp10_;
		_tile_image_unref0 (image);
		_tmp11_ = _tile_image_ref0 (_tmp8_);
		image = _tmp11_;
		if (!_tmp9_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp13_ = image;
		_tmp14_ = _tmp13_->x;
		_tmp15_ = image;
		_tmp16_ = _tmp15_->target_x;
		if (_tmp14_ == _tmp16_) {
			TileImage* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			TileImage* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
			_tmp17_ = image;
			_tmp18_ = _tmp17_->y;
			_tmp19_ = image;
			_tmp20_ = _tmp19_->target_y;
			_tmp12_ = _tmp18_ == _tmp20_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp21_ = image;
		puzzle_view_redraw_tile (self, _tmp21_);
		_tmp22_ = t;
		_tmp23_ = image;
		_tmp24_ = _tmp23_->source_time;
		_tmp25_ = image;
		_tmp26_ = _tmp25_->duration;
		if (_tmp22_ >= (_tmp24_ + _tmp26_)) {
			TileImage* _tmp27_ = NULL;
			TileImage* _tmp28_ = NULL;
			gdouble _tmp29_ = 0.0;
			TileImage* _tmp30_ = NULL;
			TileImage* _tmp31_ = NULL;
			gdouble _tmp32_ = 0.0;
			_tmp27_ = image;
			_tmp28_ = image;
			_tmp29_ = _tmp28_->target_x;
			_tmp27_->x = _tmp29_;
			_tmp30_ = image;
			_tmp31_ = image;
			_tmp32_ = _tmp31_->target_y;
			_tmp30_->y = _tmp32_;
		} else {
			gdouble d = 0.0;
			gdouble _tmp33_ = 0.0;
			TileImage* _tmp34_ = NULL;
			gdouble _tmp35_ = 0.0;
			TileImage* _tmp36_ = NULL;
			gdouble _tmp37_ = 0.0;
			TileImage* _tmp38_ = NULL;
			TileImage* _tmp39_ = NULL;
			gdouble _tmp40_ = 0.0;
			TileImage* _tmp41_ = NULL;
			gdouble _tmp42_ = 0.0;
			TileImage* _tmp43_ = NULL;
			gdouble _tmp44_ = 0.0;
			gdouble _tmp45_ = 0.0;
			TileImage* _tmp46_ = NULL;
			TileImage* _tmp47_ = NULL;
			gdouble _tmp48_ = 0.0;
			TileImage* _tmp49_ = NULL;
			gdouble _tmp50_ = 0.0;
			TileImage* _tmp51_ = NULL;
			gdouble _tmp52_ = 0.0;
			gdouble _tmp53_ = 0.0;
			_tmp33_ = t;
			_tmp34_ = image;
			_tmp35_ = _tmp34_->source_time;
			_tmp36_ = image;
			_tmp37_ = _tmp36_->duration;
			d = (_tmp33_ - _tmp35_) / _tmp37_;
			_tmp38_ = image;
			_tmp39_ = image;
			_tmp40_ = _tmp39_->source_x;
			_tmp41_ = image;
			_tmp42_ = _tmp41_->target_x;
			_tmp43_ = image;
			_tmp44_ = _tmp43_->source_x;
			_tmp45_ = d;
			_tmp38_->x = _tmp40_ + ((_tmp42_ - _tmp44_) * _tmp45_);
			_tmp46_ = image;
			_tmp47_ = image;
			_tmp48_ = _tmp47_->source_y;
			_tmp49_ = image;
			_tmp50_ = _tmp49_->target_y;
			_tmp51_ = image;
			_tmp52_ = _tmp51_->source_y;
			_tmp53_ = d;
			_tmp46_->y = _tmp48_ + ((_tmp50_ - _tmp52_) * _tmp53_);
			animating = TRUE;
		}
		_tmp54_ = image;
		puzzle_view_redraw_tile (self, _tmp54_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp55_ = animating;
	if (_tmp55_) {
		result = TRUE;
		return result;
	}
	self->priv->animation_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void puzzle_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	self = (PuzzleView*) base;
	size = 0;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		size = (gint) (((_tmp5_ * 2) + 1.5) * PUZZLE_VIEW_minimum_size);
	}
	_tmp6_ = size;
	_tmp7_ = MAX (_tmp6_, 500);
	_vala_natural = _tmp7_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void puzzle_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	self = (PuzzleView*) base;
	size = 0;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		size = (gint) ((_tmp5_ + 1) * PUZZLE_VIEW_minimum_size);
	}
	_tmp6_ = size;
	_tmp7_ = MAX (_tmp6_, 300);
	_vala_natural = _tmp7_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void puzzle_view_get_dimensions (PuzzleView* self, guint* x, guint* y, guint* size, guint* gap) {
	guint _vala_x = 0U;
	guint _vala_y = 0U;
	guint _vala_size = 0U;
	guint _vala_gap = 0U;
	guint width = 0U;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint height = 0U;
	gint _tmp5_ = 0;
	Puzzle* _tmp6_ = NULL;
	Puzzle* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	gint _tmp11_ = 0;
	Puzzle* _tmp12_ = NULL;
	Puzzle* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gint _tmp16_ = 0;
	Puzzle* _tmp17_ = NULL;
	Puzzle* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	width = (guint) (_tmp0_ / ((2 * _tmp4_) + 1.5));
	_tmp5_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp6_ = puzzle_view_get_puzzle (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = puzzle_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	height = (guint) (_tmp5_ / (_tmp9_ + 1));
	_tmp10_ = MIN (width, height);
	_vala_size = _tmp10_;
	_vala_gap = _vala_size / 2;
	_tmp11_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp12_ = puzzle_view_get_puzzle (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = puzzle_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_x = ((_tmp11_ - ((2 * _tmp15_) * _vala_size)) - _vala_gap) / 2;
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp17_ = puzzle_view_get_puzzle (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = puzzle_get_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_y = (_tmp16_ - (_tmp20_ * _vala_size)) / 2;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (size) {
		*size = _vala_size;
	}
	if (gap) {
		*gap = _vala_gap;
	}
}


static void puzzle_view_tile_moved_cb (PuzzleView* self, Puzzle* puzzle, Tile* tile, guint x, guint y) {
	GHashTable* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp1_ = tile;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = x;
	_tmp4_ = y;
	puzzle_view_move_tile_to_location (self, (TileImage*) _tmp2_, _tmp3_, _tmp4_, 0.2);
	g_signal_emit_by_name (self, "tile-moved");
}


static gboolean puzzle_view_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		Tile* _tmp4_ = NULL;
		TileImage* _tmp5_ = NULL;
		guint x = 0U;
		guint y = 0U;
		Puzzle* _tmp6_ = NULL;
		Puzzle* _tmp7_ = NULL;
		Tile* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		TileImage* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		_tile_unref0 (tile);
		_tmp4_ = _tile_ref0 (_tmp1_);
		tile = _tmp4_;
		_tile_image_unref0 (image);
		_tmp5_ = _tile_image_ref0 (_tmp2_);
		image = _tmp5_;
		if (!_tmp3_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp6_ = puzzle_view_get_puzzle (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = tile;
		puzzle_get_tile_location (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
		x = _tmp9_;
		y = _tmp10_;
		_tmp11_ = image;
		_tmp12_ = x;
		_tmp13_ = y;
		puzzle_view_move_tile_to_location (self, _tmp11_, _tmp12_, _tmp13_, (gdouble) 0);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tile_image_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* context) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	cairo_t* _tmp6_ = NULL;
	gdouble w = 0.0;
	guint _tmp7_ = 0U;
	gdouble ax = 0.0;
	guint _tmp8_ = 0U;
	Puzzle* _tmp9_ = NULL;
	Puzzle* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	gdouble _tmp15_ = 0.0;
	gdouble ay = 0.0;
	guint _tmp16_ = 0U;
	Puzzle* _tmp17_ = NULL;
	Puzzle* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	cairo_t* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	Theme* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	cairo_t* _tmp29_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp69_ = NULL;
	GHashTable* _tmp105_ = NULL;
	Puzzle* _tmp141_ = NULL;
	Puzzle* _tmp142_ = NULL;
	gboolean _tmp143_ = FALSE;
	gboolean _tmp144_ = FALSE;
	self = (PuzzleView*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	puzzle_view_get_dimensions (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x_offset = _tmp2_;
	y_offset = _tmp3_;
	size = _tmp4_;
	gap = _tmp5_;
	_tmp6_ = context;
	cairo_save (_tmp6_);
	_tmp7_ = gap;
	w = _tmp7_ * 0.5;
	_tmp8_ = x_offset;
	_tmp9_ = puzzle_view_get_puzzle (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = puzzle_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = size;
	_tmp14_ = gap;
	_tmp15_ = w;
	ax = (_tmp8_ + (_tmp12_ * _tmp13_)) + ((_tmp14_ - _tmp15_) * 0.5);
	_tmp16_ = y_offset;
	_tmp17_ = puzzle_view_get_puzzle (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = puzzle_get_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = size;
	ay = _tmp16_ + ((_tmp20_ * _tmp21_) * 0.5);
	_tmp22_ = context;
	_tmp23_ = ax;
	_tmp24_ = ay;
	cairo_translate (_tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->theme;
	_tmp26_ = context;
	_tmp27_ = size;
	_tmp28_ = gap;
	theme_draw_arrow (_tmp25_, _tmp26_, _tmp27_, _tmp28_);
	_tmp29_ = context;
	cairo_restore (_tmp29_);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_ = 0;
				Puzzle* _tmp33_ = NULL;
				Puzzle* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				guint _tmp36_ = 0U;
				if (!_tmp30_) {
					gint _tmp31_ = 0;
					_tmp31_ = y;
					y = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = y;
				_tmp33_ = puzzle_view_get_puzzle (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = puzzle_get_size (_tmp34_);
				_tmp36_ = _tmp35_;
				if (!(((guint) _tmp32_) < _tmp36_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp37_ = FALSE;
						_tmp37_ = TRUE;
						while (TRUE) {
							gint _tmp39_ = 0;
							Puzzle* _tmp40_ = NULL;
							Puzzle* _tmp41_ = NULL;
							guint _tmp42_ = 0U;
							guint _tmp43_ = 0U;
							cairo_t* _tmp44_ = NULL;
							gint _tmp45_ = 0;
							Puzzle* _tmp46_ = NULL;
							Puzzle* _tmp47_ = NULL;
							guint _tmp48_ = 0U;
							guint _tmp49_ = 0U;
							Theme* _tmp65_ = NULL;
							cairo_t* _tmp66_ = NULL;
							guint _tmp67_ = 0U;
							cairo_t* _tmp68_ = NULL;
							if (!_tmp37_) {
								gint _tmp38_ = 0;
								_tmp38_ = x;
								x = _tmp38_ + 1;
							}
							_tmp37_ = FALSE;
							_tmp39_ = x;
							_tmp40_ = puzzle_view_get_puzzle (self);
							_tmp41_ = _tmp40_;
							_tmp42_ = puzzle_get_size (_tmp41_);
							_tmp43_ = _tmp42_;
							if (!(((guint) _tmp39_) < (_tmp43_ * 2))) {
								break;
							}
							_tmp44_ = context;
							cairo_save (_tmp44_);
							_tmp45_ = x;
							_tmp46_ = puzzle_view_get_puzzle (self);
							_tmp47_ = _tmp46_;
							_tmp48_ = puzzle_get_size (_tmp47_);
							_tmp49_ = _tmp48_;
							if (((guint) _tmp45_) >= _tmp49_) {
								cairo_t* _tmp50_ = NULL;
								guint _tmp51_ = 0U;
								guint _tmp52_ = 0U;
								gint _tmp53_ = 0;
								guint _tmp54_ = 0U;
								guint _tmp55_ = 0U;
								gint _tmp56_ = 0;
								guint _tmp57_ = 0U;
								_tmp50_ = context;
								_tmp51_ = x_offset;
								_tmp52_ = gap;
								_tmp53_ = x;
								_tmp54_ = size;
								_tmp55_ = y_offset;
								_tmp56_ = y;
								_tmp57_ = size;
								cairo_translate (_tmp50_, (gdouble) ((_tmp51_ + _tmp52_) + (_tmp53_ * _tmp54_)), (gdouble) (_tmp55_ + (_tmp56_ * _tmp57_)));
							} else {
								cairo_t* _tmp58_ = NULL;
								guint _tmp59_ = 0U;
								gint _tmp60_ = 0;
								guint _tmp61_ = 0U;
								guint _tmp62_ = 0U;
								gint _tmp63_ = 0;
								guint _tmp64_ = 0U;
								_tmp58_ = context;
								_tmp59_ = x_offset;
								_tmp60_ = x;
								_tmp61_ = size;
								_tmp62_ = y_offset;
								_tmp63_ = y;
								_tmp64_ = size;
								cairo_translate (_tmp58_, (gdouble) (_tmp59_ + (_tmp60_ * _tmp61_)), (gdouble) (_tmp62_ + (_tmp63_ * _tmp64_)));
							}
							_tmp65_ = self->priv->theme;
							_tmp66_ = context;
							_tmp67_ = size;
							theme_draw_socket (_tmp65_, _tmp66_, _tmp67_);
							_tmp68_ = context;
							cairo_restore (_tmp68_);
						}
					}
				}
			}
		}
	}
	_tmp69_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp69_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp70_ = NULL;
		gconstpointer _tmp71_ = NULL;
		gboolean _tmp72_ = FALSE;
		Tile* _tmp73_ = NULL;
		TileImage* _tmp74_ = NULL;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_ = FALSE;
		TileImage* _tmp77_ = NULL;
		TileImage* _tmp78_ = NULL;
		cairo_t* _tmp87_ = NULL;
		cairo_t* _tmp88_ = NULL;
		TileImage* _tmp89_ = NULL;
		gdouble _tmp90_ = 0.0;
		TileImage* _tmp91_ = NULL;
		gdouble _tmp92_ = 0.0;
		Puzzle* _tmp93_ = NULL;
		Puzzle* _tmp94_ = NULL;
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		cairo_t* _tmp104_ = NULL;
		_tmp72_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp70_), (gpointer*) (&_tmp71_));
		_tile_unref0 (tile);
		_tmp73_ = _tile_ref0 (_tmp70_);
		tile = _tmp73_;
		_tile_image_unref0 (image);
		_tmp74_ = _tile_image_ref0 (_tmp71_);
		image = _tmp74_;
		if (!_tmp72_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp77_ = image;
		_tmp78_ = self->priv->selected_tile;
		if (_tmp77_ == _tmp78_) {
			_tmp76_ = TRUE;
		} else {
			TileImage* _tmp79_ = NULL;
			gdouble _tmp80_ = 0.0;
			TileImage* _tmp81_ = NULL;
			gdouble _tmp82_ = 0.0;
			_tmp79_ = image;
			_tmp80_ = _tmp79_->x;
			_tmp81_ = image;
			_tmp82_ = _tmp81_->target_x;
			_tmp76_ = _tmp80_ != _tmp82_;
		}
		if (_tmp76_) {
			_tmp75_ = TRUE;
		} else {
			TileImage* _tmp83_ = NULL;
			gdouble _tmp84_ = 0.0;
			TileImage* _tmp85_ = NULL;
			gdouble _tmp86_ = 0.0;
			_tmp83_ = image;
			_tmp84_ = _tmp83_->y;
			_tmp85_ = image;
			_tmp86_ = _tmp85_->target_y;
			_tmp75_ = _tmp84_ != _tmp86_;
		}
		if (_tmp75_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp87_ = context;
		cairo_save (_tmp87_);
		_tmp88_ = context;
		_tmp89_ = image;
		_tmp90_ = _tmp89_->x;
		_tmp91_ = image;
		_tmp92_ = _tmp91_->y;
		cairo_translate (_tmp88_, (gdouble) ((gint) (_tmp90_ + 0.5)), (gdouble) ((gint) (_tmp92_ + 0.5)));
		_tmp93_ = puzzle_view_get_puzzle (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = puzzle_get_paused (_tmp94_);
		_tmp96_ = _tmp95_;
		if (_tmp96_) {
			Theme* _tmp97_ = NULL;
			cairo_t* _tmp98_ = NULL;
			guint _tmp99_ = 0U;
			_tmp97_ = self->priv->theme;
			_tmp98_ = context;
			_tmp99_ = size;
			theme_draw_paused_tile (_tmp97_, _tmp98_, _tmp99_);
		} else {
			Theme* _tmp100_ = NULL;
			cairo_t* _tmp101_ = NULL;
			guint _tmp102_ = 0U;
			Tile* _tmp103_ = NULL;
			_tmp100_ = self->priv->theme;
			_tmp101_ = context;
			_tmp102_ = size;
			_tmp103_ = tile;
			theme_draw_tile (_tmp100_, _tmp101_, _tmp102_, _tmp103_);
		}
		_tmp104_ = context;
		cairo_restore (_tmp104_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp105_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp105_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp106_ = NULL;
		gconstpointer _tmp107_ = NULL;
		gboolean _tmp108_ = FALSE;
		Tile* _tmp109_ = NULL;
		TileImage* _tmp110_ = NULL;
		gboolean _tmp111_ = FALSE;
		gboolean _tmp112_ = FALSE;
		TileImage* _tmp113_ = NULL;
		TileImage* _tmp114_ = NULL;
		cairo_t* _tmp123_ = NULL;
		cairo_t* _tmp124_ = NULL;
		TileImage* _tmp125_ = NULL;
		gdouble _tmp126_ = 0.0;
		TileImage* _tmp127_ = NULL;
		gdouble _tmp128_ = 0.0;
		Puzzle* _tmp129_ = NULL;
		Puzzle* _tmp130_ = NULL;
		gboolean _tmp131_ = FALSE;
		gboolean _tmp132_ = FALSE;
		cairo_t* _tmp140_ = NULL;
		_tmp108_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp106_), (gpointer*) (&_tmp107_));
		_tile_unref0 (tile);
		_tmp109_ = _tile_ref0 (_tmp106_);
		tile = _tmp109_;
		_tile_image_unref0 (image);
		_tmp110_ = _tile_image_ref0 (_tmp107_);
		image = _tmp110_;
		if (!_tmp108_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp113_ = image;
		_tmp114_ = self->priv->selected_tile;
		if (_tmp113_ != _tmp114_) {
			TileImage* _tmp115_ = NULL;
			gdouble _tmp116_ = 0.0;
			TileImage* _tmp117_ = NULL;
			gdouble _tmp118_ = 0.0;
			_tmp115_ = image;
			_tmp116_ = _tmp115_->x;
			_tmp117_ = image;
			_tmp118_ = _tmp117_->target_x;
			_tmp112_ = _tmp116_ == _tmp118_;
		} else {
			_tmp112_ = FALSE;
		}
		if (_tmp112_) {
			TileImage* _tmp119_ = NULL;
			gdouble _tmp120_ = 0.0;
			TileImage* _tmp121_ = NULL;
			gdouble _tmp122_ = 0.0;
			_tmp119_ = image;
			_tmp120_ = _tmp119_->y;
			_tmp121_ = image;
			_tmp122_ = _tmp121_->target_y;
			_tmp111_ = _tmp120_ == _tmp122_;
		} else {
			_tmp111_ = FALSE;
		}
		if (_tmp111_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			continue;
		}
		_tmp123_ = context;
		cairo_save (_tmp123_);
		_tmp124_ = context;
		_tmp125_ = image;
		_tmp126_ = _tmp125_->x;
		_tmp127_ = image;
		_tmp128_ = _tmp127_->y;
		cairo_translate (_tmp124_, (gdouble) ((gint) (_tmp126_ + 0.5)), (gdouble) ((gint) (_tmp128_ + 0.5)));
		_tmp129_ = puzzle_view_get_puzzle (self);
		_tmp130_ = _tmp129_;
		_tmp131_ = puzzle_get_paused (_tmp130_);
		_tmp132_ = _tmp131_;
		if (_tmp132_) {
			Theme* _tmp133_ = NULL;
			cairo_t* _tmp134_ = NULL;
			guint _tmp135_ = 0U;
			_tmp133_ = self->priv->theme;
			_tmp134_ = context;
			_tmp135_ = size;
			theme_draw_paused_tile (_tmp133_, _tmp134_, _tmp135_);
		} else {
			Theme* _tmp136_ = NULL;
			cairo_t* _tmp137_ = NULL;
			guint _tmp138_ = 0U;
			Tile* _tmp139_ = NULL;
			_tmp136_ = self->priv->theme;
			_tmp137_ = context;
			_tmp138_ = size;
			_tmp139_ = tile;
			theme_draw_tile (_tmp136_, _tmp137_, _tmp138_, _tmp139_);
		}
		_tmp140_ = context;
		cairo_restore (_tmp140_);
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
	_tmp141_ = puzzle_view_get_puzzle (self);
	_tmp142_ = _tmp141_;
	_tmp143_ = puzzle_get_paused (_tmp142_);
	_tmp144_ = _tmp143_;
	if (_tmp144_) {
		cairo_t* _tmp145_ = NULL;
		cairo_t* _tmp146_ = NULL;
		cairo_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		gint _tmp149_ = 0;
		gchar* text = NULL;
		const gchar* _tmp150_ = NULL;
		gchar* _tmp151_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp152_ = NULL;
		const gchar* _tmp153_ = NULL;
		cairo_text_extents_t _tmp154_ = {0};
		cairo_t* _tmp155_ = NULL;
		gint _tmp156_ = 0;
		cairo_text_extents_t _tmp157_ = {0};
		gdouble _tmp158_ = 0.0;
		gint _tmp159_ = 0;
		cairo_text_extents_t _tmp160_ = {0};
		gdouble _tmp161_ = 0.0;
		cairo_t* _tmp162_ = NULL;
		cairo_t* _tmp163_ = NULL;
		const gchar* _tmp164_ = NULL;
		_tmp145_ = context;
		cairo_set_source_rgba (_tmp145_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp146_ = context;
		cairo_paint (_tmp146_);
		_tmp147_ = context;
		cairo_select_font_face (_tmp147_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp148_ = context;
		_tmp149_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp148_, _tmp149_ * 0.125);
		_tmp150_ = _ ("Paused");
		_tmp151_ = g_strdup (_tmp150_);
		text = _tmp151_;
		_tmp152_ = context;
		_tmp153_ = text;
		cairo_text_extents (_tmp152_, _tmp153_, &_tmp154_);
		extents = _tmp154_;
		_tmp155_ = context;
		_tmp156_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp157_ = extents;
		_tmp158_ = _tmp157_.width;
		_tmp159_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp160_ = extents;
		_tmp161_ = _tmp160_.height;
		cairo_move_to (_tmp155_, (_tmp156_ - _tmp158_) / 2.0, (_tmp159_ + _tmp161_) / 2.0);
		_tmp162_ = context;
		cairo_set_source_rgb (_tmp162_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp163_ = context;
		_tmp164_ = text;
		cairo_show_text (_tmp163_, _tmp164_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = puzzle_view_selection_timeout_cb ((PuzzleView*) self);
	return result;
}


static void puzzle_view_pick_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GHashTableIter iter = {0};
	GHashTable* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_is_solved (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	puzzle_view_get_dimensions (self, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	x_offset = _tmp5_;
	y_offset = _tmp6_;
	size = _tmp7_;
	gap = _tmp8_;
	_tmp9_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp9_);
	while (TRUE) {
		Tile* tile = NULL;
		TileImage* image = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Tile* _tmp13_ = NULL;
		TileImage* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_ = 0.0;
		TileImage* _tmp19_ = NULL;
		gdouble _tmp20_ = 0.0;
		_tmp12_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp10_), (gpointer*) (&_tmp11_));
		_tile_unref0 (tile);
		_tmp13_ = _tile_ref0 (_tmp10_);
		tile = _tmp13_;
		_tile_image_unref0 (image);
		_tmp14_ = _tile_image_ref0 (_tmp11_);
		image = _tmp14_;
		if (!_tmp12_) {
			_tile_image_unref0 (image);
			_tile_unref0 (tile);
			break;
		}
		_tmp18_ = x;
		_tmp19_ = image;
		_tmp20_ = _tmp19_->x;
		if (_tmp18_ >= _tmp20_) {
			gdouble _tmp21_ = 0.0;
			TileImage* _tmp22_ = NULL;
			gdouble _tmp23_ = 0.0;
			guint _tmp24_ = 0U;
			_tmp21_ = x;
			_tmp22_ = image;
			_tmp23_ = _tmp22_->x;
			_tmp24_ = size;
			_tmp17_ = _tmp21_ <= (_tmp23_ + _tmp24_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gdouble _tmp25_ = 0.0;
			TileImage* _tmp26_ = NULL;
			gdouble _tmp27_ = 0.0;
			_tmp25_ = y;
			_tmp26_ = image;
			_tmp27_ = _tmp26_->y;
			_tmp16_ = _tmp25_ >= _tmp27_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			gdouble _tmp28_ = 0.0;
			TileImage* _tmp29_ = NULL;
			gdouble _tmp30_ = 0.0;
			guint _tmp31_ = 0U;
			_tmp28_ = y;
			_tmp29_ = image;
			_tmp30_ = _tmp29_->y;
			_tmp31_ = size;
			_tmp15_ = _tmp28_ <= (_tmp30_ + _tmp31_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			TileImage* _tmp32_ = NULL;
			TileImage* _tmp33_ = NULL;
			gdouble _tmp34_ = 0.0;
			TileImage* _tmp35_ = NULL;
			gdouble _tmp36_ = 0.0;
			gdouble _tmp37_ = 0.0;
			TileImage* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			guint _tmp40_ = 0U;
			guint _tmp42_ = 0U;
			_tmp32_ = image;
			_tmp33_ = _tile_image_ref0 (_tmp32_);
			_tile_image_unref0 (self->priv->selected_tile);
			self->priv->selected_tile = _tmp33_;
			_tmp34_ = x;
			_tmp35_ = image;
			_tmp36_ = _tmp35_->x;
			self->priv->selected_x_offset = _tmp34_ - _tmp36_;
			_tmp37_ = y;
			_tmp38_ = image;
			_tmp39_ = _tmp38_->y;
			self->priv->selected_y_offset = _tmp37_ - _tmp39_;
			_tmp40_ = self->priv->selection_timeout;
			if (_tmp40_ != ((guint) 0)) {
				guint _tmp41_ = 0U;
				_tmp41_ = self->priv->selection_timeout;
				g_source_remove (_tmp41_);
			}
			_tmp42_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _puzzle_view_selection_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->selection_timeout = _tmp42_;
		}
		_tile_image_unref0 (image);
		_tile_unref0 (tile);
	}
}


static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->selection_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static void puzzle_view_drop_tile (PuzzleView* self, gdouble x, gdouble y) {
	TileImage* _tmp0_ = NULL;
	guint x_offset = 0U;
	guint y_offset = 0U;
	guint size = 0U;
	guint gap = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gdouble _tmp5_ = 0.0;
	guint _tmp6_ = 0U;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	guint _tmp9_ = 0U;
	gdouble _tmp10_ = 0.0;
	gint tile_y = 0;
	gdouble _tmp11_ = 0.0;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Puzzle* _tmp18_ = NULL;
	Puzzle* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	gint _tmp22_ = 0;
	gint tile_x = 0;
	gdouble _tmp23_ = 0.0;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	Puzzle* _tmp26_ = NULL;
	Puzzle* _tmp27_ = NULL;
	guint _tmp28_ = 0U;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	guint selected_x = 0U;
	guint selected_y = 0U;
	Puzzle* _tmp69_ = NULL;
	Puzzle* _tmp70_ = NULL;
	TileImage* _tmp71_ = NULL;
	Tile* _tmp72_ = NULL;
	guint _tmp73_ = 0U;
	guint _tmp74_ = 0U;
	Puzzle* _tmp75_ = NULL;
	Puzzle* _tmp76_ = NULL;
	guint _tmp77_ = 0U;
	guint _tmp78_ = 0U;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	gboolean _tmp81_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		return;
	}
	puzzle_view_get_dimensions (self, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	x_offset = _tmp1_;
	y_offset = _tmp2_;
	size = _tmp3_;
	gap = _tmp4_;
	_tmp5_ = x;
	_tmp6_ = size;
	_tmp7_ = self->priv->selected_x_offset;
	x = _tmp5_ + ((_tmp6_ * 0.5) - _tmp7_);
	_tmp8_ = y;
	_tmp9_ = size;
	_tmp10_ = self->priv->selected_x_offset;
	y = _tmp8_ + ((_tmp9_ * 0.5) - _tmp10_);
	_tmp11_ = y;
	_tmp12_ = y_offset;
	_tmp13_ = size;
	_tmp14_ = floor ((_tmp11_ - _tmp12_) / _tmp13_);
	tile_y = (gint) _tmp14_;
	_tmp15_ = tile_y;
	_tmp16_ = MAX (_tmp15_, 0);
	tile_y = _tmp16_;
	_tmp17_ = tile_y;
	_tmp18_ = puzzle_view_get_puzzle (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = puzzle_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = MIN (_tmp17_, ((gint) _tmp21_) - 1);
	tile_y = _tmp22_;
	_tmp23_ = x;
	_tmp24_ = x_offset;
	_tmp25_ = size;
	_tmp26_ = puzzle_view_get_puzzle (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = puzzle_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = gap;
	if (_tmp23_ > ((_tmp24_ + (_tmp25_ * _tmp29_)) + (_tmp30_ * 0.5))) {
		Puzzle* _tmp31_ = NULL;
		Puzzle* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		gdouble _tmp35_ = 0.0;
		guint _tmp36_ = 0U;
		Puzzle* _tmp37_ = NULL;
		Puzzle* _tmp38_ = NULL;
		guint _tmp39_ = 0U;
		guint _tmp40_ = 0U;
		guint _tmp41_ = 0U;
		guint _tmp42_ = 0U;
		guint _tmp43_ = 0U;
		gdouble _tmp44_ = 0.0;
		gint _tmp45_ = 0;
		Puzzle* _tmp46_ = NULL;
		Puzzle* _tmp47_ = NULL;
		guint _tmp48_ = 0U;
		guint _tmp49_ = 0U;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		Puzzle* _tmp52_ = NULL;
		Puzzle* _tmp53_ = NULL;
		guint _tmp54_ = 0U;
		guint _tmp55_ = 0U;
		gint _tmp56_ = 0;
		_tmp31_ = puzzle_view_get_puzzle (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = puzzle_get_size (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = x;
		_tmp36_ = x_offset;
		_tmp37_ = puzzle_view_get_puzzle (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = puzzle_get_size (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = size;
		_tmp42_ = gap;
		_tmp43_ = size;
		_tmp44_ = floor ((_tmp35_ - ((_tmp36_ + (_tmp40_ * _tmp41_)) + _tmp42_)) / _tmp43_);
		tile_x = ((gint) _tmp34_) + ((gint) _tmp44_);
		_tmp45_ = tile_x;
		_tmp46_ = puzzle_view_get_puzzle (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = puzzle_get_size (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = MAX (_tmp45_, (gint) _tmp49_);
		tile_x = _tmp50_;
		_tmp51_ = tile_x;
		_tmp52_ = puzzle_view_get_puzzle (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = puzzle_get_size (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = MIN (_tmp51_, (2 * ((gint) _tmp55_)) - 1);
		tile_x = _tmp56_;
	} else {
		gdouble _tmp57_ = 0.0;
		guint _tmp58_ = 0U;
		guint _tmp59_ = 0U;
		gdouble _tmp60_ = 0.0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		Puzzle* _tmp64_ = NULL;
		Puzzle* _tmp65_ = NULL;
		guint _tmp66_ = 0U;
		guint _tmp67_ = 0U;
		gint _tmp68_ = 0;
		_tmp57_ = x;
		_tmp58_ = x_offset;
		_tmp59_ = size;
		_tmp60_ = floor ((_tmp57_ - _tmp58_) / _tmp59_);
		tile_x = (gint) _tmp60_;
		_tmp61_ = tile_x;
		_tmp62_ = MAX (_tmp61_, 0);
		tile_x = _tmp62_;
		_tmp63_ = tile_x;
		_tmp64_ = puzzle_view_get_puzzle (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = puzzle_get_size (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = MIN (_tmp63_, ((gint) _tmp67_) - 1);
		tile_x = _tmp68_;
	}
	_tmp69_ = puzzle_view_get_puzzle (self);
	_tmp70_ = _tmp69_;
	_tmp71_ = self->priv->selected_tile;
	_tmp72_ = _tmp71_->tile;
	puzzle_get_tile_location (_tmp70_, _tmp72_, &_tmp73_, &_tmp74_);
	selected_x = _tmp73_;
	selected_y = _tmp74_;
	_tmp75_ = puzzle_view_get_puzzle (self);
	_tmp76_ = _tmp75_;
	_tmp77_ = selected_x;
	_tmp78_ = selected_y;
	_tmp79_ = tile_x;
	_tmp80_ = tile_y;
	_tmp81_ = puzzle_can_switch (_tmp76_, _tmp77_, _tmp78_, (guint) _tmp79_, (guint) _tmp80_);
	if (_tmp81_) {
		Puzzle* _tmp82_ = NULL;
		Puzzle* _tmp83_ = NULL;
		guint _tmp84_ = 0U;
		guint _tmp85_ = 0U;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		_tmp82_ = puzzle_view_get_puzzle (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = selected_x;
		_tmp85_ = selected_y;
		_tmp86_ = tile_x;
		_tmp87_ = tile_y;
		puzzle_switch_tiles (_tmp83_, _tmp84_, _tmp85_, (guint) _tmp86_, (guint) _tmp87_);
	} else {
		TileImage* _tmp88_ = NULL;
		guint _tmp89_ = 0U;
		guint _tmp90_ = 0U;
		_tmp88_ = self->priv->selected_tile;
		_tmp89_ = selected_x;
		_tmp90_ = selected_y;
		puzzle_view_move_tile_to_location (self, _tmp88_, _tmp89_, _tmp90_, 0.2);
	}
	_tile_image_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp4_ = NULL;
	GdkEventType _tmp5_ = 0;
	GdkEventButton* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->type;
	if (_tmp5_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp6_ = event;
	_tmp7_ = _tmp6_->button;
	if (_tmp7_ == ((guint) 1)) {
		TileImage* _tmp8_ = NULL;
		_tmp8_ = self->priv->selected_tile;
		if (_tmp8_ == NULL) {
			GdkEventButton* _tmp9_ = NULL;
			gdouble _tmp10_ = 0.0;
			GdkEventButton* _tmp11_ = NULL;
			gdouble _tmp12_ = 0.0;
			_tmp9_ = event;
			_tmp10_ = _tmp9_->x;
			_tmp11_ = event;
			_tmp12_ = _tmp11_->y;
			puzzle_view_pick_tile (self, _tmp10_, _tmp12_);
		} else {
			TileImage* _tmp13_ = NULL;
			_tmp13_ = self->priv->selected_tile;
			if (_tmp13_ != NULL) {
				GdkEventButton* _tmp14_ = NULL;
				gdouble _tmp15_ = 0.0;
				GdkEventButton* _tmp16_ = NULL;
				gdouble _tmp17_ = 0.0;
				_tmp14_ = event;
				_tmp15_ = _tmp14_->x;
				_tmp16_ = event;
				_tmp17_ = _tmp16_->y;
				puzzle_view_drop_tile (self, _tmp15_, _tmp17_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventButton* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp10_ = 0U;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = event;
	_tmp3_ = _tmp2_->button;
	if (_tmp3_ == ((guint) 1)) {
		TileImage* _tmp4_ = NULL;
		_tmp4_ = self->priv->selected_tile;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->selection_timeout;
		_tmp0_ = _tmp5_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkEventButton* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		GdkEventButton* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->x;
		_tmp8_ = event;
		_tmp9_ = _tmp8_->y;
		puzzle_view_drop_tile (self, _tmp7_, _tmp9_);
	}
	_tmp10_ = self->priv->selection_timeout;
	if (_tmp10_ != ((guint) 0)) {
		guint _tmp11_ = 0U;
		_tmp11_ = self->priv->selection_timeout;
		g_source_remove (_tmp11_);
	}
	self->priv->selection_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	TileImage* _tmp0_ = NULL;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		TileImage* _tmp1_ = NULL;
		GdkEventMotion* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		GdkEventMotion* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp1_ = self->priv->selected_tile;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->x;
		_tmp4_ = self->priv->selected_x_offset;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->y;
		_tmp7_ = self->priv->selected_y_offset;
		puzzle_view_move_tile (self, _tmp1_, (gdouble) ((gint) (_tmp3_ - _tmp4_)), (gdouble) ((gint) (_tmp6_ - _tmp7_)), (gdouble) 0);
	}
	result = FALSE;
	return result;
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}


static gpointer _puzzle_ref0 (gpointer self) {
	return self ? puzzle_ref (self) : NULL;
}


static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender, Tile* tile, guint x, guint y, gpointer self) {
	puzzle_view_tile_moved_cb ((PuzzleView*) self, _sender, tile, x, y);
}


static void _puzzle_view_puzzle___lambda3_ (PuzzleView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __puzzle_view_puzzle___lambda3__puzzle_paused_changed (Puzzle* _sender, gpointer self) {
	_puzzle_view_puzzle___lambda3_ ((PuzzleView*) self);
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	Puzzle* _tmp35_ = NULL;
	Puzzle* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		_tmp1_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _puzzle_ref0 (_tmp2_);
	_puzzle_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp3_;
	_tmp4_ = self->priv->tiles;
	g_hash_table_remove_all (_tmp4_);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				Puzzle* _tmp8_ = NULL;
				Puzzle* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				guint _tmp11_ = 0U;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = y;
					y = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = y;
				_tmp8_ = puzzle_view_get_puzzle (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = puzzle_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(((guint) _tmp7_) < _tmp11_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp14_ = 0;
							Puzzle* _tmp15_ = NULL;
							Puzzle* _tmp16_ = NULL;
							guint _tmp17_ = 0U;
							guint _tmp18_ = 0U;
							Tile* tile = NULL;
							Puzzle* _tmp19_ = NULL;
							Puzzle* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							Tile* _tmp23_ = NULL;
							Tile* _tmp24_ = NULL;
							TileImage* image = NULL;
							Tile* _tmp25_ = NULL;
							TileImage* _tmp26_ = NULL;
							TileImage* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							GHashTable* _tmp30_ = NULL;
							Tile* _tmp31_ = NULL;
							Tile* _tmp32_ = NULL;
							TileImage* _tmp33_ = NULL;
							TileImage* _tmp34_ = NULL;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = x;
								x = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = x;
							_tmp15_ = puzzle_view_get_puzzle (self);
							_tmp16_ = _tmp15_;
							_tmp17_ = puzzle_get_size (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(((guint) _tmp14_) < (_tmp18_ * 2))) {
								break;
							}
							_tmp19_ = puzzle_view_get_puzzle (self);
							_tmp20_ = _tmp19_;
							_tmp21_ = x;
							_tmp22_ = y;
							_tmp23_ = puzzle_get_tile (_tmp20_, (guint) _tmp21_, (guint) _tmp22_);
							tile = _tmp23_;
							_tmp24_ = tile;
							if (_tmp24_ == NULL) {
								_tile_unref0 (tile);
								continue;
							}
							_tmp25_ = tile;
							_tmp26_ = tile_image_new (_tmp25_);
							image = _tmp26_;
							_tmp27_ = image;
							_tmp28_ = x;
							_tmp29_ = y;
							puzzle_view_move_tile_to_location (self, _tmp27_, (guint) _tmp28_, (guint) _tmp29_, (gdouble) 0);
							_tmp30_ = self->priv->tiles;
							_tmp31_ = tile;
							_tmp32_ = _tile_ref0 (_tmp31_);
							_tmp33_ = image;
							_tmp34_ = _tile_image_ref0 (_tmp33_);
							g_hash_table_insert (_tmp30_, _tmp32_, _tmp34_);
							_tile_image_unref0 (image);
							_tile_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp35_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp35_, "tile-moved", (GCallback) _puzzle_view_tile_moved_cb_puzzle_tile_moved, self, 0);
	_tmp36_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp36_, "paused-changed", (GCallback) __puzzle_view_puzzle___lambda3__puzzle_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "puzzle");
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = puzzle_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = puzzle_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->configure_event = puzzle_view_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = puzzle_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = puzzle_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = puzzle_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, param_spec_puzzle ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("tile_moved", TYPE_PUZZLE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void puzzle_view_instance_init (PuzzleView * self) {
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
	self->priv->_puzzle = NULL;
	self->priv->selected_tile = NULL;
	self->priv->selection_timeout = (guint) 0;
	self->priv->animation_timeout = (guint) 0;
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_puzzle_unref0 (self->priv->_puzzle);
	_theme_unref0 (self->priv->theme);
	_tile_image_unref0 (self->priv->selected_tile);
	_g_hash_table_unref0 (self->priv->tiles);
	_g_timer_destroy0 (self->priv->animation_timer);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		value_set_puzzle (value, puzzle_view_get_puzzle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		puzzle_view_set_puzzle (self, value_get_puzzle (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



