/* taquin-view.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from taquin-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;
typedef struct _TaquinViewPrivate TaquinViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_GAME_TYPE (game_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	DIRECTION_TOP,
	DIRECTION_LEFT,
	DIRECTION_RIGHT,
	DIRECTION_BOTTOM,
	DIRECTION_NONE
} Direction;

struct _TaquinView {
	GtkDrawingArea parent_instance;
	TaquinViewPrivate * priv;
};

struct _TaquinViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _TaquinViewPrivate {
	gint grid_border_main;
	gint grid_border_thin;
	gint arrows;
	gint tile_size;
	gint board_size;
	gint x_arrow;
	gint y_arrow;
	gboolean draw_lights;
	gint render_size;
	cairo_pattern_t* tiles_pattern;
	gboolean animate;
	gint animation_offset;
	gboolean x_axis;
	gint number;
	gint x_gap;
	gint y_gap;
	gboolean animate_end;
	gboolean finished;
	gdouble animation_end_offset;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;


static gpointer taquin_view_parent_class = NULL;

GType direction_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN_VIEW, TaquinViewPrivate))
enum  {
	TAQUIN_VIEW_DUMMY_PROPERTY,
	TAQUIN_VIEW_GAME,
	TAQUIN_VIEW_THEME
};
#define TAQUIN_VIEW_GRID_SPACING 1
static void taquin_view_calculate (TaquinView* self);
Game* taquin_view_get_game (TaquinView* self);
gint game_get_size (Game* self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
static gboolean taquin_view_real_draw (GtkWidget* base, cairo_t* cr);
static void taquin_view_load_image (TaquinView* self, cairo_t* c);
static gint taquin_view_get_x_offset (TaquinView* self);
static gint taquin_view_get_y_offset (TaquinView* self);
GType game_type_get_type (void) G_GNUC_CONST;
GameType game_get_game_type (Game* self);
static void taquin_view_draw_movable_lights (TaquinView* self, cairo_t* cr);
static void taquin_view_draw_fixed_arrows (TaquinView* self, cairo_t* cr);
static void taquin_view_draw_movable_arrows (TaquinView* self, cairo_t* cr);
gint* game_get_tiles (Game* self, int* result_length1, int* result_length2);
const gchar* taquin_view_get_theme (TaquinView* self);
static void taquin_view_draw_light (TaquinView* self, cairo_t* cr, gboolean horizontal);
static void taquin_view_draw_vertical_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number);
static void taquin_view_draw_horizontal_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number);
static void taquin_view_move_cb (TaquinView* self, gboolean x_axis, gint number, gint x_gap, gint y_gap);
static void taquin_view_complete_cb (TaquinView* self);
static gboolean __lambda4_ (TaquinView* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean taquin_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_request_move (Game* self, gint x, gint y);
static gboolean taquin_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
void taquin_view_set_game (TaquinView* self, Game* value);
static void _taquin_view_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self);
static void _taquin_view_complete_cb_game_complete (Game* _sender, gpointer self);
void taquin_view_set_theme (TaquinView* self, const gchar* value);
static void taquin_view_finalize (GObject* obj);
static void _vala_taquin_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_taquin_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType direction_get_type (void) {
	static volatile gsize direction_type_id__volatile = 0;
	if (g_once_init_enter (&direction_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTION_TOP, "DIRECTION_TOP", "top"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_BOTTOM, "DIRECTION_BOTTOM", "bottom"}, {DIRECTION_NONE, "DIRECTION_NONE", "none"}, {0, NULL, NULL}};
		GType direction_type_id;
		direction_type_id = g_enum_register_static ("Direction", values);
		g_once_init_leave (&direction_type_id__volatile, direction_type_id);
	}
	return direction_type_id__volatile;
}


static void taquin_view_calculate (TaquinView* self) {
	gint size = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	size = _tmp2_;
	_tmp3_ = taquin_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_get_size (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->tile_size = ((size * 10) / 12) / _tmp6_;
	_tmp7_ = self->priv->tile_size;
	_tmp8_ = taquin_view_get_game (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = game_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	self->priv->board_size = (_tmp7_ * _tmp11_) - TAQUIN_VIEW_GRID_SPACING;
	_tmp12_ = self->priv->board_size;
	self->priv->grid_border_main = (size - _tmp12_) / 2;
	self->priv->arrows = size / 100;
}


TaquinView* taquin_view_construct (GType object_type) {
	TaquinView * self = NULL;
	self = (TaquinView*) g_object_new (object_type, NULL);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
	return self;
}


TaquinView* taquin_view_new (void) {
	return taquin_view_construct (TYPE_TAQUIN_VIEW);
}


static gboolean taquin_view_real_draw (GtkWidget* base, cairo_t* cr) {
	TaquinView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	cairo_t* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	cairo_t* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	cairo_t* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	cairo_t* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	cairo_t* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	cairo_t* _tmp69_ = NULL;
	cairo_t* _tmp70_ = NULL;
	gdouble _tmp71_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	Game* _tmp74_ = NULL;
	Game* _tmp75_ = NULL;
	GameType _tmp76_ = 0;
	GameType _tmp77_ = 0;
	cairo_t* _tmp82_ = NULL;
	cairo_t* _tmp83_ = NULL;
	cairo_t* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp291_ = FALSE;
	cairo_t* _tmp299_ = NULL;
	gboolean _tmp300_ = FALSE;
	self = (TaquinView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	taquin_view_calculate (self);
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = self->priv->tile_size;
		_tmp2_ = _tmp4_ != _tmp5_;
	}
	if (_tmp2_) {
		gint _tmp6_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		cairo_surface_t* _tmp15_ = NULL;
		cairo_pattern_t* _tmp16_ = NULL;
		_tmp6_ = self->priv->tile_size;
		self->priv->render_size = _tmp6_;
		_tmp7_ = cr;
		_tmp8_ = cairo_get_target (_tmp7_);
		_tmp9_ = self->priv->board_size;
		_tmp10_ = self->priv->board_size;
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp10_);
		surface = _tmp11_;
		_tmp12_ = surface;
		_tmp13_ = cairo_create (_tmp12_);
		c = _tmp13_;
		_tmp14_ = c;
		taquin_view_load_image (self, _tmp14_);
		_tmp15_ = surface;
		_tmp16_ = cairo_pattern_create_for_surface (_tmp15_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp16_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp17_ = cr;
	_tmp18_ = taquin_view_get_x_offset (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = taquin_view_get_y_offset (self);
	_tmp21_ = _tmp20_;
	cairo_translate (_tmp17_, (gdouble) _tmp19_, (gdouble) _tmp21_);
	_tmp22_ = cr;
	cairo_set_line_cap (_tmp22_, CAIRO_LINE_CAP_ROUND);
	_tmp23_ = cr;
	cairo_set_line_join (_tmp23_, CAIRO_LINE_JOIN_ROUND);
	_tmp24_ = cr;
	cairo_set_source_rgb (_tmp24_, 0.8, 0.8, 0.8);
	_tmp25_ = cr;
	_tmp26_ = self->priv->grid_border_main;
	_tmp27_ = self->priv->grid_border_main;
	_tmp28_ = self->priv->board_size;
	_tmp29_ = self->priv->grid_border_main;
	_tmp30_ = self->priv->board_size;
	_tmp31_ = self->priv->grid_border_main;
	cairo_rectangle (_tmp25_, _tmp26_ / 2.0, _tmp27_ / 2.0, (gdouble) (_tmp28_ + _tmp29_), (gdouble) (_tmp30_ + _tmp31_));
	_tmp32_ = cr;
	cairo_fill_preserve (_tmp32_);
	_tmp33_ = cr;
	cairo_set_source_rgb (_tmp33_, 0.3, 0.3, 0.3);
	_tmp34_ = cr;
	_tmp35_ = self->priv->grid_border_main;
	cairo_set_line_width (_tmp34_, (gdouble) _tmp35_);
	_tmp36_ = cr;
	cairo_stroke (_tmp36_);
	_tmp37_ = cr;
	cairo_set_source_rgb (_tmp37_, 0.1, 0.1, 0.1);
	_tmp38_ = cr;
	_tmp39_ = self->priv->grid_border_thin;
	cairo_set_line_width (_tmp38_, (gdouble) _tmp39_);
	_tmp40_ = cr;
	_tmp41_ = self->priv->grid_border_main;
	_tmp42_ = self->priv->grid_border_main;
	_tmp43_ = self->priv->grid_border_main;
	_tmp44_ = self->priv->grid_border_thin;
	cairo_arc (_tmp40_, _tmp41_ / 2.0, _tmp42_ / 2.0, (_tmp43_ - _tmp44_) / 2.0, G_PI, (G_PI * 3) / 2.0);
	_tmp45_ = cr;
	_tmp46_ = self->priv->grid_border_main;
	_tmp47_ = self->priv->board_size;
	_tmp48_ = self->priv->grid_border_main;
	_tmp49_ = self->priv->grid_border_main;
	_tmp50_ = self->priv->grid_border_thin;
	cairo_arc (_tmp45_, ((_tmp46_ * 3) / 2.0) + _tmp47_, _tmp48_ / 2.0, (_tmp49_ - _tmp50_) / 2.0, (G_PI * 3) / 2.0, (gdouble) 0);
	_tmp51_ = cr;
	_tmp52_ = self->priv->grid_border_main;
	_tmp53_ = self->priv->board_size;
	_tmp54_ = self->priv->grid_border_main;
	_tmp55_ = self->priv->board_size;
	_tmp56_ = self->priv->grid_border_main;
	_tmp57_ = self->priv->grid_border_thin;
	cairo_arc (_tmp51_, ((_tmp52_ * 3) / 2.0) + _tmp53_, ((_tmp54_ * 3) / 2.0) + _tmp55_, (_tmp56_ - _tmp57_) / 2.0, (gdouble) 0, G_PI / 2.0);
	_tmp58_ = cr;
	_tmp59_ = self->priv->grid_border_main;
	_tmp60_ = self->priv->grid_border_main;
	_tmp61_ = self->priv->board_size;
	_tmp62_ = self->priv->grid_border_main;
	_tmp63_ = self->priv->grid_border_thin;
	cairo_arc (_tmp58_, _tmp59_ / 2.0, ((_tmp60_ * 3) / 2.0) + _tmp61_, (_tmp62_ - _tmp63_) / 2.0, G_PI / 2.0, G_PI);
	_tmp64_ = cr;
	_tmp65_ = self->priv->grid_border_main;
	_tmp66_ = self->priv->grid_border_main;
	_tmp67_ = self->priv->grid_border_main;
	_tmp68_ = self->priv->grid_border_thin;
	cairo_arc (_tmp64_, _tmp65_ / 2.0, _tmp66_ / 2.0, (_tmp67_ - _tmp68_) / 2.0, G_PI, (G_PI * 3) / 2.0);
	_tmp69_ = cr;
	cairo_stroke (_tmp69_);
	_tmp70_ = cr;
	_tmp71_ = self->priv->animation_end_offset;
	cairo_set_source_rgba (_tmp70_, 0.25, 0.25, 0.25, 1.0 - _tmp71_);
	_tmp72_ = cr;
	_tmp73_ = self->priv->arrows;
	cairo_set_line_width (_tmp72_, (gdouble) _tmp73_);
	_tmp74_ = taquin_view_get_game (self);
	_tmp75_ = _tmp74_;
	_tmp76_ = game_get_game_type (_tmp75_);
	_tmp77_ = _tmp76_;
	if (_tmp77_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp78_ = FALSE;
		cairo_t* _tmp80_ = NULL;
		_tmp78_ = self->priv->draw_lights;
		if (_tmp78_) {
			cairo_t* _tmp79_ = NULL;
			_tmp79_ = cr;
			taquin_view_draw_movable_lights (self, _tmp79_);
		}
		_tmp80_ = cr;
		taquin_view_draw_fixed_arrows (self, _tmp80_);
	} else {
		cairo_t* _tmp81_ = NULL;
		_tmp81_ = cr;
		taquin_view_draw_movable_arrows (self, _tmp81_);
	}
	_tmp82_ = cr;
	cairo_stroke (_tmp82_);
	_tmp83_ = cr;
	cairo_save (_tmp83_);
	_tmp84_ = cr;
	_tmp85_ = self->priv->grid_border_main;
	_tmp86_ = self->priv->grid_border_main;
	cairo_translate (_tmp84_, (gdouble) _tmp85_, (gdouble) _tmp86_);
	_tmp88_ = self->priv->animate;
	if (_tmp88_) {
		Game* _tmp89_ = NULL;
		Game* _tmp90_ = NULL;
		GameType _tmp91_ = 0;
		GameType _tmp92_ = 0;
		_tmp89_ = taquin_view_get_game (self);
		_tmp90_ = _tmp89_;
		_tmp91_ = game_get_game_type (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp87_ = _tmp92_ == GAME_TYPE_SIXTEEN;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		gint texture_x = 0;
		Game* _tmp93_ = NULL;
		Game* _tmp94_ = NULL;
		gint* _tmp95_ = NULL;
		gint _tmp95__length1 = 0;
		gint _tmp95__length2 = 0;
		gint* _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		gint _tmp96__length2 = 0;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		Game* _tmp100_ = NULL;
		Game* _tmp101_ = NULL;
		gint _tmp102_ = 0;
		gint _tmp103_ = 0;
		gint _tmp104_ = 0;
		gint texture_y = 0;
		Game* _tmp105_ = NULL;
		Game* _tmp106_ = NULL;
		gint* _tmp107_ = NULL;
		gint _tmp107__length1 = 0;
		gint _tmp107__length2 = 0;
		gint* _tmp108_ = NULL;
		gint _tmp108__length1 = 0;
		gint _tmp108__length2 = 0;
		gint _tmp109_ = 0;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
		Game* _tmp112_ = NULL;
		Game* _tmp113_ = NULL;
		gint _tmp114_ = 0;
		gint _tmp115_ = 0;
		gint _tmp116_ = 0;
		gint tile_x = 0;
		gint _tmp117_ = 0;
		gint _tmp118_ = 0;
		gint tile_y = 0;
		gint _tmp119_ = 0;
		gint _tmp120_ = 0;
		cairo_matrix_t matrix = {0};
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		cairo_pattern_t* _tmp125_ = NULL;
		cairo_matrix_t _tmp126_ = {0};
		cairo_t* _tmp127_ = NULL;
		cairo_pattern_t* _tmp128_ = NULL;
		cairo_t* _tmp129_ = NULL;
		gint _tmp130_ = 0;
		gint _tmp131_ = 0;
		gint _tmp132_ = 0;
		gint _tmp133_ = 0;
		cairo_t* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		gboolean _tmp136_ = FALSE;
		gint _tmp144_ = 0;
		gint _tmp145_ = 0;
		gboolean _tmp146_ = FALSE;
		gint _tmp154_ = 0;
		gint _tmp155_ = 0;
		gint _tmp156_ = 0;
		gint _tmp157_ = 0;
		gint _tmp158_ = 0;
		cairo_pattern_t* _tmp159_ = NULL;
		cairo_matrix_t _tmp160_ = {0};
		cairo_t* _tmp161_ = NULL;
		cairo_pattern_t* _tmp162_ = NULL;
		cairo_t* _tmp163_ = NULL;
		gint _tmp164_ = 0;
		gint _tmp165_ = 0;
		gint _tmp166_ = 0;
		gint _tmp167_ = 0;
		cairo_t* _tmp168_ = NULL;
		_tmp93_ = taquin_view_get_game (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = game_get_tiles (_tmp94_, &_tmp95__length1, &_tmp95__length2);
		_tmp96_ = _tmp95_;
		_tmp96__length1 = _tmp95__length1;
		_tmp96__length2 = _tmp95__length2;
		_tmp97_ = self->priv->x_gap;
		_tmp98_ = self->priv->y_gap;
		_tmp99_ = _tmp96_[(_tmp97_ * _tmp96__length2) + _tmp98_];
		_tmp100_ = taquin_view_get_game (self);
		_tmp101_ = _tmp100_;
		_tmp102_ = game_get_size (_tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = self->priv->tile_size;
		texture_x = (_tmp99_ % _tmp103_) * _tmp104_;
		_tmp105_ = taquin_view_get_game (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = game_get_tiles (_tmp106_, &_tmp107__length1, &_tmp107__length2);
		_tmp108_ = _tmp107_;
		_tmp108__length1 = _tmp107__length1;
		_tmp108__length2 = _tmp107__length2;
		_tmp109_ = self->priv->x_gap;
		_tmp110_ = self->priv->y_gap;
		_tmp111_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
		_tmp112_ = taquin_view_get_game (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = game_get_size (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = self->priv->tile_size;
		texture_y = (_tmp111_ / _tmp115_) * _tmp116_;
		_tmp117_ = self->priv->x_gap;
		_tmp118_ = self->priv->tile_size;
		tile_x = _tmp117_ * _tmp118_;
		_tmp119_ = self->priv->y_gap;
		_tmp120_ = self->priv->tile_size;
		tile_y = _tmp119_ * _tmp120_;
		cairo_matrix_init_identity (&matrix);
		_tmp121_ = texture_x;
		_tmp122_ = tile_x;
		_tmp123_ = texture_y;
		_tmp124_ = tile_y;
		cairo_matrix_translate (&matrix, (gdouble) (_tmp121_ - _tmp122_), (gdouble) (_tmp123_ - _tmp124_));
		_tmp125_ = self->priv->tiles_pattern;
		_tmp126_ = matrix;
		cairo_pattern_set_matrix (_tmp125_, &_tmp126_);
		_tmp127_ = cr;
		_tmp128_ = self->priv->tiles_pattern;
		cairo_set_source (_tmp127_, _tmp128_);
		_tmp129_ = cr;
		_tmp130_ = tile_x;
		_tmp131_ = tile_y;
		_tmp132_ = self->priv->tile_size;
		_tmp133_ = self->priv->tile_size;
		cairo_rectangle (_tmp129_, (gdouble) _tmp130_, (gdouble) _tmp131_, (gdouble) (_tmp132_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp133_ - TAQUIN_VIEW_GRID_SPACING));
		_tmp134_ = cr;
		cairo_fill (_tmp134_);
		_tmp136_ = self->priv->x_axis;
		if (_tmp136_) {
			gint _tmp137_ = 0;
			gint _tmp138_ = 0;
			_tmp138_ = self->priv->x_gap;
			if (_tmp138_ == 0) {
				Game* _tmp139_ = NULL;
				Game* _tmp140_ = NULL;
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
				_tmp139_ = taquin_view_get_game (self);
				_tmp140_ = _tmp139_;
				_tmp141_ = game_get_size (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp137_ = _tmp142_ - 1;
			} else {
				_tmp137_ = 0;
			}
			_tmp135_ = _tmp137_;
		} else {
			gint _tmp143_ = 0;
			_tmp143_ = self->priv->x_gap;
			_tmp135_ = _tmp143_;
		}
		_tmp144_ = self->priv->tile_size;
		tile_x = _tmp144_ * _tmp135_;
		_tmp146_ = self->priv->x_axis;
		if (_tmp146_) {
			gint _tmp147_ = 0;
			_tmp147_ = self->priv->y_gap;
			_tmp145_ = _tmp147_;
		} else {
			gint _tmp148_ = 0;
			gint _tmp149_ = 0;
			_tmp149_ = self->priv->y_gap;
			if (_tmp149_ == 0) {
				Game* _tmp150_ = NULL;
				Game* _tmp151_ = NULL;
				gint _tmp152_ = 0;
				gint _tmp153_ = 0;
				_tmp150_ = taquin_view_get_game (self);
				_tmp151_ = _tmp150_;
				_tmp152_ = game_get_size (_tmp151_);
				_tmp153_ = _tmp152_;
				_tmp148_ = _tmp153_ - 1;
			} else {
				_tmp148_ = 0;
			}
			_tmp145_ = _tmp148_;
		}
		_tmp154_ = self->priv->tile_size;
		tile_y = _tmp154_ * _tmp145_;
		cairo_matrix_init_identity (&matrix);
		_tmp155_ = texture_x;
		_tmp156_ = tile_x;
		_tmp157_ = texture_y;
		_tmp158_ = tile_y;
		cairo_matrix_translate (&matrix, (gdouble) (_tmp155_ - _tmp156_), (gdouble) (_tmp157_ - _tmp158_));
		_tmp159_ = self->priv->tiles_pattern;
		_tmp160_ = matrix;
		cairo_pattern_set_matrix (_tmp159_, &_tmp160_);
		_tmp161_ = cr;
		_tmp162_ = self->priv->tiles_pattern;
		cairo_set_source (_tmp161_, _tmp162_);
		_tmp163_ = cr;
		_tmp164_ = tile_x;
		_tmp165_ = tile_y;
		_tmp166_ = self->priv->tile_size;
		_tmp167_ = self->priv->tile_size;
		cairo_rectangle (_tmp163_, (gdouble) _tmp164_, (gdouble) _tmp165_, (gdouble) (_tmp166_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp167_ - TAQUIN_VIEW_GRID_SPACING));
		_tmp168_ = cr;
		cairo_fill (_tmp168_);
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp169_ = FALSE;
			_tmp169_ = TRUE;
			while (TRUE) {
				gint _tmp171_ = 0;
				Game* _tmp172_ = NULL;
				Game* _tmp173_ = NULL;
				gint _tmp174_ = 0;
				gint _tmp175_ = 0;
				if (!_tmp169_) {
					gint _tmp170_ = 0;
					_tmp170_ = y;
					y = _tmp170_ + 1;
				}
				_tmp169_ = FALSE;
				_tmp171_ = y;
				_tmp172_ = taquin_view_get_game (self);
				_tmp173_ = _tmp172_;
				_tmp174_ = game_get_size (_tmp173_);
				_tmp175_ = _tmp174_;
				if (!(_tmp171_ < _tmp175_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp176_ = FALSE;
						_tmp176_ = TRUE;
						while (TRUE) {
							gint _tmp178_ = 0;
							Game* _tmp179_ = NULL;
							Game* _tmp180_ = NULL;
							gint _tmp181_ = 0;
							gint _tmp182_ = 0;
							gboolean _tmp183_ = FALSE;
							gboolean _tmp184_ = FALSE;
							gboolean _tmp185_ = FALSE;
							gint tile_x = 0;
							gint _tmp190_ = 0;
							gint _tmp191_ = 0;
							gint tile_y = 0;
							gint _tmp192_ = 0;
							gint _tmp193_ = 0;
							gboolean _tmp194_ = FALSE;
							gboolean _tmp195_ = FALSE;
							gint texture_x = 0;
							Game* _tmp253_ = NULL;
							Game* _tmp254_ = NULL;
							gint* _tmp255_ = NULL;
							gint _tmp255__length1 = 0;
							gint _tmp255__length2 = 0;
							gint* _tmp256_ = NULL;
							gint _tmp256__length1 = 0;
							gint _tmp256__length2 = 0;
							gint _tmp257_ = 0;
							gint _tmp258_ = 0;
							gint _tmp259_ = 0;
							Game* _tmp260_ = NULL;
							Game* _tmp261_ = NULL;
							gint _tmp262_ = 0;
							gint _tmp263_ = 0;
							gint _tmp264_ = 0;
							gint texture_y = 0;
							Game* _tmp265_ = NULL;
							Game* _tmp266_ = NULL;
							gint* _tmp267_ = NULL;
							gint _tmp267__length1 = 0;
							gint _tmp267__length2 = 0;
							gint* _tmp268_ = NULL;
							gint _tmp268__length1 = 0;
							gint _tmp268__length2 = 0;
							gint _tmp269_ = 0;
							gint _tmp270_ = 0;
							gint _tmp271_ = 0;
							Game* _tmp272_ = NULL;
							Game* _tmp273_ = NULL;
							gint _tmp274_ = 0;
							gint _tmp275_ = 0;
							gint _tmp276_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp277_ = 0;
							gint _tmp278_ = 0;
							gint _tmp279_ = 0;
							gint _tmp280_ = 0;
							cairo_pattern_t* _tmp281_ = NULL;
							cairo_matrix_t _tmp282_ = {0};
							cairo_t* _tmp283_ = NULL;
							cairo_pattern_t* _tmp284_ = NULL;
							cairo_t* _tmp285_ = NULL;
							gint _tmp286_ = 0;
							gint _tmp287_ = 0;
							gint _tmp288_ = 0;
							gint _tmp289_ = 0;
							cairo_t* _tmp290_ = NULL;
							if (!_tmp176_) {
								gint _tmp177_ = 0;
								_tmp177_ = x;
								x = _tmp177_ + 1;
							}
							_tmp176_ = FALSE;
							_tmp178_ = x;
							_tmp179_ = taquin_view_get_game (self);
							_tmp180_ = _tmp179_;
							_tmp181_ = game_get_size (_tmp180_);
							_tmp182_ = _tmp181_;
							if (!(_tmp178_ < _tmp182_)) {
								break;
							}
							_tmp185_ = self->priv->animate;
							if (_tmp185_) {
								gint _tmp186_ = 0;
								gint _tmp187_ = 0;
								_tmp186_ = x;
								_tmp187_ = self->priv->x_gap;
								_tmp184_ = _tmp186_ == _tmp187_;
							} else {
								_tmp184_ = FALSE;
							}
							if (_tmp184_) {
								gint _tmp188_ = 0;
								gint _tmp189_ = 0;
								_tmp188_ = y;
								_tmp189_ = self->priv->y_gap;
								_tmp183_ = _tmp188_ == _tmp189_;
							} else {
								_tmp183_ = FALSE;
							}
							if (_tmp183_) {
								continue;
							}
							_tmp190_ = x;
							_tmp191_ = self->priv->tile_size;
							tile_x = _tmp190_ * _tmp191_;
							_tmp192_ = y;
							_tmp193_ = self->priv->tile_size;
							tile_y = _tmp192_ * _tmp193_;
							_tmp195_ = self->priv->animate;
							if (_tmp195_) {
								gboolean _tmp196_ = FALSE;
								gint _tmp197_ = 0;
								gint _tmp198_ = 0;
								_tmp197_ = x;
								_tmp198_ = self->priv->x_gap;
								if (_tmp197_ != _tmp198_) {
									_tmp196_ = TRUE;
								} else {
									gint _tmp199_ = 0;
									gint _tmp200_ = 0;
									_tmp199_ = y;
									_tmp200_ = self->priv->y_gap;
									_tmp196_ = _tmp199_ != _tmp200_;
								}
								_tmp194_ = _tmp196_;
							} else {
								_tmp194_ = FALSE;
							}
							if (_tmp194_) {
								gboolean _tmp201_ = FALSE;
								gboolean _tmp202_ = FALSE;
								_tmp202_ = self->priv->x_axis;
								if (_tmp202_) {
									gint _tmp203_ = 0;
									gint _tmp204_ = 0;
									_tmp203_ = y;
									_tmp204_ = self->priv->y_gap;
									_tmp201_ = _tmp203_ == _tmp204_;
								} else {
									_tmp201_ = FALSE;
								}
								if (_tmp201_) {
									gboolean _tmp205_ = FALSE;
									gboolean _tmp206_ = FALSE;
									gint _tmp207_ = 0;
									_tmp207_ = self->priv->number;
									if (_tmp207_ > 0) {
										gint _tmp208_ = 0;
										gint _tmp209_ = 0;
										gint _tmp210_ = 0;
										_tmp208_ = x;
										_tmp209_ = self->priv->x_gap;
										_tmp210_ = self->priv->number;
										_tmp206_ = _tmp208_ <= (_tmp209_ + _tmp210_);
									} else {
										_tmp206_ = FALSE;
									}
									if (_tmp206_) {
										gint _tmp211_ = 0;
										gint _tmp212_ = 0;
										_tmp211_ = x;
										_tmp212_ = self->priv->x_gap;
										_tmp205_ = _tmp211_ >= _tmp212_;
									} else {
										_tmp205_ = FALSE;
									}
									if (_tmp205_) {
										gint _tmp213_ = 0;
										gint _tmp214_ = 0;
										gint _tmp215_ = 0;
										_tmp213_ = tile_x;
										_tmp214_ = self->priv->tile_size;
										_tmp215_ = self->priv->animation_offset;
										tile_x = _tmp213_ - (_tmp214_ - _tmp215_);
									} else {
										gboolean _tmp216_ = FALSE;
										gboolean _tmp217_ = FALSE;
										gint _tmp218_ = 0;
										_tmp218_ = self->priv->number;
										if (_tmp218_ < 0) {
											gint _tmp219_ = 0;
											gint _tmp220_ = 0;
											gint _tmp221_ = 0;
											_tmp219_ = x;
											_tmp220_ = self->priv->x_gap;
											_tmp221_ = self->priv->number;
											_tmp217_ = _tmp219_ >= (_tmp220_ + _tmp221_);
										} else {
											_tmp217_ = FALSE;
										}
										if (_tmp217_) {
											gint _tmp222_ = 0;
											gint _tmp223_ = 0;
											_tmp222_ = x;
											_tmp223_ = self->priv->x_gap;
											_tmp216_ = _tmp222_ <= _tmp223_;
										} else {
											_tmp216_ = FALSE;
										}
										if (_tmp216_) {
											gint _tmp224_ = 0;
											gint _tmp225_ = 0;
											gint _tmp226_ = 0;
											_tmp224_ = tile_x;
											_tmp225_ = self->priv->tile_size;
											_tmp226_ = self->priv->animation_offset;
											tile_x = _tmp224_ + (_tmp225_ - _tmp226_);
										}
									}
								} else {
									gboolean _tmp227_ = FALSE;
									gboolean _tmp228_ = FALSE;
									_tmp228_ = self->priv->x_axis;
									if (!_tmp228_) {
										gint _tmp229_ = 0;
										gint _tmp230_ = 0;
										_tmp229_ = x;
										_tmp230_ = self->priv->x_gap;
										_tmp227_ = _tmp229_ == _tmp230_;
									} else {
										_tmp227_ = FALSE;
									}
									if (_tmp227_) {
										gboolean _tmp231_ = FALSE;
										gboolean _tmp232_ = FALSE;
										gint _tmp233_ = 0;
										_tmp233_ = self->priv->number;
										if (_tmp233_ > 0) {
											gint _tmp234_ = 0;
											gint _tmp235_ = 0;
											gint _tmp236_ = 0;
											_tmp234_ = y;
											_tmp235_ = self->priv->y_gap;
											_tmp236_ = self->priv->number;
											_tmp232_ = _tmp234_ <= (_tmp235_ + _tmp236_);
										} else {
											_tmp232_ = FALSE;
										}
										if (_tmp232_) {
											gint _tmp237_ = 0;
											gint _tmp238_ = 0;
											_tmp237_ = y;
											_tmp238_ = self->priv->y_gap;
											_tmp231_ = _tmp237_ >= _tmp238_;
										} else {
											_tmp231_ = FALSE;
										}
										if (_tmp231_) {
											gint _tmp239_ = 0;
											gint _tmp240_ = 0;
											gint _tmp241_ = 0;
											_tmp239_ = tile_y;
											_tmp240_ = self->priv->tile_size;
											_tmp241_ = self->priv->animation_offset;
											tile_y = _tmp239_ - (_tmp240_ - _tmp241_);
										} else {
											gboolean _tmp242_ = FALSE;
											gboolean _tmp243_ = FALSE;
											gint _tmp244_ = 0;
											_tmp244_ = self->priv->number;
											if (_tmp244_ < 0) {
												gint _tmp245_ = 0;
												gint _tmp246_ = 0;
												gint _tmp247_ = 0;
												_tmp245_ = y;
												_tmp246_ = self->priv->y_gap;
												_tmp247_ = self->priv->number;
												_tmp243_ = _tmp245_ >= (_tmp246_ + _tmp247_);
											} else {
												_tmp243_ = FALSE;
											}
											if (_tmp243_) {
												gint _tmp248_ = 0;
												gint _tmp249_ = 0;
												_tmp248_ = y;
												_tmp249_ = self->priv->y_gap;
												_tmp242_ = _tmp248_ <= _tmp249_;
											} else {
												_tmp242_ = FALSE;
											}
											if (_tmp242_) {
												gint _tmp250_ = 0;
												gint _tmp251_ = 0;
												gint _tmp252_ = 0;
												_tmp250_ = tile_y;
												_tmp251_ = self->priv->tile_size;
												_tmp252_ = self->priv->animation_offset;
												tile_y = _tmp250_ + (_tmp251_ - _tmp252_);
											}
										}
									}
								}
							}
							_tmp253_ = taquin_view_get_game (self);
							_tmp254_ = _tmp253_;
							_tmp255_ = game_get_tiles (_tmp254_, &_tmp255__length1, &_tmp255__length2);
							_tmp256_ = _tmp255_;
							_tmp256__length1 = _tmp255__length1;
							_tmp256__length2 = _tmp255__length2;
							_tmp257_ = x;
							_tmp258_ = y;
							_tmp259_ = _tmp256_[(_tmp257_ * _tmp256__length2) + _tmp258_];
							_tmp260_ = taquin_view_get_game (self);
							_tmp261_ = _tmp260_;
							_tmp262_ = game_get_size (_tmp261_);
							_tmp263_ = _tmp262_;
							_tmp264_ = self->priv->tile_size;
							texture_x = (_tmp259_ % _tmp263_) * _tmp264_;
							_tmp265_ = taquin_view_get_game (self);
							_tmp266_ = _tmp265_;
							_tmp267_ = game_get_tiles (_tmp266_, &_tmp267__length1, &_tmp267__length2);
							_tmp268_ = _tmp267_;
							_tmp268__length1 = _tmp267__length1;
							_tmp268__length2 = _tmp267__length2;
							_tmp269_ = x;
							_tmp270_ = y;
							_tmp271_ = _tmp268_[(_tmp269_ * _tmp268__length2) + _tmp270_];
							_tmp272_ = taquin_view_get_game (self);
							_tmp273_ = _tmp272_;
							_tmp274_ = game_get_size (_tmp273_);
							_tmp275_ = _tmp274_;
							_tmp276_ = self->priv->tile_size;
							texture_y = (_tmp271_ / _tmp275_) * _tmp276_;
							cairo_matrix_init_identity (&matrix);
							_tmp277_ = texture_x;
							_tmp278_ = tile_x;
							_tmp279_ = texture_y;
							_tmp280_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp277_ - _tmp278_), (gdouble) (_tmp279_ - _tmp280_));
							_tmp281_ = self->priv->tiles_pattern;
							_tmp282_ = matrix;
							cairo_pattern_set_matrix (_tmp281_, &_tmp282_);
							_tmp283_ = cr;
							_tmp284_ = self->priv->tiles_pattern;
							cairo_set_source (_tmp283_, _tmp284_);
							_tmp285_ = cr;
							_tmp286_ = tile_x;
							_tmp287_ = tile_y;
							_tmp288_ = self->priv->tile_size;
							_tmp289_ = self->priv->tile_size;
							cairo_rectangle (_tmp285_, (gdouble) _tmp286_, (gdouble) _tmp287_, (gdouble) (_tmp288_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp289_ - TAQUIN_VIEW_GRID_SPACING));
							_tmp290_ = cr;
							cairo_fill (_tmp290_);
						}
					}
				}
			}
		}
	}
	_tmp291_ = self->priv->animate_end;
	if (_tmp291_) {
		gdouble _tmp292_ = 0.0;
		gdouble _tmp293_ = 0.0;
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp294_ = NULL;
		cairo_matrix_t _tmp295_ = {0};
		cairo_t* _tmp296_ = NULL;
		gdouble _tmp297_ = 0.0;
		gdouble _tmp298_ = 0.0;
		_tmp292_ = self->priv->animation_end_offset;
		self->priv->animation_end_offset = _tmp292_ + 0.01;
		_tmp293_ = self->priv->animation_end_offset;
		if (_tmp293_ >= ((gdouble) 1)) {
			self->priv->animation_end_offset = (gdouble) 1;
		}
		cairo_matrix_init_identity (&matrix);
		_tmp294_ = self->priv->tiles_pattern;
		_tmp295_ = matrix;
		cairo_pattern_set_matrix (_tmp294_, &_tmp295_);
		_tmp296_ = cr;
		_tmp297_ = self->priv->animation_end_offset;
		cairo_paint_with_alpha (_tmp296_, _tmp297_);
		_tmp298_ = self->priv->animation_end_offset;
		if (_tmp298_ != ((gdouble) 1)) {
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
	_tmp299_ = cr;
	cairo_restore (_tmp299_);
	_tmp300_ = self->priv->animate;
	if (_tmp300_) {
		gint _tmp301_ = 0;
		gboolean _tmp302_ = FALSE;
		gint _tmp337_ = 0;
		gint _tmp338_ = 0;
		_tmp301_ = self->priv->animation_offset;
		self->priv->animation_offset = _tmp301_ + 8;
		_tmp302_ = self->priv->x_axis;
		if (_tmp302_) {
			gint _tmp303_ = 0;
			gint _tmp304_ = 0;
			gint _tmp305_ = 0;
			gint _tmp306_ = 0;
			gint _tmp307_ = 0;
			gint _tmp308_ = 0;
			gint _tmp309_ = 0;
			gint _tmp310_ = 0;
			gint _tmp311_ = 0;
			gint _tmp312_ = 0;
			gint _tmp313_ = 0;
			gint _tmp314_ = 0;
			gint _tmp315_ = 0;
			gint _tmp316_ = 0;
			gint _tmp317_ = 0;
			gint _tmp318_ = 0;
			gint _tmp319_ = 0;
			_tmp303_ = taquin_view_get_x_offset (self);
			_tmp304_ = _tmp303_;
			_tmp305_ = self->priv->grid_border_main;
			_tmp306_ = self->priv->tile_size;
			_tmp307_ = self->priv->x_gap;
			_tmp308_ = self->priv->x_gap;
			_tmp309_ = self->priv->number;
			_tmp310_ = MIN (_tmp307_, _tmp308_ + _tmp309_);
			_tmp311_ = taquin_view_get_y_offset (self);
			_tmp312_ = _tmp311_;
			_tmp313_ = self->priv->grid_border_main;
			_tmp314_ = self->priv->tile_size;
			_tmp315_ = self->priv->y_gap;
			_tmp316_ = self->priv->tile_size;
			_tmp317_ = self->priv->number;
			_tmp318_ = abs (_tmp317_);
			_tmp319_ = self->priv->tile_size;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp304_ + _tmp305_) + (_tmp306_ * _tmp310_), (_tmp312_ + _tmp313_) + (_tmp314_ * _tmp315_), _tmp316_ * (_tmp318_ + 1), _tmp319_);
		} else {
			gint _tmp320_ = 0;
			gint _tmp321_ = 0;
			gint _tmp322_ = 0;
			gint _tmp323_ = 0;
			gint _tmp324_ = 0;
			gint _tmp325_ = 0;
			gint _tmp326_ = 0;
			gint _tmp327_ = 0;
			gint _tmp328_ = 0;
			gint _tmp329_ = 0;
			gint _tmp330_ = 0;
			gint _tmp331_ = 0;
			gint _tmp332_ = 0;
			gint _tmp333_ = 0;
			gint _tmp334_ = 0;
			gint _tmp335_ = 0;
			gint _tmp336_ = 0;
			_tmp320_ = taquin_view_get_x_offset (self);
			_tmp321_ = _tmp320_;
			_tmp322_ = self->priv->grid_border_main;
			_tmp323_ = self->priv->tile_size;
			_tmp324_ = self->priv->x_gap;
			_tmp325_ = taquin_view_get_y_offset (self);
			_tmp326_ = _tmp325_;
			_tmp327_ = self->priv->grid_border_main;
			_tmp328_ = self->priv->tile_size;
			_tmp329_ = self->priv->y_gap;
			_tmp330_ = self->priv->y_gap;
			_tmp331_ = self->priv->number;
			_tmp332_ = MIN (_tmp329_, _tmp330_ + _tmp331_);
			_tmp333_ = self->priv->tile_size;
			_tmp334_ = self->priv->tile_size;
			_tmp335_ = self->priv->number;
			_tmp336_ = abs (_tmp335_);
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp321_ + _tmp322_) + (_tmp323_ * _tmp324_), (_tmp326_ + _tmp327_) + (_tmp328_ * _tmp332_), _tmp333_, _tmp334_ * (_tmp336_ + 1));
		}
		_tmp337_ = self->priv->animation_offset;
		_tmp338_ = self->priv->tile_size;
		if (_tmp337_ > _tmp338_) {
			self->priv->animate = FALSE;
		}
	}
	result = FALSE;
	return result;
}


static void taquin_view_load_image (TaquinView* self, cairo_t* c) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GdkPixbuf* _tmp4_ = NULL;
		cairo_t* _tmp5_ = NULL;
		cairo_t* _tmp6_ = NULL;
		_tmp0_ = taquin_view_get_theme (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->board_size;
		_tmp3_ = self->priv->board_size;
		_tmp4_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, _tmp2_, _tmp3_, FALSE, &_inner_error_);
		p = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp5_ = c;
		gdk_cairo_set_source_pixbuf (_tmp5_, p, (gdouble) 0, (gdouble) 0);
		_tmp6_ = c;
		cairo_paint (_tmp6_);
		_g_object_unref0 (p);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = taquin_view_get_theme (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("taquin-view.vala:294: Failed to load theme %s: %s\n" \
"\n" \
"If you were trying to launch an unusual size, retry, it may work. But " \
"it probably implies that you have not an image adapted to the requeste" \
"d size in the current theme. If that's not the case, file a bug please" \
".\n", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void taquin_view_draw_movable_lights (TaquinView* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_save (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = self->priv->animation_end_offset;
	cairo_set_source_rgba (_tmp1_, 0.8, 0.8, 0.8, 0.3 - (0.3 * _tmp2_));
	_tmp3_ = cr;
	cairo_save (_tmp3_);
	_tmp4_ = cr;
	_tmp5_ = self->priv->grid_border_main;
	_tmp6_ = self->priv->tile_size;
	_tmp7_ = self->priv->x_arrow;
	_tmp8_ = self->priv->grid_border_main;
	_tmp9_ = self->priv->grid_border_thin;
	cairo_translate (_tmp4_, _tmp5_ + (_tmp6_ * (_tmp7_ + 0.5)), (_tmp8_ + _tmp9_) / 2.0);
	_tmp10_ = cr;
	taquin_view_draw_light (self, _tmp10_, TRUE);
	_tmp11_ = cr;
	_tmp12_ = self->priv->board_size;
	_tmp13_ = self->priv->grid_border_main;
	_tmp14_ = self->priv->grid_border_thin;
	cairo_translate (_tmp11_, (gdouble) 0, (gdouble) ((_tmp12_ + _tmp13_) - _tmp14_));
	_tmp15_ = cr;
	taquin_view_draw_light (self, _tmp15_, TRUE);
	_tmp16_ = cr;
	cairo_restore (_tmp16_);
	_tmp17_ = cr;
	cairo_fill (_tmp17_);
	_tmp18_ = cr;
	cairo_save (_tmp18_);
	_tmp19_ = cr;
	_tmp20_ = self->priv->grid_border_main;
	_tmp21_ = self->priv->grid_border_thin;
	_tmp22_ = self->priv->grid_border_main;
	_tmp23_ = self->priv->tile_size;
	_tmp24_ = self->priv->y_arrow;
	cairo_translate (_tmp19_, (_tmp20_ + _tmp21_) / 2.0, _tmp22_ + (_tmp23_ * (_tmp24_ + 0.5)));
	_tmp25_ = cr;
	taquin_view_draw_light (self, _tmp25_, FALSE);
	_tmp26_ = cr;
	_tmp27_ = self->priv->board_size;
	_tmp28_ = self->priv->grid_border_main;
	_tmp29_ = self->priv->grid_border_thin;
	cairo_translate (_tmp26_, (gdouble) ((_tmp27_ + _tmp28_) - _tmp29_), (gdouble) 0);
	_tmp30_ = cr;
	taquin_view_draw_light (self, _tmp30_, FALSE);
	_tmp31_ = cr;
	cairo_restore (_tmp31_);
	_tmp32_ = cr;
	cairo_fill (_tmp32_);
	_tmp33_ = cr;
	cairo_restore (_tmp33_);
}


static void taquin_view_draw_light (TaquinView* self, cairo_t* cr, gboolean horizontal) {
	cairo_t* _tmp0_ = NULL;
	gdouble size = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	cairo_t* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_save (_tmp0_);
	_tmp1_ = self->priv->tile_size;
	_tmp2_ = self->priv->grid_border_main;
	size = (0.3 * _tmp1_) / _tmp2_;
	_tmp4_ = horizontal;
	if (_tmp4_) {
		gdouble _tmp5_ = 0.0;
		_tmp5_ = size;
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = 0.3;
	}
	_tmp7_ = horizontal;
	if (_tmp7_) {
		_tmp6_ = 0.3;
	} else {
		gdouble _tmp8_ = 0.0;
		_tmp8_ = size;
		_tmp6_ = _tmp8_;
	}
	_tmp9_ = cr;
	cairo_scale (_tmp9_, _tmp3_, _tmp6_);
	_tmp10_ = cr;
	_tmp11_ = self->priv->grid_border_main;
	cairo_arc (_tmp10_, 0.0, 0.0, (gdouble) _tmp11_, 0.0, 2.0 * G_PI);
	_tmp12_ = cr;
	cairo_restore (_tmp12_);
}


static void taquin_view_draw_fixed_arrows (TaquinView* self, cairo_t* cr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				Game* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				cairo_t* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				cairo_t* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = taquin_view_get_game (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = game_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				_tmp7_ = cr;
				_tmp8_ = i;
				taquin_view_draw_vertical_arrow (self, _tmp7_, FALSE, _tmp8_);
				_tmp9_ = cr;
				_tmp10_ = i;
				taquin_view_draw_horizontal_arrow (self, _tmp9_, FALSE, _tmp10_);
			}
		}
	}
}


static void taquin_view_draw_movable_arrows (TaquinView* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	_tmp1_ = self->priv->x_arrow;
	taquin_view_draw_vertical_arrow (self, _tmp0_, TRUE, _tmp1_);
	_tmp2_ = cr;
	_tmp3_ = self->priv->y_arrow;
	taquin_view_draw_horizontal_arrow (self, _tmp2_, TRUE, _tmp3_);
}


static void taquin_view_draw_horizontal_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number) {
	gdouble x1 = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble x2 = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	gboolean _tmp21_ = FALSE;
	cairo_t* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gdouble _tmp34_ = 0.0;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gdouble _tmp42_ = 0.0;
	gboolean _tmp43_ = FALSE;
	cairo_t* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gdouble _tmp50_ = 0.0;
	gboolean _tmp51_ = FALSE;
	cairo_t* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->grid_border_main;
	_tmp1_ = self->priv->grid_border_thin;
	x1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
	_tmp2_ = self->priv->grid_border_main;
	_tmp3_ = self->priv->grid_border_thin;
	x2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
	_tmp5_ = inside;
	if (_tmp5_) {
		gdouble _tmp6_ = 0.0;
		_tmp6_ = x1;
		_tmp4_ = _tmp6_;
	} else {
		gdouble _tmp7_ = 0.0;
		_tmp7_ = x2;
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = cr;
	_tmp9_ = self->priv->grid_border_main;
	_tmp10_ = self->priv->tile_size;
	_tmp11_ = number;
	cairo_move_to (_tmp8_, _tmp4_, _tmp9_ + (_tmp10_ * (_tmp11_ + (1.0 / 3))));
	_tmp13_ = inside;
	if (_tmp13_) {
		gdouble _tmp14_ = 0.0;
		_tmp14_ = x2;
		_tmp12_ = _tmp14_;
	} else {
		gdouble _tmp15_ = 0.0;
		_tmp15_ = x1;
		_tmp12_ = _tmp15_;
	}
	_tmp16_ = cr;
	_tmp17_ = self->priv->grid_border_main;
	_tmp18_ = self->priv->tile_size;
	_tmp19_ = number;
	cairo_line_to (_tmp16_, _tmp12_, _tmp17_ + (_tmp18_ * (_tmp19_ + (1.0 / 2))));
	_tmp21_ = inside;
	if (_tmp21_) {
		gdouble _tmp22_ = 0.0;
		_tmp22_ = x1;
		_tmp20_ = _tmp22_;
	} else {
		gdouble _tmp23_ = 0.0;
		_tmp23_ = x2;
		_tmp20_ = _tmp23_;
	}
	_tmp24_ = cr;
	_tmp25_ = self->priv->grid_border_main;
	_tmp26_ = self->priv->tile_size;
	_tmp27_ = number;
	cairo_line_to (_tmp24_, _tmp20_, _tmp25_ + (_tmp26_ * (_tmp27_ + (2.0 / 3))));
	_tmp28_ = self->priv->board_size;
	_tmp29_ = self->priv->grid_border_main;
	_tmp30_ = self->priv->grid_border_thin;
	x1 = (_tmp28_ + ((_tmp29_ * 5.0) / 3)) - ((_tmp30_ * 2.0) / 3);
	_tmp31_ = self->priv->board_size;
	_tmp32_ = self->priv->grid_border_main;
	_tmp33_ = self->priv->grid_border_thin;
	x2 = (_tmp31_ + ((_tmp32_ * 4.0) / 3)) - ((_tmp33_ * 1.0) / 3);
	_tmp35_ = inside;
	if (_tmp35_) {
		gdouble _tmp36_ = 0.0;
		_tmp36_ = x1;
		_tmp34_ = _tmp36_;
	} else {
		gdouble _tmp37_ = 0.0;
		_tmp37_ = x2;
		_tmp34_ = _tmp37_;
	}
	_tmp38_ = cr;
	_tmp39_ = self->priv->grid_border_main;
	_tmp40_ = self->priv->tile_size;
	_tmp41_ = number;
	cairo_move_to (_tmp38_, _tmp34_, _tmp39_ + (_tmp40_ * (_tmp41_ + (1.0 / 3))));
	_tmp43_ = inside;
	if (_tmp43_) {
		gdouble _tmp44_ = 0.0;
		_tmp44_ = x2;
		_tmp42_ = _tmp44_;
	} else {
		gdouble _tmp45_ = 0.0;
		_tmp45_ = x1;
		_tmp42_ = _tmp45_;
	}
	_tmp46_ = cr;
	_tmp47_ = self->priv->grid_border_main;
	_tmp48_ = self->priv->tile_size;
	_tmp49_ = number;
	cairo_line_to (_tmp46_, _tmp42_, _tmp47_ + (_tmp48_ * (_tmp49_ + (1.0 / 2))));
	_tmp51_ = inside;
	if (_tmp51_) {
		gdouble _tmp52_ = 0.0;
		_tmp52_ = x1;
		_tmp50_ = _tmp52_;
	} else {
		gdouble _tmp53_ = 0.0;
		_tmp53_ = x2;
		_tmp50_ = _tmp53_;
	}
	_tmp54_ = cr;
	_tmp55_ = self->priv->grid_border_main;
	_tmp56_ = self->priv->tile_size;
	_tmp57_ = number;
	cairo_line_to (_tmp54_, _tmp50_, _tmp55_ + (_tmp56_ * (_tmp57_ + (2.0 / 3))));
}


static void taquin_view_draw_vertical_arrow (TaquinView* self, cairo_t* cr, gboolean inside, gint number) {
	gdouble y1 = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble y2 = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	gboolean _tmp21_ = FALSE;
	cairo_t* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gdouble _tmp34_ = 0.0;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gdouble _tmp42_ = 0.0;
	gboolean _tmp43_ = FALSE;
	cairo_t* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gdouble _tmp50_ = 0.0;
	gboolean _tmp51_ = FALSE;
	cairo_t* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->grid_border_main;
	_tmp1_ = self->priv->grid_border_thin;
	y1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
	_tmp2_ = self->priv->grid_border_main;
	_tmp3_ = self->priv->grid_border_thin;
	y2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
	_tmp5_ = inside;
	if (_tmp5_) {
		gdouble _tmp6_ = 0.0;
		_tmp6_ = y1;
		_tmp4_ = _tmp6_;
	} else {
		gdouble _tmp7_ = 0.0;
		_tmp7_ = y2;
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = cr;
	_tmp9_ = self->priv->grid_border_main;
	_tmp10_ = self->priv->tile_size;
	_tmp11_ = number;
	cairo_move_to (_tmp8_, _tmp9_ + (_tmp10_ * (_tmp11_ + (1.0 / 3))), _tmp4_);
	_tmp13_ = inside;
	if (_tmp13_) {
		gdouble _tmp14_ = 0.0;
		_tmp14_ = y2;
		_tmp12_ = _tmp14_;
	} else {
		gdouble _tmp15_ = 0.0;
		_tmp15_ = y1;
		_tmp12_ = _tmp15_;
	}
	_tmp16_ = cr;
	_tmp17_ = self->priv->grid_border_main;
	_tmp18_ = self->priv->tile_size;
	_tmp19_ = number;
	cairo_line_to (_tmp16_, _tmp17_ + (_tmp18_ * (_tmp19_ + (1.0 / 2))), _tmp12_);
	_tmp21_ = inside;
	if (_tmp21_) {
		gdouble _tmp22_ = 0.0;
		_tmp22_ = y1;
		_tmp20_ = _tmp22_;
	} else {
		gdouble _tmp23_ = 0.0;
		_tmp23_ = y2;
		_tmp20_ = _tmp23_;
	}
	_tmp24_ = cr;
	_tmp25_ = self->priv->grid_border_main;
	_tmp26_ = self->priv->tile_size;
	_tmp27_ = number;
	cairo_line_to (_tmp24_, _tmp25_ + (_tmp26_ * (_tmp27_ + (2.0 / 3))), _tmp20_);
	_tmp28_ = self->priv->board_size;
	_tmp29_ = self->priv->grid_border_main;
	_tmp30_ = self->priv->grid_border_thin;
	y1 = (_tmp28_ + ((_tmp29_ * 5.0) / 3)) - ((_tmp30_ * 2.0) / 3);
	_tmp31_ = self->priv->board_size;
	_tmp32_ = self->priv->grid_border_main;
	_tmp33_ = self->priv->grid_border_thin;
	y2 = (_tmp31_ + ((_tmp32_ * 4.0) / 3)) - ((_tmp33_ * 1.0) / 3);
	_tmp35_ = inside;
	if (_tmp35_) {
		gdouble _tmp36_ = 0.0;
		_tmp36_ = y1;
		_tmp34_ = _tmp36_;
	} else {
		gdouble _tmp37_ = 0.0;
		_tmp37_ = y2;
		_tmp34_ = _tmp37_;
	}
	_tmp38_ = cr;
	_tmp39_ = self->priv->grid_border_main;
	_tmp40_ = self->priv->tile_size;
	_tmp41_ = number;
	cairo_move_to (_tmp38_, _tmp39_ + (_tmp40_ * (_tmp41_ + (1.0 / 3))), _tmp34_);
	_tmp43_ = inside;
	if (_tmp43_) {
		gdouble _tmp44_ = 0.0;
		_tmp44_ = y2;
		_tmp42_ = _tmp44_;
	} else {
		gdouble _tmp45_ = 0.0;
		_tmp45_ = y1;
		_tmp42_ = _tmp45_;
	}
	_tmp46_ = cr;
	_tmp47_ = self->priv->grid_border_main;
	_tmp48_ = self->priv->tile_size;
	_tmp49_ = number;
	cairo_line_to (_tmp46_, _tmp47_ + (_tmp48_ * (_tmp49_ + (1.0 / 2))), _tmp42_);
	_tmp51_ = inside;
	if (_tmp51_) {
		gdouble _tmp52_ = 0.0;
		_tmp52_ = y1;
		_tmp50_ = _tmp52_;
	} else {
		gdouble _tmp53_ = 0.0;
		_tmp53_ = y2;
		_tmp50_ = _tmp53_;
	}
	_tmp54_ = cr;
	_tmp55_ = self->priv->grid_border_main;
	_tmp56_ = self->priv->tile_size;
	_tmp57_ = number;
	cairo_line_to (_tmp54_, _tmp55_ + (_tmp56_ * (_tmp57_ + (2.0 / 3))), _tmp50_);
}


static void taquin_view_move_cb (TaquinView* self, gboolean x_axis, gint number, gint x_gap, gint y_gap) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	GameType _tmp6_ = 0;
	GameType _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = x_axis;
	self->priv->x_axis = _tmp0_;
	_tmp1_ = number;
	self->priv->number = _tmp1_;
	_tmp2_ = x_gap;
	self->priv->x_gap = _tmp2_;
	_tmp3_ = y_gap;
	self->priv->y_gap = _tmp3_;
	_tmp4_ = taquin_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_game_type (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == GAME_TYPE_FIFTEEN) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = x_gap;
		self->priv->x_arrow = _tmp8_;
		_tmp9_ = y_gap;
		self->priv->y_arrow = _tmp9_;
	}
	self->priv->animation_offset = 0;
	self->priv->animate = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean __lambda4_ (TaquinView* self) {
	gboolean result = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->animate_end = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((TaquinView*) self);
	return result;
}


static void taquin_view_complete_cb (TaquinView* self) {
	g_return_if_fail (self != NULL);
	self->priv->finished = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean taquin_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->animate;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->animate_end;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->button;
	if (_tmp5_ == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp3_ = TRUE;
	} else {
		GdkEventButton* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->button;
		_tmp3_ = _tmp7_ == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp3_) {
		Game* _tmp8_ = NULL;
		Game* _tmp9_ = NULL;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GdkEventButton* _tmp17_ = NULL;
		gdouble _tmp18_ = 0.0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		self->priv->draw_lights = FALSE;
		_tmp8_ = taquin_view_get_game (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = event;
		_tmp11_ = _tmp10_->x;
		_tmp12_ = taquin_view_get_x_offset (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->grid_border_main;
		_tmp15_ = self->priv->tile_size;
		_tmp16_ = self->priv->tile_size;
		_tmp17_ = event;
		_tmp18_ = _tmp17_->y;
		_tmp19_ = taquin_view_get_y_offset (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->grid_border_main;
		_tmp22_ = self->priv->tile_size;
		_tmp23_ = self->priv->tile_size;
		game_request_move (_tmp9_, (((gint) (((_tmp11_ - _tmp13_) - _tmp14_) + _tmp15_)) / _tmp16_) - 1, (((gint) (((_tmp18_ - _tmp20_) - _tmp21_) + _tmp22_)) / _tmp23_) - 1);
	}
	result = TRUE;
	return result;
}


static gboolean taquin_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameType _tmp8_ = 0;
	GameType _tmp9_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GQuark _tmp51_ = 0U;
	static GQuark _tmp50_label0 = 0;
	static GQuark _tmp50_label1 = 0;
	static GQuark _tmp50_label2 = 0;
	static GQuark _tmp50_label3 = 0;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->finished;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = gdk_keyval_name (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	k_name = _tmp4_;
	_tmp6_ = taquin_view_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_get_game_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp10_ = FALSE;
		GdkEventKey* _tmp11_ = NULL;
		GdkModifierType _tmp12_ = 0;
		_tmp11_ = event;
		_tmp12_ = _tmp11_->state;
		if ((_tmp12_ & GDK_SHIFT_MASK) > 0) {
			_tmp10_ = TRUE;
		} else {
			GdkEventKey* _tmp13_ = NULL;
			GdkModifierType _tmp14_ = 0;
			_tmp13_ = event;
			_tmp14_ = _tmp13_->state;
			_tmp10_ = (_tmp14_ & GDK_CONTROL_MASK) > 0;
		}
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GQuark _tmp18_ = 0U;
		static GQuark _tmp17_label0 = 0;
		static GQuark _tmp17_label1 = 0;
		static GQuark _tmp17_label2 = 0;
		static GQuark _tmp17_label3 = 0;
		_tmp15_ = k_name;
		_tmp16_ = _tmp15_;
		_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
		if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("Left")))) {
			switch (0) {
				default:
				{
					Game* _tmp19_ = NULL;
					Game* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					_tmp19_ = taquin_view_get_game (self);
					_tmp20_ = _tmp19_;
					_tmp21_ = self->priv->y_arrow;
					game_request_move (_tmp20_, -1, _tmp21_);
					break;
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("Right")))) {
			switch (0) {
				default:
				{
					Game* _tmp22_ = NULL;
					Game* _tmp23_ = NULL;
					Game* _tmp24_ = NULL;
					Game* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					_tmp22_ = taquin_view_get_game (self);
					_tmp23_ = _tmp22_;
					_tmp24_ = taquin_view_get_game (self);
					_tmp25_ = _tmp24_;
					_tmp26_ = game_get_size (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = self->priv->y_arrow;
					game_request_move (_tmp23_, _tmp27_, _tmp28_);
					break;
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("Up")))) {
			switch (0) {
				default:
				{
					Game* _tmp29_ = NULL;
					Game* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					_tmp29_ = taquin_view_get_game (self);
					_tmp30_ = _tmp29_;
					_tmp31_ = self->priv->x_arrow;
					game_request_move (_tmp30_, _tmp31_, -1);
					break;
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label3) ? _tmp17_label3 : (_tmp17_label3 = g_quark_from_static_string ("Down")))) {
			switch (0) {
				default:
				{
					Game* _tmp32_ = NULL;
					Game* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					Game* _tmp35_ = NULL;
					Game* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					_tmp32_ = taquin_view_get_game (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = self->priv->x_arrow;
					_tmp35_ = taquin_view_get_game (self);
					_tmp36_ = _tmp35_;
					_tmp37_ = game_get_size (_tmp36_);
					_tmp38_ = _tmp37_;
					game_request_move (_tmp33_, _tmp34_, _tmp38_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = FALSE;
					_g_free0 (k_name);
					return result;
				}
			}
		}
	}
	_tmp41_ = k_name;
	if (g_strcmp0 (_tmp41_, "space") == 0) {
		_tmp40_ = TRUE;
	} else {
		const gchar* _tmp42_ = NULL;
		_tmp42_ = k_name;
		_tmp40_ = g_strcmp0 (_tmp42_, "KP_Enter") == 0;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		const gchar* _tmp43_ = NULL;
		_tmp43_ = k_name;
		_tmp39_ = g_strcmp0 (_tmp43_, "Return") == 0;
	}
	if (_tmp39_) {
		Game* _tmp44_ = NULL;
		Game* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		_tmp44_ = taquin_view_get_game (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = self->priv->x_arrow;
		_tmp47_ = self->priv->y_arrow;
		game_request_move (_tmp45_, _tmp46_, _tmp47_);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp48_ = k_name;
	_tmp49_ = _tmp48_;
	_tmp51_ = (NULL == _tmp49_) ? 0 : g_quark_from_string (_tmp49_);
	if (_tmp51_ == ((0 != _tmp50_label0) ? _tmp50_label0 : (_tmp50_label0 = g_quark_from_static_string ("Left")))) {
		switch (0) {
			default:
			{
				gint _tmp52_ = 0;
				_tmp52_ = self->priv->x_arrow;
				if (_tmp52_ > 0) {
					gint _tmp53_ = 0;
					_tmp53_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp53_ - 1;
				}
				break;
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label1) ? _tmp50_label1 : (_tmp50_label1 = g_quark_from_static_string ("Right")))) {
		switch (0) {
			default:
			{
				gint _tmp54_ = 0;
				Game* _tmp55_ = NULL;
				Game* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				_tmp54_ = self->priv->x_arrow;
				_tmp55_ = taquin_view_get_game (self);
				_tmp56_ = _tmp55_;
				_tmp57_ = game_get_size (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp54_ < (_tmp58_ - 1)) {
					gint _tmp59_ = 0;
					_tmp59_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp59_ + 1;
				}
				break;
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label2) ? _tmp50_label2 : (_tmp50_label2 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				gint _tmp60_ = 0;
				_tmp60_ = self->priv->y_arrow;
				if (_tmp60_ > 0) {
					gint _tmp61_ = 0;
					_tmp61_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp61_ - 1;
				}
				break;
			}
		}
	} else if (_tmp51_ == ((0 != _tmp50_label3) ? _tmp50_label3 : (_tmp50_label3 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				gint _tmp62_ = 0;
				Game* _tmp63_ = NULL;
				Game* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
				_tmp62_ = self->priv->y_arrow;
				_tmp63_ = taquin_view_get_game (self);
				_tmp64_ = _tmp63_;
				_tmp65_ = game_get_size (_tmp64_);
				_tmp66_ = _tmp65_;
				if (_tmp62_ < (_tmp66_ - 1)) {
					gint _tmp67_ = 0;
					_tmp67_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp67_ + 1;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (k_name);
				return result;
			}
		}
	}
	self->priv->draw_lights = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (k_name);
	return result;
}


static gint taquin_view_get_x_offset (TaquinView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = self->priv->board_size;
	_tmp2_ = self->priv->grid_border_main;
	result = ((_tmp0_ - _tmp1_) / 2) - _tmp2_;
	return result;
}


static gint taquin_view_get_y_offset (TaquinView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = self->priv->board_size;
	_tmp2_ = self->priv->grid_border_main;
	result = ((_tmp0_ - _tmp1_) / 2) - _tmp2_;
	return result;
}


Game* taquin_view_get_game (TaquinView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _taquin_view_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self) {
	taquin_view_move_cb ((TaquinView*) self, x_axis, number, x_gap, y_gap);
}


static void _taquin_view_complete_cb_game_complete (Game* _sender, gpointer self) {
	taquin_view_complete_cb ((TaquinView*) self);
}


void taquin_view_set_game (TaquinView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	self->priv->animate = FALSE;
	self->priv->finished = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->draw_lights = FALSE;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "move", (GCallback) _taquin_view_move_cb_game_move, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "complete", (GCallback) _taquin_view_complete_cb_game_complete, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "game");
}


const gchar* taquin_view_get_theme (TaquinView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void taquin_view_set_theme (TaquinView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "theme");
}


static void taquin_view_class_init (TaquinViewClass * klass) {
	taquin_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TaquinViewPrivate));
	((GtkWidgetClass *) klass)->draw = taquin_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = taquin_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = taquin_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_taquin_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_taquin_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = taquin_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void taquin_view_instance_init (TaquinView * self) {
	self->priv = TAQUIN_VIEW_GET_PRIVATE (self);
	self->priv->grid_border_thin = 6;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	self->priv->draw_lights = FALSE;
	self->priv->render_size = 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->finished = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void taquin_view_finalize (GObject* obj) {
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (taquin_view_parent_class)->finalize (obj);
}


GType taquin_view_get_type (void) {
	static volatile gsize taquin_view_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaquinView), 0, (GInstanceInitFunc) taquin_view_instance_init, NULL };
		GType taquin_view_type_id;
		taquin_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TaquinView", &g_define_type_info, 0);
		g_once_init_leave (&taquin_view_type_id__volatile, taquin_view_type_id);
	}
	return taquin_view_type_id__volatile;
}


static void _vala_taquin_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME:
		g_value_set_object (value, taquin_view_get_game (self));
		break;
		case TAQUIN_VIEW_THEME:
		g_value_set_string (value, taquin_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_taquin_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME:
		taquin_view_set_game (self, g_value_get_object (value));
		break;
		case TAQUIN_VIEW_THEME:
		taquin_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



