/* taquin-game.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint x;
	gint y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint* _tiles;
	gint _tiles_length1;
	gint _tiles_length2;
	gint _size;
	GameType _game_type;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	gint x_gap;
	gint y_gap;
};


static gpointer game_parent_class = NULL;

GType game_type_get_type (void) G_GNUC_CONST;
gchar* game_type_to_string (GameType self);
GType game_get_type (void) G_GNUC_CONST;
static GType game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SIZE,
	GAME_GAME_TYPE
};
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
static void game_set_size (Game* self, gint value);
static void game_set_game_type (Game* self, GameType value);
static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2);
static gint* _int_dup (gint* self);
gint* game_get_tiles (Game* self, int* result_length1, int* result_length2);
gchar* game_to_string (Game* self);
gint game_get_size (Game* self);
void game_request_move (Game* self, gint x, gint y);
GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_add_move (Game* self, gint x_gap, gint y_gap);
static void game_check_complete (Game* self);
void game_undo (Game* self);
static gint* _vala_array_dup1 (gint* self, int length);
static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* game_type_to_string (GameType self) {
	gchar* result = NULL;
	switch (self) {
		case GAME_TYPE_FIFTEEN:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("fifteen");
			result = _tmp0_;
			return result;
		}
		case GAME_TYPE_SIXTEEN:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("sixteen");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType game_type_get_type (void) {
	static volatile gsize game_type_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
		GType game_type_type_id;
		game_type_type_id = g_enum_register_static ("GameType", values);
		g_once_init_leave (&game_type_type_id__volatile, game_type_type_id);
	}
	return game_type_type_id__volatile;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


Game* game_construct (GType object_type, GameType game_type, gint size) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameType _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gint ntiles = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint** line = NULL;
	gint _tmp9_ = 0;
	gint** _tmp10_ = NULL;
	gint line_length1 = 0;
	gint _line_size_ = 0;
	gint i = 0;
	GameType _tmp26_ = 0;
	gboolean parity_grid = FALSE;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean parity_game = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	_tmp0_ = size;
	_vala_return_val_if_fail (_tmp0_ >= 2, "size >= 2", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp1_ = size;
	game_set_size (self, _tmp1_);
	_tmp2_ = game_type;
	game_set_game_type (self, _tmp2_);
	_tmp3_ = size;
	_tmp4_ = size;
	_tmp5_ = g_new0 (gint, _tmp3_ * _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp3_;
	_tmp6__length2 = _tmp4_;
	game_set_tiles (self, _tmp6_, _tmp3_, _tmp4_);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = size;
	_tmp8_ = size;
	ntiles = _tmp7_ * _tmp8_;
	_tmp9_ = ntiles;
	_tmp10_ = g_new0 (gint*, _tmp9_);
	line = _tmp10_;
	line_length1 = _tmp9_;
	_line_size_ = line_length1;
	i = 0;
	{
		gint n = 0;
		gint _tmp11_ = 0;
		_tmp11_ = ntiles;
		n = _tmp11_ - 1;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				gint** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint* _tmp24_ = NULL;
				gint* _tmp25_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = n;
					n = _tmp13_ - 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = n;
				if (!(_tmp14_ >= 0)) {
					break;
				}
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						gint _tmp19_ = 0;
						gint32 _tmp20_ = 0;
						if (!_tmp15_) {
							gint** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp17_ = 0;
							gint* _tmp18_ = NULL;
							_tmp16_ = line;
							_tmp16__length1 = line_length1;
							_tmp17_ = i;
							_tmp18_ = _tmp16_[_tmp17_];
							if (!(_tmp18_ != NULL)) {
								break;
							}
						}
						_tmp15_ = FALSE;
						_tmp19_ = ntiles;
						_tmp20_ = g_random_int_range ((gint32) 0, (gint32) _tmp19_);
						i = (gint) _tmp20_;
					}
				}
				_tmp21_ = line;
				_tmp21__length1 = line_length1;
				_tmp22_ = i;
				_tmp23_ = n;
				_tmp24_ = __int_dup0 (&_tmp23_);
				_g_free0 (_tmp21_[_tmp22_]);
				_tmp21_[_tmp22_] = _tmp24_;
				_tmp25_ = _tmp21_[_tmp22_];
			}
		}
	}
	_tmp26_ = game_type;
	if (_tmp26_ == GAME_TYPE_FIFTEEN) {
		gint** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gint _tmp28_ = 0;
		gint** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gint* _tmp30_ = NULL;
		gint* _tmp31_ = NULL;
		gint* _tmp32_ = NULL;
		gint** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gint _tmp34_ = 0;
		gint* _tmp35_ = NULL;
		gint* _tmp36_ = NULL;
		_tmp27_ = line;
		_tmp27__length1 = line_length1;
		_tmp28_ = i;
		_tmp29_ = line;
		_tmp29__length1 = line_length1;
		_tmp30_ = _tmp29_[0];
		_tmp31_ = __int_dup0 (_tmp30_);
		_g_free0 (_tmp27_[_tmp28_]);
		_tmp27_[_tmp28_] = _tmp31_;
		_tmp32_ = _tmp27_[_tmp28_];
		_tmp33_ = line;
		_tmp33__length1 = line_length1;
		_tmp34_ = -1;
		_tmp35_ = __int_dup0 (&_tmp34_);
		_g_free0 (_tmp33_[0]);
		_tmp33_[0] = _tmp35_;
		_tmp36_ = _tmp33_[0];
		self->priv->x_gap = 0;
		self->priv->y_gap = 0;
	}
	_tmp37_ = size;
	_tmp38_ = size;
	parity_grid = ((gboolean) ((_tmp37_ % 2) ^ (_tmp38_ % 2))) & (1 == 0);
	parity_game = FALSE;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				if (!_tmp39_) {
					gint _tmp40_ = 0;
					_tmp40_ = j;
					j = _tmp40_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp41_ = j;
				_tmp42_ = ntiles;
				if (!(_tmp41_ < (_tmp42_ - 1))) {
					break;
				}
				{
					gint k = 0;
					gint _tmp43_ = 0;
					_tmp43_ = j;
					k = _tmp43_ + 1;
					{
						gboolean _tmp44_ = FALSE;
						_tmp44_ = TRUE;
						while (TRUE) {
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint** _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp49_ = 0;
							gint* _tmp50_ = NULL;
							gint** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp52_ = 0;
							gint* _tmp53_ = NULL;
							if (!_tmp44_) {
								gint _tmp45_ = 0;
								_tmp45_ = k;
								k = _tmp45_ + 1;
							}
							_tmp44_ = FALSE;
							_tmp46_ = k;
							_tmp47_ = ntiles;
							if (!(_tmp46_ < _tmp47_)) {
								break;
							}
							_tmp48_ = line;
							_tmp48__length1 = line_length1;
							_tmp49_ = j;
							_tmp50_ = _tmp48_[_tmp49_];
							_tmp51_ = line;
							_tmp51__length1 = line_length1;
							_tmp52_ = k;
							_tmp53_ = _tmp51_[_tmp52_];
							if ((*_tmp50_) > (*_tmp53_)) {
								gboolean _tmp54_ = FALSE;
								_tmp54_ = parity_game;
								parity_game = !_tmp54_;
							}
						}
					}
				}
			}
		}
	}
	_tmp55_ = parity_game;
	_tmp56_ = parity_grid;
	if (_tmp55_ != _tmp56_) {
		gint* save = NULL;
		gint** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gint* _tmp58_ = NULL;
		gint* _tmp59_ = NULL;
		gint** _tmp60_ = NULL;
		gint _tmp60__length1 = 0;
		gint** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp62_ = 0;
		gint* _tmp63_ = NULL;
		gint* _tmp64_ = NULL;
		gint* _tmp65_ = NULL;
		gint** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gint _tmp67_ = 0;
		gint* _tmp68_ = NULL;
		gint* _tmp69_ = NULL;
		gint* _tmp70_ = NULL;
		_tmp57_ = line;
		_tmp57__length1 = line_length1;
		_tmp58_ = _tmp57_[1];
		_tmp59_ = __int_dup0 (_tmp58_);
		save = _tmp59_;
		_tmp60_ = line;
		_tmp60__length1 = line_length1;
		_tmp61_ = line;
		_tmp61__length1 = line_length1;
		_tmp62_ = size;
		_tmp63_ = _tmp61_[_tmp62_ + 1];
		_tmp64_ = __int_dup0 (_tmp63_);
		_g_free0 (_tmp60_[1]);
		_tmp60_[1] = _tmp64_;
		_tmp65_ = _tmp60_[1];
		_tmp66_ = line;
		_tmp66__length1 = line_length1;
		_tmp67_ = size;
		_tmp68_ = save;
		_tmp69_ = __int_dup0 (_tmp68_);
		_g_free0 (_tmp66_[_tmp67_ + 1]);
		_tmp66_[_tmp67_ + 1] = _tmp69_;
		_tmp70_ = _tmp66_[_tmp67_ + 1];
		_g_free0 (save);
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp71_ = FALSE;
			_tmp71_ = TRUE;
			while (TRUE) {
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint* _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				gint _tmp75__length2 = 0;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp76__length2 = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint** _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				gint _tmp82_ = 0;
				gint* _tmp83_ = NULL;
				gint _tmp84_ = 0;
				if (!_tmp71_) {
					gint _tmp72_ = 0;
					_tmp72_ = j;
					j = _tmp72_ + 1;
				}
				_tmp71_ = FALSE;
				_tmp73_ = j;
				_tmp74_ = ntiles;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = game_get_tiles (self, &_tmp75__length1, &_tmp75__length2);
				_tmp76_ = _tmp75_;
				_tmp76__length1 = _tmp75__length1;
				_tmp76__length2 = _tmp75__length2;
				_tmp77_ = j;
				_tmp78_ = size;
				_tmp79_ = j;
				_tmp80_ = size;
				_tmp81_ = line;
				_tmp81__length1 = line_length1;
				_tmp82_ = j;
				_tmp83_ = _tmp81_[_tmp82_];
				_tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)] = *_tmp83_;
				_tmp84_ = _tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)];
			}
		}
	}
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Game* game_new (GameType game_type, gint size) {
	return game_construct (TYPE_GAME, game_type, size);
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = self->priv->_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							gint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gchar* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = y;
							_tmp8_ = self->priv->_size;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = s;
							_tmp10_ = game_get_tiles (self, &_tmp10__length1, &_tmp10__length2);
							_tmp11_ = _tmp10_;
							_tmp11__length1 = _tmp10__length1;
							_tmp11__length2 = _tmp10__length2;
							_tmp12_ = y;
							_tmp13_ = x;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
							_tmp15_ = g_strdup_printf ("%i", _tmp14_ + 1);
							_tmp16_ = _tmp15_;
							_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
							_tmp18_ = _tmp17_;
							_tmp19_ = g_strconcat (_tmp9_, _tmp18_, NULL);
							_g_free0 (s);
							s = _tmp19_;
							_g_free0 (_tmp18_);
							_g_free0 (_tmp16_);
						}
					}
				}
				_tmp20_ = s;
				_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
				_g_free0 (s);
				s = _tmp21_;
			}
		}
	}
	result = s;
	return result;
}


void game_request_move (Game* self, gint x, gint y) {
	GameType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_type;
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = x;
		_tmp2_ = y;
		game_fifteen_move (self, _tmp1_, _tmp2_, FALSE);
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp3_ = x;
		_tmp4_ = y;
		game_sixteen_move (self, _tmp3_, _tmp4_, FALSE);
	}
}


static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean move_x_axis = FALSE;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gint move_number = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint* _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	gint _tmp93__length2 = 0;
	gint* _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	gint _tmp94__length2 = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	gboolean _tmp98_ = FALSE;
	gint _tmp99_ = 0;
	gint _tmp100_ = 0;
	gint _tmp101_ = 0;
	g_return_if_fail (self != NULL);
	_tmp3_ = x;
	if (_tmp3_ < 0) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp4_ = x;
		_tmp5_ = self->priv->_size;
		_tmp2_ = _tmp4_ >= _tmp5_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp6_ = 0;
		_tmp6_ = y;
		_tmp1_ = _tmp6_ < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = y;
		_tmp8_ = self->priv->_size;
		_tmp0_ = _tmp7_ >= _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = x;
	_tmp11_ = self->priv->x_gap;
	if (_tmp10_ == _tmp11_) {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp12_ = y;
		_tmp13_ = self->priv->y_gap;
		_tmp9_ = _tmp12_ == _tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		g_signal_emit_by_name (self, "empty-tile");
		return;
	}
	_tmp15_ = x;
	_tmp16_ = self->priv->x_gap;
	if (_tmp15_ != _tmp16_) {
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp17_ = y;
		_tmp18_ = self->priv->y_gap;
		_tmp14_ = _tmp17_ != _tmp18_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp19_ = x;
		_tmp20_ = y;
		g_signal_emit_by_name (self, "cannot-move", _tmp19_, _tmp20_);
		return;
	}
	_tmp21_ = x;
	_tmp22_ = self->priv->x_gap;
	move_x_axis = _tmp21_ != _tmp22_;
	_tmp24_ = move_x_axis;
	if (_tmp24_) {
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		_tmp25_ = self->priv->x_gap;
		_tmp26_ = x;
		_tmp23_ = _tmp25_ - _tmp26_;
	} else {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		_tmp27_ = self->priv->y_gap;
		_tmp28_ = y;
		_tmp23_ = _tmp27_ - _tmp28_;
	}
	move_number = _tmp23_;
	_tmp29_ = undoing;
	if (!_tmp29_) {
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		_tmp30_ = self->priv->x_gap;
		_tmp31_ = self->priv->y_gap;
		game_add_move (self, _tmp30_, _tmp31_);
	}
	_tmp32_ = move_x_axis;
	if (_tmp32_) {
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		_tmp33_ = x;
		_tmp34_ = self->priv->x_gap;
		if (_tmp33_ < _tmp34_) {
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					gint* _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					gint _tmp38__length2 = 0;
					gint* _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					gint _tmp39__length2 = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					gint _tmp42__length2 = 0;
					gint* _tmp43_ = NULL;
					gint _tmp43__length1 = 0;
					gint _tmp43__length2 = 0;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					if (!_tmp35_) {
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
						_tmp36_ = self->priv->x_gap;
						_tmp37_ = x;
						if (!(_tmp36_ != _tmp37_)) {
							break;
						}
					}
					_tmp35_ = FALSE;
					_tmp38_ = game_get_tiles (self, &_tmp38__length1, &_tmp38__length2);
					_tmp39_ = _tmp38_;
					_tmp39__length1 = _tmp38__length1;
					_tmp39__length2 = _tmp38__length2;
					_tmp40_ = self->priv->x_gap;
					_tmp41_ = y;
					_tmp42_ = game_get_tiles (self, &_tmp42__length1, &_tmp42__length2);
					_tmp43_ = _tmp42_;
					_tmp43__length1 = _tmp42__length1;
					_tmp43__length2 = _tmp42__length2;
					_tmp44_ = self->priv->x_gap;
					_tmp45_ = y;
					_tmp46_ = _tmp43_[((_tmp44_ - 1) * _tmp43__length2) + _tmp45_];
					_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = _tmp46_;
					_tmp47_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
					_tmp48_ = self->priv->x_gap;
					self->priv->x_gap = _tmp48_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp49_ = FALSE;
				_tmp49_ = TRUE;
				while (TRUE) {
					gint* _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					gint _tmp52__length2 = 0;
					gint* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp53__length2 = 0;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					gint* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					gint _tmp56__length2 = 0;
					gint* _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp57__length2 = 0;
					gint _tmp58_ = 0;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					if (!_tmp49_) {
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
						_tmp50_ = self->priv->x_gap;
						_tmp51_ = x;
						if (!(_tmp50_ != _tmp51_)) {
							break;
						}
					}
					_tmp49_ = FALSE;
					_tmp52_ = game_get_tiles (self, &_tmp52__length1, &_tmp52__length2);
					_tmp53_ = _tmp52_;
					_tmp53__length1 = _tmp52__length1;
					_tmp53__length2 = _tmp52__length2;
					_tmp54_ = self->priv->x_gap;
					_tmp55_ = y;
					_tmp56_ = game_get_tiles (self, &_tmp56__length1, &_tmp56__length2);
					_tmp57_ = _tmp56_;
					_tmp57__length1 = _tmp56__length1;
					_tmp57__length2 = _tmp56__length2;
					_tmp58_ = self->priv->x_gap;
					_tmp59_ = y;
					_tmp60_ = _tmp57_[((_tmp58_ + 1) * _tmp57__length2) + _tmp59_];
					_tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_] = _tmp60_;
					_tmp61_ = _tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_];
					_tmp62_ = self->priv->x_gap;
					self->priv->x_gap = _tmp62_ + 1;
				}
			}
		}
	} else {
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		_tmp63_ = y;
		_tmp64_ = self->priv->y_gap;
		if (_tmp63_ < _tmp64_) {
			{
				gboolean _tmp65_ = FALSE;
				_tmp65_ = TRUE;
				while (TRUE) {
					gint* _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp68__length2 = 0;
					gint* _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gint _tmp69__length2 = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint* _tmp72_ = NULL;
					gint _tmp72__length1 = 0;
					gint _tmp72__length2 = 0;
					gint* _tmp73_ = NULL;
					gint _tmp73__length1 = 0;
					gint _tmp73__length2 = 0;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					if (!_tmp65_) {
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
						_tmp66_ = self->priv->y_gap;
						_tmp67_ = y;
						if (!(_tmp66_ != _tmp67_)) {
							break;
						}
					}
					_tmp65_ = FALSE;
					_tmp68_ = game_get_tiles (self, &_tmp68__length1, &_tmp68__length2);
					_tmp69_ = _tmp68_;
					_tmp69__length1 = _tmp68__length1;
					_tmp69__length2 = _tmp68__length2;
					_tmp70_ = x;
					_tmp71_ = self->priv->y_gap;
					_tmp72_ = game_get_tiles (self, &_tmp72__length1, &_tmp72__length2);
					_tmp73_ = _tmp72_;
					_tmp73__length1 = _tmp72__length1;
					_tmp73__length2 = _tmp72__length2;
					_tmp74_ = x;
					_tmp75_ = self->priv->y_gap;
					_tmp76_ = _tmp73_[(_tmp74_ * _tmp73__length2) + (_tmp75_ - 1)];
					_tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_] = _tmp76_;
					_tmp77_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
					_tmp78_ = self->priv->y_gap;
					self->priv->y_gap = _tmp78_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp79_ = FALSE;
				_tmp79_ = TRUE;
				while (TRUE) {
					gint* _tmp82_ = NULL;
					gint _tmp82__length1 = 0;
					gint _tmp82__length2 = 0;
					gint* _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					gint _tmp83__length2 = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint* _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp86__length2 = 0;
					gint* _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp87__length2 = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
					if (!_tmp79_) {
						gint _tmp80_ = 0;
						gint _tmp81_ = 0;
						_tmp80_ = self->priv->y_gap;
						_tmp81_ = y;
						if (!(_tmp80_ != _tmp81_)) {
							break;
						}
					}
					_tmp79_ = FALSE;
					_tmp82_ = game_get_tiles (self, &_tmp82__length1, &_tmp82__length2);
					_tmp83_ = _tmp82_;
					_tmp83__length1 = _tmp82__length1;
					_tmp83__length2 = _tmp82__length2;
					_tmp84_ = x;
					_tmp85_ = self->priv->y_gap;
					_tmp86_ = game_get_tiles (self, &_tmp86__length1, &_tmp86__length2);
					_tmp87_ = _tmp86_;
					_tmp87__length1 = _tmp86__length1;
					_tmp87__length2 = _tmp86__length2;
					_tmp88_ = x;
					_tmp89_ = self->priv->y_gap;
					_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + (_tmp89_ + 1)];
					_tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_] = _tmp90_;
					_tmp91_ = _tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_];
					_tmp92_ = self->priv->y_gap;
					self->priv->y_gap = _tmp92_ + 1;
				}
			}
		}
	}
	_tmp93_ = game_get_tiles (self, &_tmp93__length1, &_tmp93__length2);
	_tmp94_ = _tmp93_;
	_tmp94__length1 = _tmp93__length1;
	_tmp94__length2 = _tmp93__length2;
	_tmp95_ = self->priv->x_gap;
	_tmp96_ = self->priv->y_gap;
	_tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_] = -1;
	_tmp97_ = _tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_];
	_tmp98_ = move_x_axis;
	_tmp99_ = move_number;
	_tmp100_ = self->priv->x_gap;
	_tmp101_ = self->priv->y_gap;
	g_signal_emit_by_name (self, "move", _tmp98_, _tmp99_, _tmp100_, _tmp101_);
	game_check_complete (self);
}


static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean move_x_axis = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint new_coord = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp122_ = FALSE;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gint _tmp139_ = 0;
	gboolean _tmp140_ = FALSE;
	gint _tmp143_ = 0;
	gboolean _tmp144_ = FALSE;
	gboolean _tmp147_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp4_ = x;
		_tmp5_ = self->priv->_size;
		_tmp2_ = _tmp4_ < _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp6_ = 0;
		_tmp6_ = y;
		_tmp1_ = _tmp6_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = y;
		_tmp8_ = self->priv->_size;
		_tmp0_ = _tmp7_ < _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	move_x_axis = FALSE;
	_tmp10_ = x;
	if (_tmp10_ < 0) {
		_tmp9_ = TRUE;
	} else {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp11_ = x;
		_tmp12_ = self->priv->_size;
		_tmp9_ = _tmp11_ >= _tmp12_;
	}
	if (_tmp9_) {
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		_tmp14_ = y;
		if (_tmp14_ < 0) {
			_tmp13_ = TRUE;
		} else {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_tmp15_ = y;
			_tmp16_ = self->priv->_size;
			_tmp13_ = _tmp15_ >= _tmp16_;
		}
		if (_tmp13_) {
			return;
		} else {
			move_x_axis = TRUE;
		}
	} else {
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
		_tmp18_ = y;
		if (_tmp18_ >= 0) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp19_ = y;
			_tmp20_ = self->priv->_size;
			_tmp17_ = _tmp19_ < _tmp20_;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			return;
		}
	}
	new_coord = 0;
	_tmp21_ = move_x_axis;
	if (_tmp21_) {
		gint _tmp22_ = 0;
		_tmp22_ = x;
		if (_tmp22_ < 0) {
			gint tmp = 0;
			gint* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gint _tmp23__length2 = 0;
			gint* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gint _tmp24__length2 = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp41__length2 = 0;
			gint* _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gint _tmp42__length2 = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			_tmp23_ = game_get_tiles (self, &_tmp23__length1, &_tmp23__length2);
			_tmp24_ = _tmp23_;
			_tmp24__length1 = _tmp23__length1;
			_tmp24__length2 = _tmp23__length2;
			_tmp25_ = y;
			_tmp26_ = _tmp24_[(0 * _tmp24__length2) + _tmp25_];
			tmp = _tmp26_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						gint _tmp29_ = 0;
						gint _tmp30_ = 0;
						gint* _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp31__length2 = 0;
						gint* _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp32__length2 = 0;
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gint* _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp35__length2 = 0;
						gint* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp36__length2 = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						if (!_tmp27_) {
							gint _tmp28_ = 0;
							_tmp28_ = i;
							i = _tmp28_ + 1;
						}
						_tmp27_ = FALSE;
						_tmp29_ = i;
						_tmp30_ = self->priv->_size;
						if (!(_tmp29_ < (_tmp30_ - 1))) {
							break;
						}
						_tmp31_ = game_get_tiles (self, &_tmp31__length1, &_tmp31__length2);
						_tmp32_ = _tmp31_;
						_tmp32__length1 = _tmp31__length1;
						_tmp32__length2 = _tmp31__length2;
						_tmp33_ = i;
						_tmp34_ = y;
						_tmp35_ = game_get_tiles (self, &_tmp35__length1, &_tmp35__length2);
						_tmp36_ = _tmp35_;
						_tmp36__length1 = _tmp35__length1;
						_tmp36__length2 = _tmp35__length2;
						_tmp37_ = i;
						_tmp38_ = y;
						_tmp39_ = _tmp36_[((_tmp37_ + 1) * _tmp36__length2) + _tmp38_];
						_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = _tmp39_;
						_tmp40_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
					}
				}
			}
			_tmp41_ = game_get_tiles (self, &_tmp41__length1, &_tmp41__length2);
			_tmp42_ = _tmp41_;
			_tmp42__length1 = _tmp41__length1;
			_tmp42__length2 = _tmp41__length2;
			_tmp43_ = self->priv->_size;
			_tmp44_ = y;
			_tmp45_ = tmp;
			_tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_] = _tmp45_;
			_tmp46_ = _tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_];
			_tmp47_ = self->priv->_size;
			new_coord = _tmp47_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
			gint _tmp48__length2 = 0;
			gint* _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gint _tmp49__length2 = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint* _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			gint* _tmp68_ = NULL;
			gint _tmp68__length1 = 0;
			gint _tmp68__length2 = 0;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			_tmp48_ = game_get_tiles (self, &_tmp48__length1, &_tmp48__length2);
			_tmp49_ = _tmp48_;
			_tmp49__length1 = _tmp48__length1;
			_tmp49__length2 = _tmp48__length2;
			_tmp50_ = self->priv->_size;
			_tmp51_ = y;
			_tmp52_ = _tmp49_[((_tmp50_ - 1) * _tmp49__length2) + _tmp51_];
			tmp = _tmp52_;
			{
				gint i = 0;
				gint _tmp53_ = 0;
				_tmp53_ = self->priv->_size;
				i = _tmp53_ - 1;
				{
					gboolean _tmp54_ = FALSE;
					_tmp54_ = TRUE;
					while (TRUE) {
						gint _tmp56_ = 0;
						gint* _tmp57_ = NULL;
						gint _tmp57__length1 = 0;
						gint _tmp57__length2 = 0;
						gint* _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp58__length2 = 0;
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						gint* _tmp61_ = NULL;
						gint _tmp61__length1 = 0;
						gint _tmp61__length2 = 0;
						gint* _tmp62_ = NULL;
						gint _tmp62__length1 = 0;
						gint _tmp62__length2 = 0;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						if (!_tmp54_) {
							gint _tmp55_ = 0;
							_tmp55_ = i;
							i = _tmp55_ - 1;
						}
						_tmp54_ = FALSE;
						_tmp56_ = i;
						if (!(_tmp56_ > 0)) {
							break;
						}
						_tmp57_ = game_get_tiles (self, &_tmp57__length1, &_tmp57__length2);
						_tmp58_ = _tmp57_;
						_tmp58__length1 = _tmp57__length1;
						_tmp58__length2 = _tmp57__length2;
						_tmp59_ = i;
						_tmp60_ = y;
						_tmp61_ = game_get_tiles (self, &_tmp61__length1, &_tmp61__length2);
						_tmp62_ = _tmp61_;
						_tmp62__length1 = _tmp61__length1;
						_tmp62__length2 = _tmp61__length2;
						_tmp63_ = i;
						_tmp64_ = y;
						_tmp65_ = _tmp62_[((_tmp63_ - 1) * _tmp62__length2) + _tmp64_];
						_tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_] = _tmp65_;
						_tmp66_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
					}
				}
			}
			_tmp67_ = game_get_tiles (self, &_tmp67__length1, &_tmp67__length2);
			_tmp68_ = _tmp67_;
			_tmp68__length1 = _tmp67__length1;
			_tmp68__length2 = _tmp67__length2;
			_tmp69_ = y;
			_tmp70_ = tmp;
			_tmp68_[(0 * _tmp68__length2) + _tmp69_] = _tmp70_;
			_tmp71_ = _tmp68_[(0 * _tmp68__length2) + _tmp69_];
			new_coord = 0;
		}
	} else {
		gint _tmp72_ = 0;
		_tmp72_ = y;
		if (_tmp72_ < 0) {
			gint tmp = 0;
			gint* _tmp73_ = NULL;
			gint _tmp73__length1 = 0;
			gint _tmp73__length2 = 0;
			gint* _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gint _tmp74__length2 = 0;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gint* _tmp91_ = NULL;
			gint _tmp91__length1 = 0;
			gint _tmp91__length2 = 0;
			gint* _tmp92_ = NULL;
			gint _tmp92__length1 = 0;
			gint _tmp92__length2 = 0;
			gint _tmp93_ = 0;
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
			_tmp73_ = game_get_tiles (self, &_tmp73__length1, &_tmp73__length2);
			_tmp74_ = _tmp73_;
			_tmp74__length1 = _tmp73__length1;
			_tmp74__length2 = _tmp73__length2;
			_tmp75_ = x;
			_tmp76_ = _tmp74_[(_tmp75_ * _tmp74__length2) + 0];
			tmp = _tmp76_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp77_ = FALSE;
					_tmp77_ = TRUE;
					while (TRUE) {
						gint _tmp79_ = 0;
						gint _tmp80_ = 0;
						gint* _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						gint _tmp81__length2 = 0;
						gint* _tmp82_ = NULL;
						gint _tmp82__length1 = 0;
						gint _tmp82__length2 = 0;
						gint _tmp83_ = 0;
						gint _tmp84_ = 0;
						gint* _tmp85_ = NULL;
						gint _tmp85__length1 = 0;
						gint _tmp85__length2 = 0;
						gint* _tmp86_ = NULL;
						gint _tmp86__length1 = 0;
						gint _tmp86__length2 = 0;
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						if (!_tmp77_) {
							gint _tmp78_ = 0;
							_tmp78_ = i;
							i = _tmp78_ + 1;
						}
						_tmp77_ = FALSE;
						_tmp79_ = i;
						_tmp80_ = self->priv->_size;
						if (!(_tmp79_ < (_tmp80_ - 1))) {
							break;
						}
						_tmp81_ = game_get_tiles (self, &_tmp81__length1, &_tmp81__length2);
						_tmp82_ = _tmp81_;
						_tmp82__length1 = _tmp81__length1;
						_tmp82__length2 = _tmp81__length2;
						_tmp83_ = x;
						_tmp84_ = i;
						_tmp85_ = game_get_tiles (self, &_tmp85__length1, &_tmp85__length2);
						_tmp86_ = _tmp85_;
						_tmp86__length1 = _tmp85__length1;
						_tmp86__length2 = _tmp85__length2;
						_tmp87_ = x;
						_tmp88_ = i;
						_tmp89_ = _tmp86_[(_tmp87_ * _tmp86__length2) + (_tmp88_ + 1)];
						_tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_] = _tmp89_;
						_tmp90_ = _tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_];
					}
				}
			}
			_tmp91_ = game_get_tiles (self, &_tmp91__length1, &_tmp91__length2);
			_tmp92_ = _tmp91_;
			_tmp92__length1 = _tmp91__length1;
			_tmp92__length2 = _tmp91__length2;
			_tmp93_ = x;
			_tmp94_ = self->priv->_size;
			_tmp95_ = tmp;
			_tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)] = _tmp95_;
			_tmp96_ = _tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)];
			_tmp97_ = self->priv->_size;
			new_coord = _tmp97_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp98_ = NULL;
			gint _tmp98__length1 = 0;
			gint _tmp98__length2 = 0;
			gint* _tmp99_ = NULL;
			gint _tmp99__length1 = 0;
			gint _tmp99__length2 = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			gint _tmp102_ = 0;
			gint* _tmp117_ = NULL;
			gint _tmp117__length1 = 0;
			gint _tmp117__length2 = 0;
			gint* _tmp118_ = NULL;
			gint _tmp118__length1 = 0;
			gint _tmp118__length2 = 0;
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
			_tmp98_ = game_get_tiles (self, &_tmp98__length1, &_tmp98__length2);
			_tmp99_ = _tmp98_;
			_tmp99__length1 = _tmp98__length1;
			_tmp99__length2 = _tmp98__length2;
			_tmp100_ = x;
			_tmp101_ = self->priv->_size;
			_tmp102_ = _tmp99_[(_tmp100_ * _tmp99__length2) + (_tmp101_ - 1)];
			tmp = _tmp102_;
			{
				gint i = 0;
				gint _tmp103_ = 0;
				_tmp103_ = self->priv->_size;
				i = _tmp103_ - 1;
				{
					gboolean _tmp104_ = FALSE;
					_tmp104_ = TRUE;
					while (TRUE) {
						gint _tmp106_ = 0;
						gint* _tmp107_ = NULL;
						gint _tmp107__length1 = 0;
						gint _tmp107__length2 = 0;
						gint* _tmp108_ = NULL;
						gint _tmp108__length1 = 0;
						gint _tmp108__length2 = 0;
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
						gint* _tmp111_ = NULL;
						gint _tmp111__length1 = 0;
						gint _tmp111__length2 = 0;
						gint* _tmp112_ = NULL;
						gint _tmp112__length1 = 0;
						gint _tmp112__length2 = 0;
						gint _tmp113_ = 0;
						gint _tmp114_ = 0;
						gint _tmp115_ = 0;
						gint _tmp116_ = 0;
						if (!_tmp104_) {
							gint _tmp105_ = 0;
							_tmp105_ = i;
							i = _tmp105_ - 1;
						}
						_tmp104_ = FALSE;
						_tmp106_ = i;
						if (!(_tmp106_ > 0)) {
							break;
						}
						_tmp107_ = game_get_tiles (self, &_tmp107__length1, &_tmp107__length2);
						_tmp108_ = _tmp107_;
						_tmp108__length1 = _tmp107__length1;
						_tmp108__length2 = _tmp107__length2;
						_tmp109_ = x;
						_tmp110_ = i;
						_tmp111_ = game_get_tiles (self, &_tmp111__length1, &_tmp111__length2);
						_tmp112_ = _tmp111_;
						_tmp112__length1 = _tmp111__length1;
						_tmp112__length2 = _tmp111__length2;
						_tmp113_ = x;
						_tmp114_ = i;
						_tmp115_ = _tmp112_[(_tmp113_ * _tmp112__length2) + (_tmp114_ - 1)];
						_tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_] = _tmp115_;
						_tmp116_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
					}
				}
			}
			_tmp117_ = game_get_tiles (self, &_tmp117__length1, &_tmp117__length2);
			_tmp118_ = _tmp117_;
			_tmp118__length1 = _tmp117__length1;
			_tmp118__length2 = _tmp117__length2;
			_tmp119_ = x;
			_tmp120_ = tmp;
			_tmp118_[(_tmp119_ * _tmp118__length2) + 0] = _tmp120_;
			_tmp121_ = _tmp118_[(_tmp119_ * _tmp118__length2) + 0];
			new_coord = 0;
		}
	}
	_tmp122_ = undoing;
	if (!_tmp122_) {
		gint _tmp123_ = 0;
		gboolean _tmp124_ = FALSE;
		gint _tmp129_ = 0;
		gboolean _tmp130_ = FALSE;
		_tmp124_ = move_x_axis;
		if (_tmp124_) {
			gint _tmp125_ = 0;
			gint _tmp126_ = 0;
			_tmp126_ = new_coord;
			if (_tmp126_ == 0) {
				_tmp125_ = -1;
			} else {
				gint _tmp127_ = 0;
				_tmp127_ = self->priv->_size;
				_tmp125_ = _tmp127_;
			}
			_tmp123_ = _tmp125_;
		} else {
			gint _tmp128_ = 0;
			_tmp128_ = x;
			_tmp123_ = _tmp128_;
		}
		_tmp130_ = move_x_axis;
		if (_tmp130_) {
			gint _tmp131_ = 0;
			_tmp131_ = y;
			_tmp129_ = _tmp131_;
		} else {
			gint _tmp132_ = 0;
			gint _tmp133_ = 0;
			_tmp133_ = new_coord;
			if (_tmp133_ == 0) {
				_tmp132_ = -1;
			} else {
				gint _tmp134_ = 0;
				_tmp134_ = self->priv->_size;
				_tmp132_ = _tmp134_;
			}
			_tmp129_ = _tmp132_;
		}
		game_add_move (self, _tmp123_, _tmp129_);
	}
	_tmp136_ = new_coord;
	if (_tmp136_ == 0) {
		gint _tmp137_ = 0;
		_tmp137_ = self->priv->_size;
		_tmp135_ = _tmp137_ - 1;
	} else {
		gint _tmp138_ = 0;
		_tmp138_ = self->priv->_size;
		_tmp135_ = 1 - _tmp138_;
	}
	_tmp140_ = move_x_axis;
	if (_tmp140_) {
		gint _tmp141_ = 0;
		_tmp141_ = new_coord;
		_tmp139_ = _tmp141_;
	} else {
		gint _tmp142_ = 0;
		_tmp142_ = x;
		_tmp139_ = _tmp142_;
	}
	_tmp144_ = move_x_axis;
	if (_tmp144_) {
		gint _tmp145_ = 0;
		_tmp145_ = y;
		_tmp143_ = _tmp145_;
	} else {
		gint _tmp146_ = 0;
		_tmp146_ = new_coord;
		_tmp143_ = _tmp146_;
	}
	_tmp147_ = move_x_axis;
	g_signal_emit_by_name (self, "move", _tmp147_, _tmp135_, _tmp139_, _tmp143_);
	game_check_complete (self);
}


static void game_check_complete (Game* self) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp7__length2 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_size;
				_tmp4_ = self->priv->_size;
				if (!(_tmp2_ < (_tmp3_ * _tmp4_))) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = game_get_tiles (self, &_tmp6__length1, &_tmp6__length2);
				_tmp7_ = _tmp6_;
				_tmp7__length1 = _tmp6__length1;
				_tmp7__length2 = _tmp6__length2;
				_tmp8_ = i;
				_tmp9_ = self->priv->_size;
				_tmp10_ = i;
				_tmp11_ = self->priv->_size;
				_tmp12_ = _tmp7_[((_tmp8_ % _tmp9_) * _tmp7__length2) + (_tmp10_ / _tmp11_)];
				if (_tmp5_ != _tmp12_) {
					return;
				}
			}
		}
	}
	g_signal_emit_by_name (self, "complete");
}


static gpointer _game_undo_item_dup0 (gpointer self) {
	return self ? game_undo_item_dup (self) : NULL;
}


void game_undo (Game* self) {
	GameUndoItem* _tmp0_ = NULL;
	GameType _tmp1_ = 0;
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
	GameUndoItem* _tmp12_ = NULL;
	GameUndoItem* _tmp13_ = NULL;
	GameUndoItem* _tmp16_ = NULL;
	GameUndoItem* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_game_type;
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
		GameUndoItem* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GameUndoItem* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp2_ = self->priv->state;
		_tmp3_ = (*_tmp2_).x;
		_tmp4_ = self->priv->state;
		_tmp5_ = (*_tmp4_).y;
		game_fifteen_move (self, _tmp3_, _tmp5_, TRUE);
	} else {
		GameUndoItem* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GameUndoItem* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp6_ = self->priv->state;
		_tmp7_ = (*_tmp6_).x;
		_tmp8_ = self->priv->state;
		_tmp9_ = (*_tmp8_).y;
		game_sixteen_move (self, _tmp7_, _tmp9_, TRUE);
	}
	_tmp10_ = self->priv->previous_state;
	_tmp11_ = _game_undo_item_dup0 (_tmp10_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp11_;
	_tmp13_ = self->priv->state;
	if (_tmp13_ == NULL) {
		_tmp12_ = NULL;
	} else {
		GameUndoItem* _tmp14_ = NULL;
		GameUndoItem* _tmp15_ = NULL;
		_tmp14_ = self->priv->state;
		_tmp15_ = (*_tmp14_).previous;
		_tmp12_ = _tmp15_;
	}
	_tmp16_ = _game_undo_item_dup0 (_tmp12_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp16_;
	_tmp17_ = self->priv->state;
	if (_tmp17_ == NULL) {
		g_signal_emit_by_name (self, "cannot-undo-more");
	}
}


static void game_add_move (Game* self, gint x_gap, gint y_gap) {
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GameUndoItem* _tmp6_ = NULL;
	GameUndoItem* _tmp7_ = NULL;
	GameUndoItem _tmp8_ = {0};
	GameUndoItem _tmp9_ = {0};
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == NULL) {
		_tmp0_ = NULL;
	} else {
		GameUndoItem* _tmp2_ = NULL;
		_tmp2_ = self->priv->state;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp3_;
	_tmp4_ = x_gap;
	_tmp5_ = y_gap;
	_tmp6_ = self->priv->previous_state;
	_tmp7_ = _game_undo_item_dup0 (_tmp6_);
	memset (&_tmp8_, 0, sizeof (GameUndoItem));
	_tmp8_.x = _tmp4_;
	_tmp8_.y = _tmp5_;
	_game_undo_item_free0 (_tmp8_.next);
	_tmp8_.next = NULL;
	_game_undo_item_free0 (_tmp8_.previous);
	_tmp8_.previous = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = _game_undo_item_dup0 (&_tmp9_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp10_;
	game_undo_item_destroy (&_tmp9_);
	_tmp11_ = self->priv->previous_state;
	if (_tmp11_ != NULL) {
		GameUndoItem* _tmp12_ = NULL;
		GameUndoItem* _tmp13_ = NULL;
		GameUndoItem* _tmp14_ = NULL;
		_tmp12_ = self->priv->previous_state;
		_tmp13_ = self->priv->state;
		_tmp14_ = _game_undo_item_dup0 (_tmp13_);
		_game_undo_item_free0 ((*_tmp12_).next);
		(*_tmp12_).next = _tmp14_;
	}
}


gint* game_get_tiles (Game* self, int* result_length1, int* result_length2) {
	gint* result;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tiles;
	_tmp0__length1 = self->priv->_tiles_length1;
	_tmp0__length2 = self->priv->_tiles_length2;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp1__length2;
	}
	result = _tmp1_;
	return result;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp0__length2 = value_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	self->priv->_tiles = _tmp1_;
	self->priv->_tiles_length1 = _tmp1__length1;
	self->priv->_tiles_length2 = _tmp1__length2;
}


gint game_get_size (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static void game_set_size (Game* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_size = _tmp0_;
	g_object_notify ((GObject *) self, "size");
}


GameType game_get_game_type (Game* self) {
	GameType result;
	GameType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_game_type;
	result = _tmp0_;
	return result;
}


static void game_set_game_type (Game* self, GameType value) {
	GameType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_game_type = _tmp0_;
	g_object_notify ((GObject *) self, "game-type");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (gpointer data1, gboolean arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameUndoItem* _tmp2_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	GameUndoItem* _tmp4_ = NULL;
	GameUndoItem* _tmp5_ = NULL;
	_tmp0_ = (*self).x;
	(*dest).x = _tmp0_;
	_tmp1_ = (*self).y;
	(*dest).y = _tmp1_;
	_tmp2_ = (*self).next;
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
	_game_undo_item_free0 ((*dest).next);
	(*dest).next = _tmp3_;
	_tmp4_ = (*self).previous;
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
	_game_undo_item_free0 ((*dest).previous);
	(*dest).previous = _tmp5_;
}


static void game_undo_item_destroy (GameUndoItem* self) {
	_game_undo_item_free0 ((*self).next);
	_game_undo_item_free0 ((*self).previous);
}


static GameUndoItem* game_undo_item_dup (const GameUndoItem* self) {
	GameUndoItem* dup;
	dup = g_new0 (GameUndoItem, 1);
	game_undo_item_copy (self, dup);
	return dup;
}


static void game_undo_item_free (GameUndoItem* self) {
	game_undo_item_destroy (self);
	g_free (self);
}


static GType game_undo_item_get_type (void) {
	static volatile gsize game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&game_undo_item_type_id__volatile)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
		g_once_init_leave (&game_undo_item_type_id__volatile, game_undo_item_type_id);
	}
	return game_undo_item_type_id__volatile;
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE, g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("empty_tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cannot_move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("cannot_undo_more", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->state = NULL;
	self->priv->previous_state = NULL;
	self->priv->x_gap = 0;
	self->priv->y_gap = 0;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	_game_undo_item_free0 (self->priv->state);
	_game_undo_item_free0 (self->priv->previous_state);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE:
		g_value_set_int (value, game_get_size (self));
		break;
		case GAME_GAME_TYPE:
		g_value_set_enum (value, game_get_game_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE:
		game_set_size (self, g_value_get_int (value));
		break;
		case GAME_GAME_TYPE:
		game_set_game_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



