/* game-window.c generated by valac 0.27.1.22-4ade8, the Vala compiler
 * generated from game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2015 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of a GNOME game.
 *
 * This application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This application is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this application. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	gboolean tiled_state;
	gboolean maximized_state;
	gint window_width;
	gint window_height;
	gboolean game_finished;
	GtkHeaderBar* headerbar;
	GtkStack* stack;
	GtkButton* new_game_button;
	GtkButton* start_game_button;
	GtkButton* back_button;
	GtkBox* controls_box;
	GtkBox* game_box;
	GtkBox* new_game_box;
	GtkBox* side_box;
	GtkWidget* view;
	GSimpleAction* back_action;
};


static gpointer game_window_parent_class = NULL;

GType game_window_flags_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
#define GAME_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_WINDOW, GameWindowPrivate))
enum  {
	GAME_WINDOW_DUMMY_PROPERTY
};
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_start_game_cb (GameWindow* self);
static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_back_cb (GameWindow* self);
static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_redo_cb (GameWindow* self);
static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void game_window_hint_cb (GameWindow* self);
static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GameWindow* game_window_new (const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
static void game_window_size_allocate_cb (GameWindow* self, GtkAllocation* allocation);
static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean game_window_window_state_event_cb (GameWindow* self, GdkEventWindowState* event);
static gboolean _game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void game_window_show_view (GameWindow* self);
static void game_window_show_new_game_screen (GameWindow* self);
void game_window_save_state (GameWindow* self, GSettings* settings);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
void game_window_cannot_undo_more (GameWindow* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void game_window_finalize (GObject* obj);

static const GActionEntry GAME_WINDOW_win_actions[6] = {{"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"start-game", _game_window_start_game_cb_gsimple_action_activate_callback}, {"back", _game_window_back_cb_gsimple_action_activate_callback}, {"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"redo", _game_window_redo_cb_gsimple_action_activate_callback}, {"hint", _game_window_hint_cb_gsimple_action_activate_callback}};

GType game_window_flags_get_type (void) {
	static volatile gsize game_window_flags_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{GAME_WINDOW_FLAGS_SHOW_UNDO, "GAME_WINDOW_FLAGS_SHOW_UNDO", "show-undo"}, {GAME_WINDOW_FLAGS_SHOW_REDO, "GAME_WINDOW_FLAGS_SHOW_REDO", "show-redo"}, {GAME_WINDOW_FLAGS_SHOW_HINT, "GAME_WINDOW_FLAGS_SHOW_HINT", "show-hint"}, {0, NULL, NULL}};
		GType game_window_flags_type_id;
		game_window_flags_type_id = g_flags_register_static ("GameWindowFlags", values);
		g_once_init_leave (&game_window_flags_type_id__volatile, game_window_flags_type_id);
	}
	return game_window_flags_type_id__volatile;
}


static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_new_game_cb ((GameWindow*) self);
#line 139 "game-window.c"
}


static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_start_game_cb ((GameWindow*) self);
#line 146 "game-window.c"
}


static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_back_cb ((GameWindow*) self);
#line 153 "game-window.c"
}


static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_undo_cb ((GameWindow*) self);
#line 160 "game-window.c"
}


static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_redo_cb ((GameWindow*) self);
#line 167 "game-window.c"
}


static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_hint_cb ((GameWindow*) self);
#line 174 "game-window.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 181 "game-window.c"
}


static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_size_allocate_cb ((GameWindow*) self, allocation);
#line 188 "game-window.c"
}


static gboolean _game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = game_window_window_state_event_cb ((GameWindow*) self, event);
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	return result;
#line 197 "game-window.c"
}


GameWindow* game_window_construct (GType object_type, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view) {
	GameWindow * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkHeaderBar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	GtkBox* _tmp17_ = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkWidget* _tmp20_ = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	GtkWidget* _tmp23_ = NULL;
	GtkWidget* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GameWindowFlags _tmp26_ = 0;
	gboolean _tmp40_ = FALSE;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_val_if_fail (new_game_screen != NULL, NULL);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_val_if_fail (_view != NULL, NULL);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self = (GameWindow*) g_object_new (object_type, NULL);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = _view;
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->view);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->view = _tmp1_;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GAME_WINDOW_win_actions, G_N_ELEMENTS (GAME_WINDOW_win_actions), self);
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->back_action);
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->back_action = _tmp3_;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->undo_action);
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->undo_action = _tmp5_;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_simple_action_get_type (), GSimpleAction));
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->redo_action);
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->redo_action = _tmp7_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp8_ = self->priv->back_action;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp9_ = self->undo_action;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp9_, FALSE);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp10_ = self->redo_action;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp10_, FALSE);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp11_ = name;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp11_);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp12_ = self->priv->headerbar;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp13_ = name;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_header_bar_set_title (_tmp12_, _tmp13_);
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp14_ = width;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp15_ = height;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp14_, _tmp15_);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp16_ = maximized;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp16_) {
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 307 "game-window.c"
	}
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_window_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _game_window_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp17_ = self->priv->new_game_box;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp18_ = new_game_screen;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp19_ = self->priv->game_box;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp20_ = self->priv->view;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_box_pack_start (_tmp19_, _tmp20_, TRUE, TRUE, (guint) 0);
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp21_ = self->priv->game_box;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp22_ = self->priv->view;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_container_set_focus_child ((GtkContainer*) _tmp21_, _tmp22_);
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp23_ = self->priv->view;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_set_halign (_tmp23_, GTK_ALIGN_FILL);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp24_ = self->priv->view;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_object_set (_tmp24_, "can-focus", TRUE, NULL);
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp25_ = self->priv->view;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_show (_tmp25_);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp26_ = flags;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if ((_tmp26_ & GAME_WINDOW_FLAGS_SHOW_UNDO) == GAME_WINDOW_FLAGS_SHOW_UNDO) {
#line 347 "game-window.c"
		GtkBox* history_box = NULL;
		GtkBox* _tmp27_ = NULL;
		GtkBox* _tmp28_ = NULL;
		GtkStyleContext* _tmp29_ = NULL;
		GtkButton* undo_button = NULL;
		GtkButton* _tmp30_ = NULL;
		GtkButton* _tmp31_ = NULL;
		GtkButton* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GtkButton* _tmp34_ = NULL;
		GtkBox* _tmp35_ = NULL;
		GtkButton* _tmp36_ = NULL;
		GtkBox* _tmp37_ = NULL;
		GtkBox* _tmp38_ = NULL;
		GtkBox* _tmp39_ = NULL;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		g_object_ref_sink (_tmp27_);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		history_box = _tmp27_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp28_ = history_box;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) _tmp28_);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_style_context_add_class (_tmp29_, "linked");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp30_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		g_object_ref_sink (_tmp30_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		undo_button = _tmp30_;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp31_ = undo_button;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_actionable_set_action_name ((GtkActionable*) _tmp31_, "win.undo");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp32_ = undo_button;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp33_ = _ ("Undo your most recent move");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp32_, _tmp33_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp34_ = undo_button;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp34_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp35_ = history_box;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp36_ = undo_button;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, TRUE, TRUE, (guint) 0);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp37_ = history_box;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_show ((GtkWidget*) _tmp37_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp38_ = self->priv->controls_box;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp39_ = history_box;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_g_object_unref0 (undo_button);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_g_object_unref0 (history_box);
#line 415 "game-window.c"
	}
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp40_ = start_now;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp40_) {
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		game_window_show_view (self);
#line 423 "game-window.c"
	} else {
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		game_window_show_new_game_screen (self);
#line 427 "game-window.c"
	}
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	return self;
#line 431 "game-window.c"
}


GameWindow* game_window_new (const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view) {
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	return game_window_construct (TYPE_GAME_WINDOW, name, width, height, maximized, start_now, flags, new_game_screen, _view);
#line 438 "game-window.c"
}


static void game_window_size_allocate_cb (GameWindow* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (allocation != NULL);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = self->priv->maximized_state;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp1_) {
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp0_ = TRUE;
#line 459 "game-window.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp2_ = self->priv->tiled_state;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp0_ = _tmp2_;
#line 466 "game-window.c"
	}
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp0_) {
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 472 "game-window.c"
	}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = *allocation;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = _tmp3_.width;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->window_width = _tmp4_;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = *allocation;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp6_ = _tmp5_.height;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->window_height = _tmp6_;
#line 486 "game-window.c"
}


static gboolean game_window_window_state_event_cb (GameWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = event;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 506 "game-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp2_ = event;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		self->priv->maximized_state = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 515 "game-window.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = event;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 523 "game-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp6_ = event;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		self->priv->tiled_state = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 532 "game-window.c"
	}
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	result = FALSE;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	return result;
#line 538 "game-window.c"
}


void game_window_save_state (GameWindow* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (settings != NULL);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = settings;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = self->priv->window_width;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = settings;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = self->priv->window_height;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = settings;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = self->priv->maximized_state;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 571 "game-window.c"
}


void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget) {
	GtkBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (widget != NULL);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->side_box;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = widget;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_box_pack_start (_tmp0_, _tmp1_, FALSE, FALSE, (guint) 0);
#line 588 "game-window.c"
}


void game_window_cannot_undo_more (GameWindow* self) {
	GSimpleAction* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->undo_action;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = self->priv->view;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_grab_focus (_tmp1_);
#line 605 "game-window.c"
}


void game_window_set_subtitle (GameWindow* self, const gchar* subtitle) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = subtitle;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_header_bar_set_subtitle (_tmp0_, _tmp1_);
#line 620 "game-window.c"
}


void game_window_finish_game (GameWindow* self) {
	GtkButton* _tmp0_ = NULL;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->game_finished = TRUE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->new_game_button;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 634 "game-window.c"
}


static void game_window_show_new_game_screen (GameWindow* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = self->priv->stack;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_visible_child_name (_tmp1_, "start-box");
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->controls_box;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = self->priv->game_finished;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (!_tmp4_) {
#line 662 "game-window.c"
		GtkButton* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp5_ = self->priv->back_button;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp7_ = _tmp6_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp3_ = _tmp7_;
#line 674 "game-window.c"
	} else {
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp3_ = FALSE;
#line 678 "game-window.c"
	}
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp3_) {
#line 682 "game-window.c"
		GtkButton* _tmp8_ = NULL;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp8_ = self->priv->back_button;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 688 "game-window.c"
	} else {
		GtkButton* _tmp9_ = NULL;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp9_ = self->priv->start_game_button;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
#line 695 "game-window.c"
	}
}


static void game_window_show_view (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = self->priv->back_button;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->controls_box;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = self->priv->game_finished;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp3_) {
#line 723 "game-window.c"
		GtkButton* _tmp4_ = NULL;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp4_ = self->priv->new_game_button;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 729 "game-window.c"
	} else {
		GtkWidget* _tmp5_ = NULL;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 736 "game-window.c"
	}
}


static void game_window_new_game_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 758 "game-window.c"
	}
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "wait");
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->stack;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = self->priv->stack;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = self->priv->back_button;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = self->priv->back_action;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp5_, TRUE);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_show_new_game_screen (self);
#line 780 "game-window.c"
}


static void game_window_start_game_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 801 "game-window.c"
	}
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->undo_action;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = self->redo_action;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "play");
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = self->priv->stack;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp5_ = self->priv->stack;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp5_, (guint) 1000);
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_show_view (self);
#line 825 "game-window.c"
}


static void game_window_back_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 844 "game-window.c"
	}
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->stack;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp3_ = self->priv->stack;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_show_view (self);
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "back");
#line 858 "game-window.c"
}


static void game_window_undo_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 879 "game-window.c"
	}
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->new_game_button;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = _tmp3_;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp4_) {
#line 891 "game-window.c"
		GtkWidget* _tmp5_ = NULL;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 897 "game-window.c"
	}
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp6_ = self->redo_action;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "undo");
#line 905 "game-window.c"
}


static void game_window_redo_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 926 "game-window.c"
	}
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp2_ = self->priv->new_game_button;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp4_ = _tmp3_;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (_tmp4_) {
#line 936 "game-window.c"
		GtkWidget* _tmp5_ = NULL;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		_tmp5_ = self->priv->view;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		gtk_widget_grab_focus (_tmp5_);
#line 942 "game-window.c"
	}
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp6_ = self->undo_action;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "redo");
#line 950 "game-window.c"
}


static void game_window_hint_cb (GameWindow* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_return_if_fail (self != NULL);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp0_ = self->priv->stack;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
		return;
#line 967 "game-window.c"
	}
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_emit_by_name (self, "hint");
#line 971 "game-window.c"
}


static void game_window_class_init (GameWindowClass * klass) {
	gint GameWindow_private_offset;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	game_window_parent_class = g_type_class_peek_parent (klass);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_type_class_add_private (klass, sizeof (GameWindowPrivate));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	GameWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/taquin/ui/game-window.ui");
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("play", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("wait", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("back", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("undo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("redo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	g_signal_new ("hint", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, stack));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_button));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, start_game_button));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, back_button));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, controls_box));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, game_box));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_box));
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "side_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, side_box));
#line 1017 "game-window.c"
}


static void game_window_instance_init (GameWindow * self) {
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv = GAME_WINDOW_GET_PRIVATE (self);
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self->priv->game_finished = FALSE;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1028 "game-window.c"
}


static void game_window_finalize (GObject* obj) {
	GameWindow * self;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->stack);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->start_game_button);
#line 52 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->back_button);
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->controls_box);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->game_box);
#line 59 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->new_game_box);
#line 61 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->side_box);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->view);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->priv->back_action);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->undo_action);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	_g_object_unref0 (self->redo_action);
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/game-window.vala"
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
#line 1064 "game-window.c"
}


GType game_window_get_type (void) {
	static volatile gsize game_window_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
		GType game_window_type_id;
		game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
		g_once_init_leave (&game_window_type_id__volatile, game_window_type_id);
	}
	return game_window_type_id__volatile;
}



