/* sudoku-generator.c generated by valac 0.32.0.59-edc5, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUDOKU_GENERATOR_TYPE_WORKER (sudoku_generator_worker_get_type ())
#define SUDOKU_GENERATOR_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker))
#define SUDOKU_GENERATOR_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))
#define SUDOKU_GENERATOR_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))

typedef struct _SudokuGeneratorWorker SudokuGeneratorWorker;
typedef struct _SudokuGeneratorWorkerClass SudokuGeneratorWorkerClass;
typedef struct _Block1Data Block1Data;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;
typedef struct _SudokuGeneratorWorkerPrivate SudokuGeneratorWorkerPrivate;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _Block1Data {
	int _ref_count_;
	GThreadPool* pool;
	gpointer _async_data_;
};

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint nboards;
	DifficultyCategory category;
	GCancellable* cancellable;
	GeeList* result;
	Block1Data* _data1_;
	GeeArrayList* boards;
	GeeArrayList* _tmp0_;
	guint _tmp1_;
	GThreadPool* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GThreadPool* _tmp9_;
	gint _tmp10_;
	DifficultyCategory _tmp11_;
	GeeArrayList* _tmp12_;
	SudokuGeneratorWorker* _tmp13_;
	GCancellable* _tmp14_;
	GError * _inner_error_;
};

struct _SudokuGeneratorWorker {
	GObject parent_instance;
	SudokuGeneratorWorkerPrivate * priv;
};

struct _SudokuGeneratorWorkerClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorWorkerPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};


static gpointer sudoku_generator_parent_class = NULL;
static gpointer sudoku_generator_worker_parent_class = NULL;
static GMutex sudoku_generator_worker_mutex;
static GMutex sudoku_generator_worker_mutex = {0};

GType sudoku_generator_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
static SudokuGenerator* sudoku_generator_new (void);
static SudokuGenerator* sudoku_generator_construct (GType object_type);
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
static SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static GType sudoku_generator_worker_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (SudokuGeneratorWorker* worker);
static void sudoku_generator_worker_run (SudokuGeneratorWorker* self);
static void ___lambda5__gfunc (gpointer data, gpointer self);
static void ___lambda6_ (Block1Data* _data1_);
static void ____lambda6__gfunc (gconstpointer data, gpointer self);
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);
#define SUDOKU_GENERATOR_WORKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerPrivate))
enum  {
	SUDOKU_GENERATOR_WORKER_DUMMY_PROPERTY
};
static gboolean ___lambda4_ (SudokuGeneratorWorker* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void sudoku_generator_worker_finalize (GObject* obj);


static SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 198 "sudoku-generator.c"
}


static SudokuGenerator* sudoku_generator_new (void) {
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
#line 205 "sudoku-generator.c"
}


static SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint* puzzle = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint* _tmp7_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	DifficultyCategory _tmp8_ = 0;
	SudokuBoard* _tmp35_ = NULL;
	DifficultyCategory _tmp36_ = 0;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp0_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = board;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = sudoku_board_get_rows (_tmp1_);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _tmp2_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = g_new0 (gint, _tmp3_ * _tmp6_);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp7_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp3_ * _tmp6_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = category;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp8_ != DIFFICULTY_CATEGORY_CUSTOM) {
#line 254 "sudoku-generator.c"
		DifficultyCategory _tmp9_ = 0;
		gint* _tmp10_ = NULL;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp9_ = category;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp10_ = qqwing_generate_puzzle ((gint) _tmp9_);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle = (g_free (puzzle), NULL);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle = _tmp10_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		puzzle_length1 = -1;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_puzzle_size_ = puzzle_length1;
#line 269 "sudoku-generator.c"
	}
	{
		gint row = 0;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 275 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 282 "sudoku-generator.c"
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 289 "sudoku-generator.c"
					gint _tmp12_ = 0;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 295 "sudoku-generator.c"
				}
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 311 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 317 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 324 "sudoku-generator.c"
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint val = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 341 "sudoku-generator.c"
								gint _tmp18_ = 0;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 347 "sudoku-generator.c"
							}
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 363 "sudoku-generator.c"
							}
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							val = _tmp29_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = val;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (_tmp30_ != 0) {
#line 387 "sudoku-generator.c"
								SudokuBoard* _tmp31_ = NULL;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp31_ = board;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp32_ = row;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp33_ = col;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp34_ = val;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								sudoku_board_insert (_tmp31_, _tmp32_, _tmp33_, _tmp34_, TRUE);
#line 402 "sudoku-generator.c"
							}
						}
					}
				}
			}
		}
	}
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp35_ = board;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp36_ = category;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_set_difficulty_category (_tmp35_, _tmp36_);
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = board;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 422 "sudoku-generator.c"
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->result);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
#line 435 "sudoku-generator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_object_ref (self) : NULL;
#line 442 "sudoku-generator.c"
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, sudoku_generator_generate_boards_async);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nboards;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->nboards = _tmp0_;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = category;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->category = _tmp1_;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = cancellable;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->cancellable = _tmp3_;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_boards_async_co (_data_);
#line 476 "sudoku-generator.c"
}


GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error) {
	GeeList* result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		return NULL;
#line 487 "sudoku-generator.c"
	}
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = _data_->result;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = NULL;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 497 "sudoku-generator.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return _data1_;
#line 506 "sudoku-generator.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_g_thread_pool_free0 (_data1_->pool);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_slice_free (Block1Data, _data1_);
#line 519 "sudoku-generator.c"
	}
}


static void __lambda5_ (SudokuGeneratorWorker* worker) {
	SudokuGeneratorWorker* _tmp0_ = NULL;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (worker != NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = worker;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_run (_tmp0_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (worker);
#line 534 "sudoku-generator.c"
}


static void ___lambda5__gfunc (gpointer data, gpointer self) {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	__lambda5_ ((SudokuGeneratorWorker*) data);
#line 541 "sudoku-generator.c"
}


static void vala__g_thread_pool_free_wrapper (GThreadPool* pool, gboolean immediate, gboolean wait) {
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_ = NULL;
	GThreadPool* _tmp1_ = NULL;
#line 2050 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = pool;
#line 2050 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	pool = NULL;
#line 2050 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	ptr = _tmp0_;
#line 2051 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ptr;
#line 2051 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 559 "sudoku-generator.c"
		GThreadPool* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 2052 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = ptr;
#line 2052 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = immediate;
#line 2052 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = wait;
#line 2052 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		g_thread_pool_free ((GThreadPool*) _tmp2_, _tmp3_, _tmp4_);
#line 571 "sudoku-generator.c"
	}
#line 2049 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_g_thread_pool_free0 (pool);
#line 575 "sudoku-generator.c"
}


static void ___lambda6_ (Block1Data* _data1_) {
	GThreadPool* _tmp0_ = NULL;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = _data1_->pool;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data1_->pool = NULL;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	vala__g_thread_pool_free_wrapper (_tmp0_, TRUE, FALSE);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_boards_async_co (_data1_->_async_data_);
#line 589 "sudoku-generator.c"
}


static void ____lambda6__gfunc (gconstpointer data, gpointer self) {
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	___lambda6_ (self);
#line 596 "sudoku-generator.c"
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 605 "sudoku-generator.c"
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	switch (_data_->_state_) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		case 0:
#line 614 "sudoku-generator.c"
		goto _state_0;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		case 1:
#line 618 "sudoku-generator.c"
		goto _state_1;
		default:
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_assert_not_reached ();
#line 623 "sudoku-generator.c"
	}
	_state_0:
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = NULL;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards = _data_->_tmp0_;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = 0U;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = g_get_num_processors ();
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = NULL;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = g_thread_pool_new (___lambda5__gfunc, NULL, (gint) _data_->_tmp1_, FALSE, &_data_->_inner_error_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_->pool = _data_->_tmp2_;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_error_free (_data_->_inner_error_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			if (_data_->_state_ == 0) {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 666 "sudoku-generator.c"
			} else {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 670 "sudoku-generator.c"
			}
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 676 "sudoku-generator.c"
		} else {
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 690 "sudoku-generator.c"
		}
	}
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp3_ = NULL;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_tmp3_ != NULL) {
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->_tmp4_ = NULL;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->_tmp4_ = _data_->cancellable;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_cancellable_connect (_data_->_tmp4_, (GCallback) ____lambda6__gfunc, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 705 "sudoku-generator.c"
	}
	{
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->i = 0;
#line 710 "sudoku-generator.c"
		{
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp5_ = TRUE;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp5_) {
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp6_ = 0;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp6_ = _data_->i;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->i = _data_->_tmp6_ + 1;
#line 724 "sudoku-generator.c"
				}
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp5_ = FALSE;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp7_ = 0;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp7_ = _data_->i;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp8_ = 0;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp8_ = _data_->nboards;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 740 "sudoku-generator.c"
				}
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp9_ = NULL;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp9_ = _data_->_data1_->pool;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp10_ = 0;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp10_ = _data_->nboards;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp11_ = 0;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp11_ = _data_->category;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp12_ = NULL;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp12_ = _data_->boards;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp13_ = NULL;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp13_ = sudoku_generator_worker_new (_data_->_tmp10_, _data_->_tmp11_, (GeeList*) _data_->_tmp12_, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_thread_pool_push (_data_->_tmp9_, _data_->_tmp13_, &_data_->_inner_error_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_error_free (_data_->_inner_error_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						block1_data_unref (_data_->_data1_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_data_->_data1_ = NULL;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						if (_data_->_state_ == 0) {
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 782 "sudoku-generator.c"
						} else {
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 786 "sudoku-generator.c"
						}
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_object_unref (_data_->_async_result);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 792 "sudoku-generator.c"
					} else {
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						block1_data_unref (_data_->_data1_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_data_->_data1_ = NULL;
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_clear_error (&_data_->_inner_error_);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 806 "sudoku-generator.c"
					}
				}
			}
		}
	}
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_state_ = 1;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 816 "sudoku-generator.c"
	_state_1:
	;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp14_ = NULL;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp14_ = _data_->cancellable;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_cancellable_set_error_if_cancelled (_data_->_tmp14_, &_data_->_inner_error_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		if ((_data_->_inner_error_->domain == G_THREAD_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_error_free (_data_->_inner_error_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 843 "sudoku-generator.c"
			} else {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 847 "sudoku-generator.c"
			}
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 853 "sudoku-generator.c"
		} else {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			block1_data_unref (_data_->_data1_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_data1_ = NULL;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 867 "sudoku-generator.c"
		}
	}
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = (GeeList*) _data_->boards;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	block1_data_unref (_data_->_data1_);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_ = NULL;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 880 "sudoku-generator.c"
	} else {
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 884 "sudoku-generator.c"
	}
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->boards);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	block1_data_unref (_data_->_data1_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_data1_ = NULL;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 900 "sudoku-generator.c"
	} else {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 904 "sudoku-generator.c"
	}
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 910 "sudoku-generator.c"
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint cells_length1 = 0;
	gint cells_length2 = 0;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (board != NULL);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = board;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells = _tmp3_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length1 = _tmp1_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length2 = _tmp2_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = board;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp9_ = _tmp8_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp10_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp6_ * _tmp9_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 966 "sudoku-generator.c"
	{
		gint row = 0;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 971 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 978 "sudoku-generator.c"
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 985 "sudoku-generator.c"
					gint _tmp12_ = 0;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 991 "sudoku-generator.c"
				}
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1007 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 1013 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 1020 "sudoku-generator.c"
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 1041 "sudoku-generator.c"
								gint _tmp18_ = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 1047 "sudoku-generator.c"
							}
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 1063 "sudoku-generator.c"
							}
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = cells;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length1 = cells_length1;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length2 = cells_length2;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = row;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp31_ = col;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 1095 "sudoku-generator.c"
						}
					}
				}
			}
		}
	}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34_ = puzzle;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34__length1 = puzzle_length1;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	qqwing_print_stats (_tmp34_);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells = (g_free (cells), NULL);
#line 1112 "sudoku-generator.c"
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = qqwing_get_version ();
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp0_;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1125 "sudoku-generator.c"
}


static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
	SudokuGeneratorWorker * self = NULL;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	GSourceFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (boards_list != NULL, NULL);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGeneratorWorker*) g_object_new (object_type, NULL);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nsudokus;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->nsudokus = _tmp0_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = level;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->level = _tmp1_;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = boards_list;
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->boards_list = _tmp3_;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = callback;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4__target = callback_target;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = _tmp4_;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = _tmp4__target;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 1167 "sudoku-generator.c"
}


static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_worker_construct (SUDOKU_GENERATOR_TYPE_WORKER, nsudokus, level, boards_list, callback, callback_target);
#line 1174 "sudoku-generator.c"
}


static gboolean ___lambda4_ (SudokuGeneratorWorker* self) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->callback;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0__target = self->priv->callback_target;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ (_tmp0__target);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = G_SOURCE_REMOVE;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1192 "sudoku-generator.c"
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((SudokuGeneratorWorker*) self);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1201 "sudoku-generator.c"
}


static void sudoku_generator_worker_run (SudokuGeneratorWorker* self) {
	SudokuBoard* board = NULL;
	DifficultyCategory _tmp0_ = 0;
	SudokuBoard* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->level;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = sudoku_generator_generate_board (_tmp0_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp1_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_lock (&sudoku_generator_worker_mutex);
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = self->priv->boards_list;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = board;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = self->priv->boards_list;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = self->priv->nsudokus;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp6_ == _tmp7_) {
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 1243 "sudoku-generator.c"
	}
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_unlock (&sudoku_generator_worker_mutex);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (board);
#line 1249 "sudoku-generator.c"
}


static void sudoku_generator_worker_class_init (SudokuGeneratorWorkerClass * klass) {
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_type_class_add_private (klass, sizeof (SudokuGeneratorWorkerPrivate));
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_worker_finalize;
#line 1260 "sudoku-generator.c"
}


static void sudoku_generator_worker_instance_init (SudokuGeneratorWorker * self) {
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv = SUDOKU_GENERATOR_WORKER_GET_PRIVATE (self);
#line 1267 "sudoku-generator.c"
}


static void sudoku_generator_worker_finalize (GObject* obj) {
	SudokuGeneratorWorker * self;
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (sudoku_generator_worker_parent_class)->finalize (obj);
#line 1279 "sudoku-generator.c"
}


static GType sudoku_generator_worker_get_type (void) {
	static volatile gsize sudoku_generator_worker_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_worker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGeneratorWorker), 0, (GInstanceInitFunc) sudoku_generator_worker_instance_init, NULL };
		GType sudoku_generator_worker_type_id;
		sudoku_generator_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGeneratorWorker", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_worker_type_id__volatile, sudoku_generator_worker_type_id);
	}
	return sudoku_generator_worker_type_id__volatile;
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
#line 1298 "sudoku-generator.c"
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}



