/* sudoku-solver.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from sudoku-solver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_SOLVER (sudoku_solver_get_type ())
#define SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SOLVER, SudokuSolver))
#define SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SOLVER, SudokuSolverClass))
#define IS_SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SOLVER))
#define IS_SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SOLVER))
#define SUDOKU_SOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SOLVER, SudokuSolverClass))

typedef struct _SudokuSolver SudokuSolver;
typedef struct _SudokuSolverClass SudokuSolverClass;
typedef struct _SudokuSolverPrivate SudokuSolverPrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GUESS_LIST (guess_list_get_type ())
#define GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS_LIST, GuessList))
#define GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS_LIST, GuessListClass))
#define IS_GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS_LIST))
#define IS_GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS_LIST))
#define GUESS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS_LIST, GuessListClass))

typedef struct _GuessList GuessList;
typedef struct _GuessListClass GuessListClass;

#define TYPE_BREADCRUMB_TRAIL (breadcrumb_trail_get_type ())
#define BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrail))
#define BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))
#define IS_BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BREADCRUMB_TRAIL))
#define IS_BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BREADCRUMB_TRAIL))
#define BREADCRUMB_TRAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))

typedef struct _BreadcrumbTrail BreadcrumbTrail;
typedef struct _BreadcrumbTrailClass BreadcrumbTrailClass;

#define TYPE_PARALLEL_DICT (parallel_dict_get_type ())
#define PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARALLEL_DICT, ParallelDict))
#define PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARALLEL_DICT, ParallelDictClass))
#define IS_PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARALLEL_DICT))
#define IS_PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARALLEL_DICT))
#define PARALLEL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARALLEL_DICT, ParallelDictClass))

typedef struct _ParallelDict ParallelDict;
typedef struct _ParallelDictClass ParallelDictClass;

#define TYPE_GUESS (guess_get_type ())
#define GUESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS, Guess))
#define GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS, GuessClass))
#define IS_GUESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS))
#define IS_GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS))
#define GUESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS, GuessClass))

typedef struct _Guess Guess;
typedef struct _GuessClass GuessClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUDOKU_SOLVER_TYPE_ITERATOR (sudoku_solver_iterator_get_type ())
#define SUDOKU_SOLVER_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIterator))
#define SUDOKU_SOLVER_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))
#define SUDOKU_SOLVER_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))

typedef struct _SudokuSolverIterator SudokuSolverIterator;
typedef struct _SudokuSolverIteratorClass SudokuSolverIteratorClass;

#define TYPE_CELL (cell_get_type ())

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
typedef struct _Cell Cell;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;
typedef struct _GuessPrivate GuessPrivate;
typedef struct _SudokuSolverIteratorPrivate SudokuSolverIteratorPrivate;

#define TYPE_SUDOKU_RATER (sudoku_rater_get_type ())
#define SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_RATER, SudokuRater))
#define SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_RATER, SudokuRaterClass))
#define IS_SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_RATER))
#define IS_SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_RATER))
#define SUDOKU_RATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_RATER, SudokuRaterClass))

typedef struct _SudokuRater SudokuRater;
typedef struct _SudokuRaterClass SudokuRaterClass;
typedef struct _SudokuRaterPrivate SudokuRaterPrivate;
#define _cell_free0(var) ((var == NULL) ? NULL : (var = (cell_free (var), NULL)))

#define TYPE_DIFFICULTY_RATING (difficulty_rating_get_type ())
#define DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIFFICULTY_RATING, DifficultyRating))
#define DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))
#define IS_DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIFFICULTY_RATING))
#define IS_DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIFFICULTY_RATING))
#define DIFFICULTY_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))

typedef struct _DifficultyRating DifficultyRating;
typedef struct _DifficultyRatingClass DifficultyRatingClass;
typedef struct _GuessListPrivate GuessListPrivate;
typedef struct _BreadcrumbTrailPrivate BreadcrumbTrailPrivate;
typedef struct _ParallelDictPrivate ParallelDictPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _DifficultyRatingPrivate DifficultyRatingPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	SUDOKU_ERROR_UNSOLVABLE_PUZZLE,
	SUDOKU_ERROR_CONFLICT_ERROR,
	SUDOKU_ERROR_ALREADY_SET_ERROR
} SudokuError;
#define SUDOKU_ERROR sudoku_error_quark ()
struct _SudokuSolver {
	GObject parent_instance;
	SudokuSolverPrivate * priv;
	SudokuBoard* board;
	GuessList* guesses;
	BreadcrumbTrail* breadcrumbs;
	gint backtraces;
	gboolean solved;
};

struct _SudokuSolverClass {
	GObjectClass parent_class;
	gboolean (*guess_least_open_square) (SudokuSolver* self, GError** error);
	void (*insert) (SudokuSolver* self, gint row, gint col, gint val);
};

struct _SudokuSolverPrivate {
	ParallelDict* conflicts;
	Guess* current_guess;
	gboolean count_solutions;
	gint break_at;
	GeeArrayList* trail;
	GeeArrayList* trailDetails;
	gint debug_indent;
};

struct _Coord {
	gint row;
	gint col;
};

struct _Cell {
	Coord coord;
	gint val;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gdouble difficulty_rating;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

struct _Guess {
	GObject parent_instance;
	GuessPrivate * priv;
	GeeArrayList* children;
	GeeHashMap* consequences;
};

struct _GuessClass {
	GObjectClass parent_class;
};

struct _SudokuSolverIterator {
	GObject parent_instance;
	SudokuSolverIteratorPrivate * priv;
};

struct _SudokuSolverIteratorClass {
	GObjectClass parent_class;
};

struct _SudokuSolverIteratorPrivate {
	SudokuSolver* solver;
	SudokuBoard* solution;
};

struct _SudokuRater {
	SudokuSolver parent_instance;
	SudokuRaterPrivate * priv;
};

struct _SudokuRaterClass {
	SudokuSolverClass parent_class;
};

struct _SudokuRaterPrivate {
	gboolean guessing;
	gboolean fake_add;
	GeeArrayList* fake_additions;
	GeeArrayList* add_me_queue;
	GeeHashSet* filled;
	GeeHashMap* fill_must_fillables;
	GeeHashMap* elimination_fillables;
	gint tier;
};

struct _GuessPrivate {
	gint _row;
	gint _col;
	gint _val;
};

struct _GuessList {
	GeeArrayList parent_instance;
	GuessListPrivate * priv;
};

struct _GuessListClass {
	GeeArrayListClass parent_class;
};

struct _BreadcrumbTrail {
	GuessList parent_instance;
	BreadcrumbTrailPrivate * priv;
};

struct _BreadcrumbTrailClass {
	GuessListClass parent_class;
};

struct _ParallelDict {
	GObject parent_instance;
	ParallelDictPrivate * priv;
};

struct _ParallelDictClass {
	GObjectClass parent_class;
};

struct _ParallelDictPrivate {
	GeeHashMap* map;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _DifficultyRating {
	GObject parent_instance;
	DifficultyRatingPrivate * priv;
	gfloat rating;
};

struct _DifficultyRatingClass {
	GObjectClass parent_class;
};

struct _DifficultyRatingPrivate {
	GeeHashMap* fill_must_fillables;
	GeeHashMap* elimination_fillables;
	GuessList* guesses;
	gint backtraces;
	gint squares_filled;
	gfloat elimination_ease;
	gfloat fillable_ease;
	gfloat instant_fill_fillable;
	gfloat instant_elimination_fillable;
	gfloat proportion_instant_elimination_fillable;
	gfloat proportion_instant_fill_fillable;
};

typedef gint (*DifficultyRatingDiminshBy) (gint a, void* user_data);

static gpointer sudoku_solver_parent_class = NULL;
static gpointer sudoku_solver_iterator_parent_class = NULL;
static gpointer sudoku_rater_parent_class = NULL;
static gpointer guess_parent_class = NULL;
static gpointer guess_list_parent_class = NULL;
static gpointer breadcrumb_trail_parent_class = NULL;
static gpointer parallel_dict_parent_class = NULL;
static gpointer difficulty_rating_parent_class = NULL;

GQuark sudoku_error_quark (void);
GType sudoku_solver_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType guess_list_get_type (void) G_GNUC_CONST;
GType breadcrumb_trail_get_type (void) G_GNUC_CONST;
GType parallel_dict_get_type (void) G_GNUC_CONST;
GType guess_get_type (void) G_GNUC_CONST;
#define SUDOKU_SOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_SOLVER, SudokuSolverPrivate))
enum  {
	SUDOKU_SOLVER_DUMMY_PROPERTY
};
SudokuSolver* sudoku_solver_new (SudokuBoard** board);
SudokuSolver* sudoku_solver_construct (GType object_type, SudokuBoard** board);
ParallelDict* parallel_dict_new (void);
ParallelDict* parallel_dict_construct (GType object_type);
GuessList* guess_list_new (void);
GuessList* guess_list_construct (GType object_type);
BreadcrumbTrail* breadcrumb_trail_new (void);
BreadcrumbTrail* breadcrumb_trail_construct (GType object_type);
gboolean sudoku_solver_quick_has_solution (SudokuSolver* self);
static void sudoku_solver_quick_solve (SudokuSolver* self, gint row, gint col, gint no, gint filled, gint* solution);
gboolean sudoku_solver_quick_has_unique_solution (SudokuSolver* self);
gboolean sudoku_solver_quick_has_many_solution (SudokuSolver* self);
gint sudoku_solver_quick_count_solutions (SudokuSolver* self, gint break_at);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
GType sudoku_solver_iterator_get_type (void) G_GNUC_CONST;
SudokuSolverIterator* sudoku_solver_iterator (SudokuSolver* self);
SudokuSolverIterator* sudoku_solver_iterator_new (SudokuSolver* solver);
SudokuSolverIterator* sudoku_solver_iterator_construct (GType object_type, SudokuSolver* solver);
gboolean sudoku_solver_has_unique_solution (SudokuSolver* self);
gboolean sudoku_solver_iterator_next (SudokuSolverIterator* self);
SudokuBoard* sudoku_solver_solve (SudokuSolver* self);
GType cell_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
static GeeArrayList* sudoku_solver_auto_fill (SudokuSolver* self);
gboolean sudoku_solver_guess_least_open_square (SudokuSolver* self, GError** error);
GeeArrayList* sudoku_solver_fill_must_fills (SudokuSolver* self, GError** error);
GeeArrayList* sudoku_solver_fill_deterministically (SudokuSolver* self);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
void sudoku_solver_insert (SudokuSolver* self, gint row, gint col, gint val);
void cell_init (Cell *self, Coord* coord, gint val);
static GeeArrayList* sudoku_solver_fill_must_fills_for (SudokuSolver* self, GeeList* coords, GError** error);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
void coord_init (Coord *self, gint row, gint col);
gboolean parallel_dict_contains (ParallelDict* self, Coord* key);
gboolean coord_equal (Coord* a, Coord* b);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gboolean sudoku_solver_real_guess_least_open_square (SudokuSolver* self, GError** error);
Guess** guess_list_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
gint guess_get_val (Guess* self);
static void sudoku_solver_unwrap_guess (SudokuSolver* self, Guess* guess);
Guess* guess_new (gint row, gint col, gint val);
Guess* guess_construct (GType object_type, gint row, gint col, gint val);
gint guess_get_row (Guess* self);
gint guess_get_col (Guess* self);
static void sudoku_solver_real_insert (SudokuSolver* self, gint row, gint col, gint val);
void guess_add_consequence (Guess* self, gint row, gint col, gint val);
#define SUDOKU_SOLVER_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorPrivate))
enum  {
	SUDOKU_SOLVER_ITERATOR_DUMMY_PROPERTY
};
SudokuBoard* sudoku_solver_iterator_get (SudokuSolverIterator* self);
static void sudoku_solver_iterator_finalize (GObject* obj);
static void sudoku_solver_finalize (GObject* obj);
GType sudoku_rater_get_type (void) G_GNUC_CONST;
#define SUDOKU_RATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_RATER, SudokuRaterPrivate))
enum  {
	SUDOKU_RATER_DUMMY_PROPERTY
};
SudokuRater* sudoku_rater_new (SudokuBoard** board);
SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
static void sudoku_rater_real_insert (SudokuSolver* base, gint row, gint col, gint val);
static void sudoku_rater_scan_fillables (SudokuRater* self);
static gboolean sudoku_rater_real_guess_least_open_square (SudokuSolver* base, GError** error);
GType difficulty_rating_get_type (void) G_GNUC_CONST;
DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self);
DifficultyRating* difficulty_rating_new (GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
DifficultyRating* difficulty_rating_construct (GType object_type, GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
static void sudoku_rater_finalize (GObject* obj);
#define GUESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GUESS, GuessPrivate))
enum  {
	GUESS_DUMMY_PROPERTY,
	GUESS_ROW,
	GUESS_COL,
	GUESS_VAL
};
gint coord_hash (Coord* coord);
static void guess_finalize (GObject* obj);
static void _vala_guess_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	GUESS_LIST_DUMMY_PROPERTY
};
static void _vala_array_add5 (Guess*** array, int* length, int* size, Guess* value);
Guess** guess_list_remove_children (GuessList* self, Guess* guess, int* result_length1);
static void _vala_array_add6 (Guess*** array, int* length, int* size, Guess* value);
Guess** guess_list_remove_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
static void _vala_array_add7 (Guess*** array, int* length, int* size, Guess* value);
enum  {
	BREADCRUMB_TRAIL_DUMMY_PROPERTY
};
void breadcrumb_trail_append (BreadcrumbTrail* self, Guess* guess);
#define PARALLEL_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PARALLEL_DICT, ParallelDictPrivate))
enum  {
	PARALLEL_DICT_DUMMY_PROPERTY
};
void parallel_dict_set (ParallelDict* self, Coord* k, GeeHashSet* v);
static gboolean _coord_equal (const Coord* s1, const Coord* s2);
void parallel_dict_unset (ParallelDict* self, Coord* k);
static void parallel_dict_finalize (GObject* obj);
GType difficulty_category_get_type (void) G_GNUC_CONST;
gchar* difficulty_category_to_string (DifficultyCategory self);
#define DIFFICULTY_RATING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIFFICULTY_RATING, DifficultyRatingPrivate))
enum  {
	DIFFICULTY_RATING_DUMMY_PROPERTY
};
static gfloat difficulty_rating_add_with_diminishing_importance (gint* array, int array_length1, DifficultyRatingDiminshBy diminish_by, void* diminish_by_target);
static gint* difficulty_rating_count_values (DifficultyRating* self, GeeHashMap* map, int* result_length1);
static gint difficulty_rating_diminsh_by_one (gint a);
static gint _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by (gint a, gpointer self);
static gfloat difficulty_rating_calculate (DifficultyRating* self);
gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1);
DifficultyCategory difficulty_rating_get_category (DifficultyRating* self);
gchar* difficulty_rating_to_string (DifficultyRating* self);
static void difficulty_rating_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gfloat DIFFICULTY_RATING_VERY_HARD_RANGE[2] = {0.75f, (gfloat) 10};
const gfloat DIFFICULTY_RATING_HARD_RANGE[2] = {0.6f, 0.75f};
const gfloat DIFFICULTY_RATING_MEDIUM_RANGE[2] = {0.45f, 0.6f};
const gfloat DIFFICULTY_RATING_EASY_RANGE[2] = {(gfloat) (-10), 0.45f};

GQuark sudoku_error_quark (void) {
	return g_quark_from_static_string ("sudoku_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self ? g_object_ref (self) : NULL;
#line 473 "sudoku-solver.c"
}


SudokuSolver* sudoku_solver_construct (GType object_type, SudokuBoard** board) {
	SudokuSolver * self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	ParallelDict* _tmp2_ = NULL;
	GuessList* _tmp3_ = NULL;
	BreadcrumbTrail* _tmp4_ = NULL;
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (*board != NULL, NULL);
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (SudokuSolver*) g_object_new (object_type, NULL);
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = *board;
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->board);
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->board = _tmp1_;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = parallel_dict_new ();
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->conflicts);
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->conflicts = _tmp2_;
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = guess_list_new ();
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->guesses);
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->guesses = _tmp3_;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = breadcrumb_trail_new ();
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->breadcrumbs);
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->breadcrumbs = _tmp4_;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->solved = FALSE;
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 518 "sudoku-solver.c"
}


SudokuSolver* sudoku_solver_new (SudokuBoard** board) {
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return sudoku_solver_construct (TYPE_SUDOKU_SOLVER, board);
#line 525 "sudoku-solver.c"
}


gboolean sudoku_solver_quick_has_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	solutions = 0;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->count_solutions = FALSE;
#line 45 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
#line 46 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = solutions;
#line 46 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_ > 0;
#line 46 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 547 "sudoku-solver.c"
}


gboolean sudoku_solver_quick_has_unique_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
#line 49 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 52 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	solutions = 0;
#line 53 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->count_solutions = FALSE;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = solutions;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_ == 1;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 569 "sudoku-solver.c"
}


gboolean sudoku_solver_quick_has_many_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	gint solutions = 0;
	gint _tmp0_ = 0;
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	solutions = 0;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->count_solutions = FALSE;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = solutions;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_ > 1;
#line 64 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 591 "sudoku-solver.c"
}


gint sudoku_solver_quick_count_solutions (SudokuSolver* self, gint break_at) {
	gint result = 0;
	gint solutions = 0;
	gint _tmp0_ = 0;
#line 68 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	solutions = 0;
#line 71 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->count_solutions = TRUE;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = break_at;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->break_at = _tmp0_;
#line 73 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_quick_solve (self, -1, -1, -1, -1, &solutions);
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = solutions;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 615 "sudoku-solver.c"
}


static void sudoku_solver_quick_solve (SudokuSolver* self, gint row, gint col, gint no, gint filled, gint* solution) {
	gint _tmp0_ = 0;
	gint _tmp4_ = 0;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp35_ = 0;
	SudokuBoard* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	SudokuBoard* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
#line 77 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = filled;
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp0_ == (-1)) {
#line 645 "sudoku-solver.c"
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = self->board;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = _tmp2_;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		filled = _tmp3_;
#line 657 "sudoku-solver.c"
	}
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = filled;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = self->board;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = _tmp6_;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = self->board;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = sudoku_board_get_cols (_tmp8_);
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp10_ = _tmp9_;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp4_ == (_tmp7_ * _tmp10_)) {
#line 675 "sudoku-solver.c"
		gint _tmp11_ = 0;
#line 84 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp11_ = *solution;
#line 84 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*solution = _tmp11_ + 1;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return;
#line 683 "sudoku-solver.c"
	}
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp13_ = row;
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp13_ == (-1)) {
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp12_ = TRUE;
#line 691 "sudoku-solver.c"
	} else {
		gint _tmp14_ = 0;
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp14_ = col;
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp12_ = _tmp14_ == (-1);
#line 698 "sudoku-solver.c"
	}
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp12_) {
#line 702 "sudoku-solver.c"
		{
			gint l1 = 0;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			l1 = 0;
#line 707 "sudoku-solver.c"
			{
				gboolean _tmp15_ = FALSE;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp15_ = TRUE;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				while (TRUE) {
#line 714 "sudoku-solver.c"
					gint _tmp17_ = 0;
					SudokuBoard* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!_tmp15_) {
#line 721 "sudoku-solver.c"
						gint _tmp16_ = 0;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp16_ = l1;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						l1 = _tmp16_ + 1;
#line 727 "sudoku-solver.c"
					}
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp15_ = FALSE;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp17_ = l1;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp18_ = self->board;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp19_ = sudoku_board_get_rows (_tmp18_);
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp20_ = _tmp19_;
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!(_tmp17_ < _tmp20_)) {
#line 90 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						break;
#line 743 "sudoku-solver.c"
					}
					{
						gint l2 = 0;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						l2 = 0;
#line 749 "sudoku-solver.c"
						{
							gboolean _tmp21_ = FALSE;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp21_ = TRUE;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							while (TRUE) {
#line 756 "sudoku-solver.c"
								gint _tmp23_ = 0;
								SudokuBoard* _tmp24_ = NULL;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								SudokuBoard* _tmp27_ = NULL;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								if (!_tmp21_) {
#line 767 "sudoku-solver.c"
									gint _tmp22_ = 0;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp22_ = l2;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									l2 = _tmp22_ + 1;
#line 773 "sudoku-solver.c"
								}
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp21_ = FALSE;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp23_ = l2;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp24_ = self->board;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp25_ = sudoku_board_get_cols (_tmp24_);
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp26_ = _tmp25_;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								if (!(_tmp23_ < _tmp26_)) {
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									break;
#line 789 "sudoku-solver.c"
								}
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp27_ = self->board;
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp28_ = l1;
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp29_ = l2;
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp30_ = sudoku_board_get (_tmp27_, _tmp28_, _tmp29_);
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								if (_tmp30_ == 0) {
#line 801 "sudoku-solver.c"
									gint _tmp31_ = 0;
									gint _tmp32_ = 0;
									gint _tmp33_ = 0;
									gint _tmp34_ = 0;
#line 96 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp31_ = l1;
#line 96 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp32_ = l2;
#line 96 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp33_ = no;
#line 96 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp34_ = filled;
#line 96 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									sudoku_solver_quick_solve (self, _tmp31_, _tmp32_, _tmp33_, _tmp34_, solution);
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									return;
#line 818 "sudoku-solver.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp35_ = no;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp35_ == (-1)) {
#line 831 "sudoku-solver.c"
		{
			gint l1 = 0;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			l1 = 1;
#line 836 "sudoku-solver.c"
			{
				gboolean _tmp36_ = FALSE;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp36_ = TRUE;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				while (TRUE) {
#line 843 "sudoku-solver.c"
					gint _tmp38_ = 0;
					SudokuBoard* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					SudokuBoard* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gboolean _tmp46_ = FALSE;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!_tmp36_) {
#line 855 "sudoku-solver.c"
						gint _tmp37_ = 0;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp37_ = l1;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						l1 = _tmp37_ + 1;
#line 861 "sudoku-solver.c"
					}
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp36_ = FALSE;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp38_ = l1;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp39_ = self->board;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp40_ = sudoku_board_get_max_val (_tmp39_);
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp41_ = _tmp40_;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!(_tmp38_ <= _tmp41_)) {
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						break;
#line 877 "sudoku-solver.c"
					}
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp42_ = self->board;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp43_ = row;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp44_ = col;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp45_ = l1;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp46_ = sudoku_board_is_possible (_tmp42_, _tmp43_, _tmp44_, _tmp45_);
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_tmp46_) {
#line 891 "sudoku-solver.c"
						gint _tmp47_ = 0;
						gint _tmp48_ = 0;
						gint _tmp49_ = 0;
						gint _tmp50_ = 0;
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						gboolean _tmp53_ = FALSE;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp47_ = row;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp48_ = col;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp49_ = l1;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp50_ = filled;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						sudoku_solver_quick_solve (self, _tmp47_, _tmp48_, _tmp49_, _tmp50_, solution);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp53_ = self->priv->count_solutions;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (!_tmp53_) {
#line 913 "sudoku-solver.c"
							gint _tmp54_ = 0;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp54_ = *solution;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp52_ = _tmp54_ > 1;
#line 919 "sudoku-solver.c"
						} else {
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp52_ = FALSE;
#line 923 "sudoku-solver.c"
						}
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_tmp52_) {
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp51_ = TRUE;
#line 929 "sudoku-solver.c"
						} else {
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp55_ = *solution;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp56_ = self->priv->break_at;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp51_ = _tmp55_ > _tmp56_;
#line 939 "sudoku-solver.c"
						}
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_tmp51_) {
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							return;
#line 945 "sudoku-solver.c"
						}
					}
				}
			}
		}
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return;
#line 953 "sudoku-solver.c"
	}
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp57_ = self->board;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp58_ = row;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp59_ = col;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp60_ = no;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_board_insert (_tmp57_, _tmp58_, _tmp59_, _tmp60_, FALSE);
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp61_ = filled;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_quick_solve (self, -1, -1, -1, _tmp61_ + 1, solution);
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp62_ = self->board;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp63_ = row;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp64_ = col;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_board_remove (_tmp62_, _tmp63_, _tmp64_, FALSE);
#line 977 "sudoku-solver.c"
}


SudokuSolverIterator* sudoku_solver_iterator (SudokuSolver* self) {
	SudokuSolverIterator* result = NULL;
	SudokuSolverIterator* _tmp0_ = NULL;
#line 125 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = sudoku_solver_iterator_new (self);
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 992 "sudoku-solver.c"
}


gboolean sudoku_solver_has_unique_solution (SudokuSolver* self) {
	gboolean result = FALSE;
	SudokuSolverIterator* sf = NULL;
	SudokuSolverIterator* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	SudokuSolverIterator* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = sudoku_solver_iterator (self);
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sf = _tmp0_;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = sf;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = sudoku_solver_iterator_next (_tmp2_);
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp3_ == TRUE) {
#line 1015 "sudoku-solver.c"
		SudokuSolverIterator* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = sf;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = sudoku_solver_iterator_next (_tmp4_);
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = _tmp5_ == FALSE;
#line 1024 "sudoku-solver.c"
	} else {
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = FALSE;
#line 1028 "sudoku-solver.c"
	}
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp1_) {
#line 135 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = TRUE;
#line 135 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (sf);
#line 135 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 1038 "sudoku-solver.c"
	} else {
#line 137 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = FALSE;
#line 137 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (sf);
#line 137 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 1046 "sudoku-solver.c"
	}
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (sf);
#line 1050 "sudoku-solver.c"
}


SudokuBoard* sudoku_solver_solve (SudokuSolver* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 195 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = sudoku_solver_auto_fill (self);
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _tmp0_;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp1_);
#line 1069 "sudoku-solver.c"
	{
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 1073 "sudoku-solver.c"
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp3_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp2_ = _tmp3_;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_ != NULL) {
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_inner_error_->domain == SUDOKU_ERROR) {
#line 1084 "sudoku-solver.c"
					goto __catch4_sudoku_error;
				}
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_clear_error (&_inner_error_);
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return NULL;
#line 1093 "sudoku-solver.c"
			}
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(!_tmp2_)) {
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 1099 "sudoku-solver.c"
			}
		}
	}
	goto __finally4;
	__catch4_sudoku_error:
	{
		GError* e = NULL;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		e = _inner_error_;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_inner_error_ = NULL;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_error_free0 (e);
#line 1113 "sudoku-solver.c"
	}
	__finally4:
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_inner_error_ != NULL) {
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_clear_error (&_inner_error_);
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return NULL;
#line 1124 "sudoku-solver.c"
	}
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->solved = TRUE;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = self->board;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp5_;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 1136 "sudoku-solver.c"
}


static GeeArrayList* sudoku_solver_auto_fill (SudokuSolver* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	changed = _tmp0_;
#line 1154 "sudoku-solver.c"
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = sudoku_solver_fill_must_fills (self, &_inner_error_);
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = _tmp2_;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_inner_error_ != NULL) {
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_->domain == SUDOKU_ERROR) {
#line 1167 "sudoku-solver.c"
				goto __catch5_sudoku_error;
			}
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (changed);
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_clear_error (&_inner_error_);
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return NULL;
#line 1178 "sudoku-solver.c"
		}
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = changed;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_array_list_add_all (_tmp3_, (GeeCollection*) _tmp1_);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp1_);
#line 1186 "sudoku-solver.c"
	}
	goto __finally5;
	__catch5_sudoku_error:
	{
		GError* e = NULL;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		e = _inner_error_;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_inner_error_ = NULL;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = changed;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_error_free0 (e);
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 1202 "sudoku-solver.c"
	}
	__finally5:
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_inner_error_ != NULL) {
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (changed);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_clear_error (&_inner_error_);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return NULL;
#line 1215 "sudoku-solver.c"
	}
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = changed;
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = sudoku_solver_fill_deterministically (self);
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = _tmp5_;
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp6_);
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp6_);
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = changed;
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 1231 "sudoku-solver.c"
}


GeeArrayList* sudoku_solver_fill_deterministically (SudokuSolver* self) {
	GeeArrayList* result = NULL;
	GeeHashMap* poss = NULL;
	SudokuBoard* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp2_ = NULL;
#line 223 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->board;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = sudoku_board_calculate_open_squares (_tmp0_);
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	poss = _tmp1_;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	changed = _tmp2_;
#line 1254 "sudoku-solver.c"
	{
		GeeIterator* _coord_it = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = poss;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = gee_abstract_map_get_keys ((GeeMap*) _tmp3_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = _tmp4_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp6_ = _tmp5_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp8_ = _tmp7_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp6_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_it = _tmp8_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 1281 "sudoku-solver.c"
			GeeIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			Coord* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			GeeArrayList* choices = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Coord _tmp16_ = {0};
			gpointer _tmp17_ = NULL;
			GeeArrayList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint val = 0;
			GeeArrayList* _tmp21_ = NULL;
			gpointer _tmp22_ = NULL;
			Coord _tmp23_ = {0};
			gint _tmp24_ = 0;
			Coord _tmp25_ = {0};
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			GeeArrayList* _tmp28_ = NULL;
			Coord _tmp29_ = {0};
			gint _tmp30_ = 0;
			Cell _tmp31_ = {0};
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _coord_it;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_iterator_next (_tmp9_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp10_) {
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 1316 "sudoku-solver.c"
			}
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = _coord_it;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = gee_iterator_get (_tmp11_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = (Coord*) _tmp12_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = *_tmp13_;
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp13_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			coord = _tmp14_;
#line 228 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = poss;
#line 228 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = coord;
#line 228 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, &_tmp16_);
#line 228 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			choices = (GeeArrayList*) _tmp17_;
#line 230 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp18_ = choices;
#line 230 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
#line 230 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp20_ = _tmp19_;
#line 230 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp20_ != 1) {
#line 231 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (choices);
#line 231 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				continue;
#line 1350 "sudoku-solver.c"
			}
#line 233 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp21_ = choices;
#line 233 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
#line 233 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			val = (gint) ((gintptr) _tmp22_);
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp23_ = coord;
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp24_ = _tmp23_.row;
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp25_ = coord;
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp26_ = _tmp25_.col;
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp27_ = val;
#line 235 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			sudoku_solver_insert (self, _tmp24_, _tmp26_, _tmp27_);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp28_ = changed;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp29_ = coord;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp30_ = val;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			cell_init (&_tmp31_, &_tmp29_, _tmp30_);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, &_tmp31_);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (choices);
#line 1382 "sudoku-solver.c"
		}
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_coord_it);
#line 1386 "sudoku-solver.c"
	}
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = changed;
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (poss);
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 1394 "sudoku-solver.c"
}


GeeArrayList* sudoku_solver_fill_must_fills (SudokuSolver* self, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint blocks_across = 0;
	SudokuBoard* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	SudokuBoard* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint blocks_down = 0;
	SudokuBoard* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	SudokuBoard* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	GError * _inner_error_ = NULL;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	changed = _tmp0_;
#line 1423 "sudoku-solver.c"
	{
		gint col = 0;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		col = 0;
#line 1428 "sudoku-solver.c"
		{
			gboolean _tmp1_ = FALSE;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp1_ = TRUE;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 1435 "sudoku-solver.c"
				gint _tmp3_ = 0;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeArrayList* _tmp7_ = NULL;
				SudokuBoard* _tmp8_ = NULL;
				GeeList* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gpointer _tmp11_ = NULL;
				GeeList* _tmp12_ = NULL;
				GeeArrayList* _tmp13_ = NULL;
				GeeArrayList* _tmp14_ = NULL;
				GeeArrayList* _tmp15_ = NULL;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp1_) {
#line 1451 "sudoku-solver.c"
					gint _tmp2_ = 0;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp2_ = col;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					col = _tmp2_ + 1;
#line 1457 "sudoku-solver.c"
				}
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp1_ = FALSE;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3_ = col;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp4_ = self->board;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp6_ = _tmp5_;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp3_ < _tmp6_)) {
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 1473 "sudoku-solver.c"
				}
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp8_ = self->board;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp9_ = _tmp8_->coords_for_col;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp10_ = col;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp12_ = (GeeList*) _tmp11_;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp13_ = sudoku_solver_fill_must_fills_for (self, _tmp12_, &_inner_error_);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp14_ = _tmp13_;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp12_);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp7_ = _tmp14_;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_inner_error_ != NULL) {
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_inner_error_->domain == SUDOKU_ERROR) {
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_propagate_error (error, _inner_error_);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 1503 "sudoku-solver.c"
					} else {
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_clear_error (&_inner_error_);
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 1513 "sudoku-solver.c"
					}
				}
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp15_ = changed;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_array_list_add_all (_tmp15_, (GeeCollection*) _tmp7_);
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp7_);
#line 1522 "sudoku-solver.c"
			}
		}
	}
	{
		gint row = 0;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		row = 0;
#line 1530 "sudoku-solver.c"
		{
			gboolean _tmp16_ = FALSE;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = TRUE;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 1537 "sudoku-solver.c"
				gint _tmp18_ = 0;
				SudokuBoard* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				GeeArrayList* _tmp22_ = NULL;
				SudokuBoard* _tmp23_ = NULL;
				GeeList* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gpointer _tmp26_ = NULL;
				GeeList* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				GeeArrayList* _tmp29_ = NULL;
				GeeArrayList* _tmp30_ = NULL;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp16_) {
#line 1553 "sudoku-solver.c"
					gint _tmp17_ = 0;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp17_ = row;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					row = _tmp17_ + 1;
#line 1559 "sudoku-solver.c"
				}
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp16_ = FALSE;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = row;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp19_ = self->board;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = sudoku_board_get_rows (_tmp19_);
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp21_ = _tmp20_;
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp18_ < _tmp21_)) {
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 1575 "sudoku-solver.c"
				}
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = self->board;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp24_ = _tmp23_->coords_for_row;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp25_ = row;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp27_ = (GeeList*) _tmp26_;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp28_ = sudoku_solver_fill_must_fills_for (self, _tmp27_, &_inner_error_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp29_ = _tmp28_;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp27_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = _tmp29_;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_inner_error_ != NULL) {
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_inner_error_->domain == SUDOKU_ERROR) {
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_propagate_error (error, _inner_error_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 1605 "sudoku-solver.c"
					} else {
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_clear_error (&_inner_error_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 1615 "sudoku-solver.c"
					}
				}
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp30_ = changed;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_array_list_add_all (_tmp30_, (GeeCollection*) _tmp22_);
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp22_);
#line 1624 "sudoku-solver.c"
			}
		}
	}
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = self->board;
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp32_ = sudoku_board_get_cols (_tmp31_);
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp33_ = _tmp32_;
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp34_ = self->board;
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp35_ = sudoku_board_get_block_cols (_tmp34_);
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36_ = _tmp35_;
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	blocks_across = _tmp33_ / _tmp36_;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp37_ = self->board;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp38_ = sudoku_board_get_rows (_tmp37_);
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp39_ = _tmp38_;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp40_ = self->board;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp41_ = sudoku_board_get_block_rows (_tmp40_);
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp42_ = _tmp41_;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	blocks_down = _tmp39_ / _tmp42_;
#line 1656 "sudoku-solver.c"
	{
		gint block_down = 0;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		block_down = 0;
#line 1661 "sudoku-solver.c"
		{
			gboolean _tmp43_ = FALSE;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp43_ = TRUE;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 1668 "sudoku-solver.c"
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp43_) {
#line 1673 "sudoku-solver.c"
					gint _tmp44_ = 0;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp44_ = block_down;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					block_down = _tmp44_ + 1;
#line 1679 "sudoku-solver.c"
				}
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp43_ = FALSE;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp45_ = block_down;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp46_ = blocks_down;
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp45_ < _tmp46_)) {
#line 258 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 1691 "sudoku-solver.c"
				}
				{
					gint block_across = 0;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					block_across = 0;
#line 1697 "sudoku-solver.c"
					{
						gboolean _tmp47_ = FALSE;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp47_ = TRUE;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						while (TRUE) {
#line 1704 "sudoku-solver.c"
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							GeeArrayList* _tmp51_ = NULL;
							SudokuBoard* _tmp52_ = NULL;
							GeeMap* _tmp53_ = NULL;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							Coord _tmp56_ = {0};
							gpointer _tmp57_ = NULL;
							GeeList* _tmp58_ = NULL;
							GeeArrayList* _tmp59_ = NULL;
							GeeArrayList* _tmp60_ = NULL;
							GeeArrayList* _tmp61_ = NULL;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (!_tmp47_) {
#line 1720 "sudoku-solver.c"
								gint _tmp48_ = 0;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp48_ = block_across;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								block_across = _tmp48_ + 1;
#line 1726 "sudoku-solver.c"
							}
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp47_ = FALSE;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp49_ = block_across;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp50_ = blocks_across;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (!(_tmp49_ < _tmp50_)) {
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								break;
#line 1738 "sudoku-solver.c"
							}
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp52_ = self->board;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp53_ = _tmp52_->coords_for_block;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp54_ = block_across;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp55_ = block_down;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							coord_init (&_tmp56_, _tmp54_, _tmp55_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp57_ = gee_map_get (_tmp53_, &_tmp56_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp58_ = (GeeList*) _tmp57_;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp59_ = sudoku_solver_fill_must_fills_for (self, _tmp58_, &_inner_error_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp60_ = _tmp59_;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (_tmp58_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp51_ = _tmp60_;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (_inner_error_ != NULL) {
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								if (_inner_error_->domain == SUDOKU_ERROR) {
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									g_propagate_error (error, _inner_error_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_g_object_unref0 (changed);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									return NULL;
#line 1772 "sudoku-solver.c"
								} else {
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_g_object_unref0 (changed);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									g_clear_error (&_inner_error_);
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									return NULL;
#line 1782 "sudoku-solver.c"
								}
							}
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp61_ = changed;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							gee_array_list_add_all (_tmp61_, (GeeCollection*) _tmp51_);
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (_tmp51_);
#line 1791 "sudoku-solver.c"
						}
					}
				}
			}
		}
	}
#line 263 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = changed;
#line 263 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 1802 "sudoku-solver.c"
}


static GeeArrayList* sudoku_solver_fill_must_fills_for (SudokuSolver* self, GeeList* coords, GError** error) {
	GeeArrayList* result = NULL;
	gboolean skip_set = FALSE;
	gboolean _tmp16_ = FALSE;
	GeeArrayList* changed = NULL;
	GeeArrayList* _tmp18_ = NULL;
	GeeHashMap* needs = NULL;
	GeeHashMap* _tmp19_ = NULL;
	GeeHashMap* _tmp74_ = NULL;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	GError * _inner_error_ = NULL;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (coords != NULL, NULL);
#line 270 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	skip_set = FALSE;
#line 1824 "sudoku-solver.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp0_ = coords;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_list = _tmp1_;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _coord_list;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _tmp3_;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_size = _tmp4_;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_index = -1;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 1852 "sudoku-solver.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			ParallelDict* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp5_ = _coord_index;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_index = _tmp5_ + 1;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp6_ = _coord_index;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _coord_size;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 1877 "sudoku-solver.c"
			}
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = _coord_list;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _coord_index;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = (Coord*) _tmp10_;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = *_tmp11_;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp11_);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			coord = _tmp12_;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = self->priv->conflicts;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = coord;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = parallel_dict_contains (_tmp13_, &_tmp14_);
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp15_) {
#line 273 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				skip_set = TRUE;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 1905 "sudoku-solver.c"
			}
		}
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_coord_list);
#line 1910 "sudoku-solver.c"
	}
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp16_ = skip_set;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp16_) {
#line 1916 "sudoku-solver.c"
		GeeArrayList* _tmp17_ = NULL;
#line 279 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp17_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 279 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = _tmp17_;
#line 279 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 1924 "sudoku-solver.c"
	}
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp18_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	changed = _tmp18_;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp19_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, NULL, NULL, NULL, NULL, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	needs = _tmp19_;
#line 1934 "sudoku-solver.c"
	{
		gint i = 0;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		i = 1;
#line 1939 "sudoku-solver.c"
		{
			gboolean _tmp20_ = FALSE;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp20_ = TRUE;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 1946 "sudoku-solver.c"
				gint _tmp22_ = 0;
				SudokuBoard* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				GeeHashMap* _tmp26_ = NULL;
				gint _tmp27_ = 0;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp20_) {
#line 1955 "sudoku-solver.c"
					gint _tmp21_ = 0;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp21_ = i;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					i = _tmp21_ + 1;
#line 1961 "sudoku-solver.c"
				}
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = FALSE;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = i;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = self->board;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp24_ = sudoku_board_get_max_val (_tmp23_);
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp25_ = _tmp24_;
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp22_ <= _tmp25_)) {
#line 286 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 1977 "sudoku-solver.c"
				}
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp26_ = needs;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp27_ = i;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, (gpointer) ((gintptr) _tmp27_), NULL);
#line 1985 "sudoku-solver.c"
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _coord_index = 0;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp28_ = coords;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_list = _tmp29_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp30_ = _coord_list;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp32_ = _tmp31_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_size = _tmp32_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_index = -1;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 2016 "sudoku-solver.c"
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			Coord coord = {0};
			GeeList* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gpointer _tmp38_ = NULL;
			Coord* _tmp39_ = NULL;
			Coord _tmp40_ = {0};
			gint val = 0;
			SudokuBoard* _tmp41_ = NULL;
			Coord _tmp42_ = {0};
			gint _tmp43_ = 0;
			Coord _tmp44_ = {0};
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp33_ = _coord_index;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_index = _tmp33_ + 1;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp34_ = _coord_index;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp35_ = _coord_size;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp34_ < _tmp35_)) {
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 2046 "sudoku-solver.c"
			}
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp36_ = _coord_list;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp37_ = _coord_index;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp39_ = (Coord*) _tmp38_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp40_ = *_tmp39_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp39_);
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			coord = _tmp40_;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp41_ = self->board;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp42_ = coord;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp43_ = _tmp42_.row;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp44_ = coord;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp45_ = _tmp44_.col;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp46_ = sudoku_board_get (_tmp41_, _tmp43_, _tmp45_);
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			val = _tmp46_;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp47_ = val;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp47_ != 0) {
#line 2080 "sudoku-solver.c"
				GeeHashMap* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				gboolean _tmp50_ = FALSE;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp48_ = needs;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp49_ = val;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp50_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp48_, (gpointer) ((gintptr) _tmp49_));
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp50_) {
#line 2092 "sudoku-solver.c"
					GeeHashMap* _tmp51_ = NULL;
					gint _tmp52_ = 0;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp51_ = needs;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp52_ = val;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp51_, (gpointer) ((gintptr) _tmp52_), NULL);
#line 2101 "sudoku-solver.c"
				}
			} else {
				gint* possibilities = NULL;
				SudokuBoard* _tmp53_ = NULL;
				Coord _tmp54_ = {0};
				gint _tmp55_ = 0;
				Coord _tmp56_ = {0};
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				gint* _tmp59_ = NULL;
				gint possibilities_length1 = 0;
				gint _possibilities_size_ = 0;
				gint* _tmp60_ = NULL;
				gint _tmp60__length1 = 0;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp53_ = self->board;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp54_ = coord;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp55_ = _tmp54_.row;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp56_ = coord;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp57_ = _tmp56_.col;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp59_ = sudoku_board_get_possibilities (_tmp53_, _tmp55_, _tmp57_, &_tmp58_);
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				possibilities = _tmp59_;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				possibilities_length1 = _tmp58_;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_possibilities_size_ = possibilities_length1;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp60_ = possibilities;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp60__length1 = possibilities_length1;
#line 2138 "sudoku-solver.c"
				{
					gint* possibility_collection = NULL;
					gint possibility_collection_length1 = 0;
					gint _possibility_collection_size_ = 0;
					gint possibility_it = 0;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					possibility_collection = _tmp60_;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					possibility_collection_length1 = _tmp60__length1;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					for (possibility_it = 0; possibility_it < _tmp60__length1; possibility_it = possibility_it + 1) {
#line 2150 "sudoku-solver.c"
						gint possibility = 0;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						possibility = possibility_collection[possibility_it];
#line 2154 "sudoku-solver.c"
						{
							GeeHashMap* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							gboolean _tmp63_ = FALSE;
#line 304 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp61_ = needs;
#line 304 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp62_ = possibility;
#line 304 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp63_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp61_, (gpointer) ((gintptr) _tmp62_));
#line 304 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (_tmp63_) {
#line 2167 "sudoku-solver.c"
								GeeHashMap* _tmp64_ = NULL;
								gint _tmp65_ = 0;
								gpointer _tmp66_ = NULL;
								Coord* _tmp67_ = NULL;
								gboolean _tmp68_ = FALSE;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp64_ = needs;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp65_ = possibility;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, (gpointer) ((gintptr) _tmp65_));
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp67_ = (Coord*) _tmp66_;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp68_ = _tmp67_ == NULL;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_coord_free0 (_tmp67_);
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								if (_tmp68_) {
#line 2187 "sudoku-solver.c"
									GeeHashMap* _tmp69_ = NULL;
									gint _tmp70_ = 0;
									Coord _tmp71_ = {0};
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp69_ = needs;
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp70_ = possibility;
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp71_ = coord;
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, (gpointer) ((gintptr) _tmp70_), &_tmp71_);
#line 2199 "sudoku-solver.c"
								} else {
									GeeHashMap* _tmp72_ = NULL;
									gint _tmp73_ = 0;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp72_ = needs;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									_tmp73_ = possibility;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
									gee_abstract_map_unset ((GeeAbstractMap*) _tmp72_, (gpointer) ((gintptr) _tmp73_), NULL);
#line 2209 "sudoku-solver.c"
								}
							}
						}
					}
				}
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				possibilities = (g_free (possibilities), NULL);
#line 2217 "sudoku-solver.c"
			}
		}
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_coord_list);
#line 2222 "sudoku-solver.c"
	}
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp74_ = needs;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp75_ = gee_abstract_map_get_size ((GeeMap*) _tmp74_);
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp76_ = _tmp75_;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp76_ != 0) {
#line 2232 "sudoku-solver.c"
		{
			GeeIterator* _n_it = NULL;
			GeeHashMap* _tmp77_ = NULL;
			GeeSet* _tmp78_ = NULL;
			GeeSet* _tmp79_ = NULL;
			GeeSet* _tmp80_ = NULL;
			GeeIterator* _tmp81_ = NULL;
			GeeIterator* _tmp82_ = NULL;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp77_ = needs;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp78_ = gee_abstract_map_get_keys ((GeeMap*) _tmp77_);
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp79_ = _tmp78_;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp80_ = _tmp79_;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp81_ = gee_iterable_iterator ((GeeIterable*) _tmp80_);
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp82_ = _tmp81_;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp80_);
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_n_it = _tmp82_;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 2259 "sudoku-solver.c"
				GeeIterator* _tmp83_ = NULL;
				gboolean _tmp84_ = FALSE;
				gint n = 0;
				GeeIterator* _tmp85_ = NULL;
				gpointer _tmp86_ = NULL;
				GeeHashMap* _tmp87_ = NULL;
				gint _tmp88_ = 0;
				gpointer _tmp89_ = NULL;
				Coord* _tmp90_ = NULL;
				gboolean _tmp91_ = FALSE;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp83_ = _n_it;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp84_ = gee_iterator_next (_tmp83_);
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp84_) {
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 2278 "sudoku-solver.c"
				}
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp85_ = _n_it;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp86_ = gee_iterator_get (_tmp85_);
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				n = (gint) ((gintptr) _tmp86_);
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp87_ = needs;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp88_ = n;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp89_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp87_, (gpointer) ((gintptr) _tmp88_));
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp90_ = (Coord*) _tmp89_;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp91_ = _tmp90_ == NULL;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_coord_free0 (_tmp90_);
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp91_) {
#line 2300 "sudoku-solver.c"
					gint _tmp92_ = 0;
					GError* _tmp93_ = NULL;
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp92_ = n;
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp93_ = g_error_new (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "Missing a %d in\n", _tmp92_);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_inner_error_ = _tmp93_;
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_inner_error_->domain == SUDOKU_ERROR) {
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_propagate_error (error, _inner_error_);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (_n_it);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (needs);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 2321 "sudoku-solver.c"
					} else {
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (_n_it);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (needs);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (changed);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_clear_error (&_inner_error_);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return NULL;
#line 2335 "sudoku-solver.c"
					}
				} else {
					gint val = 0;
					SudokuBoard* _tmp94_ = NULL;
					GeeHashMap* _tmp95_ = NULL;
					gint _tmp96_ = 0;
					gpointer _tmp97_ = NULL;
					Coord* _tmp98_ = NULL;
					gint _tmp99_ = 0;
					GeeHashMap* _tmp100_ = NULL;
					gint _tmp101_ = 0;
					gpointer _tmp102_ = NULL;
					Coord* _tmp103_ = NULL;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
					gint _tmp106_ = 0;
					gboolean _tmp107_ = FALSE;
					gint _tmp108_ = 0;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp94_ = self->board;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp95_ = needs;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp96_ = n;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp97_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp95_, (gpointer) ((gintptr) _tmp96_));
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp98_ = (Coord*) _tmp97_;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp99_ = (*_tmp98_).row;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp100_ = needs;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp101_ = n;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp102_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp100_, (gpointer) ((gintptr) _tmp101_));
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp103_ = (Coord*) _tmp102_;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp104_ = (*_tmp103_).col;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp105_ = sudoku_board_get (_tmp94_, _tmp99_, _tmp104_);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp106_ = _tmp105_;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_coord_free0 (_tmp103_);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_coord_free0 (_tmp98_);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					val = _tmp106_;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp108_ = val;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_tmp108_ == 0) {
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp107_ = TRUE;
#line 2392 "sudoku-solver.c"
					} else {
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp109_ = val;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp110_ = n;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp107_ = _tmp109_ == _tmp110_;
#line 2402 "sudoku-solver.c"
					}
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_tmp107_) {
#line 2406 "sudoku-solver.c"
						GeeHashMap* _tmp111_ = NULL;
						gint _tmp112_ = 0;
						gpointer _tmp113_ = NULL;
						Coord* _tmp114_ = NULL;
						gint _tmp115_ = 0;
						GeeHashMap* _tmp116_ = NULL;
						gint _tmp117_ = 0;
						gpointer _tmp118_ = NULL;
						Coord* _tmp119_ = NULL;
						gint _tmp120_ = 0;
						gint _tmp121_ = 0;
						GeeArrayList* _tmp122_ = NULL;
						GeeHashMap* _tmp123_ = NULL;
						gint _tmp124_ = 0;
						gpointer _tmp125_ = NULL;
						Coord* _tmp126_ = NULL;
						gint _tmp127_ = 0;
						Cell _tmp128_ = {0};
						Coord _tmp129_ = {0};
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp111_ = needs;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp112_ = n;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp113_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp111_, (gpointer) ((gintptr) _tmp112_));
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp114_ = (Coord*) _tmp113_;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp115_ = (*_tmp114_).row;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp116_ = needs;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp117_ = n;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp118_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp116_, (gpointer) ((gintptr) _tmp117_));
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp119_ = (Coord*) _tmp118_;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp120_ = (*_tmp119_).col;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp121_ = n;
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						sudoku_solver_insert (self, _tmp115_, _tmp120_, _tmp121_);
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_coord_free0 (_tmp119_);
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_coord_free0 (_tmp114_);
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp122_ = changed;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp123_ = needs;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp124_ = n;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp125_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp123_, (gpointer) ((gintptr) _tmp124_));
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp126_ = (Coord*) _tmp125_;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp127_ = n;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp129_ = *_tmp126_;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						cell_init (&_tmp128_, &_tmp129_, _tmp127_);
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, &_tmp128_);
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_coord_free0 (_tmp126_);
#line 2474 "sudoku-solver.c"
					} else {
						GeeHashMap* _tmp130_ = NULL;
						gint _tmp131_ = 0;
						gpointer _tmp132_ = NULL;
						Coord* _tmp133_ = NULL;
						gint _tmp134_ = 0;
						GeeHashMap* _tmp135_ = NULL;
						gint _tmp136_ = 0;
						gpointer _tmp137_ = NULL;
						Coord* _tmp138_ = NULL;
						gint _tmp139_ = 0;
						gint _tmp140_ = 0;
						gint _tmp141_ = 0;
						GError* _tmp142_ = NULL;
						GError* _tmp143_ = NULL;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp130_ = needs;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp131_ = n;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp132_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp130_, (gpointer) ((gintptr) _tmp131_));
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp133_ = (Coord*) _tmp132_;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp134_ = (*_tmp133_).col;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp135_ = needs;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp136_ = n;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp137_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp135_, (gpointer) ((gintptr) _tmp136_));
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp138_ = (Coord*) _tmp137_;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp139_ = (*_tmp138_).row;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp140_ = val;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp141_ = n;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp142_ = g_error_new (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "%d, %d must be two values at once! %d and %d", _tmp134_, _tmp139_, _tmp140_, _tmp141_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp143_ = _tmp142_;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_coord_free0 (_tmp138_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_coord_free0 (_tmp133_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_inner_error_ = _tmp143_;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_inner_error_->domain == SUDOKU_ERROR) {
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							g_propagate_error (error, _inner_error_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (_n_it);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (needs);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (changed);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							return NULL;
#line 2536 "sudoku-solver.c"
						} else {
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (_n_it);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (needs);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (changed);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							g_clear_error (&_inner_error_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							return NULL;
#line 2550 "sudoku-solver.c"
						}
					}
				}
			}
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_n_it);
#line 2557 "sudoku-solver.c"
		}
	}
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = changed;
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (needs);
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 2566 "sudoku-solver.c"
}


static gboolean sudoku_solver_real_guess_least_open_square (SudokuSolver* self, GError** error) {
	gboolean result = FALSE;
	GeeHashMap* poss = NULL;
	SudokuBoard* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GeeMapIterator* iter = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GeeMapIterator* _tmp10_ = NULL;
	GeeMapIterator* _tmp11_ = NULL;
	Coord least_coord = {0};
	GeeMapIterator* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	Coord* _tmp14_ = NULL;
	Coord _tmp15_ = {0};
	GeeArrayList* least_coord_possibilties = NULL;
	GeeMapIterator* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GeeArrayList* possible_values = NULL;
	GeeArrayList* _tmp75_ = NULL;
	Guess** guesses_for_coord = NULL;
	GuessList* _tmp76_ = NULL;
	Coord _tmp77_ = {0};
	gint _tmp78_ = 0;
	Coord _tmp79_ = {0};
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	Guess** _tmp82_ = NULL;
	gint guesses_for_coord_length1 = 0;
	gint _guesses_for_coord_size_ = 0;
	GeeArrayList* _tmp103_ = NULL;
	gint _tmp104_ = 0;
	gint _tmp105_ = 0;
	gint guess = 0;
	GeeArrayList* _tmp120_ = NULL;
	GeeArrayList* _tmp121_ = NULL;
	gint _tmp122_ = 0;
	gint _tmp123_ = 0;
	gint32 _tmp124_ = 0;
	gpointer _tmp125_ = NULL;
	Guess* guess_obj = NULL;
	Coord _tmp126_ = {0};
	gint _tmp127_ = 0;
	Coord _tmp128_ = {0};
	gint _tmp129_ = 0;
	gint _tmp130_ = 0;
	Guess* _tmp131_ = NULL;
	BreadcrumbTrail* _tmp132_ = NULL;
	gint _tmp133_ = 0;
	gint _tmp134_ = 0;
	Coord _tmp143_ = {0};
	gint _tmp144_ = 0;
	Coord _tmp145_ = {0};
	gint _tmp146_ = 0;
	gint _tmp147_ = 0;
	Guess* _tmp148_ = NULL;
	Guess* _tmp149_ = NULL;
	GuessList* _tmp150_ = NULL;
	Guess* _tmp151_ = NULL;
	GeeArrayList* _tmp152_ = NULL;
	Guess* _tmp153_ = NULL;
	GeeArrayList* _tmp154_ = NULL;
	BreadcrumbTrail* _tmp155_ = NULL;
	Guess* _tmp156_ = NULL;
	gboolean contains_empty = FALSE;
	GeeCollection* possibilties_left = NULL;
	SudokuBoard* _tmp157_ = NULL;
	GeeHashMap* _tmp158_ = NULL;
	GeeHashMap* _tmp159_ = NULL;
	GeeCollection* _tmp160_ = NULL;
	GeeCollection* _tmp161_ = NULL;
	GeeCollection* _tmp162_ = NULL;
	gboolean _tmp172_ = FALSE;
	GError * _inner_error_ = NULL;
#line 346 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->board;
#line 346 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = sudoku_board_calculate_open_squares (_tmp0_);
#line 346 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	poss = _tmp1_;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = poss;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = _tmp3_;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = _tmp4_;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = _tmp6_;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = _tmp7_ == 0;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp5_);
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp8_) {
#line 350 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = TRUE;
#line 350 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (poss);
#line 350 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 2680 "sudoku-solver.c"
	}
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = poss;
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp10_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp9_);
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	iter = _tmp10_;
#line 356 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp11_ = iter;
#line 356 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_map_iterator_next (_tmp11_);
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp12_ = iter;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp13_ = gee_map_iterator_get_key (_tmp12_);
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp14_ = (Coord*) _tmp13_;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp15_ = *_tmp14_;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_coord_free0 (_tmp14_);
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	least_coord = _tmp15_;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp16_ = iter;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp17_ = gee_map_iterator_get_value (_tmp16_);
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	least_coord_possibilties = (GeeArrayList*) _tmp17_;
#line 2710 "sudoku-solver.c"
	{
		GeeIterator* _coord_it = NULL;
		GeeHashMap* _tmp18_ = NULL;
		GeeSet* _tmp19_ = NULL;
		GeeSet* _tmp20_ = NULL;
		GeeSet* _tmp21_ = NULL;
		GeeIterator* _tmp22_ = NULL;
		GeeIterator* _tmp23_ = NULL;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp18_ = poss;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp19_ = gee_abstract_map_get_keys ((GeeMap*) _tmp18_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp20_ = _tmp19_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp21_ = _tmp20_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp23_ = _tmp22_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp21_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_it = _tmp23_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 2737 "sudoku-solver.c"
			GeeIterator* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp26_ = NULL;
			gpointer _tmp27_ = NULL;
			Coord* _tmp28_ = NULL;
			Coord _tmp29_ = {0};
			GeeHashMap* _tmp30_ = NULL;
			Coord _tmp31_ = {0};
			gpointer _tmp32_ = NULL;
			GeeArrayList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			GeeArrayList* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp24_ = _coord_it;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp25_ = gee_iterator_next (_tmp24_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp25_) {
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 2763 "sudoku-solver.c"
			}
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp26_ = _coord_it;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp27_ = gee_iterator_get (_tmp26_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp28_ = (Coord*) _tmp27_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp29_ = *_tmp28_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp28_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			coord = _tmp29_;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp30_ = poss;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31_ = coord;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, &_tmp31_);
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp33_ = (GeeArrayList*) _tmp32_;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp35_ = _tmp34_;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp36_ = least_coord_possibilties;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp38_ = _tmp37_;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp39_ = _tmp35_ > _tmp38_;
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp33_);
#line 361 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp39_) {
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				continue;
#line 2803 "sudoku-solver.c"
			} else {
				GeeHashMap* _tmp40_ = NULL;
				Coord _tmp41_ = {0};
				gpointer _tmp42_ = NULL;
				GeeArrayList* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				GeeArrayList* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gboolean _tmp49_ = FALSE;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp40_ = poss;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp41_ = coord;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp42_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, &_tmp41_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp43_ = (GeeArrayList*) _tmp42_;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp45_ = _tmp44_;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp46_ = least_coord_possibilties;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp48_ = _tmp47_;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp49_ = _tmp45_ < _tmp48_;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp43_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp49_) {
#line 2839 "sudoku-solver.c"
					Coord _tmp50_ = {0};
					GeeHashMap* _tmp51_ = NULL;
					Coord _tmp52_ = {0};
					gpointer _tmp53_ = NULL;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp50_ = coord;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					least_coord = _tmp50_;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp51_ = poss;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp52_ = coord;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp53_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp51_, &_tmp52_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (least_coord_possibilties);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					least_coord_possibilties = (GeeArrayList*) _tmp53_;
#line 2858 "sudoku-solver.c"
				} else {
					Coord _tmp54_ = {0};
					gint _tmp55_ = 0;
					Coord _tmp56_ = {0};
					gint _tmp57_ = 0;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp54_ = coord;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp55_ = _tmp54_.col;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp56_ = least_coord;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp57_ = _tmp56_.col;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_tmp55_ < _tmp57_) {
#line 2874 "sudoku-solver.c"
						Coord _tmp58_ = {0};
						GeeHashMap* _tmp59_ = NULL;
						Coord _tmp60_ = {0};
						gpointer _tmp61_ = NULL;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp58_ = coord;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						least_coord = _tmp58_;
#line 373 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp59_ = poss;
#line 373 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp60_ = coord;
#line 373 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, &_tmp60_);
#line 373 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (least_coord_possibilties);
#line 373 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						least_coord_possibilties = (GeeArrayList*) _tmp61_;
#line 2893 "sudoku-solver.c"
					} else {
						gboolean _tmp62_ = FALSE;
						Coord _tmp63_ = {0};
						gint _tmp64_ = 0;
						Coord _tmp65_ = {0};
						gint _tmp66_ = 0;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp63_ = coord;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp64_ = _tmp63_.col;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp65_ = least_coord;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp66_ = _tmp65_.col;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_tmp64_ == _tmp66_) {
#line 2910 "sudoku-solver.c"
							Coord _tmp67_ = {0};
							gint _tmp68_ = 0;
							Coord _tmp69_ = {0};
							gint _tmp70_ = 0;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp67_ = coord;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp68_ = _tmp67_.row;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp69_ = least_coord;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp70_ = _tmp69_.row;
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp62_ = _tmp68_ < _tmp70_;
#line 2925 "sudoku-solver.c"
						} else {
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp62_ = FALSE;
#line 2929 "sudoku-solver.c"
						}
#line 375 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_tmp62_) {
#line 2933 "sudoku-solver.c"
							Coord _tmp71_ = {0};
							GeeHashMap* _tmp72_ = NULL;
							Coord _tmp73_ = {0};
							gpointer _tmp74_ = NULL;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp71_ = coord;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							least_coord = _tmp71_;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp72_ = poss;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp73_ = coord;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp74_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp72_, &_tmp73_);
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (least_coord_possibilties);
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							least_coord_possibilties = (GeeArrayList*) _tmp74_;
#line 2952 "sudoku-solver.c"
						}
					}
				}
			}
		}
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_coord_it);
#line 2960 "sudoku-solver.c"
	}
#line 382 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp75_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
#line 382 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	possible_values = _tmp75_;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp76_ = self->guesses;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp77_ = least_coord;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp78_ = _tmp77_.row;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp79_ = least_coord;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp80_ = _tmp79_.col;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp82_ = guess_list_guesses_for (_tmp76_, _tmp78_, _tmp80_, &_tmp81_);
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guesses_for_coord = _tmp82_;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guesses_for_coord_length1 = _tmp81_;
#line 383 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_guesses_for_coord_size_ = guesses_for_coord_length1;
#line 2984 "sudoku-solver.c"
	{
		GeeArrayList* _possibility_list = NULL;
		GeeArrayList* _tmp83_ = NULL;
		GeeArrayList* _tmp84_ = NULL;
		gint _possibility_size = 0;
		GeeArrayList* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		gint _possibility_index = 0;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp83_ = least_coord_possibilties;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp84_ = _g_object_ref0 (_tmp83_);
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_possibility_list = _tmp84_;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp85_ = _possibility_list;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp86_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp85_);
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp87_ = _tmp86_;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_possibility_size = _tmp87_;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_possibility_index = -1;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 3012 "sudoku-solver.c"
			gint _tmp88_ = 0;
			gint _tmp89_ = 0;
			gint _tmp90_ = 0;
			gint possibility = 0;
			GeeArrayList* _tmp91_ = NULL;
			gint _tmp92_ = 0;
			gpointer _tmp93_ = NULL;
			gboolean found = FALSE;
			Guess** _tmp94_ = NULL;
			gint _tmp94__length1 = 0;
			gboolean _tmp100_ = FALSE;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp88_ = _possibility_index;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_possibility_index = _tmp88_ + 1;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp89_ = _possibility_index;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp90_ = _possibility_size;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp89_ < _tmp90_)) {
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 3036 "sudoku-solver.c"
			}
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp91_ = _possibility_list;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp92_ = _possibility_index;
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _tmp92_);
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			possibility = (gint) ((gintptr) _tmp93_);
#line 388 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			found = FALSE;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp94_ = guesses_for_coord;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp94__length1 = guesses_for_coord_length1;
#line 3052 "sudoku-solver.c"
			{
				Guess** guess_collection = NULL;
				gint guess_collection_length1 = 0;
				gint _guess_collection_size_ = 0;
				gint guess_it = 0;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guess_collection = _tmp94_;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guess_collection_length1 = _tmp94__length1;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				for (guess_it = 0; guess_it < _tmp94__length1; guess_it = guess_it + 1) {
#line 3064 "sudoku-solver.c"
					Guess* _tmp95_ = NULL;
					Guess* guess = NULL;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp95_ = _g_object_ref0 (guess_collection[guess_it]);
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					guess = _tmp95_;
#line 3071 "sudoku-solver.c"
					{
						Guess* _tmp96_ = NULL;
						gint _tmp97_ = 0;
						gint _tmp98_ = 0;
						gint _tmp99_ = 0;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp96_ = guess;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp97_ = guess_get_val (_tmp96_);
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp98_ = _tmp97_;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp99_ = possibility;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_tmp98_ == _tmp99_) {
#line 393 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							found = TRUE;
#line 394 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_g_object_unref0 (guess);
#line 394 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							break;
#line 3093 "sudoku-solver.c"
						}
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_g_object_unref0 (guess);
#line 3097 "sudoku-solver.c"
					}
				}
			}
#line 397 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp100_ = found;
#line 397 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp100_) {
#line 3105 "sudoku-solver.c"
				GeeArrayList* _tmp101_ = NULL;
				gint _tmp102_ = 0;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp101_ = possible_values;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp102_ = possibility;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp101_, (gpointer) ((gintptr) _tmp102_));
#line 3114 "sudoku-solver.c"
			}
		}
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_possibility_list);
#line 3119 "sudoku-solver.c"
	}
#line 401 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp103_ = possible_values;
#line 401 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp104_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp103_);
#line 401 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp105_ = _tmp104_;
#line 401 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp105_ == 0) {
#line 3129 "sudoku-solver.c"
		BreadcrumbTrail* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp106_ = self->breadcrumbs;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp107_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp106_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp108_ = _tmp107_;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_tmp108_ != 0) {
#line 3141 "sudoku-solver.c"
			gint _tmp109_ = 0;
			BreadcrumbTrail* _tmp110_ = NULL;
			BreadcrumbTrail* _tmp111_ = NULL;
			gint _tmp112_ = 0;
			gint _tmp113_ = 0;
			gpointer _tmp114_ = NULL;
			Guess* _tmp115_ = NULL;
			gint _tmp116_ = 0;
			gboolean _tmp117_ = FALSE;
			gboolean _tmp118_ = FALSE;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp109_ = self->backtraces;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			self->backtraces = _tmp109_ + 1;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp110_ = self->breadcrumbs;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp111_ = self->breadcrumbs;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp112_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp111_);
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp113_ = _tmp112_;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp114_ = gee_abstract_list_get ((GeeAbstractList*) _tmp110_, _tmp113_ - 1);
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp115_ = (Guess*) _tmp114_;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			sudoku_solver_unwrap_guess (self, _tmp115_);
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp115_);
#line 407 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp116_ = self->priv->debug_indent;
#line 407 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			self->priv->debug_indent = _tmp116_ + 1;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp118_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp117_ = _tmp118_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_ != NULL) {
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_inner_error_->domain == SUDOKU_ERROR) {
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_propagate_error (error, _inner_error_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (possible_values);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (least_coord_possibilties);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (iter);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (poss);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					return FALSE;
#line 3198 "sudoku-solver.c"
				} else {
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (possible_values);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (least_coord_possibilties);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (iter);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (poss);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_clear_error (&_inner_error_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					return FALSE;
#line 3216 "sudoku-solver.c"
				}
			}
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = _tmp117_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (possible_values);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (least_coord_possibilties);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (iter);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (poss);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 3233 "sudoku-solver.c"
		} else {
			GError* _tmp119_ = NULL;
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp119_ = g_error_new_literal (SUDOKU_ERROR, SUDOKU_ERROR_UNSOLVABLE_PUZZLE, "Unsolvable");
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_inner_error_ = _tmp119_;
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_->domain == SUDOKU_ERROR) {
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_propagate_error (error, _inner_error_);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possible_values);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (least_coord_possibilties);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (iter);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (poss);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return FALSE;
#line 3256 "sudoku-solver.c"
			} else {
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possible_values);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (least_coord_possibilties);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (iter);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (poss);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_clear_error (&_inner_error_);
#line 412 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return FALSE;
#line 3274 "sudoku-solver.c"
			}
		}
	}
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp120_ = possible_values;
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp121_ = possible_values;
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp122_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp121_);
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp123_ = _tmp122_;
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp124_ = g_random_int_range ((gint32) 0, (gint32) _tmp123_);
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp125_ = gee_abstract_list_get ((GeeAbstractList*) _tmp120_, (gint) _tmp124_);
#line 417 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guess = (gint) ((gintptr) _tmp125_);
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp126_ = least_coord;
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp127_ = _tmp126_.row;
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp128_ = least_coord;
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp129_ = _tmp128_.col;
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp130_ = guess;
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp131_ = guess_new (_tmp127_, _tmp129_, _tmp130_);
#line 419 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guess_obj = _tmp131_;
#line 421 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp132_ = self->breadcrumbs;
#line 421 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp133_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp132_);
#line 421 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp134_ = _tmp133_;
#line 421 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp134_ != 0) {
#line 3314 "sudoku-solver.c"
		BreadcrumbTrail* _tmp135_ = NULL;
		BreadcrumbTrail* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		gpointer _tmp139_ = NULL;
		Guess* _tmp140_ = NULL;
		GeeArrayList* _tmp141_ = NULL;
		Guess* _tmp142_ = NULL;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp135_ = self->breadcrumbs;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp136_ = self->breadcrumbs;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp137_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp136_);
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp138_ = _tmp137_;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) _tmp135_, _tmp138_ - 1);
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp140_ = (Guess*) _tmp139_;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp141_ = _tmp140_->children;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp142_ = guess_obj;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp141_, _tmp142_);
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp140_);
#line 3343 "sudoku-solver.c"
	}
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->current_guess);
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->current_guess = NULL;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp143_ = least_coord;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp144_ = _tmp143_.row;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp145_ = least_coord;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp146_ = _tmp145_.col;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp147_ = guess;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_insert (self, _tmp144_, _tmp146_, _tmp147_);
#line 428 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp148_ = guess_obj;
#line 428 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp149_ = _g_object_ref0 (_tmp148_);
#line 428 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->current_guess);
#line 428 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->current_guess = _tmp149_;
#line 431 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp150_ = self->guesses;
#line 431 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp151_ = guess_obj;
#line 431 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp150_, _tmp151_);
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp152_ = self->priv->trail;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp153_ = guess_obj;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp152_, _tmp153_);
#line 434 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp154_ = self->priv->trailDetails;
#line 434 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp154_, "+");
#line 436 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp155_ = self->breadcrumbs;
#line 436 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp156_ = guess_obj;
#line 436 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp155_, _tmp156_);
#line 438 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	contains_empty = FALSE;
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp157_ = self->board;
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp158_ = sudoku_board_calculate_open_squares (_tmp157_);
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp159_ = _tmp158_;
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp160_ = gee_abstract_map_get_values ((GeeMap*) _tmp159_);
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp161_ = _tmp160_;
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp162_ = _tmp161_;
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp159_);
#line 440 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	possibilties_left = _tmp162_;
#line 3409 "sudoku-solver.c"
	{
		GeeIterator* _i_it = NULL;
		GeeCollection* _tmp163_ = NULL;
		GeeIterator* _tmp164_ = NULL;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp163_ = possibilties_left;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp164_ = gee_iterable_iterator ((GeeIterable*) _tmp163_);
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_i_it = _tmp164_;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 3422 "sudoku-solver.c"
			GeeIterator* _tmp165_ = NULL;
			gboolean _tmp166_ = FALSE;
			GeeArrayList* i = NULL;
			GeeIterator* _tmp167_ = NULL;
			gpointer _tmp168_ = NULL;
			GeeArrayList* _tmp169_ = NULL;
			gint _tmp170_ = 0;
			gint _tmp171_ = 0;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp165_ = _i_it;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp166_ = gee_iterator_next (_tmp165_);
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp166_) {
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 3439 "sudoku-solver.c"
			}
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp167_ = _i_it;
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp168_ = gee_iterator_get (_tmp167_);
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			i = (GeeArrayList*) _tmp168_;
#line 442 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp169_ = i;
#line 442 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp170_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp169_);
#line 442 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp171_ = _tmp170_;
#line 442 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp171_ == 0) {
#line 443 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				contains_empty = TRUE;
#line 3457 "sudoku-solver.c"
			}
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (i);
#line 3461 "sudoku-solver.c"
		}
#line 441 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_i_it);
#line 3465 "sudoku-solver.c"
	}
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp172_ = contains_empty;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp172_) {
#line 3471 "sudoku-solver.c"
		GeeArrayList* _tmp173_ = NULL;
		Guess* _tmp174_ = NULL;
		gint _tmp175_ = 0;
		gboolean _tmp176_ = FALSE;
		gboolean _tmp177_ = FALSE;
#line 447 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp173_ = self->priv->trailDetails;
#line 447 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp173_, "Guess leaves us with impossible squares.");
#line 448 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp174_ = guess_obj;
#line 448 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		sudoku_solver_unwrap_guess (self, _tmp174_);
#line 449 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp175_ = self->priv->debug_indent;
#line 449 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->debug_indent = _tmp175_ + 1;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp177_ = sudoku_solver_guess_least_open_square (self, &_inner_error_);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp176_ = _tmp177_;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_inner_error_ != NULL) {
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_->domain == SUDOKU_ERROR) {
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_propagate_error (error, _inner_error_);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possibilties_left);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (guess_obj);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possible_values);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (least_coord_possibilties);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (iter);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (poss);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return FALSE;
#line 3515 "sudoku-solver.c"
			} else {
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possibilties_left);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (guess_obj);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (possible_values);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (least_coord_possibilties);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (iter);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (poss);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_clear_error (&_inner_error_);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return FALSE;
#line 3537 "sudoku-solver.c"
			}
		}
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = _tmp176_;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (possibilties_left);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (guess_obj);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (possible_values);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (least_coord_possibilties);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (iter);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (poss);
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 3558 "sudoku-solver.c"
	}
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = FALSE;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (possibilties_left);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (guess_obj);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guesses_for_coord = (_vala_array_free (guesses_for_coord, guesses_for_coord_length1, (GDestroyNotify) g_object_unref), NULL);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (possible_values);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (least_coord_possibilties);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (iter);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (poss);
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 3578 "sudoku-solver.c"
}


gboolean sudoku_solver_guess_least_open_square (SudokuSolver* self, GError** error) {
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return SUDOKU_SOLVER_GET_CLASS (self)->guess_least_open_square (self, error);
#line 3587 "sudoku-solver.c"
}


static void sudoku_solver_unwrap_guess (SudokuSolver* self, Guess* guess) {
	GeeArrayList* _tmp0_ = NULL;
	Guess* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	Guess* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Guess* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	BreadcrumbTrail* _tmp60_ = NULL;
	Guess* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
#line 456 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 456 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (guess != NULL);
#line 458 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->trail;
#line 458 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = guess;
#line 458 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 459 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = self->priv->trailDetails;
#line 459 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, "-");
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = self->board;
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = guess;
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = guess_get_row (_tmp4_);
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = _tmp5_;
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = guess;
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = guess_get_col (_tmp7_);
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = _tmp8_;
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp10_ = sudoku_board_get (_tmp3_, _tmp6_, _tmp9_);
#line 461 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp10_ != 0) {
#line 3638 "sudoku-solver.c"
		SudokuBoard* _tmp11_ = NULL;
		Guess* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		Guess* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp11_ = self->board;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp12_ = guess;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp13_ = guess_get_row (_tmp12_);
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp14_ = _tmp13_;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp15_ = guess;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp16_ = guess_get_col (_tmp15_);
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp17_ = _tmp16_;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		sudoku_board_remove (_tmp11_, _tmp14_, _tmp17_, FALSE);
#line 3662 "sudoku-solver.c"
	}
	{
		GeeIterator* _coord_it = NULL;
		Guess* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		GeeSet* _tmp20_ = NULL;
		GeeSet* _tmp21_ = NULL;
		GeeSet* _tmp22_ = NULL;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp18_ = guess;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp19_ = _tmp18_->consequences;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp20_ = gee_abstract_map_get_keys ((GeeMap*) _tmp19_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp21_ = _tmp20_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp22_ = _tmp21_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp24_ = _tmp23_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp22_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_coord_it = _tmp24_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 3693 "sudoku-solver.c"
			GeeIterator* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			Coord coord = {0};
			GeeIterator* _tmp27_ = NULL;
			gpointer _tmp28_ = NULL;
			Coord* _tmp29_ = NULL;
			Coord _tmp30_ = {0};
			SudokuBoard* _tmp31_ = NULL;
			Coord _tmp32_ = {0};
			gint _tmp33_ = 0;
			Coord _tmp34_ = {0};
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp25_ = _coord_it;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp26_ = gee_iterator_next (_tmp25_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp26_) {
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 3715 "sudoku-solver.c"
			}
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp27_ = _coord_it;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp28_ = gee_iterator_get (_tmp27_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp29_ = (Coord*) _tmp28_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp30_ = *_tmp29_;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp29_);
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			coord = _tmp30_;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31_ = self->board;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp32_ = coord;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp33_ = _tmp32_.row;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp34_ = coord;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp35_ = _tmp34_.col;
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp36_ = sudoku_board_get (_tmp31_, _tmp33_, _tmp35_);
#line 465 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp36_ != 0) {
#line 3743 "sudoku-solver.c"
				SudokuBoard* _tmp37_ = NULL;
				Coord _tmp38_ = {0};
				gint _tmp39_ = 0;
				Coord _tmp40_ = {0};
				gint _tmp41_ = 0;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp37_ = self->board;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp38_ = coord;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp39_ = _tmp38_.row;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp40_ = coord;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp41_ = _tmp40_.col;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				sudoku_board_remove (_tmp37_, _tmp39_, _tmp41_, FALSE);
#line 3761 "sudoku-solver.c"
			}
		}
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_coord_it);
#line 3766 "sudoku-solver.c"
	}
	{
		GeeArrayList* _child_list = NULL;
		Guess* _tmp42_ = NULL;
		GeeArrayList* _tmp43_ = NULL;
		GeeArrayList* _tmp44_ = NULL;
		gint _child_size = 0;
		GeeArrayList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _child_index = 0;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp42_ = guess;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp43_ = _tmp42_->children;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp44_ = _g_object_ref0 (_tmp43_);
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_child_list = _tmp44_;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp45_ = _child_list;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp46_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp45_);
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp47_ = _tmp46_;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_child_size = _tmp47_;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_child_index = -1;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 3798 "sudoku-solver.c"
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			Guess* child = NULL;
			GeeArrayList* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			gpointer _tmp53_ = NULL;
			Guess* _tmp54_ = NULL;
			GuessList* _tmp55_ = NULL;
			Guess* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp48_ = _child_index;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_child_index = _tmp48_ + 1;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp49_ = _child_index;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp50_ = _child_size;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp49_ < _tmp50_)) {
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 3822 "sudoku-solver.c"
			}
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp51_ = _child_list;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp52_ = _child_index;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp52_);
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			child = (Guess*) _tmp53_;
#line 471 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp54_ = child;
#line 471 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			sudoku_solver_unwrap_guess (self, _tmp54_);
#line 472 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp55_ = self->guesses;
#line 472 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp56_ = child;
#line 472 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp57_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp55_, _tmp56_);
#line 472 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp57_) {
#line 3844 "sudoku-solver.c"
				GuessList* _tmp58_ = NULL;
				Guess* _tmp59_ = NULL;
#line 473 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp58_ = self->guesses;
#line 473 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp59_ = child;
#line 473 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp58_, _tmp59_);
#line 3853 "sudoku-solver.c"
			}
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (child);
#line 3857 "sudoku-solver.c"
		}
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_child_list);
#line 3861 "sudoku-solver.c"
	}
#line 476 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp60_ = self->breadcrumbs;
#line 476 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp61_ = guess;
#line 476 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp62_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp60_, _tmp61_);
#line 476 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp62_) {
#line 3871 "sudoku-solver.c"
		BreadcrumbTrail* _tmp63_ = NULL;
		Guess* _tmp64_ = NULL;
#line 477 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp63_ = self->breadcrumbs;
#line 477 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp64_ = guess;
#line 477 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp63_, _tmp64_);
#line 3880 "sudoku-solver.c"
	}
}


static void sudoku_solver_real_insert (SudokuSolver* self, gint row, gint col, gint val) {
	Guess* _tmp0_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->current_guess;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp0_ != NULL) {
#line 3895 "sudoku-solver.c"
		Guess* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 484 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = self->priv->current_guess;
#line 484 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = row;
#line 484 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = col;
#line 484 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = val;
#line 484 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		guess_add_consequence (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 3910 "sudoku-solver.c"
	}
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = self->board;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = row;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = col;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = val;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_board_insert (_tmp5_, _tmp6_, _tmp7_, _tmp8_, FALSE);
#line 3922 "sudoku-solver.c"
}


void sudoku_solver_insert (SudokuSolver* self, gint row, gint col, gint val) {
#line 481 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 481 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	SUDOKU_SOLVER_GET_CLASS (self)->insert (self, row, col, val);
#line 3931 "sudoku-solver.c"
}


SudokuSolverIterator* sudoku_solver_iterator_construct (GType object_type, SudokuSolver* solver) {
	SudokuSolverIterator * self = NULL;
	SudokuSolver* _tmp0_ = NULL;
	SudokuSolver* _tmp1_ = NULL;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (solver != NULL, NULL);
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (SudokuSolverIterator*) g_object_new (object_type, NULL);
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = solver;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->solver);
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->solver = _tmp1_;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 3953 "sudoku-solver.c"
}


SudokuSolverIterator* sudoku_solver_iterator_new (SudokuSolver* solver) {
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return sudoku_solver_iterator_construct (SUDOKU_SOLVER_TYPE_ITERATOR, solver);
#line 3960 "sudoku-solver.c"
}


gboolean sudoku_solver_iterator_next (SudokuSolverIterator* self) {
	gboolean result = FALSE;
	SudokuSolver* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 149 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->solver;
#line 149 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _tmp0_->solved;
#line 149 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (!_tmp1_) {
#line 3977 "sudoku-solver.c"
		SudokuSolver* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		SudokuSolver* _tmp8_ = NULL;
		SudokuSolver* _tmp9_ = NULL;
		SudokuBoard* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = self->priv->solver;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = sudoku_solver_auto_fill (_tmp2_);
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _tmp3_;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp4_);
#line 3993 "sudoku-solver.c"
		{
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 3997 "sudoku-solver.c"
				gboolean _tmp5_ = FALSE;
				SudokuSolver* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp6_ = self->priv->solver;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp7_ = sudoku_solver_guess_least_open_square (_tmp6_, &_inner_error_);
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5_ = _tmp7_;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_inner_error_ != NULL) {
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_inner_error_->domain == SUDOKU_ERROR) {
#line 4011 "sudoku-solver.c"
						goto __catch6_sudoku_error;
					}
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_clear_error (&_inner_error_);
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					return FALSE;
#line 4020 "sudoku-solver.c"
				}
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(!_tmp5_)) {
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 4026 "sudoku-solver.c"
				}
			}
		}
		goto __finally6;
		__catch6_sudoku_error:
		{
			GError* e = NULL;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			e = _inner_error_;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_inner_error_ = NULL;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (self->priv->solution);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			self->priv->solution = NULL;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = FALSE;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_error_free0 (e);
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 4048 "sudoku-solver.c"
		}
		__finally6:
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_inner_error_ != NULL) {
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_clear_error (&_inner_error_);
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return FALSE;
#line 4059 "sudoku-solver.c"
		}
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp8_ = self->priv->solver;
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp8_->solved = TRUE;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp9_ = self->priv->solver;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp10_ = _tmp9_->board;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (self->priv->solution);
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->solution = _tmp11_;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = TRUE;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 4079 "sudoku-solver.c"
	} else {
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 4083 "sudoku-solver.c"
			SudokuSolver* _tmp12_ = NULL;
			BreadcrumbTrail* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			SudokuSolver* _tmp16_ = NULL;
			SudokuSolver* _tmp17_ = NULL;
			BreadcrumbTrail* _tmp18_ = NULL;
			SudokuSolver* _tmp19_ = NULL;
			BreadcrumbTrail* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gpointer _tmp23_ = NULL;
			Guess* _tmp24_ = NULL;
			SudokuSolver* _tmp28_ = NULL;
			SudokuBoard* _tmp29_ = NULL;
			SudokuBoard* _tmp30_ = NULL;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = self->priv->solver;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = _tmp12_->breadcrumbs;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = _tmp14_;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp15_ != 0)) {
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 4112 "sudoku-solver.c"
			}
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = self->priv->solver;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp17_ = self->priv->solver;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp18_ = _tmp17_->breadcrumbs;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp19_ = self->priv->solver;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp20_ = _tmp19_->breadcrumbs;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp22_ = _tmp21_;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp22_ - 1);
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp24_ = (Guess*) _tmp23_;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			sudoku_solver_unwrap_guess (_tmp16_, _tmp24_);
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp24_);
#line 4136 "sudoku-solver.c"
			{
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				while (TRUE) {
#line 4140 "sudoku-solver.c"
					gboolean _tmp25_ = FALSE;
					SudokuSolver* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp26_ = self->priv->solver;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp27_ = sudoku_solver_guess_least_open_square (_tmp26_, &_inner_error_);
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp25_ = _tmp27_;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_inner_error_ != NULL) {
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						if (_inner_error_->domain == SUDOKU_ERROR) {
#line 4154 "sudoku-solver.c"
							goto __catch7_sudoku_error;
						}
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						g_clear_error (&_inner_error_);
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						return FALSE;
#line 4163 "sudoku-solver.c"
					}
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!(!_tmp25_)) {
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						break;
#line 4169 "sudoku-solver.c"
					}
				}
			}
			goto __finally7;
			__catch7_sudoku_error:
			{
				GError* e = NULL;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				e = _inner_error_;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_inner_error_ = NULL;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (self->priv->solution);
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				self->priv->solution = NULL;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				result = FALSE;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_error_free0 (e);
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return result;
#line 4191 "sudoku-solver.c"
			}
			__finally7:
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_ != NULL) {
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				g_clear_error (&_inner_error_);
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return FALSE;
#line 4202 "sudoku-solver.c"
			}
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp28_ = self->priv->solver;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp29_ = _tmp28_->board;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp30_ = _g_object_ref0 (_tmp29_);
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (self->priv->solution);
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			self->priv->solution = _tmp30_;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = TRUE;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 4218 "sudoku-solver.c"
		}
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = FALSE;
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 4224 "sudoku-solver.c"
	}
}


SudokuBoard* sudoku_solver_iterator_get (SudokuSolverIterator* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->solution;
#line 188 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 188 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp1_;
#line 188 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 4243 "sudoku-solver.c"
}


static void sudoku_solver_iterator_class_init (SudokuSolverIteratorClass * klass) {
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_iterator_parent_class = g_type_class_peek_parent (klass);
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (SudokuSolverIteratorPrivate));
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_solver_iterator_finalize;
#line 4254 "sudoku-solver.c"
}


static void sudoku_solver_iterator_instance_init (SudokuSolverIterator * self) {
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = SUDOKU_SOLVER_ITERATOR_GET_PRIVATE (self);
#line 4261 "sudoku-solver.c"
}


static void sudoku_solver_iterator_finalize (GObject* obj) {
	SudokuSolverIterator * self;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIterator);
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->solver);
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->solution);
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (sudoku_solver_iterator_parent_class)->finalize (obj);
#line 4275 "sudoku-solver.c"
}


GType sudoku_solver_iterator_get_type (void) {
	static volatile gsize sudoku_solver_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_solver_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSolverIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_solver_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSolverIterator), 0, (GInstanceInitFunc) sudoku_solver_iterator_instance_init, NULL };
		GType sudoku_solver_iterator_type_id;
		sudoku_solver_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSolverIterator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_solver_iterator_type_id__volatile, sudoku_solver_iterator_type_id);
	}
	return sudoku_solver_iterator_type_id__volatile;
}


static void sudoku_solver_class_init (SudokuSolverClass * klass) {
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_solver_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (SudokuSolverPrivate));
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	SUDOKU_SOLVER_CLASS (klass)->guess_least_open_square = sudoku_solver_real_guess_least_open_square;
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	SUDOKU_SOLVER_CLASS (klass)->insert = sudoku_solver_real_insert;
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_solver_finalize;
#line 4302 "sudoku-solver.c"
}


static void sudoku_solver_instance_init (SudokuSolver * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = SUDOKU_SOLVER_GET_PRIVATE (self);
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->backtraces = 0;
#line 21 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->count_solutions = FALSE;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->break_at = 100;
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_array_list_new (TYPE_GUESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->trail = _tmp0_;
#line 25 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 25 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->trailDetails = _tmp1_;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->debug_indent = 0;
#line 4327 "sudoku-solver.c"
}


static void sudoku_solver_finalize (GObject* obj) {
	SudokuSolver * self;
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SOLVER, SudokuSolver);
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->board);
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->conflicts);
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->guesses);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->breadcrumbs);
#line 19 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->current_guess);
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->trail);
#line 25 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->trailDetails);
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (sudoku_solver_parent_class)->finalize (obj);
#line 4351 "sudoku-solver.c"
}


GType sudoku_solver_get_type (void) {
	static volatile gsize sudoku_solver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_solver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_solver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSolver), 0, (GInstanceInitFunc) sudoku_solver_instance_init, NULL };
		GType sudoku_solver_type_id;
		sudoku_solver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSolver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_solver_type_id__volatile, sudoku_solver_type_id);
	}
	return sudoku_solver_type_id__volatile;
}


SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board) {
	SudokuRater * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
#line 500 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (*board != NULL, NULL);
#line 501 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (SudokuRater*) sudoku_solver_construct (object_type, board);
#line 502 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->guessing = FALSE;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_add = FALSE;
#line 504 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 504 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fake_additions);
#line 504 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_additions = _tmp0_;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->filled);
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->filled = _tmp1_;
#line 506 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 506 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fill_must_fillables);
#line 506 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fill_must_fillables = _tmp2_;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->elimination_fillables);
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->elimination_fillables = _tmp3_;
#line 508 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->tier = 0;
#line 500 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 4409 "sudoku-solver.c"
}


SudokuRater* sudoku_rater_new (SudokuBoard** board) {
#line 500 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return sudoku_rater_construct (TYPE_SUDOKU_RATER, board);
#line 4416 "sudoku-solver.c"
}


static void sudoku_rater_real_insert (SudokuSolver* base, gint row, gint col, gint val) {
	SudokuRater * self;
	gboolean _tmp0_ = FALSE;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (SudokuRater*) base;
#line 513 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->fake_add;
#line 513 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (!_tmp0_) {
#line 4429 "sudoku-solver.c"
		gboolean _tmp1_ = FALSE;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = self->priv->guessing;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (!_tmp1_) {
#line 4435 "sudoku-solver.c"
			SudokuBoard* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp38_ = 0;
#line 515 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			sudoku_rater_scan_fillables (self);
#line 4443 "sudoku-solver.c"
			{
				GeeArrayList* _delayed_cell_list = NULL;
				GeeArrayList* _tmp2_ = NULL;
				GeeArrayList* _tmp3_ = NULL;
				gint _delayed_cell_size = 0;
				GeeArrayList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _delayed_cell_index = 0;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp2_ = self->priv->add_me_queue;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3_ = _g_object_ref0 (_tmp2_);
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_delayed_cell_list = _tmp3_;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp4_ = _delayed_cell_list;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp6_ = _tmp5_;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_delayed_cell_size = _tmp6_;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_delayed_cell_index = -1;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				while (TRUE) {
#line 4471 "sudoku-solver.c"
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					Cell delayed_cell = {0};
					GeeArrayList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gpointer _tmp12_ = NULL;
					Cell* _tmp13_ = NULL;
					Cell _tmp14_ = {0};
					SudokuBoard* _tmp15_ = NULL;
					Cell _tmp16_ = {0};
					Coord _tmp17_ = {0};
					gint _tmp18_ = 0;
					Cell _tmp19_ = {0};
					Coord _tmp20_ = {0};
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp7_ = _delayed_cell_index;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_delayed_cell_index = _tmp7_ + 1;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp8_ = _delayed_cell_index;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp9_ = _delayed_cell_size;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (!(_tmp8_ < _tmp9_)) {
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						break;
#line 4501 "sudoku-solver.c"
					}
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp10_ = _delayed_cell_list;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp11_ = _delayed_cell_index;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp13_ = (Cell*) _tmp12_;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp14_ = *_tmp13_;
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_cell_free0 (_tmp13_);
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					delayed_cell = _tmp14_;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp15_ = ((SudokuSolver*) self)->board;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp16_ = delayed_cell;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp17_ = _tmp16_.coord;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp18_ = _tmp17_.row;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp19_ = delayed_cell;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp20_ = _tmp19_.coord;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp21_ = _tmp20_.col;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp22_ = sudoku_board_get (_tmp15_, _tmp18_, _tmp21_);
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					if (_tmp22_ == 0) {
#line 4535 "sudoku-solver.c"
						Cell _tmp23_ = {0};
						Coord _tmp24_ = {0};
						gint _tmp25_ = 0;
						Cell _tmp26_ = {0};
						Coord _tmp27_ = {0};
						gint _tmp28_ = 0;
						Cell _tmp29_ = {0};
						gint _tmp30_ = 0;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp23_ = delayed_cell;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp24_ = _tmp23_.coord;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp25_ = _tmp24_.row;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp26_ = delayed_cell;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp27_ = _tmp26_.coord;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp28_ = _tmp27_.col;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp29_ = delayed_cell;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp30_ = _tmp29_.val;
#line 519 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp25_, _tmp28_, _tmp30_);
#line 4562 "sudoku-solver.c"
					}
				}
#line 516 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_delayed_cell_list);
#line 4567 "sudoku-solver.c"
			}
#line 522 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31_ = ((SudokuSolver*) self)->board;
#line 522 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp32_ = row;
#line 522 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp33_ = col;
#line 522 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp34_ = sudoku_board_get (_tmp31_, _tmp32_, _tmp33_);
#line 522 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp34_ == 0) {
#line 4579 "sudoku-solver.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp35_ = row;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp36_ = col;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp37_ = val;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp35_, _tmp36_, _tmp37_);
#line 4591 "sudoku-solver.c"
			}
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp38_ = self->priv->tier;
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			self->priv->tier = _tmp38_ + 1;
#line 4597 "sudoku-solver.c"
		} else {
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
#line 528 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp39_ = row;
#line 528 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp40_ = col;
#line 528 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp41_ = val;
#line 528 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->insert (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), _tmp39_, _tmp40_, _tmp41_);
#line 4610 "sudoku-solver.c"
		}
	} else {
		GeeArrayList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Coord _tmp45_ = {0};
		gint _tmp46_ = 0;
		Cell _tmp47_ = {0};
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp42_ = self->priv->fake_additions;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp43_ = row;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp44_ = col;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		coord_init (&_tmp45_, _tmp43_, _tmp44_);
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp46_ = val;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		cell_init (&_tmp47_, &_tmp45_, _tmp46_);
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, &_tmp47_);
#line 4633 "sudoku-solver.c"
	}
}


static void sudoku_rater_scan_fillables (SudokuRater* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeHashSet* _tmp5_ = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	GeeHashMap* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GeeHashSet* _tmp35_ = NULL;
	GeeHashSet* _tmp36_ = NULL;
	GeeHashSet* _tmp58_ = NULL;
	GeeHashMap* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gpointer _tmp61_ = NULL;
	GeeHashSet* _tmp62_ = NULL;
	GeeHashSet* _tmp63_ = NULL;
	GeeHashMap* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gpointer _tmp66_ = NULL;
	GeeHashSet* _tmp67_ = NULL;
	GeeArrayList* _tmp68_ = NULL;
	GeeArrayList* _tmp69_ = NULL;
	GError * _inner_error_ = NULL;
#line 537 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 538 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_add = TRUE;
#line 541 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 541 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fake_additions);
#line 541 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_additions = _tmp0_;
#line 4676 "sudoku-solver.c"
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = sudoku_solver_fill_must_fills ((SudokuSolver*) self, &_inner_error_);
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _tmp1_;
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp2_);
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_inner_error_ != NULL) {
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_inner_error_->domain == SUDOKU_ERROR) {
#line 4690 "sudoku-solver.c"
				goto __catch8_sudoku_error;
			}
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_clear_error (&_inner_error_);
#line 543 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return;
#line 4699 "sudoku-solver.c"
		}
	}
	goto __finally8;
	__catch8_sudoku_error:
	{
		GError* e = NULL;
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		e = _inner_error_;
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_inner_error_ = NULL;
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_error_free0 (e);
#line 4712 "sudoku-solver.c"
	}
	__finally8:
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_inner_error_ != NULL) {
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_clear_error (&_inner_error_);
#line 542 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return;
#line 4723 "sudoku-solver.c"
	}
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = self->priv->fill_must_fillables;
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = self->priv->tier;
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = _tmp5_;
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_), _tmp6_);
#line 546 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp6_);
#line 4737 "sudoku-solver.c"
	{
		GeeArrayList* _cell_list = NULL;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		gint _cell_size = 0;
		GeeArrayList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _cell_index = 0;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp7_ = self->priv->fake_additions;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_list = _tmp8_;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp9_ = _cell_list;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp11_ = _tmp10_;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_size = _tmp11_;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_index = -1;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 4765 "sudoku-solver.c"
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Cell cell = {0};
			GeeArrayList* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gpointer _tmp17_ = NULL;
			Cell* _tmp18_ = NULL;
			Cell _tmp19_ = {0};
			GeeHashSet* _tmp20_ = NULL;
			Cell _tmp21_ = {0};
			gboolean _tmp22_ = FALSE;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = _cell_index;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_cell_index = _tmp12_ + 1;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = _cell_index;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = _cell_size;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 4790 "sudoku-solver.c"
			}
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = _cell_list;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = _cell_index;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp18_ = (Cell*) _tmp17_;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp19_ = *_tmp18_;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_cell_free0 (_tmp18_);
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			cell = _tmp19_;
#line 548 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp20_ = self->priv->filled;
#line 548 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp21_ = cell;
#line 548 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
#line 548 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp22_) {
#line 4814 "sudoku-solver.c"
				GeeHashMap* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gpointer _tmp25_ = NULL;
				GeeHashSet* _tmp26_ = NULL;
				Cell _tmp27_ = {0};
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = self->priv->fill_must_fillables;
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp24_ = self->priv->tier;
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, (gpointer) ((gintptr) _tmp24_));
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp26_ = (GeeHashSet*) _tmp25_;
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp27_ = cell;
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, &_tmp27_);
#line 549 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp26_);
#line 4834 "sudoku-solver.c"
			}
		}
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_cell_list);
#line 4839 "sudoku-solver.c"
	}
#line 552 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp28_ = self->priv->fake_additions;
#line 552 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp29_ = _g_object_ref0 (_tmp28_);
#line 552 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->add_me_queue);
#line 552 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->add_me_queue = _tmp29_;
#line 553 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp30_ = gee_array_list_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, NULL, NULL, NULL);
#line 553 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fake_additions);
#line 553 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_additions = _tmp30_;
#line 555 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = sudoku_solver_fill_deterministically ((SudokuSolver*) self);
#line 555 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp32_ = _tmp31_;
#line 555 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp32_);
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp33_ = self->priv->elimination_fillables;
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp34_ = self->priv->tier;
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp35_ = gee_hash_set_new (TYPE_CELL, (GBoxedCopyFunc) cell_dup, cell_free, (GeeHashDataFunc) cell_hash, NULL, NULL, (GeeEqualDataFunc) cell_equal, NULL, NULL);
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36_ = _tmp35_;
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, (gpointer) ((gintptr) _tmp34_), _tmp36_);
#line 557 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp36_);
#line 4873 "sudoku-solver.c"
	{
		GeeArrayList* _cell_list = NULL;
		GeeArrayList* _tmp37_ = NULL;
		GeeArrayList* _tmp38_ = NULL;
		gint _cell_size = 0;
		GeeArrayList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _cell_index = 0;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp37_ = self->priv->fake_additions;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp38_ = _g_object_ref0 (_tmp37_);
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_list = _tmp38_;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp39_ = _cell_list;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp41_ = _tmp40_;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_size = _tmp41_;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_cell_index = -1;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 4901 "sudoku-solver.c"
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			Cell cell = {0};
			GeeArrayList* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gpointer _tmp47_ = NULL;
			Cell* _tmp48_ = NULL;
			Cell _tmp49_ = {0};
			GeeHashSet* _tmp50_ = NULL;
			Cell _tmp51_ = {0};
			gboolean _tmp52_ = FALSE;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp42_ = _cell_index;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_cell_index = _tmp42_ + 1;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp43_ = _cell_index;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp44_ = _cell_size;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp43_ < _tmp44_)) {
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 4926 "sudoku-solver.c"
			}
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp45_ = _cell_list;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp46_ = _cell_index;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp48_ = (Cell*) _tmp47_;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp49_ = *_tmp48_;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_cell_free0 (_tmp48_);
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			cell = _tmp49_;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp50_ = self->priv->filled;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp51_ = cell;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp52_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp50_, &_tmp51_);
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp52_) {
#line 4950 "sudoku-solver.c"
				GeeHashMap* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gpointer _tmp55_ = NULL;
				GeeHashSet* _tmp56_ = NULL;
				Cell _tmp57_ = {0};
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp53_ = self->priv->elimination_fillables;
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp54_ = self->priv->tier;
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp55_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, (gpointer) ((gintptr) _tmp54_));
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp56_ = (GeeHashSet*) _tmp55_;
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp57_ = cell;
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
#line 560 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp56_);
#line 4970 "sudoku-solver.c"
			}
		}
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_cell_list);
#line 4975 "sudoku-solver.c"
	}
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp58_ = self->priv->filled;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp59_ = self->priv->fill_must_fillables;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp60_ = self->priv->tier;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, (gpointer) ((gintptr) _tmp60_));
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp62_ = (GeeHashSet*) _tmp61_;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_collection_add_all ((GeeCollection*) _tmp58_, (GeeCollection*) _tmp62_);
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp62_);
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp63_ = self->priv->filled;
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp64_ = self->priv->elimination_fillables;
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp65_ = self->priv->tier;
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, (gpointer) ((gintptr) _tmp65_));
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp67_ = (GeeHashSet*) _tmp66_;
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_collection_add_all ((GeeCollection*) _tmp63_, (GeeCollection*) _tmp67_);
#line 564 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (_tmp67_);
#line 566 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp68_ = self->priv->add_me_queue;
#line 566 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp69_ = self->priv->fake_additions;
#line 566 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_array_list_add_all (_tmp68_, (GeeCollection*) _tmp69_);
#line 567 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fake_add = FALSE;
#line 5013 "sudoku-solver.c"
}


static gboolean sudoku_rater_real_guess_least_open_square (SudokuSolver* base, GError** error) {
	SudokuRater * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 570 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (SudokuRater*) base;
#line 572 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->guessing = TRUE;
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = SUDOKU_SOLVER_CLASS (sudoku_rater_parent_class)->guess_least_open_square (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SUDOKU_SOLVER, SudokuSolver), &_inner_error_);
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = _tmp1_;
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_inner_error_ != NULL) {
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_inner_error_->domain == SUDOKU_ERROR) {
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_propagate_error (error, _inner_error_);
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return FALSE;
#line 5039 "sudoku-solver.c"
		} else {
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_clear_error (&_inner_error_);
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return FALSE;
#line 5047 "sudoku-solver.c"
		}
	}
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 573 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5054 "sudoku-solver.c"
}


DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self) {
	DifficultyRating* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint clues = 0;
	gint numbers_added = 0;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuBoard* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	DifficultyRating* rating = NULL;
	GeeHashMap* _tmp28_ = NULL;
	GeeHashMap* _tmp29_ = NULL;
	GuessList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	DifficultyRating* _tmp32_ = NULL;
#line 576 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 577 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = ((SudokuSolver*) self)->solved;
#line 577 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (!_tmp0_) {
#line 5082 "sudoku-solver.c"
		SudokuBoard* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
#line 578 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = sudoku_solver_solve ((SudokuSolver*) self);
#line 578 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _tmp1_;
#line 578 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp2_);
#line 5091 "sudoku-solver.c"
	}
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	clues = 0;
#line 5095 "sudoku-solver.c"
	{
		gint row = 0;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		row = 0;
#line 5100 "sudoku-solver.c"
		{
			gboolean _tmp3_ = FALSE;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp3_ = TRUE;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 5107 "sudoku-solver.c"
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp3_) {
#line 5114 "sudoku-solver.c"
					gint _tmp4_ = 0;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp4_ = row;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					row = _tmp4_ + 1;
#line 5120 "sudoku-solver.c"
				}
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3_ = FALSE;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5_ = row;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp6_ = ((SudokuSolver*) self)->board;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp8_ = _tmp7_;
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 580 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 5136 "sudoku-solver.c"
				}
				{
					gint col = 0;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					col = 0;
#line 5142 "sudoku-solver.c"
					{
						gboolean _tmp9_ = FALSE;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						_tmp9_ = TRUE;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
						while (TRUE) {
#line 5149 "sudoku-solver.c"
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuBoard* _tmp15_ = NULL;
							gboolean* _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gboolean _tmp19_ = FALSE;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (!_tmp9_) {
#line 5163 "sudoku-solver.c"
								gint _tmp10_ = 0;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp10_ = col;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								col = _tmp10_ + 1;
#line 5169 "sudoku-solver.c"
							}
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp9_ = FALSE;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp11_ = col;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp12_ = ((SudokuSolver*) self)->board;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp14_ = _tmp13_;
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 581 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								break;
#line 5185 "sudoku-solver.c"
							}
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp15_ = ((SudokuSolver*) self)->board;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp16_ = _tmp15_->is_fixed;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp16__length1 = _tmp15_->is_fixed_length1;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp16__length2 = _tmp15_->is_fixed_length2;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp17_ = row;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp18_ = col;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
							if (_tmp19_) {
#line 5203 "sudoku-solver.c"
								gint _tmp20_ = 0;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								_tmp20_ = clues;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
								clues = _tmp20_ + 1;
#line 5209 "sudoku-solver.c"
							}
						}
					}
				}
			}
		}
	}
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp21_ = ((SudokuSolver*) self)->board;
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp22_ = sudoku_board_get_rows (_tmp21_);
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp23_ = _tmp22_;
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp24_ = ((SudokuSolver*) self)->board;
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp25_ = sudoku_board_get_cols (_tmp24_);
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp26_ = _tmp25_;
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp27_ = clues;
#line 585 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	numbers_added = (_tmp23_ * _tmp26_) - _tmp27_;
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp28_ = self->priv->fill_must_fillables;
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp29_ = self->priv->elimination_fillables;
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp30_ = ((SudokuSolver*) self)->guesses;
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = ((SudokuSolver*) self)->backtraces;
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp32_ = difficulty_rating_new (_tmp28_, _tmp29_, _tmp30_, _tmp31_, numbers_added);
#line 587 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	rating = _tmp32_;
#line 592 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = rating;
#line 592 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5249 "sudoku-solver.c"
}


static void sudoku_rater_class_init (SudokuRaterClass * klass) {
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sudoku_rater_parent_class = g_type_class_peek_parent (klass);
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (SudokuRaterPrivate));
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	SUDOKU_SOLVER_CLASS (klass)->insert = sudoku_rater_real_insert;
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	SUDOKU_SOLVER_CLASS (klass)->guess_least_open_square = sudoku_rater_real_guess_least_open_square;
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_rater_finalize;
#line 5264 "sudoku-solver.c"
}


static void sudoku_rater_instance_init (SudokuRater * self) {
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = SUDOKU_RATER_GET_PRIVATE (self);
#line 5271 "sudoku-solver.c"
}


static void sudoku_rater_finalize (GObject* obj) {
	SudokuRater * self;
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_RATER, SudokuRater);
#line 493 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fake_additions);
#line 494 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->add_me_queue);
#line 495 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->filled);
#line 496 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fill_must_fillables);
#line 497 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->elimination_fillables);
#line 489 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (sudoku_rater_parent_class)->finalize (obj);
#line 5291 "sudoku-solver.c"
}


GType sudoku_rater_get_type (void) {
	static volatile gsize sudoku_rater_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_rater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuRaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_rater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuRater), 0, (GInstanceInitFunc) sudoku_rater_instance_init, NULL };
		GType sudoku_rater_type_id;
		sudoku_rater_type_id = g_type_register_static (TYPE_SUDOKU_SOLVER, "SudokuRater", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_rater_type_id__volatile, sudoku_rater_type_id);
	}
	return sudoku_rater_type_id__volatile;
}


Guess* guess_construct (GType object_type, gint row, gint col, gint val) {
	Guess * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeHashMap* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 619 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (Guess*) g_object_new (object_type, NULL);
#line 620 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = row;
#line 620 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->_row = _tmp0_;
#line 621 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = col;
#line 621 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->_col = _tmp1_;
#line 622 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = val;
#line 622 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->_val = _tmp2_;
#line 623 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, G_TYPE_INT, NULL, NULL, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 623 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->consequences);
#line 623 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->consequences = _tmp3_;
#line 624 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = gee_array_list_new (TYPE_GUESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 624 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->children);
#line 624 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->children = _tmp4_;
#line 619 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 5342 "sudoku-solver.c"
}


Guess* guess_new (gint row, gint col, gint val) {
#line 619 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return guess_construct (TYPE_GUESS, row, col, val);
#line 5349 "sudoku-solver.c"
}


void guess_add_consequence (Guess* self, gint row, gint col, gint val) {
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 627 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->consequences;
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = row;
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = col;
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	coord_init (&_tmp3_, _tmp1_, _tmp2_);
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = val;
#line 629 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, &_tmp3_, (gpointer) ((gintptr) _tmp4_));
#line 5373 "sudoku-solver.c"
}


gint guess_get_row (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
#line 600 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 600 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->_row;
#line 600 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 600 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5388 "sudoku-solver.c"
}


gint guess_get_col (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
#line 606 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 606 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->_col;
#line 606 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 606 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5403 "sudoku-solver.c"
}


gint guess_get_val (Guess* self) {
	gint result;
	gint _tmp0_ = 0;
#line 612 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 612 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->_val;
#line 612 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 612 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5418 "sudoku-solver.c"
}


static void guess_class_init (GuessClass * klass) {
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guess_parent_class = g_type_class_peek_parent (klass);
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (GuessPrivate));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_guess_get_property;
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = guess_finalize;
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GUESS_ROW, g_param_spec_int ("row", "row", "row", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GUESS_COL, g_param_spec_int ("col", "col", "col", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GUESS_VAL, g_param_spec_int ("val", "val", "val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5437 "sudoku-solver.c"
}


static void guess_instance_init (Guess * self) {
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = GUESS_GET_PRIVATE (self);
#line 5444 "sudoku-solver.c"
}


static void guess_finalize (GObject* obj) {
	Guess * self;
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GUESS, Guess);
#line 615 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->children);
#line 617 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->consequences);
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (guess_parent_class)->finalize (obj);
#line 5458 "sudoku-solver.c"
}


GType guess_get_type (void) {
	static volatile gsize guess_type_id__volatile = 0;
	if (g_once_init_enter (&guess_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GuessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) guess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Guess), 0, (GInstanceInitFunc) guess_instance_init, NULL };
		GType guess_type_id;
		guess_type_id = g_type_register_static (G_TYPE_OBJECT, "Guess", &g_define_type_info, 0);
		g_once_init_leave (&guess_type_id__volatile, guess_type_id);
	}
	return guess_type_id__volatile;
}


static void _vala_guess_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Guess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GUESS, Guess);
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	switch (property_id) {
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case GUESS_ROW:
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_value_set_int (value, guess_get_row (self));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		break;
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case GUESS_COL:
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_value_set_int (value, guess_get_col (self));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		break;
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case GUESS_VAL:
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		g_value_set_int (value, guess_get_val (self));
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		break;
#line 5497 "sudoku-solver.c"
		default:
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 596 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		break;
#line 5503 "sudoku-solver.c"
	}
}


static void _vala_array_add5 (Guess*** array, int* length, int* size, Guess* value) {
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if ((*length) == (*size)) {
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*array = g_renew (Guess*, *array, (*size) + 1);
#line 5515 "sudoku-solver.c"
	}
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[(*length)++] = value;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[*length] = NULL;
#line 5521 "sudoku-solver.c"
}


Guess** guess_list_guesses_for (GuessList* self, gint row, gint col, int* result_length1) {
	Guess** result = NULL;
	Guess** guesses = NULL;
	Guess** _tmp0_ = NULL;
	gint guesses_length1 = 0;
	gint _guesses_size_ = 0;
	Guess** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
#line 635 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 636 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = g_new0 (Guess*, 0 + 1);
#line 636 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guesses = _tmp0_;
#line 636 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guesses_length1 = 0;
#line 636 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_guesses_size_ = guesses_length1;
#line 5543 "sudoku-solver.c"
	{
		GuessList* _guess_list = NULL;
		GuessList* _tmp1_ = NULL;
		gint _guess_size = 0;
		GuessList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _guess_index = 0;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_list = _tmp1_;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _guess_list;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _tmp3_;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_size = _tmp4_;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_index = -1;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 5568 "sudoku-solver.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Guess* guess = NULL;
			GuessList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			Guess* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp5_ = _guess_index;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_guess_index = _tmp5_ + 1;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp6_ = _guess_index;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _guess_size;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 5593 "sudoku-solver.c"
			}
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = _guess_list;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _guess_index;
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			guess = (Guess*) _tmp10_;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = guess;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = guess_get_row (_tmp12_);
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = _tmp13_;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = row;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp14_ == _tmp15_) {
#line 5613 "sudoku-solver.c"
				Guess* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp16_ = guess;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp17_ = guess_get_col (_tmp16_);
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = _tmp17_;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp19_ = col;
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp11_ = _tmp18_ == _tmp19_;
#line 5628 "sudoku-solver.c"
			} else {
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp11_ = FALSE;
#line 5632 "sudoku-solver.c"
			}
#line 639 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp11_) {
#line 5636 "sudoku-solver.c"
				Guess** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Guess* _tmp21_ = NULL;
				Guess* _tmp22_ = NULL;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = guesses;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20__length1 = guesses_length1;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp21_ = guess;
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 640 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_vala_array_add5 (&guesses, &guesses_length1, &_guesses_size_, _tmp22_);
#line 5651 "sudoku-solver.c"
			}
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (guess);
#line 5655 "sudoku-solver.c"
		}
#line 638 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_guess_list);
#line 5659 "sudoku-solver.c"
	}
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp23_ = guesses;
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp23__length1 = guesses_length1;
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (result_length1) {
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*result_length1 = _tmp23__length1;
#line 5669 "sudoku-solver.c"
	}
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp23_;
#line 644 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5675 "sudoku-solver.c"
}


static void _vala_array_add6 (Guess*** array, int* length, int* size, Guess* value) {
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if ((*length) == (*size)) {
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*array = g_renew (Guess*, *array, (*size) + 1);
#line 5686 "sudoku-solver.c"
	}
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[(*length)++] = value;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[*length] = NULL;
#line 5692 "sudoku-solver.c"
}


Guess** guess_list_remove_children (GuessList* self, Guess* guess, int* result_length1) {
	Guess** result = NULL;
	Guess** removed = NULL;
	Guess** _tmp0_ = NULL;
	gint removed_length1 = 0;
	gint _removed_size_ = 0;
	Guess** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
#line 647 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 647 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (guess != NULL, NULL);
#line 648 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = g_new0 (Guess*, 0 + 1);
#line 648 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	removed = _tmp0_;
#line 648 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	removed_length1 = 0;
#line 648 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_removed_size_ = removed_length1;
#line 5716 "sudoku-solver.c"
	{
		GeeArrayList* _g_list = NULL;
		Guess* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _g_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _g_index = 0;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = guess;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _tmp1_->children;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_list = _tmp3_;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _g_list;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp6_ = _tmp5_;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_size = _tmp6_;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_index = -1;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 5747 "sudoku-solver.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			Guess* g = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			Guess* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _g_index;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_index = _tmp7_ + 1;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = _g_index;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _g_size;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 5769 "sudoku-solver.c"
			}
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = _g_list;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = _g_index;
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g = (Guess*) _tmp12_;
#line 651 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = g;
#line 651 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self, _tmp13_);
#line 651 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp14_) {
#line 5785 "sudoku-solver.c"
				Guess** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				Guess* _tmp16_ = NULL;
				Guess* _tmp17_ = NULL;
				Guess* _tmp18_ = NULL;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp15_ = removed;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp15__length1 = removed_length1;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp16_ = g;
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp17_ = _g_object_ref0 (_tmp16_);
#line 652 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_vala_array_add6 (&removed, &removed_length1, &_removed_size_, _tmp17_);
#line 653 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = g;
#line 653 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) self, _tmp18_);
#line 5805 "sudoku-solver.c"
			}
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (g);
#line 5809 "sudoku-solver.c"
		}
#line 650 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_g_list);
#line 5813 "sudoku-solver.c"
	}
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp19_ = removed;
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp19__length1 = removed_length1;
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (result_length1) {
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*result_length1 = _tmp19__length1;
#line 5823 "sudoku-solver.c"
	}
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp19_;
#line 657 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 5829 "sudoku-solver.c"
}


static void _vala_array_add7 (Guess*** array, int* length, int* size, Guess* value) {
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if ((*length) == (*size)) {
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*array = g_renew (Guess*, *array, (*size) + 1);
#line 5840 "sudoku-solver.c"
	}
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[(*length)++] = value;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	(*array)[*length] = NULL;
#line 5846 "sudoku-solver.c"
}


Guess** guess_list_remove_guesses_for (GuessList* self, gint row, gint col, int* result_length1) {
	Guess** result = NULL;
	Guess** removed = NULL;
	Guess** _tmp0_ = NULL;
	gint removed_length1 = 0;
	gint _removed_size_ = 0;
	Guess** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 660 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 661 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = g_new0 (Guess*, 0 + 1);
#line 661 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	removed = _tmp0_;
#line 661 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	removed_length1 = 0;
#line 661 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_removed_size_ = removed_length1;
#line 5868 "sudoku-solver.c"
	{
		GuessList* _guess_list = NULL;
		GuessList* _tmp1_ = NULL;
		gint _guess_size = 0;
		GuessList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _guess_index = 0;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_list = _tmp1_;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = _guess_list;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _tmp3_;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_size = _tmp4_;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_guess_index = -1;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 5893 "sudoku-solver.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Guess* guess = NULL;
			GuessList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			Guess* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp5_ = _guess_index;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_guess_index = _tmp5_ + 1;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp6_ = _guess_index;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _guess_size;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 5918 "sudoku-solver.c"
			}
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = _guess_list;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _guess_index;
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			guess = (Guess*) _tmp10_;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = guess;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = guess_get_row (_tmp12_);
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = _tmp13_;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = row;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp14_ == _tmp15_) {
#line 5938 "sudoku-solver.c"
				Guess* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp16_ = guess;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp17_ = guess_get_col (_tmp16_);
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = _tmp17_;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp19_ = col;
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp11_ = _tmp18_ == _tmp19_;
#line 5953 "sudoku-solver.c"
			} else {
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp11_ = FALSE;
#line 5957 "sudoku-solver.c"
			}
#line 664 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp11_) {
#line 5961 "sudoku-solver.c"
				Guess** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Guess* _tmp21_ = NULL;
				Guess* _tmp22_ = NULL;
				Guess* _tmp23_ = NULL;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = removed;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20__length1 = removed_length1;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp21_ = guess;
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 665 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_vala_array_add7 (&removed, &removed_length1, &_removed_size_, _tmp22_);
#line 666 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = guess;
#line 666 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) self, _tmp23_);
#line 5981 "sudoku-solver.c"
			}
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (guess);
#line 5985 "sudoku-solver.c"
		}
#line 663 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_guess_list);
#line 5989 "sudoku-solver.c"
	}
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp24_ = removed;
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp24__length1 = removed_length1;
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (result_length1) {
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*result_length1 = _tmp24__length1;
#line 5999 "sudoku-solver.c"
	}
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp24_;
#line 670 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 6005 "sudoku-solver.c"
}


GuessList* guess_list_construct (GType object_type) {
	GuessList * self = NULL;
#line 633 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (GuessList*) gee_array_list_construct (object_type, TYPE_GUESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 633 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 6015 "sudoku-solver.c"
}


GuessList* guess_list_new (void) {
#line 633 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return guess_list_construct (TYPE_GUESS_LIST);
#line 6022 "sudoku-solver.c"
}


static void guess_list_class_init (GuessListClass * klass) {
#line 633 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	guess_list_parent_class = g_type_class_peek_parent (klass);
#line 6029 "sudoku-solver.c"
}


static void guess_list_instance_init (GuessList * self) {
}


GType guess_list_get_type (void) {
	static volatile gsize guess_list_type_id__volatile = 0;
	if (g_once_init_enter (&guess_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GuessListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) guess_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GuessList), 0, (GInstanceInitFunc) guess_list_instance_init, NULL };
		GType guess_list_type_id;
		guess_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GuessList", &g_define_type_info, 0);
		g_once_init_leave (&guess_list_type_id__volatile, guess_list_type_id);
	}
	return guess_list_type_id__volatile;
}


void breadcrumb_trail_append (BreadcrumbTrail* self, Guess* guess) {
	Guess* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Guess* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Guess** _tmp7_ = NULL;
	Guess** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gboolean _tmp9_ = FALSE;
#line 676 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 676 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (guess != NULL);
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = guess;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = guess_get_row (_tmp0_);
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = _tmp1_;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = guess;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = guess_get_col (_tmp3_);
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = _tmp4_;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = guess_list_guesses_for ((GuessList*) self, _tmp2_, _tmp5_, &_tmp6_);
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = _tmp7_;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8__length1 = _tmp6_;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = _tmp6_ != 0;
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
#line 677 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp9_) {
#line 6089 "sudoku-solver.c"
	} else {
		Guess* _tmp10_ = NULL;
#line 680 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp10_ = guess;
#line 680 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp10_);
#line 6096 "sudoku-solver.c"
	}
}


BreadcrumbTrail* breadcrumb_trail_construct (GType object_type) {
	BreadcrumbTrail * self = NULL;
#line 674 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (BreadcrumbTrail*) guess_list_construct (object_type);
#line 674 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 6107 "sudoku-solver.c"
}


BreadcrumbTrail* breadcrumb_trail_new (void) {
#line 674 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return breadcrumb_trail_construct (TYPE_BREADCRUMB_TRAIL);
#line 6114 "sudoku-solver.c"
}


static void breadcrumb_trail_class_init (BreadcrumbTrailClass * klass) {
#line 674 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	breadcrumb_trail_parent_class = g_type_class_peek_parent (klass);
#line 6121 "sudoku-solver.c"
}


static void breadcrumb_trail_instance_init (BreadcrumbTrail * self) {
}


GType breadcrumb_trail_get_type (void) {
	static volatile gsize breadcrumb_trail_type_id__volatile = 0;
	if (g_once_init_enter (&breadcrumb_trail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BreadcrumbTrailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) breadcrumb_trail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreadcrumbTrail), 0, (GInstanceInitFunc) breadcrumb_trail_instance_init, NULL };
		GType breadcrumb_trail_type_id;
		breadcrumb_trail_type_id = g_type_register_static (TYPE_GUESS_LIST, "BreadcrumbTrail", &g_define_type_info, 0);
		g_once_init_leave (&breadcrumb_trail_type_id__volatile, breadcrumb_trail_type_id);
	}
	return breadcrumb_trail_type_id__volatile;
}


static gboolean _coord_equal (const Coord* s1, const Coord* s2) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (s1 == s2) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return TRUE;
#line 6146 "sudoku-solver.c"
	}
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (s1 == NULL) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return FALSE;
#line 6152 "sudoku-solver.c"
	}
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (s2 == NULL) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return FALSE;
#line 6158 "sudoku-solver.c"
	}
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (s1->row != s2->row) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return FALSE;
#line 6164 "sudoku-solver.c"
	}
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (s1->col != s2->col) {
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return FALSE;
#line 6170 "sudoku-solver.c"
	}
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return TRUE;
#line 6174 "sudoku-solver.c"
}


void parallel_dict_set (ParallelDict* self, Coord* k, GeeHashSet* v) {
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	GeeHashSet* _tmp2_ = NULL;
#line 688 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 688 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (k != NULL);
#line 688 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (v != NULL);
#line 690 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->map;
#line 690 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = *k;
#line 690 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = v;
#line 690 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, &_tmp1_, _tmp2_);
#line 6196 "sudoku-solver.c"
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = v;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp3_);
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_i_it = _tmp4_;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 6209 "sudoku-solver.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			Coord i = {0};
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			Coord* _tmp9_ = NULL;
			Coord _tmp10_ = {0};
			Coord _tmp11_ = {0};
			Coord _tmp12_ = {0};
			GeeHashMap* _tmp13_ = NULL;
			Coord _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp5_ = _i_it;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp6_) {
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 6230 "sudoku-solver.c"
			}
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _i_it;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = (Coord*) _tmp8_;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = *_tmp9_;
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp9_);
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			i = _tmp10_;
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = i;
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = *k;
#line 693 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_coord_equal (&_tmp11_, &_tmp12_) == TRUE) {
#line 694 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				continue;
#line 6252 "sudoku-solver.c"
			}
#line 695 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = self->priv->map;
#line 695 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = i;
#line 695 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp13_, &_tmp14_);
#line 695 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp15_) {
#line 6262 "sudoku-solver.c"
				GeeHashMap* _tmp16_ = NULL;
				Coord _tmp17_ = {0};
				gpointer _tmp18_ = NULL;
				GeeHashSet* _tmp19_ = NULL;
				Coord _tmp20_ = {0};
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp16_ = self->priv->map;
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp17_ = *k;
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, &_tmp17_);
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp19_ = (GeeHashSet*) _tmp18_;
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = i;
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
#line 696 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp19_);
#line 6282 "sudoku-solver.c"
			} else {
				GeeHashSet* kSet = NULL;
				GeeHashSet* _tmp21_ = NULL;
				GeeHashSet* _tmp22_ = NULL;
				Coord _tmp23_ = {0};
				GeeHashMap* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
				GeeHashSet* _tmp26_ = NULL;
#line 698 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp21_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 698 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				kSet = _tmp21_;
#line 699 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = kSet;
#line 699 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = *k;
#line 699 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, &_tmp23_);
#line 700 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp24_ = self->priv->map;
#line 700 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp25_ = i;
#line 700 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp26_ = kSet;
#line 700 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, &_tmp25_, _tmp26_);
#line 695 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (kSet);
#line 6311 "sudoku-solver.c"
			}
		}
#line 691 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_i_it);
#line 6316 "sudoku-solver.c"
	}
}


void parallel_dict_unset (ParallelDict* self, Coord* k) {
	GeeHashSet* v = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	Coord _tmp4_ = {0};
#line 705 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (self != NULL);
#line 705 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_if_fail (k != NULL);
#line 707 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->map;
#line 707 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = *k;
#line 707 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, &_tmp1_);
#line 707 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	v = (GeeHashSet*) _tmp2_;
#line 708 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = self->priv->map;
#line 708 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = *k;
#line 708 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, &_tmp4_, NULL);
#line 6346 "sudoku-solver.c"
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = v;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp5_);
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_i_it = _tmp6_;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 6359 "sudoku-solver.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			Coord i = {0};
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			Coord _tmp13_ = {0};
			Coord _tmp14_ = {0};
			GeeHashMap* _tmp15_ = NULL;
			Coord _tmp16_ = {0};
			gboolean _tmp17_ = FALSE;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _i_it;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp8_) {
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 6380 "sudoku-solver.c"
			}
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _i_it;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = (Coord*) _tmp10_;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = *_tmp11_;
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_coord_free0 (_tmp11_);
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			i = _tmp12_;
#line 711 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = i;
#line 711 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = *k;
#line 711 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_coord_equal (&_tmp13_, &_tmp14_) == TRUE) {
#line 712 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				continue;
#line 6402 "sudoku-solver.c"
			}
#line 713 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = self->priv->map;
#line 713 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = i;
#line 713 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp17_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp15_, &_tmp16_);
#line 713 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp17_) {
#line 6412 "sudoku-solver.c"
				GeeHashMap* _tmp18_ = NULL;
				Coord _tmp19_ = {0};
				gpointer _tmp20_ = NULL;
				GeeHashSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				GeeHashMap* _tmp30_ = NULL;
				Coord _tmp31_ = {0};
				gpointer _tmp32_ = NULL;
				GeeHashSet* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp18_ = self->priv->map;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp19_ = i;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, &_tmp19_);
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp21_ = (GeeHashSet*) _tmp20_;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp22_ = *k;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp23_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp21_, &_tmp22_);
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp24_ = _tmp23_;
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp21_);
#line 715 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp24_) {
#line 6445 "sudoku-solver.c"
					GeeHashMap* _tmp25_ = NULL;
					Coord _tmp26_ = {0};
					gpointer _tmp27_ = NULL;
					GeeHashSet* _tmp28_ = NULL;
					Coord _tmp29_ = {0};
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp25_ = self->priv->map;
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp26_ = i;
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, &_tmp26_);
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp28_ = (GeeHashSet*) _tmp27_;
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp29_ = *k;
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp28_, &_tmp29_);
#line 716 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_g_object_unref0 (_tmp28_);
#line 6465 "sudoku-solver.c"
				}
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp30_ = self->priv->map;
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp31_ = i;
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, &_tmp31_);
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp33_ = (GeeHashSet*) _tmp32_;
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp35_ = _tmp34_;
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp36_ = _tmp35_ == 0;
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_g_object_unref0 (_tmp33_);
#line 717 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp36_) {
#line 6485 "sudoku-solver.c"
					GeeHashMap* _tmp37_ = NULL;
					Coord _tmp38_ = {0};
#line 718 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp37_ = self->priv->map;
#line 718 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp38_ = i;
#line 718 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp37_, &_tmp38_, NULL);
#line 6494 "sudoku-solver.c"
				}
			}
		}
#line 709 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_i_it);
#line 6500 "sudoku-solver.c"
	}
#line 705 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (v);
#line 6504 "sudoku-solver.c"
}


gboolean parallel_dict_contains (ParallelDict* self, Coord* key) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 725 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 725 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 727 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->map;
#line 727 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = *key;
#line 727 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, &_tmp1_);
#line 727 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp2_;
#line 727 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 6527 "sudoku-solver.c"
}


ParallelDict* parallel_dict_construct (GType object_type) {
	ParallelDict * self = NULL;
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (ParallelDict*) g_object_new (object_type, NULL);
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 6537 "sudoku-solver.c"
}


ParallelDict* parallel_dict_new (void) {
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return parallel_dict_construct (TYPE_PARALLEL_DICT);
#line 6544 "sudoku-solver.c"
}


static void parallel_dict_class_init (ParallelDictClass * klass) {
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	parallel_dict_parent_class = g_type_class_peek_parent (klass);
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (ParallelDictPrivate));
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = parallel_dict_finalize;
#line 6555 "sudoku-solver.c"
}


static void parallel_dict_instance_init (ParallelDict * self) {
	GeeHashMap* _tmp0_ = NULL;
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = PARALLEL_DICT_GET_PRIVATE (self);
#line 686 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 686 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->map = _tmp0_;
#line 6567 "sudoku-solver.c"
}


static void parallel_dict_finalize (GObject* obj) {
	ParallelDict * self;
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARALLEL_DICT, ParallelDict);
#line 686 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->map);
#line 685 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (parallel_dict_parent_class)->finalize (obj);
#line 6579 "sudoku-solver.c"
}


GType parallel_dict_get_type (void) {
	static volatile gsize parallel_dict_type_id__volatile = 0;
	if (g_once_init_enter (&parallel_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ParallelDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parallel_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ParallelDict), 0, (GInstanceInitFunc) parallel_dict_instance_init, NULL };
		GType parallel_dict_type_id;
		parallel_dict_type_id = g_type_register_static (G_TYPE_OBJECT, "ParallelDict", &g_define_type_info, 0);
		g_once_init_leave (&parallel_dict_type_id__volatile, parallel_dict_type_id);
	}
	return parallel_dict_type_id__volatile;
}


gchar* difficulty_category_to_string (DifficultyCategory self) {
	gchar* result = NULL;
#line 739 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	switch (self) {
#line 739 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case DIFFICULTY_CATEGORY_EASY:
#line 6601 "sudoku-solver.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 742 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp0_ = _ ("Easy Difficulty");
#line 742 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 742 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = _tmp1_;
#line 742 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 6613 "sudoku-solver.c"
		}
#line 739 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case DIFFICULTY_CATEGORY_MEDIUM:
#line 6617 "sudoku-solver.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 744 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp2_ = _ ("Medium Difficulty");
#line 744 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 744 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = _tmp3_;
#line 744 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 6629 "sudoku-solver.c"
		}
#line 739 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case DIFFICULTY_CATEGORY_HARD:
#line 6633 "sudoku-solver.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 746 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp4_ = _ ("Hard Difficulty");
#line 746 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 746 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = _tmp5_;
#line 746 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 6645 "sudoku-solver.c"
		}
#line 739 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		case DIFFICULTY_CATEGORY_VERY_HARD:
#line 6649 "sudoku-solver.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 748 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp6_ = _ ("Very Hard Difficulty");
#line 748 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 748 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = _tmp7_;
#line 748 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 6661 "sudoku-solver.c"
		}
		default:
		{
#line 750 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			g_assert_not_reached ();
#line 6667 "sudoku-solver.c"
		}
	}
}


GType difficulty_category_get_type (void) {
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}


static gint _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by (gint a, gpointer self) {
	gint result;
	result = difficulty_rating_diminsh_by_one (a);
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 6690 "sudoku-solver.c"
}


DifficultyRating* difficulty_rating_construct (GType object_type, GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled) {
	DifficultyRating * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GuessList* _tmp4_ = NULL;
	GuessList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GeeHashMap* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GeeHashMap* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gfloat _tmp24_ = 0.0F;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	GeeHashMap* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint* _tmp30_ = NULL;
	gint* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gfloat _tmp32_ = 0.0F;
	GeeHashMap* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint* _tmp35_ = NULL;
	gint* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gfloat _tmp37_ = 0.0F;
	gfloat _tmp38_ = 0.0F;
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (fill_must_fillables != NULL, NULL);
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (elimination_fillables != NULL, NULL);
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (guesses != NULL, NULL);
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = (DifficultyRating*) g_object_new (object_type, NULL);
#line 780 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = fill_must_fillables;
#line 780 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 780 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fill_must_fillables);
#line 780 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fill_must_fillables = _tmp1_;
#line 781 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = elimination_fillables;
#line 781 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 781 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->elimination_fillables);
#line 781 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->elimination_fillables = _tmp3_;
#line 783 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = guesses;
#line 783 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 783 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->guesses);
#line 783 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->guesses = _tmp5_;
#line 784 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = backtraces;
#line 784 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->backtraces = _tmp6_;
#line 785 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = squares_filled;
#line 785 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->squares_filled = _tmp7_;
#line 787 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = fill_must_fillables;
#line 787 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = gee_abstract_map_get_size ((GeeMap*) _tmp8_);
#line 787 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp10_ = _tmp9_;
#line 787 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp10_ != 0) {
#line 6775 "sudoku-solver.c"
		GeeHashMap* _tmp11_ = NULL;
		gpointer _tmp12_ = NULL;
		GeeHashSet* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp11_ = fill_must_fillables;
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) 0));
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp13_ = (GeeHashSet*) _tmp12_;
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp15_ = _tmp14_;
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->instant_fill_fillable = (gfloat) _tmp15_;
#line 788 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp13_);
#line 6795 "sudoku-solver.c"
	} else {
#line 790 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->instant_fill_fillable = 0.0f;
#line 6799 "sudoku-solver.c"
	}
#line 792 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp16_ = elimination_fillables;
#line 792 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp17_ = gee_abstract_map_get_size ((GeeMap*) _tmp16_);
#line 792 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp18_ = _tmp17_;
#line 792 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp18_ != 0) {
#line 6809 "sudoku-solver.c"
		GeeHashMap* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		GeeHashSet* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp19_ = elimination_fillables;
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, (gpointer) ((gintptr) 0));
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp21_ = (GeeHashSet*) _tmp20_;
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp23_ = _tmp22_;
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->instant_elimination_fillable = (gfloat) _tmp23_;
#line 793 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp21_);
#line 6829 "sudoku-solver.c"
	} else {
#line 795 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		self->priv->instant_elimination_fillable = 0.0f;
#line 6833 "sudoku-solver.c"
	}
#line 797 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp24_ = self->priv->instant_elimination_fillable;
#line 797 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp25_ = squares_filled;
#line 797 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->proportion_instant_elimination_fillable = _tmp24_ / _tmp25_;
#line 799 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp26_ = self->priv->instant_fill_fillable;
#line 799 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp27_ = squares_filled;
#line 799 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->proportion_instant_fill_fillable = _tmp26_ / _tmp27_;
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp28_ = elimination_fillables;
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp30_ = difficulty_rating_count_values (self, _tmp28_, &_tmp29_);
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = _tmp30_;
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31__length1 = _tmp29_;
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp32_ = difficulty_rating_add_with_diminishing_importance (_tmp31_, _tmp29_, _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by, NULL);
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->elimination_ease = _tmp32_;
#line 800 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = (g_free (_tmp31_), NULL);
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp33_ = fill_must_fillables;
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp35_ = difficulty_rating_count_values (self, _tmp33_, &_tmp34_);
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36_ = _tmp35_;
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36__length1 = _tmp34_;
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp37_ = difficulty_rating_add_with_diminishing_importance (_tmp36_, _tmp34_, _difficulty_rating_diminsh_by_one_difficulty_rating_diminsh_by, NULL);
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv->fillable_ease = _tmp37_;
#line 801 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36_ = (g_free (_tmp36_), NULL);
#line 802 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp38_ = difficulty_rating_calculate (self);
#line 802 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->rating = _tmp38_;
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return self;
#line 6881 "sudoku-solver.c"
}


DifficultyRating* difficulty_rating_new (GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled) {
#line 778 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return difficulty_rating_construct (TYPE_DIFFICULTY_RATING, fill_must_fillables, elimination_fillables, guesses, backtraces, squares_filled);
#line 6888 "sudoku-solver.c"
}


static gint* difficulty_rating_count_values (DifficultyRating* self, GeeHashMap* map, int* result_length1) {
	gint* result = NULL;
	GeeTreeMap* sortedMap = NULL;
	GeeTreeMap* _tmp0_ = NULL;
	gint* array = NULL;
	GeeHashMap* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint* _tmp20_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint p = 0;
	gint* _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
#line 805 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 805 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (map != NULL, NULL);
#line 806 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = gee_tree_map_new (G_TYPE_INT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 806 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sortedMap = _tmp0_;
#line 6914 "sudoku-solver.c"
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = map;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp3_ = _tmp2_;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = _tmp3_;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp6_ = _tmp5_;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp4_);
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_key_it = _tmp6_;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 6941 "sudoku-solver.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gint key = 0;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			GeeTreeMap* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			GeeHashMap* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			GeeHashSet* _tmp16_ = NULL;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp7_ = _key_it;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp8_) {
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 6961 "sudoku-solver.c"
			}
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp9_ = _key_it;
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			key = (gint) ((gintptr) _tmp10_);
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp11_ = sortedMap;
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp12_ = key;
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp13_ = map;
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp14_ = key;
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((gintptr) _tmp14_));
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp16_ = (GeeHashSet*) _tmp15_;
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) _tmp12_), _tmp16_);
#line 808 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp16_);
#line 6985 "sudoku-solver.c"
		}
#line 807 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_key_it);
#line 6989 "sudoku-solver.c"
	}
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp17_ = map;
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp18_ = gee_abstract_map_get_size ((GeeMap*) _tmp17_);
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp19_ = _tmp18_;
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp20_ = g_new0 (gint, _tmp19_);
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	array = _tmp20_;
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	array_length1 = _tmp19_;
#line 810 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_array_size_ = array_length1;
#line 811 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	p = 0;
#line 7007 "sudoku-solver.c"
	{
		GeeIterator* _i_it = NULL;
		GeeTreeMap* _tmp21_ = NULL;
		GeeSet* _tmp22_ = NULL;
		GeeSet* _tmp23_ = NULL;
		GeeSet* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp21_ = sortedMap;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp22_ = gee_abstract_map_get_keys ((GeeMap*) _tmp21_);
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp23_ = _tmp22_;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp24_ = _tmp23_;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp26_ = _tmp25_;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_tmp24_);
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_i_it = _tmp26_;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		while (TRUE) {
#line 7034 "sudoku-solver.c"
			GeeIterator* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			gint i = 0;
			GeeIterator* _tmp29_ = NULL;
			gpointer _tmp30_ = NULL;
			gint* _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp32_ = 0;
			GeeTreeMap* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			GeeHashSet* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp27_ = _i_it;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp28_ = gee_iterator_next (_tmp27_);
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (!_tmp28_) {
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				break;
#line 7059 "sudoku-solver.c"
			}
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp29_ = _i_it;
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp30_ = gee_iterator_get (_tmp29_);
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			i = (gint) ((gintptr) _tmp30_);
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31_ = array;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31__length1 = array_length1;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp32_ = p;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp33_ = sortedMap;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp34_ = i;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, (gpointer) ((gintptr) _tmp34_));
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp36_ = (GeeHashSet*) _tmp35_;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp38_ = _tmp37_;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp31_[_tmp32_] = _tmp38_;
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp39_ = _tmp31_[_tmp32_];
#line 813 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_g_object_unref0 (_tmp36_);
#line 814 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp40_ = p;
#line 814 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			p = _tmp40_ + 1;
#line 7095 "sudoku-solver.c"
		}
#line 812 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_g_object_unref0 (_i_it);
#line 7099 "sudoku-solver.c"
	}
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp41_ = array;
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp41__length1 = array_length1;
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (result_length1) {
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		*result_length1 = _tmp41__length1;
#line 7109 "sudoku-solver.c"
	}
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp41_;
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (sortedMap);
#line 816 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7117 "sudoku-solver.c"
}


static gfloat difficulty_rating_calculate (DifficultyRating* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gint _tmp1_ = 0;
	gfloat _tmp2_ = 0.0F;
	gint _tmp3_ = 0;
	GuessList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 819 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = self->priv->fillable_ease;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = self->priv->squares_filled;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = self->priv->elimination_ease;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = self->priv->squares_filled;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = self->priv->guesses;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = _tmp5_;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = self->priv->squares_filled;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = self->priv->backtraces;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = self->priv->squares_filled;
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = (((1 - (((gfloat) _tmp0_) / _tmp1_)) - (((gfloat) _tmp2_) / _tmp3_)) + (_tmp6_ / _tmp7_)) + (_tmp8_ / _tmp9_);
#line 820 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7159 "sudoku-solver.c"
}


static gint difficulty_rating_diminsh_by_one (gint a) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 826 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = a;
#line 826 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_ + 1;
#line 826 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7172 "sudoku-solver.c"
}


gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_ = 0.0F;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gfloat _tmp3_ = 0.0F;
#line 829 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = self->rating;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = range;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2__length1 = range_length1;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = _tmp2_[0];
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp1_ >= _tmp3_) {
#line 7195 "sudoku-solver.c"
		gfloat _tmp4_ = 0.0F;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp4_ = self->rating;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5_ = range;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp5__length1 = range_length1;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp6_ = _tmp5_[1];
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 7210 "sudoku-solver.c"
	} else {
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp0_ = FALSE;
#line 7214 "sudoku-solver.c"
	}
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _tmp0_;
#line 830 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7220 "sudoku-solver.c"
}


DifficultyCategory difficulty_rating_get_category (DifficultyRating* self) {
	DifficultyCategory result = 0;
	gboolean _tmp0_ = FALSE;
#line 833 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 835 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_EASY_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_EASY_RANGE));
#line 835 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	if (_tmp0_) {
#line 836 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		result = DIFFICULTY_CATEGORY_EASY;
#line 836 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		return result;
#line 7237 "sudoku-solver.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 837 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		_tmp1_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_MEDIUM_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_MEDIUM_RANGE));
#line 837 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		if (_tmp1_) {
#line 838 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			result = DIFFICULTY_CATEGORY_MEDIUM;
#line 838 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			return result;
#line 7248 "sudoku-solver.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 839 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp2_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_HARD_RANGE));
#line 839 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			if (_tmp2_) {
#line 840 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				result = DIFFICULTY_CATEGORY_HARD;
#line 840 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				return result;
#line 7259 "sudoku-solver.c"
			} else {
				gboolean _tmp3_ = FALSE;
#line 841 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3_ = difficulty_rating_in_range (self, DIFFICULTY_RATING_VERY_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_VERY_HARD_RANGE));
#line 841 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (_tmp3_) {
#line 842 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					result = DIFFICULTY_CATEGORY_VERY_HARD;
#line 842 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					return result;
#line 7270 "sudoku-solver.c"
				} else {
#line 844 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					g_assert_not_reached ();
#line 7274 "sudoku-solver.c"
				}
			}
		}
	}
}


static gfloat difficulty_rating_add_with_diminishing_importance (gint* array, int array_length1, DifficultyRatingDiminshBy diminish_by, void* diminish_by_target) {
	gfloat result = 0.0F;
	gfloat sum = 0.0F;
#line 848 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	sum = (gfloat) 0;
#line 7287 "sudoku-solver.c"
	{
		gint i = 0;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
		i = 0;
#line 7292 "sudoku-solver.c"
		{
			gboolean _tmp0_ = FALSE;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			_tmp0_ = TRUE;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
			while (TRUE) {
#line 7299 "sudoku-solver.c"
				gint _tmp2_ = 0;
				gint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gfloat _tmp4_ = 0.0F;
				gint* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				DifficultyRatingDiminshBy _tmp8_ = NULL;
				void* _tmp8__target = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!_tmp0_) {
#line 7314 "sudoku-solver.c"
					gint _tmp1_ = 0;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					_tmp1_ = i;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					i = _tmp1_ + 1;
#line 7320 "sudoku-solver.c"
				}
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp0_ = FALSE;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp2_ = i;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3_ = array;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp3__length1 = array_length1;
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				if (!(_tmp2_ < _tmp3__length1)) {
#line 849 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
					break;
#line 7334 "sudoku-solver.c"
				}
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp4_ = sum;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5_ = array;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp5__length1 = array_length1;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp6_ = i;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp8_ = diminish_by;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp8__target = diminish_by_target;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp9_ = i;
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				_tmp10_ = _tmp8_ (_tmp9_, _tmp8__target);
#line 851 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
				sum = _tmp4_ + (((gfloat) _tmp7_) / _tmp10_);
#line 7356 "sudoku-solver.c"
			}
		}
	}
#line 853 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = sum;
#line 853 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7364 "sudoku-solver.c"
}


gchar* difficulty_rating_to_string (DifficultyRating* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gfloat _tmp3_ = 0.0F;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GuessList* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gfloat _tmp41_ = 0.0F;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gfloat _tmp47_ = 0.0F;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gfloat _tmp53_ = 0.0F;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
#line 856 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 857 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp0_ = g_strdup ("");
#line 857 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp0_;
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp1_ = _result_;
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp2_ = _ ("Number of moves instantly fillable by elimination:");
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp3_ = self->priv->instant_elimination_fillable;
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp4_ = g_strdup_printf ("%s %f\n", _tmp2_, (gdouble) _tmp3_);
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp5_ = _tmp4_;
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp6_;
#line 859 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp5_);
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp7_ = _result_;
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp8_ = _ ("Percentage of moves instantly fillable by elimination:");
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp9_ = self->priv->proportion_instant_elimination_fillable;
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp10_ = g_strdup_printf ("%s %f\n", _tmp8_, (gdouble) (_tmp9_ * 100));
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp11_ = _tmp10_;
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp12_;
#line 861 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp11_);
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp13_ = _result_;
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp14_ = _ ("Number of moves instantly fillable by filling:");
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp15_ = self->priv->instant_fill_fillable;
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp16_ = g_strdup_printf ("%s %f\n", _tmp14_, (gdouble) _tmp15_);
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp17_ = _tmp16_;
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp18_;
#line 863 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp17_);
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp19_ = _result_;
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp20_ = _ ("Percentage of moves instantly fillable by filling:");
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp21_ = self->priv->proportion_instant_fill_fillable;
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp22_ = g_strdup_printf ("%s %f\n", _tmp20_, (gdouble) (_tmp21_ * 100));
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp23_ = _tmp22_;
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp24_;
#line 865 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp23_);
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp25_ = _result_;
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp26_ = _ ("Number of guesses made:");
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp27_ = self->priv->guesses;
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp27_);
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp29_ = _tmp28_;
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp30_ = g_strdup_printf ("%s %d\n", _tmp26_, _tmp29_);
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp31_ = _tmp30_;
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp32_ = g_strconcat (_tmp25_, _tmp31_, NULL);
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp32_;
#line 867 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp31_);
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp33_ = _result_;
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp34_ = _ ("Number of backtraces:");
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp35_ = self->priv->backtraces;
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp36_ = g_strdup_printf ("%s %d\n", _tmp34_, _tmp35_);
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp37_ = _tmp36_;
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp38_ = g_strconcat (_tmp33_, _tmp37_, NULL);
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp38_;
#line 869 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp37_);
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp39_ = _result_;
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp40_ = _ ("Ease by filling:");
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp41_ = self->priv->fillable_ease;
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp42_ = g_strdup_printf ("%s %f\n", _tmp40_, (gdouble) _tmp41_);
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp43_ = _tmp42_;
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp44_ = g_strconcat (_tmp39_, _tmp43_, NULL);
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp44_;
#line 871 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp43_);
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp45_ = _result_;
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp46_ = _ ("Ease by elimination:");
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp47_ = self->priv->elimination_ease;
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp48_ = g_strdup_printf ("%s %f\n", _tmp46_, (gdouble) _tmp47_);
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp49_ = _tmp48_;
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp50_ = g_strconcat (_tmp45_, _tmp49_, NULL);
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp50_;
#line 873 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp49_);
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp51_ = _result_;
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp52_ = _ ("Calculated difficulty:");
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp53_ = self->rating;
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp54_ = g_strdup_printf ("%s %f", _tmp52_, (gdouble) _tmp53_);
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp55_ = _tmp54_;
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_tmp56_ = g_strconcat (_tmp51_, _tmp55_, NULL);
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_result_);
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_result_ = _tmp56_;
#line 875 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_free0 (_tmp55_);
#line 876 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	result = _result_;
#line 876 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	return result;
#line 7604 "sudoku-solver.c"
}


static void difficulty_rating_class_init (DifficultyRatingClass * klass) {
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	difficulty_rating_parent_class = g_type_class_peek_parent (klass);
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	g_type_class_add_private (klass, sizeof (DifficultyRatingPrivate));
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (klass)->finalize = difficulty_rating_finalize;
#line 7615 "sudoku-solver.c"
}


static void difficulty_rating_instance_init (DifficultyRating * self) {
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self->priv = DIFFICULTY_RATING_GET_PRIVATE (self);
#line 7622 "sudoku-solver.c"
}


static void difficulty_rating_finalize (GObject* obj) {
	DifficultyRating * self;
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIFFICULTY_RATING, DifficultyRating);
#line 762 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->fill_must_fillables);
#line 763 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->elimination_fillables);
#line 764 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	_g_object_unref0 (self->priv->guesses);
#line 755 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-solver.vala"
	G_OBJECT_CLASS (difficulty_rating_parent_class)->finalize (obj);
#line 7638 "sudoku-solver.c"
}


GType difficulty_rating_get_type (void) {
	static volatile gsize difficulty_rating_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_rating_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DifficultyRatingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) difficulty_rating_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DifficultyRating), 0, (GInstanceInitFunc) difficulty_rating_instance_init, NULL };
		GType difficulty_rating_type_id;
		difficulty_rating_type_id = g_type_register_static (G_TYPE_OBJECT, "DifficultyRating", &g_define_type_info, 0);
		g_once_init_leave (&difficulty_rating_type_id__volatile, difficulty_rating_type_id);
	}
	return difficulty_rating_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



