/* sudoku-store.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-store.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SUDOKU_STORE (sudoku_store_get_type ())
#define SUDOKU_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_STORE, SudokuStore))
#define SUDOKU_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_STORE, SudokuStoreClass))
#define IS_SUDOKU_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_STORE))
#define IS_SUDOKU_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_STORE))
#define SUDOKU_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_STORE, SudokuStoreClass))

typedef struct _SudokuStore SudokuStore;
typedef struct _SudokuStoreClass SudokuStoreClass;
typedef struct _SudokuStorePrivate SudokuStorePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sudoku_board_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_board_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _ParamSpecSudokuStore ParamSpecSudokuStore;

struct _SudokuStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuStorePrivate * priv;
};

struct _SudokuStoreClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuStore *self);
};

struct _SudokuStorePrivate {
	GeeArrayList* easy_boards;
	GeeArrayList* medium_boards;
	GeeArrayList* hard_boards;
	GeeArrayList* very_hard_boards;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _ParamSpecSudokuStore {
	GParamSpec parent_instance;
};


static gpointer sudoku_store_parent_class = NULL;

gpointer sudoku_store_ref (gpointer instance);
void sudoku_store_unref (gpointer instance);
GParamSpec* param_spec_sudoku_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_store (GValue* value, gpointer v_object);
void value_take_sudoku_store (GValue* value, gpointer v_object);
gpointer value_get_sudoku_store (const GValue* value);
GType sudoku_store_get_type (void) G_GNUC_CONST;
gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
#define SUDOKU_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_STORE, SudokuStorePrivate))
enum  {
	SUDOKU_STORE_DUMMY_PROPERTY
};
SudokuStore* sudoku_store_new (void);
SudokuStore* sudoku_store_construct (GType object_type);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter);
SudokuBoard* sudoku_store_get_random_easy_board (SudokuStore* self);
SudokuBoard* sudoku_store_get_random_medium_board (SudokuStore* self);
SudokuBoard* sudoku_store_get_random_hard_board (SudokuStore* self);
SudokuBoard* sudoku_store_get_random_very_hard_board (SudokuStore* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
SudokuBoard* sudoku_store_get_random_board (SudokuStore* self, DifficultyCategory category);
SudokuBoard** sudoku_store_get_boards_sorted (SudokuStore* self, gint number_of_boards, DifficultyCategory level, gboolean exclude_finished, int* result_length1);
gboolean sudoku_board_is_finished (SudokuBoard* self);
static gint __lambda13_ (SudokuStore* self, SudokuBoard* a, SudokuBoard* b);
gdouble sudoku_board_get_difficulty_rating (SudokuBoard* self);
static gint ___lambda13__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void _vala_array_add5 (SudokuBoard*** array, int* length, int* size, SudokuBoard* value);
static void sudoku_store_finalize (SudokuStore* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


SudokuStore* sudoku_store_construct (GType object_type) {
	SudokuStore* self = NULL;
	GError * _inner_error_ = NULL;
	self = (SudokuStore*) g_type_create_instance (object_type);
	{
		{
			GFile* file = NULL;
			GFile* _tmp0_ = NULL;
			GFileInputStream* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GFileInputStream* _tmp3_ = NULL;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp4_ = NULL;
			gchar* line = NULL;
			_tmp0_ = g_file_new_for_uri ("resource:///org/gnome/gnome-sudoku/puzzles/easy");
			file = _tmp0_;
			_tmp2_ = file;
			_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch2_g_error;
			}
			_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
			dis = _tmp4_;
			while (TRUE) {
				gchar* _tmp5_ = NULL;
				GDataInputStream* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				SudokuBoard* board = NULL;
				SudokuBoard* _tmp10_ = NULL;
				SudokuBoard* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GeeArrayList* _tmp13_ = NULL;
				SudokuBoard* _tmp14_ = NULL;
				_tmp6_ = dis;
				_tmp7_ = g_data_input_stream_read_line (_tmp6_, NULL, NULL, &_inner_error_);
				_tmp5_ = _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp1_);
					_g_object_unref0 (file);
					goto __catch2_g_error;
				}
				_tmp8_ = _tmp5_;
				_tmp5_ = NULL;
				_g_free0 (line);
				line = _tmp8_;
				_tmp9_ = line;
				if (!(_tmp9_ != NULL)) {
					_g_free0 (_tmp5_);
					break;
				}
				_tmp10_ = sudoku_board_new (3, 3);
				board = _tmp10_;
				_tmp11_ = board;
				_tmp12_ = line;
				sudoku_board_set_from_string (_tmp11_, _tmp12_, " ", "0", "\t");
				_tmp13_ = self->priv->easy_boards;
				_tmp14_ = board;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				_sudoku_board_unref0 (board);
				_g_free0 (_tmp5_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (file);
		}
		{
			GFile* file = NULL;
			GFile* _tmp15_ = NULL;
			GFileInputStream* _tmp16_ = NULL;
			GFile* _tmp17_ = NULL;
			GFileInputStream* _tmp18_ = NULL;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp19_ = NULL;
			gchar* line = NULL;
			_tmp15_ = g_file_new_for_uri ("resource:///org/gnome/gnome-sudoku/puzzles/medium");
			file = _tmp15_;
			_tmp17_ = file;
			_tmp18_ = g_file_read (_tmp17_, NULL, &_inner_error_);
			_tmp16_ = _tmp18_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch2_g_error;
			}
			_tmp19_ = g_data_input_stream_new ((GInputStream*) _tmp16_);
			dis = _tmp19_;
			while (TRUE) {
				gchar* _tmp20_ = NULL;
				GDataInputStream* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				SudokuBoard* board = NULL;
				SudokuBoard* _tmp25_ = NULL;
				SudokuBoard* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				_tmp21_ = dis;
				_tmp22_ = g_data_input_stream_read_line (_tmp21_, NULL, NULL, &_inner_error_);
				_tmp20_ = _tmp22_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp16_);
					_g_object_unref0 (file);
					goto __catch2_g_error;
				}
				_tmp23_ = _tmp20_;
				_tmp20_ = NULL;
				_g_free0 (line);
				line = _tmp23_;
				_tmp24_ = line;
				if (!(_tmp24_ != NULL)) {
					_g_free0 (_tmp20_);
					break;
				}
				_tmp25_ = sudoku_board_new (3, 3);
				board = _tmp25_;
				_tmp26_ = board;
				_tmp27_ = line;
				sudoku_board_set_from_string (_tmp26_, _tmp27_, " ", "0", "\t");
				_tmp28_ = self->priv->medium_boards;
				_tmp29_ = board;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
				_sudoku_board_unref0 (board);
				_g_free0 (_tmp20_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp16_);
			_g_object_unref0 (file);
		}
		{
			GFile* file = NULL;
			GFile* _tmp30_ = NULL;
			GFileInputStream* _tmp31_ = NULL;
			GFile* _tmp32_ = NULL;
			GFileInputStream* _tmp33_ = NULL;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp34_ = NULL;
			gchar* line = NULL;
			_tmp30_ = g_file_new_for_uri ("resource:///org/gnome/gnome-sudoku/puzzles/hard");
			file = _tmp30_;
			_tmp32_ = file;
			_tmp33_ = g_file_read (_tmp32_, NULL, &_inner_error_);
			_tmp31_ = _tmp33_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch2_g_error;
			}
			_tmp34_ = g_data_input_stream_new ((GInputStream*) _tmp31_);
			dis = _tmp34_;
			while (TRUE) {
				gchar* _tmp35_ = NULL;
				GDataInputStream* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				SudokuBoard* board = NULL;
				SudokuBoard* _tmp40_ = NULL;
				SudokuBoard* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				GeeArrayList* _tmp43_ = NULL;
				SudokuBoard* _tmp44_ = NULL;
				_tmp36_ = dis;
				_tmp37_ = g_data_input_stream_read_line (_tmp36_, NULL, NULL, &_inner_error_);
				_tmp35_ = _tmp37_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp31_);
					_g_object_unref0 (file);
					goto __catch2_g_error;
				}
				_tmp38_ = _tmp35_;
				_tmp35_ = NULL;
				_g_free0 (line);
				line = _tmp38_;
				_tmp39_ = line;
				if (!(_tmp39_ != NULL)) {
					_g_free0 (_tmp35_);
					break;
				}
				_tmp40_ = sudoku_board_new (3, 3);
				board = _tmp40_;
				_tmp41_ = board;
				_tmp42_ = line;
				sudoku_board_set_from_string (_tmp41_, _tmp42_, " ", "0", "\t");
				_tmp43_ = self->priv->hard_boards;
				_tmp44_ = board;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
				_sudoku_board_unref0 (board);
				_g_free0 (_tmp35_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp31_);
			_g_object_unref0 (file);
		}
		{
			GFile* file = NULL;
			GFile* _tmp45_ = NULL;
			GFileInputStream* _tmp46_ = NULL;
			GFile* _tmp47_ = NULL;
			GFileInputStream* _tmp48_ = NULL;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp49_ = NULL;
			gchar* line = NULL;
			_tmp45_ = g_file_new_for_uri ("resource:///org/gnome/gnome-sudoku/puzzles/very_hard");
			file = _tmp45_;
			_tmp47_ = file;
			_tmp48_ = g_file_read (_tmp47_, NULL, &_inner_error_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch2_g_error;
			}
			_tmp49_ = g_data_input_stream_new ((GInputStream*) _tmp46_);
			dis = _tmp49_;
			while (TRUE) {
				gchar* _tmp50_ = NULL;
				GDataInputStream* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				SudokuBoard* board = NULL;
				SudokuBoard* _tmp55_ = NULL;
				SudokuBoard* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				GeeArrayList* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				_tmp51_ = dis;
				_tmp52_ = g_data_input_stream_read_line (_tmp51_, NULL, NULL, &_inner_error_);
				_tmp50_ = _tmp52_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp46_);
					_g_object_unref0 (file);
					goto __catch2_g_error;
				}
				_tmp53_ = _tmp50_;
				_tmp50_ = NULL;
				_g_free0 (line);
				line = _tmp53_;
				_tmp54_ = line;
				if (!(_tmp54_ != NULL)) {
					_g_free0 (_tmp50_);
					break;
				}
				_tmp55_ = sudoku_board_new (3, 3);
				board = _tmp55_;
				_tmp56_ = board;
				_tmp57_ = line;
				sudoku_board_set_from_string (_tmp56_, _tmp57_, " ", "0", "\t");
				_tmp58_ = self->priv->very_hard_boards;
				_tmp59_ = board;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp59_);
				_sudoku_board_unref0 (board);
				_g_free0 (_tmp50_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp46_);
			_g_object_unref0 (file);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp60_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp60_ = e->message;
		g_error ("sudoku-store.vala:74: %s", _tmp60_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SudokuStore* sudoku_store_new (void) {
	return sudoku_store_construct (TYPE_SUDOKU_STORE);
}


SudokuBoard* sudoku_store_get_random_easy_board (SudokuStore* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint32 _tmp4_ = 0;
	gpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->easy_boards;
	_tmp1_ = self->priv->easy_boards;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) _tmp4_);
	result = (SudokuBoard*) _tmp5_;
	return result;
}


SudokuBoard* sudoku_store_get_random_medium_board (SudokuStore* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint32 _tmp4_ = 0;
	gpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->medium_boards;
	_tmp1_ = self->priv->medium_boards;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) _tmp4_);
	result = (SudokuBoard*) _tmp5_;
	return result;
}


SudokuBoard* sudoku_store_get_random_hard_board (SudokuStore* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint32 _tmp4_ = 0;
	gpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->hard_boards;
	_tmp1_ = self->priv->hard_boards;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) _tmp4_);
	result = (SudokuBoard*) _tmp5_;
	return result;
}


SudokuBoard* sudoku_store_get_random_very_hard_board (SudokuStore* self) {
	SudokuBoard* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint32 _tmp4_ = 0;
	gpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->very_hard_boards;
	_tmp1_ = self->priv->very_hard_boards;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) _tmp4_);
	result = (SudokuBoard*) _tmp5_;
	return result;
}


SudokuBoard* sudoku_store_get_random_board (SudokuStore* self, DifficultyCategory category) {
	SudokuBoard* result = NULL;
	DifficultyCategory _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = category;
	if (_tmp0_ == DIFFICULTY_CATEGORY_EASY) {
		SudokuBoard* _tmp1_ = NULL;
		_tmp1_ = sudoku_store_get_random_easy_board (self);
		result = _tmp1_;
		return result;
	} else {
		DifficultyCategory _tmp2_ = 0;
		_tmp2_ = category;
		if (_tmp2_ == DIFFICULTY_CATEGORY_MEDIUM) {
			SudokuBoard* _tmp3_ = NULL;
			_tmp3_ = sudoku_store_get_random_medium_board (self);
			result = _tmp3_;
			return result;
		} else {
			DifficultyCategory _tmp4_ = 0;
			_tmp4_ = category;
			if (_tmp4_ == DIFFICULTY_CATEGORY_HARD) {
				SudokuBoard* _tmp5_ = NULL;
				_tmp5_ = sudoku_store_get_random_hard_board (self);
				result = _tmp5_;
				return result;
			} else {
				DifficultyCategory _tmp6_ = 0;
				_tmp6_ = category;
				if (_tmp6_ == DIFFICULTY_CATEGORY_VERY_HARD) {
					SudokuBoard* _tmp7_ = NULL;
					_tmp7_ = sudoku_store_get_random_very_hard_board (self);
					result = _tmp7_;
					return result;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
}


static gint __lambda13_ (SudokuStore* self, SudokuBoard* a, SudokuBoard* b) {
	gint result = 0;
	SudokuBoard* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	SudokuBoard* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	SudokuBoard* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	SudokuBoard* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = sudoku_board_get_difficulty_rating (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = sudoku_board_get_difficulty_rating (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		result = 1;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = sudoku_board_get_difficulty_rating (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = b;
	_tmp10_ = sudoku_board_get_difficulty_rating (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ == _tmp11_) {
		result = 0;
		return result;
	}
	result = -1;
	return result;
}


static gint ___lambda13__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda13_ ((SudokuStore*) self, (SudokuBoard*) a, (SudokuBoard*) b);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _sudoku_board_ref0 (gpointer self) {
	return self ? sudoku_board_ref (self) : NULL;
}


static void _vala_array_add5 (SudokuBoard*** array, int* length, int* size, SudokuBoard* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SudokuBoard*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


SudokuBoard** sudoku_store_get_boards_sorted (SudokuStore* self, gint number_of_boards, DifficultyCategory level, gboolean exclude_finished, int* result_length1) {
	SudokuBoard** result = NULL;
	GeeArrayList* boards = NULL;
	GeeArrayList* _tmp0_ = NULL;
	SudokuBoard** sorted_boards = NULL;
	SudokuBoard** _tmp1_ = NULL;
	gint sorted_boards_length1 = 0;
	gint _sorted_boards_size_ = 0;
	GeeArrayList* _tmp14_ = NULL;
	SudokuBoard** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) sudoku_board_ref, sudoku_board_unref, NULL, NULL, NULL);
	boards = _tmp0_;
	_tmp1_ = g_new0 (SudokuBoard*, 0 + 1);
	sorted_boards = _tmp1_;
	sorted_boards_length1 = 0;
	_sorted_boards_size_ = sorted_boards_length1;
	while (TRUE) {
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		SudokuBoard* board = NULL;
		DifficultyCategory _tmp6_ = 0;
		SudokuBoard* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		GeeArrayList* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		_tmp2_ = boards;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = number_of_boards;
		if (!(_tmp4_ < _tmp5_)) {
			break;
		}
		_tmp6_ = level;
		_tmp7_ = sudoku_store_get_random_board (self, _tmp6_);
		board = _tmp7_;
		_tmp9_ = exclude_finished;
		if (_tmp9_) {
			SudokuBoard* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = board;
			_tmp11_ = sudoku_board_is_finished (_tmp10_);
			_tmp8_ = _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_sudoku_board_unref0 (board);
			continue;
		}
		_tmp12_ = boards;
		_tmp13_ = board;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		_sudoku_board_unref0 (board);
	}
	_tmp14_ = boards;
	gee_list_sort ((GeeList*) _tmp14_, ___lambda13__gcompare_data_func, sudoku_store_ref (self), sudoku_store_unref);
	{
		GeeArrayList* _board_list = NULL;
		GeeArrayList* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		gint _board_size = 0;
		GeeArrayList* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _board_index = 0;
		_tmp15_ = boards;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_board_list = _tmp16_;
		_tmp17_ = _board_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_board_size = _tmp19_;
		_board_index = -1;
		while (TRUE) {
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			SudokuBoard* board = NULL;
			GeeArrayList* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gpointer _tmp25_ = NULL;
			SudokuBoard** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			SudokuBoard* _tmp27_ = NULL;
			SudokuBoard* _tmp28_ = NULL;
			_tmp20_ = _board_index;
			_board_index = _tmp20_ + 1;
			_tmp21_ = _board_index;
			_tmp22_ = _board_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _board_list;
			_tmp24_ = _board_index;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
			board = (SudokuBoard*) _tmp25_;
			_tmp26_ = sorted_boards;
			_tmp26__length1 = sorted_boards_length1;
			_tmp27_ = board;
			_tmp28_ = _sudoku_board_ref0 (_tmp27_);
			_vala_array_add5 (&sorted_boards, &sorted_boards_length1, &_sorted_boards_size_, _tmp28_);
			_sudoku_board_unref0 (board);
		}
		_g_object_unref0 (_board_list);
	}
	_tmp29_ = sorted_boards;
	_tmp29__length1 = sorted_boards_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	_g_object_unref0 (boards);
	return result;
}


static void value_sudoku_store_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_sudoku_store_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_store_unref (value->data[0].v_pointer);
	}
}


static void value_sudoku_store_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_store_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_sudoku_store_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_sudoku_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuStore* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_store_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_sudoku_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuStore** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_store_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_sudoku_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSudokuStore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SUDOKU_STORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_sudoku_store (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_STORE), NULL);
	return value->data[0].v_pointer;
}


void value_set_sudoku_store (GValue* value, gpointer v_object) {
	SudokuStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_store_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_store_unref (old);
	}
}


void value_take_sudoku_store (GValue* value, gpointer v_object) {
	SudokuStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_store_unref (old);
	}
}


static void sudoku_store_class_init (SudokuStoreClass * klass) {
	sudoku_store_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_STORE_CLASS (klass)->finalize = sudoku_store_finalize;
	g_type_class_add_private (klass, sizeof (SudokuStorePrivate));
}


static void sudoku_store_instance_init (SudokuStore * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	self->priv = SUDOKU_STORE_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) sudoku_board_ref, sudoku_board_unref, NULL, NULL, NULL);
	self->priv->easy_boards = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) sudoku_board_ref, sudoku_board_unref, NULL, NULL, NULL);
	self->priv->medium_boards = _tmp1_;
	_tmp2_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) sudoku_board_ref, sudoku_board_unref, NULL, NULL, NULL);
	self->priv->hard_boards = _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) sudoku_board_ref, sudoku_board_unref, NULL, NULL, NULL);
	self->priv->very_hard_boards = _tmp3_;
	self->ref_count = 1;
}


static void sudoku_store_finalize (SudokuStore* obj) {
	SudokuStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_STORE, SudokuStore);
	_g_object_unref0 (self->priv->easy_boards);
	_g_object_unref0 (self->priv->medium_boards);
	_g_object_unref0 (self->priv->hard_boards);
	_g_object_unref0 (self->priv->very_hard_boards);
}


GType sudoku_store_get_type (void) {
	static volatile gsize sudoku_store_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_sudoku_store_init, value_sudoku_store_free_value, value_sudoku_store_copy_value, value_sudoku_store_peek_pointer, "p", value_sudoku_store_collect_value, "p", value_sudoku_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuStore), 0, (GInstanceInitFunc) sudoku_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_store_type_id;
		sudoku_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_store_type_id__volatile, sudoku_store_type_id);
	}
	return sudoku_store_type_id__volatile;
}


gpointer sudoku_store_ref (gpointer instance) {
	SudokuStore* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_store_unref (gpointer instance) {
	SudokuStore* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_STORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



