/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*  This file is part of gnome-spell bonobo component

    Copyright (C) 1999, 2000 Helix Code, Inc.
    Authors:                 Radek Doulik <rodo@helixcode.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

 */

#include <config.h>
#include <gnome.h>
#include <bonobo.h>
#include <glade/glade.h>
#include "Spell.h"
#include "dictionary.h"
#include "control.h"

CORBA_Environment ev;
CORBA_ORB orb;

static BonoboGenericFactory *dictionary_factory;
static BonoboGenericFactory    *control_factory;

static BonoboObject *
new_object (BonoboGenericFactory *factory, const char *component_id, gpointer closure)
{
	if (factory == dictionary_factory)
		return gnome_spell_dictionary_new ();
	else if (factory == control_factory) {
		return gnome_spell_control_new ();
	} else
		return NULL;
}

static gint
factory_main (void)
{
	dictionary_factory = bonobo_generic_factory_new ("OAFIID:GNOME_Spell_DictionaryFactory:" API_VERSION,
							 new_object, NULL);

	if (dictionary_factory) {
		bonobo_running_context_auto_exit_unref (BONOBO_OBJECT (dictionary_factory));
	
		control_factory = bonobo_generic_factory_new ("OAFIID:GNOME_Spell_ControlFactory:" API_VERSION,
							      new_object, NULL);
		if (control_factory) {
			bonobo_running_context_auto_exit_unref (BONOBO_OBJECT (control_factory));
			bonobo_main ();

			return bonobo_debug_shutdown ();
		} else {
			g_error ("It was not possible to register a new spell control factory");
			return 1;
		}
	} else {
		g_error ("It was not possible to register a new dictionary factory");
		return 1;
	}
}

int
main (int argc, char *argv [])
{
	gint rv;

	/* Initialize the i18n support */
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

	CORBA_exception_init (&ev);

        if (!bonobo_ui_init ("gnome-spell-component", VERSION, &argc, argv))
		g_error (_("I could not initialize Bonobo"));

	bonobo_activate ();
	glade_gnome_init ();

	rv = factory_main ();

	CORBA_exception_free (&ev);

	return rv;
}
