/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*  This file is part of gnome-spell bonobo component

    Copyright (C) 1999, 2000 Helix Code, Inc.
    Authors:                 Radek Doulik <rodo@helixcode.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

 */

#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>
#include "Spell.h"
#include "dictionary.h"
#include "checker.h"

CORBA_Environment ev;
CORBA_ORB orb;

static BonoboGenericFactory *dictionary_factory;
static BonoboGenericFactory    *checker_factory;

static int active_dictionary_servers;
static int active_checker_servers;

static void
init_server_factory (int argc, char **argv)
{
        gnome_init_with_popt_table("spell-factory", VERSION,
				   argc, argv,
				   oaf_popt_options, 0, NULL); 
	orb = oaf_init (argc, argv);

	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error (_("I could not initialize Bonobo"));
}

static void
try_quit ()
{
	if (active_checker_servers || active_dictionary_servers)
		return;
	bonobo_object_unref (BONOBO_OBJECT (checker_factory));
	bonobo_object_unref (BONOBO_OBJECT (dictionary_factory));
	gtk_main_quit ();
}

static void
dictionary_destroyed (GtkObject *checker_object)
{
	active_dictionary_servers--;

	try_quit ();
}

static void
checker_destroyed (GtkObject *checker_object)
{
	active_checker_servers--;

	try_quit ();
}

static BonoboObject *
factory_checker_new (BonoboGenericFactory *this_factory, void *data)
{
	GNOMESpellChecker *checker;

	checker = gnome_spell_checker_new ();
	
	if (!checker)
		return NULL;

	active_checker_servers++;

	gtk_signal_connect (
		GTK_OBJECT (checker), "destroy",
		checker_destroyed, NULL);

	return BONOBO_OBJECT (checker);
}

static BonoboObject *
factory_dictionary_new (BonoboGenericFactory *this_factory, void *data)
{
	GNOMESpellDictionary *dictionary;

	dictionary = gnome_spell_dictionary_new ();
	
	if (!dictionary)
		return NULL;

	active_dictionary_servers++;

	gtk_signal_connect (
		GTK_OBJECT (dictionary), "destroy",
		dictionary_destroyed, NULL);

	return BONOBO_OBJECT (dictionary);
}

static void
factory_init (void)
{
	checker_factory = bonobo_generic_factory_new (
		"OAFIID:GNOME_Spell_CheckerFactory:0.1",
		factory_checker_new, NULL);
	dictionary_factory = bonobo_generic_factory_new (
		"OAFIID:GNOME_Spell_DictionaryFactory:0.1",
		factory_dictionary_new, NULL);

	if (!checker_factory)
		g_error ("It was not possible to register a new checker factory");
	if (!dictionary_factory)
		g_error ("It was not possible to register a new dictionary factory");
}

int
main (int argc, char *argv [])
{
	CORBA_exception_init (&ev);

	init_server_factory (argc, argv);
	factory_init ();
	bonobo_activate ();

	gtk_main ();
	CORBA_exception_free (&ev);

	return 0;
}
